/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractNullAnnotationTest;

public class NullTypeAnnotationTest
extends AbstractNullAnnotationTest {
    static /* synthetic */ Class class$0;

    public NullTypeAnnotationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NullTypeAnnotationTest.buildMinimalComplianceTestSuite(NullTypeAnnotationTest.testClass(), 32);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.NullTypeAnnotationTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test_nonnull_list_elements_01() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.List;\npublic class X {\n    void foo(List<@Nullable Object> l) {\n        System.out.print(l.get(0).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n    void bar(java.util.List<@Nullable Object> l) {\n        System.out.print(l.get(1).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(l.get(0).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n2. ERROR in X.java (at line 9)\n\tSystem.out.print(l.get(1).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n");
    }

    public void test_nonnull_list_elements_01a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nullable", "org.foo.Nullable");
        customOptions.put("org.eclipse.jdt.core.compiler.annotation.nonnull", "org.foo.NonNull");
        this.runNegativeTest(new String[]{"org/foo/Nullable.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface Nullable {\n}\n", "org/foo/NonNull.java", "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface NonNull {\n}\n", "X.java", "import org.foo.*;\nimport java.util.List;\npublic class X {\n    void foo(List<@Nullable Object> l) {\n        System.out.print(l.get(0).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n    void bar(java.util.List<@Nullable Object> l) {\n        System.out.print(l.get(1).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(l.get(0).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n2. ERROR in X.java (at line 9)\n\tSystem.out.print(l.get(1).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n", null, true, customOptions);
    }

    public void test_nonnull_list_elements_02() {
        this.runNegativeTestWithLibs(new String[]{"Dummy.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface Dummy {\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.List;\npublic class X {\n    void foo(List<@Dummy @Nullable Object> l) {\n        System.out.print(l.get(0).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n    void bar(java.util.List<@Dummy @Nullable Object> l) {\n        System.out.print(l.get(1).toString()); // problem: retrieved element can be null\n        l.add(null);\n    }\n    void bar2(java.util.List<java.lang.@Dummy @Nullable Object> l2) {\n        System.out.print(l2.get(1).toString()); // problem: retrieved element can be null\n        l2.add(null);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(l.get(0).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n2. ERROR in X.java (at line 9)\n\tSystem.out.print(l.get(1).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n3. ERROR in X.java (at line 13)\n\tSystem.out.print(l2.get(1).toString()); // problem: retrieved element can be null\n\t                 ^^^^^^^^^\nPotential null pointer access: The method get(int) may return null\n----------\n");
    }

    public void test_nonnull_list_elements_03() {
        this.runNegativeTestWithLibs(new String[]{"Dummy.java", "import static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface Dummy {\n}\n", "X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.List;\npublic class X {\n    void foo(@Nullable List<@NonNull Object> l) {\n        System.out.print(l.get(0).toString()); // problem: l may be null\n        l.add(null); // problem: cannot insert 'null' into this list\n    }\n    void bar(@Nullable List<java.lang.@NonNull Object> l) {\n        System.out.print(l.get(0).toString()); // problem: l may be null\n        l.add(0, null); // problem: cannot insert 'null' into this list\n    }\n    void bar2(@Dummy java.util.@Nullable List<java.lang.@NonNull Object> l2) {\n        System.out.print(l2.get(0).toString()); // problem: l2 may be null\n        l2.add(0, null); // problem: cannot insert 'null' into this list\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.print(l.get(0).toString()); // problem: l may be null\n\t                 ^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n2. ERROR in X.java (at line 6)\n\tl.add(null); // problem: cannot insert 'null' into this list\n\t      ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n3. ERROR in X.java (at line 9)\n\tSystem.out.print(l.get(0).toString()); // problem: l may be null\n\t                 ^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n4. ERROR in X.java (at line 10)\n\tl.add(0, null); // problem: cannot insert 'null' into this list\n\t         ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n5. ERROR in X.java (at line 13)\n\tSystem.out.print(l2.get(0).toString()); // problem: l2 may be null\n\t                 ^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n6. ERROR in X.java (at line 14)\n\tl2.add(0, null); // problem: cannot insert 'null' into this list\n\t          ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nestedType_01() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A<X> {\n    public class I<Y> {\n        X anX;\n        public X foo(Y l) {\n            return anX;\n        }\n    }\n    void bar(A<@Nullable Object>.I<@NonNull Object> i) {\n        @NonNull Object o = i.foo(null); // problems: argument and assignment violate null contracts\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 10)\n\t@NonNull Object o = i.foo(null); // problems: argument and assignment violate null contracts\n\t                    ^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable Object'\n----------\n2. ERROR in A.java (at line 10)\n\t@NonNull Object o = i.foo(null); // problems: argument and assignment violate null contracts\n\t                          ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n");
    }

    public void test_nestedType_02() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "public class A<X> {\n    public abstract class I<Y> {\n        public abstract X foo(Y l);\n        public X idX(X in) { return in; }\n        public Y idY(Y in) { return in; }\n    }\n}\n", "B.java", "import org.eclipse.jdt.annotation.*;\npublic class B extends A<@NonNull Object> {\n    public class J extends I<@Nullable String> {\n        @Override\n        public @NonNull Object foo(@Nullable String l) {\n            System.out.print(idX(null));\n            return idY(null);\n        }\n    }\n}\n"}, "----------\n1. ERROR in B.java (at line 6)\n\tSystem.out.print(idX(null));\n\t                     ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n2. ERROR in B.java (at line 7)\n\treturn idY(null);\n\t       ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable String'\n----------\n");
    }

    public void test_nestedType_03() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "public class A<X> {\n    public abstract class I<Y> {\n        public abstract X foo(Y l);\n    }\n}\n", "B.java", "import org.eclipse.jdt.annotation.*;\npublic class B extends A<@NonNull Object> {\n    public class J extends I<@Nullable String> {\n        @Override\n        public @Nullable Object foo(@NonNull String l) {\n            return null;\n        }\n    }\n}\n"}, "----------\n1. ERROR in B.java (at line 5)\n\tpublic @Nullable Object foo(@NonNull String l) {\n\t       ^^^^^^^^^^^^^^^^\nThe return type is incompatible with the @NonNull return from A<Object>.I<String>.foo(String)\n----------\n2. ERROR in B.java (at line 5)\n\tpublic @Nullable Object foo(@NonNull String l) {\n\t                            ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter l, inherited method from A<Object>.I<String> declares this parameter as @Nullable\n----------\n");
    }

    public void test_nestedType_04() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "public class A<X> {\n    public abstract class I<Y> {\n        public abstract X foo(Y l);\n    }\n}\n", "B.java", "import org.eclipse.jdt.annotation.*;\npublic class B {\n    public void foo(A<Object>.@Nullable I<@NonNull String> ai) {\n            ai.foo(null); // problems: ai can be null, arg must not be null\n    }\n}\n"}, "----------\n1. ERROR in B.java (at line 4)\n\tai.foo(null); // problems: ai can be null, arg must not be null\n\t^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n2. ERROR in B.java (at line 4)\n\tai.foo(null); // problems: ai can be null, arg must not be null\n\t       ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void test_nestedType_05() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "public class A<X> {\n    public abstract class I<Y> {\n        public abstract X foo(Y l);\n    }\n}\n", "B.java", "import org.eclipse.jdt.annotation.*;\npublic class B {\n    public void foo(A<@NonNull Object>.@Nullable I<@NonNull String> ai1) {\n\t\tA<@Nullable Object>.@Nullable I<@NonNull String> ai2 = ai1;\n    }\n}\n"}, "----------\n1. ERROR in B.java (at line 4)\n\tA<@Nullable Object>.@Nullable I<@NonNull String> ai2 = ai1;\n\t                                                       ^^^\nNull type mismatch (type annotations): required 'A<@Nullable Object>.@Nullable I<@NonNull String>' but this expression has type 'A<@NonNull Object>.@Nullable I<@NonNull String>'\n----------\n");
    }

    public void testMissingAnnotationTypes_01() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic class U {}\n   @Missing1 X.@Missing2 U fU;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@Missing1 X.@Missing2 U fU;\n\t ^^^^^^^^\nMissing1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\t@Missing1 X.@Missing2 U fU;\n\t             ^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n");
    }

    public void testArrayType_01() {
        this.runNegativeTestWithLibs(new String[]{"Wrapper.java", "public class Wrapper<T> {\n\tT content;\tpublic T content() { return content; }\n}\n", "A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void bar(Wrapper<@NonNull String[]> realStrings, Wrapper<@Nullable String[]> maybeStrings) {\n        System.out.println(realStrings.content()[0].toUpperCase()); // no problem\n        realStrings.content()[0] = null; // problem: cannot assign null as @NonNull element\n        System.out.println(maybeStrings.content()[0].toUpperCase()); // problem: element can be null\n        maybeStrings.content()[0] = null; // no problem\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 5)\n\trealStrings.content()[0] = null; // problem: cannot assign null as @NonNull element\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in A.java (at line 6)\n\tSystem.out.println(maybeStrings.content()[0].toUpperCase()); // problem: element can be null\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n");
    }

    public void testArrayType_02() {
        this.runNegativeTestWithLibs(new String[]{"Wrapper.java", "public class Wrapper<T> {\n\tT content;\tpublic T content() { return content; }\n}\n", "A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void bar(Wrapper<@NonNull String[][]> realStrings, Wrapper<@Nullable String[][]> maybeStrings) {\n        System.out.println(realStrings.content()[0][0].toUpperCase()); // no problem\n        realStrings.content()[0][0] = null; // problem: cannot assign null as @NonNull element\n        System.out.println(maybeStrings.content()[0][0].toUpperCase()); // problem: element can be null\n        maybeStrings.content()[0][0] = null; // no problem\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 5)\n\trealStrings.content()[0][0] = null; // problem: cannot assign null as @NonNull element\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in A.java (at line 6)\n\tSystem.out.println(maybeStrings.content()[0][0].toUpperCase()); // problem: element can be null\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n");
    }

    public void testArrayType_03() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void array(String @NonNull[] realStringArray, String @Nullable[] maybeStringArray) {\n        @NonNull Object array;\n        array = realStringArray;  // no problem\n        realStringArray = null; \t // problem: cannot assign null as @NonNull array\n        array = maybeStringArray; // problem: array can be null\n        maybeStringArray = null;  // no problem\n    }\n    void leaf(String @NonNull[] realStringArray, String @Nullable[] maybeStringArray, boolean b) {\n        @NonNull String string;\n        string = realStringArray[0];  // problem: unchecked conversion\n        realStringArray[0] = null; \t // no problem\n        if (b)\n            string = maybeStringArray[0]; // problems: indexing nullable array & unchecked conversion\n        else\n            maybeStringArray[0] = null; \t // problem: indexing nullable array\n        maybeStringArray[0] = null; \t // problem protected by previous dereference\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 6)\n\trealStringArray = null; \t // problem: cannot assign null as @NonNull array\n\t                  ^^^^\nNull type mismatch: required 'String @NonNull[]' but the provided value is null\n----------\n2. ERROR in A.java (at line 7)\n\tarray = maybeStringArray; // problem: array can be null\n\t        ^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'String @Nullable[]'\n----------\n3. WARNING in A.java (at line 12)\n\tstring = realStringArray[0];  // problem: unchecked conversion\n\t         ^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n4. ERROR in A.java (at line 15)\n\tstring = maybeStringArray[0]; // problems: indexing nullable array & unchecked conversion\n\t         ^^^^^^^^^^^^^^^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n5. WARNING in A.java (at line 15)\n\tstring = maybeStringArray[0]; // problems: indexing nullable array & unchecked conversion\n\t         ^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n6. ERROR in A.java (at line 17)\n\tmaybeStringArray[0] = null; \t // problem: indexing nullable array\n\t^^^^^^^^^^^^^^^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n");
    }

    public void testArrayType_04() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void outer(String [] @NonNull[] realArrays, String [] @Nullable[] maybeArrays) {\n        @NonNull Object array;\n        array = realArrays; \t\t// problem: unchecked conversion\n        realArrays = null; \t\t// no problem, outer array is unspecified\n        array = maybeArrays; \t// problem: unchecked conversion\n        maybeArrays = null; \t\t// no problem\n    }\n    void inner(String [] @NonNull[] realArrays, String [] @Nullable[] maybeArrays) {\n        @NonNull Object array;\n        array = realArrays[0]; \t// no problem\n        realArrays[0] = null; \t// problem: cannot assign null to @NonNull array\n        array = maybeArrays[0]; \t// problem: element can be null\n        maybeArrays[0] = null; \t// no problem\n    }\n    void leaf(String [] @NonNull[] realArrays, String [] @Nullable[] maybeArrays) {\n        @NonNull Object array;\n        array = realArrays[0][0]; // problem: unchecked conversion\n        realArrays[0][0] = null;  // no problem, element type is unspecified\n        array = maybeArrays[0][0]; // problems: indexing nullable array & unchecked conversion\n        maybeArrays[0][0] = null; // problem: indexing nullable array\n    }\n}\n"}, "----------\n1. WARNING in A.java (at line 5)\n\tarray = realArrays; \t\t// problem: unchecked conversion\n\t        ^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String [] @NonNull[]' needs unchecked conversion to conform to '@NonNull Object'\n----------\n2. WARNING in A.java (at line 7)\n\tarray = maybeArrays; \t// problem: unchecked conversion\n\t        ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String [] @Nullable[]' needs unchecked conversion to conform to '@NonNull Object'\n----------\n3. ERROR in A.java (at line 13)\n\trealArrays[0] = null; \t// problem: cannot assign null to @NonNull array\n\t^^^^^^^^^^^^^\nNull type mismatch: required 'String @NonNull[]' but the provided value is null\n----------\n4. ERROR in A.java (at line 14)\n\tarray = maybeArrays[0]; \t// problem: element can be null\n\t        ^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'String @Nullable[]'\n----------\n5. WARNING in A.java (at line 19)\n\tarray = realArrays[0][0]; // problem: unchecked conversion\n\t        ^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull Object'\n----------\n6. ERROR in A.java (at line 21)\n\tarray = maybeArrays[0][0]; // problems: indexing nullable array & unchecked conversion\n\t        ^^^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n7. WARNING in A.java (at line 21)\n\tarray = maybeArrays[0][0]; // problems: indexing nullable array & unchecked conversion\n\t        ^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull Object'\n----------\n8. ERROR in A.java (at line 22)\n\tmaybeArrays[0][0] = null; // problem: indexing nullable array\n\t^^^^^^^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n");
    }

    public void testArrayType_05() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void outer(String @NonNull[] @NonNull[] realArrays, String @NonNull[] @Nullable[] maybeArrays, String @Nullable[][] unknownArrays) {\n        realArrays[0] = maybeArrays[0];\t\t// problem: inner array can be null\n        realArrays[0] = unknownArrays[0];\t// problems: inner array is unspecified, outer can be null\n    }\n    void oneDim(String @Nullable[] maybeStrings, String[] unknownStrings) {\n        String @NonNull[] s = maybeStrings;\n        s = unknownStrings;\n        consume(maybeStrings);\n        consume(unknownStrings);\n    }\n    void consume(String @NonNull[] s) {};\n}\n"}, "----------\n1. ERROR in A.java (at line 4)\n\trealArrays[0] = maybeArrays[0];\t\t// problem: inner array can be null\n\t^^^^^^^^^^^^^\nNull type mismatch: required 'String @NonNull[]' but the provided value is inferred as @Nullable\n----------\n2. WARNING in A.java (at line 5)\n\trealArrays[0] = unknownArrays[0];\t// problems: inner array is unspecified, outer can be null\n\t^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to 'String @NonNull[]'\n----------\n3. ERROR in A.java (at line 5)\n\trealArrays[0] = unknownArrays[0];\t// problems: inner array is unspecified, outer can be null\n\t                ^^^^^^^^^^^^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n4. ERROR in A.java (at line 8)\n\tString @NonNull[] s = maybeStrings;\n\t                      ^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[]' but this expression has type 'String @Nullable[]'\n----------\n5. WARNING in A.java (at line 9)\n\ts = unknownStrings;\n\t    ^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to 'String @NonNull[]'\n----------\n6. ERROR in A.java (at line 10)\n\tconsume(maybeStrings);\n\t        ^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[]' but this expression has type 'String @Nullable[]'\n----------\n7. WARNING in A.java (at line 11)\n\tconsume(unknownStrings);\n\t        ^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to 'String @NonNull[]'\n----------\n");
    }

    public void testArrayType_10() {
        this.runNegativeTestWithLibs(new String[]{"A.java", "import org.eclipse.jdt.annotation.*;\npublic class A {\n    void outer(String @NonNull[] @NonNull[] realArrays, String @NonNull[] @Nullable[] maybeArrays, String @Nullable[][] unknownArrays, String @NonNull[][] mixedArrays) {\n        realArrays = maybeArrays;\t\t\t// problem on inner dimension!\n        realArrays = unknownArrays; \t\t\t// problems on both dimensions\n        maybeArrays = realArrays;\t\t\t// problem on inner dimension\n        unknownArrays = maybeArrays;\t\t\t// problsm on outer dimension\n        realArrays = mixedArrays;\t\t\t// problem on inner\n        maybeArrays = mixedArrays;\t\t\t// problem on inner\n        consume(maybeArrays, mixedArrays, maybeArrays);\n    }\n    void consume(String @NonNull[] @NonNull[] realStrings, String @NonNull[] @Nullable[] maybeArrays, String @Nullable[][] unknownArrays) {\n    }\n}\n"}, "----------\n1. ERROR in A.java (at line 4)\n\trealArrays = maybeArrays;\t\t\t// problem on inner dimension!\n\t             ^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[] @NonNull[]' but this expression has type 'String @NonNull[] @Nullable[]'\n----------\n2. ERROR in A.java (at line 5)\n\trealArrays = unknownArrays; \t\t\t// problems on both dimensions\n\t             ^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[] @NonNull[]' but this expression has type 'String @Nullable[] []'\n----------\n3. ERROR in A.java (at line 6)\n\tmaybeArrays = realArrays;\t\t\t// problem on inner dimension\n\t              ^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[] @Nullable[]' but this expression has type 'String @NonNull[] @NonNull[]'\n----------\n4. ERROR in A.java (at line 7)\n\tunknownArrays = maybeArrays;\t\t\t// problsm on outer dimension\n\t                ^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @Nullable[] []' but this expression has type 'String @NonNull[] @Nullable[]'\n----------\n5. WARNING in A.java (at line 8)\n\trealArrays = mixedArrays;\t\t\t// problem on inner\n\t             ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @NonNull[] []' needs unchecked conversion to conform to 'String @NonNull[] @NonNull[]'\n----------\n6. WARNING in A.java (at line 9)\n\tmaybeArrays = mixedArrays;\t\t\t// problem on inner\n\t              ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @NonNull[] []' needs unchecked conversion to conform to 'String @NonNull[] @Nullable[]'\n----------\n7. ERROR in A.java (at line 10)\n\tconsume(maybeArrays, mixedArrays, maybeArrays);\n\t        ^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @NonNull[] @NonNull[]' but this expression has type 'String @NonNull[] @Nullable[]'\n----------\n8. WARNING in A.java (at line 10)\n\tconsume(maybeArrays, mixedArrays, maybeArrays);\n\t                     ^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @NonNull[] []' needs unchecked conversion to conform to 'String @NonNull[] @Nullable[]'\n----------\n9. ERROR in A.java (at line 10)\n\tconsume(maybeArrays, mixedArrays, maybeArrays);\n\t                                  ^^^^^^^^^^^\nNull type mismatch (type annotations): required 'String @Nullable[] []' but this expression has type 'String @NonNull[] @Nullable[]'\n----------\n");
    }

    public void testBug403216_1() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\npublic class Test {}\n\nclass X {\n\tclass Y {\n\t\tpublic void foo( @A X. @B Y this) {}\n\t}\n}\n@Target(value={ElementType.TYPE_USE})\n@interface A {}\n@Target(value={ElementType.TYPE_USE})\n@interface B {}\n"});
    }

    public void testBug403216_2() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n    void test(List<@NonNull String> strings) {\n        List<String> someStrings;\n        someStrings = strings;\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug403216_3a() {
        this.runNegativeTestWithLibs(new String[]{"Test.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.*;\n\npublic class Test {}\n\nclass X {\n\tclass Y {\n\t\tpublic void foo( @A X. @NonNull Y this) {}\n\t}\n}\n@Target(value={ElementType.TYPE_USE})\n@interface A {}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Test.java (at line 9)\n\tpublic void foo( @A X. @NonNull Y this) {}\n\t                 ^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testBug403216_3b() {
        this.runConformTestWithLibs(new String[]{"Test.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\npublic class Test {}\n\nclass X {\n\tclass Y {\n\t\tpublic void foo( @A X. @A Y this) {}\n\t}\n}\n@Target(value={ElementType.TYPE_USE})\n@interface A {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug403457_1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.*;\n\npublic class X {\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n   void goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n}\n\n@Target(ElementType.TYPE_USE)\n@interface Marker {\n\t\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tvoid foo(Map<@Marker ? super @Marker Object, @Marker ? extends @Marker String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\tvoid goo(Map<@Marker ? extends @Marker Object, @Marker ? super @Marker String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n");
    }

    public void testBug403457_2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "// import java.util.Map;\nimport org.eclipse.jdt.annotation.*;\n\npublic class X {\n\tvoid foo(Map<@Nullable ? super @Nullable Object, @Nullable ? extends @Nullable String> m){}\n   void goo(Map<@Nullable ? extends @Nullable Object, @Nullable ? super @Nullable String> m){}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tvoid foo(Map<@Nullable ? super @Nullable Object, @Nullable ? extends @Nullable String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tvoid goo(Map<@Nullable ? extends @Nullable Object, @Nullable ? super @Nullable String> m){}\n\t         ^^^\nMap cannot be resolved to a type\n----------\n");
    }

    public void testBinary01() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runConformTestWithLibs(new String[]{"p/X.java", "package p;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n\tpublic List<@Nullable String> getSomeStrings() { return null; }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import p.X;\npublic class Y {\n\tpublic void test(X x) {\n\t\tString s0 = x.getSomeStrings().get(0);\n\t\tSystem.out.println(s0.toUpperCase());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y.java (at line 5)\n\tSystem.out.println(s0.toUpperCase());\n\t                   ^^\nPotential null pointer access: The variable s0 may be null at this location\n----------\n");
    }

    public void testBinary02() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runConformTestWithLibs(new String[]{"p/X.java", "package p;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.*;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target(TYPE_USE)\n@interface Immutable {}\npublic class X {\n\tpublic void setAllStrings(@Immutable X this, int dummy, List<@NonNull String> ss) { }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import p.X;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.*;\npublic class Y {\n\tpublic void test(X x, List<@Nullable String> ss) {\n\t\tx.setAllStrings(-1, ss);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y.java (at line 6)\n\tx.setAllStrings(-1, ss);\n\t                    ^^\nNull type mismatch (type annotations): required 'List<@NonNull String>' but this expression has type 'List<@Nullable String>'\n----------\n");
    }

    public void testBinary03() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n\tpublic static String @Nullable [] f1 = null;\n\tpublic static String [] @Nullable [] f2 = new String[] @Nullable[] { null };\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\npublic class Y1 {\n\tpublic void test() {\n\t\tSystem.out.println(p.X1.f1.length);\n\t\tSystem.out.println(X1.f2[0].length);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 4)\n\tSystem.out.println(p.X1.f1.length);\n\t                        ^^\nPotential null pointer access: this expression has a '@Nullable' type\n----------\n2. ERROR in Y1.java (at line 5)\n\tSystem.out.println(X1.f2[0].length);\n\t                   ^^^^^^^^\nPotential null pointer access: array element may be null\n----------\n");
    }

    public void testBinary04() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 extends ArrayList<@Nullable String> {\n}\n", "p/X2.java", "package p;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X2 implements List<@Nullable String> {\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\npublic class Y1 {\n\tpublic void test(X1 x) {\n\t\tString s0 = x.get(0);\n\t\tSystem.out.println(s0.toUpperCase());\n\t}\n}\n", "Y2.java", "import p.X2;\npublic class Y2 {\n\tpublic void test(X2 x) {\n\t\tString s0 = x.get(0);\n\t\tSystem.out.println(s0.toUpperCase());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 5)\n\tSystem.out.println(s0.toUpperCase());\n\t                   ^^\nPotential null pointer access: The variable s0 may be null at this location\n----------\n----------\n1. ERROR in Y2.java (at line 5)\n\tSystem.out.println(s0.toUpperCase());\n\t                   ^^\nPotential null pointer access: The variable s0 may be null at this location\n----------\n");
    }

    public void testBinary05() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1<@NonNull T> extends ArrayList<T> {\n    public <@Nullable S> void foo(S s) {}\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tX1<@Nullable String> maybeStrings;\n\tvoid test(X1<@NonNull String> x) {\n\t\tx.<@NonNull Object>foo(new Object());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 4)\n\tX1<@Nullable String> maybeStrings;\n\t   ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T extends Object'\n----------\n2. ERROR in Y1.java (at line 6)\n\tx.<@NonNull Object>foo(new Object());\n\t   ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Object' is not a valid substitute for the type parameter '@Nullable S extends Object'\n----------\n");
    }

    public void testBinary06() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1<T extends @NonNull Object> extends ArrayList<T> {\n    public <U, V extends @Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@NonNull W extends @Nullable Object> {}\n"}, customOptions, "----------\n1. ERROR in p\\X2.java (at line 3)\n\tpublic class X2<@NonNull W extends @Nullable Object> {}\n\t                                   ^^^^^^^^^\nThis nullness annotation conflicts with a '@NonNull' annotation which is effective on the same type parameter \n----------\n");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1<T extends @NonNull Object> extends ArrayList<T> {\n    public <U, V extends @Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@Nullable W extends Object> {}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport p.X2;\nimport org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tX1<@Nullable String> maybeStrings;\n   X2<@NonNull String> strings;\n\tvoid test(X1<@NonNull String> x) {\n\t\tx.<Y1, @NonNull Object>foo(this, new Object());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 5)\n\tX1<@Nullable String> maybeStrings;\n\t   ^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T extends @NonNull Object'\n----------\n2. ERROR in Y1.java (at line 6)\n\tX2<@NonNull String> strings;\n\t   ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable W extends Object'\n----------\n3. ERROR in Y1.java (at line 8)\n\tx.<Y1, @NonNull Object>foo(this, new Object());\n\t       ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Object' is not a valid substitute for the type parameter '@Nullable V extends @Nullable Object'\n----------\n");
    }

    public void testBinary06b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1<T extends java.lang.@NonNull Object> extends ArrayList<T> {\n    public <U, V extends java.lang.@Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@NonNull W extends java.lang.@Nullable Object> {}\n"}, customOptions, "----------\n1. ERROR in p\\X2.java (at line 3)\n\tpublic class X2<@NonNull W extends java.lang.@Nullable Object> {}\n\t                                             ^^^^^^^^^\nThis nullness annotation conflicts with a '@NonNull' annotation which is effective on the same type parameter \n----------\n");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1<T extends java.lang.@NonNull Object> extends ArrayList<T> {\n    public <U, V extends java.lang.@Nullable Object> void foo(U u, V v) {}\n}\n", "p/X2.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X2<@Nullable W extends Object> {}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tp.X1<java.lang.@Nullable String> maybeStrings;\n   p.X2<java.lang.@NonNull String> strings;\n\tvoid test(p.X1<java.lang.@NonNull String> x) {\n\t\tx.<Y1, java.lang.@NonNull Object>foo(this, new Object());\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 3)\n\tp.X1<java.lang.@Nullable String> maybeStrings;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable String' is not a valid substitute for the type parameter '@NonNull T extends @NonNull Object'\n----------\n2. ERROR in Y1.java (at line 4)\n\tp.X2<java.lang.@NonNull String> strings;\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull String' is not a valid substitute for the type parameter '@Nullable W extends Object'\n----------\n3. ERROR in Y1.java (at line 6)\n\tx.<Y1, java.lang.@NonNull Object>foo(this, new Object());\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Object' is not a valid substitute for the type parameter '@Nullable V extends @Nullable Object'\n----------\n");
    }

    public void testBinary07() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target(TYPE_USE)\n@interface Immutable {}\npublic abstract class X1 {\n    public <@NonNull U, V extends @Nullable Object> List<@NonNull Map<Object, @NonNull String>> foo(@Immutable X1 this, U u, V v) { return null; }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\npublic class Y1 {\n\tvoid test(X1 x) {\n\t\tx.<@NonNull Y1, @NonNull Object>foo(this, new Object())\n\t\t\t.get(0).put(null, null);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y1.java (at line 5)\n\tx.<@NonNull Y1, @NonNull Object>foo(this, new Object())\n\t                ^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@NonNull Object' is not a valid substitute for the type parameter '@Nullable V extends @Nullable Object'\n----------\n2. ERROR in Y1.java (at line 6)\n\t.get(0).put(null, null);\n\t                  ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBinary08() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n    public class Inner {}\n    public Object []@NonNull[] arrays(Object @NonNull[][] oa1) { return null; }\n    public void nesting(@NonNull Inner i1, X1.@Nullable Inner i2) { }\n    public void wildcard1(List<@Nullable ? extends @NonNull X1> l) { } // contradiction\n    public void wildcard2(List<? super @NonNull X1> l) { }\n}\n"}, customOptions, "----------\n1. ERROR in p\\X1.java (at line 8)\n\tpublic void wildcard1(List<@Nullable ? extends @NonNull X1> l) { } // contradiction\n\t                                               ^^^^^^^^\nThis nullness annotation conflicts with a '@Nullable' annotation which is effective on the same type parameter \n----------\n");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n    public class Inner {}\n    public Object []@NonNull[] arrays(Object @NonNull[][] oa1) { return null; }\n    public void nesting(@NonNull Inner i1, X1.@Nullable Inner i2) { }\n    public void wildcard1(List<@Nullable ? extends X1> l) { }\n    public void wildcard2(List<? super @NonNull X1> l) { }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Y1 {\n\tvoid test(X1 x) {\n\t\tObject @NonNull[][] a = new Object[0][]; // unsafe\n\t\tx.arrays(a)[0] = null; // illegal\n\t\tx.nesting(null, null); // 1st null is illegal\n\t\tx.wildcard2(new ArrayList<@NonNull Object>());\n\t\tx.wildcard2(new ArrayList<@Nullable Object>()); // OK\n\t\tx.wildcard1(new ArrayList<@NonNull X1>()); // incompatible\n\t}\n}\n"}, customOptions, "----------\n1. WARNING in Y1.java (at line 6)\n\tObject @NonNull[][] a = new Object[0][]; // unsafe\n\t                        ^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Object[][]' needs unchecked conversion to conform to 'Object @NonNull[] []'\n----------\n2. ERROR in Y1.java (at line 7)\n\tx.arrays(a)[0] = null; // illegal\n\t^^^^^^^^^^^^^^\nNull type mismatch: required 'Object @NonNull[]' but the provided value is null\n----------\n3. ERROR in Y1.java (at line 8)\n\tx.nesting(null, null); // 1st null is illegal\n\t          ^^^^\nNull type mismatch: required 'X1.@NonNull Inner' but the provided value is null\n----------\n4. ERROR in Y1.java (at line 11)\n\tx.wildcard1(new ArrayList<@NonNull X1>()); // incompatible\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable ? extends X1>' but this expression has type 'ArrayList<@NonNull X1>', corresponding supertype is 'List<@NonNull X1>'\n----------\n");
    }

    public void testBinary08b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTestWithLibs(new String[]{"p/X1.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n    public class Inner {}\n    public java.lang.Object []@NonNull[] arrays(java.lang.Object @NonNull[][] oa1) { return null; }\n    public void nesting(@NonNull Inner i1, X1.@Nullable Inner i2) { }\n    public void wildcard1(java.util.List<@Nullable ? extends p.@NonNull X1> l) { } // contradiction\n    public void wildcard2(java.util.List<? super p.@NonNull X1> l) { }\n}\n"}, customOptions, "----------\n1. ERROR in p\\X1.java (at line 7)\n\tpublic void wildcard1(java.util.List<@Nullable ? extends p.@NonNull X1> l) { } // contradiction\n\t                                                           ^^^^^^^^\nThis nullness annotation conflicts with a '@Nullable' annotation which is effective on the same type parameter \n----------\n");
        this.runConformTestWithLibs(new String[]{"p/X1.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic abstract class X1 {\n    public class Inner {}\n    public java.lang.Object []@NonNull[] arrays(java.lang.Object @NonNull[][] oa1) { return null; }\n    public void nesting(@NonNull Inner i1, p.X1.@Nullable Inner i2) { }\n    public void wildcard1(List<@Nullable ? extends p.X1> l) { }\n    public void wildcard2(List<? super p.@NonNull X1> l) { }\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y1.java", "import p.X1;\nimport org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Y1 {\n\tvoid test(X1 x) {\n\t\tjava.lang.Object @NonNull[][] a = new java.lang.Object[0][]; // unsafe\n\t\tx.arrays(a)[0] = null; // illegal\n\t\tx.nesting(null, null); // 1st null is illegal\n\t\tx.wildcard2(new ArrayList<java.lang.@NonNull Object>());\n\t\tx.wildcard2(new ArrayList<java.lang.@Nullable Object>());\n\t\tx.wildcard1(new ArrayList<p.@NonNull X1>()); // incompatible\n\t}\n}\n"}, customOptions, "----------\n1. WARNING in Y1.java (at line 6)\n\tjava.lang.Object @NonNull[][] a = new java.lang.Object[0][]; // unsafe\n\t                                  ^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Object[][]' needs unchecked conversion to conform to 'Object @NonNull[] []'\n----------\n2. ERROR in Y1.java (at line 7)\n\tx.arrays(a)[0] = null; // illegal\n\t^^^^^^^^^^^^^^\nNull type mismatch: required 'Object @NonNull[]' but the provided value is null\n----------\n3. ERROR in Y1.java (at line 8)\n\tx.nesting(null, null); // 1st null is illegal\n\t          ^^^^\nNull type mismatch: required 'X1.@NonNull Inner' but the provided value is null\n----------\n4. ERROR in Y1.java (at line 11)\n\tx.wildcard1(new ArrayList<p.@NonNull X1>()); // incompatible\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable ? extends X1>' but this expression has type 'ArrayList<@NonNull X1>', corresponding supertype is 'List<@NonNull X1>'\n----------\n");
    }

    public void testBinary09() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class X {\n\t@NonNull String @Nullable [] f @NonNull [] = null;\n\tstatic void foo(@NonNull String @Nullable [] p @NonNull []) {\n\t\tp = null;\n\t\t@NonNull String @Nullable [] l @NonNull [] = null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@NonNull String @Nullable [] f @NonNull [] = null;\n\t                                             ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] @Nullable[]' but the provided value is null\n----------\n2. ERROR in X.java (at line 6)\n\tp = null;\n\t    ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] @Nullable[]' but the provided value is null\n----------\n3. ERROR in X.java (at line 7)\n\t@NonNull String @Nullable [] l @NonNull [] = null;\n\t                                             ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] @Nullable[]' but the provided value is null\n----------\n");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class X {\n\t@NonNull String @Nullable [] f @NonNull [] = new @NonNull String @NonNull [0] @Nullable [];\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\tvoid test(X x) {\n       x.f = null;\n       x.f[0] = null;\n       x.f[0][0] = null;\n\t}\n}\n"}, customOptions, "----------\n1. WARNING in Y.java (at line 1)\n\timport org.eclipse.jdt.annotation.*;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import org.eclipse.jdt.annotation is never used\n----------\n2. ERROR in Y.java (at line 4)\n\tx.f = null;\n\t      ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] @Nullable[]' but the provided value is null\n----------\n3. ERROR in Y.java (at line 6)\n\tx.f[0][0] = null;\n\t^^^^^^\nPotential null pointer access: array element may be null\n----------\n4. ERROR in Y.java (at line 6)\n\tx.f[0][0] = null;\n\t^^^^^^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBinary10() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class X  {\n\tvoid foo(ArrayList<String> @NonNull [] p) {\n\t}\n}\nclass Y extends X {\n\tvoid foo() {\n\t\tsuper.foo(null);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tsuper.foo(null);\n\t          ^^^^\nNull type mismatch: required 'ArrayList<String> @NonNull[]' but the provided value is null\n----------\n");
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class X  {\n\tvoid foo(ArrayList<String> @NonNull [] p) {\n\t}\n}\n"}, customOptions, "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "public class Y extends X {\n\tvoid foo() {\n\t\tsuper.foo(null);\n\t}\n}\n"}, customOptions, "----------\n1. ERROR in Y.java (at line 3)\n\tsuper.foo(null);\n\t          ^^^^\nNull type mismatch: required 'ArrayList<String> @NonNull[]' but the provided value is null\n----------\n");
    }

    public void testConditional1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@NonNull String> foo(List<@NonNull String> good, List<String> dubious, int f) {\n\t\tif (f < 2)\n\t\t\treturn f == 0 ? good : dubious;\n\t\tif (f < 4)\n\t\t\treturn f == 2 ? dubious : good;\n\t\tif (f < 6)\n\t\t\treturn f == 4 ? good : good;\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\treturn f == 0 ? good : dubious;\n\t                       ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n2. WARNING in X.java (at line 8)\n\treturn f == 2 ? dubious : good;\n\t                ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n");
    }

    public void testConditional2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@NonNull String> foo(List<@NonNull String> good, ArrayList<String> dubious, int f) {\n\t\tif (f < 2)\n\t\t\treturn f == 0 ? good : dubious;\n\t\tif (f < 4)\n\t\t\treturn f == 2 ? dubious : good;\n\t\tif (f < 6)\n\t\t\treturn f == 4 ? good : good;\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\treturn f == 0 ? good : dubious;\n\t                       ^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n2. WARNING in X.java (at line 8)\n\treturn f == 2 ? dubious : good;\n\t                ^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n");
    }

    public void testConditional3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tvoid foo(List<@NonNull String> good, List<String> dubious, int f) {\n\t\tconsume(f == 0 ? good : dubious);\n\t\tconsume(f == 2 ? dubious : good);\n\t\tconsume(f == 4 ? good : good);\n\t}\n\tvoid consume(List<@NonNull String> strings) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tconsume(f == 0 ? good : dubious);\n\t                        ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n2. WARNING in X.java (at line 6)\n\tconsume(f == 2 ? dubious : good);\n\t                 ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n");
    }

    public void testCompatibility1() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@NonNull String> return1(List<@NonNull String> noNulls) {\n\t\treturn noNulls;\n\t}\n\tList<@Nullable String> return2(List<@Nullable String> withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(List<@NonNull String> noNulls, List<String> dubious, List<@Nullable String> withNulls) {\n\t\tList<@NonNull String> l1 = noNulls;\n\t\tList<@Nullable String> l2 = withNulls;\n\t\tList<String> l3 = dubious;\n\t}\n\tvoid arguments(List<@NonNull String> noNulls, List<String> dubious, List<@Nullable String> withNulls) {\n\t\tassigns(noNulls, dubious, withNulls);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testCompatibility1a() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull String[] return1(@NonNull String[] noNulls) {\n\t\treturn noNulls;\n\t}\n\t@Nullable String[] return2(@Nullable String[] noNulls) {\n\t\treturn noNulls;\n\t}\n\tvoid assigns(@NonNull String[] noNulls, String dubious[], @Nullable String[] withNulls) {\n\t\t@NonNull String[] l1 = noNulls;\n\t\t@Nullable String[] l2 = withNulls;\n\t\tString[] l3 = dubious;\n\t}\n\tvoid arguments(@NonNull String[] noNulls, String[] dubious, @Nullable String[] withNulls) {\n\t\tassigns(noNulls, dubious, withNulls);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testCompatibility2() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<String> return1(List<@NonNull String> noNulls) {\n\t\treturn noNulls;\n\t}\n\tList<String> return2(List<String> dubious) {\n\t\treturn dubious;\n\t}\n\tList<String> return3(List<@Nullable String> withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(List<@NonNull String> noNulls, List<String> dubious, List<@Nullable String> withNulls) {\n\t\tList<String> l1 = noNulls;\n\t\tList<String> l2 = dubious;\n\t\tList<String> l3 = withNulls;\n\t}\n\tvoid arguments(List<@NonNull String> noNulls, List<String> dubious, List<@Nullable String> withNulls) {\n\t\ttakeAny(noNulls);\n\t\ttakeAny(dubious);\n\t\ttakeAny(withNulls);\n\t}\n\tvoid takeAny(List<String> any) {}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testCompatibility2a() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tString[] return1(@NonNull String[] noNulls) {\n\t\treturn noNulls;\n\t}\n\tString[] return2(String[] dubious) {\n\t\treturn dubious;\n\t}\n\tString[] return3(@Nullable String[] withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(@NonNull String[] noNulls, String[] dubious, @Nullable String[] withNulls) {\n\t\tString[] l1 = noNulls;\n\t\tString[] l2 = dubious;\n\t\tString[] l3 = withNulls;\n\t}\n\tvoid arguments(@NonNull String[] noNulls, String[] dubious, @Nullable String[] withNulls) {\n\t\ttakeAny(noNulls);\n\t\ttakeAny(dubious);\n\t\ttakeAny(withNulls);\n\t}\n\tvoid takeAny(String[] any) {}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testCompatibility3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@NonNull String> return1(List<String> dubious) {\n\t\treturn dubious;\n\t}\n\tList<@Nullable String> return2(List<String> dubious) {\n\t\treturn dubious;\n\t}\n\tvoid assigns(List<String> dubious) {\n\t\tList<@Nullable String> l1 = dubious;\n\t\tList<@NonNull String> l2 = dubious;\n\t}\n\tvoid arguments(List<String> dubious) {\n\t\tacceptNulls(dubious);\n\t\tacceptNoNulls(dubious);\n\t}\n\tvoid acceptNulls(List<@NonNull String> noNulls) {}\n\tvoid acceptNoNulls(List<@NonNull String> noNulls) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\treturn dubious;\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n2. WARNING in X.java (at line 8)\n\treturn dubious;\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@Nullable String>'\n----------\n3. WARNING in X.java (at line 11)\n\tList<@Nullable String> l1 = dubious;\n\t                            ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@Nullable String>'\n----------\n4. WARNING in X.java (at line 12)\n\tList<@NonNull String> l2 = dubious;\n\t                           ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n5. WARNING in X.java (at line 15)\n\tacceptNulls(dubious);\n\t            ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n6. WARNING in X.java (at line 16)\n\tacceptNoNulls(dubious);\n\t              ^^^^^^^\nNull type safety (type annotations): The expression of type 'List<String>' needs unchecked conversion to conform to 'List<@NonNull String>'\n----------\n");
    }

    public void testCompatibility3a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull String[] return1(String[] dubious) {\n\t\treturn dubious;\n\t}\n\t@Nullable String[] return2(String[] dubious) {\n\t\treturn dubious;\n\t}\n\tvoid assigns(String[] dubious) {\n\t\t@Nullable String[] l1 = dubious;\n\t\t@NonNull String[] l2 = dubious;\n\t}\n\tvoid arguments(String[] dubious) {\n\t\tacceptNulls(dubious);\n\t\tacceptNoNulls(dubious);\n\t}\n\tvoid acceptNulls(@Nullable String[] withNulls) {}\n\tvoid acceptNoNulls(@NonNull String[] noNulls) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\treturn dubious;\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String []'\n----------\n2. WARNING in X.java (at line 7)\n\treturn dubious;\n\t       ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@Nullable String []'\n----------\n3. WARNING in X.java (at line 10)\n\t@Nullable String[] l1 = dubious;\n\t                        ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@Nullable String []'\n----------\n4. WARNING in X.java (at line 11)\n\t@NonNull String[] l2 = dubious;\n\t                       ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String []'\n----------\n5. WARNING in X.java (at line 14)\n\tacceptNulls(dubious);\n\t            ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@Nullable String []'\n----------\n6. WARNING in X.java (at line 15)\n\tacceptNoNulls(dubious);\n\t              ^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String []'\n----------\n");
    }

    public void testCompatibility4() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tList<@Nullable String> return1(List<@NonNull String> noNulls) {\n\t\treturn noNulls;\n\t}\n\tList<@NonNull String> return2(List<@Nullable String> withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(List<@NonNull String> noNulls, List<@Nullable String> withNulls) {\n\t\tList<@NonNull String> l1 = withNulls;\n\t\tList<@Nullable String> l2 = noNulls;\n\t}\n\tvoid arguments(List<@NonNull String> noNulls, List<@Nullable String> withNulls) {\n\t\tassigns(withNulls, noNulls);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn noNulls;\n\t       ^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable String>' but this expression has type 'List<@NonNull String>'\n----------\n2. ERROR in X.java (at line 8)\n\treturn withNulls;\n\t       ^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull String>' but this expression has type 'List<@Nullable String>'\n----------\n3. ERROR in X.java (at line 11)\n\tList<@NonNull String> l1 = withNulls;\n\t                           ^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull String>' but this expression has type 'List<@Nullable String>'\n----------\n4. ERROR in X.java (at line 12)\n\tList<@Nullable String> l2 = noNulls;\n\t                            ^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable String>' but this expression has type 'List<@NonNull String>'\n----------\n5. ERROR in X.java (at line 15)\n\tassigns(withNulls, noNulls);\n\t        ^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull String>' but this expression has type 'List<@Nullable String>'\n----------\n6. ERROR in X.java (at line 15)\n\tassigns(withNulls, noNulls);\n\t                   ^^^^^^^\nNull type mismatch (type annotations): required 'List<@Nullable String>' but this expression has type 'List<@NonNull String>'\n----------\n");
    }

    public void testCompatibility4a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@Nullable String[] return1(@NonNull String[] noNulls) {\n\t\treturn noNulls;\n\t}\n\t@NonNull String[] return2(@Nullable String[] withNulls) {\n\t\treturn withNulls;\n\t}\n\tvoid assigns(@NonNull String[] noNulls, @Nullable String[] withNulls) {\n\t\t@NonNull String[] l1 = withNulls;\n\t\t@Nullable String[] l2 = noNulls;\n\t}\n\tvoid arguments(@NonNull String[] noNulls, @Nullable String[] withNulls) {\n\t\tassigns(withNulls, noNulls);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn noNulls;\n\t       ^^^^^^^\nNull type mismatch (type annotations): required '@Nullable String []' but this expression has type '@NonNull String []'\n----------\n2. ERROR in X.java (at line 7)\n\treturn withNulls;\n\t       ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String []' but this expression has type '@Nullable String []'\n----------\n3. ERROR in X.java (at line 10)\n\t@NonNull String[] l1 = withNulls;\n\t                       ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String []' but this expression has type '@Nullable String []'\n----------\n4. ERROR in X.java (at line 11)\n\t@Nullable String[] l2 = noNulls;\n\t                        ^^^^^^^\nNull type mismatch (type annotations): required '@Nullable String []' but this expression has type '@NonNull String []'\n----------\n5. ERROR in X.java (at line 14)\n\tassigns(withNulls, noNulls);\n\t        ^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String []' but this expression has type '@Nullable String []'\n----------\n6. ERROR in X.java (at line 14)\n\tassigns(withNulls, noNulls);\n\t                   ^^^^^^^\nNull type mismatch (type annotations): required '@Nullable String []' but this expression has type '@NonNull String []'\n----------\n");
    }

    public void testCompatibility5() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.Map;\n\nimport org.eclipse.jdt.annotation.*;\n\nabstract public class X<Y> implements Map<@NonNull String,Y> {\n\tvoid foo(X<Object> x) {\n\t\tMap<@NonNull String, Object> m1 = x; // OK\n\t\tMap<@Nullable String, Object> m2 = x; // NOK\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\tMap<@Nullable String, Object> m2 = x; // NOK\n\t                                   ^\nNull type mismatch (type annotations): required 'Map<@Nullable String,Object>' but this expression has type 'X<Object>', corresponding supertype is 'Map<@NonNull String,Object>'\n----------\n");
    }

    public void testCompatibility6() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.Map;\n\nimport org.eclipse.jdt.annotation.*;\n\nabstract public class X<@Nullable Y> implements Map<@Nullable String,Y> {\n\tvoid foo(X<Object> x) {\n\t\tMap<@Nullable String, @Nullable Object> m1 = x; // OK\n\t\tMap<@Nullable String, @NonNull Object> m2 = x; // NOK\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\tMap<@Nullable String, @NonNull Object> m2 = x; // NOK\n\t                                            ^\nNull type mismatch (type annotations): required 'Map<@Nullable String,@NonNull Object>' but this expression has type 'X<Object>', corresponding supertype is 'Map<@Nullable String,@Nullable Object>'\n----------\n");
    }

    public void testUnsupportedLocation01() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic @NonNull class X {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic @NonNull class X {}\n\t       ^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n");
    }

    public void testUnsupportedLocation02() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    class Inner {}\n    @NonNull X.Inner f;\n    @NonNull X.Inner foo(@NonNull X.Inner arg) {\n        @NonNull X.Inner local = arg;\n        return local;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@NonNull X.Inner f;\n\t^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n2. ERROR in X.java (at line 5)\n\t@NonNull X.Inner foo(@NonNull X.Inner arg) {\n\t^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n3. ERROR in X.java (at line 5)\n\t@NonNull X.Inner foo(@NonNull X.Inner arg) {\n\t                     ^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n4. ERROR in X.java (at line 6)\n\t@NonNull X.Inner local = arg;\n\t^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n");
    }

    public void testUnsupportedLocation03() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n    @NonNull X foo(X arg) {\n        if (!(arg instanceof @NonNull X))\n\t\t\treturn (@NonNull X)arg;\n        return arg;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (!(arg instanceof @NonNull X))\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type X is already an instance of type X\n----------\n2. ERROR in X.java (at line 4)\n\tif (!(arg instanceof @NonNull X))\n\t                     ^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n3. WARNING in X.java (at line 5)\n\treturn (@NonNull X)arg;\n\t       ^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from X to @NonNull X\n----------\n");
    }

    public void testUnsupportedLocation04() {
        this.runNegativeTestWithLibs(new String[]{"p/X.java", "package p;\nimport org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n    List<@NonNull X> parameterized(List<X> arg) {\n        if (!(arg instanceof List<@NonNull X>))\n\t\t\treturn (java.util.List<@NonNull X>)arg;\n        return arg;\n    }\n    X @NonNull[] arrays(X[] arg) {\n        if (!(arg instanceof X @NonNull[]))\n\t\t\treturn (p.X @NonNull[])arg;\n        return arg;\n    }\n\tArrayList<@NonNull String> foo(List<@NonNull String> l) {\n\t\treturn (ArrayList<@NonNull String>) l;\n\t}\tArrayList<@NonNull String> foo2(List<@NonNull String> l) {\n\t\treturn (ArrayList<String>) l;\n\t}}\n"}, "----------\n1. ERROR in p\\X.java (at line 6)\n\tif (!(arg instanceof List<@NonNull X>))\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot perform instanceof check against parameterized type List<X>. Use the form List<?> instead since further generic type information will be erased at runtime\n----------\n2. ERROR in p\\X.java (at line 6)\n\tif (!(arg instanceof List<@NonNull X>))\n\t                     ^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n3. WARNING in p\\X.java (at line 7)\n\treturn (java.util.List<@NonNull X>)arg;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from List<X> to List<@NonNull X>\n----------\n4. WARNING in p\\X.java (at line 11)\n\tif (!(arg instanceof X @NonNull[]))\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type X[] is already an instance of type X[]\n----------\n5. ERROR in p\\X.java (at line 11)\n\tif (!(arg instanceof X @NonNull[]))\n\t                     ^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n6. WARNING in p\\X.java (at line 12)\n\treturn (p.X @NonNull[])arg;\n\t       ^^^^^^^^^^^^^^^^^^^\nNull type safety: Unchecked cast from X[] to X @NonNull[]\n----------\n7. WARNING in p\\X.java (at line 18)\n\treturn (ArrayList<String>) l;\n\t       ^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to 'ArrayList<@NonNull String>'\n----------\n");
    }

    public void testUnsupportedLocation04a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tboolean instanceOf2(Object o) {\n\t\treturn o instanceof List<@Nullable ?>;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn o instanceof List<@Nullable ?>;\n\t                    ^^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testUnsupportedLocation05() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tX x = new @NonNull X();\n\tclass Inner {}\n   Inner i = this.new @Nullable Inner();\n\tjava.util.List<@NonNull String> s = new java.util.ArrayList<@NonNull String>();\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX x = new @NonNull X();\n\t          ^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n2. ERROR in X.java (at line 5)\n\tInner i = this.new @Nullable Inner();\n\t                   ^^^^^^^^^\nThe nullness annotation 'Nullable' is not applicable at this location\n----------\n");
    }

    public void testUnsupportedLocation06() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid receiver(@Nullable X this, Object o) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid receiver(@Nullable X this, Object o) {}\n\t              ^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testUnsupportedLocation07() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.function.Supplier;\npublic class X {\n\tvoid consume(Supplier<Object> c) {}\n\tstatic Object supply() { return null; }\n\tvoid consumeSupplied() {\n\t\tconsume(@NonNull X::supply);\n\t\tconsume(@NonNull X::new);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tconsume(@NonNull X::supply);\n\t        ^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n2. ERROR in X.java (at line 8)\n\tconsume(@NonNull X::new);\n\t        ^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testUnsupportedLocation08() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.io.*;\npublic class X {\n\tvoid throwsDecl() throws @Nullable IOException {}\n\tvoid excParam() {\n\t\ttry {\n\t\t\tthrowsDecl();\n\t\t} catch (@NonNull IOException ioe) {}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tvoid throwsDecl() throws @Nullable IOException {}\n\t                         ^^^^^^^^^^^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n2. ERROR in X.java (at line 8)\n\t} catch (@NonNull IOException ioe) {}\n\t                  ^^^^^^^^^^^\nNullness annotations are not applicable at this location \n----------\n");
    }

    public void testForeach() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\tvoid foo(List<@NonNull String> nns) {\n\t\tfor(String s1 : nns) {\n\t\t\tlogMsg(s1);\n\t\t}\n\t\tfor(String s2 : getStrings()) {\n\t\t\tlogMsg(s2);\n\t\t}\n\t}\n\tCollection<@Nullable String> getStrings() { return null; }\n\tvoid logMsg(@NonNull String msg) { }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tlogMsg(s2);\n\t       ^^\nNull type mismatch: required '@NonNull String' but the provided value is inferred as @Nullable\n----------\n");
    }

    public void testNullTypeInference1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class X {\n\t<T> List<T> polyNullMethod(List<T> in) { return in; }\n\t@NonNull String test1(List<@NonNull String> strings) {\n\t\t return polyNullMethod(strings).get(0);\n\t}\n\t@NonNull String test2(List<@Nullable String> strings) {\n\t\t return polyNullMethod(strings).get(0);\n\t}\n\t@Nullable String test3(List<@NonNull String> strings) {\n\t\t return polyNullMethod(strings).get(0);\n\t}\n\t@Nullable String test4(List<@Nullable String> strings) {\n\t\t return polyNullMethod(strings).get(0);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 9)\n\treturn polyNullMethod(strings).get(0);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testNullTypeInference2a() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface NNFunc {\n\t@NonNull String a(@NonNull String i);\n}\npublic class PolyNull {\n\t@NonNull String extract(NNFunc f, @NonNull String s) { return f.a(s); }\n\t@NonNull String testOK() {\n\t\treturn extract(i -> i, \"hallo\");\n\t}\n\t@NonNull String testERR() {\n\t\treturn extract(i -> null, \"hallo\"); // err\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 12)\n\treturn extract(i -> null, \"hallo\"); // err\n\t                    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testNullTypeInference2b() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\t@NonNull String extract(Func<@NonNull String> f, @NonNull String s) { return f.a(s); }\n\t@NonNull String testOK() {\n\t\treturn extract(i -> i, \"hallo\");\n\t}\n\t@NonNull String testERR() {\n\t\treturn extract(i -> null, \"hallo\"); // err\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 12)\n\treturn extract(i -> null, \"hallo\"); // err\n\t                    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testNullTypeInference2c() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\t<X> X extract(Func<X> f, X s) { return f.a(s); }\n\t@NonNull String testOK() {\n\t\treturn extract((@NonNull String i) -> i, \"hallo\");\n\t}\n\t@NonNull String testERR() {\n\t\treturn extract((@NonNull String i) -> null, \"hallo\"); // err\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 12)\n\treturn extract((@NonNull String i) -> null, \"hallo\"); // err\n\t                                      ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testNullTypeInference2d() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\t<X> X extract(Func<X> f, X s) { return f.a(s); }\n\t@NonNull String testOK() {\n\t\treturn extract(i -> i, \"hallo\");\n\t}\n\t@NonNull String testERR() {\n\t\treturn extract(i -> null, \"hallo\"); // err\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 12)\n\treturn extract(i -> null, \"hallo\"); // err\n\t                    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testNullTypeInference2e() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\tString extract(Func<@Nullable String> f, @Nullable String s) { return f.a(s); }\n\t@NonNull String testWARN() {\n\t\treturn extract(i -> null, \"hallo\"); // OK to pass null\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in PolyNull.java (at line 9)\n\treturn extract(i -> null, \"hallo\"); // OK to pass null\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n");
    }

    public void testNullTypeInference2f() {
        this.runNegativeTestWithLibs(new String[]{"PolyNull.java", "import org.eclipse.jdt.annotation.*;\n\ninterface Func<T>  {\n\tT a(T i);\n}\npublic class PolyNull {\n\t<X> X extract(Func<@Nullable X> f, @Nullable X s) { return f.a(s); }\n\t@NonNull String testERR() {\n\t\treturn extract(i -> needNN(i), \"ola\");\n\t}\n\t@NonNull String needNN(@NonNull String s) { return \"\"; }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in PolyNull.java (at line 7)\n\t<X> X extract(Func<@Nullable X> f, @Nullable X s) { return f.a(s); }\n\t                                                           ^^^^^^\nNull type mismatch (type annotations): required 'X' but this expression has type '@Nullable X', where 'X' is a free type variable\n----------\n2. WARNING in PolyNull.java (at line 9)\n\treturn extract(i -> needNN(i), \"ola\");\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n3. ERROR in PolyNull.java (at line 9)\n\treturn extract(i -> needNN(i), \"ola\");\n\t                           ^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testNullTypeInference3() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion", "error");
        this.runNegativeTestWithLibs(new String[]{"Generics.java", "import org.eclipse.jdt.annotation.*;\n\npublic class Generics {\n\t<X> X m(@Nullable X a) { return null; }\n\tvoid test(@NonNull String in) {\n\t\t@NonNull String s = m(in);\n\t\tSystem.out.println(s.toLowerCase());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Generics().test(\"hallo\");\n\t}\n}\n"}, compilerOptions, "----------\n1. ERROR in Generics.java (at line 4)\n\t<X> X m(@Nullable X a) { return null; }\n\t                                ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'X'\n----------\n2. ERROR in Generics.java (at line 6)\n\t@NonNull String s = m(in);\n\t                    ^^^^^\nNull type safety (type annotations): The expression of type 'String' needs unchecked conversion to conform to '@NonNull String'\n----------\n");
    }

    public void testNullTypeInference3b() {
        this.runNegativeTestWithLibs(new String[]{"Generics.java", "import org.eclipse.jdt.annotation.*;\n\npublic class Generics {\n\t<X> @Nullable X m1(@Nullable X a) { return null; }\n\t<X> @Nullable X m2(X a) { return null; }\n\tvoid test(@NonNull String in) {\n\t\t@NonNull String s1 = m1(in);\n\t\t@NonNull String s2 = m2(in);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Generics().test(\"hallo\");\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Generics.java (at line 7)\n\t@NonNull String s1 = m1(in);\n\t                     ^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n2. ERROR in Generics.java (at line 8)\n\t@NonNull String s2 = m2(in);\n\t                     ^^^^^^\nNull type mismatch (type annotations): required '@NonNull String' but this expression has type '@Nullable String'\n----------\n");
    }

    public void testNullTypeInference3c() {
        this.runNegativeTestWithLibs(new String[]{"Generics.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n\ninterface Function<I,O> { }\nabstract class MyFunc implements Function<@NonNull Object, @Nullable String> { }\n  \npublic class Generics {\n  <@NonNull I,@Nullable O> \n  Collection<O> map1(Collection<I> in, Function<I, O> f) { return null; }\n  <@Nullable I,@NonNull O> \n  Collection<O> map2(Collection<I> in, Function<I, O> f) { return null; }\n\tvoid test(@NonNull List<Object> inList, MyFunc f) {\n\t\tCollection<@Nullable String> result = map1(inList, f);\n\t\tmap2(inList, f);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Generics.java (at line 14)\n\tmap2(inList, f);\n\t     ^^^^^^\nContradictory null annotations: method was inferred as 'Collection<@NonNull String> map2(Collection<@NonNull @Nullable Object>, Function<@NonNull @Nullable Object,@NonNull String>)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n");
    }

    public void testBug415850_01() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNull foo() {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@NonNull foo() {}\n\t         ^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void testBug415850_02() {
        this.runConformTestWithLibs(new String[]{"Callable.java", "interface Callable<T> {\n\tpublic enum Result {\n\t\tGOOD, BAD\n\t};\n\tpublic Result call(T arg);\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug415850_03() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.runConformTestWithLibs(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.util.Date;\nimport static java.lang.annotation.ElementType.*; \n@Target(TYPE_USE)\n@interface Vernal {}\ninterface I {\n\tint f(Date d);\n}\nclass X {\n\tstatic void monitorTemperature(Object myObject) {\n\t\tI i = @Vernal Date::getDay;\n\t}\n}\n"}, options, "");
    }

    public void testBug415850_04() throws Exception {
        this.runConformTestWithLibs(new String[]{"X.java", "public class X implements @B @C('i') J { }", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "J.java", "interface J {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug415850_05() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\npublic class X {\n\tpublic void foo() {\n\t\tint @Marker [][][] i = new @Marker int @Marker [2] @Marker [@Marker bar()] @Marker [];\n\t}\n\tpublic int bar() {\n\t\treturn 2;\n\t}\n}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tint @Marker [][][] i = new @Marker int @Marker [2] @Marker [@Marker bar()] @Marker [];\n\t                                                            ^^^^^^^\nSyntax error, type annotations are illegal here\n----------\n");
    }

    public void testBug415850_06() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.lang.annotation.Target;\npublic class X {\n\tpublic void foo() {\n\t\tint @Marker [][][] i = new @Marker int @Marker [2] @Marker [bar()] @Marker [];\n\t}\n\tpublic int bar() {\n\t\treturn 2;\n\t}\n}\n@Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface Marker {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug416172() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X {\n   class Y {}\n   X.@NonNull Y  foo(X.@NonNull Y xy) {\n       return new X().new Y();\n   }\n}\n\nclass Z extends X {\n   @Override\n   X.@NonNull Y  foo(X.Y xy) {\n       return null;\n   }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 12)\n\tX.@NonNull Y  foo(X.Y xy) {\n\t                  ^^^\nMissing non-null annotation: inherited method from X specifies this parameter as @NonNull\n----------\n2. ERROR in X.java (at line 13)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required 'X.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testBug416174() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped", "ignore");
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class X {\n\tvoid  foo1(List<X> lx) {}\n\tvoid  foo2(List<@NonNull X> lx) {}\n\tvoid  foo3(List<@Nullable X> lx) {}\n\tvoid  foo4(@NonNull List<@Nullable X> lx) {}\n}\n\nclass Z extends X {\n\t@Override void foo1(List<@NonNull X> xy) {}\n\t@Override void foo2(List<X> lx) {}\n\t@Override void foo3(List<X> lx) {}\n\t@Override void foo4(List<@Nullable X> lx) {}\n}\n"}, options, "----------\n1. ERROR in X.java (at line 12)\n\tclass Z extends X {\n\t      ^\nThe method foo1(List<@NonNull X>) from Z cannot implement the corresponding method from X due to incompatible nullness constraints\n----------\n2. ERROR in X.java (at line 12)\n\tclass Z extends X {\n\t      ^\nThe method foo2(List<X>) from Z cannot implement the corresponding method from X due to incompatible nullness constraints\n----------\n3. ERROR in X.java (at line 12)\n\tclass Z extends X {\n\t      ^\nThe method foo3(List<X>) from Z cannot implement the corresponding method from X due to incompatible nullness constraints\n----------\n");
    }

    public void testBug416174b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.*;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic abstract class X {\n\tList<X> foo1() {\n\t\treturn null;\n\t}\n\tList<@Nullable X> foo2() {\n\t\treturn null;\n\t}\n\tabstract @NonNull List<@NonNull X> foo3();\n\tList<@Nullable X> foo4() {\n\t\treturn null;\n\t}\n}\n\nabstract class Z extends X {\n\t@Override\n\tList<@NonNull X> foo1() {\n\t\treturn null;\n\t}\n\t@Override\n\tList<@NonNull X> foo2() {\n\t\treturn null;\n\t}\n\t@Override\n\t@NonNull List<X> foo3() {\n\t\treturn new ArrayList<>();\n\t}\n\t@Override\n\t@NonNull List<@Nullable X> foo4() {\n\t\treturn new ArrayList<>();\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 18)\n\tabstract class Z extends X {\n\t               ^\nThe method List<@NonNull X> foo1() from Z cannot implement the corresponding method from X due to incompatible nullness constraints\n----------\n2. ERROR in X.java (at line 18)\n\tabstract class Z extends X {\n\t               ^\nThe method List<@NonNull X> foo2() from Z cannot implement the corresponding method from X due to incompatible nullness constraints\n----------\n3. ERROR in X.java (at line 18)\n\tabstract class Z extends X {\n\t               ^\nThe method @NonNull List<X> foo3() from Z cannot implement the corresponding method from X due to incompatible nullness constraints\n----------\n");
    }

    public void testBug416175() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<@NonNull ? extends @NonNull String> ls = new ArrayList<String>();\n\t\tls.add(null);\n\t\t@NonNull String s = ls.get(0);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 8)\n\tList<@NonNull ? extends @NonNull String> ls = new ArrayList<String>();\n\t                                              ^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to 'List<@NonNull ? extends @NonNull String>'\n----------\n2. ERROR in X.java (at line 9)\n\tls.add(null);\n\t       ^^^^\nNull type mismatch: required '@NonNull ? extends @NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug416176() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<@NonNull T> {\n\tT foo(T t) {\n\t\treturn t;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug416176a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<@NonNull T> {\n\tT foo(T t) {\n\t\treturn t;\n\t}\n\t@NonNull T bar1(@NonNull T t) {\n\t\treturn t;\n\t}\n\t@NonNull T bar2(@Nullable T t) { // argument: contradiction (1)\n\t\treturn t;\n\t}\n\t@Nullable T bar3(T t) { // return type: contradiction (2)\n\t\t@Nullable T l = t; // local: contradiction (3)\n\t\treturn l;\n\t}\n\tclass Inner {\n\t\t@Nullable T f; // field: contradiction (4)\n\t}\n\tT bar3() {\n\t\treturn null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 11)\n\t@NonNull T bar2(@Nullable T t) { // argument: contradiction (1)\n\t                ^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n2. ERROR in X.java (at line 14)\n\t@Nullable T bar3(T t) { // return type: contradiction (2)\n\t^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n3. ERROR in X.java (at line 15)\n\t@Nullable T l = t; // local: contradiction (3)\n\t^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n4. ERROR in X.java (at line 19)\n\t@Nullable T f; // field: contradiction (4)\n\t^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n5. ERROR in X.java (at line 22)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n");
    }

    public void testBug416176b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<T> {\n\t@NonNull T bar(@NonNull T t) {\n\t\treturn t;\n\t}\n\t@NonNull T bar(@Nullable T t) {\n\t\treturn t;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 5)\n\t@NonNull T bar(@NonNull T t) {\n\t           ^^^^^^^^^^^^^^^^^\nDuplicate method bar(T) in type X<T>\n----------\n2. ERROR in X.java (at line 8)\n\t@NonNull T bar(@Nullable T t) {\n\t           ^^^^^^^^^^^^^^^^^^\nDuplicate method bar(T) in type X<T>\n----------\n");
    }

    public void testBug416180() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n\tT foo(T t) {\n\t\treturn t;\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new Y();\n\t}\n} \n\nclass Y extends X<@NonNull String> {\n   @Override\n\t@NonNull String foo(java.lang.@NonNull String t) {\n\t\treturn \"\";\n\t};\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug416181() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n\tclass Y {\n\t\t\n\t}\n\t\n\tX<String>.@NonNull Y y = null; // 1st error here.\n\t\n\t@NonNull Y y2 = null; // 2nd error here.\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\tX<String>.@NonNull Y y = null; // 1st error here.\n\t                         ^^^^\nNull type mismatch: required 'X<String>.@NonNull Y' but the provided value is null\n----------\n2. ERROR in X.java (at line 10)\n\t@NonNull Y y2 = null; // 2nd error here.\n\t                ^^^^\nNull type mismatch: required 'X<T>.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testBug416182() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<T> {\n\tT foo(@NonNull T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<@Nullable String> xs = new X<String>();\n\t\txs.foo(null);\n\t}\n\t\n\tpublic void test(X<String> x) {\n\t\tX<@Nullable String> xs = x;\n\t\txs.bar(null);\n\t}\n\tpublic void bar(T t) {}\n\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 10)\n\txs.foo(null);\n\t^^^^^^^^^^^^\nContradictory null annotations: method was inferred as '@Nullable String foo(@NonNull @Nullable String)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n2. WARNING in X.java (at line 14)\n\tX<@Nullable String> xs = x;\n\t                         ^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to 'X<@Nullable String>'\n----------\n");
    }

    public void testBug416182a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class X<T> {\n\tT foo(@NonNull T t) {\n\t\treturn t;\n\t}\n\tvoid foo() {}\n\tpublic static void main(String[] args) {\n\t\tX<@Nullable String> xs = new X<String>();\n\t\txs.foo();\n\t\txs.foo(null);\n\t}\n\t\n\tpublic void test(X<String> x) {\n\t\tX<@Nullable String> xs = x;\n\t\txs.bar(null);\n\t}\n\tpublic void bar(T t) {}\n\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 12)\n\txs.foo(null);\n\t^^^^^^^^^^^^\nContradictory null annotations: method was inferred as '@Nullable String foo(@NonNull @Nullable String)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n2. WARNING in X.java (at line 16)\n\tX<@Nullable String> xs = x;\n\t                         ^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to 'X<@Nullable String>'\n----------\n");
    }

    public void testBug416183() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n\tT foo(@NonNull T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> xs = new X<String>();\n\t\txs.foo(\"\");\n\t}\n\t\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testSubstitution() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport java.util.List;\nimport java.util.ArrayList;\npublic class X<T> {\n\tT foo(@NonNull List<@NonNull T> l) {\n\t\treturn l.get(0);\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tX<String> s = new X<>();\n\t\ts.foo(new ArrayList<String>()); // (1)\n\t\ts.foo(null); // (2)\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 10)\n\ts.foo(new ArrayList<String>()); // (1)\n\t      ^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'ArrayList<String>' needs unchecked conversion to conform to '@NonNull List<@NonNull String>'\n----------\n2. ERROR in X.java (at line 11)\n\ts.foo(null); // (2)\n\t      ^^^^\nNull type mismatch: required '@NonNull List<@NonNull String>' but the provided value is null\n----------\n");
    }

    public void testSubstitution2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class X<T> {\n\tT foo(@NonNull T @NonNull [] l) {\n\t\treturn l[0];\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tX<String> s = new X<>();\n       s.foo(new String [] { null });\n       s.foo(new String @Nullable [] { null });\n       s.foo(new String @NonNull [] { null });\n       s.foo(new @Nullable String @NonNull [] { null });\n       s.foo(new @NonNull String @NonNull [] { \"\" });\n\t\ts.foo(null); // (2)\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 9)\n\ts.foo(new String [] { null });\n\t      ^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String[]' needs unchecked conversion to conform to '@NonNull String @NonNull[]'\n----------\n2. WARNING in X.java (at line 10)\n\ts.foo(new String @Nullable [] { null });\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @Nullable[]' needs unchecked conversion to conform to '@NonNull String @NonNull[]'\n----------\n3. WARNING in X.java (at line 11)\n\ts.foo(new String @NonNull [] { null });\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'String @NonNull[]' needs unchecked conversion to conform to '@NonNull String @NonNull[]'\n----------\n4. ERROR in X.java (at line 12)\n\ts.foo(new @Nullable String @NonNull [] { null });\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull String @NonNull[]' but this expression has type '@Nullable String @NonNull[]'\n----------\n5. ERROR in X.java (at line 14)\n\ts.foo(null); // (2)\n\t      ^^^^\nNull type mismatch: required '@NonNull String @NonNull[]' but the provided value is null\n----------\n");
    }

    public void testSubstitution3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class X<T> {\n\tT foo(@NonNull T l) {\n\t\treturn l;\n\t}\t\n\tpublic static void main(String[] args) {\n\t\tX<String> s = new X<>();\n       s.foo(null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\ts.foo(null);\n\t      ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testSubstitution4() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNull;\n@Target(ElementType.TYPE_USE)\n@interface TypeAnnotation {\n}\npublic class X<T> {\n    class Y {}\n    void foo(@TypeAnnotation X<T>.@NonNull Y l) {\n    }\t\n    public static void main(String[] args) {\n        X<String> s = new X<>();\n        s.foo(null);\n    }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 13)\n\ts.foo(null);\n\t      ^^^^\nNull type mismatch: required 'X<String>.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testSubstitution5() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class X<T> {\n    void foo(@NonNull X<@NonNull ? extends T> p) {\n    }\t\n    public static void main(String[] args) {\n        X<String> s = new X<>();\n        X<@NonNull String> s2 = new X<@NonNull String>();\n        s.foo(s);\n        s.foo(s2);\n    }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 8)\n\ts.foo(s);\n\t      ^\nNull type safety (type annotations): The expression of type 'X<String>' needs unchecked conversion to conform to '@NonNull X<@NonNull ? extends String>'\n----------\n");
    }

    public void testArray1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n   \n\tpublic static void main(String[] args) {\n\t\t@NonNull String @NonNull [] s = new @NonNull String [] { null };\n\t\tif (s != null && s[0] != null) {\n\t\t\tSystem.out.println(\"Not null\");\n\t\t}\n\t\tSystem.out.println(\"Length = \" + s[0].length());\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\t@NonNull String @NonNull [] s = new @NonNull String [] { null };\n\t                                                         ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in X.java (at line 7)\n\tif (s != null && s[0] != null) {\n\t    ^\nRedundant null check: comparing '@NonNull String @NonNull[]' against null\n----------\n3. ERROR in X.java (at line 7)\n\tif (s != null && s[0] != null) {\n\t                 ^^^^\nRedundant null check: comparing '@NonNull String' against null\n----------\n");
    }

    public void testArray2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n   \n\tpublic static void main(String[] args) {\n\t\t@NonNull String @NonNull [][] s1 = new @NonNull String @NonNull [][] { null, { null} }; // problem at inner null\n\t\t@NonNull String @NonNull [][] s2 = new @NonNull String [] @NonNull [] { null, { null} }; // problem at both nulls\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\t@NonNull String @NonNull [][] s1 = new @NonNull String @NonNull [][] { null, { null} }; // problem at inner null\n\t                                                                               ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n2. ERROR in X.java (at line 7)\n\t@NonNull String @NonNull [][] s2 = new @NonNull String [] @NonNull [] { null, { null} }; // problem at both nulls\n\t                                                                        ^^^^\nNull type mismatch: required '@NonNull String @NonNull[]' but the provided value is null\n----------\n3. ERROR in X.java (at line 7)\n\t@NonNull String @NonNull [][] s2 = new @NonNull String [] @NonNull [] { null, { null} }; // problem at both nulls\n\t                                                                                ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testArray3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\n\npublic class X<T> {\n   \n\tpublic static void main(String[] args) {\n\t\t@NonNull String [][] @NonNull [] s = new @NonNull String []@NonNull [][] { null, { {null}, null/*ok*/ } };\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 6)\n\t@NonNull String [][] @NonNull [] s = new @NonNull String []@NonNull [][] { null, { {null}, null/*ok*/ } };\n\t                                     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type '@NonNull String [] @NonNull[] []' needs unchecked conversion to conform to '@NonNull String [] [] @NonNull[]'\n----------\n2. ERROR in X.java (at line 6)\n\t@NonNull String [][] @NonNull [] s = new @NonNull String []@NonNull [][] { null, { {null}, null/*ok*/ } };\n\t                                                                           ^^^^\nNull type mismatch: required '@NonNull String @NonNull[] []' but the provided value is null\n----------\n3. ERROR in X.java (at line 6)\n\t@NonNull String [][] @NonNull [] s = new @NonNull String []@NonNull [][] { null, { {null}, null/*ok*/ } };\n\t                                                                                    ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n");
    }

    public void testBug417759() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n\npublic class X<T> {\n\tvoid foo(@NonNull X<@NonNull ?> l) { \n\t}\t\n\tpublic static void main(String[] args) {\n\t\t@NonNull X<String> s = new X<>();\n       s.foo(s);  // String vs. @NonNull ?\n       @NonNull X<@Nullable String> s2 = new X<>();\n\t\ts.foo(s2); // @Nullable String vs. @NonNull ?\n       @NonNull X<@NonNull String> s3 = new X<>();\n\t\ts.foo(s3); // good\n\t}\n}"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 8)\n\ts.foo(s);  // String vs. @NonNull ?\n\t      ^\nNull type safety (type annotations): The expression of type '@NonNull X<String>' needs unchecked conversion to conform to '@NonNull X<@NonNull ?>'\n----------\n2. ERROR in X.java (at line 10)\n\ts.foo(s2); // @Nullable String vs. @NonNull ?\n\t      ^^\nNull type mismatch (type annotations): required '@NonNull X<@NonNull ?>' but this expression has type '@NonNull X<@Nullable String>'\n----------\n");
    }

    public void testTypeVariable1() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNull;\n@Target(ElementType.TYPE_USE)\n@interface Junk {\n}\npublic class X<@NonNull T> {\n\tT t = null;\n\t@Junk T t2 = null;\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 8)\n\tT t = null;\n\t      ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n2. ERROR in X.java (at line 9)\n\t@Junk T t2 = null;\n\t             ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n");
    }

    public void testTypeVariable2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X<T> {\n\tvoid consumeAny(T t) {\n\t\tconsume(t); // error, t can be null\n\t\tconsumeObject(t); // error, t can be null\n\t}\n\tvoid consumeNullable(@Nullable T t) {\n\t\tconsume(t); // error, both sides explicit, mismatch\n\t\tconsumeObject(t); // error, both sides explicit, mismatch\n\t}\n\tvoid consume(@NonNull T t) {}\n\tvoid consumeObject(@NonNull Object o) {}\n\tT produce() {\n\t\treturn null; // error, T may not accept null\n\t}\n\tT produceFromNullable(@Nullable T t) {\n\t\treturn t; // error, T may not accept nullable\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 4)\n\tconsume(t); // error, t can be null\n\t        ^\nNull type safety (type annotations): The expression of type 'T' needs unchecked conversion to conform to '@NonNull T'\n----------\n2. WARNING in X.java (at line 5)\n\tconsumeObject(t); // error, t can be null\n\t              ^\nNull type safety (type annotations): The expression of type 'T' needs unchecked conversion to conform to '@NonNull Object'\n----------\n3. ERROR in X.java (at line 8)\n\tconsume(t); // error, both sides explicit, mismatch\n\t        ^\nNull type mismatch (type annotations): required '@NonNull T' but this expression has type '@Nullable T'\n----------\n4. ERROR in X.java (at line 9)\n\tconsumeObject(t); // error, both sides explicit, mismatch\n\t              ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable T'\n----------\n5. ERROR in X.java (at line 14)\n\treturn null; // error, T may not accept null\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n6. ERROR in X.java (at line 17)\n\treturn t; // error, T may not accept nullable\n\t       ^\nNull type mismatch (type annotations): required 'T' but this expression has type '@Nullable T', where 'T' is a free type variable\n----------\n");
    }

    public void testTypeVariable3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X<T extends Number> {\n\tvoid consumeAny(T t) {\n\t\tconsume(t); // error, t can be null\n\t\tconsumeObject(t); // error, t can be null\n\t}\n\tvoid consumeNullable(@Nullable T t) {\n\t\tconsume(t); // error, both sides explicit, mismatch\n\t\tconsumeObject(t); // error, both sides explicit, mismatch\n\t}\n\tvoid consume(@NonNull T t) {}\n\tvoid consumeObject(@NonNull Object o) {}\n\tT produce() {\n\t\treturn null; // error, T may not accept null\n\t}\n\tT produceFromNullable(@Nullable T t) {\n\t\treturn t; // error, T may not accept nullable\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 4)\n\tconsume(t); // error, t can be null\n\t        ^\nNull type safety (type annotations): The expression of type 'T extends Number' needs unchecked conversion to conform to '@NonNull T extends Number'\n----------\n2. WARNING in X.java (at line 5)\n\tconsumeObject(t); // error, t can be null\n\t              ^\nNull type safety (type annotations): The expression of type 'T extends Number' needs unchecked conversion to conform to '@NonNull Object'\n----------\n3. ERROR in X.java (at line 8)\n\tconsume(t); // error, both sides explicit, mismatch\n\t        ^\nNull type mismatch (type annotations): required '@NonNull T extends Number' but this expression has type '@Nullable T extends Number'\n----------\n4. ERROR in X.java (at line 9)\n\tconsumeObject(t); // error, both sides explicit, mismatch\n\t              ^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable T extends Number'\n----------\n5. ERROR in X.java (at line 14)\n\treturn null; // error, T may not accept null\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable 'T'\n----------\n6. ERROR in X.java (at line 17)\n\treturn t; // error, T may not accept nullable\n\t       ^\nNull type mismatch (type annotations): required 'T' but this expression has type '@Nullable T extends Number', where 'T' is a free type variable\n----------\n");
    }

    public void testTypeVariable4() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.*;\nimport org.eclipse.jdt.annotation.*;\n@Target(ElementType.TYPE_USE) @interface TypeMarker {}\npublic class X<T> {\n\tT passThrough1(@TypeMarker T t) {\n\t\treturn t; // OK\n\t}\n\t@TypeMarker T passThrough2(T t) {\n\t\treturn t; // OK\n\t}\n\t@TypeMarker T passThrough3(@Nullable @TypeMarker T t) {\n\t\treturn t; // Not OK\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 12)\n\treturn t; // Not OK\n\t       ^\nNull type mismatch (type annotations): required 'T' but this expression has type '@Nullable T', where 'T' is a free type variable\n----------\n");
    }

    public void testTypeVariable5() {
        this.runConformTestWithLibs(new String[]{"ExFunction.java", "@FunctionalInterface\npublic interface ExFunction<T, R, E extends Exception> {\n\tR apply(T t1) throws E;\n\n\tdefault <V>  ExFunction<V, R, E> compose(ExFunction<? super V, ? extends T, E> before) {\n\t\tjava.util.Objects.requireNonNull(before);\n\t\t//warning on before.apply(v):\n\t\t//Null type safety (type annotations): The expression of type 'capture#of ? extends T' needs unchecked conversion to conform to 'T'\n\t\treturn (V v) -> apply(before.apply(v));\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testSE7AnnotationCopy() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNull;\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\npublic class X {\n\tclass Y {}\n\tvoid foo(@T X.@NonNull Y p) {\n\t\tfoo(null);\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 10)\n\tfoo(null);\n\t    ^^^^\nNull type mismatch: required 'X.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testWildcardCapture() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport java.util.ArrayList;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.NonNull;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n       List<X> ax = new ArrayList<X>();\n       ax.add(new X());\n\t\tList<? extends X> lx = ax;\n\t\tgetAdd(lx);\n\t}\n\tstatic <@NonNull P>  void getAdd(List<P> lt) {\n\t\tlt.add(lt.get(0));\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 16)\n\tgetAdd(lx);\n\t       ^^\nNull type safety (type annotations): The expression of type 'List<capture#of ? extends X>' needs unchecked conversion to conform to 'List<@NonNull capture#of ? extends X>'\n----------\n");
    }

    public void testWildcardCapture2() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport java.util.ArrayList;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.NonNull;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n       List<@NonNull X> ax = new ArrayList<@NonNull X>();\n       ax.add(new X());\n\t\tList<@NonNull ? extends X> lx = ax;\n\t\tgetAdd(lx);\n\t}\n\tstatic <@NonNull P>  void getAdd(List<P> lt) {\n\t\tlt.add(lt.get(0));\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testWildcardCapture3() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport java.util.ArrayList;\nimport java.util.List;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n       List<@Nullable X> ax = new ArrayList<@Nullable X>();\n       ax.add(new X());\n\t\tList<@Nullable ? extends X> lx = ax;\n\t\tgetAdd(lx);\n\t}\n\tstatic <@NonNull P>  void getAdd(List<P> lt) {\n\t\tlt.add(lt.get(0));\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 17)\n\tgetAdd(lx);\n\t       ^^\nContradictory null annotations: method was inferred as 'void getAdd(List<@NonNull @Nullable capture#of @Nullable ? extends X>)', but only one of '@NonNull' and '@Nullable' can be effective at any location\n----------\n");
    }

    public void testLocalArrays() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n       class L {};\n       L @NonNull [] @Nullable [] la = new L[5][];\n       L @Nullable [] @NonNull [] la2 = new L[3][];\n       la = la2;\n   }\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 13)\n\tL @NonNull [] @Nullable [] la = new L[5][];\n\t                                ^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'L[][]' needs unchecked conversion to conform to 'L @NonNull[] @Nullable[]'\n----------\n2. WARNING in X.java (at line 14)\n\tL @Nullable [] @NonNull [] la2 = new L[3][];\n\t                                 ^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'L[][]' needs unchecked conversion to conform to 'L @Nullable[] @NonNull[]'\n----------\n3. ERROR in X.java (at line 15)\n\tla = la2;\n\t     ^^^\nNull type mismatch (type annotations): required 'L @NonNull[] @Nullable[]' but this expression has type 'L @Nullable[] @NonNull[]'\n----------\n");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n       class L {};\n       L [] [] la = new L[5][];\n       L []  [] la2 = new L[3][];\n       la = la2;\n       System.out.println(\"Done\");\n   }\n}\n"}, "Done");
    }

    public void testRawType() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNull;\npublic class X<T> {\n\tclass Y <P> {}\n\tpublic static void main(String[] args) {\n\t\t@NonNull X x = null;\n\t\tX.@NonNull Y xy = null;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in X.java (at line 5)\n\t@NonNull X x = null;\n\t         ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\t@NonNull X x = null;\n\t               ^^^^\nNull type mismatch: required '@NonNull X' but the provided value is null\n----------\n3. WARNING in X.java (at line 6)\n\tX.@NonNull Y xy = null;\n\t^^^^^^^^^^^^\nX.Y is a raw type. References to generic type X<T>.Y<P> should be parameterized\n----------\n4. ERROR in X.java (at line 6)\n\tX.@NonNull Y xy = null;\n\t                  ^^^^\nNull type mismatch: required 'X.@NonNull Y' but the provided value is null\n----------\n");
    }

    public void test420456() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tInteger [] array = new Integer[] { 1234, 5678, 789 };\n\t\tArrays.sort(array, Integer::compare);\n       System.out.println(\"\" + array[0] + array[1] + array[2]);\n\t}\n}\n"}, this.getCompilerOptions(), "78912345678");
    }

    public void test422134() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collections;\npublic class X {\n\tpublic static void main(String args[]) {\n\t\tCollections.sort(new ArrayList(), (o1, o2) -> {\n\t\t\treturn o1.compareToIgnoreCase(o1);\n\t\t});\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tCollections.sort(new ArrayList(), (o1, o2) -> {\n\t\t\treturn o1.compareToIgnoreCase(o1);\n\t\t});\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation sort(ArrayList, (<no type> o1, <no type> o2) -> {}) of the generic method sort(List<T>, Comparator<? super T>) of type Collections\n----------\n2. WARNING in X.java (at line 5)\n\tCollections.sort(new ArrayList(), (o1, o2) -> {\n\t                 ^^^^^^^^^^^^^^^\nType safety: The expression of type ArrayList needs unchecked conversion to conform to List<Object>\n----------\n3. WARNING in X.java (at line 5)\n\tCollections.sort(new ArrayList(), (o1, o2) -> {\n\t                     ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n4. ERROR in X.java (at line 6)\n\treturn o1.compareToIgnoreCase(o1);\n\t          ^^^^^^^^^^^^^^^^^^^\nThe method compareToIgnoreCase(Object) is undefined for the type Object\n----------\n", null, true, this.getCompilerOptions());
    }

    public void testBug424725() {
        this.runConformTest(new String[]{"AnnotatedRecordMapper.java", "import java.lang.invoke.MethodHandle;\n\npublic final class AnnotatedRecordMapper<T> {\n  private MethodHandle afterLoadStore;\n\n  public void invokeAfterLoadStore(Object object, Object database) {\n    if(afterLoadStore != null) {\n      try {\n        afterLoadStore.invoke(object, database);\n      }\n      catch(Throwable e) {\n        throw new RuntimeException(e);\n      }\n    }\n  }\n}"});
    }

    public void testBug424727() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "@org.eclipse.jdt.annotation.NonNull public class X {\n\tstatic X singleton = new X();\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 1)\n\t@org.eclipse.jdt.annotation.NonNull public class X {\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe nullness annotation 'NonNull' is not applicable at this location\n----------\n");
    }

    public void testBug424637() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.io.IOException;\nimport java.nio.file.Files;\nimport java.nio.file.Path;\nimport java.util.function.Function;\nimport java.util.stream.Stream;\n\npublic class X {\n  public static void method() {\n    Function<Path, Stream<Path>> method = Files::walk;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tFunction<Path, Stream<Path>> method = Files::walk;\n\t                                      ^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n");
    }

    public void testBug424637a() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.nio.file.FileVisitOption;\nimport java.nio.file.Path;\nimport java.util.function.BiFunction;\nimport java.util.stream.Stream;\nimport org.eclipse.jdt.annotation.*;\n\ninterface TriFunc<A,B,C,D> { D apply(A a, B b, C c); }\npublic class X {\n  public static Stream<Path> myWalk(Path p, @NonNull FileVisitOption ... options) { return null; }\n  public static void method() {\n    BiFunction<Path, @Nullable FileVisitOption, Stream<Path>> method1 = X::myWalk;\n    BiFunction<Path, @Nullable FileVisitOption[], Stream<Path>> method2 = X::myWalk;\n    BiFunction<Path, FileVisitOption[], Stream<Path>> method3 = X::myWalk;\n \t TriFunc<Path, @NonNull FileVisitOption, @Nullable FileVisitOption, Stream<Path>> method4 = X::myWalk;\n  }\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tBiFunction<Path, @Nullable FileVisitOption, Stream<Path>> method1 = X::myWalk;\n\t                                                                    ^^^^^^^^^\nNull type mismatch at parameter 2: required '@NonNull FileVisitOption' but provided '@Nullable FileVisitOption' via method descriptor BiFunction<Path,FileVisitOption,Stream<Path>>.apply(Path, FileVisitOption)\n----------\n2. ERROR in X.java (at line 12)\n\tBiFunction<Path, @Nullable FileVisitOption[], Stream<Path>> method2 = X::myWalk;\n\t                                                                      ^^^^^^^^^\nNull type mismatch at parameter 2: required '@NonNull FileVisitOption []' but provided '@Nullable FileVisitOption []' via method descriptor BiFunction<Path,FileVisitOption[],Stream<Path>>.apply(Path, FileVisitOption[])\n----------\n3. WARNING in X.java (at line 13)\n\tBiFunction<Path, FileVisitOption[], Stream<Path>> method3 = X::myWalk;\n\t                                                            ^^^^^^^^^\nNull type safety: parameter 2 provided via method descriptor BiFunction<Path,FileVisitOption[],Stream<Path>>.apply(Path, FileVisitOption[]) needs unchecked conversion to conform to '@NonNull FileVisitOption []'\n----------\n4. ERROR in X.java (at line 14)\n\tTriFunc<Path, @NonNull FileVisitOption, @Nullable FileVisitOption, Stream<Path>> method4 = X::myWalk;\n\t                                                                                           ^^^^^^^^^\nNull type mismatch at parameter 3: required '@NonNull FileVisitOption' but provided '@Nullable FileVisitOption' via method descriptor TriFunc<Path,FileVisitOption,FileVisitOption,Stream<Path>>.apply(Path, FileVisitOption, FileVisitOption)\n----------\n");
    }

    public void testBug424637_comment3() {
        this.runConformTest(new String[]{"VarArgsMethodReferenceTest.java", "import java.util.function.Consumer;\npublic class VarArgsMethodReferenceTest {\n  @SuppressWarnings(\"unused\") public static void main(String[] argv) {\n    Consumer<String> printffer;\n    printffer = System.out::printf;\n  }\n}"});
    }

    public void testBug427163() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid consume(@NonNull String @Nullable... strings) {\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug427163b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tvoid consume1(@NonNull @Nullable String @Nullable[] strings) {}\n\tvoid consume2(@Nullable String @NonNull @Nullable... strings) {}\n\tvoid consume3(@Nullable String[] @NonNull @Nullable[] strings) {}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 3)\n\tvoid consume1(@NonNull @Nullable String @Nullable[] strings) {}\n\t                       ^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n2. ERROR in X.java (at line 4)\n\tvoid consume2(@Nullable String @NonNull @Nullable... strings) {}\n\t                               ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n3. ERROR in X.java (at line 5)\n\tvoid consume3(@Nullable String[] @NonNull @Nullable[] strings) {}\n\t                                 ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n");
    }

    public void testBug427163c() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tString[][] strings0 = new @NonNull String @Nullable[] @Nullable[] {};\n\tString[] strings1 = new String @NonNull @Nullable[] {};\n\tObject[] objects2 = new Object @NonNull @Nullable[1];\n\tString[] strings3 = new @NonNull @Nullable String [1];\n\tString[] strings4 = new @NonNull String  @Nullable @NonNull[1];\n\tString[][] strings5 = new String[] @NonNull @Nullable[] {};\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tString[] strings1 = new String @NonNull @Nullable[] {};\n\t                               ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n2. ERROR in X.java (at line 5)\n\tObject[] objects2 = new Object @NonNull @Nullable[1];\n\t                               ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n3. ERROR in X.java (at line 6)\n\tString[] strings3 = new @NonNull @Nullable String [1];\n\t                        ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n4. ERROR in X.java (at line 7)\n\tString[] strings4 = new @NonNull String  @Nullable @NonNull[1];\n\t                                         ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n5. ERROR in X.java (at line 8)\n\tString[][] strings5 = new String[] @NonNull @Nullable[] {};\n\t                                   ^^^^^^^^^^^^^^^^^^\nContradictory null specification; only one of @NonNull and @Nullable can be specified at any location\n----------\n");
    }

    public void testTypeBounds1() {
        this.runNegativeTestWithLibs(new String[]{"C.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass A { }\nclass B extends A {}\npublic class C {\n\t\n\t@NonNull A testExtends(List<@NonNull B> lb1, List<@Nullable B> lb2, boolean f) {\n\t\tList<? extends @NonNull A> la1 = lb1;\n\t\tla1.add(null); // ERR1\n\t\tif (la1.size() > 0)\n\t\t\treturn la1.get(0); // OK\n\t\tla1 = lb2; // ERR2\n\t\tList<? extends @Nullable A> la2 = lb1; // OK\n\t\tla2.add(null); // ERR3\n\t\tif (la2.size() > 0)\n\t\t\treturn la2.get(0); // ERR4\n\t\tla2 = lb2; // OK\n\t\tif (f)\n\t\t\treturn mExtends1(lb1); // OK, since we infer T to @NonNull B\n\t\treturn mExtends2(lb1);\n\t}\n\t<T extends @Nullable A> T mExtends1(List<T> t) { return null; /*ERR5*/ }\n\t<T extends @NonNull A> T mExtends2(List<T> t) { return null; /*ERR6*/ }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 12)\n\tla1.add(null); // ERR1\n\t        ^^^^\nNull type mismatch: required '? extends @NonNull A' but the provided value is null\n----------\n2. ERROR in C.java (at line 15)\n\tla1 = lb2; // ERR2\n\t      ^^^\nNull type mismatch (type annotations): required 'List<? extends @NonNull A>' but this expression has type 'List<@Nullable B>'\n----------\n3. ERROR in C.java (at line 17)\n\tla2.add(null); // ERR3\n\t        ^^^^\nNull type mismatch: required '? extends @Nullable A' but the provided value is null\n----------\n4. ERROR in C.java (at line 19)\n\treturn la2.get(0); // ERR4\n\t       ^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull A' but this expression has type 'capture#of ? extends @Nullable A'\n----------\n5. ERROR in C.java (at line 25)\n\t<T extends @Nullable A> T mExtends1(List<T> t) { return null; /*ERR5*/ }\n\t                                                        ^^^^\nNull type mismatch: required 'T extends @Nullable A' but the provided value is null\n----------\n6. ERROR in C.java (at line 26)\n\t<T extends @NonNull A> T mExtends2(List<T> t) { return null; /*ERR6*/ }\n\t                                                       ^^^^\nNull type mismatch: required 'T extends @NonNull A' but the provided value is null\n----------\n");
    }

    public void testTypeBounds2() {
        this.runNegativeTestWithLibs(new String[]{"C.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass A { }\nclass B extends A {}\npublic class C {\n\t\n\t@NonNull Object testSuper(List<@Nullable A> la1, List<@NonNull A> la2, boolean f) {\n\t\tList<? super @NonNull B> lb1 = la1; // OK\n\t\tlb1.add(null); // ERR1\n\t\tif (lb1.size() > 0)\n\t\t\treturn lb1.get(0); // ERR2\n\t\tlb1 = la2; // OK\n\t\tList<? super @Nullable B> lb2 = la1;\n\t\tlb2.add(null);\n\t\tif (lb2.size() > 0)\n\t\t\treturn lb2.get(0); // ERR3\n\t\tlb2 = la2; // ERR4\n\t\tif (f)\n\t\t\treturn mSuper1(la1); // ERR5\n\t\treturn mSuper2(la1); // ERR6 on arg\n\t}\n\t<T extends @Nullable A> T mSuper1(List<T> t) { return null; /*ERR7*/ }\n\t<T extends @NonNull A> T mSuper2(List<T> t) { return null; /*ERR8*/ }\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 12)\n\tlb1.add(null); // ERR1\n\t        ^^^^\nNull type mismatch: required '? super @NonNull B' but the provided value is null\n----------\n2. ERROR in C.java (at line 14)\n\treturn lb1.get(0); // ERR2\n\t       ^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'capture#of ? super @NonNull B'\n----------\n3. ERROR in C.java (at line 19)\n\treturn lb2.get(0); // ERR3\n\t       ^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type 'capture#of ? super @Nullable B'\n----------\n4. ERROR in C.java (at line 20)\n\tlb2 = la2; // ERR4\n\t      ^^^\nNull type mismatch (type annotations): required 'List<? super @Nullable B>' but this expression has type 'List<@NonNull A>'\n----------\n5. ERROR in C.java (at line 22)\n\treturn mSuper1(la1); // ERR5\n\t       ^^^^^^^^^^^^\nNull type mismatch (type annotations): required '@NonNull Object' but this expression has type '@Nullable A'\n----------\n6. ERROR in C.java (at line 23)\n\treturn mSuper2(la1); // ERR6 on arg\n\t               ^^^\nNull type mismatch (type annotations): required 'List<@NonNull A>' but this expression has type 'List<@Nullable A>'\n----------\n7. ERROR in C.java (at line 25)\n\t<T extends @Nullable A> T mSuper1(List<T> t) { return null; /*ERR7*/ }\n\t                                                      ^^^^\nNull type mismatch: required 'T extends @Nullable A' but the provided value is null\n----------\n8. ERROR in C.java (at line 26)\n\t<T extends @NonNull A> T mSuper2(List<T> t) { return null; /*ERR8*/ }\n\t                                                     ^^^^\nNull type mismatch: required 'T extends @NonNull A' but the provided value is null\n----------\n");
    }

    public void testTypeBounds3() {
        this.runNegativeTestWithLibs(new String[]{"C.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass A { }\nclass B extends A {}\npublic class C {\n\t\n\tvoid testExtends(List<? extends @NonNull B> lb1, List<? extends @Nullable B> lb2) {\n\t\tList<? extends @NonNull A> la1 = lb1;\n\t\tla1 = lb2; // ERR\n\t\tList<? extends @Nullable A> la2 = lb1;\n\t\tla2 = lb2;\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 12)\n\tla1 = lb2; // ERR\n\t      ^^^\nNull type mismatch (type annotations): required 'List<? extends @NonNull A>' but this expression has type 'List<capture#of ? extends @Nullable B>'\n----------\n");
    }

    public void testTypeBounds4() {
        this.runNegativeTestWithLibs(new String[]{"C.java", "import java.util.List;\n\nimport org.eclipse.jdt.annotation.NonNull;\nimport org.eclipse.jdt.annotation.Nullable;\n\nclass A { }\nclass B extends A {}\npublic class C {\n\t\n\tvoid testSuper(List<? super @Nullable A> la1, List<? super @NonNull A> la2) {\n\t\tList<? super @NonNull B> lb1 = la1; // OK\n\t\tlb1 = la2; // OK\n\t\tList<? super @Nullable B> lb2 = la1;\n\t\tlb2 = la2; // ERR4\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 14)\n\tlb2 = la2; // ERR4\n\t      ^^^\nNull type mismatch (type annotations): required 'List<? super @Nullable B>' but this expression has type 'List<capture#of ? super @NonNull A>'\n----------\n");
    }

    public void test429387() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.function.BiFunction;\nimport java.util.function.Supplier;\nimport java.util.function.ToIntFunction;\nimport java.util.stream.IntStream;\nimport java.util.stream.Stream;\npublic interface X {\nstatic <BT, T extends BT, IS extends IntStream, E extends Exception> IntStreamy<E>\ninternalFlatMapToInt(Functionish<BT, IS, E> mapper,\nClass<E> classOfE,\nSupplier<Stream<T>> maker) {\nBiFunction<Stream<T>, ToIntFunction<BT>, IntStream> func = (Stream<T> t, ToIntFunction<BT, IS> m) -> t.flatmmapToInt(m);\nreturn IntStreamy.fromFlatMap(func, mapper, classOfE, maker);\n}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 7)\n\tstatic <BT, T extends BT, IS extends IntStream, E extends Exception> IntStreamy<E>\n\t                                                                     ^^^^^^^^^^\nIntStreamy cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 8)\n\tinternalFlatMapToInt(Functionish<BT, IS, E> mapper,\n\t                     ^^^^^^^^^^^\nFunctionish cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 11)\n\tBiFunction<Stream<T>, ToIntFunction<BT>, IntStream> func = (Stream<T> t, ToIntFunction<BT, IS> m) -> t.flatmmapToInt(m);\n\t                                                                         ^^^^^^^^^^^^^\nIncorrect number of arguments for type ToIntFunction<T>; it cannot be parameterized with arguments <BT, IS>\n----------\n4. ERROR in X.java (at line 11)\n\tBiFunction<Stream<T>, ToIntFunction<BT>, IntStream> func = (Stream<T> t, ToIntFunction<BT, IS> m) -> t.flatmmapToInt(m);\n\t                                                                                                                     ^\nm cannot be resolved to a variable\n----------\n5. ERROR in X.java (at line 12)\n\treturn IntStreamy.fromFlatMap(func, mapper, classOfE, maker);\n\t       ^^^^^^^^^^\nIntStreamy cannot be resolved\n----------\n");
    }

    public void testBug429403() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\nclass Person {}\npublic class X {\n\tList<@NonNull Person> l = new ArrayList<@Nullable Person>();}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tList<@NonNull Person> l = new ArrayList<@Nullable Person>();}\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull Person>' but this expression has type 'ArrayList<@Nullable Person>', corresponding supertype is 'List<@Nullable Person>'\n----------\n");
    }

    public void testBug430219() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class X {\n       void foo(int @NonNull [] x) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tvoid foo(int @NonNull [] x) {}\n\t              ^^^^^^^\nNonNull cannot be resolved to a type\n----------\n");
    }

    public void testBug430219a() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE) @interface Marker{}\n@NonNullByDefault\npublic class X {\n       void foo(int @Marker[] x) {}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testDefault01() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n@NonNullByDefault(DefaultLocation.TYPE_ARGUMENT)\npublic class X {\n\tList<Number> test1(List<Number> in) {\n\t\tin.add(null); // ERR\n\t\treturn new ArrayList<@Nullable Number>(); // ERR\n\t}\n\tjava.util.List<java.lang.Number> test2(java.util.List<java.lang.Number> in) {\n\t\tin.add(null); // ERR\n\t\treturn new ArrayList<java.lang.@Nullable Number>(); // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\tin.add(null); // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n2. ERROR in X.java (at line 7)\n\treturn new ArrayList<@Nullable Number>(); // ERR\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull Number>' but this expression has type 'ArrayList<@Nullable Number>', corresponding supertype is 'List<@Nullable Number>'\n----------\n3. ERROR in X.java (at line 10)\n\tin.add(null); // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n4. ERROR in X.java (at line 11)\n\treturn new ArrayList<java.lang.@Nullable Number>(); // ERR\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull Number>' but this expression has type 'ArrayList<@Nullable Number>', corresponding supertype is 'List<@Nullable Number>'\n----------\n");
    }

    public void testDefault01b() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n@NonNullByDefault(DefaultLocation.TYPE_ARGUMENT)\npublic class X<T> {\n\tList<T> test(List<? extends Number> in) {\n\t\tin.add(null); // NOK, cannot assume nullable\n\t\tneedNN(in.get(0)); // NOK, cannot assume nonnull\n\t\treturn new ArrayList<@Nullable T>(); // NOK, cannot assume nullable for T in List<T>\n\t}\n\tvoid needNN(@NonNull Number n) {}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\tin.add(null); // NOK, cannot assume nullable\n\t       ^^^^\nNull type mismatch (type annotations): 'null' is not compatible to the free type variable '? extends Number'\n----------\n2. WARNING in X.java (at line 7)\n\tneedNN(in.get(0)); // NOK, cannot assume nonnull\n\t       ^^^^^^^^^\nNull type safety (type annotations): The expression of type 'capture#of ? extends Number' needs unchecked conversion to conform to '@NonNull Number'\n----------\n3. ERROR in X.java (at line 8)\n\treturn new ArrayList<@Nullable T>(); // NOK, cannot assume nullable for T in List<T>\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<T>' but this expression has type 'ArrayList<@Nullable T>', corresponding supertype is 'List<@Nullable T>'\n----------\n");
    }

    public void testDefault02() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.PARAMETER)\npublic class X {\n\tNumber test1(Number in) {\n\t\tSystem.out.print(in.intValue()); // OK\n\t\ttest1(null); // ERR\n\t\treturn null; // OK\n\t}\n\tjava.lang.Number test2(java.lang.Number in) {\n\t\tSystem.out.print(in.intValue()); // OK\n\t\ttest2(null); // ERR\n\t\treturn null; // OK\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 6)\n\ttest1(null); // ERR\n\t      ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n2. ERROR in X.java (at line 11)\n\ttest2(null); // ERR\n\t      ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault03() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\tNumber test(Number in) {\n\t\tSystem.out.print(in.intValue());\n\t\ttest(null); // OK\n\t\treturn null; // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 7)\n\treturn null; // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault04() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.FIELD)\npublic class X {\n\tNumber field; // ERR since uninitialized\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tNumber field; // ERR since uninitialized\n\t       ^^^^^\nThe @NonNull field field may not have been initialized\n----------\n");
    }

    public void testDefault05() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n\tNumber field; // ERR since uninitialized\n\tvoid test1(Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n\tvoid test2(java.lang.Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 4)\n\tNumber field; // ERR since uninitialized\n\t       ^^^^^\nThe @NonNull field field may not have been initialized\n----------\n");
    }

    public void testDefault06() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\npublic class X {\n\tclass Inner<T> {\n\t\tT process(T t) {\n\t\t\t@NonNull T t2 = t; // OK\n\t\t\treturn null; // ERR\n \t\t}\n\t}\n\tvoid test(Inner<Number> inum) {\n\t\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 7)\n\treturn null; // ERR\n\t       ^^^^\nNull type mismatch: required '@NonNull T' but the provided value is null\n----------\n2. ERROR in X.java (at line 11)\n\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t                                   ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault07() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n@NonNullByDefault(DefaultLocation.TYPE_BOUND)\npublic class X {\n\tclass Inner {\n\t\t<T extends Number> T process(T t, List<? extends Number> l) {\n\t\t\t@NonNull T t2 = t; // OK\n\t\t\t@NonNull Number n = l.get(0); // OK\n\t\t\treturn null; // ERR\n \t\t}\n\t}\n\tvoid test(Inner inner) {\n\t\t@NonNull Number nnn = inner.process(Integer.MAX_VALUE, new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 9)\n\treturn null; // ERR\n\t       ^^^^\nNull type mismatch: required 'T extends @NonNull Number' but the provided value is null\n----------\n2. WARNING in X.java (at line 13)\n\t@NonNull Number nnn = inner.process(Integer.MAX_VALUE, new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t                                    ^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'int' needs unchecked conversion to conform to '@NonNull Integer'\n----------\n3. ERROR in X.java (at line 13)\n\t@NonNull Number nnn = inner.process(Integer.MAX_VALUE, new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t                                                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<? extends @NonNull Number>' but this expression has type 'ArrayList<@Nullable Integer>', corresponding supertype is 'List<@Nullable Integer>'\n----------\n");
    }

    public void testDefault01_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\nimport java.lang.annotation.*;\n\n@Target(ElementType.TYPE_USE) @Retention(RetentionPolicy.CLASS) @interface Important {}\n\n@NonNullByDefault(DefaultLocation.TYPE_ARGUMENT)\npublic class X {\n\tList<Number> test1(List<@Important Number> in) {\n\t\treturn new ArrayList<@NonNull Number>();\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Y {\n\tvoid test(List<Number> in, X x) {\n\t\tx.test1(new ArrayList<@Nullable Number>()) // ERR at arg\n\t\t\t.add(null); // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Y.java (at line 5)\n\tx.test1(new ArrayList<@Nullable Number>()) // ERR at arg\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nNull type mismatch (type annotations): required 'List<@NonNull Number>' but this expression has type 'ArrayList<@Nullable Number>', corresponding supertype is 'List<@Nullable Number>'\n----------\n2. ERROR in Y.java (at line 6)\n\t.add(null); // ERR\n\t     ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault02_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.PARAMETER)\npublic class X {\n\tNumber test1(Number in) {\n\t\treturn null; // OK\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\t@NonNull Number test(X x) {\n\t\treturn x.test1(null); // error at arg, unchecked at return\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Y.java (at line 4)\n\treturn x.test1(null); // error at arg, unchecked at return\n\t       ^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'Number' needs unchecked conversion to conform to '@NonNull Number'\n----------\n2. ERROR in Y.java (at line 4)\n\treturn x.test1(null); // error at arg, unchecked at return\n\t               ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault03_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\t@NonNullByDefault(DefaultLocation.RETURN_TYPE)\n\tNumber test(Number in) {\n\t\treturn new Integer(13);\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\t@NonNull Number test(X x) {\n\t\treturn x.test(null); // both OK\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testDefault04_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE) @Retention(RetentionPolicy.CLASS) @interface Important {}\n@NonNullByDefault(DefaultLocation.FIELD)\npublic class X {\n\t@Important Number field = new Double(1.1d);\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "public class Y {\n\tvoid test(X x) {\n\t\tx.field = null; // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Y.java (at line 3)\n\tx.field = null; // ERR\n\t          ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault05_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class X {\n\tNumber field = new Long(13);\n\tvoid test1(Number[] ns) {\n\t\tns[0] = null; // OK since not affected by default\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\tvoid test(X x, @Nullable Number @NonNull[] ns) {\n\t\tx.test1(ns); // OK since not affected by default\n\t\tx.field = null; // ERR\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Y.java (at line 5)\n\tx.field = null; // ERR\n\t          ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault06_bin() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault(DefaultLocation.TYPE_PARAMETER)\npublic class X {\n\tstatic class Inner<T> {\n\t\tT process(T t) {\n\t\t\treturn t;\n \t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\npublic class Y {\n\tvoid test(X.Inner<Number> inum) {\n\t\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Y.java (at line 4)\n\t@NonNull Number nnn = inum.process(null); // ERR on argument\n\t                                   ^^^^\nNull type mismatch: required '@NonNull Number' but the provided value is null\n----------\n");
    }

    public void testDefault07_bin() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\n@NonNullByDefault(DefaultLocation.TYPE_BOUND)\npublic class X {\n\tstatic class Inner {\n\t\t<T extends Number> T process(T t, List<? extends Number> l) {\n\t\t\treturn t;\n \t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runNegativeTestWithLibs(new String[]{"Y.java", "import org.eclipse.jdt.annotation.*;\nimport java.util.*;\npublic class Y {\n\tvoid test(X.Inner inner) {\n\t\t@NonNull Number nnn = inner.process(Integer.MAX_VALUE, new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. WARNING in Y.java (at line 5)\n\t@NonNull Number nnn = inner.process(Integer.MAX_VALUE, new ArrayList<@Nullable Integer>()); // WARN on 1. arg; ERR on 2. arg\n\t                                    ^^^^^^^^^^^^^^^^^\nNull type safety (type annotations): The expression of type 'int' needs unchecked conversion to conform to '@NonNull Integer'\n----------\n");
    }

    public void testBug431269() {
        this.runNegativeTestWithLibs(new String[]{"p/QField.java", "package p;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class QField<R extends QField<R, ? >, T> {\n\t@NonNull\n\tprotected R m_root;\n\n\tpublic QField(@Nullable R root, @Nullable QField<R, ? > parent, @Nullable String propertyNameInParent) {\n\t\tm_root = root;\n\t}\n}\n", "p/PLogLine.java", "package p;\n\nimport org.eclipse.jdt.annotation.*;\n\npublic class PLogLine<R extends QField<R, ? >> extends QField<R, LogLine> {\n\tpublic PLogLine(@Nullable R root, @Nullable QField<R, ? > parent, @Nullable String name) {\n\t\tsuper(root, parent, name);\n\t}\n\n\t@NonNull\n\tpublic final QField<R, java.lang.String> lastName() {\n\t\treturn new QField<R, java.lang.Long>(m_root, this, \"lastName\");\n\t}\n\n}\n", "p/LogLine.java", "package p;\n\npublic class LogLine {\n\tprivate String m_lastName;\n\n\tpublic String getLastName() {\n\t\treturn m_lastName;\n\t}\n\n\tpublic void setLastName(String property) {\n\t\tm_lastName = property;\n\t}\n}\n"}, "----------\n1. ERROR in p\\QField.java (at line 10)\n\tm_root = root;\n\t         ^^^^\nNull type mismatch (type annotations): required '@NonNull R extends QField<R extends QField<R,?>,?>' but this expression has type '@Nullable R extends QField<R extends QField<R,?>,?>'\n----------\n----------\n1. ERROR in p\\PLogLine.java (at line 12)\n\treturn new QField<R, java.lang.Long>(m_root, this, \"lastName\");\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from QField<R,Long> to QField<R,String>\n----------\n");
    }

    public void testBug432223() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\npublic class X {\n\tString val;\n\tpublic static @NonNull <T> T assertNotNull(@Nullable T object) {\n\t\treturn assertNotNull(null, object);\n\t}\n\n\tpublic static @NonNull <T> T assertNotNull(@Nullable String message, @Nullable T object) {\n\t\tif (object == null) {\n\t\t\tthrow new NullPointerException(message);\n\t\t}\n\t\treturn object;\n\t}\n\tvoid test(@Nullable X x) {\n\t\t@NonNull X safe = assertNotNull(x);\n\t\tSystem.out.println(safe.val);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug432977() {
        this.runConformTestWithLibs(new String[]{"Bar.java", "import org.eclipse.jdt.annotation.*;\n@NonNullByDefault\npublic class Bar {\n\tprivate String prop = \"\";\n\n\tpublic String getProp() {\n\t\treturn prop;\n\t}\n}\n"}, this.getCompilerOptions(), "");
        this.runConformTestWithLibs(new String[]{"Fu.java", "public class Fu {\n\tprivate Bar fubar = new Bar();\n\t\n\tpublic void method() {\n\t\tfubar.getProp().equals(\"\");\n\t}\t\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug433586() {
        this.runConformTestWithLibs(new String[]{"NullConversionWarning.java", "import java.util.function.Consumer;\npublic class NullConversionWarning<T> {\n\n\tpublic Consumer<T> peek2(Consumer<? super T> action) {\n\t\t// Null type safety: parameter 1 provided via\n\t\t// method descriptor Consumer<T>.accept(T) needs\n\t\t// unchecked conversion to conform to 'capture#of ? super T'\n\t\tConsumer<T> action2 = action::accept;\n\t\treturn action2;\n\t}\n\tvoid foo(Consumer<? super T> action, T t) {\n\t  Consumer<T> action2 = t2 -> action.accept(t2);\n\t  action.accept(t);\n\t  action2.accept(t);\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug433478() {
        this.runNegativeTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.NonNullByDefault;\nimport org.eclipse.jdt.annotation.Nullable;\n\n@NonNullByDefault class Y { }\n\ninterface I<T> {\n       @Nullable T foo();\n}\n\n@NonNullByDefault \nclass X implements I<Y> {\n       @Override\n       public Y foo() {\n               return null;\n       }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull Y' but the provided value is null\n----------\n");
    }

    public void testTypeVariable6() {
        this.runNegativeTestWithLibs(new String[]{"Assert.java", "import org.eclipse.jdt.annotation.*;\npublic class Assert {\n\tpublic static void caller() {\n\t\tassertNotNull(\"not null\");\t// Compiler error\n\t\tassertNotNull(null);\t\t// Compiler error\n\t}\n\tprivate static @NonNull <T> T assertNotNull(@Nullable T object) {\n\t\treturn object; // this IS bogus\n\t}\n}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in Assert.java (at line 8)\n\treturn object; // this IS bogus\n\t       ^^^^^^\nNull type mismatch (type annotations): required '@NonNull T' but this expression has type '@Nullable T'\n----------\n");
    }

    public void testTypeVariable6a() {
        this.runConformTestWithLibs(new String[]{"Assert.java", "import org.eclipse.jdt.annotation.*;\npublic class Assert {\n\tpublic static Object caller() {\n\t\t@NonNull Object result = assertNotNull(\"not null\");\n\t\tresult = assertNotNull(null);\n\t\treturn result;\n\t}\n\tprivate static @NonNull <T> T assertNotNull(@Nullable T object) {\n\t\tif (object == null) throw new NullPointerException();\n\t\treturn object;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug434600() {
        this.runConformTestWithLibs(new String[]{"bug/Main.java", "package bug;\npublic class Main {\n\tpublic static void main(final String[] args) {\n\t\tSystem.out.println(\"Hello World\");\n\t}\n}\n", "bug/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage bug;\n", "bug/ExpressionNode.java", "package bug;\n\npublic interface ExpressionNode extends CopyableNode<ExpressionNode> {\n\t\n}\n", "bug/ExtendedNode.java", "package bug;\n\npublic interface ExtendedNode {\n\t\n}\n", "bug/CopyableNode.java", "package bug;\n\npublic interface CopyableNode<T extends ExtendedNode> extends ExtendedNode {\n\t\n}\n"}, this.getCompilerOptions(), "", "Hello World");
    }

    public void testBug434600a() {
        this.runConformTestWithLibs(new String[]{"I.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\ninterface I<S, T extends @Nullable List<@NonNull List<S>>> {\n}\n", "C.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic class C implements I<@Nullable String, @Nullable ArrayList<@NonNull List<@Nullable String>>> {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug434600a_qualified() {
        this.runConformTestWithLibs(new String[]{"p/I.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic interface I<S, T extends @Nullable List<@NonNull List<S>>> {\n}\n", "C.java", "import org.eclipse.jdt.annotation.*;\npublic class C implements p.I<java.lang.@Nullable String, java.util.@Nullable ArrayList<java.util.@NonNull List<java.lang.@Nullable String>>> {}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug434600b() {
        this.runNegativeTestWithLibs(new String[]{"I.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\ninterface I<S, T extends @Nullable List<@NonNull List<S>>> {\n}\n", "C.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic class C implements I<@Nullable String, ArrayList<@NonNull List<@Nullable String>>> {}\nclass C1 {\n\tI<String, @Nullable ArrayList<@Nullable List<String>>> field;\n}\nclass C2 implements I<@NonNull String, @Nullable ArrayList<@NonNull List<@Nullable String>>> {}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 3)\n\tpublic class C implements I<@Nullable String, ArrayList<@NonNull List<@Nullable String>>> {}\n\t                                              ^^^^^^^^^\nNull constraint mismatch: The type 'ArrayList<@NonNull List<@Nullable String>>' is not a valid substitute for the type parameter 'T extends @Nullable List<@NonNull List<S>>'\n----------\n2. ERROR in C.java (at line 5)\n\tI<String, @Nullable ArrayList<@Nullable List<String>>> field;\n\t          ^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ArrayList<@Nullable List<String>>' is not a valid substitute for the type parameter 'T extends @Nullable List<@NonNull List<S>>'\n----------\n");
    }

    public void testBug434600b_qualified() {
        this.runNegativeTestWithLibs(new String[]{"p/I.java", "package p;\nimport java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic interface I<S, T extends @Nullable List<@NonNull List<S>>> {\n}\n", "C.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\npublic class C implements p.I<@Nullable String, ArrayList<@NonNull List<@Nullable String>>> {}\nclass C1 {\n\tp.I<String, @Nullable ArrayList<@Nullable List<String>>> field;\n}\nclass C2 implements p.I<@NonNull String, @Nullable ArrayList<@NonNull List<@Nullable String>>> {}\n"}, this.getCompilerOptions(), "----------\n1. ERROR in C.java (at line 3)\n\tpublic class C implements p.I<@Nullable String, ArrayList<@NonNull List<@Nullable String>>> {}\n\t                                                ^^^^^^^^^\nNull constraint mismatch: The type 'ArrayList<@NonNull List<@Nullable String>>' is not a valid substitute for the type parameter 'T extends @Nullable List<@NonNull List<S>>'\n----------\n2. ERROR in C.java (at line 5)\n\tp.I<String, @Nullable ArrayList<@Nullable List<String>>> field;\n\t            ^^^^^^^^^^^^^^^^^^^\nNull constraint mismatch: The type '@Nullable ArrayList<@Nullable List<String>>' is not a valid substitute for the type parameter 'T extends @Nullable List<@NonNull List<S>>'\n----------\n");
    }

    public void testBug435399() {
        this.runConformTestWithLibs(new String[]{"bug/Bug1.java", "package bug;\n\nimport org.eclipse.jdt.annotation.Nullable;\n\npublic class Bug1 {\n    public static <T> void method(@Nullable T value, T defaultValue) {\n    }\n    public void invoke() {\n        method(Integer.valueOf(1), Boolean.TRUE);\n    }\n}\n"}, this.getCompilerOptions(), "");
    }

    public void testBug435962() {
        this.runConformTestWithLibs(new String[]{"interfaces/CopyableNode.java", "package interfaces;\npublic interface CopyableNode<T extends ExtendedNode> extends ExtendedNode {\n\tpublic T deepCopy();\n}\n", "interfaces/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage interfaces;\n", "interfaces/ExtendedNode.java", "package interfaces;\nimport java.util.ArrayList;\nimport org.eclipse.jdt.annotation.Nullable;\npublic interface ExtendedNode {\n\tExtendedNode getParent();\n\tvoid setParent(ExtendedNode newParent);\n\tint numChildren();\n\tvoid mutateNode(ExtendedNode root);\n\tvoid getAllNodes(ArrayList<ExtendedNode> array);\n\tExtendedNode getNode(int nodeIndex);\n\t<N extends ExtendedNode> void getNodesOfType(Class<N> desiredType,\n\t\t\tArrayList<N> array);\n\t<N extends ExtendedNode> @Nullable N getRandomNodeOfType(\n\t\t\tClass<N> desiredType, ExtendedNode root, ExtendedNode caller);\n}\n", "interfaces/ValueNode.java", "package interfaces;\npublic interface ValueNode extends ExtendedNode {\n}\n", "framework/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage framework;\n", "framework/BinaryOpNode.java", "package framework;\n\nimport interfaces.CopyableNode;\nimport interfaces.ValueNode;\npublic abstract class BinaryOpNode<T extends ValueNode & CopyableNode<T>, O>\n\t\textends EqualBinaryNode<T> implements ValueNode {\n\t@SuppressWarnings(\"unused\") private O op;\n\t\n\tprotected BinaryOpNode(final T left, final O op, final T right) {\n\t\tsuper(left, right);\n\t\tthis.op = op;\n\t}\n}\n", "framework/EqualBinaryNode.java", "package framework;\n\nimport interfaces.CopyableNode;\nimport interfaces.ExtendedNode;\npublic abstract class EqualBinaryNode<T extends ExtendedNode & CopyableNode<T>>\n\t\timplements ExtendedNode {\n\tprotected T left;\n\tprotected T right;\n\t\n\tprotected EqualBinaryNode(final T left, final T right) {\n\t\tthis.left = left;\n\t\tthis.right = right;\n\t}\n}\n"}, this.getCompilerOptions(), "");
    }
}

