/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;

public class ProgrammingProblemsTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public ProgrammingProblemsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ProgrammingProblemsTest.buildAllCompliancesTestSuite(ProgrammingProblemsTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.ProgrammingProblemsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Map getCompilerOptions() {
        Map compilerOptions = super.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        return compilerOptions;
    }

    void runTest(String[] testFiles, String[] errorOptions, String[] warningOptions, String[] ignoreOptions, boolean expectingCompilerErrors, String expectedCompilerLog, String expectedOutputString, boolean forceExecution, String[] classLib, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor, boolean skipJavac) {
        HashMap<String, String> compilerOptions = customOptions;
        if (errorOptions != null || warningOptions != null || ignoreOptions != null) {
            int i;
            if (compilerOptions == null) {
                compilerOptions = new HashMap<String, String>();
            }
            if (errorOptions != null) {
                i = 0;
                while (i < errorOptions.length) {
                    compilerOptions.put(errorOptions[i], "error");
                    ++i;
                }
            }
            if (warningOptions != null) {
                i = 0;
                while (i < warningOptions.length) {
                    compilerOptions.put(warningOptions[i], "warning");
                    ++i;
                }
            }
            if (ignoreOptions != null) {
                i = 0;
                while (i < ignoreOptions.length) {
                    compilerOptions.put(ignoreOptions[i], "ignore");
                    ++i;
                }
            }
        }
        this.runTest(testFiles, expectingCompilerErrors, expectedCompilerLog, expectedOutputString, "", forceExecution, classLib, shouldFlushOutputDirectory, vmArguments, compilerOptions, clientRequestor, skipJavac);
    }

    public void test0001_unread_parameters() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo(boolean b) {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, false);
    }

    public void test0002_unread_parameters() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo(boolean b) {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "----------\n1. WARNING in X.java (at line 2)\n\tpublic void foo(boolean b) {\n\t                        ^\nThe value of the parameter b is not used\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0003_unread_parameters() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @param b mute warning **/\n  public void foo(boolean b) {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0004_unread_parameters() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @param b mute warning **/\n  public void foo(boolean b) {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo(boolean b) {\n\t                        ^\nThe value of the parameter b is not used\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0005_unread_parameters() {
        if (this.complianceLevel >= 0x310000L) {
            this.runTest(new String[]{"X.java", "public class X {\n@SuppressWarnings(\"unused\")\n  public void foo(boolean b) {\n  }\n@SuppressWarnings(\"all\")\n  public void foo(int i) {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "", "", false, null, true, null, null, null, true);
        }
    }

    public void test0006_unread_parameters() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo(boolean b) {\n  }\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, null, true, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(boolean b) {\n\t                        ^\nThe value of the parameter b is not used\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0007_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public void foo() throws IOException {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, false);
    }

    public void test0008_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0009_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n/** @throws IOException mute warning **/\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0010_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "disabled");
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n/** @throws IOException mute warning **/\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 4)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0011_declared_thrown_checked_exceptions() {
        if (this.complianceLevel >= 0x310000L) {
            this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n@SuppressWarnings(\"all\")\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, null, null, true);
        }
    }

    public void test0012_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public void foo() throws IOException {\n  }\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, null, true, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0013_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runTest(new String[]{"X.java", "import java.io.IOException;\nimport java.io.EOFException;\npublic class X {\n/** @throws EOFException does not mute warning for IOException **/\n  public void foo() throws IOException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 5)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0014_declared_thrown_checked_exceptions_unread_parameters() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  void foo(int unused) throws IOException {}\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, true, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo(int unused) throws IOException {}\n\t             ^^^^^^\nThe value of the parameter unused is not used\n----------\n2. ERROR in X.java (at line 3)\n\tvoid foo(int unused) throws IOException {}\n\t                            ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0015_declared_thrown_checked_exceptions_unread_parameters() {
        this.runTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  void foo(int unused) throws IOException {}\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", "org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo(int unused) throws IOException {}\n\t             ^^^^^^\nThe value of the parameter unused is not used\n----------\n2. WARNING in X.java (at line 3)\n\tvoid foo(int unused) throws IOException {}\n\t                            ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0016_unread_parameters_constructor() {
        this.runTest(new String[]{"X.java", "public class X {\n  public X(boolean b) {\n  }\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedParameter"}, null, null, true, "----------\n1. ERROR in X.java (at line 2)\n\tpublic X(boolean b) {\n\t                 ^\nThe value of the parameter b is not used\n----------\n", "", false, null, true, null, null, null, true);
    }

    public void test0017_shadowing_package_visible_methods() {
        this.runTest(new String[]{"p/X.java", "package p;\npublic class X {\n  void foo() {\n  }\n}\n", "q/Y.java", "package q;\npublic class Y extends p.X {\n  void foo() {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod"}, null, false, "----------\n1. WARNING in q\\Y.java (at line 3)\n\tvoid foo() {\n\t     ^^^^^\nThe method Y.foo() does not override the inherited method from X since it is private to a different package\n----------\n", "", false, null, true, null, null, new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                if (result.compilationUnit.getFileName()[0] == 'Y') {
                    ProgrammingProblemsTest.assertEquals((String)"unexpected problems count", (int)1, (int)result.problemCount);
                    ProgrammingProblemsTest.assertEquals((String)"unexpected category", (int)100, (int)result.problems[0].getCategoryID());
                }
            }
        }, true);
    }

    public void test0018_declared_thrown_unchecked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws ArithmeticException {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0019_declared_thrown_unchecked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws RuntimeException {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0020_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0021_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Throwable {\n  }\n}\n"}, null, null, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0022_declared_thrown_unchecked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws ArithmeticException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0023_declared_thrown_unchecked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 2)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0024_declared_thrown_unchecked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws RuntimeException {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0025_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 2)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0026_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Throwable {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 2)\n\tpublic void foo() throws Throwable {\n\t                         ^^^^^^^^^\nThe declared exception Throwable is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0027_declared_thrown_unchecked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @throws Exception mute warning **/\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0028_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @throws Exception mute warning **/\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0029_declared_thrown_checked_exceptions() {
        if (this.complianceLevel >= 0x310000L) {
            HashMap<String, String> customOptions = new HashMap<String, String>();
            customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
            this.runTest(new String[]{"X.java", "public class X {\n@SuppressWarnings(\"all\")\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
        }
    }

    public void test0030_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n  }\n}\n"}, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, null, true, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0031_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n/** @throws Throwable does not mute warning for Exception **/\n  public void foo() throws Exception {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo() throws Exception {\n\t                         ^^^^^^^^^\nThe declared exception Exception is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0032_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Error {\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0033_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public void foo() throws Exception {\n    if (bar()) {\n      throw new Exception();\n    }\n  }\n  boolean bar() {\n    return true;\n  }\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0034_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public static final class MyError extends Error {\n    private static final long serialVersionUID = 1L;\n  }\n  public void foo() throws Throwable {\n    try {\n      bar();\n    } catch (MyError e) {\n    }\n  }\n  private void bar() {}\n}"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "----------\n1. WARNING in X.java (at line 5)\n\tpublic void foo() throws Throwable {\n\t                         ^^^^^^^^^\nThe declared exception Throwable is not actually thrown by the method foo() from type X\n----------\n", "", false, null, true, null, customOptions, null, true);
    }

    public void test0035_declared_thrown_checked_exceptions() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable", "disabled");
        this.runTest(new String[]{"X.java", "public class X {\n  public static final class MyError extends Error {\n    private static final long serialVersionUID = 1L;\n  }\n  public void foo() throws Throwable {\n    throw new MyError();\n  }\n}"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, customOptions, null, true);
    }

    public void test0036_declared_thrown_checked_exceptions() {
        this.runTest(new String[]{"X.java", "public class X {\n  public static class E1 extends Exception {\n    private static final long serialVersionUID = 1L;\n  }\n  public static class E2 extends E1 {\n    private static final long serialVersionUID = 1L;\n  }\n  public void foo() throws E1 {\n    throw new E2();\n  }\n}"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException"}, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0037() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b1 = args == args;\n\t\tboolean b2 = args != args;\n\t\tboolean b3 = b1 == b1;\n\t\tboolean b4 = b1 != b1;\n\t\tboolean b5 = b1 && b1;\n\t\tboolean b6 = b1 || b1;\n\t\t\n\t\tboolean b7 = foo() == foo();\n\t\tboolean b8 = foo() != foo();\n\t\tboolean b9 = foo() && foo();\n\t\tboolean b10 = foo() || foo();\n\t}\n\tstatic boolean foo() { return true; }\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b1 = args == args;\n\t             ^^^^^^^^^^^^\nComparing identical expressions\n----------\n2. WARNING in X.java (at line 4)\n\tboolean b2 = args != args;\n\t             ^^^^^^^^^^^^\nComparing identical expressions\n----------\n3. WARNING in X.java (at line 5)\n\tboolean b3 = b1 == b1;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n4. WARNING in X.java (at line 6)\n\tboolean b4 = b1 != b1;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n5. WARNING in X.java (at line 7)\n\tboolean b5 = b1 && b1;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n6. WARNING in X.java (at line 8)\n\tboolean b6 = b1 || b1;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n7. ERROR in X.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0038() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b1 = 1 == 1;\n\t\tboolean b2 = 1 != 1;\n\t\tboolean b3 = 1 == 1.0;\n\t\tboolean b4 = 1 != 1.0;\n\t\tboolean b5 = 1 == 2;\n\t\tboolean b6 = 1 != 2;\n\t\tboolean b7 = 1 == 2.0;\n\t\tboolean b8 = 1 != 2.0;\n       final short s1 = 1;\n       final short s2 = 2;\n       boolean b9 = 1 == s1;\n       boolean b10 = 1 == s2;\n       boolean b91 = 1 != s1;\n       boolean b101 = 1 != s2;\n       final long l1 = 1;\n       final long l2 = 2;\n       boolean b11 = 1 == l1;\n       boolean b12 = 1 == l2;\n       boolean b111 = 1 != l1;\n       boolean b121 = 1 != l2;\n       boolean b13 = s1 == l1;\n       boolean b14 = s1 == l2;\n       boolean b15 = s1 != l1;\n       boolean b16 = s1 != l2;\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b1 = 1 == 1;\n\t             ^^^^^^\nComparing identical expressions\n----------\n2. WARNING in X.java (at line 4)\n\tboolean b2 = 1 != 1;\n\t             ^^^^^^\nComparing identical expressions\n----------\n3. WARNING in X.java (at line 5)\n\tboolean b3 = 1 == 1.0;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n4. WARNING in X.java (at line 6)\n\tboolean b4 = 1 != 1.0;\n\t             ^^^^^^^^\nComparing identical expressions\n----------\n5. WARNING in X.java (at line 13)\n\tboolean b9 = 1 == s1;\n\t             ^^^^^^^\nComparing identical expressions\n----------\n6. WARNING in X.java (at line 15)\n\tboolean b91 = 1 != s1;\n\t              ^^^^^^^\nComparing identical expressions\n----------\n7. WARNING in X.java (at line 19)\n\tboolean b11 = 1 == l1;\n\t              ^^^^^^^\nComparing identical expressions\n----------\n8. WARNING in X.java (at line 21)\n\tboolean b111 = 1 != l1;\n\t               ^^^^^^^\nComparing identical expressions\n----------\n9. WARNING in X.java (at line 23)\n\tboolean b13 = s1 == l1;\n\t              ^^^^^^^^\nComparing identical expressions\n----------\n10. WARNING in X.java (at line 25)\n\tboolean b15 = s1 != l1;\n\t              ^^^^^^^^\nComparing identical expressions\n----------\n11. ERROR in X.java (at line 28)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0039() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void gain(String[] args) {\n\t\tboolean b1 = this == this;\n\t\tboolean b2 = this != this;\n\t\tboolean b3 = this != new X();\n\t\tboolean b4 = this == new X();\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b1 = this == this;\n\t             ^^^^^^^^^^^^\nComparing identical expressions\n----------\n2. WARNING in X.java (at line 4)\n\tboolean b2 = this != this;\n\t             ^^^^^^^^^^^^\nComparing identical expressions\n----------\n3. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        double var = Double.NaN;\n            if(var != var) {\n                  System.out.println(\"NaN\");\n            }\n            float varf = 10;\n            if(varf != varf) {\n            \tSystem.out.println(\"NaN\");\n            }\n   }\n\tZork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0041() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(1.0 == 1.0);\n\t\tSystem.out.println(1.0f == 1.0f);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tSystem.out.println(1.0 == 1.0);\n\t                   ^^^^^^^^^^\nComparing identical expressions\n----------\n2. WARNING in X.java (at line 4)\n\tSystem.out.println(1.0f == 1.0f);\n\t                   ^^^^^^^^^^^^\nComparing identical expressions\n----------\n");
    }

    public void test0042() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runTest(new String[]{"Test.java", "public class Test {\n    public static void main(String[]  args) {\n        final String var = \"Hello\";\n        final int local = 10;\n        @ZAnn(var + local)\n        class X {}\n        new X();\n    }\n}\n@interface ZAnn {\n    String value();\n}\n"}, null, new String[]{"org.eclipse.jdt.core.compiler.problem.unusedLocal"}, null, false, "", "", false, null, true, null, null, null, true);
    }

    public void test0043() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tvoid foo(int i) {\n\t\tfoo((a));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tfoo((a));\n\t     ^\na cannot be resolved to a variable\n----------\n");
    }

    public void test0044() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n   volatile int x;\n   int nvx;\n\tvoid foo(int i) {\n\t\tx = x;\n       nvx = nvx;\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tnvx = nvx;\n\t^^^^^^^^^\nThe assignment to variable nvx has no effect\n----------\n");
    }

    public void test0045() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n   volatile int x = this.x;\n   int nvx = this.nvx;\n\tvoid foo(int i) {\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tvolatile int x = this.x;\n\t             ^^^^^^^^^^\nThe assignment to variable x has no effect\n----------\n2. WARNING in X.java (at line 3)\n\tint nvx = this.nvx;\n\t    ^^^^^^^^^^^^^^\nThe assignment to variable nvx has no effect\n----------\n");
    }

    public void test0046() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    int foo() {\n        int i=1;\n        boolean b=false;\n        b|=true;\n        int k = 2;\n        --k;\n        k+=3;\n        Integer j = 3;\n        j++;\n        i++;\n        return i++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n2. WARNING in X.java (at line 6)\n\tint k = 2;\n\t    ^\nThe value of the local variable k is not used\n----------\n", null, true, customOptions);
    }

    public void test0046_field() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    private int i=1;\n    private boolean b=false;\n    private int k = 2;\n    private Integer j = 3;\n    int foo() {\n        b|=true;\n        --k;\n        k+=3;\n        j++;\n        return i++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tprivate boolean b=false;\n\t                ^\nThe value of the field X.b is not used\n----------\n2. WARNING in X.java (at line 4)\n\tprivate int k = 2;\n\t            ^\nThe value of the field X.k is not used\n----------\n", null, true, customOptions);
    }

    public void test0046_field_this_qualified() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    private int i=1;\n    private boolean b=false;\n    private int k = 2;\n    private Integer j = 3;\n    int foo() {\n        this.b|=true;\n        --this.k;\n        getThis().k+=3;\n        this.j++;\n        return this.i++;\n    }\n    X getThis() { return this; }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tprivate boolean b=false;\n\t                ^\nThe value of the field X.b is not used\n----------\n2. WARNING in X.java (at line 4)\n\tprivate int k = 2;\n\t            ^\nThe value of the field X.k is not used\n----------\n", null, true, customOptions);
    }

    public void test0046_field_qualified() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    private int i=1;\n    private boolean b=false;\n    private int k = 2;\n    private Integer j = 3;\n    int foo(X that) {\n        that.b|=true;\n        --that.k;\n        that.k+=3;\n        that.j++;\n        that.i++;\n        return that.i++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tprivate boolean b=false;\n\t                ^\nThe value of the field X.b is not used\n----------\n2. WARNING in X.java (at line 4)\n\tprivate int k = 2;\n\t            ^\nThe value of the field X.k is not used\n----------\n", null, true, customOptions);
    }

    public void test0046_field_in_private_type() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    private class Y {\n        int i=1;\n        public boolean b=false;\n        protected int k = 2;\n        Integer j = 3;\n    }\n    int foo(Y y) {\n        y.b|=true;\n        --y.k;\n        y.k+=3;\n        y.j++;\n        int result = y.i++;\n        y.i++;\n        return result;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tpublic boolean b=false;\n\t               ^\nThe value of the field X.Y.b is not used\n----------\n2. WARNING in X.java (at line 5)\n\tprotected int k = 2;\n\t              ^\nThe value of the field X.Y.k is not used\n----------\n", null, true, customOptions);
    }

    public void test0047() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    void foo(int param1, int param2, Integer param3) {\n        boolean b=false;\n        b|=true;\n        param1++;\n        {\n            int val=23;\n            param2 += val;\n        }\n        param3++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(int param1, int param2, Integer param3) {\n\t             ^^^^^^\nThe value of the parameter param1 is not used\n----------\n2. WARNING in X.java (at line 2)\n\tvoid foo(int param1, int param2, Integer param3) {\n\t                         ^^^^^^\nThe value of the parameter param2 is not used\n----------\n3. WARNING in X.java (at line 3)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n", null, true, customOptions);
    }

    public void test0048() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A implements Y{\n   public void foo(int param1, int param2, Integer param3) {\n        boolean b=false;\n        b|=true;\n        param1++;\n        param2 += 1;\n        param3++;\n    }\n   public void foo(int param1, int param2) {\n        boolean b=false;\n        b|=true;\n        param1++;\n        param2 += 1;\n    }\n   public void bar(int param1, int param2, Integer param3) {\n        param1++;\n        param2 += 1;\n        param3++;\n    }\n}\ninterface Y{\n\tpublic void foo(int param1, int param2, Integer param3);}\nabstract class A{\n\tpublic abstract void bar(int param1, int param2, Integer param3);}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n2. WARNING in X.java (at line 9)\n\tpublic void foo(int param1, int param2) {\n\t                    ^^^^^^\nThe value of the parameter param1 is not used\n----------\n3. WARNING in X.java (at line 9)\n\tpublic void foo(int param1, int param2) {\n\t                                ^^^^^^\nThe value of the parameter param2 is not used\n----------\n4. WARNING in X.java (at line 10)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n", null, true, customOptions);
    }

    public void test0049() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A {\n   public void foo(int param1, int param2, Integer param3) {\n        boolean b=false;\n        b|=true;\n        param1++;\n        param2 += 1;\n        param3++;\n    }\n   public void foo(int param1, Integer param3) {\n        param1++;\n        param3++;\n    }\n}\nclass A{\n   public void foo(int param1, int param2, Integer param3) {\n        param1 -=1;\n        param2--;\n        param3--;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tboolean b=false;\n\t        ^\nThe value of the local variable b is not used\n----------\n2. WARNING in X.java (at line 9)\n\tpublic void foo(int param1, Integer param3) {\n\t                    ^^^^^^\nThe value of the parameter param1 is not used\n----------\n3. WARNING in X.java (at line 15)\n\tpublic void foo(int param1, int param2, Integer param3) {\n\t                    ^^^^^^\nThe value of the parameter param1 is not used\n----------\n4. WARNING in X.java (at line 15)\n\tpublic void foo(int param1, int param2, Integer param3) {\n\t                                ^^^^^^\nThe value of the parameter param2 is not used\n----------\n", null, true, customOptions);
    }

    public void test0050() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    int foo() {\n        int i=1;\n\t\t if (false) {\n        \tboolean b=false;\n        \tb|=true;\n\t\t }\n        int k = 2;\n        --k;\n        k+=3;\n        Integer j = 3;\n        j++;\n        return i++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (false) {\n        \tboolean b=false;\n        \tb|=true;\n\t\t }\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. WARNING in X.java (at line 8)\n\tint k = 2;\n\t    ^\nThe value of the local variable k is not used\n----------\n", null, true, customOptions);
    }

    public void test0051() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    X(int abc) {\n        abc++;\n    }\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tX(int abc) {\n\t      ^^^\nThe value of the parameter abc is not used\n----------\n", null, true, customOptions);
    }

    public void test0052() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        this.runConformTest(new String[]{"X.java", "class X {\n    Y y = new Y();\n    private class Y {\n        int abc;\n        Y() {\n            abc++;\n        }\n    }\n    class Z extends Y {}\n}"}, "", null, true, null, customOptions, null);
    }

    public void test0052a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"Outer.java", "class Outer {\n    private class Inner1 {\n        int foo;\n    }\n    private class Inner2 extends Inner1 { }\n    class Inner3 extends Inner2 { }\n}\n"}, "", null, true, null, customOptions, null);
    }

    public void test0052b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"Outer.java", "class Outer {\n    private class Inner1 {\n        class Foo{}\n    }\n    private class Inner2 extends Inner1 { }\n    class Inner3 extends Inner2 { }\n}\n"}, "", null, true, null, customOptions, null);
    }

    public void test0053() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runConformTest(new String[]{"X.java", "class X {\n    int foo() {\n        int i=1;\n        i++;\n        return 0;\n    }\n}"}, "", null, true, null, customOptions, null);
        String expectedOutput = "  // Method descriptor #15 ()I\n  // Stack: 1, Locals: 1\n  int foo();\n    0  iconst_0\n    1  ireturn\n      Line numbers:\n        [pc: 0, line: 5]\n      Local variable table:\n        [pc: 0, pc: 2] local: this index: 0 type: X\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test0054() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        this.runConformTest(new String[]{"X.java", "class X {\n    int foo() {\n        int i=1;\n        return i+=1;\n    }\n}"}, "", null, true, null, customOptions, null);
        String expectedOutput = "  // Method descriptor #15 ()I\n  // Stack: 1, Locals: 2\n  int foo();\n    0  iconst_1\n    1  istore_1 [i]\n    2  iinc 1 1 [i]\n    5  iload_1 [i]\n    6  ireturn\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n      Local variable table:\n        [pc: 0, pc: 7] local: this index: 0 type: X\n        [pc: 2, pc: 7] local: i index: 1 type: int\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test0055() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        this.runNegativeTest(new String[]{"test1/E.java", "package test1;\npublic class E {\n    private void foo() {\n        int a= 10;\n        a++;\n        a--;\n        --a;\n        ++a;\n        for ( ; ; a++) {\n        }\n    }\n}"}, "----------\n1. WARNING in test1\\E.java (at line 4)\n\tint a= 10;\n\t    ^\nThe value of the local variable a is not used\n----------\n", null, true, customOptions);
    }

    public void test0056() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    static int foo() {\n        int i = 2;\n        int j = 3;\n        return (i += j *= 3);\n    }\n    public static void main(String[] args) {\n        System.out.println(foo());\n    }\n}"}, "11", null, true, null, customOptions, null);
    }

    public void test0057() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main (String args[]) {\n        int i = 0;\n        i += 4 + foo();\n    }\n    public static int foo() {\n    \tSystem.out.println(\"OK\");\n    \treturn 0;\n    }\n}"}, "OK", null, true, null, customOptions, null);
    }

    public void _test0058() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void foo(String m) {\n        final String message= m;\n        new Runnable() {\n            public void run() {\n                if (\"x\".equals(message)) {\n                    bug(); // undefined method\n                }\n            }\n        }.run();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tbug(); // undefined method\n\t^^^\nThe method bug() is undefined for the type new Runnable(){}\n----------\n", null, true, customOptions);
    }

    public void test0059() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deadCode", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n    \tObject a = null;\n    \tif (a != null){\n        \tint j = 3;\n        \tj++;\n    \t}\n    \tSystem.out.println(\"OK\");\n    }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (a != null){\n        \tint j = 3;\n        \tj++;\n    \t}\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. WARNING in X.java (at line 5)\n\tint j = 3;\n\t    ^\nThe value of the local variable j is not used\n----------\n", null, true, customOptions);
    }

    public void test0060() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uninternedIdentityComparison", "enabled");
        this.runNegativeTest(new String[]{"org/eclipse/jdt/internal/compiler/lookup/X.java", "package org.eclipse.jdt.internal.compiler.lookup;\nclass TypeBinding {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void gain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void vain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void cain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 7)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n2. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 9)\n\tif (t1 == t2) {\n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n3. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 16)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n4. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 18)\n\tif (t1 == t2) {\n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n5. ERROR in org\\eclipse\\jdt\\internal\\compiler\\lookup\\X.java (at line 28)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n", null, true, customOptions);
    }

    public void test0061() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uninternedIdentityComparison", "enabled");
        this.runNegativeTest(new String[]{"org/eclipse/nonjdt/internal/compiler/lookup/X.java", "package org.eclipse.nonjdt.internal.compiler.lookup;\nclass TypeBinding {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void gain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void vain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void cain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "", null, true, customOptions);
    }

    public void test0062() throws Exception {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"org/eclipse/jdt/internal/compiler/lookup/X.java", "package org.eclipse.jdt.internal.compiler.lookup;\nclass TypeBinding {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void gain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void vain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void cain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "", null, true, customOptions);
    }

    public void test0063() throws Exception {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.uninternedIdentityComparison", "enabled");
        this.runNegativeTest(new String[]{"org/eclipse/jdt/core/dom/X.java", "package org.eclipse.jdt.core.dom;\ninterface ITypeBinding {\n}\nclass TypeBinding implements ITypeBinding {\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void gain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void vain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\t//$IDENTITY-COMPARISON$\n\t\tif (t1 == t2) { \n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void cain(String[] args) {\n\t\tTypeBinding t1 = null, t2 = null;\n\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\tif (t2 == t1) {  //$IDENTITY-COMPARISON$\n\t\t\t\tif (t1 == t2) { //$IDENTITY-COMPARISON$\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 9)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n2. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 11)\n\tif (t1 == t2) {\n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n3. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 18)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n4. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 20)\n\tif (t1 == t2) {\n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n5. ERROR in org\\eclipse\\jdt\\core\\dom\\X.java (at line 30)\n\tif (t1 == t2) { \n\t    ^^^^^^^^\nThe uninterned types TypeBinding and TypeBinding should not be compared using ==/!= operators.\n----------\n", null, true, customOptions);
    }
}

