/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class TryWithResourcesStatementTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public TryWithResourcesStatementTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TryWithResourcesStatementTest.buildMinimalComplianceTestSuite(TryWithResourcesStatementTest.testClass(), 16);
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (int i = 0) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (int i = 0) {\n\t     ^^^\nThe resource type int does not implement java.lang.AutoCloseable\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (int[] tab = {}) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (int[] tab = {}) {\n\t     ^^^^^\nThe resource type int[] does not implement java.lang.AutoCloseable\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements AutoCloseable{\n\tpublic void method1(){\n\t\ttry (AutoCloseable a = new X()) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements AutoCloseable{\n\t             ^\nThe type X must implement the inherited abstract method AutoCloseable.close()\n----------\n2. ERROR in X.java (at line 3)\n\ttry (AutoCloseable a = new X()) {\n\t                   ^\nUnhandled exception type Exception thrown by automatic close() invocation on a\n----------\n");
    }

    public void test003a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y y = new Y()) { \n\t\t\tSystem.out.println();\n\t\t} catch (Exception e) {\n\t\t} finally {\n           Zork z;\n\t\t}\n\t}\n}\nclass Y implements Managed {\n    public void close () throws Exception {\n    }\n}\ninterface Managed extends AutoCloseable {}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tpublic static void main(String[] args) throws IOException {\n\t\tint i = 0;\n\t\ttry (LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(args[0])))) {\n\t\t\tString s;\n\t\t\tint i = 0;\n\t\t\twhile ((s = reader.readLine()) != null) {\n\t\t\t\tSystem.out.println(s);\n\t\t\t\ti++;\n\t\t\t}\n\t\t\tSystem.out.println(\"\" + i + \" lines\");\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tint i = 0;\n\t    ^\nDuplicate local variable i\n----------\n");
    }

    public void test004a() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tpublic static void main(String[] args) throws IOException {\n\t\ttry (LineNumberReader r = new LineNumberReader(new BufferedReader(new FileReader(args[0])))) {\n\t\t\tString s;\n\t\t\tint r = 0;\n\t\t\twhile ((s = r.readLine()) != null) {\n\t\t\t\tSystem.out.println(s);\n\t\t\t\tr++;\n\t\t\t}\n\t\t\tSystem.out.println(\"\" + r + \" lines\");\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tint r = 0;\n\t    ^\nDuplicate local variable r\n----------\n2. ERROR in X.java (at line 7)\n\twhile ((s = r.readLine()) != null) {\n\t            ^^^^^^^^^^^^\nCannot invoke readLine() on the primitive type int\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tpublic static void main(String[] args) throws IOException {\n\t\ttry (Reader r = new LineNumberReader(new BufferedReader(new FileReader(args[0])))) {\n\t\t\tr = new FileReader(args[0]);\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tr = new FileReader(args[0]);\n\t^\nThe resource r of a try-with-resources statement cannot be assigned\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tpublic static void main(String[] args) throws IOException {\n\t\ttry (Reader r = new LineNumberReader(new BufferedReader(new FileReader(args[0])))) {\n\t\t} catch(Zork z) {       }\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t} catch(Zork z) {       }\n\t        ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tpublic static void main(String[] args) throws IOException {\n\t\ttry (final Reader r = new LineNumberReader(new BufferedReader(new FileReader(args[0])))) {\n\t\t\tr = new FileReader(args[0]);\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tr = new FileReader(args[0]);\n\t^\nThe resource r of a try-with-resources statement cannot be assigned\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y [] i = null) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\nclass Y implements AutoCloseable {\n    public void close () {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Y [] i = null) {\n\t     ^^^^\nThe resource type Y[] does not implement java.lang.AutoCloseable\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y i [] = null) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\nclass Y implements AutoCloseable {\n    public void close () {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Y i [] = null) {\n\t     ^\nThe resource type Y[] does not implement java.lang.AutoCloseable\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(int p){\n       int k;\n\t\ttry (Y i = new Y(); Y i = new Y(); Y p = new Y(); Y k = new Y();) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\nclass Y implements AutoCloseable {\n    public void close () {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\ttry (Y i = new Y(); Y i = new Y(); Y p = new Y(); Y k = new Y();) {\n\t                      ^\nDuplicate local variable i\n----------\n2. ERROR in X.java (at line 4)\n\ttry (Y i = new Y(); Y i = new Y(); Y p = new Y(); Y k = new Y();) {\n\t                                     ^\nDuplicate local variable p\n----------\n3. ERROR in X.java (at line 4)\n\ttry (Y i = new Y(); Y i = new Y(); Y p = new Y(); Y k = new Y();) {\n\t                                                    ^\nDuplicate local variable k\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y i = new Y(); Y p = new Y(); Y k = new Y();) {\n\t\t\tSystem.out.println();\n\t\t}\n       catch (Exception e) {\n           System.out.println(i);\n       }\n       finally {\n           System.out.println(p);\n       }\n\t}\n}\nclass Y implements AutoCloseable {\n    public void close () {}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(i);\n\t                   ^\ni cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 10)\n\tSystem.out.println(p);\n\t                   ^\np cannot be resolved to a variable\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y i = new Y(); Y p = new Y(); Y k = new Y();) {\n           try {\n\t\t\t    System.out.println();\n           } catch (Exception i) {\n           }\n\t\t}\n       catch (Exception e) {\n           System.out.println(i);\n       }\n       finally {\n           System.out.println(p);\n       }\n\t}\n}\nclass Y implements AutoCloseable {\n    public void close () {}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\t} catch (Exception i) {\n\t                   ^\nDuplicate parameter i\n----------\n2. ERROR in X.java (at line 10)\n\tSystem.out.println(i);\n\t                   ^\ni cannot be resolved to a variable\n----------\n3. ERROR in X.java (at line 13)\n\tSystem.out.println(p);\n\t                   ^\np cannot be resolved to a variable\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n\ttry (Y y = new Y(); Y p = new Y()) {\n\t    X x = new X() {\n\t\t      public void foo(int p) {\n                         try {\n\t\t             System.out.println();\n\t\t          } catch (Exception y) {\n\t\t          }\n\t\t       }\n\t           };\n\t} finally {\n            System.out.println(y);\n\t}\n   }\n}\n\nclass Y implements AutoCloseable {\n\tpublic void close() {\n\t\t    System.out.println();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic void foo(int p) {\n\t                    ^\nThe parameter p is hiding another local variable defined in an enclosing scope\n----------\n2. WARNING in X.java (at line 8)\n\t} catch (Exception y) {\n\t                   ^\nThe parameter y is hiding another local variable defined in an enclosing scope\n----------\n3. ERROR in X.java (at line 13)\n\tSystem.out.println(y);\n\t                   ^\ny cannot be resolved to a variable\n----------\n");
    }

    public void test014() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {    \n\t\ttry (Y y = new Y();) {\n           if (y == null) {}\n           Y why = new Y();\n\t\t    System.out.println(\"Try block\");\n\t\t} finally {\n\t\t    System.out.println(\"Finally block\");\n\t\t}\n\t}\n} \n\nclass Y implements AutoCloseable {\n\tpublic Y() throws WeirdException {\n\t\tthrow new WeirdException();\n\t}\n\tpublic void close() {\n\t\t    System.out.println(\"Closing resource\");\n\t}\n}\n\nclass WeirdException extends Throwable {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Y y = new Y();) {\n\t           ^^^^^^^\nUnhandled exception type WeirdException\n----------\n2. WARNING in X.java (at line 4)\n\tif (y == null) {}\n\t               ^^\nDead code\n----------\n3. WARNING in X.java (at line 5)\n\tY why = new Y();\n\t  ^^^\nResource leak: 'why' is never closed\n----------\n4. ERROR in X.java (at line 5)\n\tY why = new Y();\n\t        ^^^^^^^\nUnhandled exception type WeirdException\n----------\n5. WARNING in X.java (at line 22)\n\tclass WeirdException extends Throwable {}\n\t      ^^^^^^^^^^^^^^\nThe serializable class WeirdException does not declare a static final serialVersionUID field of type long\n----------\n", null, true, options);
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {    \n\t\ttry (Y y = new Y();) {\n           if (y == null)\n {}\n\t\t}\n\t}\n} \n\nclass Y implements AutoCloseable {\n\tpublic void close() {\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\t{}\n\t^^\nDead code\n----------\n");
    }

    public void test016() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {    \n\t\ttry (Y y = new Y();) {\n           if (y == null) {}\n           Y why = new Y();\n\t\t    System.out.println(\"Try block\");\n\t\t}\n\t}\n} \n\nclass Y implements AutoCloseable {\n\tpublic Y() throws WeirdException {\n\t\tthrow new WeirdException();\n\t}\n\tpublic void close() {\n\t\t    System.out.println(\"Closing resource\");\n\t}\n}\n\nclass WeirdException extends Throwable {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Y y = new Y();) {\n\t           ^^^^^^^\nUnhandled exception type WeirdException\n----------\n2. WARNING in X.java (at line 4)\n\tif (y == null) {}\n\t               ^^\nDead code\n----------\n3. WARNING in X.java (at line 5)\n\tY why = new Y();\n\t  ^^^\nResource leak: 'why' is never closed\n----------\n4. ERROR in X.java (at line 5)\n\tY why = new Y();\n\t        ^^^^^^^\nUnhandled exception type WeirdException\n----------\n5. WARNING in X.java (at line 20)\n\tclass WeirdException extends Throwable {}\n\t      ^^^^^^^^^^^^^^\nThe serializable class WeirdException does not declare a static final serialVersionUID field of type long\n----------\n", null, true, options);
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {    \n\t\ttry (Y y = new Y();) {\n           if (y == null)\n {}\n\t\t} finally {\n       }\n\t}\n} \n\nclass Y implements AutoCloseable {\n\tpublic void close() {\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\t{}\n\t^^\nDead code\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {    \n\t\ttry () {\n\t\t} finally {\n       }\n\t}\n} \n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry () {\n\t    ^\nSyntax error on token \"(\", Resources expected after this token\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements AutoCloseable {\n\tpublic static void main(String [] args) {\n            try (X x = new X(); Y y = new Y(); Z z = new Z()) {\n            throw new XXException();\n            } catch (XException x) {\n\t \t\t } catch (YException y) {\n            } catch (ZException z) {\n\t    \t } finally {\n            }\n\t}\n\tpublic X() throws XException {\n\t\tthrow new XException();\n\t}\n\tpublic void close() throws XXException {\n\t\tthrow new XXException();\n\t}\n}\nclass Y implements AutoCloseable {\n\tpublic Y() throws YException {\n\t\tthrow new YException();\n\t}\n\tpublic void close() throws YYException {\n\t\tthrow new YYException();\n\t}\n}\nclass Z implements AutoCloseable {\n\tpublic Z() throws ZException {\n\t\tthrow new ZException();\n\t}\n\tpublic void close() throws ZZException {\n\t\tthrow new ZZException();\n\t}\n}\nclass XException extends Exception {}\nclass XXException extends Exception {}\nclass YException extends Exception {}\nclass YYException extends Exception {}\nclass ZException extends Exception {}\nclass ZZException extends Exception {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (X x = new X(); Y y = new Y(); Z z = new Z()) {\n\t       ^\nUnhandled exception type XXException thrown by automatic close() invocation on x\n----------\n2. ERROR in X.java (at line 3)\n\ttry (X x = new X(); Y y = new Y(); Z z = new Z()) {\n\t                      ^\nUnhandled exception type YYException thrown by automatic close() invocation on y\n----------\n3. ERROR in X.java (at line 3)\n\ttry (X x = new X(); Y y = new Y(); Z z = new Z()) {\n\t                                     ^\nUnhandled exception type ZZException thrown by automatic close() invocation on z\n----------\n4. ERROR in X.java (at line 4)\n\tthrow new XXException();\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type XXException\n----------\n5. WARNING in X.java (at line 34)\n\tclass XException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class XException does not declare a static final serialVersionUID field of type long\n----------\n6. WARNING in X.java (at line 35)\n\tclass XXException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class XXException does not declare a static final serialVersionUID field of type long\n----------\n7. WARNING in X.java (at line 36)\n\tclass YException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class YException does not declare a static final serialVersionUID field of type long\n----------\n8. WARNING in X.java (at line 37)\n\tclass YYException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class YYException does not declare a static final serialVersionUID field of type long\n----------\n9. WARNING in X.java (at line 38)\n\tclass ZException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class ZException does not declare a static final serialVersionUID field of type long\n----------\n10. WARNING in X.java (at line 39)\n\tclass ZZException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class ZZException does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y i = null) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\nclass Y {\n    public void close () {}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Y i = null) {\n\t     ^\nThe resource type Y does not implement java.lang.AutoCloseable\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y i = null) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\nclass Y implements AutoCloseable {\n    public int close () { return 0; }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tpublic int close () { return 0; }\n\t       ^^^\nThe return type is incompatible with AutoCloseable.close()\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y i = null) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\nclass Y implements AutoCloseable {\n    public void close () throws Blah {}\n}\nclass Blah extends Throwable {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Y i = null) {\n\t       ^\nUnhandled exception type Blah thrown by automatic close() invocation on i\n----------\n2. ERROR in X.java (at line 9)\n\tpublic void close () throws Blah {}\n\t            ^^^^^^^^^^^^^^^^^^^^\nException Blah is not compatible with throws clause in AutoCloseable.close()\n----------\n3. WARNING in X.java (at line 11)\n\tclass Blah extends Throwable {}\n\t      ^^^^\nThe serializable class Blah does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements AutoCloseable {\n\tpublic static void main(String [] args) {\n            try (X x = new X(); Y y = new Y(); Z z = new Z()) {\n            throw new XXException();\n            } catch (XException x) {\n\t \t\t } catch (YException y) {\n            } catch (ZException z) {\n            } catch (XXException x) {\n\t \t\t } catch (YYException y) {\n            } catch (ZZException z) {\n\t    \t } finally {\n            }\n\t}\n\tpublic X() throws XException {\n\t\tthrow new XException();\n\t}\n\tpublic void close() throws XXException {\n\t\tthrow new XXException();\n\t}\n}\nclass Y implements AutoCloseable {\n\tpublic Y() throws YException {\n\t\tthrow new YException();\n\t}\n\tpublic void close() throws YYException {\n\t\tthrow new YYException();\n\t}\n}\nclass Z implements AutoCloseable {\n\tpublic Z() throws ZException {\n\t\tthrow new ZException();\n\t}\n\tpublic void close() throws ZZException {\n\t\tthrow new ZZException();\n\t}\n}\nclass XException extends Exception {}\nclass XXException extends Exception {}\nclass YException extends Exception {}\nclass YYException extends Exception {}\nclass ZException extends Exception {}\nclass ZZException extends Exception {}\n"}, "----------\n1. WARNING in X.java (at line 37)\n\tclass XException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class XException does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 38)\n\tclass XXException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class XXException does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 39)\n\tclass YException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class YException does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 40)\n\tclass YYException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class YYException does not declare a static final serialVersionUID field of type long\n----------\n5. WARNING in X.java (at line 41)\n\tclass ZException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class ZException does not declare a static final serialVersionUID field of type long\n----------\n6. WARNING in X.java (at line 42)\n\tclass ZZException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class ZZException does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements AutoCloseable {\n\tpublic static void main(String [] args) {\n            try (X x = new X(); Y y = new Y(); Z z = new Z()) {\n            throw new XXException();\n            } catch (XException x) {\n\t \t\t } catch (YException y) {\n            } catch (ZException z) {\n            \n            }\n\t}\n\tpublic X() throws XException {\n\t\tthrow new XException();\n\t}\n\tpublic void close() throws XXException {\n\t\tthrow new XXException();\n\t}\n}\nclass Y implements AutoCloseable {\n\tpublic Y() throws YException {\n\t\tthrow new YException();\n\t}\n\tpublic void close() throws YYException {\n\t\tthrow new YYException();\n\t}\n}\nclass Z implements AutoCloseable {\n\tpublic Z() throws ZException {\n\t\tthrow new ZException();\n\t}\n\tpublic void close() throws ZZException {\n\t\tthrow new ZZException();\n\t}\n}\nclass XException extends Exception {}\nclass XXException extends Exception {}\nclass YException extends Exception {}\nclass YYException extends Exception {}\nclass ZException extends Exception {}\nclass ZZException extends Exception {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (X x = new X(); Y y = new Y(); Z z = new Z()) {\n\t       ^\nUnhandled exception type XXException thrown by automatic close() invocation on x\n----------\n2. ERROR in X.java (at line 3)\n\ttry (X x = new X(); Y y = new Y(); Z z = new Z()) {\n\t                      ^\nUnhandled exception type YYException thrown by automatic close() invocation on y\n----------\n3. ERROR in X.java (at line 3)\n\ttry (X x = new X(); Y y = new Y(); Z z = new Z()) {\n\t                                     ^\nUnhandled exception type ZZException thrown by automatic close() invocation on z\n----------\n4. ERROR in X.java (at line 4)\n\tthrow new XXException();\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type XXException\n----------\n5. WARNING in X.java (at line 34)\n\tclass XException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class XException does not declare a static final serialVersionUID field of type long\n----------\n6. WARNING in X.java (at line 35)\n\tclass XXException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class XXException does not declare a static final serialVersionUID field of type long\n----------\n7. WARNING in X.java (at line 36)\n\tclass YException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class YException does not declare a static final serialVersionUID field of type long\n----------\n8. WARNING in X.java (at line 37)\n\tclass YYException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class YYException does not declare a static final serialVersionUID field of type long\n----------\n9. WARNING in X.java (at line 38)\n\tclass ZException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class ZException does not declare a static final serialVersionUID field of type long\n----------\n10. WARNING in X.java (at line 39)\n\tclass ZZException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class ZZException does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements AutoCloseable {\n\tpublic static void main(String [] args) {\n            try (X x = new X(); Y y = new Y(); Z z = new Z()) {\n            throw new XXException();\n            } catch (XException x) {\n\t \t\t } catch (YException y) {\n            } catch (ZException z) {\n            } catch (XXException x) {\n\t \t\t } catch (YYException y) {\n            } catch (ZZException z) {\n\n            }\n\t}\n\tpublic X() throws XException {\n\t\tthrow new XException();\n\t}\n\tpublic void close() throws XXException {\n\t\tthrow new XXException();\n\t}\n}\nclass Y implements AutoCloseable {\n\tpublic Y() throws YException {\n\t\tthrow new YException();\n\t}\n\tpublic void close() throws YYException {\n\t\tthrow new YYException();\n\t}\n}\nclass Z implements AutoCloseable {\n\tpublic Z() throws ZException {\n\t\tthrow new ZException();\n\t}\n\tpublic void close() throws ZZException {\n\t\tthrow new ZZException();\n\t}\n}\nclass XException extends Exception {}\nclass XXException extends Exception {}\nclass YException extends Exception {}\nclass YYException extends Exception {}\nclass ZException extends Exception {}\nclass ZZException extends Exception {}\n"}, "----------\n1. WARNING in X.java (at line 37)\n\tclass XException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class XException does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 38)\n\tclass XXException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class XXException does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 39)\n\tclass YException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class YException does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 40)\n\tclass YYException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class YYException does not declare a static final serialVersionUID field of type long\n----------\n5. WARNING in X.java (at line 41)\n\tclass ZException extends Exception {}\n\t      ^^^^^^^^^^\nThe serializable class ZException does not declare a static final serialVersionUID field of type long\n----------\n6. WARNING in X.java (at line 42)\n\tclass ZZException extends Exception {}\n\t      ^^^^^^^^^^^\nThe serializable class ZZException does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws Exception {\n        try (X x = new X(); Y y = new Y()) {\n            System.out.println(\"Body\");\n            throw new Exception(\"Body\");\n        } catch (Exception e) {\n            System.out.println(e);\n            Throwable [] suppressed = e.getSuppressed();\n            for (int i = 0; i < suppressed.length; i++) {\n                System.out.println(\"Suppressed:\" + suppressed[i]);\n            }\n        } finally {\n            int finallyVar = 10;\n            System.out.println(finallyVar);\n        }\n    }\n    public X() {\n        System.out.println(\"X CTOR\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"X Close\");\n        throw new Exception(\"X Close\");\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() {\n        System.out.println(\"Y CTOR\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Y Close\");\n        throw new Exception(\"Y Close\");\n    }\n}\n"}, "X CTOR\nY CTOR\nBody\nY Close\nX Close\njava.lang.Exception: Body\nSuppressed:java.lang.Exception: Y Close\nSuppressed:java.lang.Exception: X Close\n10");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws Exception {\n        try (X x = new X(); Y y = new Y()) {\n            System.out.println(\"Body\");\n        } catch (Exception e) {\n            e.printStackTrace();\n        }\n    }\n    public X() {\n        System.out.println(\"X CTOR\");\n    }\n    public void close() {\n        System.out.println(\"X DTOR\");\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() {\n        System.out.println(\"Y CTOR\");\n    }\n    public void close() {\n        System.out.println(\"Y DTOR\");\n    }\n}\n"}, "X CTOR\nY CTOR\nBody\nY DTOR\nX DTOR");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() {\n        File file = new File(\"somefile\");\n        try(FileReader fileReader = new FileReader(file);) {\n            char[] in = new char[50];\n            fileReader.read(in);\n        } catch (IOException e) {\n            System.out.println(\"Got IO exception\");\n        } finally{\n        }\n    }\n    public static void main(String[] args) {\n        new X().foo();\n    }\n}\n"}, "Got IO exception");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws Exception { \n    \tfinal boolean getOut = true;\n    \tSystem.out.println(\"Main\");\n    \ttry (X x1 = new X(); X x2 = new X()) {\n            System.out.println(\"Outer Try\");\n            while (true) {\n            \ttry (Y y1 = new Y(); Y y2 = new Y()) {\n            \t\tSystem.out.println(\"Middle Try\");\n            \t\ttry (Z z1 = new Z(); Z z2 = new Z()) {\n            \t\t\tSystem.out.println(\"Inner Try\");\n            \t\t\tif (getOut) \n            \t\t\t\treturn;\n            \t\t\telse\n            \t\t\t\tbreak;\n            \t\t}\n            \t}\n            }\n            System.out.println(\"Out of while\");\n        }\n    }\n    public X() {\n        System.out.println(\"X::X\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"X::~X\");\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() {\n        System.out.println(\"Y::Y\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Y::~Y\");\n    }\n}\nclass Z implements AutoCloseable {\n    public Z() {\n        System.out.println(\"Z::Z\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Z::~Z\");\n    }\n}\n"}, "Main\nX::X\nX::X\nOuter Try\nY::Y\nY::Y\nMiddle Try\nZ::Z\nZ::Z\nInner Try\nZ::~Z\nZ::~Z\nY::~Y\nY::~Y\nX::~X\nX::~X");
    }

    public void test030a() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws Exception { \n    \tfinal boolean getOut = true;\n    \tSystem.out.println(\"Main\");\n    \ttry (X x1 = new X(); X x2 = new X()) {\n            System.out.println(\"Outer Try\");\n            while (true) {\n            \ttry (Y y1 = new Y(); Y y2 = new Y()) {\n            \t\tSystem.out.println(\"Middle Try\");\n            \t\ttry (Z z1 = new Z(); Z z2 = new Z()) {\n            \t\t\tSystem.out.println(\"Inner Try\");\n            \t\t\tif (getOut) \n            \t\t\t\treturn;\n            \t\t\telse\n            \t\t\t\tbreak;\n            \t\t}\n            \t}\n            }\n            System.out.println(\"Out of while\");\n        } catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n        }\n    }\n    public X() {\n        System.out.println(\"X::X\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"X::~X\");\n        throw new Exception(\"X::~X\");\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() {\n        System.out.println(\"Y::Y\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Y::~Y\");\n        throw new Exception(\"Y::~Y\");\n    }\n}\nclass Z implements AutoCloseable {\n    public Z() {\n        System.out.println(\"Z::Z\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Z::~Z\");\n        throw new Exception(\"Z::~Z\");\n    }\n}\n"}, "Main\nX::X\nX::X\nOuter Try\nY::Y\nY::Y\nMiddle Try\nZ::Z\nZ::Z\nInner Try\nZ::~Z\nZ::~Z\nY::~Y\nY::~Y\nX::~X\nX::~X\njava.lang.Exception: Z::~Z\nSuppressed: java.lang.Exception: Z::~Z\nSuppressed: java.lang.Exception: Y::~Y\nSuppressed: java.lang.Exception: Y::~Y\nSuppressed: java.lang.Exception: X::~X\nSuppressed: java.lang.Exception: X::~X");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws Exception { \n    \tfinal boolean getOut = false;\n    \tSystem.out.println(\"Main\");\n    \ttry (X x1 = new X(); X x2 = new X()) {\n            System.out.println(\"Outer Try\");\n            while (true) {\n            \ttry (Y y1 = new Y(); Y y2 = new Y()) {\n            \t\tSystem.out.println(\"Middle Try\");\n            \t\ttry (Z z1 = new Z(); Z z2 = new Z()) {\n            \t\t\tSystem.out.println(\"Inner Try\");\n            \t\t\tif (getOut) \n            \t\t\t\treturn;\n            \t\t\telse\n            \t\t\t\tbreak;\n            \t\t}\n            \t}\n            }\n            System.out.println(\"Out of while\");\n        }\n    }\n    public X() {\n        System.out.println(\"X::X\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"X::~X\");\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() {\n        System.out.println(\"Y::Y\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Y::~Y\");\n    }\n}\nclass Z implements AutoCloseable {\n    public Z() {\n        System.out.println(\"Z::Z\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Z::~Z\");\n    }\n}\n"}, "Main\nX::X\nX::X\nOuter Try\nY::Y\nY::Y\nMiddle Try\nZ::Z\nZ::Z\nInner Try\nZ::~Z\nZ::~Z\nY::~Y\nY::~Y\nOut of while\nX::~X\nX::~X");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws Exception { \n    \tfinal boolean getOut = false;\n    \tSystem.out.println(\"Main\");\n    \ttry (X x1 = new X(); X x2 = new X()) {\n            System.out.println(\"Outer Try\");\n            boolean more = true;\n            while (more) {\n            \ttry (Y y1 = new Y(); Y y2 = new Y()) {\n            \t\tSystem.out.println(\"Middle Try\");\n            \t\ttry (Z z1 = new Z(); Z z2 = new Z()) {\n            \t\t\tSystem.out.println(\"Inner Try\");\n                       more = false;\n                       continue;\n            \t\t} finally { \n                       System.out.println(\"Inner Finally\");\n                   }\n            \t} finally {\n                   System.out.println(\"Middle Finally\");\n               }\n            }\n            System.out.println(\"Out of while\");\n        } finally {\n            System.out.println(\"Outer Finally\");\n        }\n    }\n    public X() {\n        System.out.println(\"X::X\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"X::~X\");\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() {\n        System.out.println(\"Y::Y\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Y::~Y\");\n    }\n}\nclass Z implements AutoCloseable {\n    public Z() {\n        System.out.println(\"Z::Z\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Z::~Z\");\n    }\n}\n"}, "Main\nX::X\nX::X\nOuter Try\nY::Y\nY::Y\nMiddle Try\nZ::Z\nZ::Z\nInner Try\nZ::~Z\nZ::~Z\nInner Finally\nY::~Y\nY::~Y\nMiddle Finally\nOut of while\nX::~X\nX::~X\nOuter Finally");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws Exception { \n    \tfinal boolean getOut = false;\n    \tSystem.out.println(\"Main\");\n    \ttry (X x1 = null; Y y = new Y(); Z z = null) {\n            System.out.println(\"Body\");\n        } finally {\n            System.out.println(\"Outer Finally\");\n        }\n    }\n    public X() {\n        System.out.println(\"X::X\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"X::~X\");\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() {\n        System.out.println(\"Y::Y\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Y::~Y\");\n    }\n}\nclass Z implements AutoCloseable {\n    public Z() {\n        System.out.println(\"Z::Z\");\n    }\n    public void close() throws Exception {\n        System.out.println(\"Z::~Z\");\n    }\n}\n"}, "Main\nY::Y\nBody\nY::~Y\nOuter Finally");
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t\tthrow new Exception(\"Body\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t\tthrow new Exception (\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t\tthrow new Exception (\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t\tthrow new Exception (\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t\tthrow new Exception (\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t\tthrow new Exception (\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t\tthrow new Exception (\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t\tthrow new Exception (\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\njava.lang.Exception: A::A\nAll done");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t\tthrow new Exception(\"Body\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t\tthrow new Exception (\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t\tthrow new Exception (\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t\tthrow new Exception (\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t\tthrow new Exception (\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t\tthrow new Exception (\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t\tthrow new Exception (\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nA::~A\njava.lang.Exception: B::B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t\tthrow new Exception(\"Body\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t\tthrow new Exception (\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t\tthrow new Exception (\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t\tthrow new Exception (\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t\tthrow new Exception (\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t\tthrow new Exception (\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nB::~B\nA::~A\njava.lang.Exception: C::C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t\tthrow new Exception(\"Body\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t\tthrow new Exception (\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t\tthrow new Exception (\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t\tthrow new Exception (\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t\tthrow new Exception (\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: D::D\nSuppressed: java.lang.Exception: C::~C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t\tthrow new Exception(\"Body\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t\tthrow new Exception (\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t\tthrow new Exception (\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t\tthrow new Exception (\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: E::E\nSuppressed: java.lang.Exception: D::~D\nSuppressed: java.lang.Exception: C::~C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t\tthrow new Exception(\"Body\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t\tthrow new Exception (\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t\tthrow new Exception (\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: F::F\nSuppressed: java.lang.Exception: E::~E\nSuppressed: java.lang.Exception: D::~D\nSuppressed: java.lang.Exception: C::~C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t\tthrow new Exception(\"Body\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t\tthrow new Exception (\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nInner try\nF::~F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: Body\nSuppressed: java.lang.Exception: F::~F\nSuppressed: java.lang.Exception: E::~E\nSuppressed: java.lang.Exception: D::~D\nSuppressed: java.lang.Exception: C::~C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test041() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t\tthrow new Exception (\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nInner try\nF::~F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: F::~F\nSuppressed: java.lang.Exception: E::~E\nSuppressed: java.lang.Exception: D::~D\nSuppressed: java.lang.Exception: C::~C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nInner try\nF::~F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: E::~E\nSuppressed: java.lang.Exception: D::~D\nSuppressed: java.lang.Exception: C::~C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t\tthrow new Exception (\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nInner try\nF::~F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: D::~D\nSuppressed: java.lang.Exception: C::~C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nInner try\nF::~F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: C::~C\nSuppressed: java.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\tthrow new Exception (\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nInner try\nF::~F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: B::~B\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\tthrow new Exception (\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nInner try\nF::~F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\njava.lang.Exception: A::~A\nAll done");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A(); B b = new B()) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t\ttry (C c = new C(); D d = new D();) {\n\t\t\t\tSystem.out.println(\"Middle try\");\n\t\t\t\ttry (E e = new E(); F f = new F()) {\n\t\t\t\t\tSystem.out.println(\"Inner try\");\n\t\t\t\t} \n\t\t\t}\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t}\n}\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t}\n}\nclass D implements AutoCloseable {\n\tpublic D () throws Exception {\n\t\tSystem.out.println(\"D::D\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"D::~D\");\n\t}\n}\nclass E implements AutoCloseable {\n\tpublic E () throws Exception {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t}\n}\nclass F implements AutoCloseable {\n\tpublic F () throws Exception {\n\t\tSystem.out.println(\"F::F\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"F::~F\");\n\t}\n}\nclass G implements AutoCloseable {\n\tpublic G () throws Exception {\n\t\tSystem.out.println(\"G::G\");\n\t\tthrow new Exception (\"G::G\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"G::~G\");\n\t\tthrow new Exception (\"G::~G\");\n\t}\n}\n"}, "Main\nA::A\nB::B\nOuter try\nC::C\nD::D\nMiddle try\nE::E\nF::F\nInner try\nF::~F\nE::~E\nD::~D\nC::~C\nB::~B\nA::~A\nAll done");
    }

    public void test048() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (A a = new A()) {\n\t\t\tSystem.out.println(\"X::Try\");\n\t\t\tthrow new Exception(\"X::Main\");\n\t\t} catch (Exception e) {\n\t\t\t\tSystem.out.println(e);\n\t\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\n\nclass A implements AutoCloseable {\n\tpublic A () throws Exception {\n\t\tSystem.out.println(\"A::A\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"A::~A\");\n\t\ttry (B b = new B()) {\n\t\t\tSystem.out.println(\"A::~A::Try\");\n\t\t\tthrow new Exception(\"A::~A\");\n\t\t} catch (Exception e) {\n\t\t\t\tSystem.out.println(e);\n\t\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t\t}\n\t\t\t\tthrow e;\n\t\t} \t\n\t}\n}\n\nclass B implements AutoCloseable {\n\tpublic B () throws Exception {\n\t\tSystem.out.println(\"B::B\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"B::~B\");\n\t\ttry (C c = new C()) {\n\t\t\tSystem.out.println(\"B::~B::Try\");\n\t\t\tthrow new Exception (\"B::~B\");\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t\tthrow e;\n\t} \t\n\t}\n}\nclass C implements AutoCloseable {\n\tpublic C () throws Exception {\n\t\tSystem.out.println(\"C::C\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"C::~C\");\n\t\tthrow new Exception (\"C::~C\");\n\t} \n}\n"}, "Main\nA::A\nX::Try\nA::~A\nB::B\nA::~A::Try\nB::~B\nC::C\nB::~B::Try\nC::~C\njava.lang.Exception: B::~B\nSuppressed: java.lang.Exception: C::~C\njava.lang.Exception: A::~A\nSuppressed: java.lang.Exception: B::~B\njava.lang.Exception: X::Main\nSuppressed: java.lang.Exception: A::~A\nAll done");
    }

    public void test049() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() {\n        File file = new File(\"somefile\");\n        try(FileReader fileReader = new FileReader(file);) {\n            char[] in = new char[50];\n            fileReader.read(in);\n        } catch (IOException e) {\n            System.out.println(\"Got IO exception\");\n        } finally{\n        }\n    }\n    public static void main(String[] args) {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\ttry(FileReader fileReader = new FileReader(file);) {\n\t    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource specification not allowed here for source level below 1.7\n----------\n", null, true, options);
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\tSystem.out.println(\"Main\");\n\t\ttry (E e = E.CONST) {\n\t\t\tSystem.out.println(\"Outer try\");\n\t\t} catch (Exception e) {\n\t\t\tSystem.out.println(e);\n\t\t\tThrowable suppressed [] = e.getSuppressed();\n\t\t\tfor (int i = 0; i < suppressed.length; ++i) {\n\t\t\t\tSystem.out.println(\"Suppressed: \" + suppressed[i]);\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}", "E.java", "public enum E implements AutoCloseable {\n\tCONST;\n\tprivate E () {\n\t\tSystem.out.println(\"E::E\");\n\t}\n\tpublic void close() throws Exception {\n\t\tSystem.out.println(\"E::~E\");\n\t\tthrow new Exception (\"E::~E\");\n\t}\n}"}, "Main\nE::E\nOuter try\nE::~E\njava.lang.Exception: E::~E\nAll done");
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws Throwable {\n        try (Test t = new Test()) {\n            for (int i = 0; i < 10; i++) {\n            }\n\n\n        } \n\n        catch (Exception e) {\n            StackTraceElement t = e.getStackTrace()[1];\n            String file = t.getFileName();\n            int line = t.getLineNumber();\n            System.out.println(\"File = \" + file + \" \" + \"line = \" + line);\n        }\n    }\n}\nclass Test implements AutoCloseable {\n    public void close() throws Exception {\n        throw new Exception();\n    }\n}\n"}, "File = X.java line = 8");
    }

    public void test052() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws Throwable {\n        try (Test t = new Test()) {\n        } \n    }\n}\nclass Test {\n    public void close() throws Exception {\n        throw new Exception();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Test t = new Test()) {\n\t     ^^^^^^^^^^^^^^^^^^^\nResource specification not allowed here for source level below 1.7\n----------\n", null, true, options);
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y y = new Y()) { \n\t\t\ty.close();\n\t\t\tSystem.out.println();\n\t\t} catch (RuntimeException e) {\n\t\t}\n\t}\n}\nclass Y implements Managed {\n\t public Y() throws CloneNotSupportedException {}\n    public void close () throws ClassNotFoundException, java.io.IOException {\n    }\n}\ninterface Managed extends AutoCloseable {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Y y = new Y()) { \n\t       ^\nUnhandled exception type ClassNotFoundException thrown by automatic close() invocation on y\n----------\n2. ERROR in X.java (at line 3)\n\ttry (Y y = new Y()) { \n\t       ^\nUnhandled exception type IOException thrown by automatic close() invocation on y\n----------\n3. ERROR in X.java (at line 3)\n\ttry (Y y = new Y()) { \n\t           ^^^^^^^\nUnhandled exception type CloneNotSupportedException\n----------\n4. ERROR in X.java (at line 4)\n\ty.close();\n\t^^^^^^^^^\nUnhandled exception type ClassNotFoundException\n----------\n5. ERROR in X.java (at line 4)\n\ty.close();\n\t^^^^^^^^^\nUnhandled exception type IOException\n----------\n");
    }

    public void test053a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1(){\n\t\ttry (Y y = new Y()) { \n\t\t\ty.close();\n\t\t\tSystem.out.println();\n\t\t} catch (RuntimeException e) {\n       } finally {\n           System.out.println();\n\t\t}\n\t}\n}\nclass Y implements Managed {\n\t public Y() throws CloneNotSupportedException {}\n    public void close () throws ClassNotFoundException, java.io.IOException {\n    }\n}\ninterface Managed extends AutoCloseable {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Y y = new Y()) { \n\t       ^\nUnhandled exception type ClassNotFoundException thrown by automatic close() invocation on y\n----------\n2. ERROR in X.java (at line 3)\n\ttry (Y y = new Y()) { \n\t       ^\nUnhandled exception type IOException thrown by automatic close() invocation on y\n----------\n3. ERROR in X.java (at line 3)\n\ttry (Y y = new Y()) { \n\t           ^^^^^^^\nUnhandled exception type CloneNotSupportedException\n----------\n4. ERROR in X.java (at line 4)\n\ty.close();\n\t^^^^^^^^^\nUnhandled exception type ClassNotFoundException\n----------\n5. ERROR in X.java (at line 4)\n\ty.close();\n\t^^^^^^^^^\nUnhandled exception type IOException\n----------\n");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void foo() {\n        try (Object | Integer res = null) {\n        } catch (Exception e) {\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Object | Integer res = null) {\n\t            ^\nSyntax error on token \"|\", . expected\n----------\n");
    }

    public void test054a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void foo() {\n        try (Object.Integer res = null) {\n        } catch (Exception e) {\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ttry (Object.Integer res = null) {\n\t     ^^^^^^^^^^^^^^\nObject.Integer cannot be resolved to a type\n----------\n");
    }

    public void test055() {
        this.runConformTest(new String[]{"X.java", "import java.io.ByteArrayInputStream;\nimport java.io.InputStream;\npublic class X {\npublic static void main(String[] args) throws Exception {\n  int b;\n  try (final InputStream in = new ByteArrayInputStream(new byte[] { 42 })) {\n    b = in.read();\n  }\n  System.out.println(\"Done\");\n}\n}\n"}, "Done");
    }

    public void test055a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws Throwable {\n        int tmp;\n        try (A a = null) {\n            try (A b = null) {\n                tmp = 0;\n            }\n        }\n        System.out.println(\"Done\");\n    }\n}\nclass A implements AutoCloseable {\n    @Override\n    public void close() {\n    }\n}\n"}, "Done");
    }

    public void test057() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n\t@Override\n\tpublic void close() throws Exception {\n\t\tthrow new Exception();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfinal boolean foo;\n\t\ttry (X a = new X(); X b = new X()) {\n\t\t\tfoo = true;\n\t\t} catch (final Exception exception) {\n\t\t\treturn;\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test058() {
        this.runConformTest(new String[]{"X.java", "import java.io.ByteArrayOutputStream;\nimport java.io.FileOutputStream;\nimport java.io.IOException;\n\npublic class X {\n\n  public static void main(final String[] args) throws IOException {\n    byte[] data;\n    try (final ByteArrayOutputStream os = new ByteArrayOutputStream();\n         final FileOutputStream out = new FileOutputStream(\"test.dat\")) {\n      data = os.toByteArray();\n    }\n  }\n}\n"}, "");
    }

    public void test059() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\n\npublic class X implements java.lang.AutoCloseable {\n  static boolean isOpen = true;\n  public static void main(final String[] args) throws IOException {\n    foo();\n    System.out.println(isOpen);\n  }\n  static boolean foo() {\n    try (final X x = new X()) {\n      return x.num() >= 1;\n    }\n  }\n  int num() { return 2; }\n  public void close() {\n    isOpen = false;\n  }\n}\n"}, "false");
    }

    public void test060() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n\tstatic int num = 10 ;\n    public static void main(String [] args) throws Exception { \n    \tSystem.out.println(foo(1));\n    \tSystem.out.println(foo(2));\n    \tSystem.out.println(foo(3));\n    }\n\tprivate static boolean foo(int where) throws Exception {\n\t\tfinal boolean getOut = true;\n    \tSystem.out.println(\"Main\");\n    \ttry (X x1 = new X(); X x2 = new X()) {\n    \t\tif (where == 1) {\n    \t\t\treturn where == 1;\n    \t\t}\n            System.out.println(\"Outer Try\");\n            while (true) {\n            \ttry (Y y1 = new Y(); Y y2 = new Y()) { \n            \t\tif (where == 2) {\n            \t\t\treturn where == 2;\n            \t\t}\t\t\n            \t\tSystem.out.println(\"Middle Try\");\n            \t\ttry (Z z1 = new Z(); Z z2 = new Z()) {\n            \t\t\tSystem.out.println(\"Inner Try\");\n            \t\t\tif (getOut) \n            \t\t\t\treturn num >= 10;\n            \t\t\telse\n            \t\t\t\tbreak; \n            \t\t}\n            \t}\n            }\n            System.out.println(\"Out of while\");\n        }\n\t\treturn false;\n\t}\n    public X() {\n        System.out.println(\"X::X\");\n    }\n    @Override\n\tpublic void close() throws Exception {\n        System.out.println(\"X::~X\");\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() {\n        System.out.println(\"Y::Y\");\n    }\n    @Override\n\tpublic void close() throws Exception {\n        System.out.println(\"Y::~Y\");\n    }\n}\nclass Z implements AutoCloseable {\n    public Z() {\n        System.out.println(\"Z::Z\");\n    }\n    @Override\n\tpublic void close() throws Exception {\n        System.out.println(\"Z::~Z\");\n    }\n}\n"}, "Main\nX::X\nX::X\nX::~X\nX::~X\ntrue\nMain\nX::X\nX::X\nOuter Try\nY::Y\nY::Y\nY::~Y\nY::~Y\nX::~X\nX::~X\ntrue\nMain\nX::X\nX::X\nOuter Try\nY::Y\nY::Y\nMiddle Try\nZ::Z\nZ::Z\nInner Try\nZ::~Z\nZ::~Z\nY::~Y\nY::~Y\nX::~X\nX::~X\ntrue");
    }

    public void test375248() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\nimport java.io.InputStream;\nimport java.net.MalformedURLException;\nimport java.net.URL;\n\npublic class X {\n    public static void main(String[] args) throws Exception {\n      System.out.println(\"Done\");\n    }\n    public void foo() throws MalformedURLException {\n        URL url = new URL(\"dummy\"); //$NON-NLS-1$\n        try (InputStream is = url.openStream()) {\n        } catch (IOException e) {\n             return;\n        } finally {\n            try {\n                java.nio.file.Files.delete(null);\n            } catch (IOException e1) {\n            }\n        }\n    }\n}\n"}, "Done");
    }

    public void test375248a() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.net.MalformedURLException;\nimport java.net.URL;\nimport java.nio.file.Path;\nimport java.nio.file.StandardCopyOption;\n\npublic class X {\n    public static void main(String[] args) throws Exception {\n      System.out.println(\"Done\");\n    }\n    public void executeImports() throws MalformedURLException {\n        for (int i = 0; i < 3; i++) {\n            URL url = new URL(\"dummy\"); //$NON-NLS-1$\n            if (url != null) {\n                Path target = new File(\"dummy\").toPath();\n                try (InputStream is = url.openStream()) {\n                    java.nio.file.Files.copy(is, target,\n                            StandardCopyOption.REPLACE_EXISTING);\n                } catch (IOException e) {\n                     break;\n                } finally {\n                    try {\n                        java.nio.file.Files.delete(target);\n                    } catch (IOException e1) {\n\n                    }\n                }\n            }\n        }\n    }\n}\n"}, "Done");
    }

    public void test375248b() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.net.MalformedURLException;\nimport java.net.URL;\nimport java.nio.file.Path;\nimport java.nio.file.StandardCopyOption;\n\npublic class X {\n    public static void main(String[] args) throws Exception {\n      System.out.println(\"Done\");\n    }\n    public void executeImports() throws MalformedURLException {\n        for (int i = 0; i < 3; i++) {\n            URL url = new URL(\"dummy\"); //$NON-NLS-1$\n            if (url != null) {\n                Path target = new File(\"dummy\").toPath();\n                try (InputStream is = url.openStream()) {\n                    java.nio.file.Files.copy(is, target,\n                            StandardCopyOption.REPLACE_EXISTING);\n                } catch (IOException e) {\n                     continue;\n                } finally {\n                    try {\n                        java.nio.file.Files.delete(target);\n                    } catch (IOException e1) {\n\n                    }\n                }\n            }\n        }\n    }\n}\n"}, "Done");
    }

    public void test375248c() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.net.MalformedURLException;\nimport java.net.URL;\nimport java.nio.file.Path;\nimport java.nio.file.StandardCopyOption;\n\npublic class X implements AutoCloseable {\n\tpublic void foo()  {\n        try (X x = new X()) {\n\t     System.out.println(\"Try\");\n\t     throw new Exception();\n        } catch (Exception e) {\n\t     System.out.println(\"Catch\");\n             return;\n        } finally {\n        \tSystem.out.println(\"Finally\");\n        }\n    }\n\tpublic void close() {\n\t\tSystem.out.println(\"Close\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Try\nClose\nCatch\nFinally");
    }

    public void test375248d() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.net.MalformedURLException;\nimport java.net.URL;\nimport java.nio.file.Path;\nimport java.nio.file.StandardCopyOption;\n\npublic class X implements AutoCloseable {\n\tpublic void foo()  {\n        try (X x = new X()) {\n\t     System.out.println(\"Try\");\n        } catch (Exception e) {\n\t     System.out.println(\"Catch\");\n             return;\n        } finally {\n        \tSystem.out.println(\"Finally\");\n           return;\n        }\n    }\n\tpublic void close() {\n\t\tSystem.out.println(\"Close\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "Try\nClose\nFinally");
    }

    public void test375326() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tHasAutoCloseable a;\n\t\ttry(AutoCloseable b=(a=new HasAutoCloseable()).a) {\n\t\t}\n\t\tSystem.out.println(a);\n\t}\n\tpublic static class AutoCloseableA implements AutoCloseable {\n\t\t@Override\n\t\tpublic void close() {\n\t\t\t// TODO Auto-generated method stub\n\t\t}\n\t}\n\tpublic static class HasAutoCloseable {\n\t\tAutoCloseable a = new AutoCloseableA();\n\t\tpublic String toString() {\n\t\t\treturn \"SUCCESS\";\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test375326a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) throws Exception {\n        HasAutoCloseable aLocal;\n        try(AutoCloseable b=(new HasAutoCloseable()).a){\n        \taLocal = new HasAutoCloseable();\n        }\n        catch (Throwable e) {\n        }\n       System.out.println(aLocal.toString());       \n    } \n    public static class AutoCloseableA implements AutoCloseable{\n        @Override\n        public void close() {\n        }\n    }\n    public static class HasAutoCloseable{\n        AutoCloseable a=new AutoCloseableA(); \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tSystem.out.println(aLocal.toString());       \n\t                   ^^^^^^\nThe local variable aLocal may not have been initialized\n----------\n");
    }

    public void test375326b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) throws Exception {\n        HasAutoCloseable aLocal;\n        try(AutoCloseable b=(aLocal = new HasAutoCloseable()).a){\n        \t\n        }\n        catch (Throwable e) {\n        }\n       System.out.println(aLocal.toString());       \n    } \n    public static class AutoCloseableA implements AutoCloseable{\n        @Override\n        public void close() {\n        }\n    }\n    public static class HasAutoCloseable{\n        AutoCloseable a=new AutoCloseableA(); \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tSystem.out.println(aLocal.toString());       \n\t                   ^^^^^^\nThe local variable aLocal may not have been initialized\n----------\n");
    }

    public void test375326c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tHasAutoCloseable a;\n\t\ttry(AutoCloseable b=(a=new HasAutoCloseable()).a) {\n       } finally {\n            System.out.println(\"Finally\");\n        }\n\t\tSystem.out.println(a);\n\t}\n\tpublic static class AutoCloseableA implements AutoCloseable {\n\t\t@Override\n\t\tpublic void close() {\n\t\t\t// TODO Auto-generated method stub\n\t\t}\n\t}\n\tpublic static class HasAutoCloseable {\n\t\tAutoCloseable a = new AutoCloseableA();\n\t\tpublic String toString() {\n\t\t\treturn \"SUCCESS\";\n\t\t}\n\t}\n}"}, "Finally\nSUCCESS");
    }

    public void test375326d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) throws Exception {\n        HasAutoCloseable aLocal;\n        try(AutoCloseable b=(new HasAutoCloseable()).a){\n        \taLocal = new HasAutoCloseable();\n        }\n        catch (Throwable e) {\n        } finally {\n            System.out.println(\"Finally\");\n        }\n       System.out.println(aLocal.toString());       \n    } \n    public static class AutoCloseableA implements AutoCloseable{\n        @Override\n        public void close() {\n        }\n    }\n    public static class HasAutoCloseable{\n        AutoCloseable a=new AutoCloseableA(); \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tSystem.out.println(aLocal.toString());       \n\t                   ^^^^^^\nThe local variable aLocal may not have been initialized\n----------\n");
    }

    public void test375326e() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) throws Exception {\n        HasAutoCloseable aLocal;\n        try(AutoCloseable b=(aLocal = new HasAutoCloseable()).a){\n        \t\n        }\n        catch (Throwable e) {\n        } finally {\n            System.out.println(\"Finally\");\n        }\n       System.out.println(aLocal.toString());       \n    } \n    public static class AutoCloseableA implements AutoCloseable{\n        @Override\n        public void close() {\n        }\n    }\n    public static class HasAutoCloseable{\n        AutoCloseable a=new AutoCloseableA(); \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tSystem.out.println(aLocal.toString());       \n\t                   ^^^^^^\nThe local variable aLocal may not have been initialized\n----------\n");
    }

    public void test375326f() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void testWithResourcesAssignment() throws Exception{\n        HasAutoCloseable a;\n        try(AutoCloseable b=(a=new HasAutoCloseable()).a){\n        } finally {\n        \tSystem.out.println(a);\n        }\n    }\n    public class AutoCloseableA implements AutoCloseable{\n        @Override\n        public void close() {\n        }\n    }\n    public class HasAutoCloseable{\n        AutoCloseable a=new AutoCloseableA();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tSystem.out.println(a);\n\t                   ^\nThe local variable a may not have been initialized\n----------\n");
    }

    public void test375326g() {
        this.runNegativeTest(new String[]{"X.java", "class CheckedException extends Throwable {}\npublic class X {\n    public void testWithResourcesAssignment() throws Exception{\n        HasAutoCloseable a;\n        try(AutoCloseable b=(a=new HasAutoCloseable()).a){\n            throw new CheckedException();\n        } catch (CheckedException e) {\n            System.out.println(a);\n        } finally {\n        \tSystem.out.println(a);\n        }\n    }\n    public class AutoCloseableA implements AutoCloseable{\n        @Override\n        public void close() {\n        }\n    }\n    public class HasAutoCloseable{\n        AutoCloseable a=new AutoCloseableA();\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tclass CheckedException extends Throwable {}\n\t      ^^^^^^^^^^^^^^^^\nThe serializable class CheckedException does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 8)\n\tSystem.out.println(a);\n\t                   ^\nThe local variable a may not have been initialized\n----------\n3. ERROR in X.java (at line 10)\n\tSystem.out.println(a);\n\t                   ^\nThe local variable a may not have been initialized\n----------\n");
    }

    public void test380112a() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\ninterface I extends Closeable, Serializable {}\npublic class X {\n    public static void main(String [] args) {\n        try (I i = getX()) {\n        } catch (IOException x) {\n        }\n        System.out.println(\"Done\");\n    }\n    public static I getX() { return null;}\n    public X(){}\n}\n"}, "Done");
    }

    public void test380112b() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\ninterface I extends Closeable, Serializable {}\npublic class X {\n    public static void main(String [] args) {\n        try (I i = getX()) {\n        } catch (IOException x) {\n        } finally {\n          System.out.println(\"Done\");\n        }\n    }\n    public static I getX() { return null;}\n    public X(){}\n}\n"}, "Done");
    }

    public void test380112c() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\ninterface I2 { public void close() throws FileNotFoundException; }\ninterface I extends Closeable, I2 {}\npublic class X {\n    public static void main(String [] args) {\n        try (I i = getX()) {\n        } catch (FileNotFoundException x) {\n        }\n        System.out.println(\"Done\");\n    }\n    public static I getX() { return null;}\n    public X(){}\n}\n"}, "Done");
    }

    public void test380112d() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\ninterface I2 { public void close() throws FileNotFoundException; }\ninterface I extends Closeable, I2 {}\npublic class X {\n    public static void main(String [] args) {\n        try (I i = getX()) {\n        } catch (FileNotFoundException x) {\n        } finally {\n          System.out.println(\"Done\");\n        }\n    }\n    public static I getX() { return null;}\n    public X(){}\n}\n"}, "Done");
    }

    public void test380112e() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Test380112.jar";
        String[] defaultLibs = this.getDefaultClassPaths();
        String[] libs = new String[defaultLibs.length + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, defaultLibs.length);
        libs[defaultLibs.length] = path;
        this.runConformTest(new String[]{"X.java", "import java.io.*;\nimport pkg380112.I;\npublic class X {\n    public static void main(String [] args) {\n        try (I i = getX()) {\n        } catch (IOException x) {\n        }\n        System.out.println(\"Done\");\n    }\n    public static I getX() { return null;}\n    public X(){}\n}\n"}, "Done", libs, true, new String[]{"-cp", path});
    }

    public void test394780() {
        this.runConformTest(new String[]{"X.java", "public class X<R extends Resource> {\n    public static void main(String[] args) {\n        X<Resource> m = new X<>();\n        m.tryWithResource(new ResourceImpl());\n    }\n    public void tryWithResource(R resource) {\n        try (R r = resource) {\n            r.compute();\n        }\n    }\n}", "Resource.java", "public interface Resource extends AutoCloseable {\n    void compute();\n    @Override\n    public void close();\n}", "ResourceImpl.java", "public class ResourceImpl implements Resource {\n    @Override\n    public void close() {\n        System.out.print(\"close\");\n    }\n    @Override\n    public void compute() {\n        System.out.print(\"compute\");\n    }\n}"}, "computeclose");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.TryWithResourcesStatementTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

