/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.tests.eval.EvaluationTest;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.eval.GlobalVariable;

public class NegativeCodeSnippetTest
extends EvaluationTest
implements ProblemSeverities,
ProblemReasons {
    static /* synthetic */ Class class$0;

    public NegativeCodeSnippetTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NegativeCodeSnippetTest.setupSuite(NegativeCodeSnippetTest.testClass());
    }

    public void testChangePackage() {
        if (this.isJRockitVM()) {
            return;
        }
        try {
            this.context.setPackageName("java.util.zip".toCharArray());
            char[] codeSnippet = "new InflaterInputStream(new java.io.ByteArrayInputStream(new byte[0])).len".toCharArray();
            this.evaluateWithExpectedDisplayString(codeSnippet, "0".toCharArray());
            this.context.setPackageName(new char[0]);
            this.context.setImports((char[][])new char[][]{"java.util.zip.*".toCharArray()});
            this.evaluateWithExpectedProblem(codeSnippet, (CategorizedProblem)this.newProblem(33554503, 1, 71, 73, 1));
            this.context.setImports((char[][])new char[0][]);
            this.evaluateWithExpectedProblem(codeSnippet, (CategorizedProblem)this.newProblem(0x1000002, 1, 4, 22, 1));
        }
        finally {
            this.context.setPackageName(new char[0]);
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.eval.NegativeCodeSnippetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void testExpressionInInnerClass() {
        this.evaluateWithExpectedProblem(this.buildCharArray(new String[]{"class X {", "\tint foo() {", "\t\t1 + 1", "\t}", "}", "return new X().foo();"}), (CategorizedProblem)this.newProblem(0x600000CC, 1, 21, 21, 2));
    }

    public void testExtraClosingCurlyBracket() {
        this.evaluateWithExpectedProblem("1 + 2}".toCharArray(), (CategorizedProblem)this.newProblem(0x600000CC, 1, 0, 0, 1));
        this.evaluateWithExpectedProblem(this.buildCharArray(new String[]{"return 1 + 1;", " 2 + 2}"}), (CategorizedProblem)this.newProblem(0x600000CC, 1, 15, 15, 2));
    }

    public void testExtraOpenRoundBracket() {
        this.evaluateWithExpectedProblem("foo((a);".toCharArray(), (CategorizedProblem)this.newProblem(0x600000F0, 1, 6, 6, 1));
    }

    public void testExtraSemiColonInExpression() {
        this.evaluateWithExpectedProblem("1;".toCharArray(), (CategorizedProblem)this.newProblem(0x600000F0, 1, 0, 0, 1));
    }

    public void testInvalidField() {
        this.evaluateWithExpectedProblem("String s = \"\";\ns.length".toCharArray(), "length cannot be resolved or is not a field\n");
    }

    public void testInvalidImport() {
        try {
            this.context.setImports((char[][])new char[][]{"bar.Y".toCharArray()});
            this.evaluateWithExpectedImportProblem(this.buildCharArray(new String[]{"class X {", "\tY foo = new Y();", "}", "return new X().foo;"}), "bar.Y".toCharArray(), (CategorizedProblem)this.newProblem(268435846, 1, 0, 4, 1));
            this.context.setImports((char[][])new char[][]{"java.io.*".toCharArray(), "{".toCharArray()});
            this.evaluateWithExpectedImportProblem(this.buildCharArray(new String[]{"new File(\"c:\\temp\")"}), "{".toCharArray(), (CategorizedProblem)this.newProblem(1610612971, 1, 0, 0, 1));
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testInvalidUseOfThisInSnippet() {
        this.evaluateWithExpectedProblem("this".toCharArray(), "Cannot use this in a static context\n");
    }

    public void testInvalidUseOfThisInSnippet2() {
        this.evaluateWithExpectedProblem("return this;".toCharArray(), "Cannot use this in a static context\n");
    }

    public void testMissingClosingRoundBracket() {
        this.evaluateWithExpectedProblem(this.buildCharArray(new String[]{"System.out.println(\"3 + 3\";"}), (CategorizedProblem)this.newProblem(0x600000F0, 1, 19, 25, 1));
    }

    public void testMissingDoubleQuote() {
        this.evaluateWithExpectedProblem(this.buildCharArray(new String[]{"System.out.println(\"3 + 3 = );", "3 + 3"}), (CategorizedProblem)this.newProblem(1610612995, 1, 19, 29, 1));
    }

    public void testNonLastExpressionStatement() {
        this.evaluateWithExpectedProblem(this.buildCharArray(new String[]{"1 == '1';", "true"}), (CategorizedProblem)this.newProblem(1610612971, 1, 2, 3, 1));
    }

    public void testProblemInExpression() {
        this.evaluateWithExpectedProblem("new Object(); 3 + ".toCharArray(), (CategorizedProblem)this.newProblem(1610612968, 1, 16, 16, 1));
    }

    public void testProblemInExpression2() {
        this.evaluateWithExpectedProblem("new UnknownClass()".toCharArray(), (CategorizedProblem)this.newProblem(0x1000002, 1, 4, 15, 1));
    }

    public void testProblemInInnerClass() {
        this.evaluateWithExpectedProblem(this.buildCharArray(new String[]{"class X {", "\tY foo = new Y();", "}", "return new X().foo;"}), (CategorizedProblem)this.newProblem(0x1000002, 1, 11, 11, 2));
        this.evaluateWithExpectedWarningAndDisplayString(this.buildCharArray(new String[]{"return new Object() {", "\tpublic String toString() {", "\t\tint i = 0;", "\t\treturn \"an inner class\";", "\t}", "};"}), new CategorizedProblem[]{this.newProblem(536870973, 0, 56, 56, 3)}, "an inner class".toCharArray());
    }

    public void testProblemInPreviousStatement() {
        this.evaluateWithExpectedProblem(this.buildCharArray(new String[]{"return foo(a a);", "1 + 3"}), (CategorizedProblem)this.newProblem(1610612968, 1, 13, 13, 1));
    }

    public void testProblemInReturnStatement() {
        this.evaluateWithExpectedProblem("return 1 ++ 1;".toCharArray(), (CategorizedProblem)this.newProblem(1610612942, 1, 7, 7, 1));
    }

    public void testRemoveImport() {
        try {
            this.context.setImports((char[][])new char[][]{"java.io.*".toCharArray()});
            char[] codeSnippet = "new File(\"c:\\\\temp\")".toCharArray();
            this.evaluateWithExpectedDisplayString(codeSnippet, "c:\\temp".toCharArray());
            this.context.setImports((char[][])new char[0][]);
            this.evaluateWithExpectedProblem(codeSnippet, (CategorizedProblem)this.newProblem(0x1000002, 1, 4, 7, 1));
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testRemoveVariable() {
        GlobalVariable var = null;
        try {
            var = this.context.newVariable("int".toCharArray(), "i".toCharArray(), "1".toCharArray());
            this.installVariables(1);
            char[] codeSnippet = "i".toCharArray();
            this.evaluateWithExpectedDisplayString(codeSnippet, "1".toCharArray());
            this.context.deleteVariable(var);
            this.installVariables(0);
            this.evaluateWithExpectedProblem(codeSnippet, (CategorizedProblem)this.newProblem(33554515, 1, 0, 0, 1));
        }
        catch (Throwable throwable) {
            if (var != null) {
                this.context.deleteVariable(var);
            }
            throw throwable;
        }
        if (var != null) {
            this.context.deleteVariable(var);
        }
    }

    public void testUnreachableExpression() {
        this.evaluateWithExpectedProblem(this.buildCharArray(new String[]{"return 1 + 1;", "2 + 2"}), (CategorizedProblem)this.newProblem(536871073, 1, 14, 18, 2));
    }

    public void testUnusedImport() {
        try {
            this.context.setImports((char[][])new char[][]{"java.util.*".toCharArray()});
            Map options = this.getCompilerOptions();
            options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
            this.evaluateWithExpectedValue("1".toCharArray(), "1".toCharArray(), "int".toCharArray());
            this.evaluateWithExpectedImportProblem("new String(\"NOPE\")".toCharArray(), "java.util.*".toCharArray(), options, (CategorizedProblem)this.newProblem(268435844, 1, 0, 10, 1));
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testWarning() {
        this.evaluateWithExpectedWarningAndDisplayString(this.buildCharArray(new String[]{"int i;", "1 + 1"}), new CategorizedProblem[]{this.newProblem(536870973, 0, 4, 4, 1)}, "2".toCharArray());
    }
}

