/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;

public class JRockitVMLauncher
extends LocalVMLauncher {
    String batchFileName;

    protected String buildBootClassPath() {
        StringBuffer bootPathString = new StringBuffer();
        if (this.evalTargetPath != null) {
            bootPathString.append(this.evalTargetPath);
            bootPathString.append(File.separatorChar);
            bootPathString.append("bootPath");
        }
        return bootPathString.toString();
    }

    public String getBatchFileName() {
        return this.batchFileName;
    }

    public String[] getCommandLine() {
        Object[] result;
        Vector<String> commandLine = new Vector<String>();
        if (System.getProperty("java.vm.version").startsWith("1.4.2")) {
            commandLine.addElement(String.valueOf(this.vmPath) + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "java");
        } else {
            String vmLocation = String.valueOf(this.vmPath) + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "javaw";
            String osName = System.getProperty("os.name");
            if (osName.indexOf("win32") != -1) {
                vmLocation = String.valueOf(vmLocation) + ".exe";
            }
            if (!new File(vmLocation).exists()) {
                vmLocation = String.valueOf(this.vmPath) + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "java";
            }
            commandLine.addElement(vmLocation);
        }
        if (this.vmArguments != null) {
            int i = 0;
            while (i < this.vmArguments.length) {
                commandLine.addElement(this.vmArguments[i]);
                ++i;
            }
        }
        if (this.debugPort != -1) {
            commandLine.addElement("-Xdebug");
            commandLine.addElement("-Xnoagent");
            commandLine.addElement("-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=n");
        }
        commandLine.addElement("-classpath");
        String classpath = String.valueOf(this.buildBootClassPath()) + File.pathSeparator + this.buildClassPath();
        System.out.println(classpath);
        commandLine.addElement(classpath);
        if (this.evalPort != -1) {
            commandLine.addElement("org.eclipse.jdt.core.tests.eval.target.CodeSnippetRunner");
        }
        if (this.evalPort != -1) {
            commandLine.addElement("-evalport");
            commandLine.addElement(Integer.toString(this.evalPort));
            commandLine.addElement("-cscp");
            commandLine.addElement(String.valueOf(this.evalTargetPath) + File.separator + "regularPath");
            commandLine.addElement("-csbp");
            commandLine.addElement(String.valueOf(this.evalTargetPath) + File.separator + "bootPath");
        }
        if (this.programClass != null) {
            commandLine.addElement(this.programClass);
        }
        if (this.programArguments != null) {
            int i = 0;
            while (i < this.programArguments.length) {
                commandLine.addElement(this.programArguments[i]);
                ++i;
            }
        }
        if (this.batchFileName != null) {
            this.writeBatchFile(this.batchFileName, commandLine);
            result = new String[]{this.batchFileName};
        } else {
            result = new String[commandLine.size()];
            commandLine.copyInto(result);
        }
        int i = 0;
        while (i < result.length) {
            Object argument = result[i];
            if (((String)argument).indexOf(32) != -1) {
                result[i] = "\"" + (String)argument + "\"";
            }
            ++i;
        }
        return result;
    }

    public void setBatchFileName(String batchFileName) {
        this.batchFileName = batchFileName;
    }

    protected void writeBatchFile(String fileName, Vector commandLine) {
        block15: {
            FileOutputStream output = null;
            try {
                try {
                    output = new FileOutputStream(fileName);
                    PrintWriter out = new PrintWriter(output);
                    Enumeration e = commandLine.elements();
                    while (e.hasMoreElements()) {
                        out.print((String)e.nextElement());
                        out.print(" ");
                    }
                    out.println("pause");
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

