/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.runtime.VMInputStream;
import org.eclipse.jdt.core.tests.util.Util;

public class LocalVirtualMachine {
    protected Process process;
    protected int debugPort;
    protected String evalTargetPath;

    public LocalVirtualMachine() {
        this.process = null;
        this.debugPort = -1;
        this.evalTargetPath = null;
    }

    public LocalVirtualMachine(Process p, int debugPort, String evalTargetPath) {
        this.process = p;
        this.debugPort = debugPort;
        this.evalTargetPath = evalTargetPath;
    }

    protected void cleanupTargetPath() throws TargetException {
        if (this.evalTargetPath == null) {
            return;
        }
        String targetPath = this.evalTargetPath;
        Util.delete(new File(targetPath, "regularPath"));
        Util.delete(new File(targetPath, "bootPath"));
        File file = new File(targetPath, "EvalTestsTarget.zip");
        if (!Util.delete(file)) {
            throw new TargetException("Could not delete " + file.getPath());
        }
    }

    public int getDebugPortNumber() {
        return this.debugPort;
    }

    public InputStream getErrorStream() throws TargetException {
        if (this.process == null) {
            throw new TargetException("The VM is not running");
        }
        return this.process.getErrorStream();
    }

    public InputStream getInputStream() throws TargetException {
        if (this.process == null) {
            throw new TargetException("The VM is not running");
        }
        return new VMInputStream(this.process, this.process.getInputStream());
    }

    public OutputStream getOutputStream() throws TargetException {
        if (this.process == null) {
            throw new TargetException("The VM is not running");
        }
        return this.process.getOutputStream();
    }

    public boolean isRunning() {
        boolean hasExited;
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            hasExited = true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            hasExited = false;
        }
        return !hasExited;
    }

    public synchronized void shutDown() throws TargetException {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
            this.cleanupTargetPath();
        }
    }
}

