/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class AssertionTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public AssertionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return AssertionTest.buildMinimalComplianceTestSuite(AssertionTest.testClass(), 2);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.AssertionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"assert.java", "public class assert {}\n"}, "----------\n1. ERROR in assert.java (at line 1)\n\tpublic class assert {}\n\t             ^^^^^^\nSyntax error on token \"assert\", Identifier expected\n----------\n");
    }

    public void test002() {
        this.runConformTest(new String[]{"A4.java", "public class A4 { \n\tpublic static void main(String[] args) {\n   try {\t\n    int i = 4;\n    assert i != 4;\n\t   System.out.println(i);\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.print(\"SUCCESS\");\t\n\t  } \n\t} \n} \n"}, "SUCCESS", null, true, new String[]{"-ea"});
    }

    public void test003() {
        this.runConformTest(new String[]{"A4.java", "public class A4 { \n\tpublic static void main(String[] args) {\n    int i = 4;\n    assert i != 4;\n\t   System.out.println(i);\n\t} \n} \n"}, "4", null, true, new String[]{"-da"});
    }

    public void test004() {
        this.runConformTest(new String[]{"A4.java", "public class A4 { \n\tpublic static void main(String[] args) {\n   try {\t\n\t\tassert false : \"SUC\";\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.print(e.getMessage());\t\n\t  }\t\n\t  try {\t\n\t\tassert false : new Object(){ public String toString(){ return \"CESS\";}};\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.println(e.getMessage());\t\n\t  }\t\n  }\t\n} \n"}, "SUCCESS", null, true, new String[]{"-ea"});
    }

    public void test005() {
        this.runConformTest(new String[]{"A4.java", "public class A4 { \n\tpublic static void main(String[] args) {\n   try {\t\n\t\tassert false : 1;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.print(e.getMessage());\t\n\t  }\t\n\t  try {\t\n\t\tint i = 2;\t\n\t\tassert false : i;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.println(e.getMessage());\t\n\t  }\t\n  }\t\n} \n"}, "12", null, true, new String[]{"-ea"});
    }

    public void test006() {
        this.runNegativeTest(new String[]{"A4.java", "public class A4 { \n\tpublic static void main(String[] args) {\n\t  try {\t\n\t\tassert false : unbound;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.println(e.getMessage());\t\n\t  }\t\n  }\t\n} \n"}, "----------\n1. ERROR in A4.java (at line 4)\n\tassert false : unbound;\t\n\t               ^^^^^^^\nunbound cannot be resolved to a variable\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"A4.java", "public class A4 { \n\tpublic static void main(String[] args) {\n   try {\t\n\t\tassert false : 1L;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.print(e.getMessage());\t\n\t  }\t\n   try {\t\n\t\tassert false : 0L;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.print(e.getMessage());\t\n\t  }\t\n\t  try {\t\n\t\tlong l = 2L;\t\n\t\tassert false : l;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.println(e.getMessage());\t\n\t  }\t\n  }\t\n} \n"}, "102", null, true, new String[]{"-ea"});
    }

    public void test008() {
        this.runConformTest(new String[]{"A4.java", "public class A4 { \n\tpublic static void main(String[] args) {\n   try {\t\n\t\tassert false : 1.0f;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.print(e.getMessage());\t\n\t  }\t\n\t  try {\t\n\t\tfloat f = 2.0f;\t\n\t\tassert false : f;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.println(e.getMessage());\t\n\t  }\t\n  }\t\n} \n"}, "1.02.0", null, true, new String[]{"-ea"});
    }

    public void test009() {
        this.runConformTest(new String[]{"A4.java", "public class A4 { \n\tpublic static void main(String[] args) {\n   try {\t\n\t\tassert false : 1.0;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.print(e.getMessage());\t\n\t  }\t\n\t  try {\t\n\t\tdouble d = 2.0;\t\n\t\tassert false : d;\t\n\t  } catch(AssertionError e){\t\n\t\tSystem.out.println(e.getMessage());\t\n\t  }\t\n  }\t\n} \n"}, "1.02.0", null, true, new String[]{"-ea"});
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "public class X { \n\tpublic static void main(String[] args) { \n\t\tI.Inner inner = new I.Inner(); \n\t\ttry { \n\t\t\tinner.test(); \n\t\t\tSystem.out.println(\"FAILED\"); \n\t\t} catch(AssertionError e){ \n\t\t\tSystem.out.println(\"SUCCESS\"); \n\t\t} \n\t} \n} \ninterface I { \n  public static class Inner { \n    public void test() { \n      assert false; \n    } \n  } \n} \n"}, "SUCCESS", null, true, new String[]{"-ea"});
    }

    public void test011() {
        this.runConformTest(new String[]{"AssertTest.java", "public class AssertTest {\n   public AssertTest() {}\n   public class InnerClass {\n      InnerClass() {\n        assert(false);\n      }\n   }\n   \n   public static void main(String[] args) {\t\n        System.out.print(\"SUCCESS\");\t\n\t}\t\n}"}, "SUCCESS");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main( String[] args ) {\n        try {\n            throw new Throwable( \"This is a test\");\n        }\n        catch( Throwable ioe ) {\n            assert false : ioe;\n        }\n        System.out.print(\"SUCCESS\");\t\n    }\n}\n"}, "SUCCESS");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "public class X {\n        static class Y {\n                public static void test() {\n                        assert false;\n                        System.out.println(\"SUCCESS\");\n                }\n        }\n        public static void main(String[] args) {\n                ClassLoader classLoader = new X().getClass().getClassLoader();\n                // enable assertion for X.Y\n                classLoader.setClassAssertionStatus(\"X$Y\", true);\n                X.Y.test();\n        }\n}"}, "SUCCESS");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static class Foo {\n\t\tpublic void myMethod(boolean trash) {\n\t\t\tSystem.out.println(\"Expecting class Foo\");\n\t\t\tClass c = Foo.class;\n\t\t\tSystem.out.println(\"Got the class \" + c);\n\t\t}\n\t}\n\tpublic static class Bar {\n\t\tpublic void myMethod(boolean doAssert) {\n\t\t\tSystem.out.println(\"Expecting class Bar\");\n\t\t\tClass c = Bar.class;\n\t\t\tSystem.out.println(\"Got the class \" + c);\n\t\t\tassert c.getName().endsWith(\"Bar\");\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Foo().myMethod(false);\n\t\tnew Bar().myMethod(false);\n\t}\n}"}, "Expecting class Foo\nGot the class class X$Foo\nExpecting class Bar\nGot the class class X$Bar");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static class Foo {\n\t\tpublic void myMethod(boolean trash) {\n\t\t\tSystem.out.println(\"Expecting class Foo\");\n\t\t\tClass c = Foo.class;\n\t\t\tSystem.out.println(\"Got the class \" + c);\n\t\t}\n\t}\n\tpublic static class Bar {\n\t\tpublic void myMethod(boolean doAssert) {\n\t\t\tSystem.out.println(\"Expecting class Bar\");\n\t\t\tClass c = Bar.class;\n\t\t\ttry {\n\t\t\t\tassert c.getName().endsWith(\"Bar2\");\n\t\t\t} catch(AssertionError e) {\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t}\n\t\t\tSystem.out.println(\"Got the class \" + c);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Foo().myMethod(false);\n\t\tnew Bar().myMethod(false);\n\t}\n}"}, "Expecting class Foo\nGot the class class X$Foo\nExpecting class Bar\nSUCCESS\nGot the class class X$Bar", null, true, new String[]{"-ea"});
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static class Foo {\n\t\tpublic void myMethod(boolean trash) {\n\t\t\tSystem.out.println(\"Expecting class Foo\");\n\t\t\tClass c = Foo.class;\n\t\t\tSystem.out.println(\"Got the class \" + c);\n\t\t}\n\t}\n\tpublic static class Bar {\n\t\tpublic void myMethod(boolean doAssert) {\n\t\t\tSystem.out.println(\"Expecting class Bar\");\n\t\t\tClass c = Bar.class;\n\t\t\ttry {\n\t\t\t\tassert c.getName().endsWith(\"Bar2\");\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t} catch(AssertionError e) {\n\t\t\t\tSystem.out.println(\"FAILED\");\n\t\t\t}\n\t\t\tSystem.out.println(\"Got the class \" + c);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Foo().myMethod(false);\n\t\tnew Bar().myMethod(false);\n\t}\n}"}, "Expecting class Foo\nGot the class class X$Foo\nExpecting class Bar\nSUCCESS\nGot the class class X$Bar", null, true, new String[]{"-da"});
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprotected void transform1(boolean srcPts) {\n\t\tfinal float error1;\n\t\tassert !(srcPts && (error1 = maxError()) > 0) : error1;\n\t}\n\tfloat foo1(boolean srcPts) {\n\t\tfinal float error2;\n\t\tif (!(srcPts && (error2 = maxError()) > 0)) {\n\t\t} else {\n\t\t\treturn error2;\n\t\t}\n\t\treturn 0;\n\t}\n\tfloat bar1(boolean srcPts) {\n\t\tfinal float error3;\n\t\tif ((srcPts && (error3 = maxError()) > 0)) {\n\t\t\treturn error3;\n\t\t}\n\t\treturn 0;\n\t}\t\n\tprotected void transform2(boolean srcPts) {\n\t\tfinal float error4;\n\t\tassert (srcPts && (error4 = maxError()) > 0) : error4;\n\t}\n\tfloat foo2(boolean srcPts) {\n\t\tfinal float error5;\n\t\tif (srcPts && (error5 = maxError()) > 0) {\n\t\t} else {\n\t\t\treturn error5;\n\t\t}\n\t\treturn 0;\n\t}\n\tfloat bar2(boolean srcPts) {\n\t\tfinal float error6;\n\t\tif (!(srcPts && (error6 = maxError()) > 0)) {\n\t\t\treturn error6;\n\t\t}\n\t\treturn 0;\n\t}\n\tprivate float maxError() {\n\t\treturn 0;\n\t}\n\n}\n"}, "----------\n1. ERROR in X.java (at line 23)\n\tassert (srcPts && (error4 = maxError()) > 0) : error4;\n\t                                               ^^^^^^\nThe local variable error4 may not have been initialized\n----------\n2. ERROR in X.java (at line 29)\n\treturn error5;\n\t       ^^^^^^\nThe local variable error5 may not have been initialized\n----------\n3. ERROR in X.java (at line 36)\n\treturn error6;\n\t       ^^^^^^\nThe local variable error6 may not have been initialized\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static final int i;\n    static {\n        assert (i = 0) == 0;\n        System.out.println(i);\n    }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tstatic final int i;\n\t                 ^\nThe blank final field i may not have been initialized\n----------\n2. ERROR in X.java (at line 5)\n\tSystem.out.println(i);\n\t                   ^\nThe blank final field i may not have been initialized\n----------\n");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static final int i;\n    static {\n        i = 0;\n        assert i == 0;\n        System.out.println(i);\n    }\n}"}, "");
    }

    public void test020() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void method1() {\n\t\t int i;        assert (i = 0) == 0;\n        System.out.println(i);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tSystem.out.println(i);\n\t                   ^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test021() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int bar() {\n\t\treturn 1;\n\t}\n    void method1() {\n\t\t int i;        assert (i = this.bar()) == 0;\n        System.out.println(i);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(i);\n\t                   ^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test022() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic int bar() {\n\t\treturn 1;\n\t}\n    void method1() {\n\t\t int i;\n        assert i++ == 0;\n        System.out.println(i);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tassert i++ == 0;\n\t       ^\nThe local variable i may not have been initialized\n----------\n2. ERROR in X.java (at line 8)\n\tSystem.out.println(i);\n\t                   ^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test023() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "interface Foo {\n  default Object test(Object a) {\n    assert a != null; // triggers creation of bogus synthetic field\n    return a;\n  }\n}\npublic class X implements Foo {\n\tpublic static void main(String[] args) {\n\t\tnew X().test(\"\");\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "Hello");
    }
}

