/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.CompilerInvocationTests;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class CompilerInvocationTests
extends AbstractRegressionTest {
    private static Map categoryNames;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public CompilerInvocationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return CompilerInvocationTests.buildAllCompliancesTestSuite(CompilerInvocationTests.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.CompilerInvocationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001_irritant_warning_token() {
        HashMap<String, String> matcher = new HashMap<String, String>();
        int group = 0;
        while (group < 3) {
            int i = 0;
            while (i < 29) {
                int irritant = (group << 29) + (1 << i);
                String token = CompilerOptions.warningTokenFromIrritant((int)irritant);
                if (token != null) {
                    matcher.put(token, token);
                    CompilerInvocationTests.assertTrue((CompilerOptions.warningTokenToIrritants((String)token) != null ? 1 : 0) != 0);
                }
                ++i;
            }
            ++group;
        }
        String[] allTokens = CompilerOptions.warningTokens;
        int length = allTokens.length;
        matcher.put("all", "all");
        CompilerInvocationTests.assertEquals((int)allTokens.length, (int)matcher.size());
        int i = 0;
        while (i < length) {
            CompilerInvocationTests.assertNotNull(matcher.get(allTokens[i]));
            ++i;
        }
    }

    public void test002_problem_categories() {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.compiler.IProblem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> iProblemClass = clazz;
            Field[] fields = clazz.getFields();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                int problemId;
                int maskedProblemId;
                Field field = fields[i];
                if (field.getType() == Integer.TYPE && (maskedProblemId = (problemId = field.getInt(iProblemClass)) & 0xFFFFFF) != 0 && maskedProblemId != 0xFFFFFF && ProblemReporter.getProblemCategory((int)1, (int)problemId) == 0) {
                    CompilerInvocationTests.fail((String)("unspecified category for problem " + field.getName()));
                }
                ++i;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            CompilerInvocationTests.fail((String)"could not access members");
        }
    }

    static String taskTagsAsCutAndPaste(CategorizedProblem[] tasks) {
        String[] arguments;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < tasks.length - 1) {
            arguments = tasks[i].getArguments();
            System.out.print("\t\t\"[");
            System.out.print(arguments[0]);
            System.out.print(',');
            System.out.print(arguments[1]);
            System.out.print(',');
            System.out.print(arguments[2]);
            System.out.println("]\\n\" +");
            ++i;
        }
        arguments = tasks[tasks.length - 1].getArguments();
        System.out.print("\t\t\"[");
        System.out.print(arguments[0]);
        System.out.print(',');
        System.out.print(arguments[1]);
        System.out.print(',');
        System.out.print(arguments[2]);
        System.out.println("]\\n\"");
        return result.toString();
    }

    static String taskTagsAsStrings(CategorizedProblem[] tasks) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < tasks.length) {
            String[] arguments = tasks[i].getArguments();
            result.append('[');
            result.append(arguments[0]);
            result.append(',');
            result.append(arguments[1]);
            result.append(',');
            result.append(arguments[2]);
            result.append(']');
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    public void runTaskTagsOptionsTest(String[] testFiles, Map customOptions, String expectedTags) {
        TasksReader reader = new TasksReader();
        Hashtable options = JavaCore.getDefaultOptions();
        if (customOptions != null) {
            options.putAll(customOptions);
        }
        this.runConformTest(testFiles, "", null, true, null, options, reader, true);
        String tags = CompilerInvocationTests.taskTagsAsStrings(reader.result.tasks);
        if (!tags.equals(expectedTags)) {
            System.out.println(String.valueOf(this.getClass().getName()) + '#' + this.getName());
            System.out.println("Effective results:");
            System.out.println(tags);
            System.out.println("Cut and paste:");
            CompilerInvocationTests.taskTagsAsCutAndPaste(reader.result.tasks);
            CompilerInvocationTests.assertEquals(expectedTags, tags);
        }
    }

    public void test003_task_tags_options() {
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, null, "[FIXME, message contents,HIGH]\n[TODO, message contents,NORMAL]\n[XXX, message contents,NORMAL]\n");
    }

    public void _test004_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME, message contents,NORMAL]\n[TODO, message contents,NORMAL]\n[XXX, message contents,NORMAL]\n");
    }

    public void _test005_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", ",,");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME,message contents,NORMAL]\n[TODO,message contents,NORMAL]\n[XXX,message contents,NORMAL]\n");
    }

    public void _test006_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "A,B,C,D,E");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME,message contents,NORMAL]\n[TODO,message contents,NORMAL]\n[XXX,message contents,NORMAL]\n");
    }

    public void test007_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,NORMAL,NORMAL");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME, message contents,NORMAL]\n[TODO, message contents,NORMAL]\n[XXX, message contents,NORMAL]\n");
    }

    public void _test008_task_tags_options() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,NORMAL");
        this.runTaskTagsOptionsTest(new String[]{"X.java", "public class X {\n  void foo(X x) {\n    // FIXME TODO XXX message contents\n  }\n}\n"}, customOptions, "[FIXME,message contents,NORMAL]\n[TODO,message contents,NORMAL]\n[XXX,message contents,NORMAL]\n");
    }

    public void test009_missing_message_templates() {
        CompilerInvocationTests.assertEquals("Unable to retrieve the error message for problem id: 16777215. Check compiler resources.", new DefaultProblemFactory().getLocalizedMessage(Integer.MAX_VALUE, new String[0]));
    }

    public void test010_missing_elaboration_templates() {
        CompilerInvocationTests.assertEquals("Unable to retrieve the error message elaboration for elaboration id: 1073741823. Check compiler resources.", new DefaultProblemFactory().getLocalizedMessage(0, 0x3FFFFFFF, new String[]{"Zork"}));
    }

    public void test011_problem_categories() {
        try {
            class ProblemAttributes {
                boolean deprecated;
                int category;
                final /* synthetic */ CompilerInvocationTests this$0;

                ProblemAttributes(CompilerInvocationTests compilerInvocationTests, int category) {
                    this.this$0 = compilerInvocationTests;
                    this.category = category;
                }

                ProblemAttributes(CompilerInvocationTests compilerInvocationTests, boolean deprecated) {
                    this.this$0 = compilerInvocationTests;
                    this.deprecated = deprecated;
                }
            }
            ProblemAttributes DEPRECATED = new ProblemAttributes(this, true);
            HashMap<String, ProblemAttributes> expectedProblemAttributes = new HashMap<String, ProblemAttributes>();
            expectedProblemAttributes.put("AbstractMethodCannotBeOverridden", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AbstractMethodInAbstractClass", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AbstractMethodInEnum", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AbstractMethodMustBeImplemented", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AbstractMethodMustBeImplementedOverConcreteMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AbstractMethodsInConcreteClass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("AmbiguousConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AmbiguousConstructorInDefaultConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AmbiguousConstructorInImplicitConstructorCall", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AmbiguousField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AmbiguousMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AmbiguousType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("AnnotationCannotOverrideMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("AnnotationCircularity", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("AnnotationCircularitySelfReference", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("AnnotationFieldNeedConstantInitialization", DEPRECATED);
            expectedProblemAttributes.put("AnnotationMembersCannotHaveParameters", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("AnnotationMembersCannotHaveTypeParameters", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveConstructor", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveSuperclass", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveSuperinterfaces", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("AnnotationTypeUsedAsSuperInterface", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("AnnotationValueMustBeAnEnumConstant", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("AnnotationValueMustBeAnnotation", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("AnnotationValueMustBeArrayInitializer", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("AnnotationValueMustBeClassLiteral", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("AnnotationValueMustBeConstant", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("AnonymousClassCannotExtendFinalClass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ApplicableMethodOverriddenByInapplicable", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("ArgumentHidingField", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("ArgumentHidingLocalVariable", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("ArgumentIsNeverUsed", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("ArgumentTypeAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeCannotBeVoid", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("ArgumentTypeCannotBeVoidArray", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeNotFound", DEPRECATED);
            expectedProblemAttributes.put("ArgumentTypeNotVisible", DEPRECATED);
            expectedProblemAttributes.put("ArrayConstantsOnlyInArrayInitializers", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ArrayReferencePotentialNullReference", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ArrayReferenceRequired", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("AssignmentHasNoEffect", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("AssignmentToMultiCatchParameter", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("AssignmentToResource", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("AutoManagedResourceNotBelow17", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("BinaryLiteralNotBelow17", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("BodyForAbstractMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("BodyForNativeMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("BoundCannotBeArray", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("BoundHasConflictingArguments", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("BoundMustBeAnInterface", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("BoxingConversion", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("BytecodeExceeds64KLimit", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForClinit", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForConstructor", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotAllocateVoidArray", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotDeclareEnumSpecialMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("CannotDefineAnnotationInLocalType", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotDefineDimensionExpressionsWithInit", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotDefineEnumInLocalType", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotDefineInterfaceInLocalType", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotDefineStaticInitializerInLocalType", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotExtendEnum", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("CannotHideAnInstanceMethodWithAStaticMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("CannotImplementIncompatibleNullness", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("CannotImportPackage", new ProblemAttributes(this, 30));
            expectedProblemAttributes.put("CannotInferElidedTypes", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("CannotInvokeSuperConstructorInEnum", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("CannotOverrideAStaticMethodWithAnInstanceMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("CannotReadSource", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotReturnInInitializer", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotThrowNull", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CannotThrowType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("CannotUseDiamondWithAnonymousClasses", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("CannotUseDiamondWithExplicitTypeArguments", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("CannotUseSuperInCodeSnippet", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ClassExtendFinalClass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("CodeCannotBeReached", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CodeSnippetMissingClass", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("CodeSnippetMissingMethod", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ContainerAnnotationTypeHasNonDefaultMembers", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ContainerAnnotationTypeHasShorterRetention", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ContainerAnnotationTypeHasWrongValueType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ContainerAnnotationTypeMustHaveValue", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ContradictoryNullAnnotations", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ContradictoryNullAnnotationsOnBound", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ContradictoryNullAnnotationsInferred", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ComparingIdentical", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ConflictingImport", new ProblemAttributes(this, 30));
            expectedProblemAttributes.put("ConflictingNullAnnotations", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ConstructedArrayIncompatible", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("ConstructionTypeMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ConflictingInheritedNullAnnotations", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ConstructorReferenceNotBelow18", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ConstructorVarargsArgumentNeedCast", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("CorruptedSignature", new ProblemAttributes(this, 10));
            expectedProblemAttributes.put("DanglingReference", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DeadCode", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("DefaultMethodNotBelow18", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("DefaultMethodOverridesObjectMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DereferencingNullableExpression", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("DiamondNotBelow17", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DirectInvocationOfAbstractMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DisallowedTargetForContainerAnnotationType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DisallowedTargetForAnnotation", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DisallowedExplicitThisParameter", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("DiscouragedReference", new ProblemAttributes(this, 150));
            expectedProblemAttributes.put("DuplicateAnnotation", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DuplicateAnnotationNotMarkedRepeatable", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DuplicateAnnotationMember", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("DuplicateBlankFinalFieldInitialization", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateBounds", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DuplicateBoundInIntersectionCast", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DuplicateCase", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateDefaultCase", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("DuplicateField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateFinalLocalInitialization", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("DuplicateImport", new ProblemAttributes(this, 30));
            expectedProblemAttributes.put("DuplicateInheritedMethods", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateInheritedDefaultMethods", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateLabel", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("DuplicateMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateMethodErasure", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DuplicateModifierForArgument", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateModifierForField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateModifierForMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateModifierForType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DuplicateModifierForVariable", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateNestedType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DuplicateParameterizedMethods", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("DuplicateSuperInterface", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("DuplicateTargetInTargetAnnotation", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("DuplicateTypeVariable", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("DuplicateTypes", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("EmptyControlFlowStatement", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("EnclosingInstanceInConstructorCall", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("EndOfSource", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("EnumAbstractMethodMustBeImplemented", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("EnumConstantCannotDefineAbstractMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("EnumConstantMustImplementAbstractMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("EnumConstantsCannotBeSurroundedByParenthesis", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("EnumStaticFieldInInInitializerContext", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("EnumSwitchCannotTargetField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("ExceptionTypeAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("ExceptionTypeInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("ExceptionTypeInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("ExceptionTypeNotFound", DEPRECATED);
            expectedProblemAttributes.put("ExceptionTypeNotVisible", DEPRECATED);
            expectedProblemAttributes.put("ExplicitThisParameterNotInLambda", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ExplicitThisParameterNotBelow18", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ExplicitlyClosedAutoCloseable", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("ExpressionShouldBeAVariable", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ExternalProblemFixable", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ExternalProblemNotFixable", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ExplicitAnnotationTargetRequired", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("FallthroughCase", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("FieldComparisonYieldsFalse", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("FieldHidingField", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("FieldHidingLocalVariable", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("FieldMissingDeprecatedAnnotation", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("FieldTypeAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("FieldTypeInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("FieldTypeInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("FieldTypeNotFound", DEPRECATED);
            expectedProblemAttributes.put("FieldTypeNotVisible", DEPRECATED);
            expectedProblemAttributes.put("FinalBoundForTypeVariable", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("FinalFieldAssignment", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("FinalMethodCannotBeOverridden", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("FinalOuterLocalAssignment", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("FinallyMustCompleteNormally", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ForbiddenReference", new ProblemAttributes(this, 150));
            expectedProblemAttributes.put("GenericConstructorTypeArgumentMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("GenericInferenceError", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("GenericMethodTypeArgumentMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("GenericTypeCannotExtendThrowable", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("HidingEnclosingType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("HierarchyCircularity", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("HierarchyCircularitySelfReference", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("HierarchyHasProblems", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalAbstractModifierCombinationForMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalStrictfpForAbstractInterfaceMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalAccessFromTypeVariable", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalAnnotationForBaseType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalCast", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalClassLiteralForTypeVariable", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalDeclarationOfThisParameter", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalDefaultModifierSpecification", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalDefinitionToNonNullParameter", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("IllegalDimension", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("IllegalEnclosingInstanceSpecification", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalExtendedDimensions", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalExtendedDimensionsForVarArgs", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalGenericArray", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalHexaLiteral", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalInstanceofParameterizedType", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("IllegalInstanceofTypeParameter", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("IllegalBasetypeInIntersectionCast", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierCombinationFinalAbstractForClass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierCombinationFinalVolatileForField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierCombinationForInterfaceMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForAnnotationField", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("IllegalModifierForAnnotationMemberType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForAnnotationMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForAnnotationType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForArgument", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForClass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForEnum", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForEnumConstant", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForEnumConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForInterface", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForInterfaceField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod18", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForLocalClass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForLocalEnum", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForMemberClass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForMemberEnum", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForMemberInterface", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalModifierForMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifierForVariable", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalModifiersForElidedType", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("IllegalModifiers", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("IllegalPrimitiveOrArrayTypeForEnclosingInstance", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalQualifiedEnumConstantLabel", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalQualifiedParameterizedTypeAllocation", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalQualifierForExplicitThis", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalQualifierForExplicitThis2", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalReturnNullityRedefinition", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("IllegalRedefinitionToNonNullParameter", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("IllegalStaticModifierForMemberType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalTypeAnnotationsInStaticMemberAccess", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalTypeArgumentsInRawConstructorReference", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalTypeForExplicitThis", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalTypeVariableSuperReference", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("IllegalUnderscorePosition", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalUsageOfQualifiedTypeReference", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalUsageOfTypeAnnotations", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("IllegalVararg", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalVarargInLambda", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForMemberType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IllegalVisibilityModifierForInterfaceMemberType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ImportAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("ImportInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("ImportInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("ImportNotFound", new ProblemAttributes(this, 30));
            expectedProblemAttributes.put("ImportNotVisible", DEPRECATED);
            expectedProblemAttributes.put("IncompatibleExceptionInInheritedMethodThrowsClause", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IncompatibleExceptionInThrowsClause", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IncompatibleExceptionInThrowsClauseForNonInheritedInterfaceMethod", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("IncompatibleLambdaParameterType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncompatibleMethodReference", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IncompatibleReturnType", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("IncompatibleReturnTypeForNonInheritedInterfaceMethod", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("IncompatibleTypesInConditionalOperator", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncompatibleTypesInEqualityOperator", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncompatibleTypesInForeach", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncorrectArityForParameterizedConstructor", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncorrectArityForParameterizedMethod", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncorrectArityForParameterizedType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncorrectEnclosingInstanceReference", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncorrectSwitchType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IncorrectSwitchType17", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IndirectAccessToStaticField", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("IndirectAccessToStaticMethod", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("IndirectAccessToStaticType", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("InheritedDefaultMethodConflictsWithOtherInherited", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("InheritedFieldHidesEnclosingName", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("InheritedIncompatibleReturnType", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("InheritedMethodHidesEnclosingName", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("InheritedMethodReducesVisibility", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("InheritedTypeHidesEnclosingName", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InitializerMustCompleteNormally", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InstanceFieldDuringConstructorInvocation", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("InstanceMethodDuringConstructorInvocation", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("InterfaceAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("InterfaceCannotHaveConstructors", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InterfaceCannotHaveInitializers", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InterfaceInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("InterfaceInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("InterfaceNotFound", DEPRECATED);
            expectedProblemAttributes.put("InterfaceNotFunctionalInterface", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InterfaceNotVisible", DEPRECATED);
            expectedProblemAttributes.put("InternalTypeNameProvided", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IntersectionCastNotBelow18", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InvalidAnnotationMemberType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InvalidArrayConstructorReference", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("InvalidBinary", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidBreak", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidCatchBlockSequence", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InvalidCharacterConstant", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidClassInstantiation", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InvalidContinue", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidDigit", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidEncoding", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidEscape", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidExplicitConstructorCall", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidExpressionAsStatement", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidFileNameForPackageAnnotations", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidFloat", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidHexa", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidHighSurrogate", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidInput", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidLowSurrogate", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidLocationForModifiers", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidNullToSynchronized", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidOctal", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidOperator", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidParameterizedExceptionType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InvalidParenthesizedExpression", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidTypeExpression", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidTypeForCollection", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidTypeForCollectionTarget14", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidTypeForStaticImport", new ProblemAttributes(this, 30));
            expectedProblemAttributes.put("InvalidTypeToSynchronized", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("InvalidTypeVariableExceptionType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InvalidUnaryExpression", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUnicodeEscape", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUnionTypeReferenceSequence", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("InvalidUsageOfAnnotationDeclarations", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfAnnotations", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfEnumDeclarations", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfForeachStatements", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfStaticImports", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfTypeAnnotations", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfTypeArguments", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfTypeParameters", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfTypeParametersForAnnotationDeclaration", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfTypeParametersForEnumDeclaration", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfVarargs", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidUsageOfWildcard", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("InvalidVoidExpression", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("IsClassPathCorrect", new ProblemAttributes(this, 10));
            expectedProblemAttributes.put("JavadocAmbiguousConstructor", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocAmbiguousField", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocAmbiguousMethod", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocAmbiguousMethodReference", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocAmbiguousType", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocDuplicateParamName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocDuplicateReturnTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocDuplicateTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocDuplicateThrowsClassName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocEmptyReturnTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocGenericConstructorTypeArgumentMismatch", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocGenericMethodTypeArgumentMismatch", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocHiddenReference", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocIncorrectArityForParameterizedConstructor", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocIncorrectArityForParameterizedMethod", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInheritedFieldHidesEnclosingName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInheritedMethodHidesEnclosingName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInheritedNameHidesEnclosingTypeName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInternalTypeNameProvided", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidMemberTypeQualification", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidParamName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidParamTagName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidParamTagTypeParameter", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidSeeArgs", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidSeeHref", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidSeeReference", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidSeeUrlReference", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidThrowsClass", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidThrowsClassName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocInvalidValueReference", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMalformedSeeReference", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMessagePrefix", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("JavadocMissing", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingHashCharacter", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingIdentifier", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingParamName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingParamTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingReturnTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingSeeReference", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingTagDescription", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingThrowsClassName", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocMissingThrowsTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNoMessageSendOnArrayType", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNoMessageSendOnBaseType", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNonGenericConstructor", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNonGenericMethod", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNonStaticTypeFromStaticInvocation", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNotVisibleConstructor", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNotVisibleField", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNotVisibleMethod", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocNotVisibleType", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocParameterMismatch", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocParameterizedConstructorArgumentTypeMismatch", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocParameterizedMethodArgumentTypeMismatch", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocTypeArgumentsForRawGenericConstructor", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocTypeArgumentsForRawGenericMethod", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUndefinedConstructor", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUndefinedField", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUndefinedMethod", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUndefinedType", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUnexpectedTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUnexpectedText", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUnterminatedInlineTag", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUsingDeprecatedConstructor", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUsingDeprecatedField", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUsingDeprecatedMethod", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("JavadocUsingDeprecatedType", new ProblemAttributes(this, 70));
            expectedProblemAttributes.put("LambdaDescriptorMentionsUnmentionable", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("LambdaExpressionNotBelow18", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("LambdaRedeclaresArgument", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("LambdaRedeclaresLocal", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("LambdaShapeComputationError", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("LocalVariableCanOnlyBeNull", DEPRECATED);
            expectedProblemAttributes.put("LocalVariableCannotBeNull", DEPRECATED);
            expectedProblemAttributes.put("LocalVariableHidingField", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("LocalVariableHidingLocalVariable", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("LocalVariableIsNeverUsed", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("LocalVariableMayBeNull", DEPRECATED);
            expectedProblemAttributes.put("MaskedCatch", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MethodButWithConstructorName", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("MethodCanBePotentiallyStatic", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("MethodCanBeStatic", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("MethodMissingDeprecatedAnnotation", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("MethodMustOverride", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MethodMustOverrideOrImplement", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MethodNameClash", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MethodNameClashHidden", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MethodReducesVisibility", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MethodReferenceNotBelow18", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("MethodReferenceSwingsBothWays", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MethodRequiresBody", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MethodReturnsVoid", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MethodVarargsArgumentNeedCast", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MisplacedTypeAnnotations", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("MissingArgumentsForParameterizedMemberType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("MissingDefaultCase", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MissingEnclosingInstance", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("MissingEnclosingInstanceForConstructorCall", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("MissingEnumConstantCase", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MissingEnumConstantCaseDespiteDefault", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MissingEnumDefaultCase", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MissingNonNullByDefaultAnnotationOnPackage", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MissingNonNullByDefaultAnnotationOnType", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MissingOverrideAnnotation", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("MissingOverrideAnnotationForInterfaceMethodImplementation", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("MissingReturnType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("MissingSemiColon", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("MissingSerialVersion", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MissingSynchronizedModifierInInheritedMethod", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("MissingTypeInConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MissingTypeInLambda", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MissingTypeInMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("MissingValueForAnnotationMember", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("MultiCatchNotBelow17", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("MultipleFunctionalInterfaces", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("StaticInterfaceMethodNotBelow18", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("MustDefineEitherDimensionExpressionsOrInitializer", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("MustSpecifyPackage", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("NativeMethodsCannotBeStrictfp", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NeedToEmulateConstructorAccess", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("NeedToEmulateFieldReadAccess", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("NeedToEmulateFieldWriteAccess", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("NeedToEmulateMethodAccess", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("NoAdditionalBoundAfterTypeVariable", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("NoFieldOnBaseType", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NoGenericLambda", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("NoImplicitStringConversionForCharArrayExpression", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NoMessageSendOnArrayType", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NoMessageSendOnBaseType", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NoSuperInInterfaceContext", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("NonBlankFinalLocalAssignment", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("NonConstantExpression", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("NonExternalizedStringLiteral", new ProblemAttributes(this, 140));
            expectedProblemAttributes.put("NonGenericConstructor", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("NonGenericMethod", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("NonGenericType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("NonNullDefaultDetailIsNotEvaluated", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("NonNullExpressionComparisonYieldsFalse", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NonNullMessageSendComparisonYieldsFalse", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NonNullSpecdFieldComparisonYieldsFalse", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NonNullLocalVariableComparisonYieldsFalse", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NonStaticAccessToStaticField", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("NonStaticAccessToStaticMethod", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("NonStaticContextForEnumMemberType", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("NonStaticFieldFromStaticInvocation", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NonStaticOrAlienTypeReceiver", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NonStaticTypeFromStaticInvocation", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("NotVisibleConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NotVisibleConstructorInDefaultConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NotVisibleConstructorInImplicitConstructorCall", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NotVisibleField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NotVisibleMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("NotVisibleType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("NullableFieldReference", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullAnnotationUnsupportedLocation", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("NullAnnotationUnsupportedLocationAtType", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("NullExpressionReference", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullLocalVariableComparisonYieldsFalse", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullLocalVariableInstanceofYieldsFalse", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullLocalVariableReference", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullityMismatchAgainstFreeTypeVariable", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullityMismatchingTypeAnnotation", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullityMismatchingTypeAnnotationSuperHint", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullityMismatchTypeArgument", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotationDetail", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotationDetailSuperHint", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullNotCompatibleToFreeTypeVariable", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NullSourceString", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("NullUnboxing", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("NumericValueOutOfRange", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ObjectCannotBeGeneric", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ObjectCannotHaveSuperTypes", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ObjectHasNoSuperclass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ObjectMustBeClass", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("OuterLocalMustBeEffectivelyFinal", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("OuterLocalMustBeFinal", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("OverridingDeprecatedMethod", new ProblemAttributes(this, 110));
            expectedProblemAttributes.put("OverridingMethodWithoutSuperInvocation", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("OverridingNonVisibleMethod", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("PackageCollidesWithType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("PackageIsNotExpectedPackage", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ParameterAssignment", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("ParameterLackingNonNullAnnotation", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ParameterLackingNullableAnnotation", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ParameterMismatch", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("ParameterizedConstructorArgumentTypeMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ParameterizedMethodArgumentTypeMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ParsingError", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorDeleteToken", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorDeleteTokens", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorInsertToComplete", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorInsertToCompletePhrase", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorInsertToCompleteScope", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorInsertTokenAfter", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorInsertTokenBefore", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorInvalidToken", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorMergeTokens", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorMisplacedConstruct", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorNoSuggestion", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorNoSuggestionForTokens", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorOnKeyword", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorOnKeywordNoSuggestion", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorReplaceTokens", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("ParsingErrorUnexpectedEOF", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("PolymorphicMethodNotBelow17", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("PossibleAccidentalBooleanAssignment", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("PotentialHeapPollutionFromVararg", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("PotentiallyUnclosedCloseable", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("PotentiallyUnclosedCloseableAtExit", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("PotentialNullLocalVariableReference", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("PotentialNullExpressionReference", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("PotentialNullMessageSendReference", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("PotentialNullUnboxing", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("PublicClassMustMatchFileName", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("RawMemberTypeCannotBeParameterized", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("RawTypeReference", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("RecursiveConstructorInvocation", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("RedefinedArgument", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("RedefinedLocal", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("RedundantSpecificationOfTypeArguments", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("RedundantLocalVariableNullAssignment", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullAnnotation", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("RedundantNullCheckAgainstNonNullType", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullCheckOnField", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullExpression", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullSpecdField", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullLocalVariable", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullMessageSend", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullCheckOnNullLocalVariable", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullCheckOnSpecdNonNullLocalVariable", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotation", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationPackage", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationType", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationMethod", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("RedundantSuperinterface", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("ReferenceExpressionParameterNullityMismatch", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ReferenceExpressionParameterNullityUnchecked", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ReferenceExpressionReturnNullRedef", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ReferenceExpressionReturnNullRedefUnchecked", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ReferenceToForwardField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("RequiredNonNullButProvidedNull", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RequiredNonNullButProvidedPotentialNull", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RequiredNonNullButProvidedSpecdNullable", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("RequiredNonNullButProvidedUnknown", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ReferenceToForwardTypeVariable", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("RepeatableAnnotationTypeIsDocumented", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("RepeatableAnnotationTypeIsInherited", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("RepeatableAnnotationTypeTargetMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("RepeatableAnnotationWithRepeatingContainerAnnotation", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("RepeatedAnnotationWithContainerAnnotation", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ResourceHasToImplementAutoCloseable", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ReturnTypeAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeCannotBeVoidArray", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("ReturnTypeNotFound", DEPRECATED);
            expectedProblemAttributes.put("ReturnTypeNotVisible", DEPRECATED);
            expectedProblemAttributes.put("SafeVarargsOnFixedArityMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("SafeVarargsOnNonFinalInstanceMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("ShouldImplementHashcode", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("ShouldReturnValue", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("ShouldReturnValueHintMissingDefault", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("SpecdNonNullLocalVariableComparisonYieldsFalse", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("StaticInheritedMethodConflicts", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("StaticMemberOfParameterizedType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("StaticMethodRequested", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("StaticMethodShouldBeAccessedStatically", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("StringConstantIsExceedingUtf8Limit", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("SuperAccessCannotBypassDirectSuper", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("SuperCallCannotBypassOverride", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("SuperInterfaceMustBeAnInterface", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("SuperInterfacesCollide", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("SuperTypeUsingWildcard", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("SuperclassAmbiguous", DEPRECATED);
            expectedProblemAttributes.put("SuperclassInheritedNameHidesEnclosingName", DEPRECATED);
            expectedProblemAttributes.put("SuperclassInternalNameProvided", DEPRECATED);
            expectedProblemAttributes.put("SuperclassMustBeAClass", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("SuperclassNotFound", DEPRECATED);
            expectedProblemAttributes.put("SuperclassNotVisible", DEPRECATED);
            expectedProblemAttributes.put("SuperfluousSemicolon", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("SwitchOnEnumNotBelow15", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("SwitchOnStringsNotBelow17", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("TargetTypeNotAFunctionalInterface", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("Task", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ThisInStaticContext", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("ThisSuperDuringConstructorInvocation", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("ToleratedMisplacedTypeAnnotations", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("TooManyArgumentSlots", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TooManyArrayDimensions", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TooManyBytesForStringConstant", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TooManyConstantsInConstantPool", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TooManyFields", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TooManyLocalVariableSlots", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TooManyMethods", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TooManyParametersForSyntheticMethod", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TooManySyntheticArgumentSlots", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("TypeArgumentMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("TypeArgumentsForRawGenericConstructor", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("TypeArgumentsForRawGenericMethod", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("TypeCollidesWithPackage", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("TypeHidingType", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("TypeHidingTypeParameterFromMethod", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("TypeHidingTypeParameterFromType", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("TypeMismatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("TypeMissingDeprecatedAnnotation", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("TypeParameterHidingType", new ProblemAttributes(this, 100));
            expectedProblemAttributes.put("UnboxingConversion", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("UnclosedCloseable", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("UnclosedCloseableAtExit", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("UndefinedAnnotationMember", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UndefinedConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UndefinedConstructorInDefaultConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UndefinedConstructorInImplicitConstructorCall", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UndefinedField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UndefinedLabel", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("UndefinedMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UndefinedName", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UndefinedType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("UndefinedTypeVariable", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("UnderscoresInLiteralsNotBelow17", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("UndocumentedEmptyBlock", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("UnexpectedStaticModifierForField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UnexpectedStaticModifierForMethod", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UnhandledException", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("UnhandledExceptionInDefaultConstructor", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("UnhandledExceptionInImplicitConstructorCall", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("UnhandledExceptionOnAutoClose", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("UnhandledWarningToken", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UninitializedBlankFinalField", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UninitializedBlankFinalFieldHintMissingDefault", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UninitializedLocalVariable", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("UninitializedLocalVariableHintMissingDefault", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("UninitializedNonNullField", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("UninitializedNonNullFieldHintMissingDefault", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("UninternedIdentityComparison", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("UnmatchedBracket", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("UnnecessaryArgumentCast", DEPRECATED);
            expectedProblemAttributes.put("UnnecessaryCast", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnnecessaryElse", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnnecessaryInstanceof", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnnecessaryNLSTag", new ProblemAttributes(this, 140));
            expectedProblemAttributes.put("UnqualifiedFieldAccess", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("UnreachableCatch", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("UnresolvedVariable", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UnsafeElementTypeConversion", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeGenericArrayForVarargs", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeGenericCast", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeNullnessCast", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("UnsafeRawConstructorInvocation", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeRawFieldAssignment", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeRawGenericConstructorInvocation", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeRawGenericMethodInvocation", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeRawMethodInvocation", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeReturnTypeOverride", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnsafeTypeConversion", new ProblemAttributes(this, 130));
            expectedProblemAttributes.put("UnterminatedComment", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("UnterminatedString", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("UnusedConstructorDeclaredThrownException", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedImport", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedLabel", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedMethodDeclaredThrownException", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedObjectAllocation", new ProblemAttributes(this, 90));
            expectedProblemAttributes.put("UnusedPrivateConstructor", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedPrivateField", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedPrivateMethod", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedPrivateType", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedTypeArgumentsForConstructorInvocation", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UnusedTypeParameter", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UnusedTypeArgumentsForMethodInvocation", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("UnusedWarningToken", new ProblemAttributes(this, 120));
            expectedProblemAttributes.put("UseAssertAsAnIdentifier", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("UseEnumAsAnIdentifier", new ProblemAttributes(this, 80));
            expectedProblemAttributes.put("IllegalUseOfUnderscoreAsAnIdentifier", new ProblemAttributes(this, 20));
            expectedProblemAttributes.put("UsingDeprecatedConstructor", new ProblemAttributes(this, 110));
            expectedProblemAttributes.put("UsingDeprecatedField", new ProblemAttributes(this, 110));
            expectedProblemAttributes.put("UsingDeprecatedMethod", new ProblemAttributes(this, 110));
            expectedProblemAttributes.put("UsingDeprecatedType", new ProblemAttributes(this, 110));
            expectedProblemAttributes.put("VarargsElementTypeNotVisible", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("VarargsElementTypeNotVisibleForConstructor", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("VarargsConflict", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("VariableTypeCannotBeVoid", new ProblemAttributes(this, 60));
            expectedProblemAttributes.put("VariableTypeCannotBeVoidArray", DEPRECATED);
            expectedProblemAttributes.put("VoidMethodReturnsValue", new ProblemAttributes(this, 50));
            expectedProblemAttributes.put("WildcardConstructorInvocation", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("WildcardFieldAssignment", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("WildcardMethodInvocation", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("illFormedParameterizationOfFunctionalInterface", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("lambdaParameterTypeMismatched", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("lambdaSignatureMismatched", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalArrayOfUnionType", new ProblemAttributes(this, 40));
            expectedProblemAttributes.put("IllegalArrayTypeInIntersectionCast", new ProblemAttributes(this, 40));
            StringBuffer failures = new StringBuffer();
            StringBuffer correctResult = new StringBuffer(70000);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.compiler.IProblem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> iProblemClass = clazz;
            Field[] fields = clazz.getFields();
            Arrays.sort(fields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Field field1 = (Field)o1;
                    Field field2 = (Field)o2;
                    return field1.getName().compareTo(field2.getName());
                }
            });
            boolean watchInternalCategory = false;
            boolean printHeader = true;
            int i = 0;
            int length = fields.length;
            while (i < length) {
                int problemId;
                int maskedProblemId;
                Field field = fields[i];
                if (field.getType() == Integer.TYPE && (maskedProblemId = (problemId = field.getInt(iProblemClass)) & 0xFFFFFF) != 0 && maskedProblemId != 0xFFFFFF) {
                    int actualCategory;
                    String name = field.getName();
                    ProblemAttributes expectedAttributes = (ProblemAttributes)expectedProblemAttributes.get(name);
                    if (expectedAttributes == null) {
                        failures.append("missing expected problem attributes for problem " + name + "\n");
                        actualCategory = ProblemReporter.getProblemCategory((int)1, (int)problemId);
                        correctResult.append("\t\texpectedProblemAttributes.put(\"" + name + "\", new ProblemAttributes(CategorizedProblem." + this.categoryName(actualCategory) + "));\n");
                    } else if (!expectedAttributes.deprecated) {
                        actualCategory = ProblemReporter.getProblemCategory((int)1, (int)problemId);
                        correctResult.append("\t\texpectedProblemAttributes.put(\"" + name + "\", new ProblemAttributes(CategorizedProblem." + this.categoryName(actualCategory) + "));\n");
                        if (expectedAttributes.category != actualCategory) {
                            failures.append("category mismatch for problem " + name + " (expected " + this.categoryName(expectedAttributes.category) + ", got " + this.categoryName(actualCategory) + ")\n");
                        }
                        if (watchInternalCategory && actualCategory == 60) {
                            if (printHeader) {
                                printHeader = false;
                                System.err.println("CAT_INTERNAL for problems:");
                            }
                            System.err.println("\t" + name);
                        }
                    } else {
                        correctResult.append("\t\texpectedProblemAttributes.put(\"" + name + "\", DEPRECATED);\n");
                    }
                }
                ++i;
            }
            if (failures.length() > 0) {
                System.out.println(correctResult);
                System.out.println();
            }
            CompilerInvocationTests.assertEquals((String)failures.toString(), (int)0, (int)failures.length());
        }
        catch (IllegalAccessException illegalAccessException) {
            CompilerInvocationTests.fail((String)"could not access members");
        }
    }

    private String categoryName(int category) {
        if (categoryNames == null) {
            categoryNames = new HashMap();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jdt.core.compiler.CategorizedProblem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field[] fields = clazz.getFields();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                String name;
                Field field = fields[i];
                if (field.getType() == Integer.TYPE && (name = field.getName()).startsWith("CAT_")) {
                    try {
                        Class<?> clazz2 = class$2;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.jdt.core.compiler.CategorizedProblem");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        categoryNames.put(new Integer(field.getInt(clazz2)), name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                ++i;
            }
        }
        return (String)categoryNames.get(new Integer(category));
    }

    public void test012_compiler_problems_tuning() {
        try {
            class ProblemAttributes {
                boolean skip;
                String option;
                final /* synthetic */ CompilerInvocationTests this$0;

                ProblemAttributes(CompilerInvocationTests compilerInvocationTests, String option) {
                    this.this$0 = compilerInvocationTests;
                    this.option = option;
                }

                ProblemAttributes(CompilerInvocationTests compilerInvocationTests, boolean skip) {
                    this.this$0 = compilerInvocationTests;
                    this.skip = skip;
                }
            }
            ProblemAttributes SKIP = new ProblemAttributes(this, true);
            HashMap<String, ProblemAttributes> expectedProblemAttributes = new HashMap<String, ProblemAttributes>();
            expectedProblemAttributes.put("AbstractMethodCannotBeOverridden", SKIP);
            expectedProblemAttributes.put("AbstractMethodInAbstractClass", SKIP);
            expectedProblemAttributes.put("AbstractMethodInEnum", SKIP);
            expectedProblemAttributes.put("AbstractMethodMustBeImplemented", SKIP);
            expectedProblemAttributes.put("AbstractMethodMustBeImplementedOverConcreteMethod", SKIP);
            expectedProblemAttributes.put("AbstractMethodsInConcreteClass", SKIP);
            expectedProblemAttributes.put("AmbiguousConstructor", SKIP);
            expectedProblemAttributes.put("AmbiguousConstructorInDefaultConstructor", SKIP);
            expectedProblemAttributes.put("AmbiguousConstructorInImplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("AmbiguousField", SKIP);
            expectedProblemAttributes.put("AmbiguousMethod", SKIP);
            expectedProblemAttributes.put("AmbiguousType", SKIP);
            expectedProblemAttributes.put("AnnotationCannotOverrideMethod", SKIP);
            expectedProblemAttributes.put("AnnotationCircularity", SKIP);
            expectedProblemAttributes.put("AnnotationCircularitySelfReference", SKIP);
            expectedProblemAttributes.put("AnnotationFieldNeedConstantInitialization", SKIP);
            expectedProblemAttributes.put("AnnotationMembersCannotHaveParameters", SKIP);
            expectedProblemAttributes.put("AnnotationMembersCannotHaveTypeParameters", SKIP);
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveConstructor", SKIP);
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveSuperclass", SKIP);
            expectedProblemAttributes.put("AnnotationTypeDeclarationCannotHaveSuperinterfaces", SKIP);
            expectedProblemAttributes.put("AnnotationTypeUsedAsSuperInterface", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.annotationSuperInterface"));
            expectedProblemAttributes.put("AnnotationValueMustBeAnEnumConstant", SKIP);
            expectedProblemAttributes.put("AnnotationValueMustBeAnnotation", SKIP);
            expectedProblemAttributes.put("AnnotationValueMustBeArrayInitializer", SKIP);
            expectedProblemAttributes.put("AnnotationValueMustBeClassLiteral", SKIP);
            expectedProblemAttributes.put("AnnotationValueMustBeConstant", SKIP);
            expectedProblemAttributes.put("AnonymousClassCannotExtendFinalClass", SKIP);
            expectedProblemAttributes.put("ApplicableMethodOverriddenByInapplicable", SKIP);
            expectedProblemAttributes.put("ArgumentHidingField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.localVariableHiding"));
            expectedProblemAttributes.put("ArgumentHidingLocalVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.localVariableHiding"));
            expectedProblemAttributes.put("ArgumentIsNeverUsed", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedParameter"));
            expectedProblemAttributes.put("ArgumentTypeAmbiguous", SKIP);
            expectedProblemAttributes.put("ArgumentTypeCannotBeVoid", SKIP);
            expectedProblemAttributes.put("ArgumentTypeCannotBeVoidArray", SKIP);
            expectedProblemAttributes.put("ArgumentTypeInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("ArgumentTypeInternalNameProvided", SKIP);
            expectedProblemAttributes.put("ArgumentTypeNotFound", SKIP);
            expectedProblemAttributes.put("ArgumentTypeNotVisible", SKIP);
            expectedProblemAttributes.put("ArrayConstantsOnlyInArrayInitializers", SKIP);
            expectedProblemAttributes.put("ArrayReferencePotentialNullReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("ArrayReferenceRequired", SKIP);
            expectedProblemAttributes.put("AssignmentHasNoEffect", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.noEffectAssignment"));
            expectedProblemAttributes.put("AssignmentToMultiCatchParameter", SKIP);
            expectedProblemAttributes.put("AssignmentToResource", SKIP);
            expectedProblemAttributes.put("AutoManagedResourceNotBelow17", SKIP);
            expectedProblemAttributes.put("BinaryLiteralNotBelow17", SKIP);
            expectedProblemAttributes.put("BodyForAbstractMethod", SKIP);
            expectedProblemAttributes.put("BodyForNativeMethod", SKIP);
            expectedProblemAttributes.put("BoundCannotBeArray", SKIP);
            expectedProblemAttributes.put("BoundHasConflictingArguments", SKIP);
            expectedProblemAttributes.put("BoundMustBeAnInterface", SKIP);
            expectedProblemAttributes.put("BoxingConversion", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.autoboxing"));
            expectedProblemAttributes.put("BytecodeExceeds64KLimit", SKIP);
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForClinit", SKIP);
            expectedProblemAttributes.put("BytecodeExceeds64KLimitForConstructor", SKIP);
            expectedProblemAttributes.put("CannotAllocateVoidArray", SKIP);
            expectedProblemAttributes.put("CannotDeclareEnumSpecialMethod", SKIP);
            expectedProblemAttributes.put("CannotDefineAnnotationInLocalType", SKIP);
            expectedProblemAttributes.put("CannotDefineDimensionExpressionsWithInit", SKIP);
            expectedProblemAttributes.put("CannotDefineEnumInLocalType", SKIP);
            expectedProblemAttributes.put("CannotDefineInterfaceInLocalType", SKIP);
            expectedProblemAttributes.put("CannotDefineStaticInitializerInLocalType", SKIP);
            expectedProblemAttributes.put("CannotExtendEnum", SKIP);
            expectedProblemAttributes.put("CannotHideAnInstanceMethodWithAStaticMethod", SKIP);
            expectedProblemAttributes.put("CannotImportPackage", SKIP);
            expectedProblemAttributes.put("CannotImplementIncompatibleNullness", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("CannotInferElidedTypes", SKIP);
            expectedProblemAttributes.put("CannotInvokeSuperConstructorInEnum", SKIP);
            expectedProblemAttributes.put("CannotOverrideAStaticMethodWithAnInstanceMethod", SKIP);
            expectedProblemAttributes.put("CannotReadSource", SKIP);
            expectedProblemAttributes.put("CannotReturnInInitializer", SKIP);
            expectedProblemAttributes.put("CannotThrowNull", SKIP);
            expectedProblemAttributes.put("CannotThrowType", SKIP);
            expectedProblemAttributes.put("CannotUseDiamondWithAnonymousClasses", SKIP);
            expectedProblemAttributes.put("CannotUseDiamondWithExplicitTypeArguments", SKIP);
            expectedProblemAttributes.put("CannotUseSuperInCodeSnippet", SKIP);
            expectedProblemAttributes.put("ClassExtendFinalClass", SKIP);
            expectedProblemAttributes.put("CodeCannotBeReached", SKIP);
            expectedProblemAttributes.put("CodeSnippetMissingClass", SKIP);
            expectedProblemAttributes.put("CodeSnippetMissingMethod", SKIP);
            expectedProblemAttributes.put("ComparingIdentical", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.comparingIdentical"));
            expectedProblemAttributes.put("ConflictingImport", SKIP);
            expectedProblemAttributes.put("ConflictingNullAnnotations", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ConstructedArrayIncompatible", SKIP);
            expectedProblemAttributes.put("ConstructionTypeMismatch", SKIP);
            expectedProblemAttributes.put("ConflictingInheritedNullAnnotations", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ConstructorReferenceNotBelow18", SKIP);
            expectedProblemAttributes.put("ContainerAnnotationTypeHasNonDefaultMembers", SKIP);
            expectedProblemAttributes.put("ContainerAnnotationTypeHasShorterRetention", SKIP);
            expectedProblemAttributes.put("ContainerAnnotationTypeHasWrongValueType", SKIP);
            expectedProblemAttributes.put("ContainerAnnotationTypeMustHaveValue", SKIP);
            expectedProblemAttributes.put("ContradictoryNullAnnotations", SKIP);
            expectedProblemAttributes.put("ContradictoryNullAnnotationsOnBound", SKIP);
            expectedProblemAttributes.put("ContradictoryNullAnnotationsInferred", SKIP);
            expectedProblemAttributes.put("ConstructorVarargsArgumentNeedCast", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast"));
            expectedProblemAttributes.put("CorruptedSignature", SKIP);
            expectedProblemAttributes.put("DanglingReference", SKIP);
            expectedProblemAttributes.put("DeadCode", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.deadCode"));
            expectedProblemAttributes.put("DefaultMethodNotBelow18", SKIP);
            expectedProblemAttributes.put("DefaultMethodOverridesObjectMethod", SKIP);
            expectedProblemAttributes.put("DereferencingNullableExpression", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("DiamondNotBelow17", SKIP);
            expectedProblemAttributes.put("DirectInvocationOfAbstractMethod", SKIP);
            expectedProblemAttributes.put("DisallowedTargetForAnnotation", SKIP);
            expectedProblemAttributes.put("DisallowedTargetForContainerAnnotationType", SKIP);
            expectedProblemAttributes.put("DiscouragedReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.discouragedReference"));
            expectedProblemAttributes.put("DuplicateAnnotation", SKIP);
            expectedProblemAttributes.put("DuplicateAnnotationNotMarkedRepeatable", SKIP);
            expectedProblemAttributes.put("DuplicateAnnotationMember", SKIP);
            expectedProblemAttributes.put("DuplicateBlankFinalFieldInitialization", SKIP);
            expectedProblemAttributes.put("DuplicateBounds", SKIP);
            expectedProblemAttributes.put("DuplicateBoundInIntersectionCast", SKIP);
            expectedProblemAttributes.put("DuplicateCase", SKIP);
            expectedProblemAttributes.put("DuplicateDefaultCase", SKIP);
            expectedProblemAttributes.put("DuplicateField", SKIP);
            expectedProblemAttributes.put("DuplicateFinalLocalInitialization", SKIP);
            expectedProblemAttributes.put("DuplicateImport", SKIP);
            expectedProblemAttributes.put("DuplicateInheritedMethods", SKIP);
            expectedProblemAttributes.put("DuplicateInheritedDefaultMethods", SKIP);
            expectedProblemAttributes.put("DuplicateLabel", SKIP);
            expectedProblemAttributes.put("DuplicateMethod", SKIP);
            expectedProblemAttributes.put("DuplicateMethodErasure", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForArgument", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForField", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForMethod", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForType", SKIP);
            expectedProblemAttributes.put("DuplicateModifierForVariable", SKIP);
            expectedProblemAttributes.put("DuplicateNestedType", SKIP);
            expectedProblemAttributes.put("DuplicateParameterizedMethods", SKIP);
            expectedProblemAttributes.put("DuplicateSuperInterface", SKIP);
            expectedProblemAttributes.put("DuplicateTargetInTargetAnnotation", SKIP);
            expectedProblemAttributes.put("DuplicateTypeVariable", SKIP);
            expectedProblemAttributes.put("DuplicateTypes", SKIP);
            expectedProblemAttributes.put("EmptyControlFlowStatement", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.emptyStatement"));
            expectedProblemAttributes.put("EnclosingInstanceInConstructorCall", SKIP);
            expectedProblemAttributes.put("EndOfSource", SKIP);
            expectedProblemAttributes.put("EnumAbstractMethodMustBeImplemented", SKIP);
            expectedProblemAttributes.put("EnumConstantCannotDefineAbstractMethod", SKIP);
            expectedProblemAttributes.put("EnumConstantMustImplementAbstractMethod", SKIP);
            expectedProblemAttributes.put("EnumConstantsCannotBeSurroundedByParenthesis", SKIP);
            expectedProblemAttributes.put("EnumStaticFieldInInInitializerContext", SKIP);
            expectedProblemAttributes.put("EnumSwitchCannotTargetField", SKIP);
            expectedProblemAttributes.put("ExceptionTypeAmbiguous", SKIP);
            expectedProblemAttributes.put("ExceptionTypeInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("ExceptionTypeInternalNameProvided", SKIP);
            expectedProblemAttributes.put("ExceptionTypeNotFound", SKIP);
            expectedProblemAttributes.put("ExceptionTypeNotVisible", SKIP);
            expectedProblemAttributes.put("ExplicitThisParameterNotInLambda", SKIP);
            expectedProblemAttributes.put("ExplicitThisParameterNotBelow18", SKIP);
            expectedProblemAttributes.put("ExplicitlyClosedAutoCloseable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable"));
            expectedProblemAttributes.put("ExpressionShouldBeAVariable", SKIP);
            expectedProblemAttributes.put("ExternalProblemFixable", SKIP);
            expectedProblemAttributes.put("ExternalProblemNotFixable", SKIP);
            expectedProblemAttributes.put("ExplicitAnnotationTargetRequired", SKIP);
            expectedProblemAttributes.put("FallthroughCase", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.fallthroughCase"));
            expectedProblemAttributes.put("FieldComparisonYieldsFalse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("FieldHidingField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.fieldHiding"));
            expectedProblemAttributes.put("FieldHidingLocalVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.fieldHiding"));
            expectedProblemAttributes.put("FieldMissingDeprecatedAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation"));
            expectedProblemAttributes.put("FieldTypeAmbiguous", SKIP);
            expectedProblemAttributes.put("FieldTypeInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("FieldTypeInternalNameProvided", SKIP);
            expectedProblemAttributes.put("FieldTypeNotFound", SKIP);
            expectedProblemAttributes.put("FieldTypeNotVisible", SKIP);
            expectedProblemAttributes.put("FinalBoundForTypeVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.finalParameterBound"));
            expectedProblemAttributes.put("FinalFieldAssignment", SKIP);
            expectedProblemAttributes.put("FinalMethodCannotBeOverridden", SKIP);
            expectedProblemAttributes.put("FinalOuterLocalAssignment", SKIP);
            expectedProblemAttributes.put("FinallyMustCompleteNormally", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally"));
            expectedProblemAttributes.put("ForbiddenReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.forbiddenReference"));
            expectedProblemAttributes.put("GenericConstructorTypeArgumentMismatch", SKIP);
            expectedProblemAttributes.put("GenericInferenceError", SKIP);
            expectedProblemAttributes.put("GenericMethodTypeArgumentMismatch", SKIP);
            expectedProblemAttributes.put("GenericTypeCannotExtendThrowable", SKIP);
            expectedProblemAttributes.put("HidingEnclosingType", SKIP);
            expectedProblemAttributes.put("HierarchyCircularity", SKIP);
            expectedProblemAttributes.put("HierarchyCircularitySelfReference", SKIP);
            expectedProblemAttributes.put("HierarchyHasProblems", SKIP);
            expectedProblemAttributes.put("IllegalAbstractModifierCombinationForMethod", SKIP);
            expectedProblemAttributes.put("IllegalStrictfpForAbstractInterfaceMethod", SKIP);
            expectedProblemAttributes.put("IllegalAccessFromTypeVariable", SKIP);
            expectedProblemAttributes.put("IllegalAnnotationForBaseType", SKIP);
            expectedProblemAttributes.put("IllegalCast", SKIP);
            expectedProblemAttributes.put("IllegalClassLiteralForTypeVariable", SKIP);
            expectedProblemAttributes.put("IllegalDeclarationOfThisParameter", SKIP);
            expectedProblemAttributes.put("IllegalDefaultModifierSpecification", SKIP);
            expectedProblemAttributes.put("IllegalDefinitionToNonNullParameter", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("IllegalDimension", SKIP);
            expectedProblemAttributes.put("IllegalEnclosingInstanceSpecification", SKIP);
            expectedProblemAttributes.put("IllegalExtendedDimensions", SKIP);
            expectedProblemAttributes.put("IllegalExtendedDimensionsForVarArgs", SKIP);
            expectedProblemAttributes.put("IllegalGenericArray", SKIP);
            expectedProblemAttributes.put("IllegalHexaLiteral", SKIP);
            expectedProblemAttributes.put("IllegalInstanceofParameterizedType", SKIP);
            expectedProblemAttributes.put("IllegalInstanceofTypeParameter", SKIP);
            expectedProblemAttributes.put("IllegalBasetypeInIntersectionCast", SKIP);
            expectedProblemAttributes.put("IllegalModifierCombinationFinalAbstractForClass", SKIP);
            expectedProblemAttributes.put("IllegalModifierCombinationFinalVolatileForField", SKIP);
            expectedProblemAttributes.put("IllegalModifierCombinationForInterfaceMethod", SKIP);
            expectedProblemAttributes.put("IllegalModifierForAnnotationField", SKIP);
            expectedProblemAttributes.put("IllegalModifierForAnnotationMemberType", SKIP);
            expectedProblemAttributes.put("IllegalModifierForAnnotationMethod", SKIP);
            expectedProblemAttributes.put("IllegalModifierForAnnotationType", SKIP);
            expectedProblemAttributes.put("IllegalModifierForArgument", SKIP);
            expectedProblemAttributes.put("IllegalModifierForClass", SKIP);
            expectedProblemAttributes.put("IllegalModifierForConstructor", SKIP);
            expectedProblemAttributes.put("IllegalModifierForEnum", SKIP);
            expectedProblemAttributes.put("IllegalModifierForEnumConstant", SKIP);
            expectedProblemAttributes.put("IllegalModifierForEnumConstructor", SKIP);
            expectedProblemAttributes.put("IllegalModifierForField", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterface", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterfaceField", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod", SKIP);
            expectedProblemAttributes.put("IllegalModifierForInterfaceMethod18", SKIP);
            expectedProblemAttributes.put("IllegalModifierForLocalClass", SKIP);
            expectedProblemAttributes.put("IllegalModifierForLocalEnum", SKIP);
            expectedProblemAttributes.put("IllegalModifierForMemberClass", SKIP);
            expectedProblemAttributes.put("IllegalModifierForMemberEnum", SKIP);
            expectedProblemAttributes.put("IllegalModifierForMemberInterface", SKIP);
            expectedProblemAttributes.put("IllegalModifierForMethod", SKIP);
            expectedProblemAttributes.put("IllegalModifierForVariable", SKIP);
            expectedProblemAttributes.put("IllegalModifiersForElidedType", SKIP);
            expectedProblemAttributes.put("IllegalModifiers", SKIP);
            expectedProblemAttributes.put("IllegalPrimitiveOrArrayTypeForEnclosingInstance", SKIP);
            expectedProblemAttributes.put("IllegalQualifiedEnumConstantLabel", SKIP);
            expectedProblemAttributes.put("IllegalQualifiedParameterizedTypeAllocation", SKIP);
            expectedProblemAttributes.put("IllegalQualifierForExplicitThis", SKIP);
            expectedProblemAttributes.put("IllegalQualifierForExplicitThis2", SKIP);
            expectedProblemAttributes.put("IllegalRedefinitionToNonNullParameter", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("IllegalReturnNullityRedefinition", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("IllegalStaticModifierForMemberType", SKIP);
            expectedProblemAttributes.put("IllegalTypeAnnotationsInStaticMemberAccess", SKIP);
            expectedProblemAttributes.put("IllegalTypeArgumentsInRawConstructorReference", SKIP);
            expectedProblemAttributes.put("IllegalTypeForExplicitThis", SKIP);
            expectedProblemAttributes.put("IllegalTypeVariableSuperReference", SKIP);
            expectedProblemAttributes.put("IllegalUnderscorePosition", SKIP);
            expectedProblemAttributes.put("IllegalUsageOfQualifiedTypeReference", SKIP);
            expectedProblemAttributes.put("IllegalUsageOfTypeAnnotations", SKIP);
            expectedProblemAttributes.put("IllegalVararg", SKIP);
            expectedProblemAttributes.put("IllegalVarargInLambda", SKIP);
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForField", SKIP);
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForMemberType", SKIP);
            expectedProblemAttributes.put("IllegalVisibilityModifierCombinationForMethod", SKIP);
            expectedProblemAttributes.put("IllegalVisibilityModifierForInterfaceMemberType", SKIP);
            expectedProblemAttributes.put("ImportAmbiguous", SKIP);
            expectedProblemAttributes.put("ImportInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("ImportInternalNameProvided", SKIP);
            expectedProblemAttributes.put("ImportNotFound", SKIP);
            expectedProblemAttributes.put("ImportNotVisible", SKIP);
            expectedProblemAttributes.put("IncompatibleExceptionInInheritedMethodThrowsClause", SKIP);
            expectedProblemAttributes.put("IncompatibleExceptionInThrowsClause", SKIP);
            expectedProblemAttributes.put("IncompatibleExceptionInThrowsClauseForNonInheritedInterfaceMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod"));
            expectedProblemAttributes.put("IncompatibleReturnType", SKIP);
            expectedProblemAttributes.put("IncompatibleReturnTypeForNonInheritedInterfaceMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod"));
            expectedProblemAttributes.put("IncompatibleTypesInConditionalOperator", SKIP);
            expectedProblemAttributes.put("IncompatibleTypesInEqualityOperator", SKIP);
            expectedProblemAttributes.put("IncompatibleTypesInForeach", SKIP);
            expectedProblemAttributes.put("IncompatibleLambdaParameterType", SKIP);
            expectedProblemAttributes.put("IncompatibleMethodReference", SKIP);
            expectedProblemAttributes.put("IncorrectArityForParameterizedConstructor", SKIP);
            expectedProblemAttributes.put("IncorrectArityForParameterizedMethod", SKIP);
            expectedProblemAttributes.put("IncorrectArityForParameterizedType", SKIP);
            expectedProblemAttributes.put("IncorrectEnclosingInstanceReference", SKIP);
            expectedProblemAttributes.put("IncorrectSwitchType", SKIP);
            expectedProblemAttributes.put("IncorrectSwitchType17", SKIP);
            expectedProblemAttributes.put("IndirectAccessToStaticField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.indirectStaticAccess"));
            expectedProblemAttributes.put("IndirectAccessToStaticMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.indirectStaticAccess"));
            expectedProblemAttributes.put("IndirectAccessToStaticType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.indirectStaticAccess"));
            expectedProblemAttributes.put("InheritedDefaultMethodConflictsWithOtherInherited", SKIP);
            expectedProblemAttributes.put("InheritedFieldHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("InheritedIncompatibleReturnType", SKIP);
            expectedProblemAttributes.put("InheritedMethodHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("InheritedMethodReducesVisibility", SKIP);
            expectedProblemAttributes.put("InheritedTypeHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("InitializerMustCompleteNormally", SKIP);
            expectedProblemAttributes.put("InstanceFieldDuringConstructorInvocation", SKIP);
            expectedProblemAttributes.put("InstanceMethodDuringConstructorInvocation", SKIP);
            expectedProblemAttributes.put("InterfaceAmbiguous", SKIP);
            expectedProblemAttributes.put("InterfaceCannotHaveConstructors", SKIP);
            expectedProblemAttributes.put("InterfaceCannotHaveInitializers", SKIP);
            expectedProblemAttributes.put("InterfaceInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("InterfaceInternalNameProvided", SKIP);
            expectedProblemAttributes.put("InterfaceNotFound", SKIP);
            expectedProblemAttributes.put("InterfaceNotFunctionalInterface", SKIP);
            expectedProblemAttributes.put("InterfaceNotVisible", SKIP);
            expectedProblemAttributes.put("InternalTypeNameProvided", SKIP);
            expectedProblemAttributes.put("IntersectionCastNotBelow18", SKIP);
            expectedProblemAttributes.put("InvalidAnnotationMemberType", SKIP);
            expectedProblemAttributes.put("InvalidArrayConstructorReference", SKIP);
            expectedProblemAttributes.put("InvalidBinary", SKIP);
            expectedProblemAttributes.put("InvalidBreak", SKIP);
            expectedProblemAttributes.put("InvalidCatchBlockSequence", SKIP);
            expectedProblemAttributes.put("InvalidCharacterConstant", SKIP);
            expectedProblemAttributes.put("InvalidClassInstantiation", SKIP);
            expectedProblemAttributes.put("InvalidContinue", SKIP);
            expectedProblemAttributes.put("InvalidDigit", SKIP);
            expectedProblemAttributes.put("InvalidEncoding", SKIP);
            expectedProblemAttributes.put("InvalidEscape", SKIP);
            expectedProblemAttributes.put("InvalidExplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("InvalidExpressionAsStatement", SKIP);
            expectedProblemAttributes.put("InvalidFileNameForPackageAnnotations", SKIP);
            expectedProblemAttributes.put("InvalidFloat", SKIP);
            expectedProblemAttributes.put("InvalidHexa", SKIP);
            expectedProblemAttributes.put("InvalidHighSurrogate", SKIP);
            expectedProblemAttributes.put("InvalidInput", SKIP);
            expectedProblemAttributes.put("InvalidLowSurrogate", SKIP);
            expectedProblemAttributes.put("InvalidLocationForModifiers", SKIP);
            expectedProblemAttributes.put("InvalidNullToSynchronized", SKIP);
            expectedProblemAttributes.put("InvalidOctal", SKIP);
            expectedProblemAttributes.put("InvalidOperator", SKIP);
            expectedProblemAttributes.put("InvalidParameterizedExceptionType", SKIP);
            expectedProblemAttributes.put("InvalidParenthesizedExpression", SKIP);
            expectedProblemAttributes.put("InvalidTypeExpression", SKIP);
            expectedProblemAttributes.put("InvalidTypeForCollection", SKIP);
            expectedProblemAttributes.put("InvalidTypeForCollectionTarget14", SKIP);
            expectedProblemAttributes.put("InvalidTypeForStaticImport", SKIP);
            expectedProblemAttributes.put("InvalidTypeToSynchronized", SKIP);
            expectedProblemAttributes.put("InvalidTypeVariableExceptionType", SKIP);
            expectedProblemAttributes.put("InvalidUnaryExpression", SKIP);
            expectedProblemAttributes.put("InvalidUnicodeEscape", SKIP);
            expectedProblemAttributes.put("InvalidUnionTypeReferenceSequence", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfAnnotationDeclarations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfAnnotations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfEnumDeclarations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfForeachStatements", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfReceiverAnnotations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfStaticImports", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeAnnotations", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeArguments", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeParameters", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeParametersForAnnotationDeclaration", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfTypeParametersForEnumDeclaration", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfVarargs", SKIP);
            expectedProblemAttributes.put("InvalidUsageOfWildcard", SKIP);
            expectedProblemAttributes.put("InvalidVoidExpression", SKIP);
            expectedProblemAttributes.put("IsClassPathCorrect", SKIP);
            expectedProblemAttributes.put("JavadocAmbiguousConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocAmbiguousField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocAmbiguousMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocAmbiguousMethodReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocAmbiguousType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateParamName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateReturnTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocDuplicateThrowsClassName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocEmptyReturnTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocGenericConstructorTypeArgumentMismatch", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocGenericMethodTypeArgumentMismatch", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocHiddenReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocIncorrectArityForParameterizedConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocIncorrectArityForParameterizedMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInheritedFieldHidesEnclosingName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInheritedMethodHidesEnclosingName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInheritedNameHidesEnclosingTypeName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInternalTypeNameProvided", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidMemberTypeQualification", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidParamName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidParamTagName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidParamTagTypeParameter", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSeeArgs", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSeeHref", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSeeReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidSeeUrlReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidThrowsClass", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidThrowsClassName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocInvalidValueReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMalformedSeeReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMessagePrefix", SKIP);
            expectedProblemAttributes.put("JavadocMissing", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingJavadocComments"));
            expectedProblemAttributes.put("JavadocMissingHashCharacter", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingIdentifier", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingParamName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingParamTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingJavadocTags"));
            expectedProblemAttributes.put("JavadocMissingReturnTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingJavadocTags"));
            expectedProblemAttributes.put("JavadocMissingSeeReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingTagDescription", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingThrowsClassName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocMissingThrowsTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingJavadocTags"));
            expectedProblemAttributes.put("JavadocNoMessageSendOnArrayType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNoMessageSendOnBaseType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNonGenericConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNonGenericMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNonStaticTypeFromStaticInvocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotVisibleConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotVisibleField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotVisibleMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocNotVisibleType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocParameterMismatch", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocParameterizedConstructorArgumentTypeMismatch", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocParameterizedMethodArgumentTypeMismatch", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocTypeArgumentsForRawGenericConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocTypeArgumentsForRawGenericMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUndefinedConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUndefinedField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUndefinedMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUndefinedType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUnexpectedTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUnexpectedText", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUnterminatedInlineTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUsingDeprecatedConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUsingDeprecatedField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUsingDeprecatedMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("JavadocUsingDeprecatedType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.invalidJavadoc"));
            expectedProblemAttributes.put("LambdaDescriptorMentionsUnmentionable", SKIP);
            expectedProblemAttributes.put("LambdaExpressionNotBelow18", SKIP);
            expectedProblemAttributes.put("LambdaRedeclaresArgument", SKIP);
            expectedProblemAttributes.put("LambdaRedeclaresLocal", SKIP);
            expectedProblemAttributes.put("LambdaShapeComputationError", SKIP);
            expectedProblemAttributes.put("LocalVariableCanOnlyBeNull", SKIP);
            expectedProblemAttributes.put("LocalVariableCannotBeNull", SKIP);
            expectedProblemAttributes.put("LocalVariableHidingField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.localVariableHiding"));
            expectedProblemAttributes.put("LocalVariableHidingLocalVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.localVariableHiding"));
            expectedProblemAttributes.put("LocalVariableIsNeverUsed", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedLocal"));
            expectedProblemAttributes.put("LocalVariableMayBeNull", SKIP);
            expectedProblemAttributes.put("MaskedCatch", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock"));
            expectedProblemAttributes.put("MethodButWithConstructorName", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName"));
            expectedProblemAttributes.put("MethodCanBePotentiallyStatic", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic"));
            expectedProblemAttributes.put("MethodCanBeStatic", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic"));
            expectedProblemAttributes.put("MethodMissingDeprecatedAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation"));
            expectedProblemAttributes.put("MethodMustOverride", SKIP);
            expectedProblemAttributes.put("MethodMustOverrideOrImplement", SKIP);
            expectedProblemAttributes.put("MethodNameClash", SKIP);
            expectedProblemAttributes.put("MethodNameClashHidden", SKIP);
            expectedProblemAttributes.put("MethodReducesVisibility", SKIP);
            expectedProblemAttributes.put("MethodReferenceNotBelow18", SKIP);
            expectedProblemAttributes.put("MethodReferenceSwingsBothWays", SKIP);
            expectedProblemAttributes.put("MethodRequiresBody", SKIP);
            expectedProblemAttributes.put("MethodReturnsVoid", SKIP);
            expectedProblemAttributes.put("MethodVarargsArgumentNeedCast", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast"));
            expectedProblemAttributes.put("MisplacedTypeAnnotations", SKIP);
            expectedProblemAttributes.put("MissingArgumentsForParameterizedMemberType", SKIP);
            expectedProblemAttributes.put("MissingDefaultCase", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingDefaultCase"));
            expectedProblemAttributes.put("MissingEnclosingInstance", SKIP);
            expectedProblemAttributes.put("MissingEnclosingInstanceForConstructorCall", SKIP);
            expectedProblemAttributes.put("MissingEnumConstantCase", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch"));
            expectedProblemAttributes.put("MissingEnumConstantCaseDespiteDefault", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch"));
            expectedProblemAttributes.put("MissingEnumDefaultCase", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingDefaultCase"));
            expectedProblemAttributes.put("MissingNonNullByDefaultAnnotationOnPackage", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation"));
            expectedProblemAttributes.put("MissingNonNullByDefaultAnnotationOnType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation"));
            expectedProblemAttributes.put("MissingOverrideAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation"));
            expectedProblemAttributes.put("MissingOverrideAnnotationForInterfaceMethodImplementation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation"));
            expectedProblemAttributes.put("MissingReturnType", SKIP);
            expectedProblemAttributes.put("MissingSemiColon", SKIP);
            expectedProblemAttributes.put("MissingSerialVersion", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingSerialVersion"));
            expectedProblemAttributes.put("MissingSynchronizedModifierInInheritedMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod"));
            expectedProblemAttributes.put("MissingTypeInConstructor", SKIP);
            expectedProblemAttributes.put("MissingTypeInLambda", SKIP);
            expectedProblemAttributes.put("MissingTypeInMethod", SKIP);
            expectedProblemAttributes.put("MissingValueForAnnotationMember", SKIP);
            expectedProblemAttributes.put("MultiCatchNotBelow17", SKIP);
            expectedProblemAttributes.put("MultipleFunctionalInterfaces", SKIP);
            expectedProblemAttributes.put("StaticInterfaceMethodNotBelow18", SKIP);
            expectedProblemAttributes.put("MustDefineEitherDimensionExpressionsOrInitializer", SKIP);
            expectedProblemAttributes.put("MustSpecifyPackage", SKIP);
            expectedProblemAttributes.put("NativeMethodsCannotBeStrictfp", SKIP);
            expectedProblemAttributes.put("NeedToEmulateConstructorAccess", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("NeedToEmulateFieldReadAccess", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("NeedToEmulateFieldWriteAccess", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("NeedToEmulateMethodAccess", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation"));
            expectedProblemAttributes.put("NoAdditionalBoundAfterTypeVariable", SKIP);
            expectedProblemAttributes.put("NoFieldOnBaseType", SKIP);
            expectedProblemAttributes.put("NoGenericLambda", SKIP);
            expectedProblemAttributes.put("NoImplicitStringConversionForCharArrayExpression", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion"));
            expectedProblemAttributes.put("NoMessageSendOnArrayType", SKIP);
            expectedProblemAttributes.put("NoMessageSendOnBaseType", SKIP);
            expectedProblemAttributes.put("NoSuperInInterfaceContext", SKIP);
            expectedProblemAttributes.put("NonBlankFinalLocalAssignment", SKIP);
            expectedProblemAttributes.put("NonConstantExpression", SKIP);
            expectedProblemAttributes.put("NonExternalizedStringLiteral", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral"));
            expectedProblemAttributes.put("NonGenericConstructor", SKIP);
            expectedProblemAttributes.put("NonGenericMethod", SKIP);
            expectedProblemAttributes.put("NonGenericType", SKIP);
            expectedProblemAttributes.put("NonNullDefaultDetailIsNotEvaluated", SKIP);
            expectedProblemAttributes.put("NonNullExpressionComparisonYieldsFalse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NonNullSpecdFieldComparisonYieldsFalse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NonNullLocalVariableComparisonYieldsFalse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NonNullMessageSendComparisonYieldsFalse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NonStaticAccessToStaticField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver"));
            expectedProblemAttributes.put("NonStaticAccessToStaticMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver"));
            expectedProblemAttributes.put("NonStaticContextForEnumMemberType", SKIP);
            expectedProblemAttributes.put("NonStaticFieldFromStaticInvocation", SKIP);
            expectedProblemAttributes.put("NonStaticOrAlienTypeReceiver", SKIP);
            expectedProblemAttributes.put("NonStaticTypeFromStaticInvocation", SKIP);
            expectedProblemAttributes.put("NotVisibleConstructor", SKIP);
            expectedProblemAttributes.put("NotVisibleConstructorInDefaultConstructor", SKIP);
            expectedProblemAttributes.put("NotVisibleConstructorInImplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("NotVisibleField", SKIP);
            expectedProblemAttributes.put("NotVisibleMethod", SKIP);
            expectedProblemAttributes.put("NotVisibleType", SKIP);
            expectedProblemAttributes.put("NullableFieldReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullReference"));
            expectedProblemAttributes.put("NullAnnotationUnsupportedLocation", SKIP);
            expectedProblemAttributes.put("NullAnnotationUnsupportedLocationAtType", SKIP);
            expectedProblemAttributes.put("NullityMismatchAgainstFreeTypeVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("NullityMismatchingTypeAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("NullityMismatchingTypeAnnotationSuperHint", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("NullityMismatchTypeArgument", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotationDetail", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("NullityUncheckedTypeAnnotationDetailSuperHint", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("NullExpressionReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullReference"));
            expectedProblemAttributes.put("NullLocalVariableComparisonYieldsFalse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NullLocalVariableInstanceofYieldsFalse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("NullLocalVariableReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullReference"));
            expectedProblemAttributes.put("NullNotCompatibleToFreeTypeVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("NullSourceString", SKIP);
            expectedProblemAttributes.put("NullUnboxing", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullReference"));
            expectedProblemAttributes.put("NumericValueOutOfRange", SKIP);
            expectedProblemAttributes.put("ObjectCannotBeGeneric", SKIP);
            expectedProblemAttributes.put("ObjectCannotHaveSuperTypes", SKIP);
            expectedProblemAttributes.put("ObjectHasNoSuperclass", SKIP);
            expectedProblemAttributes.put("ObjectMustBeClass", SKIP);
            expectedProblemAttributes.put("OuterLocalMustBeEffectivelyFinal", SKIP);
            expectedProblemAttributes.put("OuterLocalMustBeFinal", SKIP);
            expectedProblemAttributes.put("OverridingDeprecatedMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("OverridingMethodWithoutSuperInvocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation"));
            expectedProblemAttributes.put("OverridingNonVisibleMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod"));
            expectedProblemAttributes.put("PackageCollidesWithType", SKIP);
            expectedProblemAttributes.put("PackageIsNotExpectedPackage", SKIP);
            expectedProblemAttributes.put("ParameterAssignment", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.parameterAssignment"));
            expectedProblemAttributes.put("ParameterLackingNonNullAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped"));
            expectedProblemAttributes.put("ParameterLackingNullableAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ParameterMismatch", SKIP);
            expectedProblemAttributes.put("ParameterizedConstructorArgumentTypeMismatch", SKIP);
            expectedProblemAttributes.put("ParameterizedMethodArgumentTypeMismatch", SKIP);
            expectedProblemAttributes.put("ParsingError", SKIP);
            expectedProblemAttributes.put("ParsingErrorDeleteToken", SKIP);
            expectedProblemAttributes.put("ParsingErrorDeleteTokens", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertToComplete", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertToCompletePhrase", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertToCompleteScope", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertTokenAfter", SKIP);
            expectedProblemAttributes.put("ParsingErrorInsertTokenBefore", SKIP);
            expectedProblemAttributes.put("ParsingErrorInvalidToken", SKIP);
            expectedProblemAttributes.put("ParsingErrorMergeTokens", SKIP);
            expectedProblemAttributes.put("ParsingErrorMisplacedConstruct", SKIP);
            expectedProblemAttributes.put("ParsingErrorNoSuggestion", SKIP);
            expectedProblemAttributes.put("ParsingErrorNoSuggestionForTokens", SKIP);
            expectedProblemAttributes.put("ParsingErrorOnKeyword", SKIP);
            expectedProblemAttributes.put("ParsingErrorOnKeywordNoSuggestion", SKIP);
            expectedProblemAttributes.put("ParsingErrorReplaceTokens", SKIP);
            expectedProblemAttributes.put("ParsingErrorUnexpectedEOF", SKIP);
            expectedProblemAttributes.put("PolymorphicMethodNotBelow17", SKIP);
            expectedProblemAttributes.put("PossibleAccidentalBooleanAssignment", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment"));
            expectedProblemAttributes.put("PotentialHeapPollutionFromVararg", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("PotentiallyUnclosedCloseable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable"));
            expectedProblemAttributes.put("PotentiallyUnclosedCloseableAtExit", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable"));
            expectedProblemAttributes.put("PotentialNullExpressionReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("PotentialNullLocalVariableReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("PotentialNullUnboxing", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("PotentialNullMessageSendReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            expectedProblemAttributes.put("PublicClassMustMatchFileName", SKIP);
            expectedProblemAttributes.put("RawMemberTypeCannotBeParameterized", SKIP);
            expectedProblemAttributes.put("RawTypeReference", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.rawTypeReference"));
            expectedProblemAttributes.put("RecursiveConstructorInvocation", SKIP);
            expectedProblemAttributes.put("RedefinedArgument", SKIP);
            expectedProblemAttributes.put("RedefinedLocal", SKIP);
            expectedProblemAttributes.put("RedundantSpecificationOfTypeArguments", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments"));
            expectedProblemAttributes.put("RedundantLocalVariableNullAssignment", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullCheckAgainstNonNullType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullExpression", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullSpecdField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullLocalVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNonNullMessageSend", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnNullLocalVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullCheckOnSpecdNonNullLocalVariable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationPackage", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantNullDefaultAnnotationMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation"));
            expectedProblemAttributes.put("RedundantSuperinterface", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantSuperinterface"));
            expectedProblemAttributes.put("ReferenceExpressionParameterNullityMismatch", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ReferenceExpressionParameterNullityUnchecked", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("ReferenceExpressionReturnNullRedef", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ReferenceExpressionReturnNullRedefUnchecked", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("ReferenceToForwardField", SKIP);
            expectedProblemAttributes.put("ReferenceToForwardTypeVariable", SKIP);
            expectedProblemAttributes.put("RepeatableAnnotationTypeIsDocumented", SKIP);
            expectedProblemAttributes.put("RepeatableAnnotationTypeIsInherited", SKIP);
            expectedProblemAttributes.put("RepeatableAnnotationTypeTargetMismatch", SKIP);
            expectedProblemAttributes.put("RepeatableAnnotationWithRepeatingContainerAnnotation", SKIP);
            expectedProblemAttributes.put("RepeatedAnnotationWithContainerAnnotation", SKIP);
            expectedProblemAttributes.put("RequiredNonNullButProvidedNull", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("RequiredNonNullButProvidedPotentialNull", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict"));
            expectedProblemAttributes.put("RequiredNonNullButProvidedUnknown", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("RequiredNonNullButProvidedSpecdNullable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            expectedProblemAttributes.put("ResourceHasToImplementAutoCloseable", SKIP);
            expectedProblemAttributes.put("ReturnTypeAmbiguous", SKIP);
            expectedProblemAttributes.put("ReturnTypeCannotBeVoidArray", SKIP);
            expectedProblemAttributes.put("ReturnTypeInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("ReturnTypeInternalNameProvided", SKIP);
            expectedProblemAttributes.put("ReturnTypeMismatch", SKIP);
            expectedProblemAttributes.put("ReturnTypeNotFound", SKIP);
            expectedProblemAttributes.put("ReturnTypeNotVisible", SKIP);
            expectedProblemAttributes.put("SafeVarargsOnFixedArityMethod", SKIP);
            expectedProblemAttributes.put("SafeVarargsOnNonFinalInstanceMethod", SKIP);
            expectedProblemAttributes.put("ShouldImplementHashcode", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod"));
            expectedProblemAttributes.put("ShouldReturnValue", SKIP);
            expectedProblemAttributes.put("ShouldReturnValueHintMissingDefault", SKIP);
            expectedProblemAttributes.put("SpecdNonNullLocalVariableComparisonYieldsFalse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantNullCheck"));
            expectedProblemAttributes.put("StaticInheritedMethodConflicts", SKIP);
            expectedProblemAttributes.put("StaticMemberOfParameterizedType", SKIP);
            expectedProblemAttributes.put("StaticMethodRequested", SKIP);
            expectedProblemAttributes.put("StaticMethodShouldBeAccessedStatically", SKIP);
            expectedProblemAttributes.put("StringConstantIsExceedingUtf8Limit", SKIP);
            expectedProblemAttributes.put("SuperAccessCannotBypassDirectSuper", SKIP);
            expectedProblemAttributes.put("SuperCallCannotBypassOverride", SKIP);
            expectedProblemAttributes.put("SuperInterfaceMustBeAnInterface", SKIP);
            expectedProblemAttributes.put("SuperInterfacesCollide", SKIP);
            expectedProblemAttributes.put("SuperTypeUsingWildcard", SKIP);
            expectedProblemAttributes.put("SuperclassAmbiguous", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod"));
            expectedProblemAttributes.put("SuperclassInheritedNameHidesEnclosingName", SKIP);
            expectedProblemAttributes.put("SuperclassInternalNameProvided", SKIP);
            expectedProblemAttributes.put("SuperclassMustBeAClass", SKIP);
            expectedProblemAttributes.put("SuperclassNotFound", SKIP);
            expectedProblemAttributes.put("SuperclassNotVisible", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.redundantSuperinterface"));
            expectedProblemAttributes.put("SuperfluousSemicolon", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.emptyStatement"));
            expectedProblemAttributes.put("SwitchOnEnumNotBelow15", SKIP);
            expectedProblemAttributes.put("SwitchOnStringsNotBelow17", SKIP);
            expectedProblemAttributes.put("TargetTypeNotAFunctionalInterface", SKIP);
            expectedProblemAttributes.put("Task", SKIP);
            expectedProblemAttributes.put("ThisInStaticContext", SKIP);
            expectedProblemAttributes.put("ThisSuperDuringConstructorInvocation", SKIP);
            expectedProblemAttributes.put("ToleratedMisplacedTypeAnnotations", SKIP);
            expectedProblemAttributes.put("TooManyArgumentSlots", SKIP);
            expectedProblemAttributes.put("TooManyArrayDimensions", SKIP);
            expectedProblemAttributes.put("TooManyBytesForStringConstant", SKIP);
            expectedProblemAttributes.put("TooManyConstantsInConstantPool", SKIP);
            expectedProblemAttributes.put("TooManyFields", SKIP);
            expectedProblemAttributes.put("TooManyLocalVariableSlots", SKIP);
            expectedProblemAttributes.put("TooManyMethods", SKIP);
            expectedProblemAttributes.put("TooManyParametersForSyntheticMethod", SKIP);
            expectedProblemAttributes.put("TooManySyntheticArgumentSlots", SKIP);
            expectedProblemAttributes.put("TypeArgumentMismatch", SKIP);
            expectedProblemAttributes.put("TypeArgumentsForRawGenericConstructor", SKIP);
            expectedProblemAttributes.put("TypeArgumentsForRawGenericMethod", SKIP);
            expectedProblemAttributes.put("TypeCollidesWithPackage", SKIP);
            expectedProblemAttributes.put("TypeHidingType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.typeParameterHiding"));
            expectedProblemAttributes.put("TypeHidingTypeParameterFromMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.typeParameterHiding"));
            expectedProblemAttributes.put("TypeHidingTypeParameterFromType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.typeParameterHiding"));
            expectedProblemAttributes.put("TypeMismatch", SKIP);
            expectedProblemAttributes.put("TypeMissingDeprecatedAnnotation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation"));
            expectedProblemAttributes.put("TypeParameterHidingType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.typeParameterHiding"));
            expectedProblemAttributes.put("UnboxingConversion", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.autoboxing"));
            expectedProblemAttributes.put("UnclosedCloseable", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unclosedCloseable"));
            expectedProblemAttributes.put("UnclosedCloseableAtExit", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unclosedCloseable"));
            expectedProblemAttributes.put("UndefinedAnnotationMember", SKIP);
            expectedProblemAttributes.put("UndefinedConstructor", SKIP);
            expectedProblemAttributes.put("UndefinedConstructorInDefaultConstructor", SKIP);
            expectedProblemAttributes.put("UndefinedConstructorInImplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("UndefinedField", SKIP);
            expectedProblemAttributes.put("UndefinedLabel", SKIP);
            expectedProblemAttributes.put("UndefinedMethod", SKIP);
            expectedProblemAttributes.put("UndefinedName", SKIP);
            expectedProblemAttributes.put("UndefinedType", SKIP);
            expectedProblemAttributes.put("UndefinedTypeVariable", SKIP);
            expectedProblemAttributes.put("UnderscoresInLiteralsNotBelow17", SKIP);
            expectedProblemAttributes.put("UndocumentedEmptyBlock", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock"));
            expectedProblemAttributes.put("UnexpectedStaticModifierForField", SKIP);
            expectedProblemAttributes.put("UnexpectedStaticModifierForMethod", SKIP);
            expectedProblemAttributes.put("UnhandledException", SKIP);
            expectedProblemAttributes.put("UnhandledExceptionInDefaultConstructor", SKIP);
            expectedProblemAttributes.put("UnhandledExceptionInImplicitConstructorCall", SKIP);
            expectedProblemAttributes.put("UnhandledExceptionOnAutoClose", SKIP);
            expectedProblemAttributes.put("UnhandledWarningToken", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unhandledWarningToken"));
            expectedProblemAttributes.put("UninitializedBlankFinalField", SKIP);
            expectedProblemAttributes.put("UninitializedBlankFinalFieldHintMissingDefault", SKIP);
            expectedProblemAttributes.put("UninitializedLocalVariable", SKIP);
            expectedProblemAttributes.put("UninitializedLocalVariableHintMissingDefault", SKIP);
            expectedProblemAttributes.put("UninitializedNonNullField", SKIP);
            expectedProblemAttributes.put("UninitializedNonNullFieldHintMissingDefault", SKIP);
            expectedProblemAttributes.put("UninternedIdentityComparison", SKIP);
            expectedProblemAttributes.put("UnmatchedBracket", SKIP);
            expectedProblemAttributes.put("UnnecessaryArgumentCast", SKIP);
            expectedProblemAttributes.put("UnnecessaryCast", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck"));
            expectedProblemAttributes.put("UnnecessaryElse", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unnecessaryElse"));
            expectedProblemAttributes.put("UnnecessaryInstanceof", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck"));
            expectedProblemAttributes.put("UnnecessaryNLSTag", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral"));
            expectedProblemAttributes.put("UnqualifiedFieldAccess", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess"));
            expectedProblemAttributes.put("UnreachableCatch", SKIP);
            expectedProblemAttributes.put("UnresolvedVariable", SKIP);
            expectedProblemAttributes.put("UnsafeElementTypeConversion", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeGenericArrayForVarargs", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeGenericCast", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeNullnessCast", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion"));
            expectedProblemAttributes.put("UnsafeRawConstructorInvocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeRawFieldAssignment", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeRawGenericConstructorInvocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeRawGenericMethodInvocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeRawMethodInvocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeReturnTypeOverride", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnsafeTypeConversion", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation"));
            expectedProblemAttributes.put("UnterminatedComment", SKIP);
            expectedProblemAttributes.put("UnterminatedString", SKIP);
            expectedProblemAttributes.put("UnusedConstructorDeclaredThrownException", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding"));
            expectedProblemAttributes.put("UnusedImport", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedImport"));
            expectedProblemAttributes.put("UnusedLabel", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedLabel"));
            expectedProblemAttributes.put("UnusedMethodDeclaredThrownException", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding"));
            expectedProblemAttributes.put("UnusedObjectAllocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation"));
            expectedProblemAttributes.put("UnusedPrivateConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"));
            expectedProblemAttributes.put("UnusedPrivateField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"));
            expectedProblemAttributes.put("UnusedPrivateMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"));
            expectedProblemAttributes.put("UnusedPrivateType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember"));
            expectedProblemAttributes.put("UnusedTypeArgumentsForConstructorInvocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation"));
            expectedProblemAttributes.put("UnusedTypeParameter", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedTypeParameter"));
            expectedProblemAttributes.put("UnusedTypeArgumentsForMethodInvocation", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation"));
            expectedProblemAttributes.put("UnusedWarningToken", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.unusedWarningToken"));
            expectedProblemAttributes.put("UseAssertAsAnIdentifier", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.assertIdentifier"));
            expectedProblemAttributes.put("UseEnumAsAnIdentifier", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.enumIdentifier"));
            expectedProblemAttributes.put("IllegalUseOfUnderscoreAsAnIdentifier", SKIP);
            expectedProblemAttributes.put("UsingDeprecatedConstructor", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedField", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedMethod", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("UsingDeprecatedType", new ProblemAttributes(this, "org.eclipse.jdt.core.compiler.problem.deprecation"));
            expectedProblemAttributes.put("VarargsConflict", SKIP);
            expectedProblemAttributes.put("VarargsElementTypeNotVisible", SKIP);
            expectedProblemAttributes.put("VarargsElementTypeNotVisibleForConstructor", SKIP);
            expectedProblemAttributes.put("VariableTypeCannotBeVoid", SKIP);
            expectedProblemAttributes.put("VariableTypeCannotBeVoidArray", SKIP);
            expectedProblemAttributes.put("VoidMethodReturnsValue", SKIP);
            expectedProblemAttributes.put("WildcardConstructorInvocation", SKIP);
            expectedProblemAttributes.put("WildcardFieldAssignment", SKIP);
            expectedProblemAttributes.put("WildcardMethodInvocation", SKIP);
            expectedProblemAttributes.put("illFormedParameterizationOfFunctionalInterface", SKIP);
            expectedProblemAttributes.put("lambdaParameterTypeMismatched", SKIP);
            expectedProblemAttributes.put("lambdaSignatureMismatched", SKIP);
            expectedProblemAttributes.put("DisallowedExplicitThisParameter", SKIP);
            expectedProblemAttributes.put("IllegalArrayOfUnionType", SKIP);
            expectedProblemAttributes.put("IllegalArrayTypeInIntersectionCast", SKIP);
            HashMap<Object, String> constantNamesIndex = new HashMap<Object, String>();
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.jdt.core.JavaCore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field[] fields = clazz.getFields();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                String fieldName;
                Field field = fields[i];
                Class<?> clazz2 = field.getType();
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2 == clazz3 && (fieldName = field.getName()).startsWith("COMPILER_PB_")) {
                    constantNamesIndex.put(field.get(null), fieldName);
                }
                ++i;
            }
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("org.eclipse.jdt.core.compiler.IProblem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            fields = clazz4.getFields();
            StringBuffer failures = new StringBuffer();
            StringBuffer correctResult = new StringBuffer(70000);
            Arrays.sort(fields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Field field1 = (Field)o1;
                    Field field2 = (Field)o2;
                    return field1.getName().compareTo(field2.getName());
                }
            });
            int i2 = 0;
            int length2 = fields.length;
            while (i2 < length2) {
                int problemId;
                int maskedProblemId;
                Field field = fields[i2];
                if (field.getType() == Integer.TYPE && (maskedProblemId = (problemId = field.getInt(null)) & 0xFFFFFF) != 0 && maskedProblemId != 0xFFFFFF) {
                    String name = field.getName();
                    ProblemAttributes expectedAttributes = (ProblemAttributes)expectedProblemAttributes.get(name);
                    String actualTuningOption = JavaCore.getOptionForConfigurableSeverity((int)problemId);
                    if (expectedAttributes == null) {
                        failures.append("missing expected problem attributes for problem " + name + "\n");
                    } else if (!expectedAttributes.skip && !expectedAttributes.option.equals(actualTuningOption)) {
                        failures.append("tuning option mismatch for problem " + name + " (expected " + expectedAttributes.option + ", got " + actualTuningOption + ")\n");
                    }
                    String optionFieldName = (String)constantNamesIndex.get(actualTuningOption);
                    correctResult.append("\t\texpectedProblemAttributes.put(\"" + name + "\", " + (optionFieldName != null ? "new ProblemAttributes(JavaCore." + optionFieldName + ")" : "SKIP") + ");\n");
                }
                ++i2;
            }
            if (failures.length() > 0) {
                System.out.println(correctResult);
                System.out.println();
            }
            CompilerInvocationTests.assertEquals((String)failures.toString(), (int)0, (int)failures.length());
        }
        catch (IllegalAccessException illegalAccessException) {
            CompilerInvocationTests.fail((String)"could not access members");
        }
    }

    class TasksReader
    implements ICompilerRequestor {
        CompilationResult result;

        TasksReader() {
        }

        public void acceptResult(CompilationResult compilationResult) {
            this.result = compilationResult;
        }
    }
}

