/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class GenericsRegressionTest_1_8
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public GenericsRegressionTest_1_8(String name) {
        super(name);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.GenericsRegressionTest_1_8");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public static Test suite() {
        return GenericsRegressionTest_1_8.buildMinimalComplianceTestSuite(GenericsRegressionTest_1_8.testClass(), 32);
    }

    public void testBug423070() {
        this.runConformTest(new String[]{"junk/Junk3.java", "package junk;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.List;\n\nclass ZZObject extends Object {\n}\n\npublic class Junk3 {\n\n    public static final List EMPTY_LIST = new ArrayList<>();\n    public static final <T> List<T> emptyList() {\n        return (List<T>) EMPTY_LIST;\n    }\n    \n    public Junk3(List<ZZObject> list) {\n    }\n    \n    //FAILS - if passed as argument\n    public Junk3() {\n        this(emptyList());\n    }\n    \n\n    //WORKS - if you assign it (and lose type info?)\n    static List works = emptyList();\n    public Junk3(boolean bogus) {\n        this(works);\n    }\n}"});
    }

    public void testConditionalExpression1() {
        this.runConformTest(new String[]{"X.java", "class A {}\nclass B extends A {}\npublic class X {\n\t<T> T combine(T x, T y) { return x; }\n\tA test(A a, B b, boolean flag) {\n\t\treturn combine(flag ? a : b, a);\n\t}\n}\n"});
    }

    public void testConditionalExpression2() {
        this.runConformTest(new String[]{"X.java", "class A{/**/}\nclass B extends A {/**/}\nclass C extends B {/**/}\nclass G<T> {/**/}\n\npublic class X {\nG<A> ga=null;\nG<B> gb=null;\nG<C> gc=null;\nG<? super A> gsa=null;\nG<? super B> gsb=null;\nG<? super C> gsc=null;\n\n@SuppressWarnings(\"unused\")\n    public void test(boolean f) {\n\t\tG<? super B> l1 = (f) ? gsa : gb;\n\t\tG<? super B> l2 = (f) ? gsb : gb;\n       G<? super C> l3 = (f) ? gsc : gb;\n       G<? super B> l4 = (f) ? gsb : gsb;\n\t}\n}"});
    }

    public void testBug423839() {
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\n\npublic class Test<T> {\n\n    public <T> T randomElement(Collection<T> list) {\n        return randomElement(list instanceof List ? list : new ArrayList<>(list));\n    }\n\n}\n"});
    }

    public void testBug418807() {
        this.runConformTest(new String[]{"Word.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n \npublic class Word {\n\tprivate final String str;\n\n\tpublic Word(String s) {\n\t\tstr = s;\n\t}\n\n\t@Override\n\tpublic String toString() {\n\t\treturn str;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tList<String> names = Arrays.asList(\"Aaron\", \"Jack\", \"Ben\");\n\t\tStream<Word> ws = names.stream().map(Word::new);\n\t\tList<Word> words = ws.collect(Collectors.toList());\n\t\twords.forEach(System.out::println);\n\t}\n}\n"});
    }

    public void testBug414631() {
        this.runConformTest(new String[]{"test/Y.java", "package test;\nimport java.util.function.Supplier;\npublic abstract class Y<E>  {\n  public static <E> Y<E> empty() { return null;}\n  public static <E> Y<E> cons(E head, Supplier<Y<E>> tailFun) {return null;}\n}", "test/X.java", "package test;\nimport static test.Y.*;\npublic class X  {\n  public void foo() {\n    Y<String> generated = cons(\"a\", () -> cons(\"b\", Y::<String>empty));\n  }\n}\n"});
    }

    public void testBug424038() {
        this.runNegativeTest(new String[]{"Foo.java", "import java.util.*;\nimport java.util.function.*;\npublic class Foo<E> {\n\n    public void gather() {\n        StreamLike<E> stream = null;\n        List<Stuff<E>> list1 = stream.gather(() -> new Stuff<>()).toList();\n        List<Consumer<E>> list2 = stream.gather(() -> new Stuff<>()).toList(); // ERROR\n    }\n\n    interface StreamLike<E> {\n        <T extends Consumer<E>> StreamLike<T> gather(Supplier<T> gatherer);\n\n        List<E> toList();\n    }\n\n    static class Stuff<T> implements Consumer<T> {\n        public void accept(T t) {}\n    }\n}\n"}, "----------\n1. ERROR in Foo.java (at line 8)\n\tList<Consumer<E>> list2 = stream.gather(() -> new Stuff<>()).toList(); // ERROR\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Foo.Stuff<E>> to List<Consumer<E>>\n----------\n");
    }

    public void testBug423504() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X  {\n  public static void main(String argv[]) {\n    I<? extends Collection<String>> sorter = (List<String> m) -> { /* sort */ };\n  }\n} \n\ninterface I<T> { \n  public void sort(T col);\n}\n"});
    }

    public void testBug420525() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.concurrent.CompletableFuture;\nimport java.util.concurrent.ExecutionException;\npublic class X {\n\tvoid test(List<CompletableFuture<Integer>> futures) {\n\t\tCompletableFuture.allOf(futures.toArray(new CompletableFuture<?>[]{})).thenApplyAsync( (Void v) -> {\n\t\t\tInteger finalResult = futures.stream().map( (CompletableFuture<Integer> f) -> {\n\t\t\t\ttry {\n\t\t\t\t\treturn f.get();\n\t\t\t\t} catch (InterruptedException | ExecutionException e) {\n\t\t\t\t\treturn 0;\n\t\t\t\t}\n\t\t\t}).reduce(0, Integer::sum);\n\t\t\t\n\t\t\tlog(\"final result is \" + finalResult);\n\t\t\tif (finalResult != 50){\n\t\t\t\tthrow new RuntimeException(\"FAILED\");\n\t\t\t} else{\n\t\t\t\tlog(\"SUCCESS\");\n\t\t\t}\n\t\t\t\n\t\t\treturn null;\n\t\t});\n\n\t}\n\tvoid log(String msg) {}\n}\n"});
    }

    public void testBug420525_mini() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.concurrent.CompletableFuture;\nimport java.util.concurrent.ExecutionException;\npublic class X {\n\tvoid test(List<CompletableFuture<Integer>> futures, boolean b) {\n\t\tInteger finalResult = futures.stream().map( (CompletableFuture<Integer> f) -> {\n\t\t\t\t\tif (b) \n\t\t\t\t\t\treturn 1;\n\t\t\t\t\telse\n\t\t\t\t\t\treturn Integer.valueOf(13);\t\t\t\t}).reduce(0, Integer::sum);\n\t}\n}\n"});
    }

    public void testBug420525a() {
        this.runNegativeTest(new String[]{"Main.java", "interface I<T> {\n    T bold(T t);\n}\n\nclass Main {  \n    public String foo(String x) { return \"<b>\" + x + \"</b>\"; }\n    String bar() {\n        I<? extends String> i = this::foo;\n        return i.bold(\"1\");\n    }  \n}\n"}, "----------\n1. ERROR in Main.java (at line 9)\n\treturn i.bold(\"1\");\n\t         ^^^^\nThe method bold(capture#1-of ? extends String) in the type I<capture#1-of ? extends String> is not applicable for the arguments (String)\n----------\n");
    }

    public void testBug424415() {
        this.runConformTest(new String[]{"X.java", "\nimport java.util.ArrayList;\nimport java.util.Collection;\n\ninterface Functional<T> {\n   T apply();\n}\n\nclass X {\n    void foo(Object o) { }\n\n\t<Q extends Collection<?>> Q goo(Functional<Q> s) {\n\t\treturn null;\n\t} \n\n    void test() {\n        foo(goo(ArrayList<String>::new));\n    }\n}\n"});
    }

    public void testBug424415b() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\n\ninterface Functional<T> {\n   T apply();\n}\n\nclass X {\n    void foo(Object o) { }\n    void foo(String str) {} \n\n    <Q extends Collection<?>> Q goo(Functional<Q> s) {\n        return null;\n    } \n\n    void test() {\n        foo(goo(ArrayList<String>::new));\n    }\n}\n"});
    }

    public void testBug424415c() {
        this.runConformTest(new String[]{"com/example/MyEmployee.java", "package com.example;\nclass MyEmployee {\n\t\n\tpublic enum Gender { MALE, FEMALE, OTHERS }\n\n\tprivate int age = 0;\n\tprivate Gender gender = Gender.MALE;\n\t\n\tpublic MyEmployee(int age, Gender gender) {\n\t\tthis.age = age;\n\t\tthis.gender = gender;\n\t}\t\n\t\n\tpublic int getAge() {\n\t\treturn age;\n\t}\n\t\n\tpublic Gender getGender() {\n\t\treturn gender;\n\t}\n}", "com/example/Test.java", "package com.example;\n\nimport java.util.List;\nimport java.util.concurrent.ConcurrentMap;\nimport java.util.stream.Collectors;\n\npublic class Test {\n\n\tConcurrentMap<MyEmployee.Gender, List<MyEmployee>> test(List<MyEmployee> el) {\n\t\treturn el.parallelStream()\n\t\t\t\t\t.collect(\n\t\t\t\t\t\tCollectors.groupingByConcurrent(MyEmployee::getGender)\n\t\t\t\t\t\t);\n\t}\n\t\n}"});
    }

    public void testBug424631() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\n\ninterface Functional<T> {\n   T apply();\n}\n\nclass X {\n    void foo(Collection<String> o) { }\n\n\t<Q extends Collection<?>> Q goo(Functional<Q> s) {\n\t\treturn null;\n\t} \n\n    void test() { \n        foo(goo(ArrayList<String>::new));\n    }\n}\n"});
    }

    public void testBug424403() {
        this.runConformTest(new String[]{"X.java", "interface Functional { int foo(); }\n\npublic class X {\n    static int bar() {\n        return -1;\n    }\n    static <T> T consume(T t) { return null; }\n\n    public static void main(String[] args) {\n    \tFunctional f = consume(X::bar);\n    }  \n}\n"});
    }

    public void testBug401850a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\npublic class X<T> {\n   X(T t) {}\n   X(String s) {}\n   int m(X<String> xs) { return 0; }\n   int i = m(new X<>(\"\"));\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tint i = m(new X<>(\"\"));\n\t          ^^^^^^^^^^^\nThe constructor X<String>(String) is ambiguous\n----------\n");
    }

    public void testBug401850b() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\npublic class X<T> {\n   X(T t) {}\n   X(String s) {}\n   int m(X<String> xs) { return 0; }\n   int i = m(new X<String>(\"\"));\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tint i = m(new X<String>(\"\"));\n\t          ^^^^^^^^^^^^^^^^^\nThe constructor X<String>(String) is ambiguous\n----------\n");
    }

    public void testBug424710() {
        this.runConformTest(new String[]{"MapperTest.java", "import java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.regex.Matcher;\nimport java.util.regex.Pattern;\nimport java.util.stream.Stream;\n\npublic class MapperTest {\n\n    public static void main( String... argv ){\n        List<String> data = Arrays.asList(\"abc\", \"123\", \"1a\", \"?!?\");\n        List<Pattern> patterns = Arrays.asList(Pattern.compile(\"[a-z]+\"), Pattern.compile(\"[0-9]+\"));\n\t\tpatterns.stream()\n\t\t\t\t.flatMap(\n\t\t\t\t\t\tp -> {\n\t\t\t\t\t\t\tStream<Matcher> map = data.stream().map(p::matcher);\n\t\t\t\t\t\t\tStream<Matcher> filter = map.filter(Matcher::find);\n\t\t\t\t\t\t\tFunction<? super Matcher, ? extends Object> mapper = Matcher::group;\n\t\t\t\t\t\t\tmapper = matcher -> matcher.group();\n\t\t\t\t\t\t\treturn filter.map(mapper);\n\t\t\t\t\t\t})\n\t\t\t\t.forEach(System.out::println);\n    }\n}\n"});
    }

    public void testBug424075() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.*;\npublic class X {\n    public static void main(String[] args) {\n        Consumer<Object> c = null;\n        Arrays.asList(pred(), c);\n    }\n\n    static <T> Predicate<T> pred() {\n        return null;\n    }\n}\n"});
    }

    public void testBug424205a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid bar(String t);\n}\nclass X<T> implements I {\n\tpublic void bar(String t) {}\n\tX(String x) {}\n\tX(T x) {}\n\tpublic void one(X<I> c){}\n\tpublic void two() {\n\t\tX<I> i = new X<>((String s) -> { });\n\t\tone (i);\n\t}\n}\n"});
    }

    public void testBug424205b() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid bar(String t);\n}\npublic class X<T> implements I {\n\tpublic void bar(String t) {}\n\tX(String x) {}\n\tX(T x) {}\n\tpublic void one(X<I> c){}\n\tpublic void two() {\n\t\tone(new X<>((String s) -> { })); // 1. Three errors\n\t\tX<I> i = new X<>((String s) -> { }); // 2. Error - Comment out the previous line to see this error go away.\n\t\tone (i);\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"main\");\n\t\tnew X<Integer>(\"one\").two();\n\t}\n}\n"}, "main");
    }

    public void testBug424712a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.function.Supplier;\nimport java.util.Set;\n\npublic class X {\n    public static <T, SOURCE extends Collection<T>, DEST extends Collection<T>>\n        DEST foo(SOURCE sourceCollection, DEST collectionFactory) {\n            return null;\n    }  \n    \n    public static void main(String... args) {\n        Set<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tSet<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n\t    ^\nY cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 12)\n\tSet<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n\t                        ^\nY cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 12)\n\tSet<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n\t                                      ^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n4. ERROR in X.java (at line 12)\n\tSet<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n\t                                      ^^^\nCannot instantiate the type Set\n----------\n");
    }

    public void testBug424712b() {
        this.runConformTest(new String[]{"X.java", "import java.util.Comparator;\npublic class X {\n\t<T> void test() {\n\t\tComparator<? super T> comparator = (Comparator<? super T>) Comparator.naturalOrder();\n\t\tSystem.out.println(\"OK\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().test();\n\t}\n}\n"}, "OK");
    }

    public void testBug425142_minimal() {
        this.runNegativeTest(new String[]{"SomethingBreaks.java", "import java.io.IOException;\nimport java.nio.file.Files;\nimport java.nio.file.Paths;\nimport java.util.function.Consumer;\n\n@FunctionalInterface interface Use<T, E extends Throwable> {   void accept(T t) throws E; }\n\n@SuppressWarnings(\"unused\") public class SomethingBreaks<T, E extends Throwable> {\n  protected static SomethingBreaks<String, IOException> stream() {     return null;  }\n\n  public void forEach(Consumer<T> use) throws E {}\n\n  public <E2 extends E> void forEach(Use<T, E2> use) throws E, E2 {}\n\n  private static void methodReference(String s) throws IOException {\n    System.out.println(Files.size(Paths.get(s)));\n  }\n  \n  public static void useCase9() throws IOException {\n    stream().forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n}\n"}, "----------\n1. ERROR in SomethingBreaks.java (at line 20)\n\tstream().forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n\t         ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n");
    }

    public void testBug425142_full() {
        this.runNegativeTest(new String[]{"SomethingBreaks.java", "import java.io.IOException;\nimport java.nio.file.Files;\nimport java.nio.file.Paths;\nimport java.util.function.Consumer;\n\n@FunctionalInterface interface Use<T, E extends Throwable> {   void accept(T t) throws E; }\n\n@SuppressWarnings(\"unused\") public class SomethingBreaks<T, E extends Throwable> {\n  protected static SomethingBreaks<String, IOException> stream() {     return null;  }\n\n  public void forEach(Consumer<T> use) throws E {}\n\n  public <E2 extends E> void forEach(Use<T, E2> use) throws E, E2 {}\n\n  private static void methodReference(String s) throws IOException {\n    System.out.println(Files.size(Paths.get(s)));\n  }\n  \n  public static void useCase1() throws IOException {\n    Use<String, IOException> c =\n      (String s) -> System.out.println(Files.size(Paths.get(s)));\n    stream().forEach(c);\n  }\n  \n  public static void useCase2() throws IOException {\n    Use<String, IOException> c = SomethingBreaks::methodReference;\n    stream().forEach(c);\n  }\n  \n  public static void useCase3() throws IOException {\n    stream().forEach((Use<String, IOException>) (String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n  \n  public static void useCase4() throws IOException {\n    stream().forEach((Use<String, IOException>) SomethingBreaks::methodReference);\n  }\n  \n  public static void useCase5() throws IOException {\n    stream().<IOException> forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n  \n  public static void useCase6() throws IOException {\n    stream().<IOException> forEach(SomethingBreaks::methodReference);\n  }\n  \n  public static void useCase7() throws IOException {\n    stream().<Use<String, IOException>> forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n  \n  public static void useCase8() throws IOException {\n    stream().<Use<String, IOException>> forEach(SomethingBreaks::methodReference);\n  }\n  \n  public static void useCase9() throws IOException {\n    stream().forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n  \n  public static void useCase10() throws IOException {\n    stream().forEach(SomethingBreaks::methodReference);\n  }\n}\n"}, "----------\n1. ERROR in SomethingBreaks.java (at line 39)\n\tstream().<IOException> forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n\t                       ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n2. ERROR in SomethingBreaks.java (at line 43)\n\tstream().<IOException> forEach(SomethingBreaks::methodReference);\n\t                       ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n3. ERROR in SomethingBreaks.java (at line 43)\n\tstream().<IOException> forEach(SomethingBreaks::methodReference);\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n4. ERROR in SomethingBreaks.java (at line 47)\n\tstream().<Use<String, IOException>> forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n\t                                                                             ^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n5. ERROR in SomethingBreaks.java (at line 51)\n\tstream().<Use<String, IOException>> forEach(SomethingBreaks::methodReference);\n\t                                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n6. ERROR in SomethingBreaks.java (at line 55)\n\tstream().forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n\t         ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n7. ERROR in SomethingBreaks.java (at line 59)\n\tstream().forEach(SomethingBreaks::methodReference);\n\t         ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n8. ERROR in SomethingBreaks.java (at line 59)\n\tstream().forEach(SomethingBreaks::methodReference);\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n");
    }

    public void testBug424195a() {
        this.runNegativeTestMultiResult(new String[]{"NPEOnCollector.java", "import java.io.IOException;\nimport java.nio.file.Path;\nimport java.util.ArrayList;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.jar.JarEntry;\nimport java.util.jar.JarFile;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\n\npublic class NPEOnCollector {\n  static void processJar(Path plugin) throws IOException {\n    \n    try(JarFile jar = new JarFile(plugin.toFile())) {\n      try(Stream<JarEntry> entries = jar.stream()) {\n        Stream<JarEntry> stream = entries\n          .distinct().collect(Collectors.toCollection(ArrayList::new));\n        \n      }\n    }\n  }\n}\n"}, null, new String[]{"----------\n1. ERROR in NPEOnCollector.java (at line 17)\n\tStream<JarEntry> stream = entries\n          .distinct().collect(Collectors.toCollection(ArrayList::new));\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Collection<JarEntry> to Stream<JarEntry>\n----------\n", "----------\n1. ERROR in NPEOnCollector.java (at line 18)\n\t.distinct().collect(Collectors.toCollection(ArrayList::new));\n\t                                            ^^^^^^^^^^^^^^\nThe constructed object of type ArrayList is incompatible with the descriptor's return type: Stream<JarEntry>&Collection<T#2>&Collection<JarEntry>\n----------\n"});
    }

    public void testBug424195b() {
        this.runConformTest(new String[]{"NPEOnCollector.java", "import java.io.IOException;\nimport java.nio.file.Path;\nimport java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.jar.JarEntry;\nimport java.util.jar.JarFile;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\n\npublic class NPEOnCollector {\n  static void processJar(Path plugin) throws IOException {\n    \n    try(JarFile jar = new JarFile(plugin.toFile())) {\n      try(Stream<JarEntry> entries = jar.stream()) {\n        Collection<JarEntry> collection = entries\n          .distinct().collect(Collectors.toCollection(ArrayList::new));\n        \n      }\n    }\n  }\n}\n"});
    }

    public void testBug424195_comment2() {
        this.runConformTest(new String[]{"X.java", "import java.io.PrintStream;\nimport java.util.ArrayList;\nimport java.util.stream.Collectors;\nimport java.util.stream.*;\npublic class X  {\n\n    public static void main(String argv[]) {\n        ArrayList<Integer> al = IntStream\n        \t     .range(0, 10_000)\n        \t     .boxed()\n        \t     .collect(Collectors.toCollection(ArrayList::new));\n\n    }\n}\n"});
    }

    public void testBug425153() {
        this.runNegativeTest(new String[]{"Main.java", "class C1 {}\nclass C2 {}\n\ninterface I<P1 extends C1, P2 extends P1> {\n    P2 foo(P1 p1);\n}\n\npublic class Main  {\n\t    public static void main(String argv[]) {\n\t    \tI<?, ?> i = (C1 c1) -> { return new C2(); };\n\t        Object c2 = i.foo(null);\n\t    }\n}\n"}, "----------\n1. ERROR in Main.java (at line 10)\n\tI<?, ?> i = (C1 c1) -> { return new C2(); };\n\t            ^^^^^^^^^^\nThe target type of this expression is not a well formed parameterized type due to bound(s) mismatch\n----------\n");
    }

    public void testBug424845() {
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\n\npublic class Test {\n    \n\n    interface Function<K, V>{\n        public V apply(K orig);\n    }\n    \n    \n    static class Ordering<O> {\n\n        public <K> Comparator<K> onResultOf(Function<K, ? extends O> function) {\n            return null;\n        }\n\n        \n    }\n    \n    public static void main(String[] args) {\n        List<Object> list = new ArrayList<>();\n        Function<Object, String> function = new Function<Object, String>() {\n            public String apply(Object arg0) {\n                return arg0.toString();\n            }\n        };\n        Ordering<Comparable<String>> natural = new Ordering<>();\n        Collections.sort(list, natural.onResultOf(function));\n    }\n    \n}\n"});
    }

    public void testBug425278() {
        this.runConformTest(new String[]{"X.java", "interface I<T, S extends X<T>> { \n    T foo(S p);\n}\n\npublic class X<T>  {\n    public void bar() {\n    I<Object, X<Object>> f = (p) -> p; // Error\n    }\n}\n"});
    }

    public void testBug425783() {
        this.runConformTest(new String[]{"Test.java", "class MyType<S extends MyType<S>> {\n\tS myself() { return (S)this; }\n}\npublic class Test {\n\tMyType test() {\n\t\treturn newInstance().myself();\n\t}\n\tMyType test2() {\n\t\treturn newInstance().myself();\n\t}\n\tpublic <T extends MyType> T newInstance() {\n\t\treturn (T) new MyType();\n\t}}\n"});
    }

    public void testBug425798() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\ninterface MyCollector<T, A, R> extends Collector<T, A, R> {\n}\npublic abstract class X {\n\tabstract <T, K, U, M extends Map<K, U>>\n    MyCollector<T, ?, M> toMap(Function<? super T, ? extends K> km,\n                                BinaryOperator<U> mf);\tvoid test(Stream<Annotation> annotations) {\n\t\tannotations\n\t\t\t.collect(toMap(Annotation::annotationType,\n\t\t\t\t (first, second) -> first));\n\t}\n}\n"}, "");
    }

    public void testBug425798a() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\ninterface MyCollector<T, A, R> extends Collector<T, A, R> {\n}\npublic abstract class X {\n\tabstract <T, K, U, M extends Map<K, U>>\n    MyCollector<T, ?, M> toMap(Function<? super T, ? extends K> km,\n                                BinaryOperator<U> mf);\tvoid test(Stream<Annotation> annotations) {\n\t\tannotations\n\t\t\t.collect(toMap(true ? Annotation::annotationType : Annotation::annotationType,\n\t\t\t\t (first, second) -> first));\n\t}\n}\n"}, "");
    }

    public void testBug425798b() {
        this.runConformTest(new String[]{"X.java", "import java.util.Objects;\nimport java.util.PrimitiveIterator;\nimport java.util.Spliterator;\nimport java.util.Spliterator.OfInt;\nimport java.util.function.Consumer;\nimport java.util.function.IntConsumer;\n\nclass IntIteratorSpliterator implements OfInt {\n\tpublic IntIteratorSpliterator(PrimitiveIterator.OfInt arg) { }\n\tpublic void forEachRemaining(IntConsumer action) { }\n\tpublic boolean tryAdvance(Consumer<? super Integer> action) { return false; }\n\tpublic long estimateSize() { return 0; }\n\tpublic int characteristics() { return 0; }\n\tpublic OfInt trySplit() { return null; }\n\tpublic boolean tryAdvance(IntConsumer action) { return false; }\n}\npublic class X {\n\n\tpublic Spliterator.OfInt spliterator(PrimitiveIterator.OfInt iterator) {\n\t\treturn new IntIteratorSpliterator(id(iterator));\n\t}\n\t<T> T id(T e) { return e; }\n}\n"});
    }

    public void testBug425460orig() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n\tfinal Integer[] boom =\n  \t\tArrays.asList(\"1\", \"22\", \"333\")\n  \t\t\t.stream()\n  \t\t\t.map(str -> str.length())\n  \t\t\t.toArray(i -> new Integer[i]);\n}\n"});
    }

    public void testBug425460variant() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n\tfinal Integer[] boom =\n  \t\tArrays.asList(\"1\", \"22\", \"333\")\n  \t\t\t.stream()\n  \t\t\t.map(str -> str.length())\n  \t\t\t.toArray((int i) -> new Integer[i]);\n}\n"});
    }

    public void testBug425951() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.List;\n\npublic class Test {\n\n    public static void main(String[] args) {\n        index(new A().test());\n    }\n\n    public static <X> void index(Iterable<X> collection)\n    {\n    }\n\t\n    public class A<S extends A<S>>\n    {\n        protected A() {}\n\t\t\n        public <T> List<T> test()\n       {\n            return null;\n       }\n    }\n}\n"}, "----------\n1. WARNING in Test.java (at line 6)\n\tindex(new A().test());\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation index(List) of the generic method index(Iterable<X>) of type Test\n----------\n2. WARNING in Test.java (at line 6)\n\tindex(new A().test());\n\t      ^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to Iterable<Object>\n----------\n3. ERROR in Test.java (at line 6)\n\tindex(new A().test());\n\t      ^^^^^^^\nNo enclosing instance of type Test is accessible. Must qualify the allocation with an enclosing instance of type Test (e.g. x.new A() where x is an instance of Test).\n----------\n4. WARNING in Test.java (at line 6)\n\tindex(new A().test());\n\t          ^\nTest.A is a raw type. References to generic type Test.A<S> should be parameterized\n----------\n");
    }

    public void testBug425951a() {
        this.runConformTest(new String[]{"Test.java", "import java.util.List;\n\npublic class Test {\n\n    public void test() {\n        index(new A().test());\n    }\n\n    public static <X> void index(Iterable<X> collection)\n    {\n    }\n\t\n    public class A<S extends A<S>>\n    {\n        protected A() {}\n\t\t\n        public <T> List<T> test()\n       {\n            return null;\n       }\n    }\n}\n"});
    }

    public void testBug424906() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n\tpublic <T> void test(Result r) {}\n\n\tpublic static void main(String[] args) {\n\t\tnew Main().test(r -> System.out.println(\"Hmmm...\" + r));\n\t}\n}\n\ninterface Result {\n\tpublic void result(Object object);\n}"});
    }

    public void testBug425156() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n    void foo(T t);\n}\npublic class X {\n    void bar(I<?> i) {\n        i.foo(null);\n    }\n    void run() {\n        bar((X x) -> {}); // Incompatible error reported\n    }\n}\n"});
    }

    public void testBug425493() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n    public void addAttributeBogus(Attribute<?> attribute) {\n        addAttribute(java.util.Objects.requireNonNull(attribute, \"\"),\n                attribute.getDefault());\n        addAttribute(attribute, attribute.getDefault());\n    }\n    public <T> void addAttributeOK(Attribute<T> attribute) {\n        addAttribute(java.util.Objects.requireNonNull(attribute, \"\"),\n                attribute.getDefault());\n        addAttribute(attribute, attribute.getDefault());\n    }\n\n    private <T> void addAttribute(Attribute<T> attribute, T defaultValue) {}\n\n    static class Attribute<T> {\n\n        T getDefault() {\n            return null;\n        }\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 3)\n\taddAttribute(java.util.Objects.requireNonNull(attribute, \"\"),\n\t^^^^^^^^^^^^\nThe method addAttribute(Test.Attribute<T>, T) in the type Test is not applicable for the arguments (Test.Attribute<capture#1-of ?>, capture#2-of ?)\n----------\n2. ERROR in Test.java (at line 5)\n\taddAttribute(attribute, attribute.getDefault());\n\t^^^^^^^^^^^^\nThe method addAttribute(Test.Attribute<T>, T) in the type Test is not applicable for the arguments (Test.Attribute<capture#3-of ?>, capture#4-of ?)\n----------\n");
    }

    public void testBug426366() {
        this.runConformTest(new String[]{"a/Test.java", "package a;\n\nimport java.util.Collections;\nimport java.util.List;\n\n/**\n * @author tomschindl\n *\n */\npublic class Test {\n\tpublic static class A {\n\t\tpublic A(B newSelectedObject, String editorController) {\n\t    }\n\n\t    public A(List<B> newSelectedObjects, String editorController) {\n\t    }\n\t}\n\t\n\tpublic static class B {\n\t\t\n\t}\n\t\n\tpublic static class C extends A {\n\t\tpublic C() {\n\t\t\tsuper(Collections.emptyList(), \"\");\n\t\t}\n\t}\n}\n"});
    }

    public void testBug426290() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n    public static void main(String argv[]) {\n       goo(foo());\n    }\n\n    static <T extends Number> List<T> foo() {\n        return new ArrayList<T>();\n    }\n\n    static void goo(Object p1) {\n        System.out.println(\"goo(Object)\");\n    }\n\n    static void goo(List<Integer> p1) {\n        System.out.println(\"goo(List<Integer>)\");\n    }\n}\n"}, "goo(List<Integer>)");
    }

    public void testBug425152() {
        this.runConformTest(new String[]{"packDown/SorterNew.java", "package packDown;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\n\npublic class SorterNew {\n\tvoid sort() {\n\t\tCollections.sort(new ArrayList<Person>(),\n\t\t\t\tComparator.comparing((Person p) -> p.getName()));\n\t}\n}\n\nclass Person {\n\tpublic String getName() {\n\t\treturn \"p\";\n\t}\n}\n"});
    }

    public void testBug426048() {
        this.runNegativeTest(new String[]{"MyFunction.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Throws {\n  Class<? extends Throwable>[] value() default Throwable.class;\n  Returns method() default @Returns(Annotation.class);\n}\n\n@Target(ElementType.TYPE_USE)\n@interface Returns {\n  Class<? extends Annotation> value() default Annotation.class;\n}\n\n@FunctionalInterface public interface MyFunction<T, @Returns R> {\n  @Returns  R apply(T t);\n\n  default <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n    compose(MyFunction<? super V, ? extends T> before) {\n\n    return (V v) -> apply(before.apply(v));\n  }\n}\n"}, "----------\n1. ERROR in MyFunction.java (at line 19)\n\tdefault <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n\t          ^\nSyntax error, insert \"Type Identifier (\" to complete MethodHeaderName\n----------\n2. ERROR in MyFunction.java (at line 19)\n\tdefault <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from MyFunction<capture#1-of ? super V,capture#2-of ? extends T> to Class<? extends Throwable>[]\n----------\n3. ERROR in MyFunction.java (at line 19)\n\tdefault <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n\t                                                          ^^^^^^\nbefore cannot be resolved\n----------\n4. ERROR in MyFunction.java (at line 19)\n\tdefault <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n\t                                                                       ^\nSyntax error, insert \")\" to complete Modifiers\n----------\n5. ERROR in MyFunction.java (at line 20)\n\tcompose(MyFunction<? super V, ? extends T> before) {\n\t       ^\nSyntax error on token \"(\", , expected\n----------\n");
    }

    public void testBug426540() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\nimport java.util.Collections;\nimport static java.util.stream.Collectors.collectingAndThen;\nimport static java.util.stream.Collectors.toList;\npublic class X {\n\tObject o = ((Stream<Integer>) null).collect(collectingAndThen(toList(), Collections::unmodifiableList));\n}\n"});
    }

    public void testBug426671_ok() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\nimport java.util.*;\nimport static java.util.stream.Collectors.collectingAndThen;\nimport static java.util.stream.Collectors.toList;\npublic class X {\n\tvoid test(Stream<List<Integer>> stream) {\n\t\tstream.collect(collectingAndThen(toList(), Collections::<List<Integer>>unmodifiableList))\n\t\t\t.remove(0);\n\t}\n}\n"});
    }

    public void testBug426671_medium() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\nimport java.util.*;\nimport static java.util.stream.Collectors.collectingAndThen;\nimport static java.util.stream.Collectors.toList;\npublic class X {\n\tvoid test(Stream<List<Integer>> stream) {\n\t\tstream.collect(collectingAndThen(toList(), Collections::unmodifiableList))\n\t\t\t.remove(0);\n\t}\n}\n"});
    }

    public void testBug426671_full() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\nimport java.util.*;\nimport static java.util.stream.Collectors.collectingAndThen;\nimport static java.util.stream.Collectors.toList;\npublic class X {\n\tvoid test() {\n\t\tArrays.asList((List<Integer>) null).stream().collect(collectingAndThen(toList(), Collections::unmodifiableList))\n\t\t\t.remove(0);\n\t}\n}\n"});
    }

    public void testBug426671b() {
        this.runNegativeTest(new String[]{"Test.java", "interface I<X,Y> {\n\tY fun(X y);\n}\npublic class Test {\n\tstatic <S> S id(S s) { return s; }\n\tvoid test() {\n        m1(Test::id, \"Hi\");\n        m2(Test::id, \"Hi\").toUpperCase();\n        m3(Test::id, \"Hi\").toUpperCase();\n   }\n\n\t<U,V> void m1(I<V,U> i, U u) { }\n\t<U,V> V m2(I<V,U> i, U u) {\n\t\treturn null;\n\t}\n\t<U,V> V m3(I<U,V> i, U u) {\n\t\treturn null;\n\t}\n}"}, "----------\n1. ERROR in Test.java (at line 8)\n\tm2(Test::id, \"Hi\").toUpperCase();\n\t                   ^^^^^^^^^^^\nThe method toUpperCase() is undefined for the type Object\n----------\n");
    }

    public void testBug426652() {
        this.runConformTest(new String[]{"X.java", "import static java.util.stream.Collectors.toList;\npublic class X {\n\tObject o = toList();\n}\n"});
    }

    public void testBug426778() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid test(List<CourseProviderEmploymentStatistics> result) {\n          Collections.sort( result, \n              Comparator.comparingInt(\n                  (CourseProviderEmploymentStatistics stat) ->  stat.doneTrainingsTotal\n\t\t\t\t)\n              .reversed()\n              .thenComparing(\n                  (CourseProviderEmploymentStatistics stat) -> stat.courseProviderName ) );\n\t}\n}\nclass CourseProviderEmploymentStatistics {\n   int doneTrainingsTotal;\n   String courseProviderName;\n}\n"});
    }

    public void testBug426676() {
        this.runConformTest(new String[]{"Test.java", "import java.util.Arrays;\nimport java.util.function.Supplier;\nimport java.util.stream.Stream;\n\n\npublic class Test {\n    public static void main(String[] args) throws Exception {\n        // Type inference works on map call.\n        Stream<String> s1 =\n        Arrays.stream(new Integer[] { 1, 2 })\n              .map(i -> i.toString());\n        \n        // Type inference doesn't work on map call.\n        Stream<String> s2 =\n        Arrays.stream(new Integer[] { 1, 2 })\n              .map(i -> i.toString())\n              .distinct();\n    }\n}\n"});
    }

    public void testBug424591_comment20() {
        this.runConformTest(new String[]{"MyList.java", "import java.util.Arrays;\npublic class MyList {\n    protected Object[] elements;\n    private int size;\n    @SuppressWarnings(\"unchecked\")\n    public <A> A[] toArray(A[] a) {\n        return (A[]) Arrays.copyOf(elements, size, a.getClass());\n    }\n}\n"});
    }

    public void testBug424591_comment20_variant() {
        this.runNegativeTest(new String[]{"MyList.java", "import java.util.Arrays;\npublic class MyList {\n    protected Object[] elements;\n    private int size;\n    @SuppressWarnings(\"unchecked\")\n    public <A> A[] toArray(A[] a) {\n        return (A[]) Arrays.copyOf(elements, size, getClass());\n    }\n}\n"}, "----------\n1. ERROR in MyList.java (at line 7)\n\treturn (A[]) Arrays.copyOf(elements, size, getClass());\n\t                    ^^^^^^\nThe method copyOf(U[], int, Class<? extends T[]>) in the type Arrays is not applicable for the arguments (Object[], int, Class<capture#1-of ? extends MyList>)\n----------\n");
    }

    public void testBug424591_comment22() {
        this.runConformTest(new String[]{"Test.java", "import java.util.*;\npublic class Test {\n\tpublic static void main(String[] args) {\n        Test.forObject(new HashSet<>());\n\t}\n    public static Test forObject(Object o) {\n        return null;\n    }\n}\n"});
    }

    public void testBug425063() {
        this.runConformTest(new String[]{"ComparatorUse.java", "import java.util.Comparator;\npublic class ComparatorUse {\n   Comparator<String> c =\n           Comparator.comparing((String s)->s.toString())\n           .thenComparing(s -> s.length());\n}\n"});
    }

    public void testBug426764() {
        this.runConformTest(new String[]{"X.java", "interface I {}\nclass C1 implements I {}\nclass C2 implements I {}\npublic class X  {\n    <T > void foo(T p1, I p2) {}\n    <T extends I> void foo(T p1, I p2) {}\n    void bar() {\n        foo(true ? new C1(): new C2(), false ? new C2(): new C1());\n        foo(new C1(), false ? new C2(): new C1());\n    }\n}\n"});
    }

    public void testBug424930a() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayDeque;\nimport java.util.Deque;\nimport java.util.function.Supplier;\n\npublic class X<S, T extends Deque<S>> {\n    private final Supplier<T> supplier;\n\n    public X(Supplier<T> supplier) {\n        this.supplier = supplier;\n    }\n    \n\t int dequeCapacity;\n    public static <S> X<S, Deque<S>> newDefaultMap() {\n        return new X<>(() -> new ArrayDeque<>(13));\n    }\n}\n"});
    }

    public void testBug424930b() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayDeque;\nimport java.util.Deque;\nimport java.util.function.Supplier;\n\npublic class X<S, T extends Deque<S>> {\n    private final Supplier<T> supplier;\n\n    public X(Supplier<T> supplier) {\n        this.supplier = supplier;\n    }\n    \n    public static <S> X<S, Deque<S>> newDefaultMap(int dequeCapacity) {\n        return new X<>(() -> new ArrayDeque<>(dequeCapacity));\n    }\n}\n"});
    }

    public void testBug424930c() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayDeque;\nimport java.util.Deque;\nimport java.util.function.Supplier;\n\npublic class X<S, T extends Deque<S>> {\n    private final Supplier<T> supplier;\n\n    public X(Supplier<T> supplier) {\n        this.supplier = supplier;\n    }\n    \n\t int dequeCapacity;\n    public static <S> X<S, Deque<S>> newDefaultMap() {\n        return new X<>(() -> new ArrayDeque<>(dequeCapacity));\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\treturn new X<>(() -> new ArrayDeque<>(dequeCapacity));\n\t                                      ^^^^^^^^^^^^^\nCannot make a static reference to the non-static field dequeCapacity\n----------\n");
    }

    public void testBug426998a() {
        this.runConformTest(new String[]{"Snippet.java", "public class Snippet {\n\tstatic void call(Class type, long init) {\n\t\tString string = new String();\n\t\tmethod(type, init == 0 ? new String() : string);\n\t}\n\tprivate static void method(Class type, String s) {}\n}\n"});
    }

    public void testBug426998b() {
        this.runConformTest(new String[]{"Snippet.java", "public class Snippet {\n  private static final String PLACEHOLDER_MEMORY = new String();\n\n  static void newInstance(Class type, long init) {\n    method(type, init == 0 ? new String() : PLACEHOLDER_MEMORY);\n  }\n\n  private static void method(Class type, String str) {}\n}\n"});
    }

    public void testBug427164() {
        this.runNegativeTest(new String[]{"NNLambda.java", "import java.util.*;\n\n@FunctionalInterface\ninterface FInter {\n\tString allToString(List<String> input);\n}\n\npublic abstract class NNLambda {\n\tabstract <INP> void printem(FInter conv, INP single);\n\t\n\tvoid test() {\n\t\tprintem((i) -> {\n\t\t\t\tCollections.<String>singletonList(\"const\")\n\t\t\t}, \n\t\t\t\"single\");\n\t}\n}\n"}, "----------\n1. ERROR in NNLambda.java (at line 13)\n\tCollections.<String>singletonList(\"const\")\n\t                                         ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n", true);
    }

    public void testBug427168() {
        this.runNegativeTest(new String[]{"X.java", "interface Producer<T> {\n\t<P> P produce();\n}\npublic class X {\n\t<T> void perform(Producer<T> r) { }\n\tvoid test() {\n\t\tperform(() -> 13); \n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tperform(() -> 13); \n\t^^^^^^^\nThe method perform(Producer<T>) in the type X is not applicable for the arguments (() -> {})\n----------\n2. ERROR in X.java (at line 7)\n\tperform(() -> 13); \n\t        ^^^^^^^^\nIllegal lambda expression: Method produce of type Producer<T> is generic \n----------\n");
    }

    public void testBug427196() {
        this.runConformTest(new String[]{"MainTest.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\nimport java.util.function.Function;\n\npublic class MainTest {\n    public static <T> List<T> copyOf (Collection<T> c) {\n        return new ArrayList<>(c);\n    }\n    \n    public static <T> List<T> copyOf (Iterable<T> c) {\n        return new ArrayList<>();\n    }\n    \n    public static void main (String[] args) {\n        Function<Collection<String>, List<String>> function1 = c -> MainTest.copyOf(c); //OK\n        Function<Collection<String>, List<String>> function2 = MainTest::copyOf;        //error\n    }\n}\n"});
    }

    public void testBug427224() {
        this.runConformTest(new String[]{"Test2.java", "import java.util.*;\npublic class Test2 {\n    public static native <T> T applyToSet(java.util.Set<String> s);\n\n    public static void applyToList(java.util.List<String> s) {\n        applyToSet(new java.util.HashSet<>(s));\n    }\n}\n"});
    }

    public void testBug424637() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo(X x, String s2);\n}\n\npublic class X {\n\tString goo(String ...ts) {\n\t\tSystem.out.println(ts[0]);  \n\t\treturn ts[0];\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::goo;\n\t\tString s = i.foo(new X(), \"world\");\n\t\tSystem.out.println(s);     \n\t}\n}\n"}, "world\nworld", options);
    }

    public void test427218_reduced() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      match(getLast(\"a\"), null);\n   }\n   public static <T> T getLast(T... array) { return null; } // same with T[]\n   public static void match(boolean b, Object foo) { }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tmatch(getLast(\"a\"), null);\n\t^^^^^\nThe method match(boolean, Object) in the type X is not applicable for the arguments (String, null)\n----------\n2. ERROR in X.java (at line 3)\n\tmatch(getLast(\"a\"), null);\n\t      ^^^^^^^^^^^^\nType mismatch: cannot convert from String to boolean\n----------\n3. WARNING in X.java (at line 5)\n\tpublic static <T> T getLast(T... array) { return null; } // same with T[]\n\t                                 ^^^^^\nType safety: Potential heap pollution via varargs parameter array\n----------\n");
    }

    public void test427218() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      match(getLast(\"a\"), null);\n   }\n   public static <T> T getLast(T... array) { return null; } // same with T[]\n   public static void match(boolean b, Object foo) { }\n   public static <A> void match(Object o, A foo) { }\n}\n"}, "");
    }

    public void testBug427223() {
        this.runConformTest(new String[]{"Test.java", "import java.util.*;\npublic class Test {\n\n\tList<Object> toList(Object o) {\n\t\tif (o instanceof Optional) {\n\t\t\treturn Arrays.asList(((Optional<?>) o).orElse(null));\n\t\t} else {\n\t\t\treturn null;\n\t\t}\n\t}\n\n}\n"});
    }

    public void testBug425183_comment8() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String... args) {\n        java.util.Comparator.reverseOrder().thenComparingLong(X::toLong);\n        System.out.println(\"ok\");\n    }\n    static <T> long toLong(T in) { return 0L; }\n}\n"}, "ok");
    }

    public void testBug427483() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid test() {\n\t\tnew TreeSet<>((String qn1, String qn2) -> {\n   \t\tboolean b = true;\n\t\t\tSystem.out.println(b); // ok\n   \t\tif(b) { }\n\t   \t\treturn qn1.compareTo(qn2);\n\t\t});\n\t}\n}\n"});
    }

    public void testBug427504() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\n\tpublic static <T> Tree<T> model(T o) {\n\t\treturn Node(Leaf(o), Leaf(o));\n\t}\n\t\n\tinterface Tree<T> {}\n\tstatic <T> Tree<T> Node(Tree<T>... children) { return null; }\n\tstatic <T> Tree<T> Leaf(T o) { return null; }\n\t\n}\n"});
    }

    public void testBug427479() {
        this.runConformTest(new String[]{"Bug.java", "import java.util.*;\nimport java.util.function.BinaryOperator; \nimport java.util.stream.*;\n\npublic class Bug {\n \n\tstatic List<String> names = Arrays.asList(\n\t\t\t\"ddd\",\n\t\t\t\"s\",\n\t\t\t\"sdfs\",\n\t\t\t\"sfdf d\"); \n \n\tpublic static void main(String[] args) {\n\t\t\t BinaryOperator<List<String>> merge = (List<String> first, List<String> second) -> {\n\t\t\t\t first.addAll(second);\n\t\t\t\t return first;\n\t\t\t\t };\n\t\t\t\t \n\t\t\tCollector<String,?,Map<Integer,List<String>>> collector= Collectors.toMap(\n\t\t\t\t\ts -> s.length(), \n\t\t\t\t\tArrays::asList,\n\t\t\t\t\tmerge); \n\t\t\tMap<Integer, List<String>> lengthToStrings = names.stream().collect(collector);\n\t\t\t\n\t\t\tlengthToStrings.forEach((Integer i, List<String> l)-> {\n\t\t\t\tSystem.out.println(i + \" : \" + Arrays.deepToString(l.toArray()));\n\t\t\t});\n\n\t}\n\n}\n"});
    }

    public void testBug427479b() {
        this.runNegativeTest(new String[]{"Bug419048.java", "import java.util.List;\nimport java.util.Map;\nimport java.util.stream.Collectors;\n\n\npublic class Bug419048 {\n\tvoid test1(List<Object> roster) {\n        Map<String, Object> map = \n                roster\n                    .stream()\n                    .collect(\n                        Collectors.toMap(\n                            p -> p.getLast(),\n                            p -> p.getLast()\n                        ));\n\t}\n}\n"}, "----------\n1. ERROR in Bug419048.java (at line 9)\n\troster\n                    .stream()\n                    .collect(\n                        Collectors.toMap(\n                            p -> p.getLast(),\n                            p -> p.getLast()\n                        ));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Map<Object,Object> to Map<String,Object>\n----------\n2. ERROR in Bug419048.java (at line 13)\n\tp -> p.getLast(),\n\t       ^^^^^^^\nThe method getLast() is undefined for the type Object\n----------\n3. ERROR in Bug419048.java (at line 14)\n\tp -> p.getLast()\n\t       ^^^^^^^\nThe method getLast() is undefined for the type Object\n----------\n");
    }

    public void testBug427626() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\n\npublic class X {\n\tvoid m() {\n        List<String> ss = Arrays.asList(\"1\", \"2\", \"3\");\n        \n        ss.stream().map(s -> {\n          class L1 {};\n          class L2 {\n            void mm(L1 l) {}\n          }\n          return new L2().mm(new L1());\n        }).forEach(e -> System.out.println(e));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 13)\n\treturn new L2().mm(new L1());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot return a void result\n----------\n");
    }

    public void testBug426542() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\t\n\t<T extends Comparable & Serializable> void foo(T o1) {\n\t}\n\n\t<T extends Serializable> void foo(T o1) {\n\t}\n\n\tvoid bar() {\n\t\tfoo((Comparable & Serializable)0);\n\t\tfoo(0);\n\t}\n}\n"});
    }

    public void testBug426836() {
        this.runConformTest(new String[]{"ReferenceToGetClass.java", "import java.util.function.Supplier;\n\n\npublic class ReferenceToGetClass {\n\t<T> T extract(Supplier<T> s) {\n\t\treturn s.get();\n\t}\n\tClass<?> test() {\n\t\tClass<? extends ReferenceToGetClass> c = extract(this::getClass);\n\t\treturn c;\n\t}\n}\n"});
    }

    public void testBug428019() {
        this.runConformTest(new String[]{"X.java", "final public class X {\n  static class Obj {}\n  static class Dial<T> {}\n\n  <T> void put(Class<T> clazz, T data) {\n  }\n\n  static <T> Dial<T> wrap(Dial<T> dl) {\n\t  return null;\n  }\n\n  static void foo(Dial<? super Obj> dial, X context) {\n    context.put(Dial.class, wrap(dial));\n  }\n  \n  public static void main(String[] args) {\n\tX.foo(new Dial<Obj>(), new X());\n  }\n}\n"});
    }

    public void testBug428198() {
        this.runConformTest(new String[]{"Snippet.java", "import java.util.*;\ninterface BundleRevision {}\ninterface BundleDescription extends BundleRevision {}\npublic class Snippet {\n  static Collection<BundleRevision> test(BundleDescription[] triggers) {\n    @SuppressWarnings(\"unchecked\")\n    Collection<BundleRevision> triggerRevisions =\n    //Type mismatch: cannot convert from Collection<Object> to Collection<BundleRevision>\n      Collections\n        .unmodifiableCollection(triggers == null ? Collections.EMPTY_LIST\n        : Arrays.asList((BundleRevision[]) triggers));\n    return triggerRevisions;\n  }\n}\n"});
    }

    public void testBug428198b() {
        this.runConformTest(new String[]{"Snippet.java", "import java.util.*;\ninterface BundleRevision {}\ninterface BundleDescription extends BundleRevision {}\npublic class Snippet {\n  static Collection<BundleRevision> test(BundleDescription[] triggers) {\n    @SuppressWarnings(\"unchecked\")\n    Collection<BundleRevision> triggerRevisions =\n      Collections\n        .unmodifiableCollection(triggers == null ? Collections.emptyList()\n        : Arrays.asList((BundleRevision[]) triggers));\n    return triggerRevisions;\n  }\n}\n"});
    }

    public void testBug428264() {
        this.runConformTest(new String[]{"Y.java", "import java.util.function.*;\nimport java.util.Optional;\n\ninterface I<E,F> {}\nclass A<G> implements I<G, Optional<G>> {}\n\npublic class Y<S,T> {\n    Y(T o, Predicate<T> p, Supplier<I<S,T>> s) {}\n\n    static <Z> Y<Z, Optional<Z>> m() {\n        return new Y<>(Optional.empty(), Optional::isPresent, A::new);\n    }\n}\n"});
    }

    public void testBug428294() {
        this.runConformTest(new String[]{"Junk5.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\n\npublic class Junk5 {\n\n    class TestTouchDevice {\n        public Object [] points;\n    }\n    \n    public static List<TestTouchDevice> getTouchDevices() {\n        return null;\n    }\n\n    public static Collection<Object[]> getTouchDeviceParameters2(int minPoints) {\n        Collection c = getTouchDevices().stream()\n                .filter(d -> d.points.length >= minPoints)\n                .map(d -> new Object[] { d })\n                .collect(Collectors.toList());\n         return c;\n    }\n    \n    public static Collection<Object[]> getTouchDeviceParameters3(int minPoints) {\n        return getTouchDevices().stream()\n                .filter(d -> d.points.length >= minPoints)\n                .map(d -> new Object[] { d })\n                .collect(Collectors.toList());\n    }\n}\n"});
    }

    public void testBug428291() {
        this.runConformTest(new String[]{"AC3.java", "import java.util.List;\n\ninterface I0<T> { }\n\ninterface I1 { }\ninterface I1List<E> extends List<E>, I1 {}\ninterface I2<T> extends I1 {\n\tvoid foo(I0<? super T> arg1);\n\tvoid bar(I0<? super T> arg2);\n}\ninterface I3<T> extends I2<T> {}\ninterface I4<T> extends I2<T> { }\ninterface I3List<E> extends I3<I1List<E>>, I1List<E> {}\nabstract class AC1<E> implements I3List<E> { }\n\nabstract class AC2<E>  {\n    public static <E> AC2<E> bork(AC2<E> f1, I3List<E> i3l, I0<? super I1List<E>> i1l) {\n        return null;\n    }\n    public static <E> AC2<E> garp(AC2<E> f2, I0<? super I1List<E>> i1l) {\n        return null;\n    }\n}\n\npublic abstract class AC3<E> extends AC1<E> implements I4<I1List<E>> {\n\n    AC2<E> f = null;\n\n    @Override\n    public void foo(I0<? super I1List<E>> arg1) {\n        f = AC2.bork(f, this, arg1);\n    }\n\n    @Override\n    public void bar(I0<? super I1List<E>> arg2) {\n        f = AC2.garp(f, arg2);\n    }\n}\n"});
    }

    public void testBug428275() {
        this.runConformTest(new String[]{"p1/C1.java", "package p1;\n\nimport java.util.List;\n\npublic class C1<T1> {\n\n\tpublic static class CInner<T2A,T2B> {\n\t\tpublic CInner(T2A a, T2B b) {}\n\t}\n\t\n\tpublic static class CInner2<T3A,T3B> {\n\t\tpublic CInner2(String n, List<CInner<T3A,T3B>> arg) {}\n\t}\n\t\n    public static <E> List<E> getList1(E... items) {\n    \treturn null;\n    }\n}\n", "Test.java", "import java.util.List;\n\nimport p1.C1;\n\npublic class Test {\n\tvoid test2(List<C1.CInner2> l) {\n\t\tl.add(\n\t\t\tnew C1.CInner2<>(\"a\",\n\t\t\t\tC1.getList1(new C1.CInner<>(\"b\", 13))\n\t\t\t)\n\t\t);\n\t}\n}\n"});
    }

    public void test428352() {
        this.runNegativeTest(new String[]{"OperationsPile.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\nclass OperationsPile<B> {\n  OperationsPile(Function<B, ?> handler) {}\n\n  private static <T> void addAll3(Collection<T> c, T t) {}\n\n  static <S> void adaad3(List<OperationsPile<?>> combined, Consumer<S> handler) {\n    addAll3(combined, new OperationsPile<>(null));\n    addAll3(combined, new OperationsPile<>(handler));\n  }\n}\n"}, "----------\n1. ERROR in OperationsPile.java (at line 13)\n\taddAll3(combined, new OperationsPile<>(handler));\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for OperationsPile<>\n----------\n");
    }

    public void test428352b() {
        this.runConformTest(new String[]{"OperationsPile.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class OperationsPile<B> {\n  OperationsPile(Function<B, ?> handler) {}\n\n  private static <T> void addAll3(Collection<T> c, T t) {}\n\n  static <S> void adaad3(List<OperationsPile<?>> combined, Consumer<S> handler) {\n    addAll3(combined, new OperationsPile<>(null));\n  }\n\tpublic static void main(String[] args) {\n\t\tadaad3(null, null);\n\t\tSystem.out.println(13);\n\t}\n}\n"}, "13");
    }

    public void testBug428307() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.Function;\nimport java.util.stream.*;\n\ninterface Bar {\n\tClass<? extends Bar> type();\n}\npublic class X {\n \n    <T extends Bar> T[] test(Class<T> barClass, Stream<Bar> bars) {\n        return get(bars.\n                    collect(Collectors.toMap(Bar::type,\n                                             Function.identity(),\n                                             ((first,second) -> first),\n                                             HashMap::new)),\n                            barClass);\n    }\n    \n    <A extends Bar> A[] get(Map<Class<? extends Bar>,Bar> m, Class<A> c) {\n    \treturn null;\n    }\n}\n"});
    }

    public void test428524() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSupplier<WithNoArgConstructor> works = WithNoArgConstructor::new;\n\t\tSystem.out.println(works.get());\n\t\tSupplier<WithoutNoArgConstructor> error = WithoutNoArgConstructor::new;\n\t\tSystem.out.println(error.get());\n\t\t\n\t}\n\tprivate static class WithNoArgConstructor {\n\t\tpublic WithNoArgConstructor() {\n\t\t}\n       public String toString() {\n           return(\"WithNoArgConstructor\");\n       }\n\t}\n\tprivate static class WithoutNoArgConstructor {\n       public String toString() {\n           return(\"WithOutNoArgConstructor\");\n       }\n\t}\n}\n"}, "WithNoArgConstructor\nWithOutNoArgConstructor");
    }

    public void testBug428786() {
        this.runConformTest(new String[]{"Junk9.java", "import java.util.*;\npublic class Junk9 {\n    class Node {\n        public double getLayoutY() {return 12;}\n    }\n    class Node2 extends Node {\n    }\n    void junk() {\n        List<Node2> visibleCells = new ArrayList<>(20);\n        Collections.sort(visibleCells, (Node o1, Node o2) -> Double.compare(o1.getLayoutY(), o2.getLayoutY()));\n    }\n}\n"});
    }

    public void testBug429090_comment1() {
        this.runNegativeTest(new String[]{"Junk10.java", "\npublic class Junk10 {\n    class Observable<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable<?> observable);\n    }\n    public static abstract class Change<E2> {}\n    interface SetChangeListener<E1> {\n        void onChanged(Change<? extends E1> change);\n    }\n    class SetListenerHelper<T> {}\n    public static <E> SetListenerHelper<E> addListener(\n\t\t\tSetListenerHelper<E> helper, SetChangeListener<? super E> listener) {\n        return helper;\n    }\n    void junk() {\n        addListener(null, (SetChangeListener.Change<?> c) -> {});\n    }\n}\n"}, "----------\n1. ERROR in Junk10.java (at line 17)\n\taddListener(null, (SetChangeListener.Change<?> c) -> {});\n\t^^^^^^^^^^^\nThe method addListener(Junk10.SetListenerHelper<E>, Junk10.SetChangeListener<? super E>) in the type Junk10 is not applicable for the arguments (null, (SetChangeListener.Change<?> c) -> {})\n----------\n2. ERROR in Junk10.java (at line 17)\n\taddListener(null, (SetChangeListener.Change<?> c) -> {});\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^\nSetChangeListener.Change cannot be resolved to a type\n----------\n");
    }

    public void testBug429090() {
        this.runConformTest(new String[]{"Junk10.java", "public class Junk10 {\n    class Observable<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable observable);\n    }\n    interface SetChangeListener<E> {\n        public static abstract class Change<E> {}\n        void onChanged(Change<? extends E> change);\n    }\n    class SetListenerHelper<T> {}\n    public static <E> SetListenerHelper<E> addListener(SetListenerHelper<E> helper, InvalidationListener listener) {\n        return helper;\n    }\n    public static <E> SetListenerHelper<E> addListener(SetListenerHelper<E> helper, SetChangeListener<? super E> listener) {\n        return helper;\n    }\n    void junk() {\n        addListener(null, new SetChangeListener () {\n            public void onChanged(SetChangeListener.Change change) {}\n        });\n        addListener(null, (SetChangeListener.Change<? extends Object> c) -> {});\n    }\n}\n"});
    }

    public void testBug429490_comment33() {
        this.runConformTest(new String[]{"Junk12.java", "public class Junk12 {\n    class Observable<T> {}\n    class ObservableValue<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable observable);\n    }\n    public interface ChangeListener<T> {\n        void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n    }\n    class ExpressionHelper<T> {}\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, InvalidationListener listener) {\n        return helper;\n    }\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, ChangeListener<? super T> listener) {\n        return helper;\n    }\n    void junk() {\n        addListener(null, null, new ChangeListener () {\n            public void changed(ObservableValue observable, Object oldValue, Object newValue) {\n                throw new RuntimeException();\n            }\n        });\n        addListener(null, null, (value, o1, o2) -> {throw new RuntimeException();});\n    }\n}\n"});
    }

    public void testBug428811() {
        this.runNegativeTest(new String[]{"MoreCollectors.java", "import java.util.AbstractList;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Collection;\nimport java.util.List;\nimport java.util.stream.Collector;\n\npublic class MoreCollectors {\n    public static void main (String[] args) {\n        ImmutableList<String> list = Arrays.asList(\"a\", \"b\", \"c\").stream().collect(toImmutableList());\n        \n        System.out.println(list);\n    }\n    \n    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList () {\n        return Collector.of(ArrayList<T>::new,\n                List<T>::add,\n                (left, right) -> { left.addAll(right); return left; },\n                ImmutableList::copyOf);\n    }\n    \n    private static class ImmutableList<T> extends AbstractList<T> {\n        public static <T> ImmutableList<T> copyOf (Collection<T> c) {\n            return new ImmutableList<>(c.toArray());\n        }\n\n        private Object[] array;\n        \n        private ImmutableList (Object[] array) {\n            this.array = array;\n        }\n\n        @Override @SuppressWarnings(\"unchecked\")\n        public T get(int index) {\n            return (T)array[index];\n        }\n\n        @Override\n        public int size() {\n            return array.length;\n        }\n    }\n}\n"}, "----------\n1. ERROR in MoreCollectors.java (at line 16)\n\treturn Collector.of(ArrayList<T>::new,\n\t                 ^^\nThe method of(ArrayList<T>::new, List<T>::add, (<no type> left, <no type> right) -> {}, ImmutableList::copyOf) is undefined for the type Collector\n----------\n2. WARNING in MoreCollectors.java (at line 23)\n\tpublic static <T> ImmutableList<T> copyOf (Collection<T> c) {\n\t                                   ^^^^^^^^^^^^^^^^^^^^^^^^\nThe method copyOf(Collection<T>) from the type MoreCollectors.ImmutableList<T> is never used locally\n----------\n");
    }

    public void testBug429430() {
        this.runConformTest(new String[]{"Main.java", "import java.io.*;\npublic class Main {\n  public static interface Closer<T, X extends Exception> {\n    void closeIt(T it) throws X;\n  }\n\n  public static <T, X extends Exception> void close( Closer<T, X> closer, T it ) throws X {\n    closer.closeIt(it);\n  }\n\n  public static void main(String[] args) throws IOException {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x -> x.close(), in );\n    close( InputStream::close, in );\n    close( (Closer<InputStream, IOException>)InputStream::close, in );\n  }\n}\n"});
    }

    public void testBug429430a() {
        this.runNegativeTest(new String[]{"Main.java", "import java.io.*;\n@SuppressWarnings(\"serial\") class EmptyStream extends Exception {}\npublic class Main {\n  public static interface Closer<T, X extends Exception> {\n    void closeIt(T it) throws X;\n  }\n\n  public static <T, X extends Exception> void close( Closer<T, X> closer, T it ) throws X {\n    closer.closeIt(it);\n  }\n\n  public static void main(String[] args) throws IOException, EmptyStream {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x ->  { if (in.available() == 0) throw new EmptyStream(); x.close(); }, in );\n  }\n}\n"}, "----------\n1. ERROR in Main.java (at line 14)\n\tclose( x ->  { if (in.available() == 0) throw new EmptyStream(); x.close(); }, in );\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type Exception\n----------\n");
    }

    public void _testBug429430b() {
        this.runConformTest(new String[]{"Main.java", "import java.io.*;\n@SuppressWarnings(\"serial\") class EmptyStream extends Exception {}\npublic class Main {\n  public static interface Closer<T, X extends Exception> {\n    void closeIt(T it) throws X;\n  }\n\n  public static <T, X extends Exception> void close( Closer<T, X> closer, T it ) throws X {\n    closer.closeIt(it);\n  }\n\n  public static void main(String[] args) throws EmptyStream {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x ->  {\n\t\t\ttry {\n\t\t\t\tx.close();\n\t\t\t} catch (IOException ioex) { throw new EmptyStream(); } \n\t\t},\t\tin);\n  }\n}\n"});
    }

    public void testBug429430c() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runConformTest(new String[]{"Main.java", "import java.io.*;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE) @interface Severe {}\npublic class Main {\n  public static interface Closer<T, X extends Exception> {\n    void closeIt(T it) throws X;\n  }\n\n  public static <T, X extends Exception> void close( Closer<T, X> closer, T it ) throws X {\n    closer.closeIt(it);\n  }\n\n  static @Severe IOException getException() { return new IOException(\"severe\"); }\n  public static void main(String[] args) throws IOException {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x -> {\n\t\t\tif (in.available() > 0)\n\t\t\t\tx.close();\n\t\t\telse\n\t\t\t\tthrow getException();\n\t\t},\n\t\tin);\n  }\n}\n"}, options);
    }

    public void testBug429490() {
        this.runConformTest(new String[]{"Junk11.java", "public class Junk11 {\n    class Observable<T> {}\n    class ObservableValue<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable observable);\n    }\n    public interface ChangeListener<T> {\n        void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n    }\n    class ExpressionHelper<T> {}\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, InvalidationListener listener) {\n        return helper;\n    }\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, ChangeListener<? super T> listener) {\n        return helper;\n    }\n    void junk() {\n        addListener(null, null, new InvalidationListener () {\n            public void invalidated(Observable o) {throw new RuntimeException();}\n        });\n        addListener(null, null, (o) -> {throw new RuntimeException();});\n    }\n}\n"});
    }

    public void testBug429424() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public static void main (String[] args) {\n        List<String> list = new ArrayList<>();\n        list.addAll(X.newArrayList());\n        System.out.println(list);\n    }\n    \n    public static <T> List<T> newArrayList () {\n        return new ArrayList<T>();\n    }\n}\n\n"});
    }

    public void _testBug426537() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(J[] list, I<J<?>> i) {\n\t\tsort(list, i);\n\t}\n\t\n\t<T> T[] sort(T[] list, I<? super T> i) {\n\t\treturn list;\n\t}\n}\ninterface I<T> {}\ninterface J<T> {}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(J[] list, I<J<?>> i) {\n\t         ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tsort(list, i);\n\t^^^^\nThe method sort(T[], I<? super T>) in the type X is not applicable for the arguments (J[], I<J<?>>)\n----------\n");
    }

    public void testBug426537b() {
        this.runConformTest(new String[]{"Test.java", "interface C<T, A, R> {}\n\nclass MImpl<K, V> {}\n\ninterface S<T> { T get(); }\n\npublic class Test {\n\tstatic <T, K, D> C<T, ?, MImpl<K, D>> m1() {\n        return m2(MImpl::new);\n    }\n    \n    static <T, K, D, M extends MImpl<K, D>> C<T, ?, M> m2(S<M> s) {\n    \treturn null;\n    }\n}\n\n"});
    }

    public void testBug426537c() {
        this.runConformTest(new String[]{"Ups.java", "public class Ups {\n    static Object innocent(MImpl o) {\n            return o.remove(\"nice\");\n    }\n}\n", "Test.java", "interface S<T> { T get(); }\ninterface F<T, R> { R apply(T t); }\ninterface C<T, A, R> { }\ninterface IM<K,V> {}\nclass MImpl<K,V>  implements IM<K,V> { \n\tpublic V remove(Object key) { return null; } \n}\npublic final class Test {\n\n    static <T, K, A, D>\n    C<T, ?, IM<K, D>> m1(F<? super T, ? extends K> f, C<? super T, A, D> c) {\n        return m2(f, MImpl::new, c);\n    }\n\n    static <T, K, D, A, M extends IM<K, D>>\n    C<T, ?, M> m2(F<? super T, ? extends K> classifier,\n                                  S<M> mapFactory,\n                                  C<? super T, A, D> downstream) {\n    \treturn null;\n    }\n}\n"});
    }

    public void testBug429203() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"DTest.java", "import java.util.function.Function;\n\n\npublic class DTest<T> {\n\tpublic DTest(Function<T, T> func) { }\n\t\n\tpublic DTest(DTest<Integer> dti) {}\n\t\n\tpublic static void main(String[] args) {\n\t\tDTest<String> t1 = new DTest<String>(new DTest<Integer>());\n\t}\n}\n"}, "----------\n1. ERROR in DTest.java (at line 10)\n\tDTest<String> t1 = new DTest<String>(new DTest<Integer>());\n\t                       ^^^^^\nRedundant specification of type arguments <String>\n----------\n2. ERROR in DTest.java (at line 10)\n\tDTest<String> t1 = new DTest<String>(new DTest<Integer>());\n\t                                     ^^^^^^^^^^^^^^^^^^^^\nThe constructor DTest<Integer>() is undefined\n----------\n", null, true, customOptions);
    }

    public void testBug430296() {
        this.runNegativeTest(new String[]{"AnnotationCollector.java", "import java.lang.annotation.*;\nimport java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\n\npublic abstract class AnnotationCollector {\n        \n        Map<String, Person> test2(Stream<Person> persons) {\n                return persons.collect(Collectors.toMap((Person p) -> p.getLastName(),\n                                                                Function::identity,\n                                                        (p1, p2) -> p1));\n        }\n}\n\nclass Person {\n        String getLastName() { return \"\"; }\n}"}, "----------\n1. ERROR in AnnotationCollector.java (at line 9)\n\treturn persons.collect(Collectors.toMap((Person p) -> p.getLastName(),\n                                                                Function::identity,\n                                                        (p1, p2) -> p1));\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Map<String,Object> to Map<String,Person>\n----------\n2. ERROR in AnnotationCollector.java (at line 10)\n\tFunction::identity,\n\t^^^^^^^^^^^^^^^^^^\nThe type Function does not define identity(Person) that is applicable here\n----------\n");
    }

    public void testBug430759() {
        this.runConformTest(new String[]{"Test.java", "import java.beans.*;\nimport java.util.*;\nimport java.util.function.*;\n\npublic abstract class Test<T,R> implements Function<T,R> {\n\n  public static final <T,R> Test<T,R> getTest() {\n    return new Test<T,R>() {\n      protected final Map<T,ResultSupplier> results = Collections.synchronizedMap(new HashMap<T,ResultSupplier>());\n      @Override\n      public R apply(final T t) {\n        ResultSupplier result = results.get(t);\n        return result.get();\n      }\n      class ResultSupplier implements Supplier<R> {\n        @Override\n        public synchronized R get() {\n          return null;\n        }\n      }\n    };\n  }\n}\n"});
    }

    public void testBug431577() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.Function;\nimport java.util.function.IntFunction;\npublic class Test<R> {\n\tpublic static void main(String[] args) {\n\tnew Test<>().test((Integer i) -> null);\n\t}\n\t<T> void test(Function<T, R> f) {\n\t}\n\tvoid test(int i, IntFunction<R> f) {\n\t\tnew State<>(new Val<>(i));\n\t}\n\tstatic class State<R> {\n\t\tState(Val<?> o) {\n\t\t}\n\t}\n\tstatic class Val<T> {\n\t\tVal(T t) {}\n\t}\n}"});
    }

    public void testBug432110() {
        this.runConformTest(new String[]{"Bug.java", "import java.util.List;\nimport java.util.function.Function;\nimport java.util.stream.Stream;\n\nclass Bug\n{\n    // fully inline\n    // compiles successfully\n    Stream<? extends Integer> flatten1(\n        final Stream<List<Integer>> input)\n    {\n        return input.flatMap(item -> item.stream().map(value -> value));\n    }\n\n    // lambda using braces\n    // compiles with error in eclipse, successfully with javac\n    Stream<? extends Integer> flatten2(\n        final Stream<List<Integer>> input)\n    {\n        return input.flatMap(item -> {\n            return item.stream().map(value -> value);\n        });\n    }\n\n    // without map step\n    // compiles successfully\n    Stream<? extends Integer> flatten3(\n        final Stream<List<Integer>> input)\n    {\n        return input.flatMap(item -> {\n            return item.stream();\n        });\n    }\n\n    // with map step, but not inline\n    // compiles successfully\n    Stream<? extends Integer> flatten4(\n        final Stream<List<Integer>> input)\n    {\n        return input.flatMap(item -> {\n            final Function<? super Integer, ? extends Integer> mapper = value -> value;\n            return item.stream().map(mapper);\n        });\n    }\n\n    // with map step, but outer lambda is not inline\n    // compiles successfully\n    Stream<? extends Integer> flatten5(\n        final Stream<List<Integer>> input)\n    {\n        final Function<? super List<Integer>, ? extends Stream<? extends Integer>> func = item -> {\n            return item.stream().map(value -> value);\n        };\n        return input.flatMap(func);\n    }\n}\n"});
    }

    public void testBug433158() {
        this.runNegativeTest(new String[]{"CollectorsMaps.java", "\nimport java.util.List;\nimport java.util.Map;\nimport static java.util.stream.Collectors.*;\n\npublic class CollectorsMaps {/*Q*/\n\tprivate static class Pair<L, R> {\n\t\tpublic final L lhs; public final R rhs;\n\t\tpublic Pair(L lhs, R rhs) { this.lhs = lhs; this.rhs = rhs; }\n\t\tpublic R rhs() { return rhs; }\n\t\tpublic L lhs() { return lhs; }\n\t\tpublic <N> Pair<N, R> keepingRhs(N newLhs) { return new Pair<>(newLhs, rhs); }\n\t\t/*E*/}\n\n\tstatic Map<String, List<String>> invert(Map<String, List<String>> packages) {\n\t\treturn packages.entrySet().stream().map(e -> new Pair<>(e.getValue(), e.getKey())).flatMap(\n\t\t\t//The method collect(Collector<? super Object,A,R>) in the type Stream<Object>\n\t\t\t//is not applicable for the arguments \n\t\t\t//(Collector<CollectorsMaps.Pair<String,String>,capture#3-of ?,Map<String,List<String>>>)\n\t\t  p -> p.lhs.stream().map(p::keepingRhs)).collect(\n\t\t  groupingBy(Pair<String, String>::lhs, mapping(Pair<String, String>::rhs, toList())));\n\t}\n}\n"}, "----------\n1. ERROR in CollectorsMaps.java (at line 20)\n\tp -> p.lhs.stream().map(p::keepingRhs)).collect(\n\t                                        ^^^^^^^\nThe method collect(Collector<? super Object,A,R>) in the type Stream<Object> is not applicable for the arguments (Collector<CollectorsMaps.Pair<String,String>,capture#3-of ?,Map<String,List<String>>>)\n----------\n");
    }

    public void _testBug432626() {
        this.runConformTest(new String[]{"StreamInterface2.java", "import java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.function.Function;\nimport java.util.function.Supplier;\nimport java.util.stream.Collector;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\npublic interface StreamInterface2 {\n\n\tstatic <T, E extends Exception, K> Map<K, ArrayList<T>> terminalAsMapToList(\n\t  Function<? super T, ? extends K> classifier,\n\t  Supplier<Stream<T>> supplier,\n\t  Class<E> classOfE) throws E {\n\t\treturn terminalAsCollected(classOfE, Collectors.groupingBy(\n\t\t\t  classifier,\n\t\t\t  //This is OK:\n\t\t\t  //Redundant specification of type arguments <K, ArrayList<T>>\n\t\t\t  () -> new HashMap<K, ArrayList<T>>(),\n\t\t\t  Collector.<T, ArrayList<T>> of(\n\t\t\t    () -> new ArrayList<>(),\n\t\t\t    (left, value) -> left.add(value),\n\t\t\t    (left, right) -> combined(left, right))), supplier);\n\t}\n\tstatic <T, E extends Exception, K> Map<K, ArrayList<T>> terminalAsMapToList2(\n\t  Function<? super T, ? extends K> classifier,\n\t  Supplier<Stream<T>> supplier,\n\t  Class<E> classOfE) throws E {\n\t\t//After removing type arguments, ECJ shows error, javac doesn't:\n\t\t//Type mismatch: cannot convert from HashMap<capture#2-of ? extends K,ArrayList<T>> to Map<K,ArrayList<T>>\n\t\treturn terminalAsCollected(classOfE, Collectors.groupingBy(\n\t\t\t  classifier,\n\t\t\t  () -> new HashMap<>(),\n\t\t\t  Collector.<T, ArrayList<T>> of(\n\t\t\t    () -> new ArrayList<>(),\n\t\t\t    (left, value) -> left.add(value),\n\t\t\t    (left, right) -> combined(left, right))), supplier);\n\t}\n\tstatic <E extends Exception, T, M> M terminalAsCollected(\n\t  Class<E> classOfE,\n\t  Collector<T, ?, M> collector,\n\t  Supplier<Stream<T>> supplier) throws E {\n\t\ttry(Stream<T> s = supplier.get()) {\n\t\t\treturn s.collect(collector);\n\t\t} catch(RuntimeException e) {\n\t\t\tthrow unwrapCause(classOfE, e);\n\t\t}\n\t}\n\tstatic <E extends Exception> E unwrapCause(Class<E> classOfE, RuntimeException e) throws E {\n\t\tThrowable cause = e.getCause();\n\t\tif(classOfE.isInstance(cause) == false) {\n\t\t\tthrow e;\n\t\t}\n\t\tthrow classOfE.cast(cause);\n\t}\n\tstatic <T> ArrayList<T> combined(ArrayList<T> left, ArrayList<T> right) {\n\t\tleft.addAll(right);\n\t\treturn left;\n\t}\n}\n"});
    }

    public void testBug433825() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n  }\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    List<String> c1 = new ArrayList<>();\n    new Bar(b ? c1 : new ArrayList<>()); // this line crashes ecj (4.4 I20140429-0800), but not ecj (eclipse 3.8.2) and javac\n  }\n  private static class Bar {\n\t  public Bar(Collection<?> col) { }\n  }\n}"});
    }

    public void testBug433825a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n  }\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    new Bar(b ? 0 : new ArrayList<>());\n  }\n  private static class Bar {\n\t  public Bar(Collection<String> col) { }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tnew Bar(b ? 0 : new ArrayList<>());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X.Bar((b ? 0 : new ArrayList<>())) is undefined\n----------\n2. ERROR in X.java (at line 9)\n\tnew Bar(b ? 0 : new ArrayList<>());\n\t            ^\nType mismatch: cannot convert from int to Collection<String>\n----------\n3. WARNING in X.java (at line 12)\n\tpublic Bar(Collection<String> col) { }\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X.Bar(Collection<String>) is never used locally\n----------\n");
    }

    public void testBug435462() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n  }\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    List<String> c1 = new ArrayList<>();\n    new Bar(b ? new ArrayList<>(b ? new ArrayList<>() : c1) : c1);\n  }\n  private static class Bar {\n\t  public Bar(Collection<?> col) { }\n  }\n}"});
    }

    public void testBug437007() {
        this.runConformTest(new String[]{"ExecutorTests.java", "import java.util.*;\n\npublic class ExecutorTests {\n    List<Runnable> tasks = Arrays.asList(\n            () -> {\n                System.out.println(\"task1 start\");\n            }\n    );\n\n    public void executeInSync(){\n        tasks.stream().forEach(Runnable::run);\n    }\n}\n"});
    }

    public void testBug435689() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.*;\nclass Foo<T> {\n  <U> void apply(Function<T, Consumer<U>> bar) {}\n}\n\nclass Bar {\n  void setBar(String bar){}\n}\npublic class Test {\n\tvoid test() {\n\t\tnew Foo<Bar>().apply(bar -> bar::setBar);\n\t}\n}\n"});
    }
}

