/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTest_1_5
extends JavadocTest {
    String docCommentSupport = "enabled";
    String reportInvalidJavadoc = "error";
    String reportInvalidJavadocVisibility = "private";
    String reportMissingJavadocTags = "error";
    String reportMissingJavadocTagsOverriding = "enabled";
    String reportMissingJavadocComments = null;
    String reportMissingJavadocCommentsVisibility = null;
    static /* synthetic */ Class class$0;

    public JavadocTest_1_5(String name) {
        super(name);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.JavadocTest_1_5");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public static Test suite() {
        return JavadocTest_1_5.buildMinimalComplianceTestSuite(JavadocTest_1_5.testClass(), 4);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", this.docCommentSupport);
        options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", this.reportInvalidJavadoc);
        if (!"ignore".equals(this.reportInvalidJavadoc)) {
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", this.reportInvalidJavadocVisibility);
        }
        if (this.reportMissingJavadocComments != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportMissingJavadocComments);
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", this.reportInvalidJavadoc);
        }
        if (this.reportMissingJavadocCommentsVisibility != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", this.reportMissingJavadocCommentsVisibility);
        }
        if (this.reportMissingJavadocTags != null) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportMissingJavadocTags);
            if (this.reportMissingJavadocTagsOverriding != null) {
                options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", this.reportMissingJavadocTagsOverriding);
            }
        } else {
            options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", this.reportInvalidJavadoc);
        }
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "enabled");
        return options;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.docCommentSupport = "enabled";
        this.reportInvalidJavadoc = "error";
        this.reportInvalidJavadocVisibility = "private";
        this.reportMissingJavadocTags = "error";
        this.reportMissingJavadocTagsOverriding = "enabled";
        this.reportMissingJavadocComments = "ignore";
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", " /**\n  * Valid type parameter reference\n  * @param <E> Type\n  */\n public class X<E> {}"});
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", " /**\n  * Valid type parameter reference\n  * @param <E> Type extends RuntimeException\n  */\n public class X<E extends RuntimeException> {}"});
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", " /**\n  * Valid type parameter reference\n  * @param <T> Type parameter 1\n  * @param <U> Type parameter 2\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"});
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <E> Type parameter\n  */\n public class X {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <E> Type parameter\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <E> Type parameter\n  */\n public class X<E, F> {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic class X<E, F> {}\n\t                  ^\nJavadoc: Missing tag for parameter F\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 1\n  * @param <U> Type parameter 2\n  * @param <V> Type parameter 3\n  */\n public class X<T> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <U> Type parameter 2\n\t          ^\nJavadoc: U cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <V> Type parameter 3\n\t          ^\nJavadoc: V cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 1\n  * @param <X> Type parameter 2\n  * @param <U> Type parameter 2\n  * @param <E> Type parameter 2\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <X> Type parameter 2\n\t          ^\nJavadoc: Parameter X is not declared\n----------\n2. ERROR in X.java (at line 6)\n\t* @param <E> Type parameter 2\n\t          ^\nJavadoc: E cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", " /**\n  * Valid type parameter reference\n  * @param <V> Type parameter 3\n  * @param <U> Type parameter 2\n  * @param <T> Type parameter 1\n  */\n public class X<T, U, V> {}"});
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <U> Type parameter 1\n  * @param <E> Type parameter 2\n  * @param <V> Type parameter 2\n  * @param <U> Type parameter 2\n  * @param <T> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <E> Type parameter 2\n\t          ^\nJavadoc: E cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\t* @param <U> Type parameter 2\n\t          ^\nJavadoc: Duplicate tag for parameter\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X<T, U, V> {}\n\t               ^\nJavadoc: Missing tag for parameter T\n----------\n2. ERROR in X.java (at line 4)\n\tpublic class X<T, U, V> {}\n\t                  ^\nJavadoc: Missing tag for parameter U\n----------\n3. ERROR in X.java (at line 4)\n\tpublic class X<T, U, V> {}\n\t                     ^\nJavadoc: Missing tag for parameter V\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t                  ^\nJavadoc: Missing tag for parameter U\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t                     ^\nJavadoc: Missing tag for parameter V\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <U> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t               ^\nJavadoc: Missing tag for parameter T\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t                     ^\nJavadoc: Missing tag for parameter V\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <U> Type parameter 3\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic class X<T, U, V> {}\n\t               ^\nJavadoc: Missing tag for parameter T\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 3\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic class X<T, U, V> {}\n\t                  ^\nJavadoc: Missing tag for parameter U\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <T> Type parameter 3\n  * @param <U> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic class X<T, U, V> {}\n\t                     ^\nJavadoc: Missing tag for parameter V\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <V> Type parameter 3\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t               ^\nJavadoc: Missing tag for parameter T\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X<T, U, V> {}\n\t                  ^\nJavadoc: Missing tag for parameter U\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <V> Type parameter 2\n  * @param <X> Type parameter 2\n  * @param <U> Type parameter 1\n  * @param <E> Type parameter 2\n  * @param <U> Type parameter 2\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <X> Type parameter 2\n\t          ^\nJavadoc: Parameter X is not declared\n----------\n2. ERROR in X.java (at line 6)\n\t* @param <E> Type parameter 2\n\t          ^\nJavadoc: E cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 7)\n\t* @param <U> Type parameter 2\n\t          ^\nJavadoc: Duplicate tag for parameter\n----------\n4. ERROR in X.java (at line 9)\n\tpublic class X<T, U, V> {}\n\t               ^\nJavadoc: Missing tag for parameter T\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <V> Type parameter 2\n  * @param\n  * @param <U> Type parameter 1\n  */\n public class X<T, U, V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V> {}\n\t               ^\nJavadoc: Missing tag for parameter T\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference: compile error\n  * @param <T> Type parameter 2\n  * @param <V> Type parameter 2\n  * @param <U> Type parameter 1\n  */\n public class X<T, , V> {}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <V> Type parameter 2\n\t          ^\nJavadoc: V cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 1\n\t          ^\nJavadoc: U cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 7)\n\tpublic class X<T, , V> {}\n\t                  ^\nSyntax error on token \",\", delete this token\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference: compile error\n  * @param <T> Type parameter 2\n  * @param <V> Type parameter 2\n  * @param <U> Type parameter 1\n  */\n public class X<T, U, V extend Exception> {}"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V extend Exception> {}\n\t                       ^^^^^^\nSyntax error on token \"extend\", extends expected\n----------\n2. ERROR in X.java (at line 7)\n\tpublic class X<T, U, V extend Exception> {}\n\t                       ^^^^^^\nextend cannot be resolved to a type\n----------\n");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param <E> Type\n\t */\n\tpublic <E> void foo() {}\n}"});
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param <E> Type extends RuntimeException\n\t * @param val int\n\t * @param obj Object\n\t */\n\tpublic <E extends RuntimeException> void foo(int val, Object obj) {}\n}"});
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param val int\n\t * @param obj Object\n\t * @param <T> Type parameter 1\n\t * @param <U> Type parameter 2\n\t * @param <V> Type parameter 3\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"});
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param val int\n\t * @param <E> Type parameter\n\t * @param obj Object\n\t */\n\tpublic void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param <E> Type parameter\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <E> Type parameter\n\t */\n\tpublic <E, F> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic <E, F> void foo(int val, Object obj) {}\n\t           ^\nJavadoc: Missing tag for parameter F\n----------\n2. ERROR in X.java (at line 6)\n\tpublic <E, F> void foo(int val, Object obj) {}\n\t                           ^^^\nJavadoc: Missing tag for parameter val\n----------\n3. ERROR in X.java (at line 6)\n\tpublic <E, F> void foo(int val, Object obj) {}\n\t                                       ^^^\nJavadoc: Missing tag for parameter obj\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <T> Type parameter 1\n\t * @param <U> Type parameter 2\n\t * @param <V> Type parameter 3\n\t * @param xxx int\n\t * @param Obj Object\n\t */\n\tpublic <T> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param <U> Type parameter 2\n\t          ^\nJavadoc: U cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\t* @param <V> Type parameter 3\n\t          ^\nJavadoc: V cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 7)\n\t* @param xxx int\n\t         ^^^\nJavadoc: Parameter xxx is not declared\n----------\n4. ERROR in X.java (at line 8)\n\t* @param Obj Object\n\t         ^^^\nJavadoc: Parameter Obj is not declared\n----------\n5. ERROR in X.java (at line 10)\n\tpublic <T> void foo(int val, Object obj) {}\n\t                        ^^^\nJavadoc: Missing tag for parameter val\n----------\n6. ERROR in X.java (at line 10)\n\tpublic <T> void foo(int val, Object obj) {}\n\t                                    ^^^\nJavadoc: Missing tag for parameter obj\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <T> Type parameter 1\n\t * @param <X> Type parameter 2\n\t * @param val int\n\t * @param <U> Type parameter 2\n\t * @param <E> Type parameter 2\n\t * @param obj Object\n\t * @param <V> Type parameter 3\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param <X> Type parameter 2\n\t          ^\nJavadoc: Parameter X is not declared\n----------\n2. ERROR in X.java (at line 8)\n\t* @param <E> Type parameter 2\n\t          ^\nJavadoc: E cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Valid type parameter reference\n\t * @param <V> Type parameter 3\n\t * @param obj Object\n\t * @param <U> Type parameter 2\n\t * @param val int\n\t * @param <T> Type parameter 1\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"});
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^\nJavadoc: Missing tag for parameter T\n----------\n2. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t           ^\nJavadoc: Missing tag for parameter U\n----------\n3. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t              ^\nJavadoc: Missing tag for parameter V\n----------\n4. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                              ^^^\nJavadoc: Missing tag for parameter val\n----------\n5. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <T> Type parameter 3\n\t * @param val int\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t           ^\nJavadoc: Missing tag for parameter U\n----------\n2. ERROR in X.java (at line 7)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t              ^\nJavadoc: Missing tag for parameter V\n----------\n3. ERROR in X.java (at line 7)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param obj Object\n\t * @param <U> Type parameter 3\n\t * @param <V> Type parameter 3\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^\nJavadoc: Missing tag for parameter T\n----------\n2. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                              ^^^\nJavadoc: Missing tag for parameter val\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param val int\n\t * @param <V> Type parameter 2\n\t * @param <X> Type parameter 2\n\t * @param <U> Type parameter 1\n\t * @param Object obj\n\t * @param <E> Type parameter 2\n\t * @param <U> Type parameter 2\n\t * @param val int\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\t* @param <X> Type parameter 2\n\t          ^\nJavadoc: Parameter X is not declared\n----------\n2. ERROR in X.java (at line 8)\n\t* @param Object obj\n\t         ^^^^^^\nJavadoc: Parameter Object is not declared\n----------\n3. ERROR in X.java (at line 9)\n\t* @param <E> Type parameter 2\n\t          ^\nJavadoc: E cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 10)\n\t* @param <U> Type parameter 2\n\t          ^\nJavadoc: Duplicate tag for parameter\n----------\n5. ERROR in X.java (at line 11)\n\t* @param val int\n\t         ^^^\nJavadoc: Duplicate tag for parameter\n----------\n6. ERROR in X.java (at line 13)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^\nJavadoc: Missing tag for parameter T\n----------\n7. ERROR in X.java (at line 13)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference\n\t * @param <V> Type parameter 2\n\t * @param\n\t * @param <U> Type parameter 1\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t        ^\nJavadoc: Missing tag for parameter T\n----------\n3. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                              ^^^\nJavadoc: Missing tag for parameter val\n----------\n4. ERROR in X.java (at line 8)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference: compile error\n\t * @param <T> Type parameter 2\n\t * @param <V> Type parameter 2\n\t * @param <U> Type parameter 1\n\t * @param val int\n\t * @param obj Object\n\t */\n\tpublic <T, , V> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T> Type parameter 2\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <V> Type parameter 2\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in X.java (at line 6)\n\t* @param <U> Type parameter 1\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in X.java (at line 10)\n\tpublic <T, , V> void foo(int val, Object obj) {}\n\t           ^\nSyntax error on token \",\", delete this token\n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", " public class X {\n\t/**\n\t * Invalid type parameter reference: compile error\n\t * @param <T> Type parameter 2\n\t * @param <V> Type parameter 2\n\t * @param <U> Type parameter 1\n\t * @param val int\n\t * @param obj Object\n\t */\n\tpublic <T, U, V extends Exceptions> void foo(int val, Object obj) {}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tpublic <T, U, V extends Exceptions> void foo(int val, Object obj) {}\n\t                        ^^^^^^^^^^\nExceptions cannot be resolved to a type\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param < Type\n  * @param < Type for parameterization\n  * @param <> Type\n  * @param <?> Type\n  * @param <*> Type\n  */\n public class X<E> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param < Type\n\t         ^^^^^^\nJavadoc: Invalid param tag type parameter name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param < Type for parameterization\n\t         ^^^^^^\nJavadoc: Invalid param tag type parameter name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <> Type\n\t         ^^\nJavadoc: Invalid param tag type parameter name\n----------\n4. ERROR in X.java (at line 6)\n\t* @param <?> Type\n\t         ^^^\nJavadoc: Invalid param tag type parameter name\n----------\n5. ERROR in X.java (at line 7)\n\t* @param <*> Type\n\t         ^^^\nJavadoc: Invalid param tag type parameter name\n----------\n6. ERROR in X.java (at line 9)\n\tpublic class X<E> {}\n\t               ^\nJavadoc: Missing tag for parameter E\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", " /**\n  * Invalid type parameter reference\n  * @param <E Type\n  * @param E> Type\n  * @param <<E> Type\n  * @param <<<E> Type\n  * @param <E>> Type\n  */\n public class X<E> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param <E Type\n\t         ^^\nJavadoc: Invalid param tag type parameter name\n----------\n2. ERROR in X.java (at line 4)\n\t* @param E> Type\n\t         ^^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 5)\n\t* @param <<E> Type\n\t         ^^^^\nJavadoc: Invalid param tag type parameter name\n----------\n4. ERROR in X.java (at line 6)\n\t* @param <<<E> Type\n\t         ^^^^^\nJavadoc: Invalid param tag type parameter name\n----------\n5. ERROR in X.java (at line 7)\n\t* @param <E>> Type\n\t         ^^^^\nJavadoc: Invalid param tag type parameter name\n----------\n6. ERROR in X.java (at line 9)\n\tpublic class X<E> {}\n\t               ^\nJavadoc: Missing tag for parameter E\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test040() {
        this.runConformReferenceTest(new String[]{"X.java", "/**\n * @category\n */\npublic class X {\n}\n"});
    }

    public void testBug80257() {
        this.runNegativeTest(new String[]{"X.java", "/**\n * @see G#G(Object)\n * @see G#G(Exception)\n */\npublic class X extends G<Exception> {\n\tX(Exception exc) { super(exc);}\n}\nclass G<E extends Exception> {\n\tG(E e) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t* @see G#G(Object)\n\t         ^^^^^^^^^\nJavadoc: The constructor G(Object) is undefined\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void _testBug82514() {
        this.runNegativeTest(new String[]{"X.java", "class ComparableUtils {\n   public static <T extends Comparable< ? super T>> int compareTo(final Object first, final Object firstPrime,  final Class<T> type) throws ClassCastException\n    {\n        return 0;\n    }\n    public static <X extends Comparable< ? super X>> int compareTo(final X first, final X firstPrime)\n        throws ClassCastException\n    {\n        return 0;\n    }\n}\npublic final class X {  \n\t/** Tests the method{@link ComparableUtils#compareTo(Object, Object, Class)} and\n\t *  {@link ComparableUtils#compareTo(Object, Object)}.\n\t */\n    public void testCompareTo() {}\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tpublic static <X extends Comparable< ? super X>> int compareTo(final X first, final X firstPrime)\n\t               ^\nThe type parameter X is hiding the type X\n----------\n2. ERROR in X.java (at line 14)\n\t*  {@link ComparableUtils#compareTo(Object, Object)}.\n\t                          ^^^^^^^^^\nJavadoc: Bound mismatch: The generic method compareTo(X, X) of type ComparableUtils is not applicable for the arguments (Object, Object). The inferred type Object is not a valid substitute for the bounded parameter <X extends Comparable<? super X>>\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83127a() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Test.java", "/** \n * @see Test#add(T) \n * @see #add(T)\n * @see Test#Test(T)\n * @see #Test(T)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (T)\"\n *   - method binding = Test.add(Object)\n *   - parameter binding = T of A\n */\npublic class Test<T> {\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Test#add(T) \n\t            ^^^\nJavadoc: The method add(Object) in the type Test is not applicable for the arguments (T)\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see #add(T)\n\t        ^^^\nJavadoc: The method add(Object) in the type Test is not applicable for the arguments (T)\n----------\n3. ERROR in Test.java (at line 4)\n\t* @see Test#Test(T)\n\t            ^^^^^^^\nJavadoc: The constructor Test(T) is undefined\n----------\n4. ERROR in Test.java (at line 5)\n\t* @see #Test(T)\n\t        ^^^^^^^\nJavadoc: The constructor Test(T) is undefined\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83127b() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Test.java", "/** \n * @see Sub#add(T)\n * @see Sub#Sub(T)\n *   - warning = \"The method add(Number) in the type Sub is not applicable for\n *                the arguments (T)\"\n *   - method binding = Sub.add(Number)\n *   - parameter binding = T of A\n *     -> Do we need to change this as T natually resolved to TypeVariable?\n *        As compiler raises a warning, it's perhaps not a problem now...\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Sub#add(T)\n\t           ^^^\nJavadoc: The method add(Number) in the type Sub is not applicable for the arguments (T)\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Sub#Sub(T)\n\t           ^^^^^^\nJavadoc: The constructor Sub(T) is undefined\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83127c() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Test.java", "/** \n * @see Sub#add(E) \n * @see Sub#Sub(E)\n *   - warning = \"E cannot be resolved to a type\"\n *   - method binding = null\n *   - parameter binding = null\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Sub#add(E) \n\t               ^\nJavadoc: E cannot be resolved to a type\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Sub#Sub(E)\n\t               ^\nJavadoc: E cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83127d() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated1.java", "public class Unrelated1<E extends Number> {\n\tpublic Unrelated1(E e) {}\n\tpublic boolean add(E e) { return false; }\n}\n", "Test.java", "/** \n * @see Unrelated1#add(E)\n * @see Unrelated1#Unrelated1(E)\n *   - warning = \"E cannot be resolved to a type\"\n *   - method binding = null\n *   - parameter binding = null\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Unrelated1#add(E)\n\t                      ^\nJavadoc: E cannot be resolved to a type\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Unrelated1#Unrelated1(E)\n\t                             ^\nJavadoc: E cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83127e() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated1.java", "public class Unrelated1<E extends Number> {\n\tpublic Unrelated1(E e) {}\n\tpublic boolean add(E e) { return false; }\n}\n", "Test.java", "/** \n * @see Unrelated1#add(Object)\n * @see Unrelated1#Unrelated1(Object)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (Object)\"\n *   - method binding = Unrelated1.add(Number)\n *   - parameter binding = java.lang.Object\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Unrelated1#add(Object)\n\t                  ^^^\nJavadoc: The method add(Number) in the type Unrelated1 is not applicable for the arguments (Object)\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Unrelated1#Unrelated1(Object)\n\t                  ^^^^^^^^^^^^^^^^^^\nJavadoc: The constructor Unrelated1(Object) is undefined\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83127f() {
        this.reportMissingJavadocTags = "ignore";
        this.runConformTest(new String[]{"Unrelated1.java", "public class Unrelated1<E extends Number> {\n\tpublic Unrelated1(E e) {}\n\tpublic boolean add(E e) { return false; }\n}\n", "Test.java", "/** \n * @see Unrelated1#add(Number)\n * @see Unrelated1#Unrelated1(Number)\n *   - no warning\n *   - method binding = Unrelated1.add(Number)\n *   - parameter binding = java.lang.Number\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"});
    }

    public void testBug83127g() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated1.java", "public class Unrelated1<E extends Number> {\n\tpublic Unrelated1(E e) {}\n\tpublic boolean add(E e) { return false; }\n}\n", "Test.java", "/** \n * @see Unrelated1#add(Integer)\n * @see Unrelated1#Unrelated1(Integer)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (Integer)\"\n *   - method binding = Unrelated1.add(Number)\n *   - parameter binding = java.lang.Integer\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n\tpublic boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Unrelated1#add(Integer)\n\t                  ^^^\nJavadoc: The method add(Number) in the type Unrelated1 is not applicable for the arguments (Integer)\n----------\n2. ERROR in Test.java (at line 3)\n\t* @see Unrelated1#Unrelated1(Integer)\n\t                  ^^^^^^^^^^^^^^^^^^^\nJavadoc: The constructor Unrelated1(Integer) is undefined\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83127h() {
        this.reportMissingJavadocTags = "ignore";
        this.runNegativeTest(new String[]{"Unrelated2.java", "public interface Unrelated2<E> {\n\tboolean add(E e);\n}\n", "Test.java", "/** \n * @see Unrelated2#add(T)\n *   - warning = \"The method add(Object) in the type Test is not applicable for\n *                the arguments (T)\"\n *   - method binding = Unrelated2.add(Object)\n *   - parameter binding = T of A\n *     -> Do we need to change this as T natually resolved to TypeVariable?\n *        As compiler raises a warning, it's perhaps not a problem now...\n */\npublic class Test<T>{\n\tTest(T t) {}\n    public boolean add(T t) {\n        return true;\n    }\n}\n\nclass Sub<E extends Number> extends Test<E> {\n\tSub (E e) {super(null);}\n    public boolean add(E e) {\n        if (e.doubleValue() > 0)\n            return false;\n        return super.add(e);\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t* @see Unrelated2#add(T)\n\t                  ^^^\nJavadoc: The method add(Object) in the type Unrelated2 is not applicable for the arguments (T)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83393a() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tpublic void foo(int a, int b) {} \n\tpublic void foo(int a, int... args) {}\n\tpublic void foo(String... args) {}\n\tpublic void foo(Exception str, boolean... args) {}\n}\n", "Valid.java", "/**\n * @see Test#foo(int, int)\n * @see Test#foo(int, int[])\n * @see Test#foo(int, int...)\n * @see Test#foo(String[])\n * @see Test#foo(String...)\n * @see Test#foo(Exception, boolean[])\n * @see Test#foo(Exception, boolean...)\n */\npublic class Valid {}\n"});
    }

    public void testBug83393b() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\tpublic void foo(int a, int b) {} \n\tpublic void foo(int a, int... args) {}\n\tpublic void foo(String... args) {}\n\tpublic void foo(Exception str, boolean... args) {}\n}\n", "Invalid.java", "/**\n * @see Test#foo(int)\n * @see Test#foo(int, int, int)\n * @see Test#foo()\n * @see Test#foo(String)\n * @see Test#foo(String, String)\n * @see Test#foo(Exception)\n * @see Test#foo(Exception, boolean)\n * @see Test#foo(Exception, boolean, boolean)\n */\npublic class Invalid {}\n"}, "----------\n1. ERROR in Invalid.java (at line 2)\n\t* @see Test#foo(int)\n\t            ^^^\nJavadoc: The method foo(int, int...) in the type Test is not applicable for the arguments (int)\n----------\n2. ERROR in Invalid.java (at line 3)\n\t* @see Test#foo(int, int, int)\n\t            ^^^\nJavadoc: The method foo(int, int...) in the type Test is not applicable for the arguments (int, int, int)\n----------\n3. ERROR in Invalid.java (at line 4)\n\t* @see Test#foo()\n\t            ^^^\nJavadoc: The method foo(String...) in the type Test is not applicable for the arguments ()\n----------\n4. ERROR in Invalid.java (at line 5)\n\t* @see Test#foo(String)\n\t            ^^^\nJavadoc: The method foo(String...) in the type Test is not applicable for the arguments (String)\n----------\n5. ERROR in Invalid.java (at line 6)\n\t* @see Test#foo(String, String)\n\t            ^^^\nJavadoc: The method foo(String...) in the type Test is not applicable for the arguments (String, String)\n----------\n6. ERROR in Invalid.java (at line 7)\n\t* @see Test#foo(Exception)\n\t            ^^^\nJavadoc: The method foo(Exception, boolean...) in the type Test is not applicable for the arguments (Exception)\n----------\n7. ERROR in Invalid.java (at line 8)\n\t* @see Test#foo(Exception, boolean)\n\t            ^^^\nJavadoc: The method foo(Exception, boolean...) in the type Test is not applicable for the arguments (Exception, boolean)\n----------\n8. ERROR in Invalid.java (at line 9)\n\t* @see Test#foo(Exception, boolean, boolean)\n\t            ^^^\nJavadoc: The method foo(Exception, boolean...) in the type Test is not applicable for the arguments (Exception, boolean, boolean)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug83804() {
        this.runNegativeTest(new String[]{"pack/package-info.java", "/**\n * Valid javadoc.\n * @see pack.Test\n * @see Unknown\n * @see pack.Test#foo()\n * @see pack.Test#unknown()\n * @see pack.Test#field\n * @see pack.Test#unknown\n * @param unexpected\n * @throws unexpected\n * @return unexpected \n * @deprecated accepted by javadoc.exe although javadoc 1.5 spec does not say that's a valid tag\n * @other-tags are valid\n */\npackage pack;\n", "pack/Test.java", "/**\n * Invalid javadoc\n */\npackage pack;\npublic class Test {\n\tpublic int field;\n\tpublic void foo() {}\n}\n"}, "----------\n1. ERROR in pack\\package-info.java (at line 4)\n\t* @see Unknown\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n2. ERROR in pack\\package-info.java (at line 6)\n\t* @see pack.Test#unknown()\n\t                 ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Test\n----------\n3. ERROR in pack\\package-info.java (at line 8)\n\t* @see pack.Test#unknown\n\t                 ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n4. ERROR in pack\\package-info.java (at line 9)\n\t* @param unexpected\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n5. ERROR in pack\\package-info.java (at line 10)\n\t* @throws unexpected\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n6. ERROR in pack\\package-info.java (at line 11)\n\t* @return unexpected \n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug86769() {
        this.reportMissingJavadocComments = "error";
        this.runNegativeTest(new String[]{"E.java", "public enum E {\n\tA,\n\tDC{\n\t\tpublic void foo() {}\n\t};\n\tE() {}\n\tpublic void foo() {}\n\tprivate enum Epriv {\n\t\tApriv,\n\t\tCpriv {\n\t\t\tpublic void foo() {}\n\t\t};\n\t\tEpriv() {}\n\t\tpublic void foo() {}\n\t}\n\tenum Edef {\n\t\tAdef,\n\t\tCdef {\n\t\t\tpublic void foo() {}\n\t\t};\n\t\tEdef() {}\n\t\tpublic void foo() {}\n\t}\n\tprotected enum Epro {\n\t\tApro,\n\t\tCpro {\n\t\t\tpublic void foo() {}\n\t\t};\n\t\tEpro() {}\n\t\tpublic void foo() {}\n\t}\n\tpublic enum Epub {\n\t\tApub,\n\t\tCpub {\n\t\t\tpublic void foo() {}\n\t\t};\n\t\tEpub() {}\n\t\tpublic void foo() {}\n\t}\n}\n"}, "----------\n1. ERROR in E.java (at line 1)\n\tpublic enum E {\n\t            ^\nJavadoc: Missing comment for public declaration\n----------\n2. ERROR in E.java (at line 2)\n\tA,\n\t^\nJavadoc: Missing comment for public declaration\n----------\n3. ERROR in E.java (at line 3)\n\tDC{\n\t^^\nJavadoc: Missing comment for public declaration\n----------\n4. ERROR in E.java (at line 7)\n\tpublic void foo() {}\n\t            ^^^^^\nJavadoc: Missing comment for public declaration\n----------\n5. ERROR in E.java (at line 32)\n\tpublic enum Epub {\n\t            ^^^^\nJavadoc: Missing comment for public declaration\n----------\n6. ERROR in E.java (at line 33)\n\tApub,\n\t^^^^\nJavadoc: Missing comment for public declaration\n----------\n7. ERROR in E.java (at line 34)\n\tCpub {\n\t^^^^\nJavadoc: Missing comment for public declaration\n----------\n8. ERROR in E.java (at line 38)\n\tpublic void foo() {}\n\t            ^^^^^\nJavadoc: Missing comment for public declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug95286_Default() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "default";
        this.runConformTest(new String[]{"test/package-info.java", "/**\n * Javadoc for all package \n */\npackage test;\n"});
    }

    public void testBug95286_Private() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "private";
        this.runConformTest(new String[]{"test/package-info.java", "/**\n * Javadoc for all package \n */\npackage test;\n"});
    }

    public void testBug95521() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n\n/** Test */\npublic class X implements I {\n\t/**\n\t * @see test.I#foo(java.lang.Class)\n\t */\n\tpublic <T> G<T> foo(Class<T> stuffClass) {\n\t\treturn null;\n\t}\n}\n/** Interface */\ninterface I {\n    /**\n     * @param <T>\n     * @param stuffClass \n     * @return stuff\n     */\n    public <T extends Object> G<T> foo(Class<T> stuffClass);\n}\n/** \n * @param <T>\n */\nclass G<T> {}\n"});
    }

    public void testBug95521b() {
        this.runConformTest(new String[]{"test/X.java", "package test;\n\n/** Test */\npublic class X {\n    /**\n     * @param <T>\n     * @param classT \n     */\n\tpublic <T> X(Class<T> classT) {\n\t}\n    /**\n     * @param <T>\n     * @param classT\n     * @return classT\n     */\n\tpublic <T> Class<T> foo(Class<T> classT) {\n\t\treturn classT;\n\t}\n}\n/** Super class */\nclass Y extends X {\n\t/**\n\t * @see X#X(java.lang.Class)\n\t */\n\tpublic <T> Y(Class<T> classT) {\n\t\tsuper(classT);\n\t}\n\n\t/**\n\t * @see X#foo(java.lang.Class)\n\t */\n    public <T extends Object> Class<T> foo(Class<T> stuffClass) {\n    \treturn null;\n    }\n}\n"});
    }

    public void testBug96237_Public01() {
        this.reportInvalidJavadocVisibility = "public";
        this.runConformTest(new String[]{"comment6/Valid.java", "package comment6;\npublic class Valid {\n    /**\n     * @see Valid.Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Valid.Inner}\n */\nclass Sub2 extends Valid { }"});
    }

    public void testBug96237_Public02() {
        this.reportInvalidJavadocVisibility = "public";
        this.runConformTest(new String[]{"comment6/Invalid.java", "package comment6;\npublic class Invalid {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Inner} \n */\nclass Sub1 extends Invalid { }\n"});
    }

    public void testBug96237_Public03() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"comment6a/def/Test.java", "package comment6a.def;\npublic class Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6a/test/Invalid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * See also {@link Inner}\n */\npublic class Invalid extends Test { \n}", "comment6a/test/Invalid2.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see Test.Inner\n */\npublic class Invalid2 extends Test { \n}", "comment6a/test/Valid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see comment6a.def.Test.Inner\n */\npublic class Valid extends Test { \n}"}, "----------\n1. ERROR in comment6a\\test\\Invalid.java (at line 4)\n\t* See also {@link Inner}\n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in comment6a\\test\\Invalid2.java (at line 4)\n\t* @see Test.Inner\n\t       ^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Public04() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"comment6b/Invalid.java", "package comment6b;\n\n/**\n * @see Inner\n */\npublic class Invalid implements Test { \n}", "comment6b/Test.java", "package comment6b;\npublic interface Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6b/Valid.java", "package comment6b;\n\n/**\n * @see Test.Inner\n */\npublic class Valid implements Test { \n}"}, "----------\n1. ERROR in comment6b\\Invalid.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Public05() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/a/Test.java", "package test.a;\n/**\n * @see Inner\n * @see Test.Inner\n */\npublic class Test {\n\tclass Inner {}\n}\n"}, "----------\n1. ERROR in test\\a\\Test.java (at line 3)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\a\\Test.java (at line 4)\n\t* @see Test.Inner\n\t       ^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Public06() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/b/Test.java", "package test.b;\n/** \n * @see Inner.Level2\n * @see Test.Inner.Level2\n */\npublic class Test {\n\t/** \n\t * @see Level2\n\t * @see Test.Inner.Level2\n\t */\n\tpublic class Inner {\n\t\tclass Level2 {}\n\t}\n}\n"}, "----------\n1. ERROR in test\\b\\Test.java (at line 3)\n\t* @see Inner.Level2\n\t       ^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\b\\Test.java (at line 4)\n\t* @see Test.Inner.Level2\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n3. ERROR in test\\b\\Test.java (at line 8)\n\t* @see Level2\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n4. ERROR in test\\b\\Test.java (at line 9)\n\t* @see Test.Inner.Level2\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Public07() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/c/Test.java", "package test.c;\n/**\n * @see Inner.Level2.Level3\n * @see Test.Inner.Level2.Level3\n */\npublic class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * @see Level3\n\t\t * @see Level2.Level3\n\t\t * @see Inner.Level2.Level3\n\t\t * @see Test.Inner.Level2.Level3\n\t\t */\n\t\tpublic class Level2 {\n\t\t\tclass Level3 {\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in test\\c\\Test.java (at line 3)\n\t* @see Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\c\\Test.java (at line 4)\n\t* @see Test.Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n3. ERROR in test\\c\\Test.java (at line 9)\n\t* @see Level3\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n4. ERROR in test\\c\\Test.java (at line 10)\n\t* @see Level2.Level3\n\t       ^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n5. ERROR in test\\c\\Test.java (at line 11)\n\t* @see Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n6. ERROR in test\\c\\Test.java (at line 12)\n\t* @see Test.Inner.Level2.Level3\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Public08() {
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"test/d/Reference.java", "package test.d;\nclass Reference {\n}\n", "test/d/Test.java", "package test.d;\n/**\n * @see Secondary\n * @see Reference\n */\npublic class Test {\n}\nclass Secondary {}"}, "----------\n1. ERROR in test\\d\\Test.java (at line 3)\n\t* @see Secondary\n\t       ^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n2. ERROR in test\\d\\Test.java (at line 4)\n\t* @see Reference\n\t       ^^^^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Private01() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"comment6/Valid.java", "package comment6;\npublic class Valid {\n    /**\n     * @see Valid.Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Valid.Inner}\n */\nclass Sub2 extends Valid { }"});
    }

    public void testBug96237_Private02() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6/Invalid.java", "package comment6;\npublic class Invalid {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n/**\n * See also {@link Inner} \n */\nclass Sub1 extends Invalid { }\n"}, "----------\n1. ERROR in comment6\\Invalid.java (at line 9)\n\t* See also {@link Inner} \n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Private03() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6a/def/Test.java", "package comment6a.def;\npublic class Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6a/test/Invalid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * See also {@link Inner}\n */\npublic class Invalid extends Test { \n}", "comment6a/test/Invalid2.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see Test.Inner\n */\npublic class Invalid2 extends Test { \n}", "comment6a/test/Valid.java", "package comment6a.test;\nimport comment6a.def.Test;\n/**\n * @see comment6a.def.Test.Inner\n */\npublic class Valid extends Test { \n}"}, "----------\n1. ERROR in comment6a\\test\\Invalid.java (at line 4)\n\t* See also {@link Inner}\n\t                  ^^^^^\nJavadoc: Invalid member type qualification\n----------\n----------\n1. ERROR in comment6a\\test\\Invalid2.java (at line 4)\n\t* @see Test.Inner\n\t       ^^^^^^^^^^\nJavadoc: Invalid member type qualification\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Private04() {
        this.reportInvalidJavadocVisibility = "private";
        this.runNegativeTest(new String[]{"comment6b/Invalid.java", "package comment6b;\n\n/**\n * @see Inner\n */\npublic class Invalid implements Test { \n}", "comment6b/Test.java", "package comment6b;\npublic interface Test {\n    /**\n     * @see Inner\n     */\n    public class Inner { }\n}\n", "comment6b/Valid.java", "package comment6b;\n\n/**\n * @see Test.Inner\n */\npublic class Valid implements Test { \n}"}, "----------\n1. ERROR in comment6b\\Invalid.java (at line 4)\n\t* @see Inner\n\t       ^^^^^\nJavadoc: Invalid member type qualification\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug96237_Private05() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/a/Test.java", "package test.a;\n/**\n * @see Inner\n * @see Test.Inner\n */\npublic class Test {\n\tclass Inner {}\n}\n"});
    }

    public void testBug96237_Private06() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/b/Test.java", "package test.b;\n/** \n * @see Inner.Level2\n * @see Test.Inner.Level2\n */\npublic class Test {\n\t/** \n\t * @see Level2\n\t * @see Test.Inner.Level2\n\t */\n\tpublic class Inner {\n\t\tclass Level2 {}\n\t}\n}\n"});
    }

    public void testBug96237_Private07() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/c/Test.java", "package test.c;\n/**\n * @see Inner.Level2.Level3\n * @see Test.Inner.Level2.Level3\n */\npublic class Test {\n\tpublic class Inner {\n\t\t/**\n\t\t * @see Level3\n\t\t * @see Level2.Level3\n\t\t * @see Inner.Level2.Level3\n\t\t * @see Test.Inner.Level2.Level3\n\t\t */\n\t\tpublic class Level2 {\n\t\t\tclass Level3 {\n\t\t\t}\n\t\t}\n\t}\n}\n"});
    }

    public void testBug96237_Private08() {
        this.reportInvalidJavadocVisibility = "private";
        this.runConformTest(new String[]{"test/d/Reference.java", "package test.d;\nclass Reference {\n}\n", "test/d/Test.java", "package test.d;\n/**\n * @see Secondary\n * @see Reference\n */\npublic class Test {\n}\nclass Secondary {}"});
    }

    public void testBug101283a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, F> {\n\n\t/**\n\t * @param <T>  \n\t * @param <F>\n\t */\n\tstatic class Entry<L, R> {\n\t\t// empty\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T>  \n\t          ^\nJavadoc: Parameter T is not declared\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <F>\n\t          ^\nJavadoc: Parameter F is not declared\n----------\n3. ERROR in X.java (at line 7)\n\tstatic class Entry<L, R> {\n\t                   ^\nJavadoc: Missing tag for parameter L\n----------\n4. ERROR in X.java (at line 7)\n\tstatic class Entry<L, R> {\n\t                      ^\nJavadoc: Missing tag for parameter R\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug101283b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, F> {\n\n\t/**\n\t * @see T Variable \n\t * @see F Variable\n\t */\n\tstatic class Entry<L, R> {\n\t\t// empty\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see T Variable \n\t       ^\nJavadoc: Invalid reference\n----------\n2. ERROR in X.java (at line 5)\n\t* @see F Variable\n\t       ^\nJavadoc: Invalid reference\n----------\n3. ERROR in X.java (at line 7)\n\tstatic class Entry<L, R> {\n\t                   ^\nJavadoc: Missing tag for parameter L\n----------\n4. ERROR in X.java (at line 7)\n\tstatic class Entry<L, R> {\n\t                      ^\nJavadoc: Missing tag for parameter R\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug101283c() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, F> {\n\n\t/**\n\t * @param <T>  \n\t * @param <F>\n\t */\n\tclass Entry<L, R> {\n\t\t// empty\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param <T>  \n\t          ^\nJavadoc: Parameter T is not declared\n----------\n2. ERROR in X.java (at line 5)\n\t* @param <F>\n\t          ^\nJavadoc: Parameter F is not declared\n----------\n3. ERROR in X.java (at line 7)\n\tclass Entry<L, R> {\n\t            ^\nJavadoc: Missing tag for parameter L\n----------\n4. ERROR in X.java (at line 7)\n\tclass Entry<L, R> {\n\t               ^\nJavadoc: Missing tag for parameter R\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug101283d() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T, F> {\n\n\t/**\n\t * @see T Variable \n\t * @see F Variable\n\t */\n\tclass Entry<L, R> {\n\t\t// empty\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see T Variable \n\t       ^\nJavadoc: Invalid reference\n----------\n2. ERROR in X.java (at line 5)\n\t* @see F Variable\n\t       ^\nJavadoc: Invalid reference\n----------\n3. ERROR in X.java (at line 7)\n\tclass Entry<L, R> {\n\t            ^\nJavadoc: Missing tag for parameter L\n----------\n4. ERROR in X.java (at line 7)\n\tclass Entry<L, R> {\n\t               ^\nJavadoc: Missing tag for parameter R\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug101283e() {
        this.reportMissingJavadocTags = "disabled";
        this.runNegativeTest(new String[]{"Test.java", "public interface Test<V, R extends Component<?>, C extends\nTest<V, R, C>> extends Control<SelectModel<V>, C>\n{\n\tpublic interface ValueRepresentationStrategy<VV, RR extends Component<?>> extends ComponentFactory<VV, RR>\n\t{\n\t\t/**This value must be equal to the ID of the component returned by the {@link\n\t\tComponentFactory#createComponent(V)} method.*/\n\t\tpublic String getID(final VV value);\n\t}\n}\nclass Component<T> {}\ninterface Control<U, V> {}\nclass SelectModel<V> {}\ninterface ComponentFactory <U, V> {\n\tpublic void createComponent(V v);\n}\n"}, "----------\n1. ERROR in Test.java (at line 7)\n\tComponentFactory#createComponent(V)} method.*/\n\t                                 ^\nJavadoc: Cannot make a static reference to the non-static type variable V\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug101283f() {
        this.reportMissingJavadocTags = "disabled";
        this.runConformTest(new String[]{"Test.java", "public interface Test<V, R extends Component<?>, C extends\nTest<V, R, C>> extends Control<SelectModel<V>, C>\n{\n\tpublic interface ValueRepresentationStrategy<VV, RR extends Component<?>> extends ComponentFactory<VV, RR>\n\t{\n\t\t/**This value must be equal to the ID of the component returned by the {@link\n\t\tComponentFactory#createComponent(Object)} method.*/\n\t\tpublic String getID(final VV value);\n\t}\n}\nclass Component<T> {}\ninterface Control<U, V> {}\nclass SelectModel<V> {}\ninterface ComponentFactory <U, V> {\n\tpublic void createComponent(V v);\n}\n"});
    }

    public void testBug101283g() {
        this.reportMissingJavadocTags = "disabled";
        this.runConformTest(new String[]{"test/X.java", "package test;\npublic class X {\n\tint foo() { return 0; }\n\tclass XX extends X2 {\n\t\tint bar() {\n\t\t\treturn foo();\n\t\t}\n\t}\n}\nclass X2 {\n\tint foo() {\n\t\treturn 0;\n\t}\n}\n", "test/Y.java", "package test;\npublic class Y {\n\tint foo;\n\tclass YY extends Y2 {\n\t/**\n\t *  @see #foo\n\t */\n\t\tint bar() {\n\t\t\treturn foo;\n\t\t}\n\t}\n}\nclass Y2 {\n\tint foo;\n}\n"});
    }

    public void testBug112346() {
        this.reportMissingJavadocTags = "ignore";
        this.runConformTest(new String[]{"Test.java", "/**\n * Test references\n * @see Test#field\n * @see Test#foo()\n */\npublic class Test<T> {\n\tT field;\n\tT foo() { return null; }\n}\n"});
    }

    public void testBug119857() {
        this.runConformTest(new String[]{"DefaultInformationControl.java", "public class DefaultInformationControl {\n\tpublic interface IInformationPresenter {\n\t\t/**\n\t\t * Updates the given presentation of the given information and\n\t\t * thereby may manipulate the information to be displayed. The manipulation\n\t\t * could be the extraction of textual encoded style information etc. Returns the\n\t\t * manipulated information.\n\t\t *\n\t\t * @param hoverInfo the information to be presented\n\t\t * @param maxWidth the maximal width in pixels\n\t\t * @param maxHeight the maximal height in pixels\n\t\t *\n\t\t * @return the manipulated information\n\t\t * @deprecated As of 3.2, replaced by {@link IInformationPresenterExtension#updatePresentation(String, int, int)}\n\t\t * \t\t\t\tsee bug https://bugs.eclipse.org/bugs/show_bug.cgi?id=38528 for details.\n\t\t */\n\t\tString updatePresentation(String hoverInfo, int maxWidth, int maxHeight);\n\t}\n\t/**\n\t * An information presenter determines the style presentation\n\t * of information displayed in the default information control.\n\t * The interface can be implemented by clients.\n\t * \n\t * @since 3.2\n\t */\n\tpublic interface IInformationPresenterExtension {\n\t\t\n\t\t/**\n\t\t * Updates the given presentation of the given information and\n\t\t * thereby may manipulate the information to be displayed. The manipulation\n\t\t * could be the extraction of textual encoded style information etc. Returns the\n\t\t * manipulated information.\n\t\t * <p>\n\t\t * Replaces {@link IInformationPresenter#updatePresentation(String, int, int)}\n\t\t * <em>Make sure that you do not pass in a <code>Display</code></em> until\n\t\t * https://bugs.eclipse.org/bugs/show_bug.cgi?id=38528 is fixed.\n\t\t * </p>\n\t\t *\n\t\t * @param hoverInfo the information to be presented\n\t\t * @param maxWidth the maximal width in pixels\n\t\t * @param maxHeight the maximal height in pixels\n\t\t *\n\t\t * @return the manipulated information\n\t\t */\n\t\tString updatePresentation(String hoverInfo, int maxWidth, int maxHeight);\n\t}\n}\n"});
    }

    public void testBug119857_Fields() {
        this.runConformTest(new String[]{"TestFields.java", "/**\n * @see MyInnerClass#foo\n */\npublic class TestFields {\n    /**\n     * @see MyInnerClass#foo\n     */\n    public class MyInnerClass {\n            Object foo;\n    }\n}"});
    }

    public void testBug119857_Methods() {
        this.runConformTest(new String[]{"TestMethods.java", "/**\n * @see MyInnerClass#foo()\n * @see MyInnerInterface#foo()\n */\npublic class TestMethods {\n    /**\n     * @see MyInnerInterface#foo()\n     */\n    public class MyInnerClass {\n            public void foo() {}\n    }\n    /**\n     * @see MyInnerClass#foo()\n     */\n    public interface MyInnerInterface {\n            public void foo();\n    }\n}"});
    }

    public void testBug119857_Types() {
        this.runConformTest(new String[]{"TestTypes.java", "/**\n * @see MyInnerClass\n * @see MyInnerInterface\n */\npublic class TestTypes {\n\t/**\n\t * @see MyInnerInterface\n\t */\n\tpublic class MyInnerClass {\n\t        public void foo() {}\n\t}\n\t/**\n\t * @see MyInnerClass\n\t */\n\tpublic interface MyInnerInterface {\n\t        public void foo();\n\t}\n}"});
    }

    public void testBug119857_Private01() {
        this.reportMissingJavadocTags = "ignore";
        this.runConformTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic Inner field;\n\t/** \n\t * @see Inner#foo()\n\t */\n\tpublic Object foo() {\n\t\treturn field.foo();\n\t}\n}\n"});
    }

    public void testBug119857_Public01() {
        this.reportMissingJavadocTags = "disabled";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic Inner field;\n\t/** \n\t * @see Inner#foo()\n\t */\n\tpublic Object foo() {\n\t\treturn field.foo();\n\t}\n}\n"}, "----------\n1. ERROR in pack\\Test.java (at line 8)\r\n\t* @see Inner#foo()\r\n\t       ^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug119857_Private02() {
        this.reportMissingJavadocTags = "ignore";
        this.runConformTest(new String[]{"test/Test.java", "package test;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tstatic class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"});
    }

    public void testBug119857_Public02() {
        this.reportMissingJavadocTags = "ignore";
        this.reportInvalidJavadocVisibility = "public";
        this.runConformTest(new String[]{"test/Test.java", "package test;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tstatic class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"});
    }

    public void testBug119857_Public03() {
        this.reportMissingJavadocTags = "ignore";
        this.reportInvalidJavadocVisibility = "public";
        this.runNegativeTest(new String[]{"pack/Test.java", "package pack;\npublic class Test {\n\tstatic class Inner1 {\n\t\tpublic Object foo() { return null; }\n\t}\n\tpublic static class Inner2 {\n\t\tpublic Inner1 field;\n\t\t/** \n\t\t * @see Inner1#foo()\n\t\t */\n\t\tpublic Object foo() {\n\t\t\treturn field.foo();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in pack\\Test.java (at line 9)\n\t* @see Inner1#foo()\n\t       ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'default' reference\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug132430() {
        this.runConformTest(new String[]{"A.java", "public class A<E> {\n    /**\n     * @param object\n     */\n    public void aMethod(E object) {}\n}", "B.java", "public class B<E> extends A<E> {\n\t/**\n\t * @see A#aMethod(java.lang.Object)\n\t */\n\t@Override\n\tpublic void aMethod(E object) {\n\t\tsuper.aMethod(object);\n\t}\n}\n"});
    }

    public void testBug132430b() {
        this.runConformTest(new String[]{"A.java", "public class A<E> {\n    /**\n     * @param object\n     */\n    public void aMethod(E object) {}\n}", "B.java", "public class B<E> extends A<E> {\n\t/**\n\t * @see A#aMethod(java.lang.Object)\n\t */\n\tpublic void aMethod(E object) {\n\t\tsuper.aMethod(object);\n\t}\n}\n"});
    }

    public void testBug132430c() {
        this.runConformTest(new String[]{"A.java", "public class A<E> {\n    /**\n     * @param object\n     */\n    public void aMethod(E object) {}\n}", "B.java", "public class B<E> extends A<E> {\n\t/**\n\t * Empty comment\n\t */\n\t@Override\n\tpublic void aMethod(E object) {\n\t\tsuper.aMethod(object);\n\t}\n}\n"});
    }

    public void testBug145007() {
        this.runConformTest(new String[]{"TestClass.java", "class TestClass<T> {\n    static class Test1 {\n        /**\n         * A simple method that demonstrates tag problems\n         * \n         * @return a string\n         * @throws MyException\n         *             if something goes wrong\n         */\n        public String getString() throws MyException {\n            throw new MyException();\n        }\n    }\n    static class MyException extends Exception {\n        private static final long serialVersionUID = 1L;\n    }\n}"});
    }

    public void testBug87500a() {
        this.reportMissingJavadocComments = "error";
        this.reportMissingJavadocCommentsVisibility = "default";
        this.runNegativeTest(new String[]{"A.java", "enum A {\n\tclubs,\n\tdiamonds,\n\thearts,\n\tspades\n}\n"}, "----------\n1. ERROR in A.java (at line 1)\n\tenum A {\n\t     ^\nJavadoc: Missing comment for default declaration\n----------\n2. ERROR in A.java (at line 2)\n\tclubs,\n\t^^^^^\nJavadoc: Missing comment for default declaration\n----------\n3. ERROR in A.java (at line 3)\n\tdiamonds,\n\t^^^^^^^^\nJavadoc: Missing comment for default declaration\n----------\n4. ERROR in A.java (at line 4)\n\thearts,\n\t^^^^^^\nJavadoc: Missing comment for default declaration\n----------\n5. ERROR in A.java (at line 5)\n\tspades\n\t^^^^^^\nJavadoc: Missing comment for default declaration\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug87500b() {
        this.reportMissingJavadocComments = "ignore";
        this.runConformTest(new String[]{"A.java", "enum A {\n\tclubs,\n\tdiamonds,\n\thearts,\n\tspades\n}\n"});
    }

    public void testBug204749a() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocComments = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    /** @see T.R */\n    void foo() {}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\t/** @see T.R */\n\t         ^^^\nJavadoc: Invalid reference\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug204749b() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocComments = "ignore";
        this.reportInvalidJavadoc = "ignore";
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    /** @see T.R */\n    void foo() {}\n}"});
    }

    public void testBug209936a() {
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic abstract class X extends Y {\n\tprotected class A extends Member {\n\t\t/**\n\t\t * @see Member#foo(Object, Object)\n\t\t */\n\t\tpublic void foo(Object source, Object data) {}\n\t}\n}", "p/Y.java", "package p;\nimport p1.Z;\npublic abstract class Y extends Z<Object> {\n}", "p1/Z.java", "package p1;\npublic abstract class Z<T> {\n\tprotected class Member {\n\t\tprotected void foo(Object source, Object data) {\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\t* @see Member#foo(Object, Object)\n\t       ^^^^^^\nJavadoc: Invalid member type qualification\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936b() {
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic abstract class X extends Y {\n\tprotected class A extends Member {\n\t\t/**\n\t\t * @see Member#foo(Object, Object)\n\t\t */\n\t\tpublic void foo(Object source, Object data) {}\n\t}\n}", "p/Y.java", "package p;\n\nimport p1.Z;\npublic abstract class Y extends Z<Object> {}", "p1/Z.java", "package p1;\npublic abstract class Z<T> {\n\tprotected class Member {\n\t\tprotected void foo(Object source, Object data) {}\n\t}\n}"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\t* @see Member#foo(Object, Object)\n\t       ^^^^^^\nJavadoc: Invalid member type qualification\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_GenericMemberImplicitReference() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2<T> {\n\t\t\tpublic class A3<U> {\n\t\t\t\tpublic class A4<V> {\n\t\t\t\t\tpublic void foo(V v) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2<T> extends A2<T> {\n\t\t\tpublic class X3<U> extends A3<U> {\n\t\t\t\tpublic class X4<V> extends A4<V> {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see #foo(Object)\n\t\t\t \t\t * @see #foo(V)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(V v) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 10)\n\t* @see #foo(V)\n\t        ^^^\nJavadoc: The method foo(Object) in the type X.X1.X2.X3.X4 is not applicable for the arguments (V)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_GenericMemberSingleReference() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2<T> {\n\t\t\tpublic class A3<U> {\n\t\t\t\tpublic class A4<V> {\n\t\t\t\t\tpublic void foo(V v) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2<T> extends A2<T> {\n\t\t\tpublic class X3<U> extends A3<U> {\n\t\t\t\tpublic class X4<V> extends A4<V> {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see A4#foo(V)\n\t\t\t \t\t * @see A4#foo(Object)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void myFoo(V v) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 9)\n\t* @see A4#foo(V)\n\t          ^^^\nJavadoc: The method foo(Object) in the type A.A1.A2.A3.A4 is not applicable for the arguments (V)\n----------\n2. ERROR in p2\\X.java (at line 10)\n\t* @see A4#foo(Object)\n\t       ^^\nJavadoc: Invalid member type qualification\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_GenericMemberQualifiedSingleReference() {
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2<T> {\n\t\t\tpublic class A3<U> {\n\t\t\t\tpublic class A4<V> {\n\t\t\t\t\tpublic void foo(V v) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2<T> extends A2<T> {\n\t\t\tpublic class X3<U> extends A3<U> {\n\t\t\t\tpublic class X4<V> extends A4<V> {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see A3.A4#foo(V)\n\t\t\t \t\t * @see p1.A.A1.A2.A3.A4#foo(Object)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(V v) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 9)\n\t* @see A3.A4#foo(V)\n\t             ^^^\nJavadoc: The method foo(Object) in the type A.A1.A2.A3.A4 is not applicable for the arguments (V)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_GenericMemberFullyQualifiedSingleReference() {
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2<T> {\n\t\t\tpublic class A3<U> {\n\t\t\t\tpublic class A4<V> {\n\t\t\t\t\tpublic void foo(V v) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2<T> extends A2<T> {\n\t\t\tpublic class X3<U> extends A3<U> {\n\t\t\t\tpublic class X4<V> extends A4<V> {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see p1.A.A1.A2.A3.A4#foo(V)\n\t\t\t \t\t * @see p1.A.A1.A2.A3.A4#foo(Object)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(V v) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 9)\n\t* @see p1.A.A1.A2.A3.A4#foo(V)\n\t                        ^^^\nJavadoc: The method foo(Object) in the type A.A1.A2.A3.A4 is not applicable for the arguments (V)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_MemberImplicitReference() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2<T> {\n\t\t\tpublic class A3<U> {\n\t\t\t\tpublic class A4 {\n\t\t\t\t\tpublic void foo(U u) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2<T> extends A2<T> {\n\t\t\tpublic class X3<U> extends A3<U> {\n\t\t\t\tpublic class X4 extends A4 {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see #foo(Object)\n\t\t\t \t\t * @see #foo(U u)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(U u) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 10)\r\n\t* @see #foo(U u)\r\n\t        ^^^\nJavadoc: The method foo(Object) in the type X.X1.X2.X3.X4 is not applicable for the arguments (U)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_MemberSingleReference1() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2<T> {\n\t\t\tpublic class A3 {\n\t\t\t\tpublic class A4 {\n\t\t\t\t\tpublic void foo(T t) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2<T> extends A2<T> {\n\t\t\tpublic class X3 extends A3 {\n\t\t\t\tpublic class X4 extends A4 {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see A4#foo(Object)\n\t\t\t \t\t * @see A4#foo(T)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(T t) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 9)\n\t* @see A4#foo(Object)\n\t       ^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in p2\\X.java (at line 10)\n\t* @see A4#foo(T)\n\t          ^^^\nJavadoc: The method foo(Object) in the type A.A1.A2.A3.A4 is not applicable for the arguments (T)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_MemberSingleReference2() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2 {\n\t\t\tpublic class A3 {\n\t\t\t\tpublic class A4 {\n\t\t\t\t\tpublic void foo(S s) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2 extends A2 {\n\t\t\tpublic class X3 extends A3 {\n\t\t\t\tpublic class X4 extends A4 {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see A4#foo(Object)\n\t\t\t \t\t * @see A4#foo(S)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(S s) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 9)\n\t* @see A4#foo(Object)\n\t       ^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in p2\\X.java (at line 10)\n\t* @see A4#foo(S)\n\t          ^^^\nJavadoc: The method foo(Object) in the type A.A1.A2.A3.A4 is not applicable for the arguments (S)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_MemberSingleReference3() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tpublic class A1 {\n\t\tpublic class A2<T> {\n\t\t\tpublic class A3 {\n\t\t\t\tpublic class A4 {\n\t\t\t\t\tpublic void foo(T t) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X extends A {\n\tpublic class X1 extends A1 {\n\t\tpublic class X2<T> extends A2<T> {\n\t\t\tpublic class X3 extends A3 {\n\t\t\t\tpublic class X4 extends A4 {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see A4#foo(Object)\n\t\t\t \t\t * @see A4#foo(T)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(T t) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 9)\n\t* @see A4#foo(Object)\n\t       ^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in p2\\X.java (at line 10)\n\t* @see A4#foo(T)\n\t          ^^^\nJavadoc: The method foo(Object) in the type A.A1.A2.A3.A4 is not applicable for the arguments (T)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_MemberSingleReference4() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tpublic class A1 {\n\t\tpublic class A2<T> {\n\t\t\tpublic class A3 {\n\t\t\t\tpublic class A4 {\n\t\t\t\t\tpublic void foo(T t) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X extends A {\n\tpublic class X1 extends A1 {\n\t\tpublic class X2<T> extends A2<T> {\n\t\t\tpublic class X3 extends A3 {\n\t\t\t\tpublic class X4 extends A4 {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see A4#foo(Object)\n\t\t\t \t\t * @see A4#foo(T)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(T t) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 9)\n\t* @see A4#foo(Object)\n\t       ^^\nJavadoc: Invalid member type qualification\n----------\n2. ERROR in p2\\X.java (at line 10)\n\t* @see A4#foo(T)\n\t          ^^^\nJavadoc: The method foo(Object) in the type A.A1.A2.A3.A4 is not applicable for the arguments (T)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug209936_MemberQualifiedSingleReference1() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runConformTest(new String[]{"p1/A.java", "package p1;\n\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2 {\n\t\t\tpublic class A3 {\n\t\t\t\tpublic class A4 {\n\t\t\t\t\tpublic void foo(S s) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2 extends A2 {\n\t\t\tpublic class X3 extends A3 {\n\t\t\t\tpublic class X4 extends A4 {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see p1.A.A1.A2.A3.A4#foo(Object)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(S s) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"});
    }

    public void testBug209936_MemberQualifiedSingleReference2() {
        this.reportMissingJavadocTags = "ignore";
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runConformTest(new String[]{"p1/A.java", "package p1;\n\npublic class A<R> {\n\tpublic class A1<S> {\n\t\tpublic class A2 {\n\t\t\tpublic class A3 {\n\t\t\t\tpublic class A4 {\n\t\t\t\t\tpublic class A5 {\n\t\t\t\t\t\tpublic class A6 {\n\t\t\t\t\t\t\tpublic void foo(S s) {}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1<S> extends A1<S> {\n\t\tpublic class X2 extends A2 {\n\t\t\tpublic class X3 extends A3 {\n\t\t\t\tpublic class X4 extends A4 {\n\t\t\t\t\tpublic class X5 extends A5 {\n\t\t\t\t\t\tpublic class X6 extends A6 {\n\t\t\t\t\t\t\t/**\n\t\t\t \t\t\t\t * @see p1.A.A1.A2.A3.A4.A5.A6#foo(Object)\n\t\t\t\t\t\t\t */\n\t\t\t\t\t\t\tpublic void foo(S s) {}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"});
    }

    public void testBug209936_MemberFullyQualifiedSingleReference() {
        this.reportMissingJavadocCommentsVisibility = "warning";
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\n\npublic class A<R> {\n\tpublic class A1 {\n\t\tpublic class A2 {\n\t\t\tpublic class A3 {\n\t\t\t\tpublic class A4 {\n\t\t\t\t\tpublic void foo(R r) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}", "p2/X.java", "package p2;\nimport p1.A;\npublic class X<R> extends A<R> {\n\tpublic class X1 extends A1 {\n\t\tpublic class X2 extends A2 {\n\t\t\tpublic class X3 extends A3 {\n\t\t\t\tpublic class X4 extends A4 {\n\t\t\t\t\t/**\n\t\t\t \t\t * @see p1.A.A1.A2.A3.A4#foo(Object)\n\t\t\t \t\t * @see p1.A.A1.A2.A3.A4#foo(R)\n\t\t\t\t\t */\n\t\t\t\t\tpublic void foo(R r) {}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in p2\\X.java (at line 10)\r\n\t* @see p1.A.A1.A2.A3.A4#foo(R)\r\n\t                        ^^^\nJavadoc: The method foo(Object) in the type A.A1.A2.A3.A4 is not applicable for the arguments (R)\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug247037a() {
        this.runNegativeTest(new String[]{"pack/package-info.java", "/**\n * {@inheritDoc}\n * @since {@inheritDoc}\n * @blah {@inheritDoc}\n */\npackage pack;\n"}, "----------\n1. ERROR in pack\\package-info.java (at line 2)\n\t* {@inheritDoc}\n\t    ^^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in pack\\package-info.java (at line 3)\n\t* @since {@inheritDoc}\n\t           ^^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in pack\\package-info.java (at line 4)\n\t* @blah {@inheritDoc}\n\t          ^^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void testBug247037b() {
        this.runNegativeTest(new String[]{"pack/package-info.java", "/**\n * @return {@inheritDoc}\n * @param blah {@inheritDoc}\n */\npackage pack;\n"}, "----------\n1. ERROR in pack\\package-info.java (at line 2)\n\t* @return {@inheritDoc}\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in pack\\package-info.java (at line 2)\n\t* @return {@inheritDoc}\n\t            ^^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in pack\\package-info.java (at line 3)\n\t* @param blah {@inheritDoc}\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in pack\\package-info.java (at line 3)\n\t* @param blah {@inheritDoc}\n\t                ^^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void testBug284333() {
        this.runNegativeTest(new String[]{"goo/bar/package-info.java", "/**\n*/\npackage goo.bar;\n", "foo/bar/ClassInSamePackage.java", "package foo.bar;\npublic class ClassInSamePackage {\n\tpublic static int SOME_FIELD; \n}\n", "foo/bar/goo/ClassInSubPackage.java", "package foo.bar.goo;\npublic class ClassInSubPackage {\n\tpublic static void foo() { \n   }\n}\n", "foo/ClassInEnclosingPackage.java", "package foo;\npublic class ClassInEnclosingPackage {\n\tpublic static int SOME_FIELD; \n}\n", "foo/bar/package-info.java", "/**\n * @see ClassInSamePackage#SOME_FIELD\n * @see foo.bar.ClassInSamePackage#SOME_FIELD\n * @see ClassInSamePackage#SOME_FIELD\n * @see ClassInSubPackage#foo\n * @see foo.bar.goo.ClassInSubPackage#foo\n * @see ClassInSubPackage#foo\n * @see ClassInEnclosingPackage\n * @see foo.ClassInEnclosingPackage\n * @see ClassInEnclosingPackage\n * @see foo.bar\n * @see goo.bar\n * @see foo.bar.goo\n */\npackage foo.bar;\n"}, "----------\n1. ERROR in foo\\bar\\package-info.java (at line 2)\n\t* @see ClassInSamePackage#SOME_FIELD\n\t       ^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid reference\n----------\n2. ERROR in foo\\bar\\package-info.java (at line 4)\n\t* @see ClassInSamePackage#SOME_FIELD\n\t       ^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid reference\n----------\n3. ERROR in foo\\bar\\package-info.java (at line 5)\n\t* @see ClassInSubPackage#foo\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: ClassInSubPackage cannot be resolved to a type\n----------\n4. ERROR in foo\\bar\\package-info.java (at line 7)\n\t* @see ClassInSubPackage#foo\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: ClassInSubPackage cannot be resolved to a type\n----------\n5. ERROR in foo\\bar\\package-info.java (at line 8)\n\t* @see ClassInEnclosingPackage\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: ClassInEnclosingPackage cannot be resolved to a type\n----------\n6. ERROR in foo\\bar\\package-info.java (at line 10)\n\t* @see ClassInEnclosingPackage\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: ClassInEnclosingPackage cannot be resolved to a type\n----------\n");
    }

    public void testBug284333a() {
        this.runNegativeTest(new String[]{"goo/bar/package-info.java", "/**\n*/\npackage goo.bar;\n", "foo/bar/ClassInSamePackage.java", "package foo.bar;\npublic class ClassInSamePackage {\n\tpublic static int SOME_FIELD; \n}\n", "foo/bar/goo/ClassInSubPackage.java", "package foo.bar.goo;\npublic class ClassInSubPackage {\n\tpublic static void foo() { \n   }\n}\n", "foo/ClassInEnclosingPackage.java", "package foo;\npublic class ClassInEnclosingPackage {\n\tpublic static int SOME_FIELD; \n}\n", "foo/bar/NotAPackageInfo.java", "package foo.bar;\n/**\n * @see ClassInSamePackage#SOME_FIELD\n * @see foo.bar.ClassInSamePackage#SOME_FIELD\n * @see ClassInSamePackage#SOME_FIELD\n */\n public class NotAPackageInfo {\n/**\n * @see ClassInSubPackage#foo\n * @see foo.bar.goo.ClassInSubPackage#foo\n * @see ClassInSubPackage#foo\n */\n\tpublic static int SOME_FIELD = 0;\n/**\n * @see ClassInEnclosingPackage\n * @see foo.ClassInEnclosingPackage\n * @see ClassInEnclosingPackage\n */\n \tpublic static void foo() {\n\t}\n\t }\n"}, "----------\n1. ERROR in foo\\bar\\NotAPackageInfo.java (at line 9)\n\t* @see ClassInSubPackage#foo\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: ClassInSubPackage cannot be resolved to a type\n----------\n2. ERROR in foo\\bar\\NotAPackageInfo.java (at line 11)\n\t* @see ClassInSubPackage#foo\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: ClassInSubPackage cannot be resolved to a type\n----------\n3. ERROR in foo\\bar\\NotAPackageInfo.java (at line 15)\n\t* @see ClassInEnclosingPackage\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: ClassInEnclosingPackage cannot be resolved to a type\n----------\n4. ERROR in foo\\bar\\NotAPackageInfo.java (at line 17)\n\t* @see ClassInEnclosingPackage\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: ClassInEnclosingPackage cannot be resolved to a type\n----------\n");
    }

    public void testBug284333b() {
        this.runConformTest(new String[]{"goo/bar/package-info.java", "/**\n*/\npackage goo.bar;\n", "foo/bar/ClassInSamePackage.java", "package foo.bar;\npublic class ClassInSamePackage {\n\tpublic static int SOME_FIELD; \n}\n", "foo/bar/goo/ClassInSubPackage.java", "package foo.bar.goo;\npublic class ClassInSubPackage {\n\tpublic static void foo() { \n   }\n}\n", "foo/ClassInEnclosingPackage.java", "package foo;\npublic class ClassInEnclosingPackage {\n\tpublic static int SOME_FIELD; \n}\n", "foo/bar/NotAPackageInfo.java", "package foo.bar;\nimport foo.*;\nimport foo.bar.goo.*;\n/**\n * @see ClassInSamePackage#SOME_FIELD\n * @see foo.bar.ClassInSamePackage#SOME_FIELD\n * @see ClassInSamePackage#SOME_FIELD\n * @see goo.bar\n */\n public class NotAPackageInfo {\n/**\n * @see ClassInSubPackage#foo\n * @see foo.bar.goo.ClassInSubPackage#foo\n * @see ClassInSubPackage#foo\n * @see goo.bar\n */\n\tpublic static int SOME_FIELD = 0;\n/**\n * @see ClassInEnclosingPackage\n * @see foo.ClassInEnclosingPackage\n * @see ClassInEnclosingPackage\n * @see goo.bar\n */\n \tpublic static void foo() {\n\t}\n\t }\n"});
    }

    public void testBug322581a() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "disabled");
        this.runNegativeTest(true, new String[]{"X.java", " public class X {\n\t/**\n\t * javadoc\n\t */\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                              ^^^\nJavadoc: Missing tag for parameter val\n----------\n2. ERROR in X.java (at line 5)\n\tpublic <T, U, V> void foo(int val, Object obj) {}\n\t                                          ^^^\nJavadoc: Missing tag for parameter obj\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug322581b() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "disabled");
        this.runNegativeTest(true, new String[]{"ListCallable.java", " import java.util.Collections;\n import java.util.List;\n import java.util.concurrent.Callable;\n/**\n * Callable that returns a list.\n */\npublic abstract class ListCallable<V> implements Callable<List<V>> { // good warning\n\tpublic abstract List<V> call() throws Exception;\n    /**\n\t * Returns a {@link ListCallable} that wraps the result from calling <code>callable</code>.\n    * @param callable the {@link Callable} to wrap\n\t * @return the wrapper\n    */\n\tpublic static <T> ListCallable<T> from(final Callable<T> callable) { // don't warn\n\t\treturn new ListCallable<T>() {\n\t\t\t@Override\n\t\t\tpublic List<T> call() throws Exception {\n\t\t\t\treturn Collections.singletonList(callable.call());\n\t\t\t}\n\t\t};\n\t}\n}"}, null, options, "----------\n1. ERROR in ListCallable.java (at line 7)\n\tpublic abstract class ListCallable<V> implements Callable<List<V>> { // good warning\n\t                                   ^\nJavadoc: Missing tag for parameter V\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug331872() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "disabled");
        this.runNegativeTest(true, new String[]{"X.java", "/**\n * @param <p> the given type parameter\n */\npublic class X<p> {\n\t/**\n\t * @param o the given object\n\t * @see #foo(p.O[])\n\t */\n\tpublic void foo(Object o) {\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 7)\n\t* @see #foo(p.O[])\n\t            ^^^\nIllegal qualified access from the type parameter p\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug331872b() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "disabled");
        this.runNegativeTest(true, new String[]{"X.java", "/**\n * @param <p> the given type parameter\n */\npublic class X<p> {\n\t/**\n\t * @param o the given object\n\t * @see #foo(O[])\n\t */\n\tpublic void foo(Object o) {\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 7)\n\t* @see #foo(O[])\n\t            ^\nJavadoc: O[] cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug331872c() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "disabled");
        this.runNegativeTest(true, new String[]{"X.java", "/**\n * @param <p> the given type parameter\n */\npublic class X<p> {\n\t/**\n\t * @param o the given object\n\t * @see #foo(test.O[])\n\t */\n\tpublic void foo(Object o) {\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 7)\n\t* @see #foo(test.O[])\n\t            ^^^^^^\nJavadoc: test[] cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testBug331872d() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", "disabled");
        this.runNegativeTest(true, new String[]{"X.java", "/**\n * @param <p> the given type parameter\n */\npublic class X<p> {\n\t/**\n\t * @param o the given object\n\t * @see #foo(test.O)\n\t */\n\tpublic void foo(Object o) {\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 7)\n\t* @see #foo(test.O)\n\t            ^^^^^^\nJavadoc: test cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }
}

