/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class LambdaExpressionsTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public LambdaExpressionsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LambdaExpressionsTest.buildMinimalComplianceTestSuite(LambdaExpressionsTest.testClass(), 32);
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  int add(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    I i = (x, y) -> {\n      return x + y;\n    };\n    System.out.println(i.add(1234, 5678));\n  }\n}\n"}, "6912");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "interface Greetings {\n  void greet(String head, String tail);\n}\npublic class X {\n  public static void main(String[] args) {\n    Greetings g = (x, y) -> {\n      System.out.println(x + y);\n    };\n    g.greet(\"Hello, \", \"World!\");\n  }\n}\n"}, "Hello, World!");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    BinaryOperator<String> binOp = (x,y) -> { return x+y; };\n    System.out.println(\"SUCCESS\");\n    // System.out.println(binOp.apply(\"SUCC\", \"ESS\")); // when lambdas run\n  }\n}\n", "BiFunction.java", "@FunctionalInterface\npublic interface BiFunction<T, U, R> {\n    R apply(T t, U u);\n}", "BinaryOperator.java", "@FunctionalInterface\npublic interface BinaryOperator<T> extends BiFunction<T,T,T> {\n}"}, "SUCCESS");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    BinaryOperator binOp = (x,y) -> { return x+y; };\n    System.out.println(\"SUCCESS\");\n    // System.out.println(binOp.apply(\"SUCC\", \"ESS\")); // when lambdas run\n  }\n}\n", "BiFunction.java", "@FunctionalInterface\npublic interface BiFunction<T, U, R> {\n    R apply(T t, U u);\n}", "BinaryOperator.java", "@FunctionalInterface\npublic interface BinaryOperator<T> extends BiFunction<T,T,T> {\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tBinaryOperator binOp = (x,y) -> { return x+y; };\n\t^^^^^^^^^^^^^^\nBinaryOperator is a raw type. References to generic type BinaryOperator<T> should be parameterized\n----------\n2. ERROR in X.java (at line 6)\n\tBinaryOperator binOp = (x,y) -> { return x+y; };\n\t                                         ^^^\nThe operator + is undefined for the argument type(s) java.lang.Object, java.lang.Object\n----------\n");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString id(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> s;\n\t\tSystem.out.println(i.id(\"Hello\"));\n\t}\n}\n"}, "Hello");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString id(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> s + s;\n\t\tSystem.out.println(i.id(\"Hello\"));\n\t}\n}\n"}, "HelloHello");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid print(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> System.out.println(s);\n\t\ti.print(\"Hello\");\n\t}\n}\n"}, "Hello");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString print(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> new String(s).toUpperCase();\n\t\tSystem.out.println(i.print(\"Hello\"));\n\t}\n}\n"}, "HELLO");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString print(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> new String(s);\n\t\tSystem.out.println(i.print(\"Hello\"));\n\t}\n}\n"}, "Hello");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint unbox(Integer i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> s;\n\t\tSystem.out.println(i.unbox(new Integer(1234)));\n\t}\n}\n"}, "1234");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tInteger box(int i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> s;\n\t\tSystem.out.println(i.box(1234));\n\t}\n}\n"}, "1234");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX subType();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = () -> new Y();\n\t\tSystem.out.println(i.subType());\n\t}\n}\nclass Y extends X {\n    public String toString() {\n        return \"Some Y\";\n    }\n}"}, "Some Y");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    void foo(String s);\n}\npublic class X {\n    public static void main(String [] args) {\n        int in = 12345678;\n        I i = (s) -> {\n            I j = (s2) -> {\n                System.out.println(s + s2 + in);  \n            };\n            j.foo(\"Number=\");\n        };\n        i.foo(\"The \");\n    }\n}\n"}, "The Number=12345678");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void nonmain(String[] args) {\n    int var = 2;\n    I x2 = () -> {\n      System.out.println(\"Argc = \" + args.length);\n      for (int i = 0; i < args.length; i++) {\n          System.out.println(\"Argv[\" + i + \"] = \" + args[i]);\n      }\n    };\n    x2.doit();\n    var=2;\n  }\n  public static void main(String[] args) {\n      nonmain(new String[] {\"Hello! \", \"World!\" });\n  }\n}"}, "Argc = 2\nArgv[0] = Hello! \nArgv[1] = World!");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    try {\n      new java.io.File((String) null).getCanonicalPath();\n    } catch (NullPointerException | java.io.IOException ioe) {\n      I x2 = () -> {\n        System.out.println(ioe.getMessage()); // OK: args is not re-assignment since declaration/first assignment\n      };\n      x2.doit();\n    };\n  }\n}\n"}, "null");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    java.util.List<String> list = new java.util.ArrayList<>();\n    list.add(\"SomeString\");\n    for (String s : list) {\n      I x2 = () -> {\n        System.out.println(s); // OK: args is not re-assignment since declaration/first assignment\n      };\n      x2.doit();\n    };\n  }\n\n}\n"}, "SomeString");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    BinaryOperator<String> binOp = (x,y) -> { return x+y; }; \n    System.out.println(binOp.apply(\"SUCC\", \"ESS\")); // when lambdas run\n  }\n}\n@FunctionalInterface\ninterface BiFunction<T, U, R> { \n    R apply(T t, U u);\n}\n@FunctionalInterface \ninterface BinaryOperator<T> extends BiFunction<T,T,T> { \n}\n"}, "SUCCESS");
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [][][] copy (short x);\n}\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = X[][][]::new;\n       I j = X[][][]::new;\n\t\tX[][][] x = i.copy((short) 631);\n\t\tSystem.out.println(x.length);\n       x = j.copy((short) 136);\n\t\tSystem.out.println(x.length);\n\t}\n}\n"}, "631\n136");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [][][] copy (int x);\n}\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = X[][][]::new;\n       I j = X[][][]::new;\n\t\tX[][][] x = i.copy(631);\n\t\tSystem.out.println(x.length);\n       x = j.copy(136);\n\t\tSystem.out.println(x.length);\n\t}\n}\n"}, "631\n136");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [][][] copy (Integer x);\n}\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = X[][][]::new;\n       I j = X[][][]::new;\n\t\tX[][][] x = i.copy(631);\n\t\tSystem.out.println(x.length);\n       x = j.copy(136);\n\t\tSystem.out.println(x.length);\n\t}\n}\n"}, "631\n136");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [][][] copy (Integer x);\n}\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = X[][][]::new;\n       I j = X[][][]::new;\n\t\tX[][][] x = i.copy(new Integer(631));\n\t\tSystem.out.println(x.length);\n       x = j.copy(new Integer((short)136));\n\t\tSystem.out.println(x.length);\n\t}\n}\n"}, "631\n136");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object copy(int [] ia);\n}\ninterface J {\n\tint [] copy(int [] ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = int[]::<String>clone;\n        int [] x = new int [] { 10, 20, 30 };\n        int [] y = (int []) i.copy(x);\n        if (x == y || x.length != y.length || x[0] != y[0] || x[1] != y[1] || x[2] != y[2]) {\n        \tSystem.out.println(\"Broken\");\n        } else {\n        \tSystem.out.println(\"OK\");\n        }\n        J j = int []::clone;\n        y = null;\n        y = j.copy(x);\n        if (x == y || x.length != y.length || x[0] != y[0] || x[1] != y[1] || x[2] != y[2]) {\n        \tSystem.out.println(\"Broken\");\n        } else {\n        \tSystem.out.println(\"OK\");\n        }\n    }\n}\n"}, "OK\nOK");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object copy(int [] ia);\n}\n\npublic class X  {\n    public static void main(String [] args) {\n        I i = int[]::<String>clone;\n        int [] ia = (int []) i.copy(new int[10]);\n        System.out.println(ia.length);\n    }\n}\n"}, "10");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    YBase copy(Y ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y::<String>copy;\n        YBase yb = i.copy(new Y());\n        System.out.println(yb.getClass());\n    }\n}\nclass YBase {\n\tpublic YBase copy() {\n\t\treturn this;\n\t}\n}\nclass Y extends YBase {\n}\n"}, "class Y");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    int foo(int [] ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = int[]::<String>hashCode;\n        i.foo(new int[10]);\n    }\n}\n"}, "");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tInteger foo(int x, int y);\n}\nclass Y {\n\tint foo(int x, int y) {\n\t\tSystem.out.println(\"Y.foo(\" + x + \",\" + y + \")\");\n\t\treturn foo(x, y);\n\t}\n}\npublic class X extends Y {\n\tint foo(int x, int y) {\n\t\tSystem.out.println(\"X.foo(\" + x + \",\" + y + \")\");\n\t\treturn x + y;\n\t}\n\tvoid goo() {\n\t\tI i = super::foo;\n\t\tSystem.out.println(i.foo(1234, 4321));\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().goo();\n\t}\n}\n"}, "Y.foo(1234,4321)\nX.foo(1234,4321)\n5555");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo(int x, int y);\n}\ninterface J {\n\tdefault int foo(int x, int y) {\n\t\tSystem.out.println(\"I.foo(\" + x + \",\" + y + \")\");\n\t\treturn x + y;\n\t}\n}\npublic class X implements J {\n\tpublic static void main(String[] args) {\n\t\tI i = new X().f();\n\t\tSystem.out.println(i.foo(1234, 4321));\n\t\ti = new X().g();\n\t\ttry {\n\t\t\tSystem.out.println(i.foo(1234, 4321));\n\t\t} catch (Throwable e) {\n\t\t\tSystem.out.println(e.getMessage());\n\t\t}\n\t}\n\tI f() {\n\t\treturn J.super::foo;\n\t}\n\tI g() {\n\t\treturn new X()::foo;\n\t}\n\tpublic int foo(int x, int y) {\n\t\tthrow new RuntimeException(\"Exception\");\n\t}\n}\n"}, "I.foo(1234,4321)\n5555\nException");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object copy();\n}\npublic class X  {\n    public static void main(String [] args) {\n    \tint [] x = new int[] { 0xdeadbeef, 0xfeedface };\n    \tI i = x::<String>clone;\n       System.out.println(Integer.toHexString(((int []) i.copy())[0]));\n       System.out.println(Integer.toHexString(((int []) i.copy())[1]));\n    }\n}\n"}, "deadbeef\nfeedface");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y.Z makexyz(int val);\n}\npublic class X {\n\tpublic static void main(String args []) {\n\t\tnew X().new Y().new Z().new P().goo();\n\t}\n\tclass Y {\n\t\tclass Z {\n\t\t\tZ(int val) {\n\t\t\t\tSystem.out.println(Integer.toHexString(val));\n\t\t\t}\t\n\t\t\tZ() {\n\t\t\t}\n\t\t\tclass P {\n\t\t\t\tvoid goo() {\n\t\t\t\t\tI i = Z::new;\n\t\t\t\t\ti.makexyz(0xdeadbeef);\n\t\t\t\t}\n\t\t\t\tI i = Z::new;\n\t\t\t\t{ i.makexyz(0xfeedface); }\n\t\t\t}\n\t\t}\n\t\tI i = Z::new;\n\t\t{ i.makexyz(0xbeeffeed); }\n\t}\n}\n"}, "beeffeed\nfeedface\ndeadbeef");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y makeY();\n}\npublic class X {\n\tpublic class Y {\n       public String toString() {\n           return \"class Y\";\n   }\n\t}\n\tvoid foo() {\n\t\tI i = Y::new;\n\t\tSystem.out.println(i.makeY());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "class Y");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y makeY(int x);\n}\npublic class X {\n\tclass Y {\n\t\tString state; \n\t\tY(int x) {\n\t\t\tstate = Integer.toHexString(x);\n\t\t}\n\t\tpublic String toString() {\n\t\t\treturn state;\n\t\t}\n\t}\n\tclass Z extends Y {\n\t\tZ(int x) {\n\t\t\tsuper(x);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().f();\n\t}\n\tvoid f() {\n\t\tI i = Y::new;\n\t\tSystem.out.println(i.makeY(0xdeadbeef));\n\t}\n}\n"}, "deadbeef");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y makeY(int x);\n}\npublic class X {\n\tclass Y {\n\t\tString state; \n\t\tY(int x) {\n\t\t\tstate = Integer.toHexString(x);\n\t\t}\n\t\tpublic String toString() {\n\t\t\treturn state;\n\t\t}\n\t}\n\tclass Z extends Y {\n\t\tZ(int x) {\n\t\t\tsuper(x);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().f();\n\t}\n\tvoid f() {\n\t\tI i = Z::new;\n\t\tSystem.out.println(i.makeY(0xdeadbeef));\n\t}\n}\n"}, "deadbeef");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y.Z makeY(int x);\n}\npublic class X {\n\tclass Y {\n\t\tY() {\n\t\t}\n\t\tclass Z {\n\t\t\tString state;\n\t\t\tZ(int x) {\n\t\t\t\tstate = Integer.toHexString(x);\n\t\t\t}\n\t\t\tpublic String toString() {\n\t\t\t\treturn state;\n\t\t\t}\n\t\t}\n\t}\n\tclass YS extends Y {\n\t\tYS() {\n\t\t}\n\t\tvoid f() {\n\t\t\tI i = Z::new;\n\t\t\tSystem.out.println(i.makeY(0xbeefface));\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new YS().f();\n\t}\n}\n"}, "beefface");
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    int foo();\n}\npublic class X {\n    int f = 1234;\n    void foo() {\n        int x = 4321;\n        I i = () -> x + f;\n        System.out.println(i.foo());\n    }\n    public static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "5555");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n\t\t\tclass Local {\n\t\t\t\tvoid foo() {\n               }\n\t\t\t};\n\t\t\tnew Local();\n\t\t};\n   }\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    String foo(String x, String y);\n}\npublic class X {\n    String xf = \"Lambda \";\n    String x() {\n    \tString xl = \"code \";\n    \tclass Y {\n\t\t\tString yf = \"generation \";\n\t\t\tString y () {\n\t\t\t\tString yl = \"with \";\n\t\t\t\tclass Z {\n\t\t\t\t\tString zf = \"instance \";\n\t\t\t\t\tString z () {\n\t\t\t\t\t\tString zl = \"and \";\n\t\t\t\t\t\tclass P {\n\t\t\t\t\t\t\tString pf = \"local \";\n\t\t\t\t\t\t\tString p () {\n\t\t\t\t\t\t\t\tString pl = \"capture \";\n\t\t\t\t\t\t\t\tI i = (x1, y1) -> {\n\t\t\t\t\t\t\t\t\treturn (((I) ((x2, y2) -> {\n\t\t\t\t\t\t\t\t\t\treturn ( ((I) ((x3, y3) -> {\n\t\t\t\t\t\t\t\t\t\t\treturn xf + xl + yf + yl + zf + zl + pf + pl + x3 + y3;\n\t\t\t\t\t\t\t\t\t\t})).foo(\"works \", \"fine \") + x2 + y2);\n\t\t\t\t\t\t\t\t\t})).foo(\"in \", \"the \") + x1 + y1);\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t\treturn i.foo(\"eclipse \", \"compiler \");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn new P().p();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn new Z().z();\n\t\t\t}\n    \t}\n    \treturn new Y().y();\n    }\n    public static void main(String[] args) {\n\tSystem.out.println(new X().x());\n    }\n}\n"}, "Lambda code generation with instance and local capture works fine in the eclipse compiler");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    String foo(String x, String y);\n}\npublic class X {\n    String xf = \"Lambda \";\n    String x() {\n    \tString xl = \"code \";\n    \tclass Y {\n\t\t\tString yf = \"generation \";\n\t\t\tString y () {\n\t\t\t\tString yl = \"with \";\n\t\t\t\tclass Z {\n\t\t\t\t\tString zf = \"instance \";\n\t\t\t\t\tString z () {\n\t\t\t\t\t\tString zl = \"and \";\n\t\t\t\t\t\tclass P {\n\t\t\t\t\t\t\tString pf = \"local \";\n\t\t\t\t\t\t\tString p () {\n\t\t\t\t\t\t\t\tString pl = \"capture \";\n\t\t\t\t\t\t\t\tI i = (x1, y1) -> {\n\t\t\t\t\t\t\t\t\treturn (((I) ((x2, y2) -> {\n\t\t\t\t\t\t\t\t\t\treturn ( ((I) ((x3, y3) -> {\n                                           String exclaim = \"!\";\n\t\t\t\t\t\t\t\t\t\t\treturn xf + xl + yf + yl + zf + zl + pf + pl + x3 + y3 + x2 + y2 + x1 + y1 + exclaim;\n\t\t\t\t\t\t\t\t\t\t})).foo(\"works \", \"fine \"));\n\t\t\t\t\t\t\t\t\t})).foo(\"in \", \"the \"));\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t\treturn i.foo(\"eclipse \", \"compiler \");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn new P().p();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn new Z().z();\n\t\t\t}\n    \t}\n    \treturn new Y().y();\n    }\n    public static void main(String[] args) {\n\tSystem.out.println(new X().x());\n    }\n}\n"}, "Lambda code generation with instance and local capture works fine in the eclipse compiler !");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\npublic class X implements I, J {\n\tpublic static void main( String [] args) { \n\t\tf(new X());\n\t}\n\tstatic void f(Object o) {\n\t\tX x = (X & I & J) o;\n       System.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\npublic class X implements J {\n\tpublic static void main( String [] args) { \n\t\tf(new X());\n\t}\n\tstatic void f(Object o) {\n       try {\n\t\t    X x = (X & I & J) o;\n       } catch (ClassCastException e) {\n           System.out.println(e.getMessage());\n       }\n\t}\n}\n"}, "X cannot be cast to I");
    }

    public void test041() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tclass Z {\n\t\tvoid f() {\n\t\t\tI i = X::new;\n\t\t\ti.makeX(123456);\n\t\t}\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(x);\n\t}\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Z().f();\n\t}\n}\n"}, "123456");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tclass Y extends X {\n\t\tclass Z {\n\t\t\tvoid f() {\n\t\t\t\tI i = X::new;\n\t\t\t\ti.makeX(123456);\n\t\t\t\ti = Y::new;\n\t\t\t\ti.makeX(987654);\n\t\t\t}\n\t\t}\n\t\tprivate Y(int y) {\n\t\t\tSystem.out.println(\"Y(\" + y + \")\");\n\t\t}\n\t\tprivate Y() {\n\t\t\t\n\t\t}\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(\"X(\" + x + \")\");\n\t}\n\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().new Z().f();\n\t}\n\n}\n"}, "X(123456)\nY(987654)");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tclass Y extends X {\n\t\tclass Z extends X {\n\t\t\tvoid f() {\n\t\t\t\tI i = X::new;\n\t\t\t\ti.makeX(123456);\n\t\t\t\ti = Y::new;\n\t\t\t\ti.makeX(987654);\n               i = Z::new;\n               i.makeX(456789);\n\t\t\t}\n       \tprivate Z(int z) {\n\t\t\t\tSystem.out.println(\"Z(\" + z + \")\");\n\t\t\t}\n           Z() {\n           }\n       }\n\t\tprivate Y(int y) {\n\t\t\tSystem.out.println(\"Y(\" + y + \")\");\n\t\t}\n\t\tprivate Y() {\n\t\t\t\n\t\t}\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(\"X(\" + x + \")\");\n\t}\n\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().new Z().f();\n\t}\n\n}\n"}, "X(123456)\nY(987654)\nZ(456789)");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tvoid foo() {\n\t\tint local;\n\t\tclass Y extends X {\n\t\t\tclass Z extends X {\n\t\t\t\tvoid f() {\n\t\t\t\t\tI i = X::new;\n\t\t\t\t\ti.makeX(123456);\n\t\t\t\t\ti = Y::new;\n\t\t\t\t\ti.makeX(987654);\n\t\t\t\t\ti = Z::new;\n\t\t\t\t\ti.makeX(456789);\n\t\t\t\t}\n\t\t\t\tprivate Z(int z) {\n\t\t\t\t\tSystem.out.println(\"Z(\" + z + \")\");\n\t\t\t\t}\n\t\t\t\tZ() {}\n\t\t\t}\n\t\t\tprivate Y(int y) {\n\t\t\t\tSystem.out.println(\"Y(\" + y + \")\");\n\t\t\t}\n\t\t\tprivate Y() {\n\t\t\t}\n\t\t}\n\t\tnew Y().new Z().f();\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(\"X(\" + x + \")\");\n\t}\n\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "X(123456)\nY(987654)\nZ(456789)");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tI i = (x) -> {\n\t\tclass Y extends X {\n\t\t\tprivate Y (int y) {\n\t\t\t\tSystem.out.println(y);\n\t\t\t}\n\t\t\tY() {\n\t\t\t}\n\t\t\tvoid f() {\n\t\t\t\tI i = X::new;\n\t\t\t\ti.makeX(123456);\n\t\t\t\ti = X.Y::new;\n\t\t\t\ti.makeX(987654);\n\t\t\t}\n\t\t}\n\t\treturn null; \n\t};\n\tprivate X(int x) {\n\t\tSystem.out.println(x);\n\t}\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().f();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tclass Y extends X {\n\t      ^\nThe type Y is never used locally\n----------\n2. WARNING in X.java (at line 7)\n\tprivate Y (int y) {\n\t        ^^^^^^^^^\nThe constructor Y(int) is never used locally\n----------\n3. WARNING in X.java (at line 10)\n\tY() {\n\t^^^\nThe constructor Y() is never used locally\n----------\n4. WARNING in X.java (at line 13)\n\tI i = X::new;\n\t  ^\nThe local variable i is hiding a field from type X\n----------\n5. ERROR in X.java (at line 15)\n\ti = X.Y::new;\n\t      ^\nY cannot be resolved or is not a field\n----------\n6. ERROR in X.java (at line 27)\n\tnew X().new Y().f();\n\t            ^\nX.Y cannot be resolved to a type\n----------\n");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString doit();\n}\npublic class X extends B {\n\tclass Y {\n\t\tclass Z {\n\t\t\tvoid f() {\n\t\t\t\t\n\t\t\t\t I i = X.super::toString; // Verify error\n\t\t\t\t System.out.println(i.doit());\n\t\t\t\t i = X.this::toString; // This call gets dispatched OK.\n\t\t\t\t System.out.println(i.doit());\n\t\t\t}\n\t\t}\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().new Z().f(); \n\t}\n\t\n\tpublic String toString() {\n\t\treturn \"X's toString\";\n\t}\n}\nclass B {\n\tpublic String toString() {\n\t\treturn \"B's toString\";\n\t}\n}\n"}, "B's toString\nX's toString");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x, int y);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tlong lng = 1234;\n\t\tdouble d = 1234.5678;\n\t\tI i = (x, y) -> {\n\t\t\tSystem.out.println(\"long = \" + lng);\n\t\t\tSystem.out.println(\"args length = \" + args.length);\n\t\t\tSystem.out.println(\"double = \" + d);\n\t\t\tSystem.out.println(\"x = \" + x);\n\t\t\tSystem.out.println(\"y = \" + y);\n\t\t};\n\t\ti.foo(9876, 4321);\n\t}\n}\n"}, "long = 1234\nargs length = 0\ndouble = 1234.5678\nx = 9876\ny = 4321");
    }

    public void test048() {
        this.runConformTest(new String[]{"X.java", "interface I<T, J> {\n\tvoid foo(T x, J y);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tlong lng = 1234;\n\t\tdouble d = 1234.5678;\n\t\tI<Object, Object> i = (x, y) -> {\n\t\t\tSystem.out.println(\"long = \" + lng);\n\t\t\tSystem.out.println(\"args length = \" + args.length);\n\t\t\tSystem.out.println(\"double = \" + d);\n\t\t\tSystem.out.println(\"x = \" + x);\n\t\t\tSystem.out.println(\"y = \" + y);\n\t\t};\n\t\ti.foo(9876, 4321);\n\t\t\n\t\tI<String, String> i2 = (x, y) -> {\n\t\t\tSystem.out.println(x);\n\t\t\tSystem.out.println(y);\n\t\t};\n\t\ti2.foo(\"Hello !\",  \"World\");\n\t}\n}\n"}, "long = 1234\nargs length = 0\ndouble = 1234.5678\nx = 9876\ny = 4321\nHello !\nWorld");
    }

    public void test049() {
        this.runConformTest(new String[]{"X.java", "interface I<T, J> {\n\tvoid foo(X x, T t, J j);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI<String, String> i = X::foo;\n\t\ti.foo(new X(), \"Hello\", \"World!\");\n\t}\n\tvoid foo(String s, String t) {\n\t\tSystem.out.println(s);\n\t\tSystem.out.println(t);\n\t}\n}\n"}, "Hello\nWorld!");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x, int y);\n}\npublic class X {\n\tstatic private void add(int x, int y) {\n\t\tSystem.out.println(x + y);\n\t}\n\tprivate void multiply(int x, int y) {\n\t\tSystem.out.println(x * y);\n\t}\n\tstatic class Y {\n\t\tstatic private void subtract(int x, int y) {\n\t\t\tSystem.out.println(x - y);\n\t\t}\n\t\tprivate void divide (int x, int y) {\n\t\t\tSystem.out.println(x / y);\n\t\t}\n\t\tstatic void doy() {\n\t\t\tI i = X::add;\n\t\t\ti.foo(1234, 12);\n\t\t\ti = new X()::multiply;\n\t\t\ti.foo(12, 20);\n\t\t\ti = Y::subtract;\n\t\t\ti.foo(123,  13);\n\t\t\ti = new Y()::divide;\n\t\t\ti.foo(99, 9);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::add;\n\t\ti.foo(1234, 12);\n\t\ti = new X()::multiply;\n\t\ti.foo(12, 20);\n\t\ti = Y::subtract;\n\t\ti.foo(123,  13);\n\t\ti = new Y()::divide;\n\t\ti.foo(99, 9);\n\t\tY.subtract(10,  7);\n\t\tY.doy();\n\t}\n}\n"}, "1246\n240\n110\n11\n3\n1246\n240\n110\n11");
    }

    public void test051() {
        this.runConformTest(new String[]{"p2/B.java", "package p2;\nimport p1.*;\t\t\t\t\t\t\t\t\ninterface I {\n\tvoid foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class B extends A {\n\tclass Y {\n\t\tvoid g() {\n\t\t\tI i = B::foo;\n\t\t\ti.foo();\n\t\t\tJ j = new B()::goo;\n\t\t\tj.foo();\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew B().new Y().g();\n\t}\n}\n", "p1/A.java", "package p1;\nimport p2.*;\npublic class A {\n\tprotected static void foo() {\n\t    System.out.println(\"A's static foo\");\n\t}\n\tprotected void goo() {\n\t    System.out.println(\"A's instance goo\");\n\t}\n}"}, "A's static foo\nA's instance goo");
    }

    public void test052() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\npublic class X {\n\tvoid foo() {\n\t\tint local = 10;\n\t\tclass Y {\n\t\t\tvoid foo(int x) {\n\t\t\t\tSystem.out.println(local);\n\t\t\t}\n\t\t\tvoid goo() {\n\t\t\t\tI i = this::foo;\n\t\t\t\ti.foo(10);\n\t\t\t}\n\t\t}\n\t\tnew Y().goo();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "10");
    }

    public void test053() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n  public static <E> void printItem(E value, int index) {\n    String output = String.format(\"%d -> %s\", index, value);\n    System.out.println(output);\n  }\n  public static void main(String[] argv) {\n    List<String> list = Arrays.asList(\"A\",\"B\",\"C\");\n    eachWithIndex(list,X::printItem);\n  }\n  interface ItemWithIndexVisitor<E> {\n    public void visit(E item, int index);\n  }\n  public static <E> void eachWithIndex(List<E> list, ItemWithIndexVisitor<E> visitor) {\n    for (int i = 0; i < list.size(); i++) {\n         visitor.visit(list.get(i), i);\n    }\n  }\n}\n"}, "0 -> A\n1 -> B\n2 -> C");
    }

    public void test054() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n  public static <E> void printItem(E value) {}\n  public static void main(String[] argv) {\n    List<String> list = null;\n    eachWithIndex(list, X::printItem);\n  }\n  interface ItemWithIndexVisitor<E> {\n    public void visit(E item);\n  }\n  public static <E> void eachWithIndex(List<E> list, ItemWithIndexVisitor<E> visitor) {}\n}\n"}, "");
    }

    public void test055() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tX x = null;\n\t\tI i = x::foo;\n\t}\n\tint foo(int x) {\n\t\treturn x;\n\t}\n}\n"}, "");
    }

    public void test056() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tX x = null;\n\t\tI i = x::foo;\n\t\ttry {\n\t\t\ti.foo(10);\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(npe.getMessage());\n\t\t}\n\t}\n\tint foo(int x) {\n\t\treturn x;\n\t}\n}\n"}, "null");
    }

    public void test057() {
        String source = "interface I {\n    void foo(Y<String> y);\n}\npublic class Y<T> {\n    class Z<K> {\n        Z(Y<String> y) {\n            System.out.println(\"Y<T>.Z<K>:: new\");\n        }\n        public void bar() {\n            I i = Y<String>.Z<Integer>::<String> new;\n            i.foo(new Y<String>());\n            i = Y<String>.Z<Integer>:: new;\n            i.foo(new Y<String>());\n            i = Y.Z:: new;\n            i.foo(new Y<String>());\n        }\n    }\n\tpublic void foo() {\n\t\tZ<String> z = new Z<String>(null);\n\t\tz.bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<String>();\n\t\ty.foo();\n\t}\n}\n";
        this.runConformTest(new String[]{"Y.java", source}, "Y<T>.Z<K>:: new\nY<T>.Z<K>:: new\nY<T>.Z<K>:: new\nY<T>.Z<K>:: new");
    }

    public void test058() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tF1 f = X::foo;\n\t\tSystem.out.println(\"Hello, World\");\n\t}\n    static int foo (int x) throws NumberFormatException { return 0; }\n}\ninterface F1 { int X(int x);}\n"}, "Hello, World");
    }

    public void testGenericArrayCreation() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX<?, ?, ?>[] makeArray(int i);\n}\npublic class X<T, U, V> {\n\tpublic static void main(String [] args) {\n\t\tI i = X<?, ?, ?>[]::new; // OK.\n\t\tSystem.out.println(i.makeArray(1024).length);\n\t}\n}\n"}, "1024");
    }

    public void test421536() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "interface I {\n\tI foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tI i = () -> null;\n\t\t} catch (NullPointerException npe) {}\n       System.out.println(\"OK\");\n\t}\n}\n"}, "OK", customOptions);
    }

    public void test421536a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\npublic class X {\n   public static void foo() {}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tI i = X::foo;\n\t\t} catch (NullPointerException npe) {}\n       System.out.println(\"OK\");\n\t}\n}\n"}, "OK", customOptions);
    }

    public void test421607() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tpublic void foo();\n}\nclass C implements I {\n\tpublic void foo() {\n\t\tSystem.out.println(\"You will get here\");\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t((C & I) (I) new C()).foo();\n\t}\n}\n"}, "You will get here");
    }

    public void test421712() {
        this.runConformTest(new String[]{"X.java", "interface F {\n\tvoid foo();\n}\ninterface I {\n\tdefault void foo() {\n\t\tF f = () -> {\n\t\t};\n   System.out.println(\"Lambda instantiated\");\n\t}\n}\npublic class X implements I {\n\tpublic static void main(String argv[]) {\n\t\tX x = new X();\n\t\tx.foo();\n\t}\n}\n"}, "Lambda instantiated");
    }

    public void test422515() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws InterruptedException {\n        final int[] result = { 0 };\n        Thread t = new Thread(() -> result[0] = 42);\n        t.start();\n        t.join();\n        System.out.println(result[0]);\n    }\n}\n"}, "42");
    }

    public void test422515a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws InterruptedException {\n        final int[] result= { 0 };\n        final int x = args.length + 42;\n        Thread t = new Thread(() -> {\n            result[0]= x;\n        });\n        t.start();\n        t.join();\n        System.out.println(result[0]);\n    }\n}\n"}, "42");
    }

    public void test422800() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    private String fField; // must be here; can be used or unused\n    public void foo(Integer arg) {\n        new Thread(() -> {\n            arg.intValue();\n        });\n    }\n    public static void main(String [] args) {\n\t     System.out.println(\"OK\");\n    }\n}\n"}, "OK");
    }

    public void test421927() {
        this.runConformTest(new String[]{"X.java", "interface I { \n\tint foo();\n}\npublic class X {\n    static I i  = (I & java.io.Serializable) () -> 42;\n    public static void main(String args[]) {\n        System.out.println(i.foo());\n    }\n}\n"}, "42");
    }

    public void testReferenceExpressionInference1() {
        this.runConformTest(new String[]{"X.java", "interface I<E> {\n\tE foo(E e);\n}\npublic class X {\n\t<T> T print(I<T> i) { return null; }\n\tvoid test() {\n\t\tString s = print(this::bar);\t}\n\t<S> S bar(S s) { return s; }\n}\n"});
    }

    public void testReferenceExpressionInference2() {
        this.runConformTest(new String[]{"X.java", "interface I<E,F> {\n\tF foo(E e);\n}\npublic class X {\n\t<S,T,U> I<S,U> compose(I<S,T> i1, I<T,U> i2) { return null; }\n\tvoid test() {\n\t\tI<X,String> x2s = compose(this::bar, this::i2s);\t}\n\tString i2s (Integer i) { return i.toString(); }\n\t<V,W extends Number> W bar(V v) { return null; }\n}\n"});
    }

    public void testReferenceExpressionInference3a() {
        this.runConformTest(new String[]{"X.java", "interface I<E,F> {\n\tF foo(E e);\n}\npublic class X {\n\t<S,T,U> I<S,U> compose(I<S,T> i1, I<T,U> i2) { return null; }\n\tvoid test() {\n\t\tI<X,String> x2s = compose(this::bar, this::<String>i2s);\t}\n\t<Z> Z i2s (Integer i) { return null; }\n\t<V,W extends Number> W bar(V v) { return null; }\n}\n"});
    }

    public void testReferenceExpressionInference3b() {
        this.runNegativeTest(new String[]{"X.java", "interface I<E,F> {\n\tF foo(E e);\n}\npublic class X {\n\t<S,T,U> I<S,U> compose(I<S,T> i1, I<T,U> i2) { return null; }\n\tvoid test() {\n\t\tI<X,String> x2s = compose(this::bar, this::i2s);\n\t}\n\t<Z> Z i2s (Integer i) { return null; }\n\t<V,W extends Number> W bar(V v) { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI<X,String> x2s = compose(this::bar, this::i2s);\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from I<Object,Object> to I<X,String>\n----------\n2. ERROR in X.java (at line 7)\n\tI<X,String> x2s = compose(this::bar, this::i2s);\n\t                                     ^^^^^^^^^\nThe type X does not define i2s(Object) that is applicable here\n----------\n");
    }

    public void testLambdaInference1() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n  public static void main(String[] argv) {\n    List<String> list = null;\n    eachWithIndex(list, s -> print(s));\n  }\n  static void print(String s) {}\n  interface ItemWithIndexVisitor<E> {\n    public void visit(E item);\n  }\n  public static <E> void eachWithIndex(List<E> list, ItemWithIndexVisitor<E> visitor) {}\n}\n"}, "");
    }

    public void testLambdaInference2() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nclass A {}\nclass B extends A {\n\tvoid bar() {}\n}\npublic class X {\n  public static void main(String[] argv) {\n    someWithIndex(getList(), (B b) -> b.bar());\n  }\n  interface ItemWithIndexVisitor<E> {\n    public void visit(E item);\n  }\n  public static <G> void someWithIndex(List<G> list, ItemWithIndexVisitor<G> visitor) {}\n  static <I extends A> List<I> getList() { return null; }\n}\n"}, "");
    }

    public void testBug419048_1() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.stream.*;\npublic class X {\n\tpublic void test() {\n\t\t List<Person> roster = new ArrayList<>();\n        \n        Map<String, Person> map = \n            roster\n                .stream()\n                .collect(\n                    Collectors.toMap(\n                        p -> p.getLast(),\n                        p -> p\n                    ));\n\t}\n}\nclass Person {\n  public String getLast() { return null; }\n}\n"});
    }

    public void testBug419048_2() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\npublic class X {\n\tpublic void test() {\n\t\t List<Person> roster = new ArrayList<>();\n        \n        Map<String, Person> map = \n            roster\n                .stream()\n                .collect(\n                    Collectors.toMap(\n                        Person::getLast,\n                        Function.identity()\n                    ));\n\t}\n}\nclass Person {\n  public String getLast() { return null; }\n}\n"});
    }

    public void testBug419048_3() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\npublic class X {\n\tpublic void test() {\n\t\t List<Person> roster = new ArrayList<>();\n        \n        Map<String, Person> map = \n            roster\n                .stream()\n                .collect(\n                    Collectors.toMap(\n                        new Function<Person, String>() {\n                            public String apply(Person p) { \n                                return p.getLast(); \n                            } \n                        },\n                        Function.identity()\n                    ));\n\t}\n}\nclass Person {\n  public String getLast() { return null; }\n}\n"});
    }

    public void test424226() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void fun1() {\n\t\tFI fi = I::staticMethod; \n\t}\n   public static void main(String [] args) {\n       System.out.println(\"OK\");\n   }\n}\n@FunctionalInterface\ninterface FI {\n\tvoid foo();\t\n}\ninterface I {\n\tstatic FI staticMethod() {\n\t\treturn null;\n\t}\n}\n"}, "OK");
    }

    public void test423684() {
        this.runConformTest(new String[]{"Test.java", "import java.util.Arrays;\nimport java.util.List;\nimport mypackage.MyPublicClass;\npublic class Test {\n    public static void main(String[] args) {\n        doesWork();\n        doesNotWork();\n    }\n    public static void doesNotWork() {\n        MyPublicClass victim = new MyPublicClass();\n        List<String> items = Arrays.asList(\"first\", \"second\", \"third\");\n        items.forEach(victim::doSomething); //illegal access error here\n    }\n    public static void doesWork() {\n        MyPublicClass victim = new MyPublicClass();\n        List<String> items = Arrays.asList(\"first\", \"second\", \"third\");\n        for (String item : items) {\n            victim.doSomething(item);\n        }\n    }\n}\n", "mypackage/MyPublicClass.java", "package mypackage;\nclass MyPackagePrivateBaseClass {\n    public void doSomething(String input) {\n        System.out.println(input);\n    }\n}\npublic class MyPublicClass extends MyPackagePrivateBaseClass {\n}\n"}, "first\nsecond\nthird\nfirst\nsecond\nthird");
    }

    public void testBug424742() {
        this.runNegativeTest(new String[]{"TestInlineLambdaArray.java", "package two.test;\n\nclass TestInlineLambdaArray {\n\tTestInlineLambdaArray h = new TestInlineLambdaArray(x -> x++);\t// [9]\n\tpublic TestInlineLambda(FI fi) {}\n}\n\ninterface FI {\n\t\tvoid foo();\n}\n"}, "----------\n1. ERROR in TestInlineLambdaArray.java (at line 4)\n\tTestInlineLambdaArray h = new TestInlineLambdaArray(x -> x++);\t// [9]\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor TestInlineLambdaArray((<no type> x) -> {}) is undefined\n----------\n2. ERROR in TestInlineLambdaArray.java (at line 5)\n\tpublic TestInlineLambda(FI fi) {}\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void test424589() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Collection;\nimport java.util.function.Supplier;\nimport java.util.Set;\npublic class X {\n    public static <T, Y extends Collection<T>>\n        Y foo(Supplier<Y> y) {\n            return null;\n    }  \n    public static void main(String[] args) {\n        Set<Z> x = foo(Set::new);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tSet<Z> x = foo(Set::new);\n\t    ^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 11)\n\tSet<Z> x = foo(Set::new);\n\t           ^^^^^^^^^^^^^\nType mismatch: cannot convert from Collection<Object> to Set<Z>\n----------\n3. ERROR in X.java (at line 11)\n\tSet<Z> x = foo(Set::new);\n\t               ^^^\nCannot instantiate the type Set\n----------\n");
    }

    public void test425152() {
        this.runConformTest(new String[]{"Main.java", "interface Base { \n\tBase get(int x);\n}\nclass Main {\n    <T> Base foo(Base b) { \n        return null; \n     }\n    void bar(Base b) { }\n    void testCase() {\n        bar(foo((int p)->null));\n     }\n}\n"});
    }

    public void test425512() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X  {\n    public static void main(String argv[]) {\n    \tint [] a = (int [] & Cloneable & Serializable) new int[5];\n       System.out.println(a.length);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint [] a = (int [] & Cloneable & Serializable) new int[5];\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nArrays are not allowed in intersection cast operator\n----------\n");
    }

    public void test424628() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static interface Consumer<T> {\n        void accept(T t);\n    }\n    \n    public static class Base {\n        public void method () { System.out.println(123); }\n    }\n    public static class Foo extends Base {}\n    public static class Bar extends Base {}\n\n    public static void main (String[] args) {\n        Consumer<Foo> foo = Foo::method;\n        Consumer<Bar> bar = Bar::method;\n        foo.accept(new Foo());\n        bar.accept(new Bar());\n    }\n}\n"}, "123\n123");
    }

    public void test425712() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    {\n        bar( () -> (char) 0); // [1]\n    }\n    void bar(FB fb) { }\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\ninterface FB {\n\tbyte foo();\n}\n"}, "OK");
    }

    public void test426074() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Functional<T> {\n    void foo(T t);\n}\ninterface I { }\npublic class X {\n\tpublic static void main(String[] args) {\n    \tFunctional<? extends X> f = (Functional<? extends X> & I) (X c) -> {\n    \t\tSystem.out.println(\"main\");\n    \t};\n    \tf.foo(null);\n    }\n}\n"}, "main");
    }

    public void test426411() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\t((Serializable & AutoCloseable) (() -> {})).close();\n\t}\n}\n"}, "");
    }

    public void test426411b() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface AnotherAutoCloseable extends AutoCloseable {}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\t((Serializable & AnotherAutoCloseable) (() -> {})).close();\n\t}\n}\n"}, "");
    }

    public void test426411c() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\t((AutoCloseable & Serializable) (() -> {})).close();\n\t}\n}\n"}, "");
    }

    public void test426411d() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface AnotherAutoCloseable extends AutoCloseable {}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\t((AnotherAutoCloseable & Serializable) (() -> {})).close();\n\t}\n}\n"}, "");
    }

    public void test426411e() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface I {}\ninterface J extends I {\n   static final int xyz = 99;\n}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tJ j = new J() {};\n\t\tSystem.out.println(((I & J) j).xyz);\n\t}\n}\n"}, "99");
    }

    public void test426411f() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface I {}\ninterface J extends I {\n   final int xyz = 99;\n}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tJ j = new J() {};\n\t\tSystem.out.println(((I & J) j).xyz);\n\t}\n}\n"}, "99");
    }

    public void test426086() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Functional {\n    Long square(Integer a);\n}\npublic class X {\n    static class Base {\n    \t private Long square(Integer a) {\n             return Long.valueOf(a*a);\n         } \n    }\n    static class SubClass extends Base {\n        public Long callSquare(Integer i) {\n            Functional fi = SubClass.super::square;\n            return fi.square(i);\n        }\n    }\n    public static void main(String argv[]) throws Exception {\n    \tSystem.out.println(new SubClass().callSquare(-3));\n    }\n}\n"}, "9");
    }

    public void test426086a() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Functional {\n    Long square(Integer a);\n}\npublic class X {\n    static class Base {\n    \t private Long square(Integer a) {\n             return Long.valueOf(a*a);\n         } \n    }\n    static class SubClass extends Base {\n        public Long callSquare(Integer i) {\n            Functional fi = super::square;\n            return fi.square(i);\n        }\n    }\n    public static void main(String argv[]) throws Exception {\n    \tSystem.out.println(new SubClass().callSquare(-3));\n    }\n}\n"}, "9");
    }

    public void test406744a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\tstatic void m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tI i = Y::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744b() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\tstatic int m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t\treturn 1;\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tI i = Y::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744c() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\t Y(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tI i = Y::new;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744d() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int a1, Integer a2, String a3);\n}\ninterface Y {\n\tstatic void m(float a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic interface X extends Y{\n\tpublic static void main(String [] args) {\n\t\tI i = Y::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10.0\n20\n10, 20");
    }

    public void test406744e() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString method(int a);\n}\nclass C {\n\tstatic String foo(Integer... i) {\n\t\treturn \"foo\";\n\t}\n\tstatic String goo(Integer bi, Integer... i) {\n\t\treturn \"bar\";\n\t}\n\tpublic void foo() {\n\t\tI i;\n\t\ti = C::foo;\n\t\tSystem.out.println(i.method(0));\n\t\ti = C::goo;\n\t\tSystem.out.println(i.method(0));\n\t}\n}\npublic class X {\n\tpublic static void main(String argv[])   {\n\t\tnew C().foo();\n\t}\n}\n"}, "foo\nbar");
    }

    public void test406744f() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\tvoid m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = super::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744g() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tprivate void m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = this::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744h() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int [] ia);\n}\nclass Y {\n\tvoid m(Object... rest) {\n\t\tSystem.out.println(\"Hello \" + rest.length);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = super::m;\n\t\ti.foo(new int [0]);\n\t}\n}\n"}, "Hello 1");
    }

    public void test406744i() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int [] ia);\n}\ninterface I1 {\n\tvoid foo(int [] ia);\n}\nclass Y {\n\tvoid m(Object... rest) {\n\t\tSystem.out.println(\"Hello \" + rest.length);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = super::m;\n\t\ti.foo(new int [0]);\n\t\tI1 i1 = super::m;\n\t\ti1.foo(new int [0]);\n\t}\n}\n"}, "Hello 1\nHello 1");
    }

    public void test406744j() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int [] ia);\n}\nclass Y {\n\tvoid m(Object... rest) {\n\t\tI i = this::n;\n\t\ti.foo(new int [0]);\n\t}\n\tvoid n(Object... rest) {\n\t\tSystem.out.println(\"Hello \" + rest.length);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = super::m;\n\t\ti.foo(new int [0]);\n\t}\n}\n"}, "Hello 1");
    }

    public void test406744k() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int [] ia);\n}\nclass Y {\n\tstatic void m(Object... rest) {\n\t\tSystem.out.println(\"Hello \" + rest.length);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\nclass Y1 extends Y { }\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = Y::m;\n\t\ti.foo(new int [0]);\n\t\ti = Y1::m;\n\t\ti.foo(new int [0]);\n\t}\n}\n"}, "Hello 1\nHello 1");
    }

    public void test406744l() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer i);\n}\npublic class X {\n\tstatic void foo(int ... x) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::foo;\n\t\ti.foo(1);\n\t\tSystem.out.println(\"Hello\");\n}\n}\n"}, "Hello");
    }

    public void test406744m() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int i);\n}\npublic class X {\n\tstatic void foo(int ... x) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::foo;\n\t\ti.foo(1);\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "Hello");
    }

    public void test406744n() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer i);\n}\nclass Base {\n\tvoid foo(Object ...objects) {\n\t\tSystem.out.println(\"Ok\");\n\t}\n}\npublic class X extends Base {\n\tvoid foo(Object... objects) {\n\t\tthrow new RuntimeException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().goo();\n\t}\n\tvoid goo() {\n\t\tI i = super::foo;\n\t\ti.foo(10);\n\t}\n}\n"}, "Ok");
    }

    public void test406744o() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\nclass Base {\n\tpublic void foo(int ...is) {\n\t\tSystem.out.println(\"foo\");\n\t}\n}\npublic class X extends Base {\n\tpublic static void main( String[] args ) {\n\t\tI i = new X()::foo;\n\t\ti.foo(10);\n\t}\n}\n"}, "foo");
    }

    public void test406744p() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\npublic class X {\n\tprivate void foo(int ...is) {\n\t\tSystem.out.println(\"foo\");\n\t}\n\tpublic static void main(String[] args ) {\n\t\tnew X().new Y().foo();\n\t}\n\tclass Y extends X {\n\t\tvoid foo() {\n\t\t\tI i = new X()::foo;\n\t\t\ti.foo(10);\n\t\t}\n\t}\n}\n"}, "foo");
    }

    public void test406744q() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\nclass Y {\n\tpublic static void foo(int ...is) {\n\t\tSystem.out.println(\"Y.foo\");\n\t}\n}\npublic class X {\n\tpublic static void foo(int ...is) {\n\t\tSystem.out.println(\"X.foo\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::foo;\n\t\ti.foo(10);\n\t\ti = Y::foo;\n\t\ti.foo(20);\n\t}\n}\n"}, "X.foo\nY.foo");
    }

    public void test406744r() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int t, int [] ia);\n}\npublic class X {\n\tpublic static void foo(Integer i, int ...is) {\n\t\tSystem.out.println(\"Y.foo\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::foo;\n\t\ti.foo(10, null);\n\t}\n}\n"}, "Y.foo");
    }

    public void test406744s() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo(int x);\n}\npublic class X {\n\tclass Y extends X {\n\t\tY(int ... x) {\n\t\t\tSystem.out.println(\"Y::Y\");\n\t\t}\n\t}\n\tpublic static void main(String[] args ) {\n\t\tnew X().goo();\n\t}\n\tvoid goo() {\n\t\tI i = Y::new;\n\t\ti.foo(10);\n\t}\n}\n"}, "Y::Y");
    }

    public void test406744t() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo(int x);\n}\npublic class X<T> {\n\tclass Y extends X {\n\t    Y(int ... x) {\n\t\t    System.out.println(\"Y::Y\");\n\t    }\n\t}\n\tpublic static void main(String[] args ) {\n\t\tSystem.out.println(\"Hello\");\n\t\tnew X().goo();\n\t}\n\tvoid goo() {\n\t\tI i = Y::new;\n\t\ti.foo(10);\n\t}\n}\n"}, "Hello\nY::Y");
    }

    public void test406744u() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX<String> foo(int x);\n}\npublic class X<T> {  \n\tclass Y extends X<String> {\n\t    Y(int ... x) {\n\t\t    System.out.println(\"Y::Y\"); \n\t    }\n\t}\n\tpublic static void main(String[] args ) {\n\t\tSystem.out.println(\"Hello\");\n\t\tnew X<String>().goo();  \n\t}\n\tvoid goo() {\n\t\tI i = Y::new;\n\t\ti.foo(10); \n\t}\n}\n"}, "Hello\nY::Y");
    }

    public void test406744v() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo();\n}\npublic class X {\n\tprivate X(int ... is) {\n\t\tSystem.out.println(\"X::X\");\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().goo();\n\t}\n\tpublic class Y {\n\t\tpublic void goo() {\n\t\t\tI i = X::new; \n\t\t\ti.foo();\n\t\t} \n\t}\n}\n"}, "X::X\nX::X");
    }

    public void test406744w() {
        this.runConformTest(new String[]{"p2/B.java", "package p2;\nimport p1.*;\ninterface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tvoid foo(int x);\n}\npublic class B extends A {\n\tclass Y {\n\t\tvoid g() {\n\t\t\tI i = B::foo;\n\t\t\ti.foo(10);\n\t\t\tJ j = new B()::goo;\n\t\t\tj.foo(10);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew B().new Y().g();\n\t}\n}\n", "p1/A.java", "package p1;\nimport p2.*;\npublic class A {\n\tprotected static void foo(int ... is) {\n\t    System.out.println(\"A's static foo\");\n\t}\n\tprotected void goo(int ... is) {\n\t    System.out.println(\"A's instance goo\");\n\t}\n}\n"}, "A's static foo\nA's instance goo");
    }

    public void test406744x() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\npublic class X {\n\tclass Y {\n\t\tvoid goo() {\n\t\t\tI i = X::goo;\n\t\t\ti.foo(10);\n\t\t}\n\t}\n\tprivate static void goo(Integer i) {\n\t\tSystem.out.println(i);\n\t}\n\tpublic static void main(String[] args) {\n\t\t new X().new Y().goo(); \n\t}\n}\n"}, "10");
    }

    public void test427483() {
        this.runConformTest(new String[]{"X.java", "import java.util.TreeSet;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew TreeSet<>((String qn1, String qn2) -> {\n\t\t\tboolean b = true;\n\t\t\tSystem.out.println(b); // ok\n\t\t\tif (b) {\n\t\t\t} // Eclipse says: b cannot be resolved or is not a field\n\t\t\treturn qn1.compareTo(qn2);\n\t\t});\n\t}\n}\n"}, "");
    }

    public void test427627() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n    Runnable r = () -> {\n      List<SourceKey> keys = new ArrayList<>();\n\n      associate(\"Test\", keys.toArray(new SourceKey[keys.size()]));\n    };\n    r.run();\n  }\n  private static void associate(String o, SourceKey... keys) {\n\t  System.out.println(o);\n\t  System.out.println(keys.length);\n  }\n  public class SourceKey {\n    public SourceKey(Object source, Object key) {\n    }\n  }\n}\n"}, "Test\n0");
    }

    public void test427744() {
        this.runConformTest(new String[]{"X.java", "public class X {   \n    public static void main(String argv[]) {\n        int i = ((I) (x) -> { return 999; }).foo(true ? 0 : (Comparable) null);\n        System.out.println(i);\n    }\n    interface I {\n        int foo (Comparable arg); \n        default int foo (Object arg) { \n            return 0;\n        }\n    }\n}\n"}, "999");
    }

    public void test427962() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\nimport java.util.function.IntFunction;\nimport java.util.stream.Stream;\nimport java.util.stream.IntStream;\npublic class X {\n  static <A, B> Stream<B> objmap(Function<A, B> p1, A[] p2) {return Stream.of(p2).map(p1);}\n  static <B> Stream<B> intmap(IntFunction<B> p1, int[] p2) {return IntStream.of(p2).mapToObj(p1);}\n  public static void main(String[] args) {\n    Integer[] p12 = {1, 2, 3};\n    int[] p22 = {1, 2, 3};\n    //works\n    String[] a11 = objmap(String::valueOf, p12).<String> toArray(String[]::new);\n    String[] a21 = intmap(String::valueOf, p22).<String> toArray(String[]::new);\n    //does not work\n    String[] a12 = objmap(String::valueOf, p12).toArray(String[]::new);\n    String[] a22 = intmap(String::valueOf, p22).toArray(String[]::new);\n  }\n}\n"}, "");
    }

    public void test428112() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.Locale;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(Locale.lookup(Stream.of( \"de\", \"*-CH\" ).map(Locale.LanguageRange::new).collect(Collectors.toList()), \n                                   Arrays.asList(Locale.getAvailableLocales())));\n\t}\n}\n"}, "de");
    }

    public void test428003() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n    public static void main(String[] args) {\n        Arrays.sort(args, (String x, String y) -> x.length() - y.length());\n        Arrays.sort(args, (x, y) -> Integer.compare(x.length(), y.length()));\n    }\n}\n"}, "");
    }

    public void test428003a() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n    public static void main(String[] args) {\n        String[] words = {\"java\", \"interface\", \"lambda\", \"expression\" };\n        Arrays.sort(words, (String word1, String word2) -> {\n                    if (word1.length() < word2.length())\n                        return -1;\n                    else if (word1.length() > word2.length())\n                        return 1;\n                    else\n                        return 0;\n                  });\n        for (String word : words)\n            System.out.println(word);\n        words = new String [] {\"java\", \"interface\", \"lambda\", \"expression\" };\n        Arrays.sort(words, (word1, word2) -> Integer.compare(word1.length(), word2.length()));\n        for (String word : words)\n            System.out.println(word);\n        words = new String [] {\"java\", \"interface\", \"lambda\", \"expression\" };\n        Arrays.sort(words, (String word1, String word2) -> Integer.compare(word1.length(), word2.length()));\n        for (String word : words)\n            System.out.println(word);\n      }\n  }\n"}, "java\nlambda\ninterface\nexpression\njava\nlambda\ninterface\nexpression\njava\nlambda\ninterface\nexpression");
    }

    public void test428261() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo(int a);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString s = \"Blah\";\n\t\tclass Local extends X {\n\t\t\tLocal(int a) {\n\t\t\t\tSystem.out.println(a);\n\t\t\t\tSystem.out.println(s);\n\t\t\t}\n\t\t}\n\t\tI i = Local::new; // Incorrect error here.\n       i.foo(10);\n\t}\n}\n"}, "10\nBlah");
    }

    public void test428261a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo(int a);\n}\npublic class X {\n\tvoid goo() {\n\t\tclass Local extends X {\n\t\t\tLocal(int a) {\n\t\t\t\tSystem.out.println(a);\n\t\t\t}\n\t\t}\n\t\tI i = Local::new;\n       i.foo(10);\n\t}\n   public static void main(String [] args) {\n        new X().goo();\n   }\n}\n"}, "10");
    }

    public void test428552() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tinterface Example extends Serializable {\n\t\tString convert(Object o);\n\t}\n\tpublic static void main(String[] args) throws IOException {\n\t\tExample e=Object::toString;\n\t\ttry(ObjectOutputStream os=new ObjectOutputStream(new ByteArrayOutputStream())) {\n\t\t\tos.writeObject(e);\n\t\t}\n       System.out.println(\"No exception !\");\n\t}\n}\n"}, "No exception !", null, true, new String[]{"-Ddummy"});
    }

    public void test428642() {
        this.runConformTest(new String[]{"QuickSerializedLambdaTest.java", "import java.io.*;\nimport java.util.function.IntConsumer;\npublic class QuickSerializedLambdaTest {\n\tinterface X extends IntConsumer,Serializable{}\n\tpublic static void main(String[] args) throws IOException, ClassNotFoundException {\n\t\tX x1 = i -> System.out.println(i);// lambda expression\n\t\tX x2 = System::exit; // method reference\n\t\tByteArrayOutputStream debug=new ByteArrayOutputStream();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug))\n\t\t{\n\t\t\too.writeObject(x1);\n\t\t\too.writeObject(x2);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray())))\n\t\t{\n\t\t\tX x=(X)oi.readObject();\n\t\t\tx.accept(42);// shall print 42\n\t\t\tx=(X)oi.readObject();\n\t\t\tx.accept(0);// shall exit\n\t\t}\n\t\tthrow new AssertionError(\"should not reach this point\");\n\t}\n}\n"}, "42", null, true, new String[]{"-Ddummy"});
    }

    public void test429112() {
        this.runConformTest(new String[]{"ArrayConstructorReference.java", "import java.io.Serializable;\nimport java.util.function.IntFunction;\npublic class ArrayConstructorReference {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) {\n    IF factory=String[][][]::new;\n    Object o = factory.apply(10);\n    System.out.println(o.getClass());\n    String [][][] sa = (String [][][]) o;\n    System.out.println(sa.length);\n  }\n}\n"}, "class [[[Ljava.lang.String;\n10");
    }

    public void test429112a() {
        this.runConformTest(new String[]{"ArrayConstructorReference.java", "import java.io.Serializable;\nimport java.util.function.IntFunction;\npublic class ArrayConstructorReference {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) {\n    IF factory=java.util.function.IntFunction[][][]::new;\n    Object o = factory.apply(10);\n    System.out.println(o.getClass());\n    java.util.function.IntFunction[][][] sa = (java.util.function.IntFunction[][][]) o;\n    System.out.println(sa.length);\n  }\n}\n"}, "class [[[Ljava.util.function.IntFunction;\n10");
    }

    public void test429112b() {
        this.runConformTest(new String[]{"ArrayConstructorReference.java", "import java.io.Serializable;\nimport java.util.function.IntFunction;\npublic class ArrayConstructorReference {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) {\n    IF factory=java.util.function.IntFunction[]::new;\n    Object o = factory.apply(10);\n    System.out.println(o.getClass());\n    java.util.function.IntFunction[] sa = (java.util.function.IntFunction[]) o;\n    System.out.println(sa.length);\n  }\n}\n"}, "class [Ljava.util.function.IntFunction;\n10");
    }

    public void test429112c() {
        this.runConformTest(new String[]{"ArrayConstructorReference.java", "import java.io.Serializable;\nimport java.util.function.IntFunction;\npublic class ArrayConstructorReference {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) {\n    IF factory=String[]::new;\n    Object o = factory.apply(10);\n    System.out.println(o.getClass());\n    String [] sa = (String []) o;\n    System.out.println(sa.length);\n  }\n}\n"}, "class [Ljava.lang.String;\n10");
    }

    public void test428857() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.function.Function;\npublic class X {\n    public static void main (String[] args) {\n        Function<List<String>, String> func = List::toString;\n        System.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n    }\n}\n"}, "[a, b]", customOptions);
    }

    public void test428857a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\ninterface I {\n    List<String> getList();\n}\npublic class X {\n    public static void main (String[] args) {\n        I i = ArrayList::new;\n        System.out.println(i.getList());\n    }\n}\n"}, "[]", customOptions);
    }

    public void test428857b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\ninterface I {\n    ArrayList<String> getList();\n}\npublic class X {\n    public static void main (String[] args) {\n        I i = ArrayList::new;\n        System.out.println(i.getList());\n    }\n}\n"}, "[]", customOptions);
    }

    public void test428857c() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.ArrayList;\npublic class X {\n    public static void main (String[] args) {\n        Function<ArrayList<String>, String> func = List::toString;\n        System.out.println(func.apply(new ArrayList<>(Arrays.asList(\"a\", \"b\"))));\n    }\n}\n"}, "[a, b]", customOptions);
    }

    public void test429763() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n       try {\n\t\t    final int i = new Test<Integer>().test((Byte b) -> (int) b);\n       } catch (NullPointerException e) {\n            System.out.println(\"NPE\");\n       }\n\t}\n\tstatic class Test<R> {\n\t\t<T> R test(Function<T,R> f) {\n\t\t\treturn null;\n\t\t}\n\t}\n}\n"}, "NPE");
    }

    public void test429763a() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t// does not compile\n\t\tnew Test<Integer>().test((Byte b) -> (int) b);\n\t}\n\tstatic class Test<R> {\n\t\t<T> void test(Function<T,R> f) {\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test429759() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\nimport java.util.function.Supplier;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tfinal int i = new Test<Integer>().test(\"\", (String s) -> 1);\n\t}\n\tstatic class Test<R> {\n\t\t<T> R test(T t, Supplier<R> s) {\n\t\t\treturn s.get();\n\t\t}\n\t\t<T> R test(T t, Function<T, R> f) {\n\t\t\treturn f.apply(t);\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test429948() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\texecute(() -> {\n\t\t\texecuteInner(() -> {\n\t\t\t});\n\t\t\treturn null;\n\t\t});\n\t\tSystem.out.println(\"done\");\n\t}\n\tstatic <R> R execute(Supplier<R> supplier) {\n\t\treturn null;\n\t}\n\tstatic void executeInner(Runnable callback) {\n\t}\n}\n"}, "done");
    }

    public void test429969() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.Optional;\npublic class X {\n    public static void main(String[] args) {\n        final String s = Arrays.asList(\"done\").stream().reduce(null, (s1,s2) -> {\n                // THE FOLLOWING LINE CAUSES THE PROBLEM\n                require(s1 != null || s2 != null, \"both strings are null\");\n                    return (s1 != null) ? s1 : s2;\n            }, (s1,s2) -> (s1 != null) ? s1 : s2);\n\t\n        System.out.println(s);\n    }\n    static void require(boolean condition, String msg) throws RuntimeException {\n        if (!condition) {\n            throw new RuntimeException(msg);\n        }\n    }\n}\n"}, "done");
    }

    public void test430015() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Method;\nimport java.lang.reflect.Parameter;\nimport java.util.Arrays;\nimport java.util.function.IntConsumer;\npublic class X {\n    IntConsumer xx(int a) {\n        return i -> { };\n    }\n    public static void main(String[] args) {\n        Method[] methods = X.class.getDeclaredMethods();\n        for (Method method : methods) {\n        \tif (method.getName().contains(\"lambda\")) {\n         \t\tParameter[] parameters = method.getParameters();\n        \t\tSystem.out.println(Arrays.asList(parameters));\n        \t}\n        }\n    }\n}\n"}, "[int arg0]");
    }

    public void test430040() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        System.out.println(\"OK\");\n    }\n    class Observable<T> {}\n    class ObservableValue<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable observable);\n    }\n    public interface ChangeListener<T> {\n        void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n    }\n    static class ExpressionHelper<T> {}\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, InvalidationListener listener) {\n        return helper;\n    }\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, ChangeListener<? super T> listener) {\n        return helper;\n    }\n    private ExpressionHelper<Object> helper;\n    public void junk() {\n        helper = (ExpressionHelper<Object>) addListener(helper, null, (Observable o) -> {throw new RuntimeException();});\n        helper = addListener(helper, null, (Observable o) -> {throw new RuntimeException();});\n    }\n}\n"}, "OK");
    }

    public void test430043() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.IOException;\nimport java.io.StringReader;\nimport java.nio.file.Files;\nimport java.text.MessageFormat;\nimport java.util.*;\nimport java.util.function.Function;\nimport java.util.jar.Attributes;\nimport java.util.jar.JarFile;\nimport java.util.jar.Manifest;\npublic class X<T>  {\n    public X(String name, String description, String id, Class<T> valueType, String[] fallbackIDs, Function<Map<String, ? super Object>, T> defaultValueFunction, boolean requiresUserSetting, Function<String, T> stringConverter) {\n    }\n    public static final X<String> NAME  =\n            new X<>(\n                    null,\n                    null,\n                    null,\n                    String.class,\n                    null,\n                    params -> {throw new IllegalArgumentException(\"junk14\");},\n                    true,\n                    s -> s\n            );\n     public static void main(String [] args) {\n         System.out.println(\"OK\");\n     }\n}\n"}, "OK");
    }

    public void test430035() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Consumer;\npublic class X {\n    interface StringConsumer extends Consumer<String> {\n        void accept(String t);\n    }\n    public static void main(String... x) {\n      StringConsumer c = s->System.out.println(\"m(\"+s+')');\n      c.accept(\"direct call\");\n      Consumer<String> c4b=c;\n      c4b.accept(\"bridge method\");\n    }\n}\n"}, "m(direct call)\nm(bridge method)");
    }

    public void test430035a() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Consumer;\npublic class X {\n    interface StringConsumer extends Consumer<String> {\n        void accept(String t);\n    }\n    static void m(String s) { System.out.println(\"m(\"+s+\")\"); } \n    public static void main(String... x) {\n      StringConsumer c = X::m;\n      c.accept(\"direct call\");\n      Consumer<String> c4b=c;\n      c4b.accept(\"bridge method\");\n    }\n}\n"}, "m(direct call)\nm(bridge method)");
    }

    public void test430035b() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tvoid foo(T t);\n}\ninterface J<T> {\n\tvoid foo(T t);\n}\ninterface K extends I<String>, J<String> {\n}\npublic class X {\n    public static void main(String... x) {\n      K k = s -> System.out.println(\"m(\"+s+')');\n      k.foo(\"direct call\");\n      J<String> j = k;\n      j.foo(\"bridge method\");\n      I<String> i = k;\n      i.foo(\"bridge method\");\n    }\n}\n"}, "m(direct call)\nm(bridge method)\nm(bridge method)");
    }

    public void test430035c() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tvoid foo(String t, T u);\n}\ninterface J<T> {\n\tvoid foo(T t, String u);\n}\ninterface K extends I<String>, J<String> {\n\tvoid foo(String t, String u);\n}\npublic class X {\n    public static void main(String... x) {\n      K k = (s, u) -> System.out.println(\"m(\"+ s + u + ')');\n      k.foo(\"direct\", \" call\");\n      J<String> j = k;\n      j.foo(\"bridge\",  \" method(j)\");\n      I<String> i = k;\n      i.foo(\"bridge\",  \" method(i)\");\n    }\n}\n"}, "m(direct call)\nm(bridge method(j))\nm(bridge method(i))");
    }

    public void test430035d() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tvoid foo(String t, T u);\n}\ninterface J<T> {\n\tvoid foo(T t, String u);\n}\ninterface K extends I<String>, J<String> {\n}\npublic class X {\n    public static void main(String... x) {\n      K k = (s, u) -> System.out.println(\"m(\"+ s + u + ')');\n      k.foo(\"direct\", \" call\");\n      J<String> j = k;\n      j.foo(\"bridge\",  \" method(j)\");\n      I<String> i = k;\n      i.foo(\"bridge\",  \" method(i)\");\n    }\n}\n"}, "m(direct call)\nm(bridge method(j))\nm(bridge method(i))");
    }

    public void test430035e() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tObject foo(String t, T u);\n}\ninterface J<T> {\n\tString foo(T t, String u);\n}\ninterface K extends I<String>, J<String> {\n}\npublic class X {\n    public static void main(String... x) {\n      K k = (s, u) -> s + u;\n      System.out.println(k.foo(\"direct\", \" call\"));\n      J<String> j = k;\n      System.out.println(j.foo(\"bridge\",  \" method(j)\"));\n      I<String> i = k;\n      System.out.println(i.foo(\"bridge\",  \" method(i)\"));\n    }\n}\n"}, "direct call\nbridge method(j)\nbridge method(i)");
    }

    public void test430035f() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tObject foo(String t, String u);\n}\ninterface J<T> {\n\tString foo(String t, String u);\n}\ninterface K extends I<String>, J<String> {\n}\npublic class X {\n    public static void main(String... x) {\n      K k = (s, u) -> s + u;\n      System.out.println(k.foo(\"direct\", \" call\"));\n      J<String> j = k;\n      System.out.println(j.foo(\"bridge\",  \" method(j)\"));\n      I<String> i = k;\n      System.out.println(i.foo(\"bridge\",  \" method(i)\"));\n    }\n}\n"}, "direct call\nbridge method(j)\nbridge method(i)");
    }

    public void test430241() {
        this.runConformTest(new String[]{"X.java", "interface K extends I, J {\n}\ninterface I {\n    Comparable<Integer> foo();\n}\ninterface J {\n    Comparable foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tK k = () -> null;\n\t\tSystem.out.println(k.foo());\n\t}\n}\n"}, "null");
    }

    public void test430310() {
        this.runConformTest(new String[]{"X.java", "interface Func1<T1, R> {\n        R apply(T1 v1);\n        void other();\n}\n@FunctionalInterface // spurious error: F1<T, R> is not a functional interface\npublic interface X<T1, R> extends Func1<T1, R> {\n\tdefault void other() {}\n   public static void main(String [] args) {\n       System.out.println(\"OK\");\n   }\n}\n"}, "OK");
    }

    public void test430310a() {
        this.runConformTest(new String[]{"X.java", "@FunctionalInterface\npublic interface X<T1, T2, R> {\n    R apply(T1 v1, T2 v2);\n    default void other() {}\n    public static void main(String[] args) {\n        System.out.println(\"OK\");\n    }\n}\n"}, "OK");
    }

    public void test430310b() {
        this.runConformTest(new String[]{"X.java", "interface I1 {\n\tint foo(String s);\n}\n@FunctionalInterface\ninterface A1 extends I1 {\n\t@Override\n\tdefault int foo(String s) {\n\t\treturn -1;\n\t}\n\tint foo(java.io.Serializable s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }

    public void test430310c() {
        this.runConformTest(new String[]{"X.java", "interface I2 {\n\tint foo(String s);\n}\n@FunctionalInterface\ninterface A2 extends I2 {\n\t@Override\n\tdefault int foo(String s) {\n\t\treturn -1;\n\t}\n\tint bar(java.io.Serializable s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }

    public void test432619() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.function.BiConsumer;\npublic interface X<E extends Exception> {\n\tstatic void foo() {\n\t    BiConsumer<double[][], Double> biConsumer2 = Re2::accumulate;\n\t}\n\tstatic class Re2 {\n\t    static void accumulate(double[][] container, Double value) {}\n\t}\n   public static void main(String [] args) {\n       System.out.println(\"OK\");\n   }\n}\n"}, "OK");
    }

    public void test432619a() throws Exception {
        this.runConformTest(new String[]{"StreamInterface.java", "import java.util.Map;\nimport java.util.stream.Collector;\npublic interface StreamInterface<E extends Exception> {\n\tstatic class DoubleCo {\n\t\tprivate static class Re2 {\n\t\t\tstatic <K, E extends Exception> Map<K, double[]> internalToMapToList2() {\n\t\t\t\tCollector<Double, double[][], double[][]> toContainer1 = Collector.of(\n\t\t\t\t//The method supply() from the type StreamInterface.DoubleCo.Re2 should be accessed in a static way\n\t\t\t\t  StreamInterface.DoubleCo.Re2::supply,\n\t\t\t\t  //The method accumulate(double[][], Double) from the type StreamInterface.DoubleCo.Re2 should be accessed in a static way\n\t\t\t\t  StreamInterface.DoubleCo.Re2::accumulate,\n\t\t\t\t  //The method combine(double[][], double[][]) from the type StreamInterface.DoubleCo.Re2 should be accessed in a static way\n\t\t\t\t  StreamInterface.DoubleCo.Re2::combine);\n\t\t\t\tCollector<Double, double[][], double[][]> toContainer2 =\n\t\t\t\t//All 3 from above:\n\t\t\t\t  Collector.of(DoubleCo.Re2::supply, DoubleCo.Re2::accumulate, DoubleCo.Re2::combine);\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tprivate static double[][] supply() {\n\t\t\t\treturn new double[64][];\n\t\t\t}\n\t\t\tprivate static void accumulate(double[][] container, Double value) {}\n\t\t\tprivate static double[][] combine(double[][] container, double[][] containerRight) {\n\t\t\t\treturn new double[container.length + containerRight.length][];\n\t\t\t}\n\t\t}\n\t}\n     public static void main(String [] args) {\n         System.out.println(\"OK\");\n     }\n}\n"}, "OK");
    }

    public void _test432682() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.Optional;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tOptional<String> userName = Optional.of(\"sa\");\n\t\tOptional<String> password = Optional.of(\"sa\");\n\t\tboolean isValid = userName.flatMap(u -> {\n\t\t\treturn password.map(p -> {\n\t\t\t\treturn u.equals(\"sa\") && p.equals(\"sa\");\n\t\t\t});\n\t\t}).orElse(false);\n\t\tSystem.out.println(isValid);\n\t}\n}\n"}, "OK");
    }

    public void test432520() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void withProvider(Provider<String> provider) { }\n\tpublic static void main(String [] args) {\n\t\twithProvider(() -> \"user\");\n\t}\n}\ninterface ParentProvider<T> {\n\tT get();\n}\n// if you remove the extends clause everything works fine\ninterface Provider<T> extends ParentProvider<T> {\n\tT get();\n}\n"}, "");
    }

    public void test432625() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\npublic class X {\n    public static void main(String[] args) {\n        Stream<?> stream = Stream.of(\"A\");\n        stream.map(x -> (String) x);\n    }\n}\n"}, "");
    }

    public void test430766() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Comparator;\nimport java.util.List;\npublic class X {\n\tstatic class Person {\n\t\tprivate String email;\n\t\tpublic Person(String email) {\n\t\t\tthis.email = email;\n\t\t}\n\t\tpublic String getEmail() {\n\t\t\treturn email;\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tList<Person> persons = new ArrayList<Person>();\n\t\tpersons.add(new Person(\"joe.smith@gmail.com\"));\n\t\tpersons.add(new Person(\"alice.smith@gmail.com\"));\n\t\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::getEmail)));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::getEmail)));\n\t                                             ^^^^^^^^^\nThe method nullsLast(Comparator<? super T>) in the type Comparator is not applicable for the arguments (Person::getEmail)\n----------\n2. ERROR in X.java (at line 17)\n\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::getEmail)));\n\t                                                       ^^^^^^^^^^^^^^^^\nThe type X.Person does not define getEmail(T, T) that is applicable here\n----------\n");
    }

    public void test430766a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Comparator;\nimport java.util.List;\nimport java.io.Serializable;\npublic class X {\n\tstatic class Person {\n\t\tprivate String email;\n\t\tpublic Person(String email) {\n\t\t\tthis.email = email;\n\t\t}\n\t\tpublic String getEmail() {\n\t\t\treturn email;\t\t}\n\tpublic static <T extends Runnable,V extends Serializable> int isRunnable(T first, V second) {\n\t\treturn (second instanceof Runnable) ? 1 : 0;\n\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tList<Person> persons = new ArrayList<Person>();\n\t\tpersons.add(new Person(\"joe.smith@gmail.com\"));\n\t\tpersons.add(new Person(\"alice.smith@gmail.com\"));\n\t\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::<Runnable>isRunnable)));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::<Runnable>isRunnable)));\n\t                                             ^^^^^^^^^\nThe method nullsLast(Comparator<? super T>) in the type Comparator is not applicable for the arguments (Person::<Runnable>isRunnable)\n----------\n2. ERROR in X.java (at line 21)\n\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::<Runnable>isRunnable)));\n\t                                                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type X.Person does not define isRunnable(T, T) that is applicable here\n----------\n");
    }

    public void test431190() throws Exception {
        this.runConformTest(new String[]{"Java8VerifyError.java", "public class Java8VerifyError {\n    public static class Foo {\n        public Object get() {\n            return new Object();\n        }\n    }\n    @FunctionalInterface\n    public static interface Provider<T> {\n        public T get();\n    }\n    public static void main(String[] args) {\n        Provider<Foo> f = () -> new Foo();\n        Provider<Provider<Object>> meta = () -> f.get()::get;\n    }\n}\n"}, "");
    }

    public void test431514() {
        this.runConformTest(new String[]{"X.java", "class X {\n\tvoid fun1(int x) {\n\t\tclass Local {\n\t\t\tFI test= () -> {\n\t\t\t\ttry {\n\t\t\t\t} catch (Exception e) {\n\t\t\t\t\tint x;\n\t\t\t\t};\n\t\t\t};\n\t\t}\n\t}\n}\ninterface FI {\n\tvoid foo();\n}"});
    }

    public void test431514a() {
        this.runConformTest(new String[]{"X.java", "class X {\n\tvoid fun1(int x) {\n\t\tclass Local {\n\t\t\tclass L1 { }\n\t\t\tint y;\n\t\t\tFI test= () -> {\n\t\t\t\tclass L1 { } \n\t\t\t\tint y; \n\t\t\t};\n\t\t}\n\t}\n\t\n}\ninterface FI {\n\tvoid foo();\n}"});
    }

    public void test432531() {
        this.runConformTest(new String[]{"Y.java", "import java.util.function.Supplier;\nclass E {\n\tE(Supplier<Object> factory) { }\n}\npublic class Y extends E {\n\tY() {\n\t\tsuper(() -> new Object() {\n\t\t});\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Y();\n\t}\n}"});
    }

    public void test432531a() {
        this.runConformTest(new String[]{"Y.java", "import java.util.function.Supplier;\nclass E {\n\tE(Supplier<Object> factory) { }\n}\npublic class Y extends E {\n\tY() {\n\t\tsuper( () -> {\n\t\t\tclass Z extends E {\n\t\t\t\tZ() {\n\t\t\t\t\tsuper(() -> new Object());\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn new Z();\n\t\t\t});\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Y();\n\t}\n}"});
    }

    public void test434297() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n  }\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    List<String> c1 = new ArrayList<>();\n    Collections.sort(c1, b ? null : new Bar(new ArrayList<>(),Comparator.nullsLast((a,e) -> {return 0;})));\n  }\n  private static class Bar implements Comparator<String>{\n\t  public <T> Bar(Collection<T> col, Comparator<T> comp) { }\n\t@Override\n\tpublic int compare(String o1, String o2) {\n\t\treturn 0;\n\t}\n  }\n}"});
    }

    public void test436542() throws Exception {
        String jreDirectory = org.eclipse.jdt.core.tests.util.Util.getJREDirectory();
        String jfxJar = org.eclipse.jdt.core.tests.util.Util.toNativePath(String.valueOf(jreDirectory) + "/lib/ext/jfxrt.jar");
        this.runConformTest(new String[]{"Utility.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\nimport javafx.collections.ListChangeListener;\nimport javafx.collections.ObservableList;\npublic class Utility {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Success\");\n\t}\n    public static <T, R> List<R> mapList(Collection<T> original, Function<T, R> func) {\n        return original.stream().map(func).collect(Collectors.toList());\n    }\n    /**\n     * \"Binds\" the destination list to the observable source list with a transformation function applied.\n     * Whenever the source list changes, the destination list is altered to match by applying\n     * the given function to each element in the source list.\n     */\n    public static <S, T> void bindMap(List<T> dest, ObservableList<S> src, Function<S, T> func) {\n        dest.clear();\n        dest.addAll(mapList(src, func));\n        src.addListener((ListChangeListener<S>) changes -> {\n            while (changes.next()) {\n                if (changes.wasPermutated() || changes.wasUpdated()) {\n                    // Same code for updated, replaced and permutation, just recalc the range:\n                    for (int i = changes.getFrom(); i < changes.getTo(); i++)\n                        dest.set(i, func.apply(src.get(i)));\n                } else {\n                    for (int i = 0; i < changes.getRemovedSize(); i++)\n                        dest.remove(changes.getFrom());\n                    for (int i = 0; i < changes.getAddedSubList().size();i++)\n                        dest.add(i + changes.getFrom(), func.apply(changes.getAddedSubList().get(i)));\n                }\n            }\n        });\n    }\n}"}, "Success", org.eclipse.jdt.core.tests.util.Util.concatWithClassLibs(new String[]{jfxJar, OUTPUT_DIR}, false), true, null);
        IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((String)(String.valueOf(OUTPUT_DIR) + File.separator + "Utility.class"), (int)65535);
        IMethodInfo lambdaMethod = null;
        IMethodInfo[] methodInfos = classFileReader.getMethodInfos();
        int length = methodInfos.length;
        int i = 0;
        while (i < length) {
            IMethodInfo methodInfo = methodInfos[i];
            if ("lambda$0".equals(new String(methodInfo.getName()))) {
                lambdaMethod = methodInfo;
                break;
            }
            ++i;
        }
        LambdaExpressionsTest.assertNotNull((String)"Could not find lambda method", lambdaMethod);
        IClassFileAttribute signature = Util.getAttribute(lambdaMethod, (char[])IAttributeNamesConstants.SIGNATURE);
        LambdaExpressionsTest.assertNull((String)"Found generic signature for lambda method", (Object)signature);
    }

    public void test440152() {
        this.runConformTest(new String[]{"Foo.java", "import java.util.function.Function;\ninterface Foo {void alpha(Bar pBar);}\nclass Bar {Object bravo() {return null;}}\nclass Test {\n  Test(Function pFunction) {\n    class Baz {public Baz(Object pObj) {pFunction.apply(pObj);}}\n    delta(pBar -> charlie(new Baz(pBar.bravo())));\n  }\n  void charlie(Object pRemovals) {}\n  void delta(Foo pListener) {}\n}"});
    }

    public void test440152a() {
        this.runConformTest(new String[]{"Foo.java", "import java.util.function.Function;\ninterface Foo {void alpha(Bar pBar);}\nclass Bar {Object bravo() {return null;}}\nclass Test {\n\tTest(Function pFunction) {\n\t    class Baz {\n\t    \tpublic Baz(Object pObj) {\n\t    \t}\n\t    \tclass NestedBaz extends Baz {\n\t    \t\tNestedBaz(Object pObj) {\n\t    \t\t\tsuper(pObj);\n\t    \t\t\tpFunction.apply(pObj);\n\t    \t\t}\n\t    \t}\n\t    \t}\n\t    delta(pBar -> charlie(new Baz(pBar).new NestedBaz(pBar.bravo())));\n\t  }\n\t  void charlie(Object pRemovals) {}\n\t  void delta(Foo pListener) {}\n}\n"});
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.LambdaExpressionsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

