/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class NonFatalErrorTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public NonFatalErrorTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NonFatalErrorTest.buildAllCompliancesTestSuite(NonFatalErrorTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.NonFatalErrorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 1)\n\timport java.util.*;\n\t       ^^^^^^^^^\nThe import java.util is never used\n----------\n", "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test002() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 1)\n\timport java.util.*;\n\t       ^^^^^^^^^\nThe import java.util is never used\n----------\n", "", "java.lang.Error: Unresolved compilation problem: \n\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(\"SUCCESS\");\n\t                   ^^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test004() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\t public static void foo() {}\n\t\t public static void main(String argv[]) {\n\t\t\t\tfoo();\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void foo() {}\n\t                         ^^\nEmpty block should be documented\n----------\n", "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\t public static void foo() {}\n\t\t public static void main(String argv[]) {\n\t\t\t\tfoo();\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void foo() {}\n\t                         ^^\nEmpty block should be documented\n----------\n", "", "java.lang.Error: Unresolved compilation problem: \n\tEmpty block should be documented\n\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t{     }\n\tstatic {  }\n \tX() { }\n \tX(int a) {}\n \tpublic void foo() {}\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\t{     }\n\t^^^^^^^\nEmpty block should be documented\n----------\n2. ERROR in X.java (at line 3)\n\tstatic {  }\n\t       ^^^^\nEmpty block should be documented\n----------\n3. ERROR in X.java (at line 5)\n\tX(int a) {}\n\t         ^^\nEmpty block should be documented\n----------\n4. ERROR in X.java (at line 6)\n\tpublic void foo() {}\n\t                  ^^\nEmpty block should be documented\n----------\n", "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n        @SuppressWarnings(\"unused\")\n        static void foo() {\n            String s = null;\n            System.out.println(\"SUCCESS\");\n        }\n        public static void main(String argv[]) {\n            foo();\n        }\n}"}, "SUCCESS", null, true, null, customOptions, null);
    }
}

