/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class NumericTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public NumericTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NumericTest.buildAllCompliancesTestSuite(NumericTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p/B.java", "package p;\npublic class B {\n  public static void main(String[] args) {\n    int offset = -8;\n    int temp = 0 - offset;\n    offset = 0 - offset;  // This is the problem line\n    System.out.println(\"offset: \" + offset);\n    System.out.println(\"temp: \" + temp);\n    if (offset != temp ) {\n      System.err.println(\"offset (\" + offset + \") should be equal to temp (\" + temp + \").\");\n      System.exit(-1);\n    }\n  }\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"p/Y.java", "package p;\npublic class Y {\n  public static void main(String[] args) {\n    int clockend = 0;\n    clockend += 128;\n    if(clockend < 0) {\n      System.out.println(clockend);\n      System.exit(-1);\n    }\n  }\n}\n"});
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  int i1 = -2147483648;\n  int i2 = -(2147483648);\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i2 = -(2147483648);\n\t          ^^^^^^^^^^^^\nThe literal 2147483648 of type int is out of range \n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  long l1 = -9223372036854775808L;\n  long l2 = -(9223372036854775808L);\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tlong l2 = -(9223372036854775808L);\n\t           ^^^^^^^^^^^^^^^^^^^^^^\nThe literal 9223372036854775808L of type long is out of range \n----------\n");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint result;\n\t\tif (130 != (result = testShort1())) System.out.println(\"failed-testShort1():\" + result);\n\t\tif (130 != (result = testShort2())) System.out.println(\"failed-testShort2():\" + result);\n\t\tif (130 != (result = testInt1())) System.out.println(\"failed-testInt1():\" + result);\n\t\tif (130 != (result = testInt2())) System.out.println(\"failed-testInt2():\" + result);\n\t\tif (30 != (result = testByte1())) System.out.println(\"failed-testByte1():\" + result);\n\t\tif (30 != (result = testByte2())) System.out.println(\"failed-testByte2():\" + result);\n\t\tSystem.out.println(\"done\");\n\t}\n\tstatic int testShort1() {\n\t\tshort min = Short.MIN_VALUE;\n\t\tint num = -32638;\n\t\treturn num = num - min;\n\t}\n\tstatic int testShort2() {\n\t\tfinal short min = Short.MIN_VALUE;\n\t\tint num = -32638;\n\t\treturn num = num - min;\n\t}\n\tstatic int testInt1() {\n\t\tshort min = Short.MIN_VALUE;\n\t\tint num = -32638;\n\t\treturn num = num - min;\n\t}\n\tstatic int testInt2() {\n\t\tfinal short min = Short.MIN_VALUE;\n\t\tint num = -32638;\n\t\treturn num = num - min;\n\t}\t\n\tstatic int testByte1() {\n\t\tbyte min = Byte.MIN_VALUE;\n\t\tint num = -98;\n\t\treturn num = num - min;\n\t}\n\tstatic int testByte2() {\n\t\tfinal byte min = Byte.MIN_VALUE;\n\t\tint num = -98;\n\t\treturn num = num - min;\n\t}\t\t\n}\n"}, "done");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.NumericTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

