/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.dom;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class StandAloneASTParserTest
extends AbstractRegressionTest {
    private static final int JLS_LATEST = 8;

    public StandAloneASTParserTest(String name) {
        super(name);
    }

    public ASTNode runConversion(int astLevel, String source, boolean resolveBindings, boolean statementsRecovery, boolean bindingsRecovery, String unitName) {
        ASTParser parser = ASTParser.newParser((int)astLevel);
        parser.setSource(source.toCharArray());
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(resolveBindings);
        parser.setStatementsRecovery(statementsRecovery);
        parser.setBindingsRecovery(bindingsRecovery);
        parser.setCompilerOptions(this.getCompilerOptions());
        parser.setUnitName(unitName);
        return parser.createAST(null);
    }

    public void test1() {
        String contents = "package p;\npublic class X {\n\tpublic int i;\n\tpublic static void main(String[] args) {\n\t\tint length = args.length;\n\t\tSystem.out.println(length);\n\t}\n}";
        ASTNode node = this.runConversion(8, contents, true, true, true, "p/X.java");
        StandAloneASTParserTest.assertTrue((String)"Should be a compilation unit", (boolean)(node instanceof CompilationUnit));
        CompilationUnit unit = (CompilationUnit)node;
        List types = unit.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding binding = typeDeclaration.resolveBinding();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)binding);
        StandAloneASTParserTest.assertNull((String)"Got a java element", (Object)binding.getJavaElement());
        StandAloneASTParserTest.assertEquals("Wrong name", "p.X", binding.getQualifiedName());
        MethodDeclaration methodDeclaration = (MethodDeclaration)typeDeclaration.bodyDeclarations().get(1);
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)methodBinding);
        StandAloneASTParserTest.assertNull((String)"Got a java element", (Object)methodBinding.getJavaElement());
        Block body = methodDeclaration.getBody();
        VariableDeclarationStatement statement = (VariableDeclarationStatement)body.statements().get(0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)statement.fragments().get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)variableBinding);
        StandAloneASTParserTest.assertNull((String)"Got a java element", (Object)variableBinding.getJavaElement());
        ExpressionStatement statement2 = (ExpressionStatement)body.statements().get(1);
        Expression expression = statement2.getExpression();
        MethodInvocation invocation = (MethodInvocation)expression;
        Expression expression2 = invocation.getExpression();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)expression2.resolveTypeBinding());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)typeDeclaration.bodyDeclarations().get(0);
        VariableDeclarationFragment fragment2 = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        IVariableBinding variableBinding2 = fragment2.resolveBinding();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)variableBinding2);
        StandAloneASTParserTest.assertNull((String)"Got a java element", (Object)variableBinding2.getJavaElement());
    }

    public void test2() {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setCompilerOptions(this.getCompilerOptions());
        final IBinding[] bindings = new IBinding[1];
        FileASTRequestor requestor = new FileASTRequestor(){

            public void acceptBinding(String bindingKey, IBinding binding) {
                if ("Ljava/lang/String;".equals(bindingKey)) {
                    bindings[0] = binding;
                }
            }
        };
        parser.createASTs(new String[0], null, new String[]{"Ljava/lang/String;"}, requestor, null);
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)bindings[0]);
        StandAloneASTParserTest.assertEquals((String)"Wrong type of binding", (int)2, (int)bindings[0].getKind());
        ITypeBinding typeBinding = (ITypeBinding)bindings[0];
        StandAloneASTParserTest.assertEquals("Wrong binding", "java.lang.String", typeBinding.getQualifiedName());
        StandAloneASTParserTest.assertNull((String)"No java element", (Object)typeBinding.getJavaElement());
    }

    public void test3() throws IOException {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setCompilerOptions(this.getCompilerOptions());
        final IBinding[] bindings = new IBinding[1];
        String contents = "package p;\npublic class X extends Y {\n\tpublic int i;\n\tpublic static void main(String[] args) {\n\t\tint length = args.length;\n\t\tSystem.out.println(length);\n\t}\n}";
        File packageDir = new File(rootDir, "p");
        packageDir.mkdir();
        File file = new File(packageDir, "X.java");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "package p;\npublic class Y {}";
        File fileY = new File(packageDir, "Y.java");
        Writer writer2 = null;
        try {
            writer2 = new BufferedWriter(new FileWriter(fileY));
            writer2.write(contents2);
        }
        catch (Throwable throwable) {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer2 != null) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            final String canonicalPath = file.getCanonicalPath();
            final CompilationUnit[] units = new CompilationUnit[1];
            FileASTRequestor requestor = new FileASTRequestor(){

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("Lp/X;".equals(bindingKey)) {
                        bindings[0] = binding;
                    }
                }

                public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                    if (canonicalPath.equals(sourceFilePath)) {
                        units[0] = ast;
                    }
                }
            };
            parser.setEnvironment(null, new String[]{rootDir.getCanonicalPath()}, null, true);
            parser.createASTs(new String[]{canonicalPath}, null, new String[]{"Lp/X;"}, requestor, null);
            StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)bindings[0]);
            StandAloneASTParserTest.assertEquals((String)"Wrong type of binding", (int)2, (int)bindings[0].getKind());
            ITypeBinding typeBinding = (ITypeBinding)bindings[0];
            StandAloneASTParserTest.assertEquals("Wrong binding", "p.X", typeBinding.getQualifiedName());
            StandAloneASTParserTest.assertNull((String)"No java element", (Object)typeBinding.getJavaElement());
            StandAloneASTParserTest.assertNotNull((String)"No ast", (Object)units[0]);
            StandAloneASTParserTest.assertEquals((String)"No problem", (int)0, (int)units[0].getProblems().length);
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }

    public void test4() {
        ASTParser parser = ASTParser.newParser((int)8);
        try {
            parser.setEnvironment(null, null, new String[]{"UTF-8"}, true);
            StandAloneASTParserTest.assertTrue((String)"Should have failed", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void test5() {
        ASTParser parser = ASTParser.newParser((int)8);
        try {
            parser.setEnvironment(null, new String[0], new String[]{"UTF-8"}, true);
            StandAloneASTParserTest.assertTrue((String)"Should have failed", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void test6() throws IOException {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setCompilerOptions(this.getCompilerOptions());
        final IBinding[] bindings = new IBinding[2];
        String contents = "package p;\npublic class X extends Y {\n\tpublic int i;\n\tpublic static void main(String[] args) {\n\t\tint length = args.length;\n\t\tSystem.out.println(length);\n\t}\n}";
        File packageDir = new File(rootDir, "p");
        packageDir.mkdir();
        File file = new File(packageDir, "X.java");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "package p;\npublic class Y {}";
        File fileY = new File(packageDir, "Y.java");
        Writer writer2 = null;
        try {
            writer2 = new BufferedWriter(new FileWriter(fileY));
            writer2.write(contents2);
        }
        catch (Throwable throwable) {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer2 != null) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            final String canonicalPath = file.getCanonicalPath();
            final CompilationUnit[] units = new CompilationUnit[1];
            FileASTRequestor requestor = new FileASTRequestor(){

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("Lp/X;".equals(bindingKey)) {
                        bindings[0] = binding;
                        IBinding[] temp = this.createBindings(new String[]{"Ljava/lang/Object;"});
                        int i = 0;
                        while (i < temp.length) {
                            bindings[i + 1] = temp[i];
                            ++i;
                        }
                    }
                }

                public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                    if (canonicalPath.equals(sourceFilePath)) {
                        units[0] = ast;
                    }
                }
            };
            parser.setEnvironment(null, new String[]{rootDir.getCanonicalPath()}, null, true);
            parser.createASTs(new String[]{canonicalPath}, null, new String[]{"Lp/X;"}, requestor, null);
            StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)bindings[0]);
            StandAloneASTParserTest.assertEquals((String)"Wrong type of binding", (int)2, (int)bindings[0].getKind());
            ITypeBinding typeBinding = (ITypeBinding)bindings[0];
            StandAloneASTParserTest.assertEquals("Wrong binding", "p.X", typeBinding.getQualifiedName());
            StandAloneASTParserTest.assertNull((String)"No java element", (Object)typeBinding.getJavaElement());
            IPackageBinding packageBinding = typeBinding.getPackage();
            StandAloneASTParserTest.assertNull((String)"No java element", (Object)packageBinding.getJavaElement());
            StandAloneASTParserTest.assertNotNull((String)"No ast", (Object)units[0]);
            StandAloneASTParserTest.assertEquals((String)"No problem", (int)0, (int)units[0].getProblems().length);
            StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)bindings[1]);
            StandAloneASTParserTest.assertEquals((String)"Wrong type of binding", (int)2, (int)bindings[1].getKind());
            typeBinding = (ITypeBinding)bindings[1];
            StandAloneASTParserTest.assertEquals("Wrong binding", "java.lang.Object", typeBinding.getQualifiedName());
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }

    public void test7() throws IOException {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        String contents = "enum X {\n              /** */\n    FOO\n}";
        File file = new File(rootDir, "X.java");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "package p;\nclass Y {}";
        File packageDir = new File(rootDir, "p");
        packageDir.mkdir();
        File fileY = new File(packageDir, "Y.java");
        Writer writer2 = null;
        try {
            writer2 = new BufferedWriter(new FileWriter(fileY));
            writer2.write(contents2);
        }
        catch (Throwable throwable) {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer2 != null) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setKind(8);
            parser.setCompilerOptions((Map)JavaCore.getOptions());
            parser.createASTs(new String[]{file.getCanonicalPath(), fileY.getCanonicalPath()}, null, new String[0], new FileASTRequestor(){}, null);
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }
}

