/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.junit.extension;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PerformanceTestSuite
extends TestSuite {
    static /* synthetic */ Class class$0;

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PerformanceTestSuite(Class theClass) {
        Class clazz;
        this.setName(theClass.getName());
        try {
            PerformanceTestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.addTest(PerformanceTestSuite.addWarningTest("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(PerformanceTestSuite.addWarningTest("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Method[] methods = superClass.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    this.addTestMethod(methods[i], names, theClass);
                    ++i;
                }
                superClass = superClass.getSuperclass();
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("junit.framework.Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(superClass));
        if (this.countTestCases() == 0) {
            this.addTest(PerformanceTestSuite.addWarningTest("No tests found in " + theClass.getName()));
        }
    }

    public PerformanceTestSuite(String name) {
        this.setName(name);
    }

    private void addTestMethod(Method m, Vector names, Class theClass) {
        String name = m.getName();
        if (names.contains(name)) {
            return;
        }
        if (!this.isPublicTestMethod(m)) {
            if (this.isTestMethod(m)) {
                this.addTest(PerformanceTestSuite.addWarningTest("Test method isn't public: " + m.getName()));
            }
            return;
        }
        names.addElement(name);
        this.addTest(PerformanceTestSuite.createTest((Class)theClass, (String)name));
    }

    public void addTestSuite(Class theClass) {
        this.addTest((Test)new PerformanceTestSuite(theClass));
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("testPerf") && returnType.equals(Void.TYPE);
    }

    private static Test addWarningTest(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)message);
            }
        };
    }
}

