/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.util.Util;

public class TestVerifier {
    public String failureReason;
    boolean reuseVM = true;
    String[] classpathCache;
    LocalVirtualMachine vm;
    StringBuffer outputBuffer;
    StringBuffer errorBuffer;
    Socket socket;
    static /* synthetic */ Class class$0;

    public TestVerifier(boolean reuseVM) {
        this.reuseVM = reuseVM;
    }

    private boolean checkBuffers(String outputString, String errorString, String sourceFileName, String expectedOutputString, String expectedErrorStringStart) {
        String platformIndependantString;
        boolean didMatchExpectation = true;
        this.failureReason = null;
        if (expectedOutputString != null) {
            platformIndependantString = Util.convertToIndependantLineDelimiter(outputString.trim());
            if (!Util.convertToIndependantLineDelimiter(expectedOutputString).equals(platformIndependantString)) {
                System.out.println(Util.displayString(platformIndependantString, 2));
                this.failureReason = "Unexpected output running resulting class file for " + sourceFileName + ":\n" + "--[START]--\n" + outputString + "---[END]---\n";
                didMatchExpectation = false;
            }
        }
        String trimmedErrorString = errorString.trim();
        if (expectedErrorStringStart != null) {
            platformIndependantString = Util.convertToIndependantLineDelimiter(trimmedErrorString);
            if (expectedErrorStringStart.length() == 0 && platformIndependantString.length() > 0 || !platformIndependantString.startsWith(Util.convertToIndependantLineDelimiter(expectedErrorStringStart))) {
                System.out.println(Util.displayString(platformIndependantString, 2));
                this.failureReason = "Unexpected error running resulting class file for " + sourceFileName + ":\n" + "--[START]--\n" + errorString + "---[END]---\n";
                didMatchExpectation = false;
            }
        } else if (trimmedErrorString.length() != 0) {
            platformIndependantString = Util.convertToIndependantLineDelimiter(trimmedErrorString);
            System.out.println(Util.displayString(platformIndependantString, 2));
            this.failureReason = "Unexpected error running resulting class file for " + sourceFileName + ":\n" + "--[START]--\n" + errorString + "---[END]---\n";
            didMatchExpectation = false;
        }
        return didMatchExpectation;
    }

    private boolean checkBuffersThrowingError(String errorString, String sourceFileName, String expectedSuccessOutputString) {
        if (errorString.length() > 0 && errorString.indexOf(expectedSuccessOutputString) != -1) {
            return true;
        }
        this.failureReason = "Expected error not thrown for " + sourceFileName + ":\n" + expectedSuccessOutputString;
        return false;
    }

    private void compileVerifyTests(String verifierDir) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.util.VerifyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String fullyQualifiedName = clazz.getName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        String packageName = fullyQualifiedName.substring(0, lastDot);
        String simpleName = fullyQualifiedName.substring(lastDot + 1);
        String dirName = String.valueOf(verifierDir.replace('\\', '/')) + "/" + packageName.replace('.', '/');
        File dir = new File(dirName.replace('/', File.separatorChar));
        if (!dir.exists() && !dir.mkdirs()) {
            System.out.println("Could not create " + dir);
            return;
        }
        String fileName = dir + File.separator + simpleName + ".java";
        Util.writeToFile(this.getVerifyTestsCode(), fileName);
        BatchCompiler.compile((String)("\"" + fileName + "\" -d \"" + verifierDir + "\" -warn:-resource -classpath \"" + Util.getJavaClassLibsAsString() + "\""), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null);
    }

    public void execute(String className, String[] classpaths) {
        this.outputBuffer = new StringBuffer();
        this.errorBuffer = new StringBuffer();
        this.launchAndRun(className, classpaths, null, null);
    }

    protected void finalize() throws Throwable {
        this.shutDown();
    }

    public String getExecutionOutput() {
        return this.outputBuffer.toString();
    }

    public String getExecutionError() {
        return this.errorBuffer.toString();
    }

    private String getVerifyTestsCode() {
        return "/*******************************************************************************\n * Copyright (c) 2000, 2011 IBM Corporation and others.\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * which accompanies this distribution, and is available at\n * http://www.eclipse.org/legal/epl-v10.html\n *\n * Contributors:\n *     IBM Corporation - initial API and implementation\n *******************************************************************************/\npackage org.eclipse.jdt.core.tests.util;\n\nimport java.io.DataInputStream;\nimport java.io.DataOutputStream;\nimport java.io.File;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.lang.reflect.InvocationTargetException;\nimport java.lang.reflect.Method;\nimport java.net.ServerSocket;\nimport java.net.Socket;\nimport java.util.StringTokenizer;\n\n/******************************************************\n *\n * IMPORTANT NOTE: If modifying this class, copy the source to TestVerifier#getVerifyTestsCode()\n * (see this method for details)\n *\n ******************************************************/\n\npublic class VerifyTests {\n\tint portNumber;\n\tSocket socket;\n\n/**\n * NOTE: Code copied from junit.util.TestCaseClassLoader.\n *\n * A custom class loader which enables the reloading\n * of classes for each test run. The class loader\n * can be configured with a list of package paths that\n * should be excluded from loading. The loading\n * of these packages is delegated to the system class\n * loader. They will be shared across test runs.\n * <p>\n * The list of excluded package paths is specified in\n * a properties file \"excluded.properties\" that is located in\n * the same place as the TestCaseClassLoader class.\n * <p>\n * <b>Known limitation:</b> the VerifyClassLoader cannot load classes\n * from jar files.\n */\n\n\npublic class VerifyClassLoader extends ClassLoader {\n\t/** scanned class path */\n\tprivate String[] pathItems;\n\n\t/** excluded paths */\n\tprivate String[] excluded= {};\n\n\t/**\n\t * Constructs a VerifyClassLoader. It scans the class path\n\t * and the excluded package paths\n\t */\n\tpublic VerifyClassLoader() {\n\t\tsuper();\n\t\tString classPath= System.getProperty(\"java.class.path\");\n\t\tString separator= System.getProperty(\"path.separator\");\n\n\t\t// first pass: count elements\n\t\tStringTokenizer st= new StringTokenizer(classPath, separator);\n\t\tint i= 0;\n\t\twhile (st.hasMoreTokens()) {\n\t\t\tst.nextToken();\n\t\t\ti++;\n\t\t}\n\t\t// second pass: split\n\t\tthis.pathItems= new String[i];\n\t\tst= new StringTokenizer(classPath, separator);\n\t\ti= 0;\n\t\twhile (st.hasMoreTokens()) {\n\t\t\tthis.pathItems[i++]= st.nextToken();\n\t\t}\n\n\t}\n\tpublic java.net.URL getResource(String name) {\n\t\treturn ClassLoader.getSystemResource(name);\n\t}\n\tpublic InputStream getResourceAsStream(String name) {\n\t\treturn ClassLoader.getSystemResourceAsStream(name);\n\t}\n\tprotected boolean isExcluded(String name) {\n\t\t// exclude the \"java\" packages.\n\t\t// They always need to be excluded so that they are loaded by the system class loader\n\t\tif (name.startsWith(\"java\") || name.startsWith(\"[Ljava\"))\n\t\t\treturn true;\n\n\t\t// exclude the user defined package paths\n\t\tfor (int i= 0; i < this.excluded.length; i++) {\n\t\t\tif (name.startsWith(this.excluded[i])) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\tpublic synchronized Class loadClass(String name, boolean resolve)\n\t\tthrows ClassNotFoundException {\n\n\t\tClass c= findLoadedClass(name);\n\t\tif (c != null)\n\t\t\treturn c;\n\t\t//\n\t\t// Delegate the loading of excluded classes to the\n\t\t// standard class loader.\n\t\t//\n\t\tif (isExcluded(name)) {\n\t\t\ttry {\n\t\t\t\tc= findSystemClass(name);\n\t\t\t\treturn c;\n\t\t\t} catch (ClassNotFoundException e) {\n\t\t\t\t// keep searching\n\t\t\t}\n\t\t}\n\t\tFile file= locate(name);\n\t\tif (file == null)\n\t\t\tthrow new ClassNotFoundException();\n\t\tbyte data[]= loadClassData(file);\n\t\tc= defineClass(name, data, 0, data.length);\n\t\tif (resolve)\n\t\t\tresolveClass(c);\n\t\treturn c;\n\t}\n\tprivate byte[] loadClassData(File f) throws ClassNotFoundException {\n\t\tFileInputStream stream = null;\n\t\ttry {\n\t\t\t//System.out.println(\"loading: \"+f.getPath());\n\t\t\tstream = new FileInputStream(f);\n\n\t\t\ttry {\n\t\t\t\tbyte[] b= new byte[stream.available()];\n\t\t\t\tstream.read(b);\n\t\t\t\treturn b;\n\t\t\t}\n\t\t\tcatch (IOException e) {\n\t\t\t\tthrow new ClassNotFoundException();\n\t\t\t}\n\t\t}\n\t\tcatch (FileNotFoundException e) {\n\t\t\tthrow new ClassNotFoundException();\n\t\t} finally {\n\t\t\tif (stream != null) {\n\t\t\t\ttry {\n\t\t\t\t\tstream.close();\n\t\t\t\t} catch (IOException e) {\n\t\t\t\t\t/* ignore */\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\t/**\n\t * Locate the given file.\n\t * @return Returns null if file couldn't be found.\n\t */\n\tprivate File locate(String fileName) {\n\t\tif (fileName != null) {\n\t\t\tfileName= fileName.replace('.', '/')+\".class\";\n\t\t\tFile path= null;\n\t\t\tfor (int i= 0; i < this.pathItems.length; i++) {\n\t\t\t\tpath= new File(this.pathItems[i], fileName);\n\t\t\t\tif (path.exists())\n\t\t\t\t\treturn path;\n\t\t\t}\n\t\t}\n\t\treturn null;\n\t}\n}\n\npublic void loadAndRun(String className) throws Throwable {\n\t//System.out.println(\"Loading \" + className + \"...\");\n\tClass testClass = new VerifyClassLoader().loadClass(className);\n\t//System.out.println(\"Loaded \" + className);\n\ttry {\n\t\tMethod main = testClass.getMethod(\"main\", new Class[] {String[].class});\n\t\t//System.out.println(\"Running \" + className);\n\t\tmain.invoke(null, new Object[] {new String[] {}});\n\t\t//System.out.println(\"Finished running \" + className);\n\t} catch (NoSuchMethodException e) {\n\t\treturn;\n\t} catch (InvocationTargetException e) {\n\t\tthrow e.getTargetException();\n\t}\n}\npublic static void main(String[] args) throws IOException {\n\tVerifyTests verify = new VerifyTests();\n\tverify.portNumber = Integer.parseInt(args[0]);\n\tverify.run();\n}\npublic void run() throws IOException {\n\tServerSocket server = new ServerSocket(this.portNumber);\n\tthis.socket = server.accept();\n\tthis.socket.setTcpNoDelay(true);\n\tserver.close();\n\n\tDataInputStream in = new DataInputStream(this.socket.getInputStream());\n\tfinal DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());\n\twhile (true) {\n\t\tfinal String className = in.readUTF();\n\t\tThread thread = new Thread() {\n\t\t\tpublic void run() {\n\t\t\t\ttry {\n\t\t\t\t\tloadAndRun(className);\n\t\t\t\t\tout.writeBoolean(true);\n\t\t\t\t\tSystem.err.println(VerifyTests.class.getName());\n\t\t\t\t\tSystem.out.println(VerifyTests.class.getName());\n\t\t\t\t} catch (Throwable e) {\n\t\t\t\t\te.printStackTrace();\n\t\t\t\t\ttry {\n\t\t\t\t\t\tSystem.err.println(VerifyTests.class.getName());\n\t\t\t\t\t\tSystem.out.println(VerifyTests.class.getName());\n\t\t\t\t\t\tout.writeBoolean(false);\n\t\t\t\t\t} catch (IOException e1) {\n\t\t\t\t\t\te1.printStackTrace();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\ttry {\n\t\t\t\t\tout.flush();\n\t\t\t\t} catch (IOException e) {\n\t\t\t\t\te.printStackTrace();\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t\tthread.start();\n\t}\n}\n}";
    }

    private void launchAndRun(String className, String[] classpaths, String[] programArguments, String[] vmArguments) {
        Thread errorThread;
        Thread outputThread;
        if (this.vm != null) {
            try {
                this.vm.shutDown();
            }
            catch (TargetException targetException) {}
        }
        this.classpathCache = null;
        LocalVMLauncher launcher = LocalVMLauncher.getLauncher();
        launcher.setClassPath(classpaths);
        launcher.setVMPath(Util.getJREDirectory());
        if (vmArguments != null) {
            String[] completeVmArguments = new String[vmArguments.length + 1];
            System.arraycopy(vmArguments, 0, completeVmArguments, 1, vmArguments.length);
            completeVmArguments[0] = "-verify";
            launcher.setVMArguments(completeVmArguments);
        } else {
            launcher.setVMArguments(new String[]{"-verify"});
        }
        launcher.setProgramClass(className);
        launcher.setProgramArguments(programArguments);
        try {
            this.vm = launcher.launch();
            final InputStream input = this.vm.getInputStream();
            outputThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        int c = input.read();
                        while (c != -1) {
                            TestVerifier.this.outputBuffer.append((char)c);
                            c = input.read();
                        }
                    }
                    catch (IOException iOException) {}
                }
            });
            final InputStream errorStream = this.vm.getErrorStream();
            errorThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        int c = errorStream.read();
                        while (c != -1) {
                            TestVerifier.this.errorBuffer.append((char)c);
                            c = errorStream.read();
                        }
                    }
                    catch (IOException iOException) {}
                }
            });
            outputThread.start();
            errorThread.start();
        }
        catch (TargetException e) {
            throw new Error(e.getMessage());
        }
        try {
            outputThread.join(10000L);
            errorThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void launchVerifyTestsIfNeeded(String[] classpaths, String[] vmArguments) {
        Class<?> clazz;
        if (this.vm != null && this.vm.isRunning() && this.classpathCache != null && classpaths.length == this.classpathCache.length) {
            boolean sameClasspaths = true;
            int i = 0;
            while (i < classpaths.length) {
                if (!this.classpathCache[i].equals(classpaths[i])) {
                    sameClasspaths = false;
                    break;
                }
                ++i;
            }
            if (sameClasspaths) {
                return;
            }
        }
        if (this.vm != null) {
            try {
                this.vm.shutDown();
            }
            catch (TargetException targetException) {}
        }
        this.classpathCache = classpaths;
        LocalVMLauncher launcher = LocalVMLauncher.getLauncher();
        int length = classpaths.length;
        String[] cp = new String[length + 1];
        System.arraycopy(classpaths, 0, cp, 0, length);
        String verifierDir = String.valueOf(Util.getOutputDirectory()) + File.separator + "verifier";
        this.compileVerifyTests(verifierDir);
        cp[length] = verifierDir;
        launcher.setClassPath(cp);
        launcher.setVMPath(Util.getJREDirectory());
        if (vmArguments != null) {
            String[] completeVmArguments = new String[vmArguments.length + 1];
            System.arraycopy(vmArguments, 0, completeVmArguments, 1, vmArguments.length);
            completeVmArguments[0] = "-verify";
            launcher.setVMArguments(completeVmArguments);
        } else {
            launcher.setVMArguments(new String[]{"-verify"});
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.util.VerifyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        launcher.setProgramClass(clazz.getName());
        int portNumber = Util.getFreePort();
        launcher.setProgramArguments(new String[]{Integer.toString(portNumber)});
        try {
            this.vm = launcher.launch();
            final InputStream input = this.vm.getInputStream();
            Thread outputThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        int c = input.read();
                        while (c != -1) {
                            TestVerifier.this.outputBuffer.append((char)c);
                            c = input.read();
                        }
                    }
                    catch (IOException iOException) {}
                }
            });
            final InputStream errorStream = this.vm.getErrorStream();
            Thread errorThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        int c = errorStream.read();
                        while (c != -1) {
                            TestVerifier.this.errorBuffer.append((char)c);
                            c = errorStream.read();
                        }
                    }
                    catch (IOException iOException) {}
                }
            });
            outputThread.start();
            errorThread.start();
        }
        catch (TargetException e) {
            throw new Error(e.getMessage());
        }
        this.socket = null;
        boolean isVMRunning = false;
        do {
            try {
                this.socket = new Socket("localhost", portNumber);
                this.socket.setTcpNoDelay(true);
                break;
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (IOException iOException) {}
            if (this.socket != null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            isVMRunning = this.vm.isRunning();
        } while (this.socket == null && isVMRunning);
    }

    private boolean loadAndRun(String className) {
        if (this.socket != null) {
            try {
                DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
                out.writeUTF(className);
                DataInputStream in = new DataInputStream(this.socket.getInputStream());
                try {
                    boolean result = in.readBoolean();
                    this.waitForFullBuffers();
                    return result;
                }
                catch (SocketException socketException) {
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void shutDown() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.vm != null) {
            try {
                int retry = 0;
                while (this.vm.isRunning() && ++retry < 20) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.vm.isRunning()) {
                    this.vm.shutDown();
                }
            }
            catch (TargetException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean verifyClassFiles(String sourceFilePath, String className, String expectedSuccessOutputString, String[] classpaths) {
        return this.verifyClassFiles(sourceFilePath, className, expectedSuccessOutputString, "", classpaths, null, null);
    }

    public boolean verifyClassFiles(String sourceFilePath, String className, String expectedSuccessOutputString, String[] classpaths, String[] programArguments, String[] vmArguments) {
        return this.verifyClassFiles(sourceFilePath, className, expectedSuccessOutputString, "", classpaths, programArguments, vmArguments);
    }

    public boolean verifyClassFiles(String sourceFilePath, String className, String expectedOutputString, String expectedErrorStringStart, String[] classpaths, String[] programArguments, String[] vmArguments) {
        this.outputBuffer = new StringBuffer();
        this.errorBuffer = new StringBuffer();
        if (this.reuseVM && programArguments == null) {
            this.launchVerifyTestsIfNeeded(classpaths, vmArguments);
            this.loadAndRun(className);
        } else {
            this.launchAndRun(className, classpaths, programArguments, vmArguments);
        }
        this.failureReason = null;
        return this.checkBuffers(this.outputBuffer.toString(), this.errorBuffer.toString(), sourceFilePath, expectedOutputString, expectedErrorStringStart);
    }

    public boolean verifyClassFilesThrowingError(String sourceFilePath, String className, String expectedSuccessOutputString, String[] classpaths, String[] programArguments, String[] vmArguments) {
        this.outputBuffer = new StringBuffer();
        this.errorBuffer = new StringBuffer();
        if (this.reuseVM && programArguments == null) {
            this.launchVerifyTestsIfNeeded(classpaths, vmArguments);
            this.loadAndRun(className);
        } else {
            this.launchAndRun(className, classpaths, programArguments, vmArguments);
        }
        this.failureReason = null;
        return this.checkBuffersThrowingError(this.errorBuffer.toString(), sourceFilePath, expectedSuccessOutputString);
    }

    private void waitForFullBuffers() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.util.VerifyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String endString = clazz.getName();
        int count = 50;
        int errorEndStringStart = this.errorBuffer.toString().indexOf(endString);
        int outputEndStringStart = this.outputBuffer.toString().indexOf(endString);
        while (errorEndStringStart == -1 || outputEndStringStart == -1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (--count == 0) {
                return;
            }
            errorEndStringStart = this.errorBuffer.toString().indexOf(endString);
            outputEndStringStart = this.outputBuffer.toString().indexOf(endString);
        }
        this.errorBuffer.setLength(errorEndStringStart);
        this.outputBuffer.setLength(outputEndStringStart);
    }
}

