/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.tests.compiler.regression.Requestor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class Util {
    private static int DELETE_MAX_TIME;
    public static boolean DELETE_DEBUG;
    public static int DELETE_MAX_WAIT;
    private static final boolean DEBUG = false;
    private static final String OUTPUT_DIRECTORY;
    private static final String DELAY_BEFORE_CLEAN_PREVIOUS;

    static {
        File dir;
        String container;
        DELETE_MAX_TIME = 0;
        DELETE_DEBUG = false;
        DELETE_MAX_WAIT = 10000;
        DELAY_BEFORE_CLEAN_PREVIOUS = System.getProperty("delay");
        long millisecondsPerHour = 3600000L;
        long delay = millisecondsPerHour * 2L;
        try {
            if (DELAY_BEFORE_CLEAN_PREVIOUS != null) {
                float hours = Float.parseFloat(DELAY_BEFORE_CLEAN_PREVIOUS);
                delay = (int)((float)millisecondsPerHour * hours);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((container = System.getProperty("jdt.test.output_directory")) == null) {
            container = System.getProperty("java.io.tmpdir");
        }
        if (container == null) {
            container = ".";
        }
        if (Character.isLowerCase(container.charAt(0)) && container.charAt(1) == ':') {
            container = String.valueOf(Character.toUpperCase(container.charAt(0))) + container.substring(1);
        }
        if ((dir = new File(new File(container), "comptest")).exists()) {
            long now = System.currentTimeMillis();
            if (now - dir.lastModified() > delay) {
                Util.flushDirectoryContent(dir);
            } else {
                File[] testDirs = dir.listFiles();
                int i = 0;
                int l = testDirs.length;
                while (i < l) {
                    if (testDirs[i].isDirectory() && now - testDirs[i].lastModified() > delay) {
                        Util.delete(testDirs[i]);
                    }
                    ++i;
                }
            }
        }
        File dateDir = new File(dir, "run." + System.currentTimeMillis());
        String pathDir = null;
        try {
            pathDir = dateDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            pathDir = dateDir.getAbsolutePath();
        }
        OUTPUT_DIRECTORY = pathDir;
    }

    public static void appendProblem(StringBuffer problems, IProblem problem, char[] source, int problemCount) {
        problems.append(String.valueOf(problemCount) + (problem.isError() ? ". ERROR" : ". WARNING"));
        problems.append(" in " + new String(problem.getOriginatingFileName()));
        if (source != null) {
            problems.append(((DefaultProblem)problem).errorReportSource(source));
        }
        problems.append("\n");
        problems.append(problem.getMessage());
        problems.append("\n");
    }

    public static CompilationUnit[] compilationUnits(String[] testFiles) {
        int length = testFiles.length / 2;
        CompilationUnit[] result = new CompilationUnit[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            result[i] = new CompilationUnit(testFiles[index + 1].toCharArray(), testFiles[index], null);
            index += 2;
            ++i;
        }
        return result;
    }

    public static void compile(String[] pathsAndContents, Map options, String outputPath) {
        Util.compile(pathsAndContents, options, null, outputPath);
    }

    public static void compile(String[] pathsAndContents, Map options, String[] classpath, String outputPath) {
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        Requestor requestor = new Requestor(false, null, false, false);
        requestor.outputPath = outputPath.endsWith(File.separator) ? outputPath : String.valueOf(outputPath) + File.separator;
        String[] classLibs = Util.getJavaClassLibs();
        if (classpath != null) {
            int length = classpath.length;
            int classLibsLength = classLibs.length;
            String[] stringArray = classpath;
            classpath = new String[length + classLibsLength];
            System.arraycopy(stringArray, 0, classpath, 0, length);
            System.arraycopy(classLibs, 0, classpath, length, classLibsLength);
        } else {
            classpath = classLibs;
        }
        FileSystem nameEnvironment = new FileSystem(classpath, new String[0], null);
        IErrorHandlingPolicy errorHandlingPolicy = new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean ignoreAllErrors() {
                return false;
            }
        };
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.performMethodsFullRecovery = false;
        compilerOptions.performStatementsRecovery = false;
        Compiler batchCompiler = new Compiler((INameEnvironment)nameEnvironment, errorHandlingPolicy, compilerOptions, (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        batchCompiler.options.produceReferenceInfo = true;
        batchCompiler.compile((ICompilationUnit[])Util.compilationUnits(pathsAndContents));
        nameEnvironment.cleanup();
        if (requestor.hasErrors) {
            System.err.print(requestor.problemLog);
        }
    }

    public static String[] concatWithClassLibs(String[] classpaths, boolean inFront) {
        String[] classLibs = Util.getJavaClassLibs();
        if (classpaths == null) {
            return classLibs;
        }
        int classLibsLength = classLibs.length;
        int classpathsLength = classpaths.length;
        String[] defaultClassPaths = new String[classLibsLength + classpathsLength];
        if (inFront) {
            System.arraycopy(classLibs, 0, defaultClassPaths, classpathsLength, classLibsLength);
            System.arraycopy(classpaths, 0, defaultClassPaths, 0, classpathsLength);
        } else {
            System.arraycopy(classLibs, 0, defaultClassPaths, 0, classLibsLength);
            System.arraycopy(classpaths, 0, defaultClassPaths, classLibsLength, classpathsLength);
        }
        int i = 0;
        while (i < classpathsLength) {
            File file = new File(classpaths[i]);
            if (!file.exists()) {
                file.mkdirs();
            }
            ++i;
        }
        return defaultClassPaths;
    }

    public static String[] concatWithClassLibs(String classpath, boolean inFront) {
        String[] classLibs = Util.getJavaClassLibs();
        int length = classLibs.length;
        File dir = new File(classpath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String[] defaultClassPaths = new String[length + 1];
        if (inFront) {
            System.arraycopy(classLibs, 0, defaultClassPaths, 1, length);
            defaultClassPaths[0] = classpath;
        } else {
            System.arraycopy(classLibs, 0, defaultClassPaths, 0, length);
            defaultClassPaths[length] = classpath;
        }
        return defaultClassPaths;
    }

    public static String convertToIndependantLineDelimiter(String source) {
        if (source == null) {
            return "";
        }
        if (source.indexOf(10) == -1 && source.indexOf(13) == -1) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = source.length();
        while (i < length) {
            char car = source.charAt(i);
            if (car == '\r') {
                buffer.append('\n');
                if (i < length - 1 && source.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else {
                buffer.append(car);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void copy(String sourcePath, String destPath) {
        sourcePath = Util.toNativePath(sourcePath);
        destPath = Util.toNativePath(destPath);
        File source = new File(sourcePath);
        if (!source.exists()) {
            return;
        }
        File dest = new File(destPath);
        if (!dest.exists()) {
            return;
        }
        if (source.isDirectory()) {
            String[] files = source.list();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    String file = files[i];
                    File sourceFile = new File(source, file);
                    if (sourceFile.isDirectory()) {
                        File destSubDir = new File(dest, file);
                        destSubDir.mkdir();
                        Util.copy(sourceFile.getPath(), destSubDir.getPath());
                    } else {
                        Util.copy(sourceFile.getPath(), dest.getPath());
                    }
                    ++i;
                }
            }
        } else {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                try {
                    in = new FileInputStream(source);
                    File destFile = new File(dest, source.getName());
                    if (destFile.exists() && !Util.delete(destFile)) {
                        throw new IOException(destFile + " is in use");
                    }
                    out = new FileOutputStream(destFile);
                    int bufferLength = 1024;
                    byte[] buffer = new byte[bufferLength];
                    int read = 0;
                    while (read != -1) {
                        read = in.read(buffer, 0, bufferLength);
                        if (read == -1) continue;
                        out.write(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    throw new Error(e.toString());
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void createFile(String path, String contents) throws IOException {
        FileOutputStream output = new FileOutputStream(path);
        try {
            output.write(contents.getBytes());
        }
        finally {
            output.close();
        }
    }

    public static void createClassFolder(String[] pathsAndContents, String folderPath, String compliance) throws IOException {
        File classesDir = new File(folderPath);
        Util.flushDirectoryContent(classesDir);
        Util.compile(pathsAndContents, Util.getCompileOptions(compliance), folderPath);
    }

    public static void createEmptyJar(String jarPath, String compliance) throws IOException {
        Util.createJar(null, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\n"}, jarPath, null, compliance);
    }

    public static void createJar(String[] pathsAndContents, Map options, String jarPath) throws IOException {
        Util.createJar(pathsAndContents, null, options, null, jarPath);
    }

    public static void createJar(String[] pathsAndContents, String[] extraPathsAndContents, Map options, String[] classpath, String jarPath) throws IOException {
        String classesPath = String.valueOf(Util.getOutputDirectory()) + File.separator + "classes";
        File classesDir = new File(classesPath);
        Util.flushDirectoryContent(classesDir);
        if (pathsAndContents != null) {
            Util.compile(pathsAndContents, options, classpath, classesPath);
        }
        if (extraPathsAndContents != null) {
            int i = 0;
            int l = extraPathsAndContents == null ? 0 : extraPathsAndContents.length;
            while (i < l) {
                File outputFile = new File(classesPath, extraPathsAndContents[i++]);
                outputFile.getParentFile().mkdirs();
                Util.writeToFile(extraPathsAndContents[i++], outputFile.getAbsolutePath());
            }
        }
        Util.zip(classesDir, jarPath);
    }

    public static void createJar(String[] javaPathsAndContents, String jarPath, String compliance) throws IOException {
        Util.createJar(javaPathsAndContents, null, jarPath, compliance);
    }

    public static void createJar(String[] javaPathsAndContents, String[] extraPathsAndContents, String jarPath, String compliance) throws IOException {
        Util.createJar(javaPathsAndContents, extraPathsAndContents, jarPath, null, compliance);
    }

    public static void createJar(String[] javaPathsAndContents, String[] extraPathsAndContents, String jarPath, String[] classpath, String compliance) throws IOException {
        Util.createJar(javaPathsAndContents, extraPathsAndContents, Util.getCompileOptions(compliance), classpath, jarPath);
    }

    public static void createJar(String[] javaPathsAndContents, String[] extraPathsAndContents, String jarPath, String[] classpath, String compliance, Map options) throws IOException {
        Map compileOptions = Util.getCompileOptions(compliance);
        if (options != null) {
            compileOptions.putAll(options);
        }
        Util.createJar(javaPathsAndContents, extraPathsAndContents, compileOptions, classpath, jarPath);
    }

    public static void createSourceZip(String[] pathsAndContents, String zipPath) throws IOException {
        String sourcesPath = String.valueOf(Util.getOutputDirectory()) + File.separator + "sources";
        Util.createSourceDir(pathsAndContents, sourcesPath);
        Util.zip(new File(sourcesPath), zipPath);
    }

    public static void createSourceDir(String[] pathsAndContents, String sourcesPath) throws IOException {
        Util.flushDirectoryContent(new File(sourcesPath));
        int i = 0;
        int length = pathsAndContents.length;
        while (i < length) {
            String sourcePath = String.valueOf(sourcesPath) + File.separator + pathsAndContents[i];
            File sourceFile = new File(sourcePath);
            sourceFile.getParentFile().mkdirs();
            Util.createFile(sourcePath, pathsAndContents[i + 1]);
            i += 2;
        }
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            Util.flushDirectoryContent(file);
        }
        file.delete();
        if (Util.isFileDeleted(file)) {
            return true;
        }
        return Util.waitUntilFileDeleted(file);
    }

    public static IStatus delete(IResource resource) {
        IStatus status = null;
        try {
            resource.delete(true, null);
            if (Util.isResourceDeleted(resource)) {
                return Status.OK_STATUS;
            }
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        boolean deleted = Util.waitUntilResourceDeleted(resource);
        if (deleted) {
            return Status.OK_STATUS;
        }
        if (status != null) {
            return status;
        }
        return new Status(4, "org.eclipse.jdt.core", "Cannot delete resource " + resource);
    }

    public static boolean delete(String path) {
        return Util.delete(new File(path));
    }

    public static String displayString(String inputString) {
        return Util.displayString(inputString, 0);
    }

    public static String displayString(String inputString, int indent) {
        return Util.displayString(inputString, indent, false);
    }

    public static String displayString(String inputString, int indent, boolean shift) {
        if (inputString == null) {
            return "null";
        }
        int length = inputString.length();
        StringBuffer buffer = new StringBuffer(length);
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\n\r", true);
        int i = 0;
        while (i < indent) {
            buffer.append("\t");
            ++i;
        }
        if (shift) {
            ++indent;
        }
        buffer.append("\"");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\r")) {
                buffer.append("\\r");
                if (!tokenizer.hasMoreTokens()) continue;
                token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    buffer.append("\\n");
                    if (!tokenizer.hasMoreTokens()) continue;
                    buffer.append("\" + \n");
                    int i2 = 0;
                    while (i2 < indent) {
                        buffer.append("\t");
                        ++i2;
                    }
                    buffer.append("\"");
                    continue;
                }
                buffer.append("\" + \n");
                int i3 = 0;
                while (i3 < indent) {
                    buffer.append("\t");
                    ++i3;
                }
                buffer.append("\"");
            } else if (token.equals("\n")) {
                buffer.append("\\n");
                if (!tokenizer.hasMoreTokens()) continue;
                buffer.append("\" + \n");
                int i4 = 0;
                while (i4 < indent) {
                    buffer.append("\t");
                    ++i4;
                }
                buffer.append("\"");
                continue;
            }
            StringBuffer tokenBuffer = new StringBuffer();
            int i5 = 0;
            while (i5 < token.length()) {
                char c = token.charAt(i5);
                switch (c) {
                    case '\r': {
                        tokenBuffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        tokenBuffer.append("\\n");
                        break;
                    }
                    case '\b': {
                        tokenBuffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        tokenBuffer.append("\t");
                        break;
                    }
                    case '\f': {
                        tokenBuffer.append("\\f");
                        break;
                    }
                    case '\"': {
                        tokenBuffer.append("\\\"");
                        break;
                    }
                    case '\'': {
                        tokenBuffer.append("\\'");
                        break;
                    }
                    case '\\': {
                        tokenBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        tokenBuffer.append(c);
                    }
                }
                ++i5;
            }
            buffer.append(tokenBuffer.toString());
        }
        buffer.append("\"");
        return buffer.toString();
    }

    public static String fileContent(String sourceFilePath) {
        File sourceFile = new File(sourceFilePath);
        if (!sourceFile.exists()) {
            return null;
        }
        if (!sourceFile.isFile()) {
            return null;
        }
        StringBuffer sourceContentBuffer = new StringBuffer();
        FileInputStream input = null;
        try {
            input = new FileInputStream(sourceFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            try {
                int read;
                do {
                    if ((read = input.read()) == -1) continue;
                    sourceContentBuffer.append((char)read);
                } while (read != -1);
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {}
        return sourceContentBuffer.toString();
    }

    public static String fileContentToDisplayString(String sourceFilePath, int indent, boolean independantLineDelimiter) {
        String sourceString = Util.fileContent(sourceFilePath);
        if (independantLineDelimiter) {
            sourceString = Util.convertToIndependantLineDelimiter(sourceString);
        }
        return Util.displayString(sourceString, indent);
    }

    public static void fileContentToDisplayString(String sourceFilePath, int indent, String destinationFilePath, boolean independantLineDelimiter) {
        String displayString = Util.fileContentToDisplayString(sourceFilePath, indent, independantLineDelimiter);
        if (destinationFilePath == null) {
            System.out.println(displayString);
            return;
        }
        Util.writeToFile(displayString, destinationFilePath);
    }

    public static void flushDirectoryContent(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        int max = files.length;
        while (i < max) {
            Util.delete(files[i]);
            ++i;
        }
    }

    private static Map getCompileOptions(String compliance) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.compliance", compliance);
        options.put("org.eclipse.jdt.core.compiler.source", compliance);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compliance);
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", "ignore");
        options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        return options;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getFreePort() {
        ServerSocket socket = null;
        socket = new ServerSocket(0);
        int n = socket.getLocalPort();
        if (socket == null) return n;
        try {
            socket.close();
            return n;
        }
        catch (IOException iOException) {}
        return n;
        catch (IOException iOException) {
            try {
                if (socket == null) return -1;
            }
            catch (Throwable throwable) {
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                socket.close();
                return -1;
            }
            catch (IOException iOException3) {}
            return -1;
        }
    }

    public static String[] getJavaClassLibs() {
        String bootclasspathProperty = System.getProperty("sun.boot.class.path");
        if (!(bootclasspathProperty != null && bootclasspathProperty.length() != 0 || (bootclasspathProperty = System.getProperty("vm.boot.class.path")) != null && bootclasspathProperty.length() != 0)) {
            bootclasspathProperty = System.getProperty("org.apache.harmony.boot.class.path");
        }
        String[] jars = null;
        if (bootclasspathProperty != null && bootclasspathProperty.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(bootclasspathProperty, File.pathSeparator);
            int size = tokenizer.countTokens();
            jars = new String[size];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String fileName = Util.toNativePath(tokenizer.nextToken());
                if (!new File(fileName).exists()) continue;
                jars[i] = fileName;
                ++i;
            }
            if (size != i) {
                String[] stringArray = jars;
                jars = new String[i];
                System.arraycopy(stringArray, 0, jars, 0, i);
            }
        } else {
            String jreDir = Util.getJREDirectory();
            String osName = System.getProperty("os.name");
            if (jreDir == null) {
                return new String[0];
            }
            if (osName.startsWith("Mac")) {
                return new String[]{Util.toNativePath(String.valueOf(jreDir) + "/../Classes/classes.jar")};
            }
            String vmName = System.getProperty("java.vm.name");
            if ("J9".equals(vmName)) {
                return new String[]{Util.toNativePath(String.valueOf(jreDir) + "/lib/jclMax/classes.zip")};
            }
            String[] jarsNames = null;
            ArrayList paths = new ArrayList();
            if ("DRLVM".equals(vmName)) {
                FilenameFilter jarFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar") & !name.endsWith("-src.jar");
                    }
                };
                jarsNames = new File(String.valueOf(jreDir) + "/lib/boot/").list(jarFilter);
                Util.addJarEntries(String.valueOf(jreDir) + "/lib/boot/", jarsNames, paths);
            } else {
                jarsNames = new String[]{"/lib/vm.jar", "/lib/rt.jar", "/lib/core.jar", "/lib/security.jar", "/lib/xml.jar", "/lib/graphics.jar"};
                Util.addJarEntries(jreDir, jarsNames, paths);
            }
            jars = new String[paths.size()];
            paths.toArray(jars);
        }
        return jars;
    }

    private static void addJarEntries(String jreDir, String[] jarNames, ArrayList paths) {
        int i = 0;
        int max = jarNames.length;
        while (i < max) {
            String currentName = String.valueOf(jreDir) + jarNames[i];
            File f = new File(currentName);
            if (f.exists()) {
                paths.add(Util.toNativePath(currentName));
            }
            ++i;
        }
    }

    public static String getJavaClassLibsAsString() {
        String[] classLibs = Util.getJavaClassLibs();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = classLibs.length;
        while (i < max) {
            buffer.append(classLibs[i]).append(File.pathSeparatorChar);
            ++i;
        }
        return buffer.toString();
    }

    public static String getJREDirectory() {
        return System.getProperty("java.home");
    }

    public static String getOutputDirectory() {
        return OUTPUT_DIRECTORY;
    }

    private static File getParentChildFile(File file) {
        int length;
        File parent = file.getParentFile();
        if (parent == null || !parent.exists()) {
            return null;
        }
        File[] files = parent.listFiles();
        int n = length = files == null ? 0 : files.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (files[i] == file) {
                    return files[i];
                }
                if (files[i].equals(file)) {
                    return files[i];
                }
                if (files[i].getPath().equals(file.getPath())) {
                    return files[i];
                }
                ++i;
            }
        }
        return null;
    }

    private static IResource getParentChildResource(IResource resource) {
        IContainer parent = resource.getParent();
        if (parent == null || !parent.exists()) {
            return null;
        }
        try {
            int length;
            IResource[] members = parent.members();
            int n = length = members == null ? 0 : members.length;
            if (length > 0) {
                int i = 0;
                while (i < length) {
                    if (members[i] == resource) {
                        return members[i];
                    }
                    if (members[i].equals((Object)resource)) {
                        return members[i];
                    }
                    if (members[i].getFullPath().equals((Object)resource.getFullPath())) {
                        return members[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private static String getTestName() {
        StackTraceElement[] elements = new Exception().getStackTrace();
        int idx = 0;
        int length = elements.length;
        while (idx < length && !elements[idx++].getClassName().startsWith("org.eclipse.jdt")) {
        }
        if (idx < length) {
            StackTraceElement testElement = null;
            while (idx < length && elements[idx].getClassName().startsWith("org.eclipse.jdt")) {
                testElement = elements[idx++];
            }
            if (testElement != null) {
                return String.valueOf(testElement.getClassName()) + " - " + testElement.getMethodName();
            }
        }
        return "?";
    }

    public static String indentString(String inputString, int indent) {
        if (inputString == null) {
            return "";
        }
        int length = inputString.length();
        StringBuffer buffer = new StringBuffer(length);
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\n\r", true);
        StringBuffer indentStr = new StringBuffer(indent);
        int i = 0;
        while (i < indent) {
            indentStr.append("\t");
            ++i;
        }
        buffer.append(indentStr);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            buffer.append(token);
            if (!token.equals("\r") && !token.equals("\n")) continue;
            buffer.append(indentStr);
        }
        return buffer.toString();
    }

    public static boolean isFileDeleted(File file) {
        return !file.exists() && Util.getParentChildFile(file) == null;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isResourceDeleted(IResource resource) {
        return !resource.isAccessible() && Util.getParentChildResource(resource) == null;
    }

    private static void printFileInfo(File file, int indent, int recurse) {
        File parent;
        int length;
        String tab = "";
        int i = 0;
        while (i < indent) {
            tab = String.valueOf(tab) + "\t";
            ++i;
        }
        System.out.print(String.valueOf(tab) + "- " + file.getName() + " file info: ");
        String sep = "";
        if (file.canRead()) {
            System.out.print("read");
            sep = ", ";
        }
        if (file.canWrite()) {
            System.out.print(String.valueOf(sep) + "write");
            sep = ", ";
        }
        if (file.exists()) {
            System.out.print(String.valueOf(sep) + "exist");
            sep = ", ";
        }
        if (file.isDirectory()) {
            System.out.print(String.valueOf(sep) + "dir");
            sep = ", ";
        }
        if (file.isFile()) {
            System.out.print(String.valueOf(sep) + "file");
            sep = ", ";
        }
        if (file.isHidden()) {
            System.out.print(String.valueOf(sep) + "hidden");
            sep = ", ";
        }
        System.out.println();
        File[] files = file.listFiles();
        int n = length = files == null ? 0 : files.length;
        if (length > 0) {
            boolean children = recurse < 0;
            System.out.print(String.valueOf(tab) + "\t+ children: ");
            if (children) {
                System.out.println();
            }
            int i2 = 0;
            while (i2 < length) {
                if (children) {
                    Util.printFileInfo(files[i2], indent + 2, -1);
                } else {
                    if (i2 > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(files[i2].getName());
                    if (files[i2].isDirectory()) {
                        System.out.print("[dir]");
                    } else if (files[i2].isFile()) {
                        System.out.print("[file]");
                    } else {
                        System.out.print("[?]");
                    }
                }
                ++i2;
            }
            if (!children) {
                System.out.println();
            }
        }
        if (recurse > 0 && (parent = file.getParentFile()) != null) {
            Util.printFileInfo(parent, indent + 1, recurse - 1);
        }
    }

    private static void printJdtCoreStackTrace(Exception exception, int indent) {
        String tab = "";
        int i = 0;
        while (i < indent) {
            tab = String.valueOf(tab) + "\t";
            ++i;
        }
        StackTraceElement[] elements = (exception == null ? new Exception() : exception).getStackTrace();
        int idx = 0;
        int length = elements.length;
        while (idx < length && !elements[idx++].getClassName().startsWith("org.eclipse.jdt")) {
        }
        if (idx < length) {
            System.out.print(String.valueOf(tab) + "- stack trace");
            if (exception == null) {
                System.out.println(":");
            } else {
                System.out.println(" for exception " + exception + ":");
            }
            while (idx < length && elements[idx].getClassName().startsWith("org.eclipse.jdt")) {
                StackTraceElement testElement = elements[idx++];
                System.out.println(String.valueOf(tab) + "\t-> " + testElement);
            }
        } else {
            exception.printStackTrace(System.out);
        }
    }

    public static String toNativePath(String path) {
        String nativePath = path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return nativePath.endsWith("/") || nativePath.endsWith("\\") ? nativePath.substring(0, nativePath.length() - 1) : nativePath;
    }

    public static String toString(String[] strings, boolean addExtraNewLine) {
        if (strings == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = strings.length;
        while (i < length) {
            buffer.append(strings[i]);
            if (addExtraNewLine || i < length - 1) {
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void unzip(String zipPath, String destDirPath) throws IOException {
        block21: {
            FileInputStream zipIn = new FileInputStream(zipPath);
            byte[] buf = new byte[8192];
            File destDir = new File(destDirPath);
            ZipInputStream zis = new ZipInputStream(zipIn);
            FileOutputStream fos = null;
            try {
                try {
                    ZipEntry zEntry;
                    while ((zEntry = zis.getNextEntry()) != null) {
                        if (zEntry.isDirectory()) {
                            new File(destDir, zEntry.getName()).mkdirs();
                            continue;
                        }
                        String filePath = zEntry.getName();
                        int lastSeparator = filePath.lastIndexOf("/");
                        String fileDir = "";
                        if (lastSeparator >= 0) {
                            fileDir = filePath.substring(0, lastSeparator);
                        }
                        new File(destDir, fileDir).mkdirs();
                        File outFile = new File(destDir, filePath);
                        fos = new FileOutputStream(outFile);
                        int n = 0;
                        while ((n = zis.read(buf)) >= 0) {
                            fos.write(buf, 0, n);
                        }
                        fos.close();
                    }
                }
                catch (IOException iOException) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    try {
                        ((InputStream)zipIn).close();
                        if (zis != null) {
                            zis.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException3) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)zipIn).close();
                    if (zis != null) {
                        zis.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)zipIn).close();
                if (zis != null) {
                    zis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void waitAtLeast(int time) {
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {}
        } while (System.currentTimeMillis() - start < (long)time);
    }

    private static boolean waitUntilFileDeleted(File file) {
        if (DELETE_DEBUG) {
            System.out.println();
            System.out.println("WARNING in test: " + Util.getTestName());
            System.out.println("\t- problems occured while deleting " + file);
            Util.printJdtCoreStackTrace(null, 1);
            Util.printFileInfo(file.getParentFile(), 1, -1);
            System.out.print("\t- wait for (" + DELETE_MAX_WAIT + "ms max): ");
        }
        int count = 0;
        int delay = 10;
        int maxRetry = DELETE_MAX_WAIT / delay;
        int time = 0;
        while (count < maxRetry) {
            block12: {
                block11: {
                    ++count;
                    Thread.sleep(delay);
                    if ((time += delay) > DELETE_MAX_TIME) {
                        DELETE_MAX_TIME = time;
                    }
                    if (DELETE_DEBUG) {
                        System.out.print('.');
                    }
                    if (!file.exists() || !file.delete()) break block11;
                    if (DELETE_DEBUG) {
                        System.out.println();
                        System.out.println("\t=> file really removed after " + time + "ms (max=" + DELETE_MAX_TIME + "ms)");
                        System.out.println();
                    }
                    return true;
                }
                if (!Util.isFileDeleted(file)) break block12;
                if (DELETE_DEBUG) {
                    System.out.println();
                    System.out.println("\t=> file disappeared after " + time + "ms (max=" + DELETE_MAX_TIME + "ms)");
                    System.out.println();
                }
                return true;
            }
            try {
                if (count < 10 || delay > 100) continue;
                count = 1;
                maxRetry = DELETE_MAX_WAIT / (delay *= 10);
                if (DELETE_MAX_WAIT % delay == 0) continue;
                ++maxRetry;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (!DELETE_DEBUG) {
            System.out.println();
            System.out.println("WARNING in test: " + Util.getTestName());
            System.out.println("\t- problems occured while deleting " + file);
            Util.printJdtCoreStackTrace(null, 1);
            Util.printFileInfo(file.getParentFile(), 1, -1);
        }
        System.out.println();
        System.out.println("\t!!! ERROR: " + file + " was never deleted even after having waited " + DELETE_MAX_TIME + "ms!!!");
        System.out.println();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitUntilResourceDeleted(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            System.out.println();
            System.out.println("\t!!! ERROR: " + resource + " getLocation() returned null!!!");
            System.out.println();
            return false;
        }
        File file = location.toFile();
        if (DELETE_DEBUG) {
            System.out.println();
            System.out.println("WARNING in test: " + Util.getTestName());
            System.out.println("\t- problems occured while deleting resource " + resource);
            Util.printJdtCoreStackTrace(null, 1);
            Util.printFileInfo(file.getParentFile(), 1, -1);
            System.out.print("\t- wait for (" + DELETE_MAX_WAIT + "ms max): ");
        }
        int count = 0;
        int delay = 10;
        int maxRetry = DELETE_MAX_WAIT / delay;
        int time = 0;
        while (count < maxRetry) {
            try {
                ++count;
                Thread.sleep(delay);
                if ((time += delay) > DELETE_MAX_TIME) {
                    DELETE_MAX_TIME = time;
                }
                if (DELETE_DEBUG) {
                    System.out.print('.');
                }
                if (resource.isAccessible()) {
                    try {
                        resource.delete(true, null);
                        if (Util.isResourceDeleted(resource) && Util.isFileDeleted(file)) {
                            if (DELETE_DEBUG) {
                                System.out.println();
                                System.out.println("\t=> resource really removed after " + time + "ms (max=" + DELETE_MAX_TIME + "ms)");
                                System.out.println();
                            }
                            return true;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (Util.isResourceDeleted(resource) && Util.isFileDeleted(file)) {
                    if (DELETE_DEBUG) {
                        System.out.println();
                        System.out.println("\t=> resource disappeared after " + time + "ms (max=" + DELETE_MAX_TIME + "ms)");
                        System.out.println();
                    }
                    return true;
                }
                if (count < 10 || delay > 100) continue;
                count = 1;
                maxRetry = DELETE_MAX_WAIT / (delay *= 10);
                if (DELETE_MAX_WAIT % delay == 0) continue;
                ++maxRetry;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (!DELETE_DEBUG) {
            System.out.println();
            System.out.println("WARNING in test: " + Util.getTestName());
            System.out.println("\t- problems occured while deleting resource " + resource);
            Util.printJdtCoreStackTrace(null, 1);
            Util.printFileInfo(file.getParentFile(), 1, -1);
        }
        System.out.println();
        System.out.println("\t!!! ERROR: " + resource + " was never deleted even after having waited " + DELETE_MAX_TIME + "ms!!!");
        System.out.println();
        return false;
    }

    public static void writeToFile(String contents, String destinationFilePath) {
        File destFile = new File(destinationFilePath);
        FileOutputStream output = null;
        try {
            try {
                output = new FileOutputStream(destFile);
                PrintWriter writer = new PrintWriter(output);
                writer.print(contents);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void zip(File rootDir, String zipPath) throws IOException {
        ZipOutputStream zip = null;
        try {
            File zipFile = new File(zipPath);
            if (zipFile.exists()) {
                if (!Util.delete(zipFile)) {
                    throw new IOException("Could not delete " + zipPath);
                }
                int timeToWait = 1000;
                Util.waitAtLeast(timeToWait);
            } else {
                zipFile.getParentFile().mkdirs();
            }
            zip = new ZipOutputStream(new FileOutputStream(zipFile));
            Util.zip(rootDir, zip, rootDir.getPath().length() + 1);
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    private static void zip(File dir, ZipOutputStream zip, int rootPathLength) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            int length = files.length;
            while (i < length) {
                File file = files[i];
                if (file.isFile()) {
                    String path = file.getPath();
                    path = path.substring(rootPathLength);
                    ZipEntry entry = new ZipEntry(path.replace('\\', '/'));
                    zip.putNextEntry(entry);
                    zip.write(org.eclipse.jdt.internal.compiler.util.Util.getFileByteContent((File)file));
                    zip.closeEntry();
                } else {
                    Util.zip(file, zip, rootPathLength);
                }
                ++i;
            }
        }
    }

    public static void zipFiles(File[] files, String zipPath) throws IOException {
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            if (!Util.delete(zipFile)) {
                throw new IOException("Could not delete " + zipPath);
            }
            int timeToWait = 1000;
            Util.waitAtLeast(timeToWait);
        } else {
            zipFile.getParentFile().mkdirs();
        }
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipFile));
        try {
            int i = 0;
            int length = files.length;
            while (i < length) {
                File file = files[i];
                ZipEntry entry = new ZipEntry(file.getName());
                zip.putNextEntry(entry);
                zip.write(org.eclipse.jdt.internal.compiler.util.Util.getFileByteContent((File)file));
                zip.closeEntry();
                ++i;
            }
        }
        finally {
            zip.close();
        }
    }

    public static String getProblemLog(CompilationResult compilationResult, boolean showCategory, boolean showWarningToken) {
        StringBuffer buffer = new StringBuffer(100);
        if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
            CategorizedProblem[] problems = compilationResult.getAllProblems();
            int count = problems.length;
            int problemCount = 0;
            char[] unitSource = compilationResult.compilationUnit.getContents();
            int i = 0;
            while (i < count) {
                DefaultProblem problem = (DefaultProblem)problems[i];
                if (problem != null) {
                    if (problemCount == 0) {
                        buffer.append("----------\n");
                    }
                    buffer.append(String.valueOf(++problemCount) + (problem.isError() ? ". ERROR" : ". WARNING"));
                    buffer.append(" in " + new String(problem.getOriginatingFileName()).replace('/', '\\'));
                    try {
                        String warningToken;
                        int irritant;
                        String category;
                        buffer.append(problem.errorReportSource(unitSource));
                        buffer.append("\n");
                        if (showCategory && (category = problem.getInternalCategoryMessage()) != null) {
                            buffer.append("[@cat:").append(category).append("] ");
                        }
                        if (showWarningToken && (irritant = ProblemReporter.getIrritant((int)problem.getID())) != 0 && (warningToken = CompilerOptions.warningTokenFromIrritant((int)irritant)) != null) {
                            buffer.append("[@sup:").append(warningToken).append("] ");
                        }
                        buffer.append(problem.getMessage());
                        buffer.append("\n");
                    }
                    catch (Exception exception) {}
                    buffer.append("----------\n");
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    public static long getMajorMinorVMVersion() {
        String[] versionParts;
        String classFileVersion = System.getProperty("java.class.version");
        if (classFileVersion != null && (versionParts = classFileVersion.split("\\.")).length >= 2) {
            int majorVersion = -1;
            try {
                majorVersion = Integer.parseInt(versionParts[0]);
            }
            catch (NumberFormatException numberFormatException) {}
            int minorVersion = -1;
            try {
                minorVersion = Integer.parseInt(versionParts[1]);
            }
            catch (NumberFormatException numberFormatException) {}
            if (minorVersion != -1 && majorVersion != -1) {
                return ((long)majorVersion << 16) + (long)minorVersion;
            }
        }
        return -1L;
    }
}

