/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.tests.compiler.parser.TestSourceElementRequestor;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class EnumDietRecoveryTest
extends AbstractCompilerTest {
    public static boolean optimizeStringLiterals = false;
    public static long sourceLevel = 0x2F0000L;

    public EnumDietRecoveryTest(String testName) {
        super(testName);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        return options;
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietPlusBodyUnitToString, String expectedFullUnitToString, String expectedCompletionDietUnitToString, String testName) {
        CompilationResult compilationResult;
        CompilationUnit sourceUnit;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)(sourceUnit = new CompilationUnit(source, testName, null)), compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0));
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        EnumDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        EnumDietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            int i = 0;
            int length = computedUnit.types.length;
            while (i < length) {
                computedUnit.types[i].parseMethods(parser, computedUnit);
                ++i;
            }
        }
        if (!expectedDietPlusBodyUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        EnumDietRecoveryTest.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        EnumDietRecoveryTest.assertEquals("Invalid unit full structure" + testName, expectedFullUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        EnumDietRecoveryTest.assertEquals("Invalid source element diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        EnumDietRecoveryTest.assertEquals("Invalid source element full structure" + testName, expectedFullUnitToString, computedUnitToString);
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser2 = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), false);
        CompilationUnit sourceUnit2 = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult2 = new CompilationResult((ICompilationUnit)sourceUnit2, 0, 0, 0);
        CompilationUnitDeclaration computedUnit2 = parser2.dietParse((ICompilationUnit)sourceUnit2, compilationResult2, Integer.MAX_VALUE);
        String computedUnitToString2 = computedUnit2.toString();
        if (!expectedCompletionDietUnitToString.equals(computedUnitToString2)) {
            System.out.println(Util.displayString(computedUnitToString2));
        }
        EnumDietRecoveryTest.assertEquals("Invalid completion diet structure" + testName, expectedCompletionDietUnitToString, computedUnitToString2);
    }

    public void test0001() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#\npublic enum X {\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0002() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#\npublic enum X {\t\t\t\t\t\t\t\t\n  A,\t\t\t\t\t\t\t\t\t\t\t\n  B;\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  A(),\n  B(),\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  A(),\n  B(),\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0003() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#\npublic enum X {\t\t\t\t\t\t\t\t\n  A(10),\t\t\t\t\t\t\t\t\t\t\n  B(){};\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  A(10),\n  B() {\n  },\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  A(10),\n  B() {\n  },\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0004() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#\npublic enum X {\t\t\t\t\t\t\t\t\n  B(){\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }  \t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0005() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#\npublic enum X {\t\t\t\t\t\t\t\t\n  B(){\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  };  \t\t\t\t\t\t\t\t\t\t\n  public X(){}\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  <clinit>() {\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  <clinit>() {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0006() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#\npublic enum X {\t\t\t\t\t\t\t\t\n  B(){\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }  \t\t\t\t\t\t\t\t\t\t\n  public X(){} \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  public X() {\n  },\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  public X() {\n  },\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0007() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#\npublic enum X {\t\t\t\t\t\t\t\t\n  B(){\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }  \t\t\t\t\t\t\t\t\t\t\n  X(){} \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  X() {\n  },\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  X() {\n  },\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0008() {
        String expectedDietPlusBodyUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic enum X {\t\t\t\t\t\t\t\t\n  B(){\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }  \t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  <clinit>() {\n  }\n  public X() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  <clinit>() {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0009() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#              \t\t\t\t\t\t\t\t\npublic enum X {\t\t\t\t\t\t\t\t\n  B(){\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }  \t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n  },\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0010() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#              \t\t\t\t\t\t\t\t\npublic enum X {\t\t\t\t\t\t\t\t\n  B(){\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  ;  \t\t\t\t\t\t\t\t\t\t\n  void bar(){}  \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n    void bar() {\n    }\n  },\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n    void bar() {\n    }\n  },\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0011() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#              \t\t\t\t\t\t\t\t\npublic enum X {\t\t\t\t\t\t\t\t\n  B(){\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  ;  \t\t\t\t\t\t\t\t\t\t\n  X(){}      \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n    X() {\n    }\n  },\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B() {\n    void foo() {\n    }\n    X() {\n    }\n  },\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0012() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#              \t\t\t\t\t\t\t\t\npublic enum X {\t\t\t\t\t\t\t\t\n  B()\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  };  \t\t\t\t\t\t\t\t\t\t\n  void bar(){}  \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B(),\n  {\n  }\n  public X() {\n  }\n  <clinit>() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B(),\n  {\n  }\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0013() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#              \t\t\t\t\t\t\t\t\npublic enum X {\t\t\t\t\t\t\t\t\n  B( {\t\t\t\t\t\t\t\t\t\t\n    void foo(){\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  };  \t\t\t\t\t\t\t\t\t\t\n  void bar(){}  \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X {\n  B,\n  {\n  }\n  public X() {\n  }\n  <clinit>() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X {\n  B,\n  {\n  }\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0014() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\n#              \t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  class Y { \t\t\t\t\t\t\t\t\t\n  }   \t\t\t\t\t\t\t\t\t\t\n  enum Z {\t\t\t\t\t\t\t\t\t\n    B() {\t\t\t\t\t\t\t\t\t\n      void foo(){\t\t\t\t\t\t\t\n      }\t\t\t\t\t\t\t\t\t\t\n    };  \t\t\t\t\t\t\t\t\t\t\n    Z(){}       \t\t\t\t\t\t\t\t\n  }            \t\t\t\t\t\t\t\t\n  class W {     \t\t\t\t\t\t\t\t\n  }             \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic class X {\n  class Y {\n    Y() {\n    }\n  }\n  enum Z {\n    B() {\n      void foo() {\n      }\n    },\n    <clinit>() {\n    }\n    Z() {\n    }\n  }\n  class W {\n    W() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  class Y {\n    Y() {\n      super();\n    }\n  }\n  enum Z {\n    B() {\n      void foo() {\n      }\n    },\n    <clinit>() {\n    }\n    Z() {\n      super();\n    }\n  }\n  class W {\n    W() {\n      super();\n    }\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0015() {
        String s = "public enum Enum1 {\t\t\t\t\t\t\n  BLEU(){   \t\t\t\t\t\t\t\t\t\n    void foo() {                             \n       System.out.println();     \t\t\t\n    }    \t\t\t\t\t\t\t\t\t\n  },             \t\t\t\t\t\t\t\n  BLANC,  \t\t\t\t\t\t\t\t\t\n  ROUGE;\t\t\t\t\t\t\t\t\t\t\n                \t\t\t\t\t\t\t\t\n  main         \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public enum Enum1 {\n  BLEU() {\n    void foo() {\n    }\n  },\n  BLANC(),\n  ROUGE(),\n  public Enum1() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public enum Enum1 {\n  BLEU() {\n    void foo() {\n    }\n  },\n  BLANC(),\n  ROUGE(),\n  public Enum1() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0016() {
        String s = "public enum Enum {\t\t\t\t\t\t\t\t\n  BEGIN(\"blabla\"),\t\t\t\t\t\t\n  END(\"blabla\").\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public enum Enum {\n  BEGIN(\"blabla\"),\n  END(\"blabla\"),\n  public Enum() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public enum Enum {\n  BEGIN(\"blabla\"),\n  END(\"blabla\"),\n  public Enum() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test0017() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic enum X <T> {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\npublic enum X<T> {\n  <clinit>() {\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic enum X<T> {\n  <clinit>() {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = "package a;\npublic enum X<T> {\n  <clinit>() {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<enum type recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }
}

