/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractSyntaxTreeTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;

public class LambdaExpressionSyntaxTest
extends AbstractSyntaxTreeTest {
    private static String jsr335TestScratchArea = "c:\\Jsr335TestScratchArea";
    private static String referenceCompiler = "C:\\jdk-7-ea-bin-b75-windows-i586-30_oct_2009\\jdk7\\bin\\javac.exe";
    static /* synthetic */ Class class$0;

    static {
        if (!new File(referenceCompiler).exists()) {
            referenceCompiler = null;
            jsr335TestScratchArea = null;
        }
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.parser.LambdaExpressionSyntaxTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
    }

    public static Test suite() {
        return LambdaExpressionSyntaxTest.buildMinimalComplianceTestSuite(LambdaExpressionSyntaxTest.testClass(), 32);
    }

    public LambdaExpressionSyntaxTest(String testName) {
        super(testName, referenceCompiler, jsr335TestScratchArea);
        if (referenceCompiler != null) {
            File f = new File(jsr335TestScratchArea);
            if (!f.exists()) {
                f.mkdir();
            }
            CHECK_ALL |= 0x80;
        }
    }

    public void test0001() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    public static void main(String [] args) {\n        System.out.println(((I) x -> x * x).square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    System.out.println(((I) (<no type> x) -> (x * x)).square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0001", expectedUnitToString);
    }

    public void test0002() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    public static void main(String [] args) {\n        I i =  x -> x * x;\n        System.out.println(i.square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = (<no type> x) -> (x * x);\n    System.out.println(i.square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0002", expectedUnitToString);
    }

    public void test0003() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    public static void main(String [] args) {\n        I i =  ((((x -> x * x))));\n        System.out.println(i.square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = (((((<no type> x) -> (x * x)))));\n    System.out.println(i.square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0003", expectedUnitToString);
    }

    public void test0004() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    public static void main(String [] args) {\n        I i;\n        i =  (x -> x * x);\n        System.out.println(i.square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i;\n    i = ((<no type> x) -> (x * x));\n    System.out.println(i.square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0004", expectedUnitToString);
    }

    public void test0005() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    static I getI() {\n        return (x -> x * x);\n    }\n    public static void main(String [] args) {\n        I i = getI();\n        System.out.println(i.square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  static I getI() {\n    return ((<no type> x) -> (x * x));\n  }\n  public static void main(String[] args) {\n    I i = getI();\n    System.out.println(i.square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0005", expectedUnitToString);
    }

    public void test0006() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    public static void main(String [] args) {\n        I i = args == null ? x -> x * x : x -> x * x * x;\n        System.out.println(i.square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = ((args == null) ? (<no type> x) -> (x * x) : (<no type> x) -> ((x * x) * x));\n    System.out.println(i.square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0006", expectedUnitToString);
    }

    public void test0007() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    static void foo(I i1, I i2) {\n        System.out.println(i1.square(10));\n        System.out.println(i2.square(10));\n    }\n    public static void main(String [] args) {\n        foo(x -> x * x, x -> x * x * x);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  static void foo(I i1, I i2) {\n    System.out.println(i1.square(10));\n    System.out.println(i2.square(10));\n  }\n  public static void main(String[] args) {\n    foo((<no type> x) -> (x * x), (<no type> x) -> ((x * x) * x));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0007", expectedUnitToString);
    }

    public void test0008() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    X (I i1, I i2) {\n        System.out.println(i1.square(10));\n        System.out.println(i2.square(10));\n    }\n    public static void main(String [] args) {\n        new X(x -> x * x, x -> x * x * x);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  X(I i1, I i2) {\n    super();\n    System.out.println(i1.square(10));\n    System.out.println(i2.square(10));\n  }\n  public static void main(String[] args) {\n    new X((<no type> x) -> (x * x), (<no type> x) -> ((x * x) * x));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0008", expectedUnitToString);
    }

    public void test0009() throws IOException {
        String source = "interface I {\n    I square(int x);\n}\npublic class X {\n    public static void main(String [] args) {\n      System.out.println (((I) a->b->c->d->e->f->g-> null).square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  I square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    System.out.println(((I) (<no type> a) -> (<no type> b) -> (<no type> c) -> (<no type> d) -> (<no type> e) -> (<no type> f) -> (<no type> g) -> null).square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0009", expectedUnitToString);
    }

    public void test00010() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    static I i = x -> x * x;\n    {\n        i = x -> x * x * x;\n    }\n    static {\n        i = x -> x * x * x;\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  static I i = (<no type> x) -> (x * x);\n  {\n    i = (<no type> x) -> ((x * x) * x);\n  }\n  static {\n    i = (<no type> x) -> ((x * x) * x);\n  }\n  <clinit>() {\n  }\n  public X() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test00010", expectedUnitToString);
    }

    public void test0011() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    public static void main(String [] args) {\n        System.out.println(((I) (x) -> x * x).square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    System.out.println(((I) (<no type> x) -> (x * x)).square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0011", expectedUnitToString);
    }

    public void test0012() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    public static void main(String [] args) {\n        I i = (int x) -> x * x;\n        System.out.println(i.square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    I i = (int x) -> (x * x);\n    System.out.println(i.square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0012", expectedUnitToString);
    }

    public void test0013() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    @interface Positive {}\n    static void foo(I i1, I i2) {\n        System.out.println(i1.square(10));\n        System.out.println(i2.square(10));\n    }\n    public static void main(String [] args) {\n        foo((final int x) -> x * x, (final @Positive int x) -> x * x * x);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  @interface Positive {\n  }\n  public X() {\n    super();\n  }\n  static void foo(I i1, I i2) {\n    System.out.println(i1.square(10));\n    System.out.println(i2.square(10));\n  }\n  public static void main(String[] args) {\n    foo((final int x) -> (x * x), (final @Positive int x) -> ((x * x) * x));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0013", expectedUnitToString);
    }

    public void test0014() throws IOException {
        String source = "interface I {\n    int square(int ... x);\n}\npublic class X {\n    @interface Positive {}\n    static void foo(I i1, I i2) {\n        System.out.println(i1.square(10));\n        System.out.println(i2.square(10));\n    }\n    public static void main(String [] args) {\n        foo((final int ... x) -> 10, (final @Positive int [] x) -> 20);\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int... x);\n}\npublic class X {\n  @interface Positive {\n  }\n  public X() {\n    super();\n  }\n  static void foo(I i1, I i2) {\n    System.out.println(i1.square(10));\n    System.out.println(i2.square(10));\n  }\n  public static void main(String[] args) {\n    foo((final int... x) -> 10, (final @Positive int[] x) -> 20);\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0014", expectedUnitToString);
    }

    public void test0015() throws IOException {
        String source = "interface I {\n    int product(int x, int y);\n}\npublic class X {\n    static I getI() {\n        return ((x, y) -> x * y);\n    }\n    public static void main(String [] args) {\n        I i = getI();\n        System.out.println(i.product(5, 6));\n    }\n};\n";
        String expectedUnitToString = "interface I {\n  int product(int x, int y);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  static I getI() {\n    return ((<no type> x, <no type> y) -> (x * y));\n  }\n  public static void main(String[] args) {\n    I i = getI();\n    System.out.println(i.product(5, 6));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0015", expectedUnitToString);
    }

    public void test0016() throws IOException {
        String source = "interface I {\n    int product(int x, int y);\n}\npublic class X {\n    static I getI() {\n        return (int x, int y) -> { return x * y; };\n    }\n    public static void main(String [] args) {\n        I i = getI();\n        System.out.println(i.product(5, 6));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int product(int x, int y);\n}\npublic class X {\n  public X() {\n    super();\n  }\n  static I getI() {\n    return (int x, int y) -> {\n  return (x * y);\n};\n  }\n  public static void main(String[] args) {\n    I i = getI();\n    System.out.println(i.product(5, 6));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0016", expectedUnitToString);
    }

    public void test0017() throws IOException {
        String source = "interface I {\n    String noarg();\n}\npublic class X {\n    public static void main(String [] args) {\n        System.out.println( ((I) () -> { return \"noarg\"; }).noarg());\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  String noarg();\n}\npublic class X {\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    System.out.println(((I) () -> {\n  return \"noarg\";\n}).noarg());\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0017", expectedUnitToString);
    }

    public void test0018() throws IOException {
        String source = "interface I {\n    void foo();\n}\n\ninterface J {\n    int foo();\n}\npublic class X {\n  I i1 = ()->{}; \n  J j1 = ()->0;\n  J j2 = ()->{ return 0; };\n  I i2 = ()->{ System.gc(); };\n  J j3 = ()->{\n    if (true) return 0;\n    else {\n      int r = 12;\n      for (int i = 1; i < 8; i++)\n        r += i;\n      return r;\n    }\n  };\n}\n";
        String expectedUnitToString = "interface I {\n  void foo();\n}\ninterface J {\n  int foo();\n}\npublic class X {\n  I i1 = () ->   {\n  };\n  J j1 = () -> 0;\n  J j2 = () ->   {\n    return 0;\n  };\n  I i2 = () ->   {\n    System.gc();\n  };\n  J j3 = () ->   {\n    if (true)\n        return 0;\n    else\n        {\n          int r = 12;\n          for (int i = 1;; (i < 8); i ++) \n            r += i;\n          return r;\n        }\n  };\n  public X() {\n    super();\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0018", expectedUnitToString);
    }

    public void test0019() throws IOException {
        String source = "interface I {\n    int square(int x);\n}\npublic class X {\n    int y;\n    public static void main(String [] args) {\n        System.out.println(((I) x -> y = x * x ).square(10));\n    }\n}\n";
        String expectedUnitToString = "interface I {\n  int square(int x);\n}\npublic class X {\n  int y;\n  public X() {\n    super();\n  }\n  public static void main(String[] args) {\n    System.out.println(((I) (<no type> x) -> y = (x * x)).square(10));\n  }\n}\n";
        this.checkParse(129, source.toCharArray(), null, "test0019", expectedUnitToString);
    }

    public void testNestedLambda01() throws IOException {
        String source = "public class C {\n\tI foo() {\n\t\treturn (i1, i2) -> \t(String x1, String x2) -> { \n\t\t\t\t\t\t\t\treturn x1+x2; \n\t\t\t\t\t\t\t};\n\t}\n}\n\ninterface I {\n\tString doit(String s1, String s2);\n}\n";
        String expectedUnitToString = "public class C {\n  public C() {\n    super();\n  }\n  I foo() {\n    return (<no type> i1, <no type> i2) -> (String x1, String x2) -> {\n  return (x1 + x2);\n};\n  }\n}\ninterface I {\n  String doit(String s1, String s2);\n}\n";
        this.checkParse(129, source.toCharArray(), null, "testNestedLambda01", expectedUnitToString);
    }

    public void test385132() throws IOException {
        String source = "->";
        String expectedErrorString = "----------\n1. ERROR in test385132 (at line 1)\n\t->\n\t^^\nSyntax error on token \"->\", delete this token\n----------\n";
        this.checkParse(1, source.toCharArray(), expectedErrorString, "test385132", null);
    }
}

