/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.parser.SourceField;
import org.eclipse.jdt.core.tests.compiler.parser.SourceImport;
import org.eclipse.jdt.core.tests.compiler.parser.SourceInitializer;
import org.eclipse.jdt.core.tests.compiler.parser.SourceMethod;
import org.eclipse.jdt.core.tests.compiler.parser.SourcePackage;
import org.eclipse.jdt.core.tests.compiler.parser.SourceType;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class SourceElementParserTest
extends AbstractCompilerTest
implements ISourceElementRequestor {
    private SourceType currentType;
    private SourceMethod currentMethod;
    private SourceField currentField;
    private SourceInitializer currentInitializer;
    private char[] source;
    private SourcePackage currentPackage;
    private SourceImport[] currentImports;
    private int numberOfImports;
    static /* synthetic */ Class class$0;

    public SourceElementParserTest(String testName) {
        super(testName);
    }

    public SourceElementParserTest(String testName, char[] source) {
        super(testName);
        this.source = source;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.parser.SourceElementParserTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SourceElementParserTest.buildAllCompliancesTestSuite(clazz);
    }

    public void acceptAnnotationTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
    }

    public void acceptAnnotationTypeReference(char[] typeName, int sourcePosition) {
    }

    public void acceptConstructorReference(char[] typeName, int argCount, int sourcePosition) {
        if (this.currentMethod == null) {
            if (this.currentType != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(typeName).append("(").append(argCount).append(")\n");
                this.currentType.setDefaultConstructor(buffer.toString());
            }
            return;
        }
        if (this.currentMethod.isConstructor()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(typeName).append("(").append(argCount).append(")\n");
            this.currentMethod.setExplicitConstructorCall(buffer.toString());
        } else if (this.currentType != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(typeName).append("(").append(argCount).append(")\n");
            this.currentType.setDefaultConstructor(buffer.toString());
        }
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
    }

    public void acceptImport(int declarationStart, int declarationEnd, int nameStart, int nameEnd, char[][] tokens, boolean onDemand, int modifiers) {
        this.addImport(new SourceImport(declarationStart, declarationEnd, CharOperation.concatWith((char[][])tokens, (char)'.'), onDemand, modifiers, this.source));
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition) {
    }

    public void acceptPackage(ImportReference importReference) {
        this.currentPackage = new SourcePackage(importReference.declarationSourceStart, importReference.declarationSourceEnd, CharOperation.concatWith((char[][])importReference.getImportName(), (char)'.'), this.source);
    }

    public void acceptProblem(CategorizedProblem problem) {
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
    }

    public void acceptTypeReference(char[] typeName, int sourcePosition) {
    }

    public void acceptUnknownReference(char[][] name, int sourceStart, int sourceEnd) {
    }

    public void acceptUnknownReference(char[] name, int sourcePosition) {
    }

    protected void addImport(SourceImport sourceImport) {
        if (this.currentImports == null) {
            this.currentImports = new SourceImport[4];
        }
        if (this.numberOfImports == this.currentImports.length) {
            this.currentImports = new SourceImport[this.numberOfImports * 2];
            System.arraycopy(this.currentImports, 0, this.currentImports, 0, this.numberOfImports);
        }
        this.currentImports[this.numberOfImports++] = sourceImport;
    }

    public void dietParse(String s, String testName) {
        this.dietParse(s, testName, false);
    }

    public void dietParse(String s, String testName, boolean recordLocalDeclaration) {
        this.source = s.toCharArray();
        this.reset();
        SourceElementParser parser = new SourceElementParser((ISourceElementRequestor)this, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), recordLocalDeclaration, true);
        CompilationUnit sourceUnit = new CompilationUnit(this.source, testName, null);
        parser.parseCompilationUnit((ICompilationUnit)sourceUnit, false, null);
    }

    public static String displayModifiers(int modifiers) {
        StringBuffer buffer = new StringBuffer();
        if ((modifiers & 1) != 0) {
            buffer.append("public ");
        }
        if ((modifiers & 4) != 0) {
            buffer.append("protected ");
        }
        if ((modifiers & 2) != 0) {
            buffer.append("private ");
        }
        if ((modifiers & 0x10) != 0) {
            buffer.append("final ");
        }
        if ((modifiers & 8) != 0) {
            buffer.append("static ");
        }
        if ((modifiers & 0x400) != 0) {
            buffer.append("abstract ");
        }
        if ((modifiers & 0x100) != 0) {
            buffer.append("native ");
        }
        if ((modifiers & 0x20) != 0) {
            buffer.append("synchronized ");
        }
        return buffer.toString();
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        if (this.currentType == null) {
            this.currentType = new SourceType(null, typeInfo.declarationStart, typeInfo.modifiers, typeInfo.name, typeInfo.nameSourceStart, typeInfo.nameSourceEnd, typeInfo.superclass, typeInfo.superinterfaces, this.source);
            this.currentType.setPackage(this.currentPackage);
            this.setImports();
        } else {
            SourceType memberType = new SourceType(this.currentType.getName(), typeInfo.declarationStart, typeInfo.modifiers, typeInfo.name, typeInfo.nameSourceStart, typeInfo.nameSourceEnd, typeInfo.superclass, typeInfo.superinterfaces, this.source);
            this.currentType.addMemberType(memberType);
            memberType.parent = this.currentType;
            this.currentType = memberType;
        }
        if (typeInfo.typeParameters != null) {
            int i = 0;
            int length = typeInfo.typeParameters.length;
            while (i < length) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[i];
                this.addTypeParameterToType(typeParameterInfo);
                ++i;
            }
        }
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbtractMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        this.currentField = new SourceField(fieldInfo.declarationStart, fieldInfo.modifiers, fieldInfo.type, fieldInfo.name, fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd, this.source);
        this.currentType.addField(this.currentField);
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        this.currentInitializer = new SourceInitializer(declarationSourceStart, modifiers);
        this.currentType.addField(this.currentInitializer);
    }

    public void exitInitializer(int declarationSourceEnd) {
        this.currentInitializer.setDeclarationSourceEnd(declarationSourceEnd);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterAbtractMethod(methodInfo);
    }

    protected void enterAbtractMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        this.currentMethod = new SourceMethod(methodInfo.declarationStart, methodInfo.modifiers, methodInfo.returnType, methodInfo.name, methodInfo.nameSourceStart, methodInfo.nameSourceEnd, methodInfo.parameterTypes, methodInfo.parameterNames, methodInfo.exceptionTypes, this.source);
        this.currentType.addMethod(this.currentMethod);
        if (methodInfo.typeParameters != null) {
            int i = 0;
            int length = methodInfo.typeParameters.length;
            while (i < length) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = methodInfo.typeParameters[i];
                this.addTypeParameterToMethod(typeParameterInfo);
                ++i;
            }
        }
    }

    public void addTypeParameterToMethod(ISourceElementRequestor.TypeParameterInfo typeParameterInfo) {
        if (this.currentMethod.typeParameterNames == null) {
            this.currentMethod.typeParameterNames = new char[][]{typeParameterInfo.name};
            this.currentMethod.typeParameterBounds = new char[][][]{typeParameterInfo.bounds};
        } else {
            int length = this.currentMethod.typeParameterNames.length;
            char[][] cArrayArray = new char[length + 1][];
            this.currentMethod.typeParameterNames = cArrayArray;
            System.arraycopy(this.currentMethod.typeParameterNames, 0, cArrayArray, 0, length);
            this.currentMethod.typeParameterNames[length] = typeParameterInfo.name;
            char[][][] cArrayArray2 = new char[length + 1][][];
            this.currentMethod.typeParameterBounds = cArrayArray2;
            System.arraycopy(this.currentMethod.typeParameterBounds, 0, cArrayArray2, 0, length);
            this.currentMethod.typeParameterBounds[length] = typeParameterInfo.bounds;
        }
    }

    public void addTypeParameterToType(ISourceElementRequestor.TypeParameterInfo typeParameterInfo) {
        if (this.currentType.typeParameterNames == null) {
            this.currentType.typeParameterNames = new char[][]{typeParameterInfo.name};
            this.currentType.typeParameterBounds = new char[][][]{typeParameterInfo.bounds};
        } else {
            int length = this.currentType.typeParameterNames.length;
            char[][] cArrayArray = new char[length + 1][];
            this.currentType.typeParameterNames = cArrayArray;
            System.arraycopy(this.currentType.typeParameterNames, 0, cArrayArray, 0, length);
            this.currentMethod.typeParameterNames[length] = typeParameterInfo.name;
            char[][][] cArrayArray2 = new char[length + 1][][];
            this.currentType.typeParameterBounds = cArrayArray2;
            System.arraycopy(this.currentType.typeParameterBounds, 0, cArrayArray2, 0, length);
            this.currentType.typeParameterBounds[length] = typeParameterInfo.bounds;
        }
    }

    public void exitType(int declarationEnd) {
        this.currentType.setDeclarationSourceEnd(declarationEnd);
        if (this.currentType.parent != null) {
            this.currentType = this.currentType.parent;
        }
    }

    public void exitCompilationUnit(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        this.exitAbstractMethod(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        this.currentField.setDeclarationSourceEnd(declarationEnd);
    }

    public void exitMethod(int declarationEnd, Expression defaultValue) {
        this.exitAbstractMethod(declarationEnd);
    }

    protected void exitAbstractMethod(int declarationEnd) {
        this.currentMethod.setDeclarationSourceEnd(declarationEnd);
    }

    public void fullParse(String s, String testName) {
        this.fullParse(s, testName, false);
    }

    public void fullParse(String s, String testName, Map options) {
        this.fullParse(s, testName, false, options);
    }

    public void fullParse(String s, String testName, boolean recordLocalDeclaration, Map options) {
        this.source = s.toCharArray();
        this.reset();
        SourceElementParser parser = new SourceElementParser((ISourceElementRequestor)this, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(options), recordLocalDeclaration, true);
        CompilationUnit sourceUnit = new CompilationUnit(this.source, testName, null);
        parser.parseCompilationUnit((ICompilationUnit)sourceUnit, true, null);
    }

    public void fullParse(String s, String testName, boolean recordLocalDeclaration) {
        this.fullParse(s, testName, recordLocalDeclaration, this.getCompilerOptions());
    }

    public void reset() {
        this.currentType = null;
        this.currentMethod = null;
        this.currentField = null;
        this.currentPackage = null;
        this.currentImports = null;
        this.numberOfImports = 0;
    }

    public void setImports() {
        if (this.currentImports == null) {
            return;
        }
        if (this.numberOfImports != this.currentImports.length) {
            this.currentImports = new SourceImport[this.numberOfImports];
            System.arraycopy(this.currentImports, 0, this.currentImports, 0, this.numberOfImports);
        }
        this.currentType.setImports(this.currentImports);
    }

    public void test01() {
        String s = "package a;\nimport java.lang.*;\nimport java.util.*;\n\npublic class X {\nvoid foo() {\nSystem.out.println();\n\npublic int h;\npublic int[] i = { 0, 1 };\n\nint bar\\u0065(){\nvoid truc(){\n}\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tpublic int h;\n\tpublic int[] i;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tint bare() {}\n\tvoid truc() {}\n}";
        String testName = "test01: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)52, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)178, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)105, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)117, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)119, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)144, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)69, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)103, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bare", (int)147, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bare", (int)163, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)164, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)177, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bare", "bar\\u0065", methods[1].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test02() {
        String s = "/** javadoc comment */\npublic class X {\n}\n";
        String expectedUnitToString = "public class X {\n\tjava.lang.Object(0)\n}";
        String testName = "test02: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)40, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test03() {
        String s = "package a;\nimport java.lang.*;\nimport java.util.*;\n\npublic class X {\nvoid foo() {\nSystem.out.println();\n\npublic int h;\npublic int[] i = { 0, 1 };\n\nint bar\\u0065(){\nvoid truc(){\n}\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tpublic int h;\n\tpublic int[] i;\n\tvoid foo() {}\n\tint bare() {}\n\tvoid truc() {}\n}";
        String testName = "test03: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)52, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)178, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)105, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)117, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)119, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)144, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)69, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)103, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)147, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)163, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)164, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)177, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bare", "bar\\u0065", methods[1].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test04() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L {\t\t\t\t\t\t\t\t\n\t\t\tvoid baz(){}\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tpublic int h;\n\tpublic int[] i;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test04: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)89, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)372, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)248, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)260, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)271, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)296, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)115, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)222, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)317, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)337, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)339, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)360, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test05() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L {\t\t\t\t\t\t\t\t\n\t\t\tvoid baz(){}\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tpublic int h;\n\tpublic int[] i;\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test05: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)89, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)372, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)248, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)260, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)271, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)296, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)115, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)222, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)317, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)337, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)339, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)360, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test06() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n X x;\t\t\t\t\t\t\t\t\t\t\n Object a, b = null;\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tX x;\n\tObject a;\n\tObject b;\n\tpublic int h;\n\tpublic int[] i;\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test06: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)89, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)347, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid fields length ", (int)5, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)115, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)118, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field a", (int)131, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field a", (int)139, (int)fields[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field b", (int)131, (int)fields[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field b", (int)149, (int)fields[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)223, (int)fields[3].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)235, (int)fields[3].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)246, (int)fields[4].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)271, (int)fields[4].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)159, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)221, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)292, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)312, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)314, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)335, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test07() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n X x;\t\t\t\t\t\t\t\t\t\t\n Object a, b = null;\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tX x;\n\tObject a;\n\tObject b;\n\tpublic int h;\n\tpublic int[] i;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test07: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)89, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)347, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid fields length ", (int)5, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field xh", (int)115, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)118, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field a", (int)131, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field a", (int)139, (int)fields[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field b", (int)131, (int)fields[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field b", (int)149, (int)fields[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)223, (int)fields[3].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)235, (int)fields[3].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)246, (int)fields[4].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)271, (int)fields[4].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)159, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)221, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)292, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)312, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)314, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)335, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test08() {
        String s = "public class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n \tvoid baz(){}\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test08: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)198, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)27, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)100, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)127, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)149, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)163, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)185, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test09() {
        String s = "public class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n \tvoid baz(){}\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test09: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)198, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)27, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)100, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)127, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)149, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)163, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)185, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test10() {
        String s = "public class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n \tvoid baz(){}\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\t/** comment                                 \n  *                                          \n  *                                          \n  */                                         \n                                             \n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test10: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)415, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)27, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)100, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)114, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)366, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)380, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)402, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test11() {
        String s = "public class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n \tvoid baz(){}  \t\t\t\t\t\t\t\n\t/** comment                                 \n  *                                          \n  *                                          \n  */                                         \n  int[][] j[] = null, k; // comment          \n                                             \n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tint[][][] j;\n\tint[][] k;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid baz() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test11: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)449, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field j", (int)102, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field j", (int)305, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field k", (int)102, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field k", (int)308, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)4, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)27, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)76, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)79, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)90, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)378, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)400, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)414, (int)methods[3].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)436, (int)methods[3].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[2].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[3].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test12() {
        String s = "import java.util.Enumeration;\nimport java.util.Hashtable;\n/** comment */\npublic class A2 {\n\tvoid foo() {\n\t\tSystem.out.println();\n \tvoid baz(){}\n\t/** comment\n  *\n  *\n  */\n  static { } // comment\n  \n\n\tvoid bar(){\n }\n\tvoid truc(){\n }\n}\n";
        String expectedUnitToString = "import java.util.Enumeration;\nimport java.util.Hashtable;\npublic class A2 {\n\tstatic {}\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid baz() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test12: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)58, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)231, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid fields length ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for initializer", (int)145, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for initializer", (int)181, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)4, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)92, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)128, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)131, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)142, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)183, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)212, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)215, (int)methods[3].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)229, (int)methods[3].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[2].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[3].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test13() {
        String s = "import java.util.Enumeration;\nimport java.util.Hashtable;\n\npublic class A2 {\n\tvoid foo() {\n\t\tSystem.out.println();\n \tvoid baz(){}\n  static { }\n  \n\n\tvoid bar(){\n }\n\tvoid truc(){\n }\n}\n";
        String expectedUnitToString = "import java.util.Enumeration;\nimport java.util.Hashtable;\npublic class A2 {\n\tstatic {}\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid baz() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test13: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)59, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)180, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for initializer", (int)132, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for initializer", (int)141, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)4, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)78, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)114, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)117, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)128, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)148, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)161, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)164, (int)methods[3].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)178, (int)methods[3].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[2].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[3].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test14() {
        String s = "import java.util.Enumeration;\nimport java.util.Hashtable;\n\npublic class A2 {\n\tvoid foo() {\n\t\tSystem.out.println();\n \tvoid baz(){}\n  static { }\n }\n\n\tvoid bar(){\n }\n\tvoid truc(){\n }\n}\n";
        String expectedUnitToString = "import java.util.Enumeration;\nimport java.util.Hashtable;\npublic class A2 {\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test14: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)59, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)180, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)78, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)144, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)148, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)161, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)164, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)178, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test15() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n class Y {\t\t\t\t\t\t\t\t\t\n\t  void foo() {\t\t\t\t\t\t\t\t\n\t   System.out.println();\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n public int h;\t\t\t\t\t\t\t\t\n public int[] i = {0, 1};\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tpublic int h;\n\t\tpublic int[] i;\n\t\tjava.lang.Object(0)\n\t\tvoid foo() {}\n\t\tvoid bar() {}\n\t\tvoid baz() {}\n\t}\n\tjava.lang.Object(0)\n}";
        String testName = "test15: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)227, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid members length ", (int)1, (int)members.length);
        fields = members[0].getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)117, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)129, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)140, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)163, (int)fields[1].getDeclarationSourceEnd());
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)48, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)103, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)171, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)191, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)193, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)215, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[2].getActualName());
        SourceType member = members[0];
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)26, (int)member.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)227, (int)member.getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test16() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n class Y {\t\t\t\t\t\t\t\t\t\n\t  void foo() {\t\t\t\t\t\t\t\t\n\t   System.out.println();\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n public int h;\t\t\t\t\t\t\t\t\n public int[] i = {0, 1};\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tpublic int h;\n\t\tpublic int[] i;\n\t\tvoid foo() {}\n\t\tvoid bar() {}\n\t\tvoid baz() {}\n\t}\n}";
        String testName = "test16: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)227, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid members length ", (int)1, (int)members.length);
        fields = members[0].getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)117, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)129, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)140, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)163, (int)fields[1].getDeclarationSourceEnd());
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid methods length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)48, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)103, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)171, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)191, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)193, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)215, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[2].getActualName());
        SourceType member = members[0];
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)26, (int)member.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)227, (int)member.getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test17() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n class Y {\t\t\t\t\t\t\t\t\t\n\t  void foo() {\t\t\t\t\t\t\t\t\n\t   System.out.println();\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n public int h;\t\t\t\t\t\t\t\t\n public int[] i = {0, 1};\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tjava.lang.Object(0)\n\t\tvoid foo() {}\n\t}\n\tpublic int h;\n\tpublic int[] i;\n\tjava.lang.Object(0)\n\tvoid bar() {}\n\tvoid baz() {}\n}";
        String testName = "test17: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)241, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)131, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)143, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)154, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)177, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)185, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)205, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)207, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)229, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid members length ", (int)1, (int)members.length);
        fields = members[0].getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid methods length ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)48, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)103, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType member = members[0];
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)26, (int)member.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)117, (int)member.getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test18() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n class Y {\t\t\t\t\t\t\t\t\t\n\t  void foo() {\t\t\t\t\t\t\t\t\n\t   System.out.println();\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n public int h;\t\t\t\t\t\t\t\t\n public int[] i = {0, 1};\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tvoid foo() {}\n\t}\n\tpublic int h;\n\tpublic int[] i;\n\tvoid bar() {}\n\tvoid baz() {}\n}";
        String testName = "test18: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)241, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)131, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)143, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)154, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)177, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)185, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)205, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)207, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)229, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid members length ", (int)1, (int)members.length);
        fields = members[0].getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid methods length ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)48, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)103, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType member = members[0];
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)26, (int)member.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)117, (int)member.getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test19() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n  int x;\t\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n int y;\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\t{}\n\tint y;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid baz() {}\n}";
        String testName = "test19: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)197, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for initializer", (int)90, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for initializer", (int)90, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)181, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)186, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)26, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)77, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)104, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)143, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)145, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)167, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test20() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n public int x;\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n int y;\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\t{}\n\tpublic int x;\n\tint y;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid baz() {}\n}";
        String testName = "test20: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)201, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)3, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for initializer", (int)90, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for initializer", (int)90, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)126, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)138, (int)fields[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)185, (int)fields[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)190, (int)fields[2].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)26, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)77, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)104, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)124, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)149, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)171, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test21() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n public int x;\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n int y;\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\t{}\n\tpublic int x;\n\tint y;\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid baz() {}\n}";
        String testName = "test21: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)201, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)3, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for initializer", (int)90, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for initializer", (int)90, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)126, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)138, (int)fields[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)185, (int)fields[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)190, (int)fields[2].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)26, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)77, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)104, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)124, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method baz", (int)149, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method baz", (int)171, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method baz", "baz", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test22() {
        String s = "public class X extends {\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tjava.lang.Object(0)\n\tvoid foo() {}\n}";
        String testName = "test22: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)67, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)32, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)54, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test23() {
        String s = "public class X extends Thread {\t\t\t\t\n\tvoid foo() throws\t\t\t\t\t\t\t\n\tvoid bar() \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X extends Thread {\n\tThread(0)\n\tvoid foo() {}\n\tvoid bar() {}\n}";
        String testName = "test23: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)98, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)37, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)61, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)63, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)85, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test24() {
        String s = "public class X implements \t\t\t\t\t\t\n\tvoid foo() \t\t\t\t\t\t\t\t\t\n\tvoid bar() \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n}";
        String testName = "test24: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)91, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)34, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)54, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)56, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)78, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test25() {
        String s = "public class X implements Y,\t\t\t\t\t\n\tvoid foo() \t\t\t\t\t\t\t\t\t\n\tvoid bar() \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X implements Y, {\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n}";
        String testName = "test25: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)92, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"contains superinterfaces ", (this.currentType.getInterfaceNames() != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid superinterfaces length ", (int)1, (int)this.currentType.getInterfaceNames().length);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)35, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)55, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)57, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)79, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test26() {
        String s = "public class X implements \t\t\t\t\t\t\n class Y { \t\t\t\t\t\t\t\t\t\n\t void bar() \t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tjava.lang.Object(0)\n\t\tvoid bar() {}\n\t}\n\tjava.lang.Object(0)\n}";
        String testName = "test26: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)102, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one member ", (int)1, (int)members.length);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)34, (int)members[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)90, (int)members[0].getDeclarationSourceEnd());
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one method ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)56, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)77, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[0].getActualName());
        members = members[0].getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test27() {
        String s = "public class X \t\t \t\t\t\t\t\t\n fieldX;\t\t\t\t\t\t\t\t\t\t\n class Y { \t\t\t\t\t\t\t\t\t\n\t void bar() \t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tjava.lang.Object(0)\n\t\tvoid bar() {}\n\t}\n\tjava.lang.Object(0)\n}";
        String testName = "test27: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)113, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one member ", (int)1, (int)members.length);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)45, (int)members[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)101, (int)members[0].getDeclarationSourceEnd());
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one method ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)67, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)88, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[0].getActualName());
        members = members[0].getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test28() {
        String s = "public class X \t\t \t\t\t\t\t\t\n fieldX;\t\t\t\t\t\t\t\t\t\t\n class Y  \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tjava.lang.Object(0)\n\t}\n\tjava.lang.Object(0)\n}";
        String testName = "test28: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)78, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one member ", (int)1, (int)members.length);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)45, (int)members[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)65, (int)members[0].getDeclarationSourceEnd());
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        members = members[0].getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test29() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L extends {\t\t\t\t\t\t\n\t\t\tpublic int l;\t\t\t\t\t\t\n\t\t\tvoid baz(){}\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tpublic int h;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test29: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)88, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)357, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)276, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)288, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains 3 methods ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)114, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)250, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)312, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)332, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)334, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)355, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test30() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L extends {\t\t\t\t\t\t\n\t\t\tpublic int l;\t\t\t\t\t\t\n\t\t\tvoid baz(){}\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tpublic int h;\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test30: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)88, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)357, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)276, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)288, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains 3 methods ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)114, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)250, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)312, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)332, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)334, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)355, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test31() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tnew X(){\t\t\t\t\t\t\t\t\n\t\t\tvoid baz() {}\t\t\t\t\t\t\n\t\t}.baz();\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tpublic int h;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test31: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)89, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)334, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)253, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)265, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains 3 methods ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)115, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)251, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)289, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)309, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)311, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)332, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test32() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tnew X(){\t\t\t\t\t\t\t\t\n\t\t\tvoid baz() {}\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tpublic int h;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tvoid bar(){\t\t\t\t\t\t\t\t\n\t\tvoid truc(){\t\t\t\t\t\t\t\n}\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tjava.lang.Object(0)\n\tvoid foo() {}\n}";
        String testName = "test32: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)89, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)315, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one methods ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)115, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)315, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test33() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tnew X(){\t\t\t\t\t\t\t\t\n\t\t\tvoid baz() {}\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tpublic int h;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tvoid bar(){\t\t\t\t\t\t\t\t\n\t\tvoid truc(){\t\t\t\t\t\t\t\n}\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tvoid foo() {}\n}";
        String testName = "test33: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)89, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)315, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one methods ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)115, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)315, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test34() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tnew X(){\t\t\t\t\t\t\t\t\n\t\t\tvoid baz() \t\t\t\t\t\t\t\n\t    }\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tpublic int h;\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test34: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)88, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)342, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field h", (int)250, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field h", (int)262, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains 3 methods ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)114, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)236, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)286, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)306, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)308, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)329, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test35() {
        String s = "package a;\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\nimport java.util.*;\t\t\t\t\n\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\n\t\tSystem.out.println();\t\t\n\t\t\t\t\t\t\t\t\t\n\t\tclass L extends {\t\t\t\n\t\t\tpublic int l;\t\t\t\n\t\t\tvoid baz(){}\t\t\t\n\t\t}\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\n\t\tint h;\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tjava.lang.Object(0)\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test35: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)76, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)309, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains 3 methods ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)99, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)260, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)262, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)279, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)281, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)299, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test36() {
        String s = "package a;\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\nimport java.util.*;\t\t\t\t\n\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\n\t\tSystem.out.println();\t\t\n\t\t\t\t\t\t\t\t\t\n\t\tclass L extends {\t\t\t\n\t\t\tpublic int l;\t\t\t\n\t\t\tvoid baz(){}\t\t\t\n\t\t}\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\n\t\tint h;\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n\tvoid foo() {}\n\tvoid bar() {}\n\tvoid truc() {}\n}";
        String testName = "test36: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)76, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)309, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains 3 methods ", (int)3, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)99, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)260, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)262, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)279, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method truc", (int)281, (int)methods[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method truc", (int)299, (int)methods[2].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method truc", "truc", methods[2].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test37() {
        String s = "public class X {\t\t \t\n  int x;\t\t\t \t\t\n\t\t\t\t\t\t\t\n  int foo(){ }\t\t\t\t\n\t\t\t\t\t\t\t\n  class Y  {\t\t\t\t\n    int y;\t\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tint y;\n\t\tjava.lang.Object(0)\n\t}\n\tint x;\n\tjava.lang.Object(0)\n\tint foo() {}\n}";
        String testName = "test37: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)112, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)23, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)28, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one methods ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)46, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)57, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one member ", (int)1, (int)members.length);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)73, (int)members[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)104, (int)members[0].getDeclarationSourceEnd());
        fields = members[0].getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)92, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)97, (int)fields[0].getDeclarationSourceEnd());
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test38() {
        String s = "public class X {\t\t \t\n  int x;\t\t\t \t\t\n\t\t\t\t\t\t\t\n  int foo(){ }\t\t\t\t\n\t\t\t\t\t\t\t\n  class Y  {\t\t\t\t\n    int y;\t\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tint y;\n\t}\n\tint x;\n\tint foo() {}\n}";
        String testName = "test38: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)112, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)23, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)28, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one methods ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)46, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)57, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one member ", (int)1, (int)members.length);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)73, (int)members[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)104, (int)members[0].getDeclarationSourceEnd());
        fields = members[0].getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)92, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)97, (int)fields[0].getDeclarationSourceEnd());
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test39() {
        String s = "public class X {\t\t \t\n  int x;\t\t\t \t\t\n\t\t\t\t\t\t\t\n  int foo(){ }\t\t\t\t\n\t\t\t\t\t\t\t\n  class Y  \t\t\t\t\n}\t\t\t\t\t\t\t\n  int y;\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t\tjava.lang.Object(0)\n\t}\n\tint x;\n\tint y;\n\tjava.lang.Object(0)\n\tint foo() {}\n}";
        String testName = "test39: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)109, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)23, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)28, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)98, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)103, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one methods ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)46, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)57, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one member ", (int)1, (int)members.length);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)73, (int)members[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)87, (int)members[0].getDeclarationSourceEnd());
        fields = members[0].getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test40() {
        String s = "public class X {\t\t \t\n  int x;\t\t\t \t\t\n\t\t\t\t\t\t\t\n  int foo(){ }\t\t\t\t\n\t\t\t\t\t\t\t\n  class Y  \t\t\t\t\n}\t\t\t\t\t\t\t\n  int y;\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tclass Y {\n\t}\n\tint x;\n\tint y;\n\tint foo() {}\n}";
        String testName = "test40: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)109, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one field ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)23, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)28, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)98, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)103, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one methods ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)46, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)57, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"contains one member ", (int)1, (int)members.length);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)73, (int)members[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)87, (int)members[0].getDeclarationSourceEnd());
        fields = members[0].getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        methods = members[0].getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test41() {
        String s = "public class X {\t\t\t\t\n\tvoid hell\\u006f()\n\tstatic void foo() {\t\t\t\n\t\tX x;\t\t\t\t\t\n\t\tx = new X(23);\t\t\t\n\t\tSystem.out.println();\t\n\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tjava.lang.Object(0)\n\tvoid hello() {}\n\tstatic void foo() {}\n}";
        String testName = "test41: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)139, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one methods ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method hello", (int)22, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method hello", (int)39, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)41, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)130, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method hello", "hell\\u006f", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test42() {
        String s = "public class X {\t\t\n\tint x\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tint x;\n\tjava.lang.Object(0)\n}";
        String testName = "test42: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)29, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one field", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)20, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)24, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test43() {
        String s = "public class X {\t\t\n\tint x\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tint x;\n}";
        String testName = "test43: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)29, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one field", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)20, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)24, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test44() {
        String s = "public class X {\t\t\n\tint x, y\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tint x;\n\tint y;\n\tjava.lang.Object(0)\n}";
        String testName = "test44: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)31, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one field", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)20, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)25, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)20, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)27, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test45() {
        String s = "public class X {\t\t\n\tint x, y\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tint x;\n\tint y;\n}";
        String testName = "test45: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)31, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one field", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)20, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)25, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)20, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)27, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test46() {
        String s = "public class X {\t\t\n\tString s = \"\t\t\n";
        String expectedUnitToString = "public class X {\n\tString s;\n\tjava.lang.Object(0)\n}";
        String testName = "test46: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)34, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one field", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field s", (int)20, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field s", (int)34, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test47() {
        String s = "public class X {\t\t\n\tString s = \"\t\t\n";
        String expectedUnitToString = "public class X {\n\tString s;\n}";
        String testName = "test47: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)34, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"doesn't contain superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" contains one field", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field s", (int)20, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field s", (int)34, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test48() {
        String s = "public class X implements Y, \t\t\n\tString s = \"\t\t\t\t\t\n";
        String expectedUnitToString = "public class X implements Y, String, {\n\tjava.lang.Object(0)\n}";
        String testName = "test48: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)50, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has 2 superinterfaces ", (this.currentType.getInterfaceNames() != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"2 superinterfaces ", (int)2, (int)this.currentType.getInterfaceNames().length);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test49() {
        String s = "public class X implements Y, \t\t\n\tString s = \"\t\t\t\t\t\n";
        String expectedUnitToString = "public class X implements Y, String, {\n}";
        String testName = "test49: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)50, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has 2 superinterfaces ", (this.currentType.getInterfaceNames() != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"2 superinterfaces ", (int)2, (int)this.currentType.getInterfaceNames().length);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test50() {
        String s = "public class X implements \t\t\nint x\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tint x;\n\tjava.lang.Object(0)\n}";
        String testName = "test50: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)42, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)29, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)33, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test51() {
        String s = "public class X implements \t\t\nint x\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tint x;\n}";
        String testName = "test51: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)42, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)29, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)33, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test52() {
        String s = "public class X public int foo(int bar(static String s";
        String expectedUnitToString = "public class X {\n\tstatic String s;\n\tjava.lang.Object(0)\n\tpublic int foo() {}\n\tint bar() {}\n}";
        String testName = "test52: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)52, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field s", (int)38, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field s", (int)52, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)15, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)29, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)30, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)37, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test53() {
        String s = "public class X public int foo(int x, int bar public String s;";
        String expectedUnitToString = "public class X {\n\tpublic String s;\n\tjava.lang.Object(0)\n\tpublic int foo(int x, int bar, ) {}\n}";
        String testName = "test53: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)60, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one field ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field s", (int)45, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field s", (int)60, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one method ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)15, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)44, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test54() {
        String s = "public class X \t\t\t\n\tpublic int foo(\t\t\t\n\tint bar(\t\t\t\t\n \tstatic String s, int x\t\n";
        String expectedUnitToString = "public class X {\n\tstatic String s;\n\tint x;\n\tjava.lang.Object(0)\n\tpublic int foo() {}\n\tint bar() {}\n}";
        String testName = "test54: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)78, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 2 fields ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field s", (int)55, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field s", (int)70, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)72, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)76, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 2 methods ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)20, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)38, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)40, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)52, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test55() {
        String s = "public class X \t\t\t\n\tpublic int foo(\t\t\t\n\tint bar(\t\t\t\t\n \tstatic String s, int x\t\n";
        String expectedUnitToString = "public class X {\n\tstatic String s;\n\tint x;\n\tpublic int foo() {}\n\tint bar() {}\n}";
        String testName = "test55: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)78, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 2 fields ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field s", (int)55, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field s", (int)70, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)72, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)76, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 2 methods ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)20, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)38, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method bar", (int)40, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method bar", (int)52, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method bar", "bar", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test56() {
        String s = "class X {\t\t\t\t\t\n\tString s;\t\t\t\t\n\t\t\t\t\t\t\t\n\tpublic void foo(\t\t\n\t\tstatic int x\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "class X {\n\tString s;\n\tstatic int x;\n\tjava.lang.Object(0)\n\tpublic void foo() {}\n}";
        String testName = "test56: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)75, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 2 fields ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field s", (int)16, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field s", (int)24, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)60, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)71, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 1 method ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)39, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)57, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test57() {
        String s = "class X {\t\t\t\t\t\n\tString s;\t\t\t\t\n\t\t\t\t\t\t\t\n\tpublic void foo(\t\t\n\t\tstatic int x\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "class X {\n\tString s;\n\tstatic int x;\n\tpublic void foo() {}\n}";
        String testName = "test57: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)75, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 2 fields ", (int)2, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field s", (int)16, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field s", (int)24, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)60, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)71, (int)fields[1].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 1 method ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)39, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)57, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test58() {
        String s = "public class X {\t\t\t\n\tint foo(){\t\t\t\t\n\t\tString s = \"\t\t\n\t}\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tjava.lang.Object(0)\n\tint foo() {}\n}";
        String testName = "test58: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)62, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 1 method ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)21, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)54, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test59() {
        String s = "class X {\t\t\t\t\t\t\t\t\t\n\tint foo(AA a, BB b, IOEx\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "class X {\n\tjava.lang.Object(0)\n\tint foo(AA a, BB b, ) {}\n}";
        String testName = "test59: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)60, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 1 method ", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)20, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)60, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test60() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tfinal static int foo(){ \t\t\t\t\n\t\treturn \"1; \t\t\t\t\t\t\n\t} \t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String argv[]){ \n\t\tfoo();\t\t\t\t\t\t\t\t\n\t} \t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedUnitToString = "public class X {\n\tjava.lang.Object(0)\n\tfinal static int foo() {}\n\tpublic static void main(String[] argv, ) {}\n}";
        String testName = "test60: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)161, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has 1 method ", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)25, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)75, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method main", (int)89, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method main", (int)148, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method main", "main", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test61() {
        String s = "public class X {\t\t\t\t\t\t\t\n\t{\t\t\t\t\t\t\t\t\t\t\n     int x;";
        String expectedUnitToString = "public class X {\n\t{}\n\tjava.lang.Object(0)\n}";
        String testName = "test61: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)47, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for initializer", (int)25, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for initializer", (int)47, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test62() {
        String s = "public class X {\t\t\t\t\t\t\t\n   int foo(){\t\t\t\t\t\t\t\t\n\t  if(true){\t\t\t\t\t\t\t\t\n     \tint x;";
        String expectedUnitToString = "public class X {\n\tjava.lang.Object(0)\n\tint foo() {}\n}";
        String testName = "test62: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)78, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one method", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)27, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)78, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test63() {
        String s = "public class X {\t\t\t\t\t\t\t\n   int foo(){}\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\nint x;\n";
        String expectedUnitToString = "public class X {\n\tint x;\n\tjava.lang.Object(0)\n\tint foo() {}\n}";
        String testName = "test63: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)66, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one field", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)60, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)65, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one method", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)27, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)37, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test64() {
        String s = "public class X {\t\t\t\t\t\t\t\n   int foo(){}\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\nint x;\n";
        String expectedUnitToString = "public class X {\n\tint x;\n\tint foo() {}\n}";
        String testName = "test64: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)66, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one field", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field x", (int)60, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field x", (int)65, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one method", (int)1, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)27, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)37, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test65() {
        String s = "public class X {\t\t\t\t\t\t\t\n   int foo(){}\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\nint x();\n";
        String expectedUnitToString = "public class X {\n\t{}\n\tint foo() {}\n\tint x() {}\n}";
        String testName = "test65: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)68, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)" invalid fields length ", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for initializer", (int)47, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for initializer", (int)47, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has two methods", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)27, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)37, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method x", (int)60, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method x", (int)67, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method x", "x", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test66() {
        String s = "public interface X {\t\t\t\t\t\t\n   int foo() {};\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\nint x();\n";
        String expectedUnitToString = "public interface X {\n\tint foo() {}\n\tint x() {}\n}";
        String testName = "test66: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)72, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has two methods", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)30, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)41, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method x", (int)64, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method x", (int)71, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method x", "x", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test67() {
        String s = "public interface X {\t\t\t\t\t\t\n   int foo() {};\t\t\t\t\t\t\t\n   int x();\t\t\t\t\t\t\t\t\n}";
        String expectedUnitToString = "public interface X {\n\tint foo() {}\n\tint x() {}\n}";
        String testName = "test67: diet parse";
        this.dietParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)71, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has two methods", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)30, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)41, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method x", (int)54, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method x", (int)61, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method x", "x", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test68() {
        String s = "public interface X {\t\t\t\t\t\t\n   int foo() {};\t\t\t\t\t\t\t\n   int x();\t\t\t\t\t\t\t\t\n}";
        String expectedUnitToString = "public interface X {\n\tint foo() {}\n\tint x() {}\n}";
        String testName = "test68: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)71, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has two methods", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)30, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)41, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method x", (int)54, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method x", (int)61, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method x", "x", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test69() {
        String s = "public interface X {\t\t\t\t\t\t\nfloat y;\t\t\t\t\t\t\t\t\t\n   int foo()\t;\t\t\t\t\t\t\t\n   int x();\t\t\t\t\t\t\t\t\n}";
        String expectedUnitToString = "public interface X {\n\tfloat y;\n\tint foo() {}\n\tint x() {}\n}";
        String testName = "test69: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)87, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one field", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field y", (int)27, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field y", (int)34, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has two methods", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)48, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)58, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method x", (int)70, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method x", (int)77, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method x", "x", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test70() {
        String s = "public interface X {\t\t\t\t\t\t\n   int foo();\t\t\t\t\t\t\t\t\n   int x();\t\t\t\t\t\t\t\t\n}";
        String expectedUnitToString = "public interface X {\n\tint foo() {}\n\tint x() {}\n}";
        String testName = "test70: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)69, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields == null ? 1 : 0) != 0);
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has two methods", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)30, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)39, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method x", (int)52, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method x", (int)59, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method x", "x", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test71() {
        String s = "public interface X {\t\t\t\t\t\t\n   int[] i = ;\t\t\t\t\t\t\t\t\n   int foo() {}\t\t\t\t\t\t\t\n   int x();\t\t\t\t\t\t\t\t\n}";
        String expectedUnitToString = "public interface X {\n\tint[] i;\n\tint foo() {}\n\tint x() {}\n}";
        String testName = "test71: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)93, (int)this.currentType.getDeclarationSourceEnd());
        SourceElementParserTest.assertTrue((String)"has no superinterfaces ", (this.currentType.getInterfaceNames() == null ? 1 : 0) != 0);
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)" invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has one field", (int)1, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)30, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field i", (int)49, (int)fields[0].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"has two methods", (int)2, (int)methods.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method foo", (int)53, (int)methods[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method foo", (int)64, (int)methods[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for method x", (int)76, (int)methods[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for method x", (int)83, (int)methods[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals(" Invalid actual name for method foo", "foo", methods[0].getActualName());
        SourceElementParserTest.assertEquals(" Invalid actual name for method x", "x", methods[1].getActualName());
        SourceType[] members = this.currentType.getMemberTypes();
        SourceElementParserTest.assertTrue((String)" invalid members ", (members == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test72() {
        String s = "public class X {\t\t\t\t\t\t\n   X() {\t\t\t\t\t\t\t\t\n   \tthis();\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}";
        String expectedUnitToString = "public class X {\n\tX() {\n\t\tX(0)\n\t}\n}";
        String testName = "test72: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test73() {
        String s = "public class X extends Toto {\t\t\t\n   X() {\t\t\t\t\t\t\t\t\n   \tthis();\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n   X(int i) {\t\t\t\t\t\t\t\n   \tsuper();\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n   X() {\t\t\t\t\t\t\t\t\n   \tthis(0);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}";
        String expectedUnitToString = "public class X extends Toto {\n\tX() {\n\t\tX(0)\n\t}\n\tX(int i, ) {\n\t\tToto(0)\n\t}\n\tX() {\n\t\tX(1)\n\t}\n}";
        String testName = "test73: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test74() {
        String s = "public class X extends Toto {\t\t\t\n\tclass Y extends Throwable {\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n   X() {\t\t\t\t\t\t\t\t\n   \tthis();\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n   X(int i) {\t\t\t\t\t\t\t\n   \tsuper();\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n   X() {\t\t\t\t\t\t\t\t\n   \tthis(0);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n\tpublic Object foo(int i) {\t\t\t\n\t\treturn new Object() {};\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}";
        String expectedUnitToString = "public class X extends Toto {\n\tclass Y extends Throwable {\n\t\tThrowable(0)\n\t}\n\tX() {\n\t\tX(0)\n\t}\n\tX(int i, ) {\n\t\tToto(0)\n\t}\n\tX() {\n\t\tX(1)\n\t}\n\tpublic Object foo(int i, ) {}\n}";
        String testName = "test74: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test75() {
        String s = "public class P#AField {\n\tpublic void setP#A(String P#A) {\n\t\tthis.P#A = P#A;\n\t}\n}";
        String expectedUnitToString = "public class P {\n\t{}\n\tpublic void setP;\n\tjava.lang.Object(0)\n\tA(String P, ) {}\n}";
        String testName = "test75: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test76() {
        String s = "class X {\n  public static int j = 0;\n  /* static */ {\n  }  public static int i = 9;\n}\n";
        String expectedUnitToString = "class X {\n\tpublic static int j;\n\t{}\n\tpublic static int i;\n\tjava.lang.Object(0)\n}";
        String testName = "test76: full parse";
        this.fullParse(s, testName);
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceStart ", (int)0, (int)this.currentType.getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid class declarationSourceEnd ", (int)84, (int)this.currentType.getDeclarationSourceEnd());
        SourceField[] fields = this.currentType.getFields();
        SourceElementParserTest.assertTrue((String)"invalid fields ", (fields != null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals((String)"Invalid fields length ", (int)3, (int)fields.length);
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field j", (int)12, (int)fields[0].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for field j", (int)35, (int)fields[0].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for initializer", (int)39, (int)fields[1].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end for initializer", (int)56, (int)fields[1].getDeclarationSourceEnd());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source start for field i", (int)59, (int)fields[2].getDeclarationSourceStart());
        SourceElementParserTest.assertEquals((String)"Invalid declaration source end field i", (int)82, (int)fields[2].getDeclarationSourceEnd());
        SourceMethod[] methods = this.currentType.getMethods();
        SourceElementParserTest.assertTrue((String)" invalid methods ", (methods == null ? 1 : 0) != 0);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void testBug99662() {
        String s = "@Deprecated\npackage p;\n";
        String testName = "package-info.java";
        this.fullParse(s, testName);
        SourceElementParserTest.assertNull((String)"package-info.java file should not have ANY type!", (Object)this.currentType);
    }

    public void _test77() {
        String s = "public class X {\n\tvoid foo() {\n\t\tclass Y {\n\t\t\tString s = null;\n\t\t\t{\n\t\t\t\tclass Z {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}";
        String expectedUnitToString = "public class X implements Y, String, {\n}";
        String testName = "test77: diet parse";
        this.dietParse(s, testName, true);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void _test78() {
        String s = "public class X {\n\tvoid foo() {\n\t\tclass Y {\n\t\t\tString s = null;\n\t\t\t{\n\t\t\t\tclass Z {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}";
        String expectedUnitToString = "public class X implements Y, String, {\n}";
        String testName = "test78: full parse";
        this.fullParse(s, testName, true);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void _test79() {
        String s = "public class X {\n\tvoid foo() {\n\t\tclass Y {\n\t\t\t{\n\t\t\t\tclass Z {\n\t\t\t\t}\n\t\t\t}\n\t\t\tString s = null;\n\t\t}\n\t}\n}";
        String expectedUnitToString = "public class X implements Y, String, {\n}";
        String testName = "test79: diet parse";
        this.dietParse(s, testName, true);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void _test80() {
        String s = "public class X {\n\tvoid foo() {\n\t\tclass Y {\n\t\t\t{\n\t\t\t\tclass Z {\n\t\t\t\t}\n\t\t\t}\n\t\t\tString s = null;\n\t\t}\n\t}\n}";
        String expectedUnitToString = "public class X implements Y, String, {\n}";
        String testName = "test80: full parse";
        this.fullParse(s, testName, true);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }

    public void test81() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        String s = "import java.util.Collection;\n\npublic class X {\n\tpublic abstract class AbstractData {}\n\t\n\tpublic interface IScalarData<T extends AbstractData> {}\n\n\tprivate static interface ValueObjectPropertyIterator {\n\t\tpublic <T extends AbstractData> void iterateOnValueObjectProperty(IScalarData<T> scalarObject, T valueObject, Class<?> valueObjectType, final String name, final Class<?> scalarType) throws Exception;\n\t}\n\n\tprivate static <T extends AbstractData> void iterateOnValueObjectProperties(IScalarData<T> scalarObject, T valueObject, ValueObjectPropertyIterator valueObjectPropertyIterator) {}\n\t\n\tpublic static <T extends AbstractData> void loadScalarFromValueObject(IScalarData<T> scalarObject, T valueObject) {\n\t\titerateOnValueObjectProperties(scalarObject, valueObject, new ValueObjectPropertyIterator() {\n\t\t\tpublic <T extends AbstractData> void iterateOnValueObjectProperty(IScalarData<T> scalarObject, T valueObject, Class<?> valueObjectType, String name, Class<?> scalarType) throws Exception {\n\t\t\t\tif (true) {\n\t\t\t\t\tif (true) {\n\t\t\t\t\t\tif (true) {\n\t\t\t\t\t\t\tfinal Collection<IScalarData<AbstractData>> lazyCollection = createLazyCollection(\n\t\t\t\t\t\t\t\t\tname, scalarType, null, null,\n\t\t\t\t\t\t\t\t\tnew CollectionProviderForTargetCollection<IScalarData<AbstractData>>() {\n\t\t\t\t\t\t\t\t\t\t@Override\n\t\t\t\t\t\t\t\t\t\tpublic Collection<IScalarData<AbstractData>> provideCollection(\n\t\t\t\t\t\t\t\t\t\t\t\tfinal Collection<IScalarData<AbstractData> targetCollection, final Class<IScalarData<AbstractData>> scalarCollectionType) {\n\t\t\t\t\t\t\t\t\t\t\treturn null;\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tabstract class CollectionProviderForTargetCollection<S> {\n\t\t\t\tabstract public Collection<S> provideCollection(Collection<S> targetCollection, Class<S> scalarCollectionType);\n\t\t\t}\n\n\t\t\tprivate <S> Collection<S> createLazyCollection(String name,\n\t\t\t\t\tClass<?> scalarType, final Collection<AbstractData> valueObjectCollection,\n\t\t\t\t\tfinal Class<S> scalarCollectionType, CollectionProviderForTargetCollection<S> collectionProvider) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t});\n\t}\n}";
        String expectedUnitToString = "import java.util.Collection;\npublic class X {\n\tpublic abstract class AbstractData {\n\t\tjava.lang.Object(0)\n\t}\n\tpublic interface IScalarData {\n\t}\n\tprivate static interface ValueObjectPropertyIterator {\n\t\tpublic void iterateOnValueObjectProperty(IScalarData<T> scalarObject, T valueObject, Class<?> valueObjectType, String name, Class<?> scalarType, ) throws Exception, {}\n\t}\n\tjava.lang.Object(0)\n\tprivate static void iterateOnValueObjectProperties(IScalarData<T> scalarObject, T valueObject, ValueObjectPropertyIterator valueObjectPropertyIterator, ) {}\n\tpublic static void loadScalarFromValueObject(IScalarData<T> scalarObject, T valueObject, ) {}\n}";
        String testName = "test81: full parse";
        this.fullParse(s, testName, options);
        SourceElementParserTest.assertEquals("Invalid source " + testName, expectedUnitToString, this.currentType.toString());
    }
}

