/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.core.util.IClassFileReader;

public class ClassFileReaderTest_1_5
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        return ClassFileReaderTest_1_5.buildMinimalComplianceTestSuite(ClassFileReaderTest_1_5.testClass(), 4);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.ClassFileReaderTest_1_5");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ClassFileReaderTest_1_5(String name) {
        super(name);
    }

    private void checkClassFileUsingInputStream(String directoryName, String className, String source, String expectedOutput, int mode) throws IOException {
        this.compileAndDeploy(source, directoryName, className);
        BufferedInputStream inputStream = null;
        try {
            File directory = new File(EVAL_DIRECTORY, directoryName);
            if (!directory.exists()) {
                ClassFileReaderTest_1_5.assertTrue((String)(".class file not generated properly in " + directory), (boolean)false);
            }
            File f = new File(directory, String.valueOf(className) + ".class");
            inputStream = new BufferedInputStream(new FileInputStream(f));
            IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((InputStream)inputStream, (int)65535);
            ClassFileReaderTest_1_5.assertNotNull((Object)classFileReader);
            String result = ToolFactory.createDefaultClassFileDisassembler().disassemble(classFileReader, "\n", mode);
            int index = result.indexOf(expectedOutput);
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(Util.displayString(result, 3));
            }
            if (index == -1) {
                ClassFileReaderTest_1_5.assertEquals("Wrong contents", expectedOutput, result);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.removeTempClass(className);
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.removeTempClass(className);
    }

    public void test001() throws Exception {
        String source = "public class X {\n\tX(String s) {\n\t}\n\tpublic void foo(int i, long l, String[][]... args) {\n\t}\n}";
        String expectedOutput = "  // Method descriptor #18 (IJ[[[Ljava/lang/String;)V\n  // Stack: 0, Locals: 5\n  public void foo(int i, long l, java.lang.String[][]... args);\n    0  return\n      Line numbers:\n        [pc: 0, line: 5]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n        [pc: 0, pc: 1] local: i index: 1 type: int\n        [pc: 0, pc: 1] local: l index: 2 type: long\n        [pc: 0, pc: 1] local: args index: 4 type: java.lang.String[][][]\n}";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test002() throws Exception {
        String source = "public class X {\n\tpublic static void main(String[] args) {\n\t\tlong[] tab = new long[] {};\n\t\tSystem.out.println(tab.clone());\n\t\tSystem.out.println(tab.clone());\n\t}\n}";
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  newarray long [11]\n     3  astore_1 [tab]\n     4  getstatic java.lang.System.out : java.io.PrintStream [16]\n     7  aload_1 [tab]\n     8  invokevirtual long[].clone() : java.lang.Object [22]\n    11  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [28]\n    14  getstatic java.lang.System.out : java.io.PrintStream [16]\n    17  aload_1 [tab]\n    18  invokevirtual long[].clone() : java.lang.Object [22]\n    21  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [28]\n    24  return\n";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test003() throws Exception {
        String source = "public class Y<W, U extends java.io.Reader & java.io.Serializable> {\n  U field;\n  String field2;\n  <T> Y(T t) {}\n  <T> T foo(T t, String... s) {\n    return t;\n  }\n}";
        String expectedOutput = "public class Y<W,U extends Reader & Serializable> {\n  \n  U field;\n  \n  String field2;\n  \n  <T> Y(T t) {\n  }\n  \n  <T> T foo(T t, String... s) {\n    return null;\n  }\n}";
        this.checkClassFile("", "Y", source, expectedOutput, 24);
    }

    public void test004() throws Exception {
        String source = "public class Y<W, U extends java.io.Reader & java.io.Serializable> {\n  U field;\n  String field2;\n  <T> Y(T t) {}\n  <T> T foo(T t, String... s) {\n    return t;\n  }\n}";
        String expectedOutput = "public class Y<W,U extends java.io.Reader & java.io.Serializable> {\n  \n  U field;\n  \n  java.lang.String field2;\n  \n  <T> Y(T t) {\n  }\n  \n  <T> T foo(T t, java.lang.String... s) {\n    return null;\n  }\n}";
        this.checkClassFile("", "Y", source, expectedOutput, 16);
    }

    public void test005() throws Exception {
        String source = "public class X {\n\tX(String s) {\n\t}\n\tpublic static void foo(int i, long l, String[][]... args) {\n\t}\n}";
        String expectedOutput = "  // Method descriptor #18 (IJ[[[Ljava/lang/String;)V\n  // Stack: 0, Locals: 4\n  public static void foo(int i, long l, java.lang.String[][]... args);\n    0  return\n      Line numbers:\n        [pc: 0, line: 5]\n      Local variable table:\n        [pc: 0, pc: 1] local: i index: 0 type: int\n        [pc: 0, pc: 1] local: l index: 1 type: long\n        [pc: 0, pc: 1] local: args index: 3 type: java.lang.String[][][]\n}";
        this.checkClassFile("X", source, expectedOutput);
    }

    public void test006() throws Exception {
        String source = "public enum X { \n\t\n\tBLEU(10),\n\tBLANC(20),\n\tROUGE(30);\n\tX(int i) {}\n}\n";
        String expectedOutput = "public enum X {\n  \n  BLEU(0),\n  \n  BLANC(0),\n  \n  ROUGE(0),;\n  \n  private X(int i) {\n  }\n}";
        this.checkClassFile("", "X", source, expectedOutput, 16);
    }

    public void test007() throws Exception {
        String source = "public enum X {\n\tBLEU(0) {\n\t\tpublic String colorName() {\n\t\t\treturn \"BLEU\";\n\t\t}\n\t},\n\tBLANC(1) {\n\t\tpublic String colorName() {\n\t\t\treturn \"BLANC\";\n\t\t}\n\t},\n\tROUGE(2) {\n\t\tpublic String colorName() {\n\t\t\treturn \"ROUGE\";\n\t\t}\n\t},;\n\t\n\tX(int i) {\n\t}\n\tabstract public String colorName();\n}";
        String expectedOutput = "public enum X {\n  \n  BLEU(0),\n  \n  BLANC(0),\n  \n  ROUGE(0),;\n  \n  private X(int i) {\n  }\n  \n  public abstract java.lang.String colorName();\n}";
        this.checkClassFile("", "X", source, expectedOutput, 16);
    }

    public void test008() throws Exception {
        String source = "interface I {\n\tString colorName();\n}\npublic enum X implements I {\n\tBLEU(0) {\n\t\tpublic String colorName() {\n\t\t\treturn \"BLEU\";\n\t\t}\n\t},\n\tBLANC(1) {\n\t\tpublic String colorName() {\n\t\t\treturn \"BLANC\";\n\t\t}\n\t},\n\tROUGE(2) {\n\t\tpublic String colorName() {\n\t\t\treturn \"ROUGE\";\n\t\t}\n\t},;\n\t\n\tX(int i) {\n\t}\n}";
        String expectedOutput = "public enum X implements I {\n  \n  BLEU(0),\n  \n  BLANC(0),\n  \n  ROUGE(0),;\n  \n  private X(int i) {\n  }\n}";
        this.checkClassFile("", "X", source, expectedOutput, 16);
    }

    public void test009() throws Exception {
        String source = "@interface X {\n\tString firstName();\n\tString lastName() default \"Smith\";\n}\n";
        String expectedOutput = "abstract @interface X {\n  \n  public abstract java.lang.String firstName();\n  \n  public abstract java.lang.String lastName() default \"Smith\";\n}";
        this.checkClassFile("", "X", source, expectedOutput, 16);
    }

    public void test010() throws Exception {
        String source = "@interface X {\n\tString firstName();\n\tString lastName() default \"Smith\";\n}\n";
        String expectedOutput = "abstract @interface X {\n  \n  public abstract java.lang.String firstName();\n  \n  public abstract java.lang.String lastName() default \"Smith\";\n}";
        this.checkClassFileUsingInputStream("", "X", source, expectedOutput, 16);
    }

    public void test011() throws Exception {
        String source = "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Target(value={})\n@Retention(value=RetentionPolicy.RUNTIME)\npublic @interface X {}";
        String expectedOutput = "public abstract @interface X extends java.lang.annotation.Annotation {\n  Constant pool:\n    constant #1 class: #2 X\n    constant #2 utf8: \"X\"\n    constant #3 class: #4 java/lang/Object\n    constant #4 utf8: \"java/lang/Object\"\n    constant #5 class: #6 java/lang/annotation/Annotation\n    constant #6 utf8: \"java/lang/annotation/Annotation\"\n    constant #7 utf8: \"SourceFile\"\n    constant #8 utf8: \"X.java\"\n    constant #9 utf8: \"RuntimeVisibleAnnotations\"\n    constant #10 utf8: \"Ljava/lang/annotation/Target;\"\n    constant #11 utf8: \"value\"\n    constant #12 utf8: \"Ljava/lang/annotation/Retention;\"\n    constant #13 utf8: \"Ljava/lang/annotation/RetentionPolicy;\"\n    constant #14 utf8: \"RUNTIME\"\n\n  RuntimeVisibleAnnotations: \n    #10 @java.lang.annotation.Target(\n      #11 value=[\n        ]\n    )\n    #12 @java.lang.annotation.Retention(\n      #11 value=java.lang.annotation.RetentionPolicy.RUNTIME(enum type #13.#14)\n    )\n}";
        this.checkClassFile("", "X", source, expectedOutput, 4);
    }

    public void test012() throws Exception {
        String source = "@Deprecated\npackage p;";
        String expectedOutput = "abstract interface p.package-info {\n}";
        if (this.complianceLevel > 0x310000L) {
            expectedOutput = "abstract synthetic interface p.package-info {\n}";
        }
        this.checkClassFile("p", "package-info", source, expectedOutput, 2);
    }

    public void test013() throws Exception {
        String source = "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Target(value={})\n@Retention(value=RetentionPolicy.RUNTIME)\npublic @interface X {}";
        String expectedOutput = "public abstract @interface X extends Annotation {\n  Constant pool:\n    constant #1 class: #2 X\n    constant #2 utf8: \"X\"\n    constant #3 class: #4 java/lang/Object\n    constant #4 utf8: \"java/lang/Object\"\n    constant #5 class: #6 java/lang/annotation/Annotation\n    constant #6 utf8: \"java/lang/annotation/Annotation\"\n    constant #7 utf8: \"SourceFile\"\n    constant #8 utf8: \"X.java\"\n    constant #9 utf8: \"RuntimeVisibleAnnotations\"\n    constant #10 utf8: \"Ljava/lang/annotation/Target;\"\n    constant #11 utf8: \"value\"\n    constant #12 utf8: \"Ljava/lang/annotation/Retention;\"\n    constant #13 utf8: \"Ljava/lang/annotation/RetentionPolicy;\"\n    constant #14 utf8: \"RUNTIME\"\n\n  RuntimeVisibleAnnotations: \n    #10 @Target(\n      #11 value=[\n        ]\n    )\n    #12 @Retention(\n      #11 value=RetentionPolicy.RUNTIME(enum type #13.#14)\n    )\n}";
        this.checkClassFile("", "X", source, expectedOutput, 12);
    }

    public void test014() throws Exception {
        String source = "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Target(value={})\n@Retention(value=RetentionPolicy.RUNTIME)\npublic @interface X {}";
        String expectedOutput = "@Target(value={})\n@Retention(value=RetentionPolicy.RUNTIME)\npublic abstract @interface X extends Annotation {\n\n}";
        this.checkClassFile("", "X", source, expectedOutput, 9);
    }

    public void test015() throws Exception {
        String source = "import java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\npublic class X {\n        public void foo(@Deprecated @Annot(2) int i) {}\n}\n@Retention(CLASS)\n@interface Annot {\n        int value() default -1;\n}";
        String expectedOutput = "  public void foo(@Deprecated @Annot(value=(int) 2) int i);";
        this.checkClassFile("", "X", source, expectedOutput, 9);
    }

    public void test016() throws Exception {
        String source = "public @interface MonAnnotation {\n\tString test1() default \"\\0\";\n\tchar test2() default '\\0';\n}\n";
        String expectedOutput = "  public abstract char test2() default '\\0';";
        this.checkClassFile("", "MonAnnotation", source, expectedOutput, 9);
    }
}

