/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Compliance_1_5
extends AbstractComparableTest {
    boolean docSupport = false;
    static /* synthetic */ Class class$0;

    public Compliance_1_5(String name) {
        super(name);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        if (this.docSupport) {
            options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
            options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
        }
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        return options;
    }

    public static Test suite() {
        return Compliance_1_5.buildComparableTestSuite(Compliance_1_5.testClass());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.docSupport = false;
    }

    public void test010() {
        this.runConformTest(new String[]{"p1/Z.java", "package p1; \npublic class Z {\t\n\tpublic static void main(String[] arguments) { \n\t\tString[] s = new String[]{\"SUCCESS\" };\t\n\t\tSystem.out.print(s.length);\t\n\t\tSystem.out.print(((String[])s.clone())[0]);\t\n\t} \n} \n"}, "1SUCCESS");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1; \npublic class X { \n\tvoid foo() { \n\t\twhile (false);\t\n\t\twhile (false) System.out.println(\"unreachable\");\t\n\t\tdo ; while (false);\t\n\t\tdo System.out.println(\"unreachable\"); while (false);\t\n\t\tfor (;false;);\t\n\t\tfor (;false;) System.out.println(\"unreachable\");\t\n\t\tif (false);\t\n\t\tif (false)System.out.println(\"unreachable\");\t\t\n\t}\t\n} \n"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\twhile (false);\t\n\t             ^\nUnreachable code\n----------\n2. ERROR in p1\\X.java (at line 5)\n\twhile (false) System.out.println(\"unreachable\");\t\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n3. ERROR in p1\\X.java (at line 8)\n\tfor (;false;);\t\n\t             ^\nUnreachable code\n----------\n4. ERROR in p1\\X.java (at line 9)\n\tfor (;false;) System.out.println(\"unreachable\");\t\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n5. WARNING in p1\\X.java (at line 10)\n\tif (false);\t\n\t          ^\nDead code\n----------\n6. WARNING in p1\\X.java (at line 11)\n\tif (false)System.out.println(\"unreachable\");\t\t\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n");
    }

    public void test012() {
        this.runConformTest(new String[]{"p1/Y.java", "package p1;\t\nclass Store {\t\n\tString value;\t\n\tStore(String value){\t\n\t\tthis.value = value;\t\n\t}\t\n}\t\nclass Top {\t\n\tstatic String bar = \"Top.bar\";\t\n\tString foo = \"Top.foo\";\t\n\tStore store = new Store(\"Top.store\");\t\n\tstatic Store sstore = new Store(\"Top.sstore\");\t\n\tstatic Top ss = new Top();\t\n}\t\npublic class Y extends Updated {\t\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew Y().test();\t\n\t}\t\n\tvoid test() {\t\t\n\t\tSystem.out.print(\"*** FIELD ACCESS ***\");\t\n\t\tSystem.out.print(\"*1* new Updated().bar: \" + new Updated().bar);\t\n\t\tSystem.out.print(\"*2* new Updated().foo: \" + new Updated().foo);\t\n\t\tSystem.out.print(\"*3* new Y().foo: \" + new Y().foo);\t\n\t\tSystem.out.print(\"*4* new Y().bar: \" + new Y().bar);\t\n\t\tSystem.out.print(\"*5* bar: \" + bar);\t\n\t\tSystem.out.print(\"*6* foo: \" + foo);\t\n\t\tSystem.out.print(\"*7* Y.bar: \" + Y.bar);\t\n\t\tSystem.out.print(\"*8* this.bar: \" + this.bar);\t\n\t\tSystem.out.print(\"*9* this.foo: \" + this.foo);\t\n\t\tSystem.out.print(\"*10* store.value: \" + store.value);\t\n\t\tSystem.out.print(\"*11* sstore.value: \" + sstore.value);\t\n\t\tSystem.out.print(\"*12* ss.sstore.value: \" + ss.sstore.value);\t\n\t}\t\t\n}\t\t\n", "p1/Updated.java", "package p1;\t\npublic class Updated extends Top {\t\n}\t\n"}, "*** FIELD ACCESS ****1* new Updated().bar: Top.bar*2* new Updated().foo: Top.foo*3* new Y().foo: Top.foo*4* new Y().bar: Top.bar*5* bar: Top.bar*6* foo: Top.foo*7* Y.bar: Top.bar*8* this.bar: Top.bar*9* this.foo: Top.foo*10* store.value: Top.store*11* sstore.value: Top.sstore*12* ss.sstore.value: Top.sstore");
        this.runConformTest(new String[]{"p1/Updated.java", "package p1; \npublic class Updated extends Top { \n\tpublic static void main(String[] arguments) { \n\t\tY.main(arguments);\t\n\t}\t\n\tstatic String bar = \"Updated.bar\";\t\n\tString foo = \"Updated.foo\";\t\n\tStore store = new Store(\"Updated.store\");\t\n\tstatic Store sstore = new Store(\"Updated.sstore\");\t\n\tstatic Updated ss = new Updated();\t\n} \n"}, "*** FIELD ACCESS ****1* new Updated().bar: Updated.bar*2* new Updated().foo: Updated.foo*3* new Y().foo: Updated.foo*4* new Y().bar: Updated.bar*5* bar: Updated.bar*6* foo: Updated.foo*7* Y.bar: Updated.bar*8* this.bar: Updated.bar*9* this.foo: Updated.foo*10* store.value: Updated.store*11* sstore.value: Updated.sstore*12* ss.sstore.value: Top.sstore", null, false, null);
    }

    public void test013() {
        this.runConformTest(new String[]{"p1/Y.java", "package p1;\t\nclass Store {\t\n\tString value;\t\n\tStore(String value){\t\n\t\tthis.value = value;\t\n\t}\t\n}\t\nclass Top {\t\n\tstatic String bar() { return \"Top.bar()\"; }\t\n\tString foo() { return \"Top.foo()\"; }\t\n}\t\npublic class Y extends Updated {\t\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew Y().test();\t\n\t}\t\n\tvoid test() {\t\t\n\t\tSystem.out.print(\"*** METHOD ACCESS ***\");\t\n\t\tSystem.out.print(\"*1* new Updated().bar(): \" + new Updated().bar());\t\n\t\tSystem.out.print(\"*2* new Updated().foo(): \" + new Updated().foo());\t\n\t\tSystem.out.print(\"*3* new Y().foo(): \" + new Y().foo());\t\n\t\tSystem.out.print(\"*4* new Y().bar(): \" + new Y().bar());\t\n\t\tSystem.out.print(\"*5* bar(): \" + bar());\t\n\t\tSystem.out.print(\"*6* foo(): \" + foo());\t\n\t\tSystem.out.print(\"*7* Y.bar(): \" + Y.bar());\t\n\t\tSystem.out.print(\"*8* this.bar(): \" + this.bar());\t\n\t\tSystem.out.print(\"*9* this.foo(): \" + this.foo());\t\n\t}\t\t\n}\t\t\n", "p1/Updated.java", "package p1;\t\npublic class Updated extends Top {\t\n}\t\n"}, "*** METHOD ACCESS ****1* new Updated().bar(): Top.bar()*2* new Updated().foo(): Top.foo()*3* new Y().foo(): Top.foo()*4* new Y().bar(): Top.bar()*5* bar(): Top.bar()*6* foo(): Top.foo()*7* Y.bar(): Top.bar()*8* this.bar(): Top.bar()*9* this.foo(): Top.foo()");
        this.runConformTest(false, new String[]{"p1/Updated.java", "package p1; \npublic class Updated extends Top { \n\tpublic static void main(String[] arguments) { \n\t\tY.main(arguments);\t\n\t}\t\n\tstatic String bar() { return \"Updated.bar()\"; }\t\n\tString foo() { return \"Updated.foo()\"; }\t\n} \n"}, null, "*** METHOD ACCESS ****1* new Updated().bar(): Updated.bar()*2* new Updated().foo(): Updated.foo()*3* new Y().foo(): Updated.foo()*4* new Y().bar(): Updated.bar()*5* bar(): Updated.bar()*6* foo(): Updated.foo()*7* Y.bar(): Updated.bar()*8* this.bar(): Updated.bar()*9* this.foo(): Updated.foo()", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacThrowsAnExceptionForJava_1_5_0_16);
    }

    public void test014() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\nclass T {\t\n\tvoid foo(boolean b) {\t\n\t\t System.out.print(\"T.foo(boolean)#\"); \t\n\t}\t\n\tboolean bar = false;\t\n\tclass Member {\t\n\t\tvoid display(){ System.out.print(\"T.Member#\"); }\t\n\t}\t\n}\t\npublic class X {\t\n\tvoid foo(int i) {\t\n\t\t System.out.println(\"X.foo(int)#\"); \t\t\t\n\t}\t\n\tint bar;\t\n\tclass Member {\t\n\t\tvoid display(){ System.out.print(\"X.Member#\"); }\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().bar();\t\n\t}\t\t\t\t\n\tvoid bar() { \t\n\t\tnew T() {\t\n\t\t\t{\t\n\t\t\t\tfoo(true);\t\n\t\t\t\tSystem.out.print((boolean)bar + \"#\");\t\n\t\t\t\tMember m = new Member();\t\n\t\t\t\tm.display();\t\n\t\t\t} \t\n\t\t};\t\n\t}\t\n}\t\n"}, "T.foo(boolean)#false#T.Member#");
    }

    public void test015() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tC c = new C() {\t\n\t\t\tpublic void doSomething(){\t\n\t\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t\t}\t\n\t\t};\t\n\t\tc.doSomething();\t\n\t}\t\n}\t\ninterface I {\t\n\tvoid doSomething();\t\n}\t\nabstract class C implements I {\t\n}\t\n"}, "SUCCESS");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "class T {\t\n      void foo(boolean b) {}\t\n}\t\npublic class X {\t\n      void foo(int i) {}\t\n      void bar() {\t\n            new T() {\t\n                  {\t\n                        foo(0); \t\n                  }\t\n            };\t\n      }\t\n} \t\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tfoo(0); \t\n\t^^^\nThe method foo(boolean) in the type T is not applicable for the arguments (int)\n----------\n");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "class T {\t\n      void foo(boolean b) { System.out.println(\"SUCCESS\"); }\t\n}\t\npublic class X {\t\n      void foo(int i) {}\t\n      void bar() {\t\n            new T() {\t\n                  {\t\n                        foo(false); \t\n                  }\t\n            };\t\n      }\t\n      public static void main(String[] arguments) {\t\n\t\t\tnew X().bar();\t\n      }\t\n} \t\n"}, "SUCCESS");
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "class T {\t\n      void foo(int j) { System.out.println(\"SUCCESS\"); }\t\n}\t\npublic class X {\t\n      void foo(int i) {}\t\n      void bar() {\t\n            new T() {\t\n                  {\t\n                        foo(0); \t\n                  }\t\n            };\t\n      }\t\n      public static void main(String[] arguments) {\t\n\t\t\tnew X().bar();\t\n      }\t\n} \t\n"}, "SUCCESS");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "class T {\t\n      void foo(int j) { System.out.println(\"SUCCESS\"); }\t\n}\t\nclass U {\t\n      void foo(int j) { System.out.println(\"FAILED\"); }\t\n}\t\npublic class X extends U {\t\n      void bar() {\t\n            new T() {\t\n                  {\t\n                        foo(0); \t\n                  }\t\n            };\t\n      }\t\n      public static void main(String[] arguments) {\t\n\t\t\tnew X().bar();\t\n      }\t\n} \t\n"}, "SUCCESS");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "class T {\t\n      void foo(int j) { System.out.println(\"SUCCESS\"); }\t\n}\t\nclass U {\t\n      void foo(boolean j) { System.out.println(\"FAILED\"); }\t\n}\t\npublic class X extends U {\t\n      void bar() {\t\n            new T() {\t\n                  {\t\n                        foo(0); \t\n                  }\t\n            };\t\n      }\t\n      public static void main(String[] arguments) {\t\n\t\t\tnew X().bar();\t\n      }\t\n} \t\n"}, "SUCCESS");
    }

    public void test020a() {
        this.runConformTest(new String[]{"X.java", "class T {\t\n      void foo(U j) { System.out.println(\"SUCCESS\"); }\t\n}\t\nclass U {\t\n}\t\npublic class X extends U {\t\n      void foo(X j) { System.out.println(\"FAILED\"); }\t\n      void bar() {\t\n            new T() {\t\n                  {\t\n                        foo(new X()); \t\n                  }\t\n            };\t\n      }\t\n      public static void main(String[] arguments) {\t\n\t\t\tnew X().bar();\t\n      }\t\n} \t\n"}, "SUCCESS");
    }

    public void test021() {
        boolean check;
        this.runConformTest(new String[]{"p1/Z.java", "package p1;\t\npublic class Z extends AbstractA {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew Z().init(); \t\n\t}\t\n}\t\nabstract class AbstractB implements K {\t\n\tpublic void init() {\t\n\t\tSystem.out.println(\"AbstractB.init()\");\t\n\t}\t\n}\t\ninterface K {\t\n\tvoid init();\t\n\tvoid init(int i);\t\n}\t\n", "p1/AbstractA.java", "package p1;\t\npublic abstract class AbstractA extends AbstractB implements K {\t\n\tpublic void init(int i) {\t\n\t}\t\n}\t\n"}, "AbstractB.init()");
        String computedReferences = this.findReferences(String.valueOf(OUTPUT_DIR) + "/p1/Z.class");
        boolean bl = check = computedReferences.indexOf("constructorRef/Z/0") >= 0 && computedReferences.indexOf("methodRef/init/0") >= 0;
        if (!check) {
            System.out.println(computedReferences);
        }
        Compliance_1_5.assertTrue((String)"did not bind 'new Z().init()' to Z.init()'", (boolean)check);
    }

    public void test022() {
        this.runNegativeTest(new String[]{"p1/T.java", "package p1;\t\ninterface II {}\t\nclass TT {\t\n\tvoid foo(boolean b) {}\t\n\tvoid foo(int i, boolean b) {}\t\n\tvoid foo(String s) {}\t\n}\t\npublic abstract class T implements II {\t\n\tvoid foo(int i) {}\t\n\tvoid bar() {\t\n\t\tnew TT() {\t\n\t\t\t{\t\n\t\t\t\tfoo(0); // should say that foo(int, boolean) isn't applicable\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n\tvoid boo() {\t\n\t\tnew TT() {\t\n\t\t\t{\t\n\t\t\t\tfoo(true); // should not complain about ambiguity\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n} \t\n"}, "----------\n1. ERROR in p1\\T.java (at line 13)\n\tfoo(0); // should say that foo(int, boolean) isn't applicable\t\n\t^^^\nThe method foo(int, boolean) in the type TT is not applicable for the arguments (int)\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"p1/T.java", "package p1;\t\ninterface II {}\t\nabstract class TT {\t\n\tvoid foo(boolean b) {}\t\n\tvoid foo(int i, boolean b) {}\t\n\tvoid foo(String s) {}\t\n}\t\npublic abstract class T implements II {\t\n\tvoid foo(int i) {}\t\n\tvoid bar() {\t\n\t\tnew TT() {\t\n\t\t\t{\t\n\t\t\t\tfoo(0); // should say that foo(int, boolean) isn't applicable\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n\tvoid boo() {\t\n\t\tnew TT() {\t\n\t\t\t{\t\n\t\t\t\tfoo(true); // should complain ambiguity\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n} \t\n"}, "----------\n1. ERROR in p1\\T.java (at line 13)\n\tfoo(0); // should say that foo(int, boolean) isn't applicable\t\n\t^^^\nThe method foo(int, boolean) in the type TT is not applicable for the arguments (int)\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\t\ninterface II {}\t\nabstract class T implements II {\t\n\tvoid foo(boolean b) {}\t\n\tvoid foo(int i, boolean b) {}\t\n}\t\nabstract class TT implements II {\t\n\tvoid foo(boolean b) {}\t\n}\t\npublic class X {\t\n\tvoid foo(int i) {}\t\n\tvoid bar() {\t\n\t\tnew T() {\t\n\t\t\t{\t\n\t\t\t\tfoo(0); // javac says foo cannot be resolved because of multiple matches\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n\tvoid bar2() {\t\n\t\tnew TT() {\t\n\t\t\t{\t\n\t\t\t\tfoo(0); // should say that foo(boolean) isn't applicable\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n\tvoid boo() {\t\n\t\tnew T() {\t\n\t\t\t{\t\n\t\t\t\tfoo(true); // should complain ambiguity\t\n\t\t\t}\t\n\t\t};\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p1\\X.java (at line 15)\n\tfoo(0); // javac says foo cannot be resolved because of multiple matches\t\n\t^^^\nThe method foo(int, boolean) in the type T is not applicable for the arguments (int)\n----------\n2. ERROR in p1\\X.java (at line 22)\n\tfoo(0); // should say that foo(boolean) isn't applicable\t\n\t^^^\nThe method foo(boolean) in the type TT is not applicable for the arguments (int)\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\t\npublic class X extends AbstractY {\t\n\tvoid bar(){\t\n\t\tinit(\"hello\");\t\n\t}\t\t\n}\t\nabstract class AbstractY implements I {\t\n}\t\ninterface I {\t\n\tvoid init(String s, int i);\t\n}\t\n"}, "----------\n1. ERROR in p1\\X.java (at line 2)\n\tpublic class X extends AbstractY {\t\n\t             ^\nThe type X must implement the inherited abstract method I.init(String, int)\n----------\n2. ERROR in p1\\X.java (at line 4)\n\tinit(\"hello\");\t\n\t^^^^\nThe method init(String, int) in the type I is not applicable for the arguments (String)\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\t\npublic class X extends AbstractY {\t\n\tvoid bar(){\t\n\t\tinit(\"hello\");\t\n\t}\t\t\n}\t\nclass AbstractY implements I {\t\n}\t\ninterface I {\t\n\tvoid init(String s, int i);\t\n}\t\n"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\tinit(\"hello\");\t\n\t^^^^\nThe method init(String, int) in the type I is not applicable for the arguments (String)\n----------\n2. ERROR in p1\\X.java (at line 7)\n\tclass AbstractY implements I {\t\n\t      ^^^^^^^^^\nThe type AbstractY must implement the inherited abstract method I.init(String, int)\n----------\n");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tfor (;false;p());\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n\tstatic void p(){\t\n\t\tSystem.out.println(\"FAILED\");\t\n\t}\t\n}\t\n"}, "----------\n1. WARNING in p1\\X.java (at line 4)\n\tfor (;false;p());\t\n\t            ^^^\nDead code\n----------\n2. ERROR in p1\\X.java (at line 4)\n\tfor (;false;p());\t\n\t                ^\nUnreachable code\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\ninterface FooInterface {\t\n\tpublic boolean foo(int a);\t\n\tpublic boolean bar(int a);\t\n}\t\npublic class X extends Z {\t\n\tpublic boolean foo(int a){ return true; }\t\n\tpublic boolean bar(int a){ return false; }\t\n\tpublic static void main(String[] arguments) {\t\n\t\tSystem.out.println(new X().test(0));\t\n\t}\t\n}\nabstract class Z implements FooInterface {\t\n\tpublic boolean foo(int a, int b) {\t\n\t\treturn true;\t\n\t}\t\n\tpublic String test(int a) {\t\n\t\tboolean result = foo(a); \n\t\tif (result)\t\n\t\t\treturn \"SUCCESS\";\t\n\t\telse\t\n\t\t\treturn \"FAILED\";\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test029() {
        this.runConformTest(new String[]{"p/X.java", "package p;\t\npublic class X {\t\n\tpublic static void main(String[] args) {\t\n\t\tnew X();\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}  \t\n\tWoof woof_1;\t\n\tpublic class Honk {\t\n\t\tInteger honks;\t\n\t}\t\n\tpublic class Meow {\t\n\t\tHonk honk_1;\t\n\t}\t\n\tpublic class Woof {\t\n\t\tMeow meow_1;\t\n\t}\t\n\tpublic void setHonks(int num) {\t\n\t\t// This is the line that causes the VerifyError\t\n\t\twoof_1.meow_1.honk_1.honks = new Integer(num);\t\n\t\t// Here is equivalent code that does not cause the error.\t\n\t\t//  Honk h = woof_1.moo_1.meow_1.honk_1;\t\n\t\t//  h.honks = new Integer(num);\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic class X {\t\n\tpublic static void main(String[] args){\t\n\t\tnew q.X2().foo(\"String\");\t\n\t\tnew q.X2().bar(\"String\");\t\n\t\tnew q.X2().barbar(\"String\");\t\n\t\tnew q.X2().baz(\"String\");\t\n\t}\t\n}\t\n", "p/X1.java", "package p;\t\npublic abstract class X1 {\t\n\tprotected void foo(Object o){\tSystem.out.println(\"X1.foo(Object)\"); }\t\n\tprotected void bar(Object o){\tSystem.out.println(\"X1.bar(Object)\"); }\t\n\tvoid barbar(Object o){\tSystem.out.println(\"X1.barbar(Object)\"); }\t\n\tprotected void baz(Object o) { System.out.println(\"X1.baz(Object)\"); }\t\n}\t\n", "q/X2.java", "package q;\t\npublic class X2 extends p.X1 {\t\n\tprotected void foo(int i) { System.out.println(\"X2.foo(int)\"); }\t\n\tprotected void bar(Object o) { System.out.println(\"X2.bar(Object)\"); }\t\n\tvoid barbar(Object o){\tSystem.out.println(\"X2.barbar(Object)\"); }\t\n\tprotected void baz(String s) {\tSystem.out.println(\"X2.baz(String)\"); }\t\n}\t\n"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\tnew q.X2().bar(\"String\");\t\n\t           ^^^\nThe method bar(Object) from the type X2 is not visible\n----------\n2. ERROR in p\\X.java (at line 6)\n\tnew q.X2().barbar(\"String\");\t\n\t           ^^^^^^\nThe method barbar(Object) from the type X2 is not visible\n----------\n----------\n1. WARNING in q\\X2.java (at line 4)\n\tprotected void bar(Object o) { System.out.println(\"X2.bar(Object)\"); }\t\n\t               ^^^^^^^^^^^^^\nThe method bar(Object) of type X2 should be tagged with @Override since it actually overrides a superclass method\n----------\n2. WARNING in q\\X2.java (at line 5)\n\tvoid barbar(Object o){\tSystem.out.println(\"X2.barbar(Object)\"); }\t\n\t     ^^^^^^^^^^^^^^^^\nThe method X2.barbar(Object) does not override the inherited method from X1 since it is private to a different package\n----------\n");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic class X extends q.X2 {\t\n\tpublic static void main(String[] args){\t\n\t\t\tnew X().doSomething();\t\n\t}\t\n\tvoid doSomething(){\t\n\t\tfoo(\"String\");\t\n\t\tbar(\"String\");\t\n\t\tbarbar(\"String\");\t\n\t\tbaz(\"String\");\t\n\t}\t\n}\t\n", "p/X1.java", "package p;\t\npublic abstract class X1 {\t\n\tprotected void foo(Object o){\tSystem.out.println(\"X1.foo(Object)\"); }\t\n\tprotected void bar(Object o){\tSystem.out.println(\"X1.bar(Object)\"); }\t\n\tvoid barbar(Object o){\tSystem.out.println(\"X1.barbar(Object)\"); }\t\n\tprotected void baz(Object o) { System.out.println(\"X1.baz(Object)\"); }\t\n}\t\n", "q/X2.java", "package q;\t\npublic class X2 extends p.X1 {\t\n\tprotected void foo(int i) { System.out.println(\"X2.foo(int)\"); }\t\n\tprotected void bar(Object o) { System.out.println(\"X2.bar(Object)\"); }\t\n\tvoid barbar(Object o){\tSystem.out.println(\"X2.barbar(Object)\"); }\t\n\tprotected void baz(String s) {\tSystem.out.println(\"X2.baz(String)\"); }\t\n}\t\n"}, "----------\n1. ERROR in p\\X.java (at line 9)\n\tbarbar(\"String\");\t\n\t^^^^^^\nThe method barbar(Object) from the type X2 is not visible\n----------\n----------\n1. WARNING in q\\X2.java (at line 4)\n\tprotected void bar(Object o) { System.out.println(\"X2.bar(Object)\"); }\t\n\t               ^^^^^^^^^^^^^\nThe method bar(Object) of type X2 should be tagged with @Override since it actually overrides a superclass method\n----------\n2. WARNING in q\\X2.java (at line 5)\n\tvoid barbar(Object o){\tSystem.out.println(\"X2.barbar(Object)\"); }\t\n\t     ^^^^^^^^^^^^^^^^\nThe method X2.barbar(Object) does not override the inherited method from X1 since it is private to a different package\n----------\n");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic class X {\t\n\tpublic static void main(String[] args){\t\n\t\tSystem.out.println(new q.X2().foo);\t\n\t\tSystem.out.println(new q.X2().bar);\t\n\t}\t\n}\t\n", "p/X1.java", "package p;\t\npublic abstract class X1 {\t\n\tprotected String foo = \"X1.foo\"; \t\n\tString bar = \"X1.bar\";\t\n}\t\n", "q/X2.java", "package q;\t\npublic class X2 extends p.X1 {\t\n\tprotected String foo = \"X2.foo\";\t\n\tString bar = \"X2.bar\";\t\n}\t\n"}, "----------\n1. ERROR in p\\X.java (at line 4)\n\tSystem.out.println(new q.X2().foo);\t\n\t                              ^^^\nThe field X2.foo is not visible\n----------\n2. ERROR in p\\X.java (at line 5)\n\tSystem.out.println(new q.X2().bar);\t\n\t                              ^^^\nThe field X2.bar is not visible\n----------\n----------\n1. WARNING in q\\X2.java (at line 3)\n\tprotected String foo = \"X2.foo\";\t\n\t                 ^^^\nThe field X2.foo is hiding a field from type X1\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"A.java", "public class A {\t\n  public int m;\t\n  public void pp() {\t\n     C c = new C(4);\t\n     System.out.println(c.get());\t\n  }\t\n  public static void main(String[] args) {\t\n     A a = new A();\t\n\t  try {\t\n       a.pp(); \t\n\t\tSystem.out.println(\"SyntheticInit BEFORE SuperConstructorCall\");\t\n\t  } catch(NullPointerException e) {\t\n\t\tSystem.out.println(\"SyntheticInit AFTER SuperConstructorCall\"); // should no longer occur with target 1.4 \n\t  }\t\n  }\t\n  class C extends B {\t\n    public C(int x1) {\t\n      super(x1);    \t\n    }\t\n    protected void init(int x1) {\t\n       x = m * x1; // <- NULL POINTER EXCEPTION because of m\t\n    }  \t\n  }\t\n}\t\nclass B {\t\n  int x;\t\n  public B(int x1) {\t\n    init(x1);\t\n  }\t\n  protected void init(int x1) {\t\n    x  = x1;\t\n  }\t\n  public int get() {\t\n    return x;\t\n  }\t\n}\t\n"}, "0\nSyntheticInit BEFORE SuperConstructorCall");
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().new X2();\t\n\t}\t\n\tclass X1 {\t\n\t\tX1(){\t\n\t\t\tthis.baz();\t\n\t\t}\t\n\t\tvoid baz() {\t\n\t\t\tSystem.out.println(\"-X1.baz()\");\t\n\t\t}\t\n\t}\t\n\tclass X2 extends X1 {\t\n\t\tvoid baz() {\t\n\t\t\tSystem.out.print(X.this==null ? \"X.this == null\" : \"X.this != null\");\t\n\t\t\tX1 x1 = X.this.new X1(){\t\n\t\t\t\tvoid baz(){\t\n\t\t\t\t\tSystem.out.println(\"-X$1.baz()\");\t\n\t\t\t\t}\t\n\t\t\t};\t\n\t\t}\t\n\t}\t\n}\n"}, "X.this != null-X$1.baz()");
    }

    public void test035() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tclass Y { Y(int i){} }\t\n\tpublic static void main(String[] arguments) {\t\n\t\tint i = 1;\t\n\t\ttry {\t\n\t\t\tX x =null;\t\n\t\t\tx.new Y(++i);\t\n\t\t\tSystem.out.println(\"FAILED\");\t\n\t\t} catch(NullPointerException e){\t\n\t\t\tSystem.out.println(\"SUCCESS:\"+i);\t\n\t\t}\t\n\t}\t\n}\t\n"}, "SUCCESS:1");
    }

    public void test036() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tclass Y {}\t\n\tstatic class Z extends Y {\t\n\t\tZ (X x){\t\n\t\t\tx.super();\t\n\t\t}\t\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\ttry {\t\n\t\t\tnew Z(null);\t\n\t\t\tSystem.out.println(\"FAILED\");\t\n\t\t} catch(NullPointerException e){\t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test037() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.taskTags", "TODO:");
        this.runConformTest(true, new String[]{"p/X.java", "package p;\t\npublic class X {\n}\n// TODO: something"}, null, customOptions, "----------\n1. WARNING in p\\X.java (at line 4)\n\t// TODO: something\n\t   ^^^^^^^^^^^^^^^\nTODO: something\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test038() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.taskTags", "TODO:");
        this.runConformTest(true, new String[]{"X.java", "// TODO: something"}, null, customOptions, "----------\n1. WARNING in X.java (at line 1)\n\t// TODO: something\n\t   ^^^^^^^^^^^^^^^\nTODO: something\n----------\n", null, "java.lang.ClassNotFoundException", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] args){\t\n\t\tfor (;null != null;);\t\n\t\tfor (;null != null;){}\t\n\t\tfor (;false;);\t\n\t\tfor (;false;){}\t\n\t\twhile (false);\t\n\t\twhile (false){}\t\n\t\tif (false) {} else {}\t\n\t\tif (false) ; else ;\t\t\t\n\t\tSystem.out.println(\"FAILED\");\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tfor (;false;);\t\n\t             ^\nUnreachable code\n----------\n2. ERROR in X.java (at line 6)\n\tfor (;false;){}\t\n\t             ^^\nUnreachable code\n----------\n3. ERROR in X.java (at line 7)\n\twhile (false);\t\n\t             ^\nUnreachable code\n----------\n4. ERROR in X.java (at line 8)\n\twhile (false){}\t\n\t             ^^\nUnreachable code\n----------\n5. WARNING in X.java (at line 9)\n\tif (false) {} else {}\t\n\t           ^^\nDead code\n----------\n6. WARNING in X.java (at line 10)\n\tif (false) ; else ;\t\t\t\n\t           ^\nDead code\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tinterface Homonym {}\t\n\tvoid foo() {\t\n\t\tclass Homonym extends X {\t\n\t\t\t{\t\n\t\t\t\tclass Y extends Homonym {};\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n}\t\nclass Homonym extends X {\t\n\t{\t\n\t\tclass Y extends Homonym {};\t\n\t}\t\n}\t\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tclass Homonym extends X {\t\n\t      ^^^^^^^\nThe type Homonym is hiding the type X.Homonym\n----------\n2. ERROR in X.java (at line 6)\n\tclass Y extends Homonym {};\t\n\t                ^^^^^^^\nThe type X.Homonym cannot be the superclass of Y; a superclass must be a class\n----------\n3. ERROR in X.java (at line 13)\n\tclass Y extends Homonym {};\t\n\t                ^^^^^^^\nThe type X.Homonym cannot be the superclass of Y; a superclass must be a class\n----------\n");
    }

    public void test041() {
        this.runConformTest(new String[]{"p/X.java", "package p;\t\npublic class X {\t\n\tvoid foo(int i, float f){}\t\n\tpublic static void main(String[] args) {\t\n\t\tq.Y y = new q.Y.Z();\t\n\t\ty.bar();\t\n\t}\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y extends p.X implements I {\t\n\tpublic void bar(){   foo(1, 2); }\t\n\tpublic static class Z extends Y {\t\n\t\tpublic void foo(float f, int i) {\t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\t\n\t}\t\n}\t\ninterface I {\t\n\tvoid foo(float f, int i);\t\n}\t\n"}, "SUCCESS");
    }

    public void test042() {
        this.runConformTest(new String[]{"p/X.java", "package p;\t\npublic class X extends X0 {\t\n\tvoid foo(int i, float f){}\t\n\tpublic static void main(String[] args) {\t\n\t\tq.Y y = new q.Y.Z();\t\n\t\ty.bar();\t\n\t}\t\n}\t\nclass X0 {\t\n\tvoid foo(int i, double d){}\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y extends p.X implements I {\t\n\tpublic void bar(){   foo(1, 2); }\t\n\tpublic static class Z extends Y {\t\n\t\tpublic void foo(float f, int i) {\t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\t\n\t}\t\n}\t\ninterface I {\t\n\tvoid foo(float f, int i);\t\n}\t\n"}, "SUCCESS");
    }

    public void _test043() {
        this.runConformTest(new String[]{"p1/Y.java", "package p1;\t\npublic class Y extends A implements I { \n\tpublic static void main(String[] args) {\t\n\t\tY.printValues();\t\n\t}\t\n\tpublic static void printValues() {\t\n\t\tSystem.out.println(\"i=\"+i+\",j=\"+j+\",Y.i=\"+Y.i+\",Y.j=\"+Y.j);\t\n\t}\t\n}\t\n", "p1/A.java", "package p1;\t\npublic class A {\t\n\tstatic int i = 1;\t\n}\t\n", "p1/I.java", "package p1;\t\ninterface I {\t\n\tint j = \"aa\".length();\t\n}\t\n"}, "i=1,j=2,Y.i=1,Y.j=2");
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\npublic class A {\t\n\tstatic int j = 3;\t\n\tpublic static void main(String[] args) {\t\n\t\tY.printValues();\t\n\t}\t\n}\t\n", "p1/I.java", "package p1;\t\ninterface I {\t\n\tint j = \"aaaa\".length();\t\n}\t\n"}, "i=4,j=3,Y.i=4,Y.j=3", null, false, null);
    }

    public void test044() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\t\targs.clone();\t\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "     1  invokevirtual java.lang.String[].clone() : java.lang.Object [16]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            Compliance_1_5.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test045() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic class X { \n\tpublic static void main(String[] args) {\t\n\t\tSystem.out.println(\"FAILED\");\t\n\t\treturn;;\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\treturn;;\t\n\t       ^\nUnreachable code\n----------\n");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n}\nabstract class Y extends Z {\n  public abstract void foo();\n}\nabstract class Z extends T {\n}\nclass T implements I {\n  public void foo(){}\n}\ninterface I {\n    public void foo ();\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y {\n\t             ^\nThe type X must implement the inherited abstract method Y.foo()\n----------\n2. WARNING in X.java (at line 4)\n\tpublic abstract void foo();\n\t                     ^^^^^\nThe method foo() of type Y should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X extends AbstractDoubleAlgorithm {\n\t\n\tpublic static void main(String[] args) {\n\t\t((ObjectAlgorithm)(new X())).operate(new Double(0));\n\t}\n    public void operate(Double pDouble)\n    {\n        System.out.println(\"SUCCESS\");\n    }\n}\nabstract class AbstractDoubleAlgorithm implements DoubleAlgorithm {\n    public void operate(Object pObject)\n    {\n        operate((Double)pObject);\n    }\n}\ninterface DoubleAlgorithm extends ObjectAlgorithm {\n    void operate(Double pDouble);\n}\ninterface ObjectAlgorithm {\n    void operate(Object pObject);\n}"}, "SUCCESS");
    }

    public void test048() {
        this.runConformTest(new String[]{"X.java", "public class X extends AbstractDoubleAlgorithm {\n\t\n\tpublic static void main(String[] args) {\n\t\t((ObjectAlgorithm)(new X())).operate(new Double(0));\n\t}\n    public void operate(Double pDouble)\n    {\n        System.out.println(\"SUCCESS\");\n    }\n}\nabstract class AbstractDoubleAlgorithm implements DoubleAlgorithm {\n    public void operate(Object pObject)\n    {\n        operate((Double)pObject);\n    }\n    public void operate(X x) {}\n}\ninterface DoubleAlgorithm extends ObjectAlgorithm {\n    void operate(Double pDouble);\n}\ninterface ObjectAlgorithm {\n    void operate(Object pObject);\n}"}, "SUCCESS");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"pa/Caller.java", "package pa;\nimport pb.Concrete;\npublic class Caller {\n\n\tpublic static void main(String[] args) {\n\t\tConcrete aConcrete = new Concrete(); \n\t\taConcrete.callme();\n\t}\n}\n", "pa/Abstract.java", "package pa;\npublic abstract class Abstract {\n\n\tprotected void callme(){}\n}\n", "pb/Concrete.java", "package pb;\npublic class Concrete extends pa.Abstract {\n\n\tprotected void callme(){\tSystem.out.println(\"SUCCESS\"); }\n}\n"}, "----------\n1. ERROR in pa\\Caller.java (at line 7)\n\taConcrete.callme();\n\t          ^^^^^^\nThe method callme() from the type Concrete is not visible\n----------\n----------\n1. WARNING in pb\\Concrete.java (at line 4)\n\tprotected void callme(){\tSystem.out.println(\"SUCCESS\"); }\n\t               ^^^^^^^^\nThe method callme() of type Concrete should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test050() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static void main(String args[]) {\n     foo();\n  }\n  public static void foo() {\n     int a1 = 1;\n     int a2 = 1;\n     a1 = 2;\n     while (false) {};\n     a2 = 2;\n  }\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 10)\n\twhile (false) {};\n\t              ^^\nUnreachable code\n----------\n");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static void main(String args[]) {\n     foo();\n  }\n  public static void foo() {\n     int a1 = 1;\n     int a2 = 1;\n     a1 = 2;\n     while (false);\n     a2 = 2;\n  }\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 10)\n\twhile (false);\n\t             ^\nUnreachable code\n----------\n");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"p/A.java", "package p;\npublic class A {\n  public static void main(String[] argv) {\n    foo();\n  }\n  private int i;\n  static class Y extends X {\n    int x = i;\n  }\n  public static void foo() {\n    return;\n  }\n}", "p/X.java", "package p;\npublic class X {\n  public static void main(String argv[]) {\n     foo();\n  }\n  public static void foo() {\n     int a1 = 1;\n     int a2 = 1;\n     a1 = 2;\n     while (false);\n     a2 = 2;\n  }\n}"}, "----------\n1. ERROR in p\\A.java (at line 8)\n\tint x = i;\n\t        ^\nCannot make a static reference to the non-static field i\n----------\n----------\n1. ERROR in p\\X.java (at line 10)\n\twhile (false);\n\t             ^\nUnreachable code\n----------\n");
    }

    public void test053() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nclass X {\n  static class A {\n    interface I {\n      int a = 3;\n    }\n  } \n  interface I { \n    int b = 4;\n  }\n  class Y extends A implements I {\n    Object F() {\n      return new I() {\n        int c = a; // WE SHOULD NOT BE ABLE TO SEE BOTH a and b\n        int d = b; // WE SHOULD NOT BE ABLE TO SEE BOTH a and b\n      };\n    }\n  }\n}"});
    }

    public void test054() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  static class A {\n    interface I {\n      int a = 3;\n      void foo();\n    }\n  }\n  interface I {\n    int a = 4;\n    void foo();\n  }\n  class Y extends A implements I {\n    public void foo() {\n      new I() {\n        public void foo() {\n          System.out.println(\"X$1::foo-\" + a);\n        }\n      }\n      .foo();\n    }\n  }\npublic static void main(String argv[]) {\n  new X().new Y().foo();\n}\n}"});
    }

    public void test055() {
        this.runConformTest(true, new String[]{"p/X.java", "package p;\npublic class X {\n  static class A {\n    interface I2 {\n      int a = 3;\n      void foo();\n    }\n  }\n  interface I1 {\n    int a = 4;\n    void foo(int a);\n  }\n  class Y extends A implements I1 {\n    public void foo(int a) {\n      new I2() {\n        public void foo() {\n          System.out.println(\"X$1::foo-\" + a);\n        }\n      }\n      .foo();\n    }\n  }\npublic static void main(String argv[]) {\n  new X().new Y().foo(8);\n}\n}"}, "----------\n1. WARNING in p\\X.java (at line 11)\n\tvoid foo(int a);\n\t             ^\nThe parameter a is hiding a field from type X.I1\n----------\n2. WARNING in p\\X.java (at line 14)\n\tpublic void foo(int a) {\n\t                    ^\nThe parameter a is hiding a field from type X.I1\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test056() {
        this.runConformTest(new String[]{"p/MethodQualification.java", "package p;\npublic class MethodQualification {\n  void foo() {\n  System.out.println(\"Inherited foo() for anonymous type\");\n  class Local {\n    void foo(){\n    System.out.println(\"Enclosing foo() for anonymous type\");\n    new MethodQualification () { {foo();} };\n    }\n  };\n  }  \n}"}, "");
    }

    public void test057() {
        this.runConformTest(new String[]{"p/AG.java", "package p;\n/**\n * 1F9RITI\n */\npublic class AG {\n  public class X {\n    class B {\n      int intValueOfB = -9;\n    }\n    class SomeInner extends A {\n      void someMethod() {\n        int i = new B().intValueOfB; \n      }\n    }\n  }\n  class A {\n    class B {\n      int intValueOfB = -9;\n    }\n  }\n}"}, "");
    }

    public void test058() {
        this.runConformTest(new String[]{"p/AE.java", "package p;\n/**\n * 1F9RITI\n */\npublic class AE {\n  public class X {\n    int intValue = 153;\n    class SomeInner extends A {\n      void someMethod() {\n        int i = intValue; \n      }\n    }\n  }\n  class A {\n    int intValue = 153;\n  }\n}"}, "");
    }

    public void test059() {
        this.runConformTest(true, new String[]{"p/FieldQualification.java", "package p;\npublic class FieldQualification {\n  String field = \"Inherited field for anonymous type\";\nvoid foo() {\n  class Local {\n    String field = \"Enclosing field for anonymous type\";\n    void foo() {\n      System.out.println(\"Enclosing foo() for anonymous type\");\n      new FieldQualification() {\n        {\n          System.out.println(field);\n        }\n      };\n    }\n  };\n}\n}"}, "----------\n1. WARNING in p\\FieldQualification.java (at line 6)\n\tString field = \"Enclosing field for anonymous type\";\n\t       ^^^^^\nThe field Local.field is hiding a field from type FieldQualification\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test060() {
        this.runConformTest(new String[]{"p/AF.java", "package p;\n/**\n * 1F9RITI\n */\npublic class AF {\n  public class X {\n    int intMethod() {\n      return 3333;\n    }\n    class SomeInner extends A {\n      void someMethod() {\n        int i = intMethod(); \n      }\n    }\n  }\n  class A {\n    int intMethod() {\n      return 3333;\n    }\n  }\n}"}, "");
    }

    public void test061() {
        this.runConformTest(true, new String[]{"p/X.java", "package p;\t\npublic class X extends q.Y {\t\n\tX someField;\t\n}\t\nclass Z extends q.Y {\t\n\tZ someField;\t\n}\t\n", "q/Y.java", "package q;\t\npublic class Y {\t\n\tprivate static class X {}\t\n\tpublic static class Z {}\t\n}\t\n"}, "", null, null, AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void test062() {
        this.runNegativeTest(new String[]{"p1/Y.java", "package p1;\t\npublic class Y extends AbstractT {\t\n\tpublic void init(){\t\n\t\tsuper.init();\t\n\t}\t\n}\t\nabstract class AbstractT implements J {\t\n}\t\ninterface J {\t\n\tvoid init();\t\n}\t\n"}, "----------\n1. ERROR in p1\\Y.java (at line 4)\n\tsuper.init();\t\n\t^^^^^^^^^^^^\nCannot directly invoke the abstract method init() for the type J\n----------\n");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tclass Y extends X {}\t\n\tclass Z extends Y {\t\n\t\tZ(){\t\n\t\t\tSystem.out.println(\"SUCCESS\");\t\n\t\t}\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().new Z();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p1\\X.java (at line 5)\n\tZ(){\t\n\t^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n");
    }

    public void test064() {
        this.runNegativeTest(new String[]{"Foo.java", "public class Foo {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic class Bar extends Foo {\n\t\tpublic Bar() {\n\t\t}\n\t}\n\tpublic class Baz extends Bar {\n\t\tpublic Baz() {\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Foo.java (at line 10)\n\tpublic Baz() {\n\t       ^^^^^\nNo enclosing instance of type Foo is available due to some intermediate constructor invocation\n----------\n");
    }

    public void test065() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().new Y().new Z().bar();\t\n\t}\t\n\tString foo() { return \"X-foo\"; }\t\n\tclass Y extends X {\t\n\t\tString foo() { return \"Y-foo\"; }\t\n\t\tclass Z extends Y {\t\n\t\t\tZ(){\t\n\t\t\t\t//X.this.super();\t\n\t\t\t}\t\n\t\t\tString foo() { return \"Z-foo\"; }\t\n\t\t\tvoid bar () {\t\n\t\t\t\tSystem.out.println(X.this.foo());\t\n\t\t\t}\t\n\t\t}\t\n\t}\t\n}\t\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tString foo() { return \"Y-foo\"; }\t\n\t       ^^^^^\nThe method foo() of type X.Y should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 9)\n\tZ(){\t\n\t^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n3. WARNING in X.java (at line 12)\n\tString foo() { return \"Z-foo\"; }\t\n\t       ^^^^^\nThe method foo() of type X.Y.Z should be tagged with @Override since it actually overrides a superclass method\n----------\n");
    }

    public void test066() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  X(Object o) {}\n  class M extends X {\n    M(){\n      super(null);\n    }\n    M(Object o) {\n      super(new M(){});\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tsuper(new M(){});\n\t          ^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n");
    }

    public void test067() {
        String expectedError = "----------\n1. ERROR in X.java (at line 11)\n\tsuper(null); //1\n\t^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n2. ERROR in X.java (at line 14)\n\tsuper(new M());//2\n\t^^^^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n3. ERROR in X.java (at line 14)\n\tsuper(new M());//2\n\t      ^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n";
        if (this.complianceLevel >= 0x320000L) {
            expectedError = "----------\n1. ERROR in X.java (at line 11)\n\tsuper(null); //1\n\t^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n2. ERROR in X.java (at line 14)\n\tsuper(new M());//2\n\t^^^^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n";
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tX(Object o) {\n\t}\n\tclass N extends X {\n\t\tN(Object o) {\n\t\t\tsuper(o);\n\t\t}\n\t}\n\tclass M extends N {\n\t\tM() {\n\t\t\tsuper(null); //1\n\t\t}\n\t\tM(Object o) {\n\t\t\tsuper(new M());//2\n\t\t}\n\t}\n}\n"}, expectedError);
    }

    public void test068() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass MX1 extends X {\n\t\tMX1() {\n\t\t}\n\t}\n\tclass MX2 extends MX1 {\n\t\tMX2() {\n\t\t\tsuper();\t// ko\n\t\t}\n\t\tMX2(X x) {\n\t\t\tthis();\t\t// ok\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tsuper();\t// ko\n\t^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n");
    }

    public void test069() {
        String expectedError = "----------\n1. ERROR in X.java (at line 8)\n\tsuper(new MX4());\t// ko\n\t^^^^^^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n2. ERROR in X.java (at line 8)\n\tsuper(new MX4());\t// ko\n\t      ^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n3. ERROR in X.java (at line 14)\n\tthis(new MX4());\t\t// ko\n\t     ^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n";
        if (this.complianceLevel >= 0x320000L) {
            expectedError = "----------\n1. ERROR in X.java (at line 8)\n\tsuper(new MX4());\t// ko\n\t^^^^^^^^^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n2. ERROR in X.java (at line 14)\n\tthis(new MX4());\t\t// ko\n\t     ^^^^^^^^^\nNo enclosing instance of type X is available due to some intermediate constructor invocation\n----------\n";
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass MX3 extends X {\n\t\tMX3(X x) {\n\t\t}\n\t}\n\tclass MX4 extends MX3 {\n\t\tMX4() {\n\t\t\tsuper(new MX4());\t// ko\n\t\t}\n\t\tMX4(X x) {\n\t\t\tthis();\t\t// ok\n\t\t}\n\t\tMX4(int i) {\n\t\t\tthis(new MX4());\t\t// ko\n\t\t}\n\t}\n}\n"}, expectedError);
    }

    public void test070() {
        this.runConformTest(new String[]{"X.java", "public class X extends Middle {\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(new X().field);\n\t}\n}\nclass Middle extends Top {\n}\nclass Top {\n\tString field = \"Top.field\";\n}\n"}, "Top.field");
        this.runConformTest(new String[]{"Middle.java", "public class Middle extends Top {\n\tpublic static void main(String[] arguments) { \n\t\tX.main(arguments);\t\n\t}\t\n\tString field = \"Middle.field\";\n}\n"}, "Middle.field", null, false, null);
    }

    public void test071() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic interface Copyable extends Cloneable {\n\t\tpublic Object clone() throws CloneNotSupportedException;\n\t}\n\tpublic interface TestIf extends Copyable {\n\t}\n\tpublic static class ClassA implements Copyable {\n\t\tpublic Object clone() throws CloneNotSupportedException {\n\t\t\treturn super.clone();\n\t\t}\n\t}\n\tpublic static class ClassB implements TestIf {\n\t\tpublic Object clone() throws CloneNotSupportedException {\n\t\t\treturn super.clone();\n\t\t}\n\t}\n\tpublic static void main(String[] args) throws Exception {\n\t\tCopyable o1 = new ClassA();\n\t\tClassB o2 = new ClassB();\n\t\tTestIf o3 = o2;\n\t\tObject clonedObject;\n\t\tclonedObject = o1.clone();\n\t\tclonedObject = o2.clone();\n\t\t// The following line fails at runtime with AbstractMethodError when\n\t\t// compiled with Eclipse\n\t\tclonedObject = o3.clone();\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test072() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        try {\n            f();\n        } catch(NullPointerException e) {\n            System.out.println(\"SUCCESS\");\n        }\n    }\n    static void f() {\n        Object x = new Object() {\n            {\n                    if (true) throw null;\n            }\n        };\n    }\n}"}, "SUCCESS");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public static void main(String[] args) {\n        \n        switch(args.length) {\n            \n            case 1:\n                int i = 0;\n                class Local {\n\t            }\n                break;\n                \n\t\t\tcase 0 :\n\t\t\t    System.out.println(i); // local var can be referred to, only an initialization pb\n\t\t\t    System.out.println(new Local());\n        \t\tbreak;\n\n\t\t\tcase 2 :\n                class Local { // not a duplicate\n\t            }\n        \t\tbreak;\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tSystem.out.println(new Local());\n\t                       ^^^^^\nLocal cannot be resolved to a type\n----------\n");
    }

    public void test074() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n    \tString nonInlinedString = \"[Local]\";\t\n    \tint i = 2;\t\n\t\tswitch(i){\t\n\t\t\tcase 1:\t\n\t\t\t\tfinal String displayString = nonInlinedString;\n\t\t\t\tfinal String inlinedString = \"a\";\t\n\t\t\t\tclass Local {\t\n\t\t\t\t\tpublic String toString() {\t\n\t\t\t\t\t\treturn inlinedString + displayString;\t\n\t\t\t\t\t}\t\n\t\t\t\t}\t\n\t\t\tcase 2:\t\n\t\t\t\tSystem.out.print(new Local());\t\n\t\t\t\tSystem.out.print(\"-\");\t\n\t\t\t\tSystem.out.println(new Local(){\t\n\t\t\t\t\tpublic String toString() {\t\n\t\t\t\t\t\treturn super.toString()+\": anonymous\";\t\n\t\t\t\t\t}\t\n\t\t\t\t});\t\n\t\t}\t\n    }\t\n}\t\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tpublic String toString() {\t\n\t              ^^^^^^^^^^\nThe method toString() of type Local should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 15)\n\tSystem.out.print(new Local());\t\n\t                     ^^^^^\nLocal cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 17)\n\tSystem.out.println(new Local(){\t\n\t                       ^^^^^\nLocal cannot be resolved to a type\n----------\n");
    }

    public void test075() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\n        System.out.println(\"SUCCESS\");\n    }\n    public void foo(int p1) {} \n    public void foo(short p1) {} \n}\t\n", "Y.java", "public class Y extends X {\t\n    public void foo(long p1) {} \n    public void testEc() { foo((short)1); } \n}\t\n"}, "SUCCESS");
    }

    public void test076() {
        this.docSupport = true;
        this.runNegativeTest(new String[]{"IX.java", "interface IX {\n\tpublic static class Problem extends Exception {}\n}\n", "X.java", "public abstract class X {\n\tpublic static class Problem extends Exception {}\n\tpublic abstract static class InnerClass implements IX {\n\t\t/**\n\t\t * @throws Problem \n\t\t */\n\t\tpublic void foo() throws IllegalArgumentException {\n\t\t}\n\t}\n}\n\n"}, "----------\n1. WARNING in IX.java (at line 2)\n\tpublic static class Problem extends Exception {}\n\t                    ^^^^^^^\nThe serializable class Problem does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in X.java (at line 2)\n\tpublic static class Problem extends Exception {}\n\t                    ^^^^^^^\nThe serializable class Problem does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 5)\n\t* @throws Problem \n\t          ^^^^^^^\nJavadoc: Exception Problem is not declared\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test077() {
        this.docSupport = true;
        this.runConformTest(new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar() { \n\t\treturn \"FAILED\";\t\n\t} \n\tvoid foo(){ \n\t\t/** @see #bar() */\n\t\tclass Y extends Secondary { \n\t\t\t/** @see #bar() */\n\t\t\tString z = bar();\t\n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tString bar(){ return \"FAILED\"; } \n} \n"});
    }

    public void test078() {
        this.docSupport = true;
        this.runConformTest(new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar = \"FAILED\";\tvoid foo(){ \n\t\t/** @see #bar */\n\t\tclass Y extends Secondary { \n\t\t\t/** @see #bar */\n\t\t\tString z = bar; \n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tString bar = \"FAILED\"; \n} \n"});
    }

    public void test079() {
        this.runNegativeTest(new String[]{"Hello.java", "void ___eval() {\n\tnew Runnable() {\n\t\tint ___run() throws Throwable {\n\t\t\treturn blah;\n\t\t}\n\t\tprivate String blarg;\n\t\tpublic void run() {\n\t\t}\n\t};\n}\npublic class Hello {\n\tprivate static int x;\n\tprivate String blah;\n\tpublic static void main(String[] args) {\n\t}\n\tpublic void hello() {\n\t}\n\tpublic boolean blah() {\n\t\treturn false;\n\t}\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in Hello.java (at line 1)\n\tvoid ___eval() {\n\t^^^^\nSyntax error on token \"void\", @ expected\n----------\n2. ERROR in Hello.java (at line 1)\n\tvoid ___eval() {\n\t             ^\nSyntax error on token \")\", delete this token\n----------\n3. ERROR in Hello.java (at line 9)\n\t};\n}\n\t^^^^\nSyntax error on tokens, delete these tokens\n----------\n4. ERROR in Hello.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n5. ERROR in Hello.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"}\" to complete MemberValue\n----------\n6. ERROR in Hello.java (at line 23)\n\t}\n\t^\nSyntax error, insert \")\" to complete Modifiers\n----------\n7. ERROR in Hello.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"enum Identifier\" to complete EnumHeader\n----------\n8. ERROR in Hello.java (at line 23)\n\t}\n\t^\nSyntax error, insert \"EnumBody\" to complete CompilationUnit\n----------\n");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X {\n    private static class C1 extends ArrayList {\n    }\n    private static class C2 extends ArrayList {\n    }\n    public static void main(String[] args) {\n\t\tArrayList list = args == null ? new C1(): new C2();\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test081() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public X foo() { return this; } \n    public static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\nclass Y extends X {\n    public Y foo() { return this; } \n}\n"}, "SUCCESS");
    }

    public void test082() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\t\tX x = new X1();\n\t\tSystem.out.println(x.foo());\n\t}\n\tObject foo() {\n\t\treturn null;\n\t}\n}\n\nclass X1 extends X {\n\tString foo() {\n\t\treturn \"SUCCESS\";\n\t}\n}\n"}, "SUCCESS");
    }

    public void test083() {
        this.docSupport = true;
        this.runConformTest(new String[]{"X.java", "public @interface X {\n    /** Value */\n    String[] value();\n}\n"});
    }

    public void test084() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tObject enum = null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject enum = null;\n\t       ^^^^\nSyntax error on token \"enum\", delete this token\n----------\n");
    }

    public void test085() {
        this.runConformTest(true, new String[]{"A.java", "import static j.l.S.*;\nimport static j.l.S.in;\n\npublic class A {\n\n}\n", "j/l/S.java", "package j.l;\npublic class S {\n\tpublic static int in;\n}\n"}, "----------\n1. WARNING in A.java (at line 1)\n\timport static j.l.S.*;\n\t              ^^^^^\nThe import j.l.S is never used\n----------\n2. WARNING in A.java (at line 2)\n\timport static j.l.S.in;\n\t              ^^^^^^^^\nThe import j.l.S.in is never used\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test086() {
        this.runNegativeTest(new String[]{"p/S.java", "package p;\npublic class S {\n    public final static String full = \"FULL\";\n    public final static String success = \"SUCCESS\";\n}\n", "X.java", "import static p.S;\npublic class X {\n\tpublic static void main ( String[] args) {\n\t\t\n      System.out.print(full+\" \"+p.S.success);\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static p.S;\n\t              ^^^\nThe static import p.S must be a field or member type\n----------\n2. ERROR in X.java (at line 5)\n\tSystem.out.print(full+\" \"+p.S.success);\n\t                 ^^^^\nfull cannot be resolved to a variable\n----------\n");
    }

    public void test087() {
        this.runNegativeTest(new String[]{"S.java", "public class S {\n    public final static String full = \"FULL\";\n    public final static String success = \"SUCCESS\";\n}\n", "X.java", "import static S;\npublic class X {\n\tpublic static void main ( String[] args) {\n\t\t\n      System.out.print(full+\" \"+S.success);\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static S;\n\t              ^\nThe import S cannot be resolved\n----------\n2. ERROR in X.java (at line 5)\n\tSystem.out.print(full+\" \"+S.success);\n\t                 ^^^^\nfull cannot be resolved to a variable\n----------\n");
    }

    public void test088() {
        String errorMessage = "----------\n1. WARNING in p\\X.java (at line 4)\n\tpublic class X extends Date implements Runnable{\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in p\\X.java (at line 12)\n\tthis.super();\n\t^^^^\nIllegal enclosing instance specification for type Object\n----------\n3. WARNING in p\\X.java (at line 39)\n\tMethod _getMethod = c.getMethod(\"d\",null);\n\t                    ^^^^^^^^^^^^^^^^^^^^^\nType null of the last argument to method getMethod(String, Class...) doesn't exactly match the vararg parameter type. Cast to Class[] to confirm the non-varargs invocation, or pass individual arguments of type Class for a varargs invocation.\n----------\n";
        String javaVersion = System.getProperty("java.version");
        if (Compliance_1_5.isJRELevel(56) || AbstractCompilerTest.getPossibleComplianceLevels() == 4 && javaVersion.indexOf("1.5") == -1) {
            errorMessage = "----------\n1. WARNING in p\\X.java (at line 4)\n\tpublic class X extends Date implements Runnable{\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in p\\X.java (at line 12)\n\tthis.super();\n\t^^^^\nIllegal enclosing instance specification for type Object\n----------\n3. WARNING in p\\X.java (at line 39)\n\tMethod _getMethod = c.getMethod(\"d\",null);\n\t                    ^^^^^^^^^^^^^^^^^^^^^\nType null of the last argument to method getMethod(String, Class...) doesn't exactly match the vararg parameter type. Cast to Class[] to confirm the non-varargs invocation, or pass individual arguments of type Class for a varargs invocation.\n----------\n4. WARNING in p\\X.java (at line 39)\n\tMethod _getMethod = c.getMethod(\"d\",null);\n\t                    ^^^^^^^^^^^^^^^^^^^^^\nType safety: The method getMethod(String, Class...) belongs to the raw type Class. References to generic type Class<T> should be parameterized\n----------\n";
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport java.util.Date;\nimport java.lang.reflect.*;\npublic class X extends Date implements Runnable{\n \n Integer w = new Integer(90);\n protected double x = 91.1;\n public long y = 92;\n static public Boolean z = new Boolean(true); \n public class X_inner {\n  public X_inner() {\n   this.super();\n   System.out.println(\"....\");\n  }\n }\n X_inner a = new X_inner();\n public interface X_interface {\n   public void f(); \n }\n static {\n  System.out.println(\"Static initializer\");\n }\n public X() { } \n public X(int a1,int b1) { } \n private void a() { System.out.println(\"A\");} \n protected void b() { System.out.println(\"B\");} \n public void c() { System.out.println(\"C\");} \n static public int d() {System.out.println(\"Static D\");return -1;} \n public static void main(String args[]) {\n  X  b = new X();\n  Class c = b.getClass();\n  Class _getClasses [] = X.class.getClasses(); \n//  System.out.println(_getClasses[0].toString());\n//  System.out.println(_getClasses[1].toString());\n  if (_getClasses.length == 0) {System.out.println(\"FAILED\");};\n  Constructor _getConstructors[] = c.getConstructors(); \n  try {\n   Field _getField = c.getField(\"y\");\n   Method _getMethod = c.getMethod(\"d\",null);\n \n   Boolean b_z = X.z; \n  }\n  catch (NoSuchFieldException e) { System.out.println(\"NoSuchFieldException\");}\n  catch (NoSuchMethodException e) { System.out.println(\"NoSuchMethodException\");};\n } \n public void run() {System.out.println(\"RUN\");} \n}"}, errorMessage);
    }

    public void test089() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    @interface I1 {}\n}\n\npublic class X {\n    public static void main(String argv[])   {\n    \tSystem.out.print(\"SUCCESS\");\n    }\n}"}, "SUCCESS");
    }

    public void test090() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tvoid foo(int[] ints, Object o) {\n\t\tints = ints.clone();\n\t\tints = (int[])ints.clone();\n\t\tX x = this.clone();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tX x = this.clone();\n\t      ^^^^^^^^^^^^\nType mismatch: cannot convert from Object to X\n----------\n");
    }

    public void test091() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t\n\tpublic static void main(String[] args) {\n\t\targs = args.clone();\n\t}\n}"}, "");
    }

    public void test092() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(Boolean b) {\n\t\tif (b) { \n\t\t\tint i = 0;\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test093() {
        this.runNegativeTest(new String[]{"p/X_1.java", "package p;\n/*   dena JTest Suite, Version 2.2, September 1997\n *   Copyright (c) 1995-1997 Modena Software (I) Pvt. Ltd., All Rights Reserved\n */\n/*  Section    :  Inner classes \n *  FileName   :  ciner026.java\n *  Purpose    :  Positive test for Inner classes\n *  \n *  An anonymous class can have initializers but cannot have a constructor.\n *  The argument list of the associated new expression is implicitely \n *  passed to the constructor of the super class. \n *\n */\n \n class X_1 {\n  static int xx = 100;\n  //inner class Y  \n  static class Y {  \n   public int j = 0;\n   Y(int x){ j = x; }\n   }  \n public void call_inner()\n {\n   int i = test_anonymous().j;\n }     \n public static void main(String argv[])\n {\n   X_1 ox = new X_1();\n   ox.call_inner(); \n }  \npublic void newMethod ( ) {\n  Float f1 = null;\n  f1=(f1==0.0)?1.0:f1;\n}\n   static Y test_anonymous()\n   { \n    //anonymous implementation of class Y\n    return new Y(xx) //xx should be implicitely passed to Y()\n    {\n    };    \n   \n   } //end test_anonymous      \n} "}, "----------\n1. ERROR in p\\X_1.java (at line 33)\n\tf1=(f1==0.0)?1.0:f1;\n\t   ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from double to Float\n----------\n");
    }

    public void test094() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\t\npublic class X {\t\n\tvoid foo(){\n\t\t()\n\t\tIOException e;\n\t} \n}\t\t\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t()\n\t^\nSyntax error on token \"(\", AnnotationName expected before this token\n----------\n");
    }

    public void test095() {
        this.runConformTest(new String[]{"X.java", "interface I {\n   int foo();\n}\ninterface J {\n   String foo();\n}\n \npublic class X implements I {\n   public int foo() {\n \treturn 0;\n   }\n   public static void main(String[] args) {\n         I i = new X();\n         try {\n\t        J j = (J) i;\n         } catch(ClassCastException e) {\n\t        System.out.println(\"SUCCESS\");\n         }\n  }\n}\n"}, "SUCCESS");
    }

    public void test096() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    interface A {\n       void doSomething();\n    }\n\n    interface B {\n       int doSomething();\n    }\n\n    interface C extends B {\n    }\n\n    public static void main(String[] args) {\n        \n        A a = null;\n        C c = (C)a; \n    }\n}"}, "");
    }

    public void test097() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    public static void main(String argv[]) {\n    \tint cst = X1.CST;\n        X2.Root.foo();\n    }\n    static void foo() {}\n}\n\nclass X1 {\n    static {\n\t\tSystem.out.print(\"[X1]\");\n    }\n    public static final int CST = 12;\n    static X Root = null;\n}\nclass X2 {\n    static {\n\t\tSystem.out.print(\"[X2]\");\n    }\n    public final int CST = 12;\n    static X Root = null;\n}\n"}, "[X2]");
    }

    public void test098() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tSystem.out.print(\"foo\");\n\t}\n\tclass Y {\n\t\tString this$0;\n\t\tString this$0$;\n\t\tvoid print() { \n\t\t\tfoo();\n\t\t\tSystem.out.println(this$0+this$0$);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tX.Y y = new X().new Y();\n\t\ty.this$0 = \"hello\";\n\t\ty.this$0$ = \"world\";\n\t\ty.print();\n\t}\n}\n"}, "foohelloworld");
    }

    public void test099() {
        this.runNegativeTest(new String[]{"I.java", "public interface I extends Cloneable {\n\tclass Inner {\n\t\tObject bar(I i) throws CloneNotSupportedException { return i.clone(); }\n\t}\n}\n"}, "----------\n1. ERROR in I.java (at line 3)\n\tObject bar(I i) throws CloneNotSupportedException { return i.clone(); }\n\t                                                             ^^^^^\nThe method clone() is undefined for the type I\n----------\n");
    }

    public void test100() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    int \\ud800\\udc05\\ud800\\udc04\\ud800\\udc03\\ud800\\udc02\\ud800\\udc01\\ud800\\udc00;\n    void foo() {\n        int \\ud800\\udc05\\ud800\\udc04\\ud800\\udc03\\ud800\\udc02\\ud800\\udc01\\ud800\\udc00;\n    }\n}\n"});
    }

    public void test101() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tCharacter c0 = 'a';\n\tpublic static void main(String argv[]) {\n\t\tCharacter c1;\n\t\tc1 = 'b';\n\n\t\tCharacter c2 = 'c';\n\t\tCharacter[] c3 = { 'd' };\n\t\n\t}\n}\n"}, "");
    }

    public void test102() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Object() {\n\t\t\t{\n\t\t\t\tnew Object() {\n\t\t\t\t\t{\n\t\t\t\t\t\tSystem.out.println(this.getClass().getName());\n\t\t\t\t\t\tSystem.out.println(this.getClass().getSimpleName());\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\t\t};\n\t}\n}\n"}, "X$1$1");
    }

    public void test103() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\t\tSystem.out.print(X.class);\n    }\n}\n"}, "class X");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "public class X {\n  \n  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  public X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 1]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n  \n  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n    0  getstatic java.lang.System.out : java.io.PrintStream [16]\n    3  ldc <Class X> [1]\n    5  invokevirtual java.io.PrintStream.print(java.lang.Object) : void [22]\n    8  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 8, line: 4]\n      Local variable table:\n        [pc: 0, pc: 9] local: args index: 0 type: java.lang.String[]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            Compliance_1_5.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test104() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Object() {\n\t\t\t{\n\t\t\t\tnew Object() {\n\t\t\t\t\t{\n\t\t\t\t\t\tclass Y {\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\tSystem.out.print(this.getClass());\n\t\t\t\t\t\t\t\tSystem.out.print(' ');\n\t\t\t\t\t\t\t\tSystem.out.print(this.getClass().getSimpleName());\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\t;\n\t\t\t\t\t\tnew Y();\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\t\t};\n\t}\n}"}, "class X$1$1$1Y Y");
    }

    public void test105() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static class Y { }\n    static class Z1 {\n        Runnable m;\n        Z1(Runnable p) {\n            this.m = p;\n        }\n    }\n    class Z2 extends Z1 {\n        Z2(final Y p) {\n            super(new Runnable() {\n                public void run() {\n                    foo(p);\n                }\n            });\n        }\n    }\n    void foo(Y p) { }\n}\n"}, AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test106() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\nimport java.util.zip.*;\npublic class X {\n\tvoid x() throws ZipException {\n\t\tIandJ ij= new K();\n\t\tij.m();\n\t}\n\tvoid y() throws ZipException {\n\t\tK k= new K();\n\t\tk.m();\n\t}\n}\ninterface I { void m() throws IOException; }\ninterface J { void m() throws ZipException; }\ninterface IandJ extends I, J {}\nclass K implements IandJ { public void m() throws ZipException { } }"}, "");
    }

    public void test107() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tC c = new D();\n\t\tc.xyz();\n\t}\n}\nclass AException extends Exception { }\nclass BException extends Exception { }\ninterface A { void xyz() throws AException; }\ninterface B { void xyz() throws BException; }\ninterface C extends A, B { }\nclass D implements C {\n\tpublic void xyz() { System.out.println(1); }\n}"}, "1");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.Compliance_1_5");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

