/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;

public class GenericsRegressionTest
extends AbstractComparableTest {
    static /* synthetic */ Class class$0;

    public GenericsRegressionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return GenericsRegressionTest.buildComparableTestSuite(GenericsRegressionTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.GenericsRegressionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Map getCompilerOptions() {
        Map compilerOptions = super.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", "ignore");
        return compilerOptions;
    }

    public void _test322531a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic class X {\n    <T extends I> void main(Class<T> clazz) {\n        boolean b = \n            clazz == clazz || \n            X.class == X.class || \n            I.class == I.class || \n            clazz == X.class || \n            X.class == clazz || \n            clazz == I.class || \n            I.class == clazz || \n            I.class == X.class ||\n            X.class == I.class;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tclazz == clazz || \n\t^^^^^^^^^^^^^^\nComparing identical expressions\n----------\n2. ERROR in X.java (at line 8)\n\tclazz == X.class || \n\t^^^^^^^^^^^^^^^^\nIncompatible operand types Class<T> and Class<X>\n----------\n3. ERROR in X.java (at line 9)\n\tX.class == clazz || \n\t^^^^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<T>\n----------\n4. ERROR in X.java (at line 12)\n\tI.class == X.class ||\n\t^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<I> and Class<X>\n----------\n5. ERROR in X.java (at line 13)\n\tX.class == I.class;\n\t^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<I>\n----------\n");
    }

    public void test322531b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic class X implements I {\n    <T extends I> void main(Class<T> clazz) {\n        boolean b = \n            clazz == clazz || \n            X.class == X.class || \n            I.class == I.class || \n            clazz == X.class || \n            X.class == clazz || \n            clazz == I.class || \n            I.class == clazz || \n            I.class == X.class ||\n            X.class == I.class;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tclazz == clazz || \n\t^^^^^^^^^^^^^^\nComparing identical expressions\n----------\n2. ERROR in X.java (at line 12)\n\tI.class == X.class ||\n\t^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<I> and Class<X>\n----------\n3. ERROR in X.java (at line 13)\n\tX.class == I.class;\n\t^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<I>\n----------\n");
    }

    public void test322531c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic class X {\n    <T extends I> void main(Class<T> clazz, X x) {\n        boolean b = \n            x.getClass() == clazz || \n            clazz == x.getClass(); \n    }\n}\n"}, "");
    }

    public void test322531d() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic final class X {\n    <T extends I> void main(Class<T> clazz, X x) {\n        boolean b = \n            x.getClass() == clazz || \n            clazz == x.getClass(); \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tx.getClass() == clazz || \n\t^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<capture#1-of ? extends X> and Class<T>\n----------\n2. ERROR in X.java (at line 6)\n\tclazz == x.getClass(); \n\t^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<T> and Class<capture#2-of ? extends X>\n----------\n");
    }

    public void test322531e() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic final class X implements I {\n    <T extends I> void main(Class<T> clazz, X x) {\n        boolean b = \n            x.getClass() == clazz || \n            clazz == x.getClass(); \n    }\n}\n"}, "");
    }

    public void test322531f() {
        this.runNegativeTest(new String[]{"X.java", "class I {}\npublic class X {\n    <T extends I> void main(Class<T> clazz, X x) {\n        boolean b = \n            x.getClass() == clazz || \n            clazz == x.getClass(); \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tx.getClass() == clazz || \n\t^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<capture#1-of ? extends X> and Class<T>\n----------\n2. ERROR in X.java (at line 6)\n\tclazz == x.getClass(); \n\t^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<T> and Class<capture#2-of ? extends X>\n----------\n");
    }

    public void _test322531g() {
        this.runNegativeTest(new String[]{"X.java", "interface List<E> {}\ninterface I {}\npublic class X implements I {\n    void main(List<I> li, X t) {\n        boolean b = I.class == t.getClass();\n\t         b = li == t.getList();\n    }\n    \n    List<? extends Object> getList() {\n    \treturn null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tboolean b = I.class == t.getClass();\n\t            ^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<I> and Class<capture#1-of ? extends X>\n----------\n");
    }

    public void _test322531h() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic class X implements I {\n    <T extends I> void main(Class<T> clazz, X t) {\n        boolean b = \n            clazz == t.getClass() || \n            t.getClass() == clazz || \n            I.class == t.getClass() ||\n            t.getClass() == I.class;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI.class == t.getClass() ||\n\t^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<I> and Class<capture#3-of ? extends X>\n----------\n2. ERROR in X.java (at line 8)\n\tt.getClass() == I.class;\n\t^^^^^^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<capture#4-of ? extends X> and Class<I>\n----------\n");
    }

    public void test322531i() {
        this.runNegativeTest(new String[]{"X.java", "interface I {};\npublic class X {\n    public X() {\n    }\n    public <T extends I> void test(Class<T> clazz) {\n        Class<I> ci = I.class;\n        Class<X> ti = X.class;\n        boolean b = ci == X.class ||\n        \t        X.class == ci ||\n        \t\t\tI.class == X.class ||\n        \t\t\tX.class == I.class ||\n        \t\t\tti == I.class ||\n        \t\t\tI.class == ti ||\n        \t\t\tti == ci ||\n        \t\t\tci == ti;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tboolean b = ci == X.class ||\n\t            ^^^^^^^^^^^^^\nIncompatible operand types Class<I> and Class<X>\n----------\n2. ERROR in X.java (at line 9)\n\tX.class == ci ||\n\t^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<I>\n----------\n3. ERROR in X.java (at line 10)\n\tI.class == X.class ||\n\t^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<I> and Class<X>\n----------\n4. ERROR in X.java (at line 11)\n\tX.class == I.class ||\n\t^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<I>\n----------\n5. ERROR in X.java (at line 12)\n\tti == I.class ||\n\t^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<I>\n----------\n6. ERROR in X.java (at line 13)\n\tI.class == ti ||\n\t^^^^^^^^^^^^^\nIncompatible operand types Class<I> and Class<X>\n----------\n7. ERROR in X.java (at line 14)\n\tti == ci ||\n\t^^^^^^^^\nIncompatible operand types Class<X> and Class<I>\n----------\n8. ERROR in X.java (at line 15)\n\tci == ti;\n\t^^^^^^^^\nIncompatible operand types Class<I> and Class<X>\n----------\n");
    }

    public void _test322531j() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\npublic class X {\n    <T extends I> void main(Class<T> clazz) {\n        boolean b = \n            clazz != clazz || \n            X.class != X.class || \n            I.class != I.class || \n            clazz != X.class || \n            X.class != clazz || \n            clazz != I.class || \n            I.class != clazz || \n            I.class != X.class ||\n            X.class != I.class;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tclazz != clazz || \n\t^^^^^^^^^^^^^^\nComparing identical expressions\n----------\n2. ERROR in X.java (at line 8)\n\tclazz != X.class || \n\t^^^^^^^^^^^^^^^^\nIncompatible operand types Class<T> and Class<X>\n----------\n3. ERROR in X.java (at line 9)\n\tX.class != clazz || \n\t^^^^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<T>\n----------\n4. ERROR in X.java (at line 12)\n\tI.class != X.class ||\n\t^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<I> and Class<X>\n----------\n5. ERROR in X.java (at line 13)\n\tX.class != I.class;\n\t^^^^^^^^^^^^^^^^^^\nIncompatible operand types Class<X> and Class<I>\n----------\n");
    }

    public void test282152() {
        this.runConformTest(new String[]{"Test.java", "public interface Test<T extends Number> {\n    public <U> void test(Test<? super U> t, U value);\n    public void setValue(T v);}", "Impl.java", "public class Impl<T extends Number> implements Test<T>{\n    T val;    public <U> void test(Test<? super U> t, U value) {\n        t.setValue(value);\n    }\n    public void setValue(T v) {\n        this.val = v;\n    }\n}", "Client.java", "public class Client {\n    void test() {\n        Impl<Integer> t1 = new Impl<Integer>();\n        Double n = Double.valueOf(3.14);\n        t1.test(new Impl<Number>(), n);\n    }\n}\n"}, "");
    }

    public void test282152b() {
        this.runNegativeTest(new String[]{"Test.java", "public interface Test<T extends Number> {\n    public <U> void test(Test<? super U> t, U value);\n    public void setValue(T v);}", "Impl.java", "public class Impl<T extends Number> implements Test<T>{\n    T val;    public <U> void test(Test<? super U> t, U value) {\n        t.setValue(value);\n    }\n    public void setValue(T v) {\n        this.val = v;\n    }\n}", "Client.java", "public class Client {\n    void test() {\n        Impl<Integer> t1 = new Impl<Integer>();\n        Number n = Double.valueOf(3.14);\n        t1.test(new Impl<Double>(), n);\n    }\n}\n"}, "----------\n1. ERROR in Client.java (at line 5)\n\tt1.test(new Impl<Double>(), n);\n\t   ^^^^\nThe method test(Test<? super U>, U) in the type Impl<Integer> is not applicable for the arguments (Impl<Double>, Number)\n----------\n");
    }

    public void test282152c() {
        this.runNegativeTest(new String[]{"Test.java", "public interface Test<T extends Number> {\n    public <U extends Exception> void test(Test<? super U> t, U value);\n    public void setValue(T v);}"}, "----------\n1. ERROR in Test.java (at line 2)\n\tpublic <U extends Exception> void test(Test<? super U> t, U value);\n\t                                            ^^^^^^^^^\nBound mismatch: The type ? super U is not a valid substitute for the bounded parameter <T extends Number> of the type Test<T>\n----------\n");
    }

    public void test282152d() {
        this.runConformTest(new String[]{"Test.java", "public interface Test<T extends Number> {\n    public <U extends Integer> void test(Test<? super U> t, U value);\n    public void setValue(T v);}", "Impl.java", "public class Impl<T extends Number> implements Test<T>{\n    T val;    public <U extends Integer> void test(Test<? super U> t, U value) {\n        t.setValue(value);\n    }\n    public void setValue(T v) {\n        this.val = v;\n    }\n}", "Client.java", "public class Client {\n    void test() {\n        Impl<Integer> t1 = new Impl<Integer>();\n        Integer i = Integer.valueOf(3);\n        t1.test(new Impl<Integer>(), i);\n    }\n}\n"}, "");
    }

    public void test282152e() {
        this.runNegativeTest(new String[]{"Test.java", "public interface Test<T extends Number> {\n    public <U> void test(Test<U> t, U value);\n    public void setValue(T v);}"}, "----------\n1. ERROR in Test.java (at line 2)\n\tpublic <U> void test(Test<U> t, U value);\n\t                          ^\nBound mismatch: The type U is not a valid substitute for the bounded parameter <T extends Number> of the type Test<T>\n----------\n");
    }

    public void test330869() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public <T> T getAdapter(Class<? extends T> adapterType) {\n        T result = null;\n        if (adapterType == Foo.class) {\n        }\n        else if (adapterType == Bar.class) {\n        }\n        return  result;\n     }\n     public class Foo {\n     }\n     public interface Bar {\n     }\n}\n"}, "");
    }

    public void test322817() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "interface Adaptable {\n    public Object getAdapter(Class clazz);    \n}\npublic class X implements Adaptable {\n    public Object getAdapter(Class clazz) {\n        return null;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic Object getAdapter(Class clazz);    \n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test322817b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "enabled");
        this.runNegativeTest(new String[]{"X.java", "interface Adaptable {\n    public Object getAdapter(Class clazz);    \n}\npublic class X implements Adaptable {\n    public Object getAdapter(Class clazz) {\n        return null;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic Object getAdapter(Class clazz);    \n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tpublic Object getAdapter(Class clazz) {\n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test322817c() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "interface Adaptable {\n    public Object getAdapter(Class<String> clazz);    \n}\npublic class X implements Adaptable {\n    public Object getAdapter(Class clazz) {\n        return null;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic Object getAdapter(Class clazz) {\n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test322817d() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "interface Adaptable {\n    public Object getAdapter(Class<String> clazz);    \n}\npublic class X implements Adaptable {\n    public Object getAdapter(Class clazz) {\n        return null;\n    }\n}\nclass Y extends X {\n    @Override\n    public Object getAdapter(Class clazz) {\n        return null;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic Object getAdapter(Class clazz) {\n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test322817e() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass Top {\n    public void set(List arg) { } // OK to warn in 1.5 code\n    public List get() { return null; } // OK to warn in 1.5 code\n}\nclass Sub extends Top {\n    @Override\n    public void set(List arg) { // should not warn (overrides)\n    }\n    @Override\n    public List get() { // should not warn (overrides)\n        return super.get();\n    }\n}\npublic class X {\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void set(List arg) { } // OK to warn in 1.5 code\n\t                ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tpublic List get() { return null; } // OK to warn in 1.5 code\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test322817f() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass Top {\n    public void set(List arg) { } // OK to warn in 1.5 code\n    public List<String> get() { return null; }\n}\nclass Sub extends Top {\n    @Override\n    public void set(List arg) { // should not warn (overrides)\n    }\n    @Override\n    public List get() { // should warn (super's return type is not raw)\n        return super.get();\n    }\n}\npublic class X {\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void set(List arg) { } // OK to warn in 1.5 code\n\t                ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 11)\n\tpublic List get() { // should warn (super's return type is not raw)\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 11)\n\tpublic List get() { // should warn (super's return type is not raw)\n\t       ^^^^\nType safety: The return type List for get() from the type Sub needs unchecked conversion to conform to List<String> from the type Top\n----------\n", null, true, customOptions);
    }

    public void test322817g() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"Top.java", "import java.util.List;\npublic class Top {\n    public void set(List arg) { } // OK to warn in 1.5 code\n    public List get() { return null; } // OK to warn in 1.5 code\n    List list; // OK to warn in 1.5 code\n}\n", "Sub.java", "import java.util.List;\npublic class Sub extends Top {\n    @Override\n    public void set(List arg) { // should not warn (overrides)\n        super.set(arg);\n        arg.set(0, \"A\"); // should not warn ('arg' is forced raw)\n    }\n    @Override\n    public List get() { // should not warn (overrides)\n        return super.get();\n    }\n}\n", "X.java", "import java.util.List;\npublic class X {\n    void run() {\n        new Top().list.add(\"arg\"); // should not warn (uses raw field declared elsewhere)\n        new Top().get().add(\"arg\"); // should not warn (uses raw API)\n        List raw= new Top().get(); // OK to warn ('raw' declared here)\n        raw.add(\"arg\"); // OK to warn ('raw' declared here)\n        // When Top#get() is generified, both of the following will fail\n        // with a compile error if type arguments don't match:\n        List<String> unchecked= new Top().get(); // should not warn (forced)\n        unchecked.add(\"x\");\n        // Should not warn about unchecked cast, but should warn about\n        // unnecessary cast:\n        List<String> cast= (List<String>) new Top().get();\n        cast.add(\"x\");\n    }\n}\n"}, "----------\n1. WARNING in Top.java (at line 3)\n\tpublic void set(List arg) { } // OK to warn in 1.5 code\n\t                ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in Top.java (at line 4)\n\tpublic List get() { return null; } // OK to warn in 1.5 code\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in Top.java (at line 5)\n\tList list; // OK to warn in 1.5 code\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n----------\n1. WARNING in X.java (at line 6)\n\tList raw= new Top().get(); // OK to warn ('raw' declared here)\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\traw.add(\"arg\"); // OK to warn ('raw' declared here)\n\t^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 14)\n\tList<String> cast= (List<String>) new Top().get();\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from List to List<String>\n----------\n", null, true, customOptions);
    }

    public void test322817h() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "enabled");
        this.runNegativeTest(new String[]{"Top.java", "import java.util.List;\npublic class Top {\n    public void set(List arg) { }\n    public List get() { return null; }\n    List list;\n}\n", "Sub.java", "import java.util.List;\npublic class Sub extends Top {\n    @Override\n    public void set(List arg) {\n        super.set(arg);\n        arg.set(0, \"A\");\n    }\n    @Override\n    public List get() {\n        return super.get();\n    }\n}\n", "X.java", "import java.util.List;\npublic class X {\n    void run() {\n        new Top().list.add(\"arg\");\n        new Top().get().add(\"arg\");\n        List raw= new Top().get();\n        raw.add(\"arg\");\n        List<String> unchecked= new Top().get();\n        unchecked.add(\"x\");\n        List<String> cast= (List<String>) new Top().get();\n        cast.add(\"x\");\n    }\n}\n"}, "----------\n1. WARNING in Top.java (at line 3)\n\tpublic void set(List arg) { }\n\t                ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in Top.java (at line 4)\n\tpublic List get() { return null; }\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in Top.java (at line 5)\n\tList list;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n----------\n1. WARNING in Sub.java (at line 4)\n\tpublic void set(List arg) {\n\t                ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in Sub.java (at line 6)\n\targ.set(0, \"A\");\n\t^^^^^^^^^^^^^^^\nType safety: The method set(int, Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n3. WARNING in Sub.java (at line 9)\n\tpublic List get() {\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n----------\n1. WARNING in X.java (at line 4)\n\tnew Top().list.add(\"arg\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tnew Top().get().add(\"arg\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tList raw= new Top().get();\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in X.java (at line 7)\n\traw.add(\"arg\");\n\t^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n5. WARNING in X.java (at line 8)\n\tList<String> unchecked= new Top().get();\n\t                        ^^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n6. WARNING in X.java (at line 10)\n\tList<String> cast= (List<String>) new Top().get();\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List to List<String>\n----------\n7. WARNING in X.java (at line 10)\n\tList<String> cast= (List<String>) new Top().get();\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from List to List<String>\n----------\n", null, true, customOptions);
    }

    public void test322817i() {
        Map customOptions = this.getCompilerOptions();
        this.runNegativeTest(new String[]{"Top.java", "import java.util.List;\npublic class Top {\n    public void set(List arg) { }\n    public List get() { return null; }\n    List list;\n}\n", "Sub.java", "import java.util.List;\npublic class Sub extends Top {\n    @Override\n    public void set(List arg) {\n        super.set(arg);\n        arg.set(0, \"A\");\n    }\n    @Override\n    public List get() {\n        return super.get();\n    }\n}\n", "X.java", "import java.util.List;\npublic class X {\n    void run() {\n        new Top().list.add(\"arg\");\n        new Top().get().add(\"arg\");\n        List raw= new Top().get();\n        raw.add(\"arg\");\n        List<String> unchecked= new Top().get();\n        unchecked.add(\"x\");\n        List<String> cast= (List<String>) new Top().get();\n        cast.add(\"x\");\n    }\n}\n"}, "----------\n1. WARNING in Top.java (at line 3)\n\tpublic void set(List arg) { }\n\t                ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in Top.java (at line 4)\n\tpublic List get() { return null; }\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in Top.java (at line 5)\n\tList list;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n----------\n1. WARNING in Sub.java (at line 4)\n\tpublic void set(List arg) {\n\t                ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in Sub.java (at line 6)\n\targ.set(0, \"A\");\n\t^^^^^^^^^^^^^^^\nType safety: The method set(int, Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n3. WARNING in Sub.java (at line 9)\n\tpublic List get() {\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n----------\n1. WARNING in X.java (at line 4)\n\tnew Top().list.add(\"arg\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tnew Top().get().add(\"arg\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tList raw= new Top().get();\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in X.java (at line 7)\n\traw.add(\"arg\");\n\t^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n5. WARNING in X.java (at line 8)\n\tList<String> unchecked= new Top().get();\n\t                        ^^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n6. WARNING in X.java (at line 10)\n\tList<String> cast= (List<String>) new Top().get();\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List to List<String>\n----------\n7. WARNING in X.java (at line 10)\n\tList<String> cast= (List<String>) new Top().get();\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from List to List<String>\n----------\n", null, true, customOptions);
    }

    public void test322817j() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass Top {\n    public void set(List arg) { } // OK to warn in 1.5 code\n    public List get() { return null; } // OK to warn in 1.5 code\n}\nclass Sub extends Top {\n    @Override\n    public void set(List arg) { // should not warn (overrides)\n        super.set(arg);\n        arg.set(0, \"A\"); // should not warn ('arg' is forced raw)\n    }\n    @Override\n    public List get() { // should not warn (overrides)\n        return super.get();\n    }\n}\npublic class X {\n    void run() {\n        new Top().get().add(\"arg\");\n        List raw= new Top().get(); // OK to warn ('raw' declared here)\n        raw.add(\"arg\"); // OK to warn ('raw' declared here)\n        List<String> unchecked= new Top().get();\n        unchecked.add(\"x\");\n        List<String> cast= (List<String>) new Top().get();\n        cast.add(\"x\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void set(List arg) { } // OK to warn in 1.5 code\n\t                ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tpublic List get() { return null; } // OK to warn in 1.5 code\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 19)\n\tnew Top().get().add(\"arg\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n4. WARNING in X.java (at line 20)\n\tList raw= new Top().get(); // OK to warn ('raw' declared here)\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n5. WARNING in X.java (at line 21)\n\traw.add(\"arg\"); // OK to warn ('raw' declared here)\n\t^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n6. WARNING in X.java (at line 22)\n\tList<String> unchecked= new Top().get();\n\t                        ^^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n7. WARNING in X.java (at line 24)\n\tList<String> cast= (List<String>) new Top().get();\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List to List<String>\n----------\n8. WARNING in X.java (at line 24)\n\tList<String> cast= (List<String>) new Top().get();\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from List to List<String>\n----------\n", null, true, customOptions);
    }

    public void test322817k() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.Set;\nimport java.util.HashSet;\npublic class X {\n    public void foo(String[] elements) {\n\t     Set set= new HashSet(Arrays.asList(elements));\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tSet set= new HashSet(Arrays.asList(elements));\n\t^^^\nSet is a raw type. References to generic type Set<E> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tSet set= new HashSet(Arrays.asList(elements));\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The constructor HashSet(Collection) belongs to the raw type HashSet. References to generic type HashSet<E> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tSet set= new HashSet(Arrays.asList(elements));\n\t             ^^^^^^^\nHashSet is a raw type. References to generic type HashSet<E> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test338350() {
        String[] testFiles = new String[]{"Try.java", "import java.lang.reflect.Array;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class Try<E> {\n\tvoid fooObj() {\n\t\ttakeObj((E) Bar.getObject());\n\t\ttakeObj((E) Bar.getArray());\n\t\ttakeObj((E) Array.newInstance(Integer.class, 2));\n\t}\n\tvoid takeObj(E obj) { }\n\tvoid fooArray() {\n\t\ttakeArray((E[]) Bar.getArray());\n\t\ttakeArray((E[]) Array.newInstance(Integer.class, 2));\n\t}\n\tvoid takeArray(E[] array) { }\n\t<L> void foo(List<L> list) {\n\t\tlist.toArray((L[]) Bar.getArray());\n\t\tlist.toArray((L[]) Array.newInstance(Integer.class, 2));\n\t}\n\tvoid bar() {\n\t\tList<String> l = (List<String>) Bar.getObject();\n\t\tList<String> l2 = Bar.getRawList();\n\t\tArrayList<String> l3 = (ArrayList<String>) Bar.getRawList();\n\t}\n}\n", "Bar.java", "import java.lang.reflect.Array;\nimport java.util.ArrayList;\nimport java.util.List;\npublic class Bar {\n\tpublic static Object getObject() {\n\t\treturn new Object();\n\t}\n\tpublic static Object[] getArray() {\n\t\treturn (Object[]) Array.newInstance(Integer.class, 2);\n\t}\n\tpublic static List getRawList() {\n\t\treturn new ArrayList();\n\t}\n}\n"};
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "enabled");
        this.runNegativeTest(testFiles, "----------\n1. WARNING in Try.java (at line 6)\n\ttakeObj((E) Bar.getObject());\n\t        ^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to E\n----------\n2. WARNING in Try.java (at line 7)\n\ttakeObj((E) Bar.getArray());\n\t        ^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object[] to E\n----------\n3. WARNING in Try.java (at line 8)\n\ttakeObj((E) Array.newInstance(Integer.class, 2));\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to E\n----------\n4. WARNING in Try.java (at line 12)\n\ttakeArray((E[]) Bar.getArray());\n\t          ^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object[] to E[]\n----------\n5. WARNING in Try.java (at line 13)\n\ttakeArray((E[]) Array.newInstance(Integer.class, 2));\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to E[]\n----------\n6. WARNING in Try.java (at line 17)\n\tlist.toArray((L[]) Bar.getArray());\n\t             ^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object[] to L[]\n----------\n7. WARNING in Try.java (at line 18)\n\tlist.toArray((L[]) Array.newInstance(Integer.class, 2));\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to L[]\n----------\n8. WARNING in Try.java (at line 21)\n\tList<String> l = (List<String>) Bar.getObject();\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<String>\n----------\n9. WARNING in Try.java (at line 22)\n\tList<String> l2 = Bar.getRawList();\n\t                  ^^^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<String>\n----------\n10. WARNING in Try.java (at line 23)\n\tArrayList<String> l3 = (ArrayList<String>) Bar.getRawList();\n\t                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from List to ArrayList<String>\n----------\n----------\n1. WARNING in Bar.java (at line 11)\n\tpublic static List getRawList() {\n\t              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in Bar.java (at line 12)\n\treturn new ArrayList();\n\t           ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n", null, true, customOptions);
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(testFiles, "----------\n1. WARNING in Try.java (at line 6)\n\ttakeObj((E) Bar.getObject());\n\t        ^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to E\n----------\n2. WARNING in Try.java (at line 7)\n\ttakeObj((E) Bar.getArray());\n\t        ^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object[] to E\n----------\n3. WARNING in Try.java (at line 8)\n\ttakeObj((E) Array.newInstance(Integer.class, 2));\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to E\n----------\n4. WARNING in Try.java (at line 12)\n\ttakeArray((E[]) Bar.getArray());\n\t          ^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object[] to E[]\n----------\n5. WARNING in Try.java (at line 13)\n\ttakeArray((E[]) Array.newInstance(Integer.class, 2));\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to E[]\n----------\n6. WARNING in Try.java (at line 17)\n\tlist.toArray((L[]) Bar.getArray());\n\t             ^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object[] to L[]\n----------\n7. WARNING in Try.java (at line 18)\n\tlist.toArray((L[]) Array.newInstance(Integer.class, 2));\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to L[]\n----------\n8. WARNING in Try.java (at line 21)\n\tList<String> l = (List<String>) Bar.getObject();\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to List<String>\n----------\n----------\n1. WARNING in Bar.java (at line 11)\n\tpublic static List getRawList() {\n\t              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in Bar.java (at line 12)\n\treturn new ArrayList();\n\t           ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test334622a() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n    private Object foo;\n}\n", "q/Y.java", "package q;\nimport p.X;\npublic class Y {\n    public <T extends X> void test(T t) {\n        System.out.println(t.foo);\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in p\\X.java (at line 3)\n\tprivate Object foo;\n\t               ^^^\nThe value of the field X.foo is not used\n----------\n----------\n1. ERROR in q\\Y.java (at line 5)\n\tSystem.out.println(t.foo);\n\t                     ^^^\nThe field X.foo is not visible\n----------\n2. ERROR in q\\Y.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test334622b() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n    private Object foo;\n}\n", "p/Y.java", "package p;\npublic class Y {\n    public <T extends X> void test(T t) {\n        System.out.println(t.foo);\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in p\\X.java (at line 3)\n\tprivate Object foo;\n\t               ^^^\nThe value of the field X.foo is not used\n----------\n----------\n1. ERROR in p\\Y.java (at line 4)\n\tSystem.out.println(t.foo);\n\t                     ^^^\nThe field X.foo is not visible\n----------\n2. ERROR in p\\Y.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test334622c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private Object foo;\n    public <T extends X> void test(T t) {\n        System.out.println(t.foo);\n        Zork z;\n    }\n}\n"}, this.complianceLevel <= 0x320000L ? "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 2)\n\tprivate Object foo;\n\t               ^^^\nThe value of the field X.foo is not used\n----------\n2. ERROR in X.java (at line 4)\n\tSystem.out.println(t.foo);\n\t                     ^^^\nThe field X.foo is not visible\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test334622d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private Object foo() { return null; }\n    public <T extends X> void test(T t) {\n        t.foo();\n        Zork z;\n    }\n}\n"}, this.complianceLevel <= 0x320000L ? "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tt.foo();\n\t  ^^^\nThe method foo() from the type X is not visible\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test335751() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A extends B, B extends A> {}\n"}, this.complianceLevel <= 0x320000L ? "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<A extends B, B extends A> {}\n\t               ^\nIllegal forward reference to type parameter B\n----------\n" : "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<A extends B, B extends A> {}\n\t                                      ^\nCycle detected: a cycle exists in the type hierarchy between B and A\n----------\n");
    }

    public void test334121() {
        this.runNegativeTest(new String[]{"X.java", "public class X<A extends A> {}\n"}, this.complianceLevel <= 0x320000L ? "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<A extends A> {}\n\t               ^\nIllegal forward reference to type parameter A\n----------\n" : "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<A extends A> {}\n\t                         ^\nCycle detected: the type A cannot extend/implement itself or one of its own member types\n----------\n");
    }

    public void test337751() {
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        this.runConformTest(new String[]{"Project.java", "import java.util.Map;\npublic class Project {\n    public Map getOptions(boolean b) {\n        return null;\n    }\n}\n"}, "", null, true, null, compilerOptions14, null);
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "enabled");
        this.runNegativeTest(new String[]{"Y.java", "import java.util.Map;\npublic class Y {\n    void foo(Project project) {\n        Map<String, String> options=\n                        project != null ? project.getOptions(true) : null;\n        options = project.getOptions(true);\n        options = project == null ? null : project.getOptions(true);\n    }\n}\n"}, "----------\n1. WARNING in Y.java (at line 5)\n\tproject != null ? project.getOptions(true) : null;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Map needs unchecked conversion to conform to Map<String,String>\n----------\n2. WARNING in Y.java (at line 6)\n\toptions = project.getOptions(true);\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Map needs unchecked conversion to conform to Map<String,String>\n----------\n3. WARNING in Y.java (at line 7)\n\toptions = project == null ? null : project.getOptions(true);\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Map needs unchecked conversion to conform to Map<String,String>\n----------\n", null, false, compilerOptions15, null);
    }

    public void test337751a() {
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        this.runConformTest(new String[]{"Project.java", "import java.util.Map;\npublic class Project {\n    public Map getOptions(boolean b) {\n        return null;\n    }\n}\n"}, "", null, true, null, compilerOptions14, null);
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"Y.java", "import java.util.Map;\npublic class Y {\n    void foo(Project project) {\n        Map<String, String> options=\n                        project != null ? project.getOptions(true) : null;\n        options = project.getOptions(true);\n        options = project == null ? null : project.getOptions(true);\n    }\n}\n"}, "", null, false, compilerOptions15, null);
    }

    public void test337962() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "enabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\nclass Super {\n    protected List fList;\n}\npublic class X extends Super {\n    protected List fSubList; // raw type warning (good)\n    {\n        fSubList = new ArrayList();\n         fList.add(null); // type safety warning (TODO: bad, should be hidden)\n        super.fList.add(null); // type safety warning (TODO: bad, should be hidden)\n        fSubList.add(null); // type safety warning (good, should not be hidden)\n    }\n    void foo(String s) {\n        fList.add(s); // type safety warning (TODO: bad, should be hidden)\n        super.fList.add(s); // type safety warning (TODO: bad, should be hidden)\n        fSubList.add(s); // type safety warning (good, should not be hidden)\n    }\n    X(String s) {\n        fSubList = new ArrayList();\n         fList.add(s); // type safety warning (TODO: bad, should be hidden)\n        super.fList.add(s); // type safety warning (TODO: bad, should be hidden)\n        fSubList.add(s); // type safety warning (good, should not be hidden)\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tprotected List fList;\n\t          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tprotected List fSubList; // raw type warning (good)\n\t          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 9)\n\tfSubList = new ArrayList();\n\t               ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n4. WARNING in X.java (at line 10)\n\tfList.add(null); // type safety warning (TODO: bad, should be hidden)\n\t^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n5. WARNING in X.java (at line 11)\n\tsuper.fList.add(null); // type safety warning (TODO: bad, should be hidden)\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n6. WARNING in X.java (at line 12)\n\tfSubList.add(null); // type safety warning (good, should not be hidden)\n\t^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n7. WARNING in X.java (at line 15)\n\tfList.add(s); // type safety warning (TODO: bad, should be hidden)\n\t^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n8. WARNING in X.java (at line 16)\n\tsuper.fList.add(s); // type safety warning (TODO: bad, should be hidden)\n\t^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n9. WARNING in X.java (at line 17)\n\tfSubList.add(s); // type safety warning (good, should not be hidden)\n\t^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n10. WARNING in X.java (at line 20)\n\tfSubList = new ArrayList();\n\t               ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n11. WARNING in X.java (at line 21)\n\tfList.add(s); // type safety warning (TODO: bad, should be hidden)\n\t^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n12. WARNING in X.java (at line 22)\n\tsuper.fList.add(s); // type safety warning (TODO: bad, should be hidden)\n\t^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n13. WARNING in X.java (at line 23)\n\tfSubList.add(s); // type safety warning (good, should not be hidden)\n\t^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n", null, false, compilerOptions15, null);
    }

    public void test337962b() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\nclass Super {\n    protected List fList;\n}\npublic class X extends Super {\n    protected List fSubList; // raw type warning (good)\n    {\n        fSubList = new ArrayList();\n         fList.add(null); // type safety warning (TODO: bad, should be hidden)\n        super.fList.add(null); // type safety warning (TODO: bad, should be hidden)\n        fSubList.add(null); // type safety warning (good, should not be hidden)\n    }\n    void foo(String s) {\n        fList.add(s); // type safety warning (TODO: bad, should be hidden)\n        super.fList.add(s); // type safety warning (TODO: bad, should be hidden)\n        fSubList.add(s); // type safety warning (good, should not be hidden)\n    }\n    X(String s) {\n        fSubList = new ArrayList();\n         fList.add(s); // type safety warning (TODO: bad, should be hidden)\n        super.fList.add(s); // type safety warning (TODO: bad, should be hidden)\n        fSubList.add(s); // type safety warning (good, should not be hidden)\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tprotected List fList;\n\t          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tprotected List fSubList; // raw type warning (good)\n\t          ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 9)\n\tfSubList = new ArrayList();\n\t               ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n4. WARNING in X.java (at line 12)\n\tfSubList.add(null); // type safety warning (good, should not be hidden)\n\t^^^^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n5. WARNING in X.java (at line 17)\n\tfSubList.add(s); // type safety warning (good, should not be hidden)\n\t^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n6. WARNING in X.java (at line 20)\n\tfSubList = new ArrayList();\n\t               ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n7. WARNING in X.java (at line 23)\n\tfSubList.add(s); // type safety warning (good, should not be hidden)\n\t^^^^^^^^^^^^^^^\nType safety: The method add(Object) belongs to the raw type List. References to generic type List<E> should be parameterized\n----------\n", null, false, compilerOptions15, null);
    }

    public void test338011() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "disabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X extends A {\n    public X(Map m) { // should warn about raw type m\n        super(m);\n        m.put(\"one\", 1); // warns about raw method invocation (good)\n    }\n    public X(Map<String, Integer> m, boolean b) {\n        super(m); // shows that parametrizing the parameter type is no problem \n        new A(m);\n        m.put(\"one\", 1);\n    }\n}\nclass A {\n    public A (Map m) {\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic X(Map m) { // should warn about raw type m\n\t         ^^^\nMap is a raw type. References to generic type Map<K,V> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tm.put(\"one\", 1); // warns about raw method invocation (good)\n\t^^^^^^^^^^^^^^^\nType safety: The method put(Object, Object) belongs to the raw type Map. References to generic type Map<K,V> should be parameterized\n----------\n3. WARNING in X.java (at line 14)\n\tpublic A (Map m) {\n\t          ^^^\nMap is a raw type. References to generic type Map<K,V> should be parameterized\n----------\n", null, false, compilerOptions15, null);
    }

    public void test338011b() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", "enabled");
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X extends A {\n    public X(Map m) { // should warn about raw type m\n        super(m);\n        m.put(\"one\", 1); // warns about raw method invocation (good)\n    }\n    public X(Map<String, Integer> m, boolean b) {\n        super(m); // shows that parametrizing the parameter type is no problem \n        new A(m);\n        m.put(\"one\", 1);\n    }\n}\nclass A {\n    public A (Map m) {\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic X(Map m) { // should warn about raw type m\n\t         ^^^\nMap is a raw type. References to generic type Map<K,V> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tm.put(\"one\", 1); // warns about raw method invocation (good)\n\t^^^^^^^^^^^^^^^\nType safety: The method put(Object, Object) belongs to the raw type Map. References to generic type Map<K,V> should be parameterized\n----------\n3. WARNING in X.java (at line 14)\n\tpublic A (Map m) {\n\t          ^^^\nMap is a raw type. References to generic type Map<K,V> should be parameterized\n----------\n", null, false, compilerOptions15, null);
    }

    public void test339478a() {
        if (this.complianceLevel >= 0x330000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tx.testFunction(\"SUCCESS\");\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<String> x = new X<>();\n\t                  ^\n'<>' operator is not allowed for source level below 1.7\n----------\n");
    }

    public void test339478b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX<> x1 = null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<> x1 = null;\n\t^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478c() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\npublic class X implements Map<> {\n    static Map<> foo (Map<> x) { \n        return null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X implements Map<> {\n\t                          ^^^\nIncorrect number of arguments for type Map<K,V>; it cannot be parameterized with arguments <>\n----------\n2. ERROR in X.java (at line 3)\n\tstatic Map<> foo (Map<> x) { \n\t       ^^^\nIncorrect number of arguments for type Map<K,V>; it cannot be parameterized with arguments <>\n----------\n3. ERROR in X.java (at line 3)\n\tstatic Map<> foo (Map<> x) { \n\t                  ^^^\nIncorrect number of arguments for type Map<K,V>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478d() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Map;\npublic class X  {\n    static Map<> foo () { \n        return null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tstatic Map<> foo () { \n\t       ^^^\nIncorrect number of arguments for type Map<K,V>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478e() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    class Y<K> {\n    }\n    public static void main(String [] args) {\n        X<String>.Y<> [] y = null; \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tX<String>.Y<> [] y = null; \n\t^^^^^^^^^^^\nIncorrect number of arguments for type X<String>.Y; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478f() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    class Y<K> {\n    }\n    public static void main(String [] args) {\n        X<String>.Y<>  y = null; \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tX<String>.Y<>  y = null; \n\t^^^^^^^^^^^\nIncorrect number of arguments for type X<String>.Y; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478g() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    public void foo(Object x) {\n        if (x instanceof X<>) {    \n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (x instanceof X<>) {    \n\t                 ^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478h() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    public void foo(Object x) throws X.Y<>.LException {\n    }\n    static class Y<T> {\n    static class LException extends Throwable {}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(Object x) throws X.Y<>.LException {\n\t                                 ^^^\nIncorrect number of arguments for type X.Y; it cannot be parameterized with arguments <>\n----------\n2. WARNING in X.java (at line 5)\n\tstatic class LException extends Throwable {}\n\t             ^^^^^^^^^^\nThe serializable class LException does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test339478i() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    public void foo () {\n        Object o = new X<> [10];\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X<> [10];\n\t               ^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478j() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX<>[] x1 = null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<>[] x1 = null;\n\t^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478k() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tX<>[] x1 = null;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tX<>[] x1 = null;\n\t^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478l() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX<> x1 = null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<> x1 = null;\n\t^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478m() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tX<> f1 = null;\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tX<> f1 = null;\n\t^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478n() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic void foo(X<> args) {\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(X<> args) {\n\t                ^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test339478o() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tnew X<>(){\n\t\t\tvoid newMethod(){\n\t\t\t}\n\t\t}.testFunction(\"SUCCESS\");\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 3)\n\tnew X<>(){\n\t    ^\n'<>' operator is not allowed for source level below 1.7\n----------\n2. ERROR in X.java (at line 3)\n\tnew X<>(){\n\t    ^\n'<>' cannot be used with anonymous classes\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tnew X<>(){\n\t    ^\n'<>' cannot be used with anonymous classes\n----------\n");
    }

    public void test339478p() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX Test = new X<>(){\n\t\t\tvoid newMethod(){\n\t\t\t}\n\t\t}.testFunction(\"SUCCESS\");\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in X.java (at line 3)\n\tX Test = new X<>(){\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tX Test = new X<>(){\n\t             ^\n'<>' operator is not allowed for source level below 1.7\n----------\n3. ERROR in X.java (at line 3)\n\tX Test = new X<>(){\n\t             ^\n'<>' cannot be used with anonymous classes\n----------\n" : "----------\n1. WARNING in X.java (at line 3)\n\tX Test = new X<>(){\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tX Test = new X<>(){\n\t             ^\n'<>' cannot be used with anonymous classes\n----------\n");
    }

    public void test339478q() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tX Test = new X<>();\n\t}\n}"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 3)\n\tX Test = new X<>();\n\t             ^\n'<>' operator is not allowed for source level below 1.7\n----------\n2. ERROR in X.java (at line 3)\n\tX Test = new X<>();\n\t             ^\nThe type X is not generic; it cannot be parameterized with arguments <>\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tX Test = new X<>();\n\t             ^\nThe type X is not generic; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test334493() {
        this.runNegativeTest(new String[]{"X.java", "interface Super<P> {}\nclass Y<C> implements Super<Integer>{}\ninterface II extends Super<Double>{}\nclass S<A> extends Y<Byte> {}\ninterface T<B> extends II{}\npublic class X {\n    public static void main(String argv[]) {\n        S<Integer> s = null;\n        T<Integer> t = null;\n        t = (T) s;          //casting to raw type, no error\n        System.out.println(t);\n    }\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 10)\n\tt = (T) s;          //casting to raw type, no error\n\t    ^^^^^\nCannot cast from S<Integer> to T\n----------\n2. WARNING in X.java (at line 10)\n\tt = (T) s;          //casting to raw type, no error\n\t    ^^^^^\nType safety: The expression of type T needs unchecked conversion to conform to T<Integer>\n----------\n" : "----------\n1. WARNING in X.java (at line 10)\n\tt = (T) s;          //casting to raw type, no error\n\t    ^^^^^\nType safety: The expression of type T needs unchecked conversion to conform to T<Integer>\n----------\n2. WARNING in X.java (at line 10)\n\tt = (T) s;          //casting to raw type, no error\n\t     ^\nT is a raw type. References to generic type T<B> should be parameterized\n----------\n");
    }

    public void test334313() {
        this.runNegativeTest(new String[]{"X.java", "abstract class C<T>  {\n\tpublic abstract Object foo(T x);\n   public Integer foo(String x){ return 1; }\n}\npublic class X extends C<String> {\n    zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tzork z;\n\t^^^^\nzork cannot be resolved to a type\n----------\n");
    }

    public void test334313b() {
        this.runNegativeTest(new String[]{"X.java", "abstract class C<T>  {\n\tpublic abstract Integer foo(T x);\n   public Object foo(String x){ return 1; }\n}\npublic class X extends C<String> {\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic class X extends C<String> {\n\t             ^\nThe type X must implement the inherited abstract method C<String>.foo(String) to override C<String>.foo(String)\n----------\n");
    }

    public void test334313c() {
        this.runNegativeTest(new String[]{"X.java", "abstract class B<T> {\n\tpublic abstract Object foo(T x);\n}\nabstract class C<T> extends B<T> {\n    public Integer foo(String x){ return 1; }\n}\npublic class X extends C<String> {\n    zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tzork z;\n\t^^^^\nzork cannot be resolved to a type\n----------\n");
    }

    public void test334313d() {
        this.runNegativeTest(new String[]{"X.java", "abstract class B<T> {\n\tpublic abstract Integer foo(T x);\n}\nabstract class C<T> extends B<T> {\n    public Object foo(String x){ return 1; }\n}\npublic class X extends C<String> {\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic class X extends C<String> {\n\t             ^\nThe type X must implement the inherited abstract method B<String>.foo(String) to override C<String>.foo(String)\n----------\n");
    }

    public void test334313e() {
        this.runNegativeTest(new String[]{"X.java", "abstract class C<T>  {\n\tpublic abstract Object foo(T x);\n   public static Integer foo(String x){ return 1; }\n}\npublic class X extends C<String> {\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic class X extends C<String> {\n\t             ^\nThe static method foo(String) conflicts with the abstract method in C<String>\n----------\n");
    }

    public void test347145() {
        this.runNegativeTest(new String[]{"X.java", "class A {}\nclass B<V> extends A {} \nclass F<T extends A, Y extends B<T>> {\n\tstatic <U extends A , V extends B<U>> F<U,V> g() {\n\t\treturn null;\n\t}\n}\npublic class X  {\n    F<? extends B, ? extends B<? extends B>> f011 = F.g();\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tF<? extends B, ? extends B<? extends B>> f011 = F.g();\n\t            ^\nB is a raw type. References to generic type B<V> should be parameterized\n----------\n2. WARNING in X.java (at line 9)\n\tF<? extends B, ? extends B<? extends B>> f011 = F.g();\n\t                                     ^\nB is a raw type. References to generic type B<V> should be parameterized\n----------\n");
    }

    public void test347426() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    class A<T extends B<?>> {  }\n    class B<T extends A<?>> {\n        D<? extends B<T>> x;\n    }\n    class D<T extends B<?>> {}\n    <E extends B<?>> X(E x, D<B<A<?>>> d) {\n        if (x.x == d) {\n            return;\n        }\n    }\n}\n"}, "");
    }

    public void test347426b() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    class A<T extends X<?>> {\n        B<? extends A<T>> x;\n    }\n    class B<T extends A<?>> {}\n    boolean b = ((A<?>)null).x == ((B<A<X<?>>>)null);   \n}\n"}, "");
    }

    public void test347426c() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    class A<T extends X<? extends String>> {\n        B<? extends A<T>> x;\n    }\n    class B<T extends A<?>> {}\n    boolean b = ((A<? extends X<?>>)null).x == ((B<A<X<? extends String>>>)null);       \n}\n"}, "");
    }

    public void test283353() {
        String source = "public class X {\n  public static void main(String[] args) {\n    EntityKey entityKey = null;\n    new EntityCondenser().condense(entityKey);  \n  }\n  public static class EntityCondenser {\n    <I, E extends EntityType<I, E, K>, K extends EntityKey<I>> void condense(K entityKey) {\n    }\n  }\n  public class EntityKey<I> {}\n  public interface EntityType<\n    I,\n    E extends EntityType<I, E, K>,\n    K extends EntityKey<I>> {\n  }\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runConformTest(new String[]{"X.java", source}, "");
        } else {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. WARNING in X.java (at line 3)\n\tEntityKey entityKey = null;\n\t^^^^^^^^^\nX.EntityKey is a raw type. References to generic type X.EntityKey<I> should be parameterized\n----------\n2. ERROR in X.java (at line 4)\n\tnew EntityCondenser().condense(entityKey);  \n\t                      ^^^^^^^^\nThe method condense(K) in the type X.EntityCondenser is not applicable for the arguments (X.EntityKey)\n----------\n");
        }
    }

    public void test347600() {
        this.runNegativeTest(new String[]{"X.java", "class A {}\nclass B<V> extends A {} \nclass D extends B<E> {}\nclass E extends B<D> {}\npublic class X<T, Y extends B<U>, U extends B<Y>> {    \n    public static <T1, Y1 extends B<U1>, U1 extends B<Y1>> X<T1, Y1, U1> getX() {\n        return null;\n    }\n    X<B, ? extends D, ? extends E> f = getX();   \n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tX<B, ? extends D, ? extends E> f = getX();   \n\t  ^\nB is a raw type. References to generic type B<V> should be parameterized\n----------\n");
    }

    public void test347746() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    class A<T extends B<?>> {}\n    class B<T extends A<?>> extends D {}\n    class C<T extends D> {}\n    class D {}\n    class E<T extends C<? extends B<?>>> {}\n    <U extends C<V>, V extends B<W>, W extends A<V>> W foo(E<U> e) {\n        return goo(e);\n    }\n    <P extends C<Q>, Q extends B<R>, R extends A<Q>> R goo(E<P> e) {\n        return null;\n    }\n}\n"}, "");
    }

    public void test348493() {
        if (this.complianceLevel >= 0x330000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<Z> {}\n\tpublic static void main(String[] args) {\n\t\tX<String>.X2<> x = new X<String>().new X2<>();\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tX<String>.X2<> x = new X<String>().new X2<>();\n\t^^^^^^^^^^^^\nIncorrect number of arguments for type X<String>.X2; it cannot be parameterized with arguments <>\n----------\n2. ERROR in X.java (at line 4)\n\tX<String>.X2<> x = new X<String>().new X2<>();\n\t                                       ^^\n'<>' operator is not allowed for source level below 1.7\n----------\n");
    }

    public void test348493a() {
        if (this.complianceLevel >= 0x330000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX<> x = new X<>();\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<> x = new X<>();\n\t^\nIncorrect number of arguments for type X<T>; it cannot be parameterized with arguments <>\n----------\n2. ERROR in X.java (at line 3)\n\tX<> x = new X<>();\n\t            ^\n'<>' operator is not allowed for source level below 1.7\n----------\n");
    }

    public void test366131() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        System.out.println(\"SUCCESS\");\n    }\n}\nclass Range<T extends Comparable<? super T>> {\n    public boolean containsNC(T value) {\n        return false;\n    }\n}\nclass NumberRange<T extends Number & Comparable<? super T>> extends Range<T> {\n    public boolean contains(Comparable<?> value) {\n        return castTo((Class) null).containsNC((Comparable) null);\n    }\n    public <N extends Number & Comparable<? super N>> NumberRange<N>\ncastTo(Class<N> type) {\n        return null;\n    }\n}\n"}, "SUCCESS");
    }

    public void test366131b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        Zork z;\n    }\n}\nclass Range<T extends Comparable<? super T>> {\n    public boolean containsNC(T value) {\n        return false;\n    }\n}\nclass NumberRange<T extends Number & Comparable<? super T>> extends Range<T> {\n    public boolean contains(Comparable<?> value) {\n        return castTo((Class) null).containsNC((Comparable) null);\n    }\n    public <N extends Number & Comparable<? super N>> NumberRange<N>\ncastTo(Class<N> type) {\n        return null;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 13)\n\treturn castTo((Class) null).containsNC((Comparable) null);\n\t       ^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation castTo(Class) of the generic method castTo(Class<N>) of type NumberRange<T>\n----------\n3. WARNING in X.java (at line 13)\n\treturn castTo((Class) null).containsNC((Comparable) null);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method containsNC(Comparable) belongs to the raw type Range. References to generic type Range<T> should be parameterized\n----------\n4. WARNING in X.java (at line 13)\n\treturn castTo((Class) null).containsNC((Comparable) null);\n\t              ^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type safety: The expression of type Class needs unchecked conversion to conform to Class<Number&Comparable<? super Number&Comparable<? super N>>>\n" : "Type safety: The expression of type Class needs unchecked conversion to conform to Class<Comparable<? super Comparable<? super N>&Number>&Number>\n") + "----------\n" + "5. WARNING in X.java (at line 13)\n" + "\treturn castTo((Class) null).containsNC((Comparable) null);\n" + "\t               ^^^^^\n" + "Class is a raw type. References to generic type Class<T> should be parameterized\n" + "----------\n" + "6. WARNING in X.java (at line 13)\n" + "\treturn castTo((Class) null).containsNC((Comparable) null);\n" + "\t                                        ^^^^^^^^^^\n" + "Comparable is a raw type. References to generic type Comparable<T> should be parameterized\n" + "----------\n");
    }

    public void _test375394() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\npublic class X {\n    static <C1,C2 extends Collection<Object>> boolean foo(C1 c, C2 c2) {\n        return foo(c2,c); \n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\treturn foo(c2,c); \n\t       ^^^\nBound mismatch: The generic method foo(C1, C2) of type X is not applicable for the arguments (C2, C1). The inferred type C1 is not a valid substitute for the bounded parameter <C2 extends Collection<Object>>\n----------\n");
    }

    public void test375394a() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    B<C, ? extends C<C>, ? extends C<C>> b = new B<>();\n}\nclass B <T, U extends C<T>, V extends U>{}\nclass C<T> {}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tB<C, ? extends C<C>, ? extends C<C>> b = new B<>();\n\t  ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tB<C, ? extends C<C>, ? extends C<C>> b = new B<>();\n\t                 ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n3. WARNING in X.java (at line 2)\n\tB<C, ? extends C<C>, ? extends C<C>> b = new B<>();\n\t                                 ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n");
    }

    public void test385780() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\npublic <S> X() {\n}\npublic void ph(int t) {\n}\n}\ninterface doNothingInterface<T> {\n}\nclass doNothing {\npublic <T> void doNothingMethod() {}\n}\nclass noerror {\npublic <T> void doNothing(T t) {}}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<T> {\n\t               ^\nUnused type parameter T\n----------\n2. ERROR in X.java (at line 2)\n\tpublic <S> X() {\n\t        ^\nUnused type parameter S\n----------\n3. ERROR in X.java (at line 7)\n\tinterface doNothingInterface<T> {\n\t                             ^\nUnused type parameter T\n----------\n4. ERROR in X.java (at line 10)\n\tpublic <T> void doNothingMethod() {}\n\t        ^\nUnused type parameter T\n----------\n", null, true, customOptions);
    }

    public void testBug395002_1() {
        this.runConformTest(new String[]{"Client.java", "interface SelfBound<S extends SelfBound<S, T>, T> {\n}\npublic class Client {\n\t<A extends SelfBound<?,A>> void foo3(A arg3) {\n\t\tSelfBound<?, A> var3 = arg3;\n\t\tSelfBound<? extends SelfBound<?, A>, ?> var4 = var3;\n\t}\n}\n"});
    }

    public void testBug395002_2() {
        this.runConformTest(new String[]{"Client.java", "interface SelfBound<S extends SelfBound<S, T>, T> {\n}\npublic class Client {\n\t<A extends SelfBound<?,A>> void foo2(A arg2) {\n\t\tSelfBound<? extends SelfBound<?, A>, ?> var2 = arg2;\n\t}\n}\n"});
    }

    public void testBug395002_3() {
        this.runConformTest(new String[]{"Client.java", "interface SelfBound<S extends SelfBound<S, T>, T> {\n}\npublic class Client<A extends SelfBound<?,A>>  {\n\tSelfBound<? extends SelfBound<?, A>, ?> field2;\n\tvoid foo2(A arg2) {\n\t\tfield2 = arg2;\n\t}\n}\n"});
    }

    public void testBug395002_4() {
        this.runConformTest(new String[]{"Client.java", "interface SelfBound<S extends SelfBound<S, T>, T> {\n}\npublic class Client<A extends SelfBound<?,A>>  {\n\tvoid bar(SelfBound<? extends SelfBound<?, A>, ?> argBar) {};\n\tvoid foo2(A arg2) {\n\t\tbar(arg2);\n\t}\n}\n"});
    }

    public void testBug395002_full() {
        this.runConformTest(new String[]{"Bug.java", "interface SelfBound<S extends SelfBound<S, T>, T> {\n}\nclass Test<X extends SelfBound<? extends Y, ?>, Y> {\n}\npublic class Bug<A extends SelfBound<?, A>> {\n\tpublic Bug() {\n\t\tnew Test<A, SelfBound<?, A>>();\n\t}\n}\n"});
    }

    public void testBug395002_combined() {
        this.runConformTest(new String[]{"Client.java", "interface SelfBound<S extends SelfBound<S, T>, T> {\n}\nclass Test<X extends SelfBound<? extends Y, ?>, Y> {\n}\npublic class Client {\n\t<A extends SelfBound<?,A>> void foo2(A arg2) {\n\t\tObject o = new Test<A, SelfBound<?, A>>();\n\t\tSelfBound<? extends SelfBound<?, A>, ?> var2 = arg2;\n\t}\n}\n"});
    }

    public void test397888a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "enabled");
        this.runNegativeTest(new String[]{"X.java", "/***\n * @param <T>\n */\npublic class X <T> {\n/***\n * @param <S>\n */\n\tpublic <S> void ph(int i) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tpublic <S> void ph(int i) {\n\t                       ^\nThe value of the parameter i is not used\n----------\n", null, true, customOptions);
    }

    public void test397888b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedTypeParameter", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
        this.runNegativeTest(new String[]{"X.java", "/***\n * @param <T>\n */\npublic class X <T> {\n/***\n * @param <S>\n */\npublic <S> void ph() {\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X <T> {\n\t                ^\nUnused type parameter T\n----------\n2. ERROR in X.java (at line 8)\n\tpublic <S> void ph() {\n\t        ^\nUnused type parameter S\n----------\n", null, true, customOptions);
    }

    public void test401456() {
        this.runConformTest(new String[]{"App.java", "import java.util.List;\n\npublic class App {\n\n    public interface Command_1<T> {\n        public void execute(T o);\n    }\n    public static class ObservableEventWithArg<T> {\n        public class Monitor {\n            public Object addListener(final Command_1<T> l) {\n                return null;\n            }\n        }\n    }\n    public static class Context<T> {\n          public ObservableEventWithArg<String>.Monitor getSubmissionErrorEventMonitor() {\n              return new ObservableEventWithArg<String>().new Monitor();\n        }\n    }\n\n    public static void main(String[] args) {\n        compileError(new Context<List<String>>());\n    }\n\n    private static void compileError(Context context) {\n        context.getSubmissionErrorEventMonitor().addListener(\n            new Command_1<String>() {\n                public void execute(String o) {\n                }\n            });\n    }\n}\n"});
    }

    public void testBug405706a() {
        this.runNegativeTest(new String[]{"TypeUnsafe.java", "import java.util.Collection;\n\npublic class TypeUnsafe {\n\tpublic static <Type,\n\t\t\tCollectionType extends Collection<Type>>\n\t\t\tCollectionType\n\t\t\tnullAsCollection(Class<Type> clazz) {\n\t\treturn null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tCollection<Integer> integers = nullAsCollection(String.class);\n\t}\n}\n"}, "----------\n1. ERROR in TypeUnsafe.java (at line 12)\n\tCollection<Integer> integers = nullAsCollection(String.class);\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Collection<String> to Collection<Integer>\n----------\n");
    }

    public void testBug405706b() {
        this.runNegativeTest(new String[]{"TypeUnsafe.java", "import java.util.Collection;\nimport java.util.List;\n\npublic class TypeUnsafe {\n\tpublic static <Type,\n\t\t\tCollectionType extends List<Type>>\n\t\t\tCollectionType\n\t\t\tnullAsList(Class<Type> clazz) {\n\t\treturn null;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tCollection<Integer> integers = nullAsList(String.class);\n\t}\n}\n"}, "----------\n1. ERROR in TypeUnsafe.java (at line 13)\n\tCollection<Integer> integers = nullAsList(String.class);\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<String> to Collection<Integer>\n----------\n");
    }

    public void testBug408441() {
        this.runConformTest(new String[]{"TypeMistmatchIssue.java", "import java.util.Arrays;\nimport java.util.List;\n\n\npublic class TypeMistmatchIssue {\n\tstatic interface A {\n\t}\n\tstatic class B implements A {\n\t}\n\tstatic class C implements A {\n\t}\n\tstatic class D implements A {\n\t}\n\t\n\tvoid illustrate() {\n\t\tList<Class<? extends A>> no1= Arrays.asList(B.class, A.class);\t\t\t\t\t\t// compiles\n\t\tList<Class<? extends A>> no2= Arrays.asList(C.class, B.class, A.class);\t\t\t\t// compiles\n\t\tList<Class<? extends A>> no3= Arrays.asList(D.class, B.class, A.class);\t\t\t\t// compiles\n\t\t\n\t\tList<Class<? extends A>> no4= Arrays.asList(D.class, C.class, B.class, A.class);\t// cannot convert error !!!\n\n\t\tList<Class<? extends A>> no5= Arrays.asList(A.class, B.class, C.class, D.class);\t// compiles\n\t\tList<Class<? extends A>> no6= Arrays.asList(A.class, D.class, C.class, B.class);\t// compiles\n\t}\n}\n"});
    }

    public void testBug413958_1() {
        this.runConformTest(new String[]{"TestA.java", "public class TestA { }\n", "TestB.java", "public class TestB { }\n", "ReadOnlyWrapper.java", "@SuppressWarnings(\"unchecked\")\npublic class ReadOnlyWrapper<A extends TestA, B extends TestB> {\n    protected A a;\n    protected B b;\n    public ReadOnlyWrapper(A ax,B bx){\n        this.a = ax;\n        this.b = bx;\n    }\n    public <X extends ReadOnlyWrapper<A,B>> X copy() {\n        return (X) new ReadOnlyWrapper<A,B>(a,b);\n    }\n    public <TA extends TestA,TB extends TestB,X extends ReadOnlyWrapper<TA,TB>> X icopy() {\n        return (X) new ReadOnlyWrapper<A,B>(a,b);\n    }\n    public A getA() {\n        return this.a;\n    }\n    public B getB() {\n        return this.b;\n    }\n}", "WritableWrapper.java", "@SuppressWarnings(\"unchecked\")\npublic class WritableWrapper<A extends TestA, B extends TestB> extends ReadOnlyWrapper<A, B> {\n    public WritableWrapper(A ax,B bx){\n        super(ax,bx);\n    }\n    @Override\n    public <X extends ReadOnlyWrapper<A,B>> X copy() {\n        return (X) new WritableWrapper<A, B>(a,b);\n    }\n    @Override\n    public <TA extends TestA,TB extends TestB,X extends ReadOnlyWrapper<TA,TB>> X icopy() {\n        // Works in Indigo, Fails in Kepler\n        return (X) new WritableWrapper<A,B>(a,b);\n    }\n    public void setA(A ax) {\n        this.a = ax;\n    }\n    public void setB(B bx) {\n        this.b = bx;\n    }\n}\n", "TestGenerics.java", "public class TestGenerics {\n    public static void main(String [] args) {\n        final WritableWrapper<TestA, TestB> v1 = new WritableWrapper<TestA, TestB>(new TestA(), new TestB());\n        final WritableWrapper<TestA,TestB> v2 = v1.copy();\n        final WritableWrapper<TestA,TestB> v3 = v1.icopy();\n    }\n}\n"});
    }

    public void testBug413958_2() {
        String[] sourceFiles = new String[]{"TestA.java", "public class TestA { }\n", "TestB.java", "public class TestB { }\n", "TestA2.java", "public class TestA2 extends TestA { }\n", "ReadOnlyWrapper.java", "@SuppressWarnings(\"unchecked\")\npublic class ReadOnlyWrapper<A extends TestA, B extends TestB> {\n    protected A a;\n    protected B b;\n    public ReadOnlyWrapper(A ax,B bx){\n        this.a = ax;\n        this.b = bx;\n    }\n    public <X extends ReadOnlyWrapper<A,B>> X copy() {\n        return (X) new ReadOnlyWrapper<A,B>(a,b);\n    }\n    public <TA extends TestA,TB extends TestB,X extends ReadOnlyWrapper<TA,TB>> X icopy() {\n        return (X) new ReadOnlyWrapper<A,B>(a,b);\n    }\n    public <TA extends TestA,TB extends TestB,X extends ReadOnlyWrapper<TA,TB>> X icopy2(TA in) {\n        return (X) new ReadOnlyWrapper<A,B>(a,b);\n    }\n    public A getA() {\n        return this.a;\n    }\n    public B getB() {\n        return this.b;\n    }\n}", "WritableWrapper.java", "@SuppressWarnings(\"unchecked\")\npublic class WritableWrapper<A extends TestA, B extends TestB> extends ReadOnlyWrapper<A, B> {\n    public WritableWrapper(A ax,B bx){\n        super(ax,bx);\n    }\n    @Override\n    public <X extends ReadOnlyWrapper<A,B>> X copy() {\n        return (X) new WritableWrapper<A, B>(a,b);\n    }\n    @Override\n    public <TA extends TestA,TB extends TestB,X extends ReadOnlyWrapper<TA,TB>> X icopy() {\n        return (X) new WritableWrapper<A,B>(a,b);\n    }\n    @Override\n    public <TA extends TestA,TB extends TestB,X extends ReadOnlyWrapper<TA,TB>> X icopy2(TA in) {\n        return (X) new WritableWrapper<A,B>(a,b);\n    }\n    public void setA(A ax) {\n        this.a = ax;\n    }\n    public void setB(B bx) {\n        this.b = bx;\n    }\n}\n", "TestGenerics.java", "public class TestGenerics {\n    public static void main(String [] args) {\n        final WritableWrapper<TestA, TestB> v1 = new WritableWrapper<TestA, TestB>(new TestA(), new TestB());\n        final WritableWrapper<TestA,TestB> v2 = v1.copy();\n        final WritableWrapper<TestA,TestB> v3 = v1.icopy();\n        final WritableWrapper<TestA2,TestB> v4 = v1.icopy();\n        final WritableWrapper<TestA2,TestB> v5 = v1.icopy2(new TestA2());\n    }\n}\n"};
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(sourceFiles, "----------\n1. ERROR in TestGenerics.java (at line 6)\n\tfinal WritableWrapper<TestA2,TestB> v4 = v1.icopy();\n\t                                         ^^^^^^^^^^\nType mismatch: cannot convert from ReadOnlyWrapper<TestA,TestB> to WritableWrapper<TestA2,TestB>\n----------\n");
        } else {
            this.runConformTest(sourceFiles);
        }
    }

    public void testBug415734() {
        String compileSrc = "import java.util.ArrayList;\nimport java.util.List;\n\npublic class Compile {\n\n    public <T, Exp extends List<T>> Exp typedNull() {\n        return null;\n    }\n\n    public void call() {\n        ArrayList<String> list = typedNull();\n    }\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"Compile.java", compileSrc}, "----------\n1. ERROR in Compile.java (at line 11)\n\tArrayList<String> list = typedNull();\n\t                         ^^^^^^^^^^^\nType mismatch: cannot convert from List<Object> to ArrayList<String>\n----------\n");
        } else {
            this.runConformTest(new String[]{"Compile.java", compileSrc});
        }
    }

    public void test426534() {
        this.runNegativeTest(new String[]{"p/B.java", "package p;\nclass A {\n}\npublic class B extends A {\n    public <T extends A> void foo(T ... o) { }\n}\n", "X.java", "import p.*;\npublic class X  {\n    public static void main(String argv[]) {\n        new B().foo(null, null);\n    }\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 4)\n\tnew B().foo(null, null);\n\t        ^^^\nThe method foo(T...) of type B is not applicable as the formal varargs element type T is not accessible here\n----------\n" : "----------\n1. WARNING in p\\B.java (at line 5)\n\tpublic <T extends A> void foo(T ... o) { }\n\t                                    ^\nType safety: Potential heap pollution via varargs parameter o\n----------\n----------\n1. ERROR in X.java (at line 4)\n\tnew B().foo(null, null);\n\t        ^^^\nThe method foo(T...) of type B is not applicable as the formal varargs element type T is not accessible here\n----------\n");
    }

    public void test426589() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid take(String... strings) {\n\t}\n\tvoid test() {\n\t\ttake(getString());\n\t}\n\tprivate <T> String getString() {\n\t\treturn \"hi\";\n\t}\n}\n"}, "");
    }

    public void testBug426590() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\t\t\n\t}\n\t\n\tclass B extends A {\n\t\t\n\t}\n\t\n\tclass C extends B {\n\t\t\n\t}\n\t\n\tclass D {\n\t\tD(A a) {\n\t\t\t\n\t\t}\n\t\t\n\t\tD(boolean b) {\n\t\t\tthis(b ? new B() : new C());\n\t\t}\n\t}\n"});
    }

    public void testBug426590b() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\t\t\n\t}\n\t\n\tclass B extends A {\n\t\t\n\t}\n\t\n\tclass C extends B {\n\t\t\n\t}\n\t\n\tclass D {\n\t\tvoid bla(boolean b) {\n\t\t\ttest(b ? new B() : new C());\n\t\t}\n\t\t\n\t\tvoid test(A a) {\n\t\t\t\n\t\t}\n\t}\n"});
    }

    public void test426633() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t<T> void foo (T... p);\n}\nabstract class A implements I {\n\tpublic void foo(Object [] p) {}\n}\npublic class X extends A {\n\tpublic static void main(String[] args) {\n\t\tA a = new X();\n\t\ta.foo(\"hello\", \"world\");\n\t}\n}\n"}, this.complianceLevel >= 0x340000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<T> void foo (T... p);\n\t                   ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n2. WARNING in X.java (at line 5)\n\tpublic void foo(Object [] p) {}\n\t            ^^^^^^^^^^^^^^^^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n3. ERROR in X.java (at line 10)\n\ta.foo(\"hello\", \"world\");\n\t  ^^^\nThe method foo(Object[]) in the type A is not applicable for the arguments (String, String)\n----------\n" : (this.complianceLevel >= 0x330000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<T> void foo (T... p);\n\t                   ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n2. WARNING in X.java (at line 5)\n\tpublic void foo(Object [] p) {}\n\t            ^^^^^^^^^^^^^^^^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n" : "----------\n1. WARNING in X.java (at line 5)\n\tpublic void foo(Object [] p) {}\n\t            ^^^^^^^^^^^^^^^^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n"));
    }

    public void test426633a() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t <T> void foo (T... p);\n}\nabstract class A  {\n\tpublic void foo(Object [] p) {\n\t\tSystem.out.println(\"A.foo\");\n\t}\n}\nabstract class B extends A implements I {\n}\npublic class X extends B implements I {\n\tpublic static void main(String[] args) {\n\t\tB b = new X();\n\t\tb.foo(\"hello\", \"world\");\n\t}\n}\n"}, this.complianceLevel >= 0x340000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<T> void foo (T... p);\n\t                   ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n2. WARNING in X.java (at line 9)\n\tabstract class B extends A implements I {\n\t               ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n3. WARNING in X.java (at line 11)\n\tpublic class X extends B implements I {\n\t             ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n4. ERROR in X.java (at line 14)\n\tb.foo(\"hello\", \"world\");\n\t  ^^^\nThe method foo(T...) of type I cannot be invoked as it is overridden by an inapplicable method\n----------\n" : (this.complianceLevel >= 0x330000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<T> void foo (T... p);\n\t                   ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n2. WARNING in X.java (at line 9)\n\tabstract class B extends A implements I {\n\t               ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n3. WARNING in X.java (at line 11)\n\tpublic class X extends B implements I {\n\t             ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n" : "----------\n1. WARNING in X.java (at line 9)\n\tabstract class B extends A implements I {\n\t               ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n2. WARNING in X.java (at line 11)\n\tpublic class X extends B implements I {\n\t             ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n"));
    }

    public void test426633b() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t <T> void foo (T... p);\n}\nabstract class A  {\n\tpublic abstract void foo(Object [] p);\n}\nabstract class B extends A implements I {\n}\npublic abstract class X extends B implements I {\n\tpublic static void main(B b) {\n\t\tb.foo(\"hello\", \"world\");\n\t}\n}\n"}, this.complianceLevel >= 0x330000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<T> void foo (T... p);\n\t                   ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n" : "");
    }

    public void test426633c() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t default <T> void foo (T... p) {}\n}\nabstract class A  {\n\tpublic abstract void foo(Object [] p);\n}\nabstract class B extends A implements I {\n}\npublic abstract class X extends B implements I {\n\tpublic static void main(B b) {\n\t\tb.foo(\"hello\", \"world\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tdefault <T> void foo (T... p) {}\n\t                           ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n");
    }

    public void test426633d() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t default <T> void foo (T... p) {}\n}\nabstract class A  {\n\tpublic void foo(Object [] p) {}\n}\nabstract class B extends A implements I {\n}\npublic abstract class X extends B implements I {\n\tpublic static void main(B b) {\n\t\tb.foo(\"hello\", \"world\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tdefault <T> void foo (T... p) {}\n\t                           ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n2. WARNING in X.java (at line 7)\n\tabstract class B extends A implements I {\n\t               ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n3. WARNING in X.java (at line 9)\n\tpublic abstract class X extends B implements I {\n\t                      ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n4. ERROR in X.java (at line 11)\n\tb.foo(\"hello\", \"world\");\n\t  ^^^\nThe method foo(T...) of type I cannot be invoked as it is overridden by an inapplicable method\n----------\n");
    }

    public void test426633e() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t default <T> void foo (T... p) {}\n}\nabstract class A  {\n\tpublic void foo(String [] p) {}\n}\nabstract class B extends A implements I {\n}\npublic abstract class X extends B implements I {\n\tpublic static void main(B b) {\n\t\tb.foo(\"hello\", \"world\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tdefault <T> void foo (T... p) {}\n\t                           ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n");
    }

    public void test426678() {
        this.runNegativeTest(new String[]{"X.java", "import p.*;\npublic class X  {\n    public static void main(String argv[]) {\n        new B().foo(null, null);\n    }\n}\n", "p/B.java", "package p;\nclass A {\n}\npublic class B extends A {\n    public <T extends A> void foo(T ... o) { System.out.println(\"PGMB\"); }\n    public void foo(Object... o) { System.out.println(\"MB\"); }\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 4)\n\tnew B().foo(null, null);\n\t        ^^^\nThe method foo(T...) of type B is not applicable as the formal varargs element type T is not accessible here\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tnew B().foo(null, null);\n\t        ^^^\nThe method foo(T...) of type B is not applicable as the formal varargs element type T is not accessible here\n----------\n----------\n1. WARNING in p\\B.java (at line 5)\n\tpublic <T extends A> void foo(T ... o) { System.out.println(\"PGMB\"); }\n\t                                    ^\nType safety: Potential heap pollution via varargs parameter o\n----------\n");
    }

    public void test426678a() {
        this.runConformTest(new String[]{"X.java", "import p.*;\npublic class X  {\n    public static void main(String argv[]) {\n        new B().foo(null, null);\n    }\n}\n", "p/A.java", "package p;\npublic class A {\n}\n", "p/B.java", "package p;\npublic class B extends A {\n    public <T extends A> void foo(T ... o) { System.out.println(\"PGMB\"); }\n    public void foo(Object... o) { System.out.println(\"MB\"); }\n}\n"}, "PGMB");
    }

    public void _test421922() {
        this.runConformTest(new String[]{"X.java", "import p.*;\npublic class X  {\n    public static void main(String argv[]) {\n        new B().foo(null, null);\n    }\n}\n", "p/B.java", "package p;\ninterface A {\n}\npublic class B implements A {\n    public <T extends A> void foo(T ... o) { System.out.println(\"PGMB\"); }\n    public void foo(Object... o) { System.out.println(\"MB\"); }\n}\n"}, "PGMB");
    }

    public void test425719() {
        String interfaceMethod = this.complianceLevel < 0x340000L ? "   <T> void foo(List<T> list);\n" : "   default <T> void foo(List<T> list) {\n\t   System.out.println(\"interface method\");\n   }\n";
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\ninterface I {\n" + interfaceMethod + "}\n" + "class Base {\n" + "    public <T> void foo(List<T> list) {\n" + "        System.out.println(\"class method\");\n" + "   }\n" + "}\n" + "public class X extends Base implements I {\n" + "\t public static void main(String argv[]) {\n" + "\t    \tnew X().foo(new ArrayList<String>());\n" + "\t    }\n" + "}\n"}, "class method");
    }

    public void test425719a() {
        String interfaceMethod = this.complianceLevel < 0x340000L ? "   <T> void foo(List<T> list);\n\n\n" : "   default <T> void foo(List<T> list) {\n\t   System.out.println(\"interface method\");\n   }\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\ninterface I {\n" + interfaceMethod + "}\n" + "abstract class Base {\n" + "    public abstract <T> void foo(List<T> list);\n" + "}\n" + "public abstract class X extends Base implements I {\n" + "\t public static void main(String argv[]) {\n" + "           X x = new Y();\n" + "\t    \tx.foo(new ArrayList<String>());\n" + "\t    }\n" + "}\n" + "class Y extends X {}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tclass Y extends X {}\n\t      ^\nThe type Y must implement the inherited abstract method Base.foo(List<T>)\n----------\n");
    }

    public void test425719b() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        String interfaceMethod = this.complianceLevel < 0x340000L ? "   <T> void foo(List<T> list);\n\n\n" : "   default <T> void foo(List<T> list) {\n\t   System.out.println(\"interface method\");\n   }\n";
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\ninterface I {\n" + interfaceMethod + "}\n" + "abstract class Base {\n" + "    public abstract <T> void foo(List<T> list);\n" + "}\n" + "public abstract class X extends Base implements I {\n" + "\t public static void main(String argv[]) {\n" + "           X x = new Y();\n" + "\t    \tx.foo(new ArrayList<String>());\n" + "\t    }\n" + "}\n" + "class Y extends X {\n" + "    public <T> void foo(List<T> list) {\n" + "        System.out.println(\"Y.foo\");\n" + "    }\n" + "}\n"}, "Y.foo");
    }

    public void test427282() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\npublic class X {\n\tpublic X(String... a) {\n\t}\n\tpublic static <T> T[] a(T[] a, T[] b) {\n\t\treturn null;\n\t}\n\tpublic static void error() {\n\t\tfinal Collection<X> as = null;\n       for (X a : as) {\n           new X(X.a(new String[0], new String[0]));\n       }\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tfor (X a : as) {\n\t           ^^\nNull pointer access: The variable as can only be null at this location\n----------\n");
    }

    public void testBug427216() {
        this.runConformTest(new String[]{"Test.java", "public class Test\n{\n   public static void main(String[] args)\n   {\n      foo(args); // ok in 1.7 and 1.8\n      foo(java.util.Arrays.asList(\"1\").toArray(new String[0]));\n\t\tSystem.out.println(\"good\");\n   }\n\n   private static void foo(String... args) { }\n}\n"}, "good");
    }

    public void testBug427433() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void testError() {\n\t\tassertEquals(A.e(null, null, null), null);\n\t}\n\tpublic static boolean assertEquals(String a, String b) {\n\t\treturn false;\n\t}\n\tpublic static boolean assertEquals(Object a, Object b) {\n\t\treturn false;\n\t}\n}\nclass A {\n\tpublic static <T, V> V e(T[] t, V[] v, T object) {\n\t\treturn null;\n\t}\n}\n"}, "");
    }

    public void testBug427433b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void testError() {\n\t\tassertEquals(A.e(null, null, null), null);\n\t}\n\tpublic static boolean assertEquals(String a, String b, X... xs) {\n\t\treturn false;\n\t}\n\tpublic static boolean assertEquals(Object a, Object b, X... xs) {\n\t\treturn false;\n\t}\n}\nclass A {\n\tpublic static <T, V> V e(T[] t, V[] v, T object) {\n\t\treturn null;\n\t}\n}\n"}, "");
    }

    public void testBug427438c3() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.List;\npublic class X {\n\tboolean b;\n\tpublic List<A> getLignes() {\n\t\treturn (List<A>) data(b ? (Serializable) get() : null);\n\t}\n\tpublic List<A> get() {\n\t\treturn null;\n\t}\n\tpublic <T extends Serializable> T data(T data) {\n\t\treturn data;\n\t}\n\tpublic class A implements Serializable {\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\treturn (List<A>) data(b ? (Serializable) get() : null);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Serializable to List<X.A>\n----------\n2. WARNING in X.java (at line 14)\n\tpublic class A implements Serializable {\n\t             ^\nThe serializable class A does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test427411() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\n    public static void main() {\n        List<Object> list = null;\n        Object o = null;\n        genericMethod(list, genericClassTransformer(genericClassFactory(o)));\n        genericMethod(list, genericClassFactory(o)); // works\n        GenericClass<Iterable<? super Object>> tempVariable = genericClassTransformer(genericClassFactory(o));\n        GenericClass<Iterable<? super Object>> tempVariable2 = genericClassFactory(o); // works\n    }\n    private static <T> void genericMethod(T param1, GenericClass<? super T> param2) {\n        throw new UnsupportedOperationException();\n    }\n    public static <T> GenericClass<Iterable<? super T>> genericClassFactory(T item) {\n        throw new UnsupportedOperationException();\n    }\n    public static <T> GenericClass<T> genericClassTransformer(GenericClass<T> matcher) {\n        throw new UnsupportedOperationException();\n    }\n    private static class GenericClass<T> {\n    }\n}\n"}, "");
    }

    public void test427728() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <T> int foo(T t) {\n\t\treturn 1234;\n\t}\n\tpublic static void main(String[] args) {\n            goo(foo(10));\n        }\n\tstatic void goo(Integer i) {\n\t\tSystem.out.println(i);\n\t}\n}\n"}, "1234");
    }

    public void test427728a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collections;\npublic class X {\n\tpublic static void mai(String[] args) {\n\t\tMath.max(2345, java.util.Collections.max(Collections.<Integer>emptySet()));\n\t\tMath.max(0, java.util.Collections.<Integer>max(Collections.<Integer>emptySet()));\n    }\n}\n"}, "");
    }

    public void test427728b() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.util.Collections;\nimport java.util.LinkedHashMap;\nimport java.util.Map;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t   Map<X, Integer> map = new LinkedHashMap<>();\n\t\t   map.put(null, X.getInt());\n\t\t   map.put(null, X.getint());\n\t\t}\n\t\tprivate static <T> int getInt() {\n\t\t   return 0;\n\t\t}\n\t\tprivate static int getint() {\n\t\t\t   return 0;\n\t\t}\n}\n"}, "");
    }

    public void test427736() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runNegativeTest(new String[]{"Test1.java", "class Test1<K, V> {\n static class Node<K2, V2> {}\n void keySet(V v) {}\n /**\n  * See {@link #keySet() keySet()},\n  */\n class KeySetView {}\n static <K4, V4> void untree0(Node<K4, V4> hi) {}    \n void untreesomething(Node<K, V> n) {\n   untree0(n); \n }\n}\n"}, "", null, true, customOptions);
    }

    public void test426836() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic <T> T id(T t) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tClass<? extends String> id = id(new X().getClass());\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tClass<? extends String> id = id(new X().getClass());\n\t                             ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Class<capture#1-of ? extends X> to Class<? extends String>\n----------\n");
    }

    public void test428071() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runNegativeTest(new String[]{"K1.java", "import java.util.List;\nimport java.util.Map;\ninterface K1 {\n\tpublic Map<String,List> get();\n}\n", "K.java", "import java.util.List;\nimport java.util.Map;\npublic class K implements K1 {\n\tpublic Map<String, List> get() {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. WARNING in K1.java (at line 4)\n\tpublic Map<String,List> get();\n\t                  ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n----------\n1. WARNING in K.java (at line 4)\n\tpublic Map<String, List> get() {\n\t                   ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test428019() {
        this.runConformTest(new String[]{"X.java", "public final class X {\n  static class Obj {}\n  static class Dial<T> {}\n  static void foo(Dial<? super Obj> dial, X context) {\n    context.put(Dial.class, wrap(dial));\n  }\n  <T> void put(Class<T> clazz, T data) {\n\tSystem.out.println(\"put\");\n  }\n  static <T> Dial<T> wrap(Dial<T> dl) {\n\t  return null;\n  }\n  public static void main(String[] args) {\n\tX.foo(new Dial<Obj>(), new X());\n  }\n}\n"}, "put");
    }

    public void test428285() {
        this.runConformTest(new String[]{"X.java", "class Reference<T> {\n\tReferenceQueue<? super T>  queue;\n}\nclass ReferenceQueue<T> {\n}\npublic class X {\n    public static void main(String args[]) {\n            Reference<Object> r = new Reference<Object>();\n            ReferenceQueue<Object> q = r.queue;\n            System.out.println(\"OK\");\n    }\n}\n"}, "OK");
    }

    public void testBug428366() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T> void m(String s, int i) {}\n\t<T> void m(String s1, String s2) {}\n\tvoid test() {\n\t\tm(\"1\", null);\n\t}\n\tZork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test429733() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttest(new Some<>(1.1d));\n\t}\n\tstatic <S> void test(Option<S> value) {\n\t}\n\tstatic interface Option<T> {\n\t}\n\tstatic class Some<T> implements Option<T> {\n\t\tSome(T value) {\n         System.out.println(value);\n\t\t}\n\t}\n}\n"}, "1.1");
    }

    public void test429733a() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttest(new Some<Double>(1.1d));\n\t}\n\tstatic <S> void test(Option<S> value) {\n\t}\n\tstatic interface Option<T> {\n\t}\n\tstatic class Some<T> implements Option<T> {\n\t\tSome(T value) {\n         System.out.println(value);\n\t\t}\n\t}\n}\n"}, "1.1");
    }

    public void test429733b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttest(id(1.1d));\n\t}\n\tstatic <S> void test(S value) {\n       System.out.println(value);\n\t}\n\tstatic <T> T id(T t) {\n       return t;\n   }\n}\n"}, "1.1");
    }

    public void test429733c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew X();\n\t}\n\t<S> X(S value) {\n       System.out.println(value);\n\t}\n\tstatic <T> T id(T t) {\n       return t;\n   }\n   X() {\n      this(id(1.1d));\n   }\n}\n"}, "1.1");
    }

    public void testBug426537() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(J[] list, I<J<?>> i) {\n\t\tsort(list, i);\n\t}\n\tJ[] sort(J[] list, I<? super J> i) {\n\t\treturn list;\n\t}\n}\ninterface I<T> {}\ninterface J<T> {}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(J[] list, I<J<?>> i) {\n\t         ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tsort(list, i);\n\t^^^^\nThe method sort(J[], I<? super J>) in the type X is not applicable for the arguments (J[], I<J<?>>)\n----------\n3. WARNING in X.java (at line 5)\n\tJ[] sort(J[] list, I<? super J> i) {\n\t^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n4. WARNING in X.java (at line 5)\n\tJ[] sort(J[] list, I<? super J> i) {\n\t         ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n5. WARNING in X.java (at line 5)\n\tJ[] sort(J[] list, I<? super J> i) {\n\t                             ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n");
    }

    public void testBug426537_generic() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(J[] list, I<J<?>> i) {\n\t\tsort(list, i);\n\t}\n\t<T> T[] sort(T[] list, I<? super T> i) {\n\t\treturn list;\n\t}\n}\ninterface I<T> {}\ninterface J<T> {}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(J[] list, I<J<?>> i) {\n\t         ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tsort(list, i);\n\t^^^^\nThe method sort(T[], I<? super T>) in the type X is not applicable for the arguments (J[], I<J<?>>)\n----------\n");
    }

    public void testBug427957() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    <T> void sort(T[] a, I<? super T> c) { }\n    void foo(I[] e, I<I<?>> comp) {\n        sort(e, comp);\n    }\n}\ninterface I<T> {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo(I[] e, I<I<?>> comp) {\n\t         ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n2. ERROR in X.java (at line 4)\n\tsort(e, comp);\n\t^^^^\nThe method sort(T[], I<? super T>) in the type X is not applicable for the arguments (I[], I<I<?>>)\n----------\n");
    }

    public void testBug427957a() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.postResolutionRawTypeCompatibilityCheck", "disabled");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    <T> void sort(T[] a, I<? super T> c) { }\n    void foo(I[] e, I<I<?>> comp) {\n        sort(e, comp);\n    }\n}\ninterface I<T> {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tvoid foo(I[] e, I<I<?>> comp) {\n\t         ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n", null, true, customOptions);
    }

    public void test427992() {
        if (this.complianceLevel < 0x320000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import static org.junit.Assert.assertArrayEquals;\nimport java.util.Arrays;\nimport org.junit.Test;\npublic class X {\n  @Test(expected = IllegalArgumentException.class)\n  public void shouldThrowExceptionWhenClassesAreNotInSameInheritanceTree() {\n    Arrays.sort(new Class[] {Chimp.class, Cat.class}, ClassInheritanceDepthComparator.INSTANCE);\n  }\n  public static class Animal {\n  }\n  public static class Monkey extends Animal {\n  }\n  public static class Chimp extends Monkey {\n  }\n  public static class Cat extends Animal {\n  }\npublic static class ClassInheritanceDepthComparator implements Comparator<Class<?>> {\n  public static final ClassInheritanceDepthComparator INSTANCE = new ClassInheritanceDepthComparator();\n  @Override\n  public int compare(Class<?> c1, Class<?> c2) {\n    if(c1.equals(c2)) {\n      return 0;\n    }\n    if(c1.isAssignableFrom(c2)) {\n      return -1;\n    }\n    if(c2.isAssignableFrom(c1)) {\n      return 1;\n    }\n    throw new IllegalArgumentException(\"classes to compare must be in the same inheritance tree: \" + c1 + \"; \" + c2);\n  }\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport static org.junit.Assert.assertArrayEquals;\n\t              ^^^^^^^^^\nThe import org.junit cannot be resolved\n----------\n2. ERROR in X.java (at line 3)\n\timport org.junit.Test;\n\t       ^^^^^^^^^\nThe import org.junit cannot be resolved\n----------\n3. ERROR in X.java (at line 5)\n\t@Test(expected = IllegalArgumentException.class)\n\t ^^^^\nTest cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 7)\n\tArrays.sort(new Class[] {Chimp.class, Cat.class}, ClassInheritanceDepthComparator.INSTANCE);\n\t       ^^^^\nThe method sort(T[], Comparator<? super T>) in the type Arrays is not applicable for the arguments (Class[], X.ClassInheritanceDepthComparator)\n----------\n5. ERROR in X.java (at line 17)\n\tpublic static class ClassInheritanceDepthComparator implements Comparator<Class<?>> {\n\t                                                               ^^^^^^^^^^\nComparator cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 20)\n\tpublic int compare(Class<?> c1, Class<?> c2) {\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method compare(Class<?>, Class<?>) of type X.ClassInheritanceDepthComparator must override or implement a supertype method\n----------\n");
    }

    public void testBug430987() {
        String source = "public class X {\n\n  public static interface Foo<T> {\n    // no content\n  }\n\n  public void compileError() {\n    doSomethingWithFoo( any( Foo.class ), any( Foo.class ) );\n  }\n\n  public void noCompileError() {\n    Foo foo = any( Foo.class );\n    doSomethingWithFoo( foo, foo );\n  }\n\n  public void fix() {\n    this.<Object>doSomethingWithFoo( any( Foo.class ), any( Foo.class ) );\n  }\n\n  public <T> void  doSomethingWithFoo( Foo<T> foo, Foo<T> foo2 ) {\n    // do something\n  }\n\n  public static <T> T any(Class<T> clazz) {\n    return null;\n  }\n\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runConformTest(new String[]{"X.java", source});
        } else {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 8)\n\tdoSomethingWithFoo( any( Foo.class ), any( Foo.class ) );\n\t^^^^^^^^^^^^^^^^^^\nThe method doSomethingWithFoo(X.Foo<T>, X.Foo<T>) in the type X is not applicable for the arguments (X.Foo, X.Foo)\n----------\n2. WARNING in X.java (at line 12)\n\tFoo foo = any( Foo.class );\n\t^^^\nX.Foo is a raw type. References to generic type X.Foo<T> should be parameterized\n----------\n3. WARNING in X.java (at line 13)\n\tdoSomethingWithFoo( foo, foo );\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation doSomethingWithFoo(X.Foo, X.Foo) of the generic method doSomethingWithFoo(X.Foo<T>, X.Foo<T>) of type X\n----------\n4. WARNING in X.java (at line 13)\n\tdoSomethingWithFoo( foo, foo );\n\t                    ^^^\nType safety: The expression of type X.Foo needs unchecked conversion to conform to X.Foo<Object>\n----------\n5. WARNING in X.java (at line 13)\n\tdoSomethingWithFoo( foo, foo );\n\t                         ^^^\nType safety: The expression of type X.Foo needs unchecked conversion to conform to X.Foo<Object>\n----------\n6. WARNING in X.java (at line 17)\n\tthis.<Object>doSomethingWithFoo( any( Foo.class ), any( Foo.class ) );\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation doSomethingWithFoo(X.Foo, X.Foo) of the generic method doSomethingWithFoo(X.Foo<T>, X.Foo<T>) of type X\n----------\n7. WARNING in X.java (at line 17)\n\tthis.<Object>doSomethingWithFoo( any( Foo.class ), any( Foo.class ) );\n\t                                 ^^^^^^^^^^^^^^^^\nType safety: The expression of type X.Foo needs unchecked conversion to conform to X.Foo<Object>\n----------\n8. WARNING in X.java (at line 17)\n\tthis.<Object>doSomethingWithFoo( any( Foo.class ), any( Foo.class ) );\n\t                                                   ^^^^^^^^^^^^^^^^\nType safety: The expression of type X.Foo needs unchecked conversion to conform to X.Foo<Object>\n----------\n");
        }
    }

    public void testBug430686() {
        this.runConformTest(new String[]{"TestClass.java", "\npublic class TestClass\n{\n    private static class Alice<A extends Alice<A, B>, B extends Bob>\n    {\n    }\n\n    public static class Bob\n    {\n    }\n\n    public void callingMethod()\n    {\n        calledMethod(); // error: The method calledMethod() in the type TestClass is not applicable for the arguments ()\n    }\n\n    private <A extends Alice<A, B>, B extends Bob> A calledMethod()\n    {\n        return null;\n    }\n}\n"});
    }

    public void testBug430759() {
        this.runConformTest(new String[]{"A.java", "class CriteriaBuilder {\n\n}\n\nclass CriteriaQuery<T> {\n\n}\n\nclass Root<T> {\n\n}\n\npublic class A<E> {\n\n    protected abstract class CustomGenericQuery<T> {\n    }\n\n    protected <T> T executeCustomSingleQuery(CustomGenericQuery<T> customQuery, Class<T> resultClass) {\n\treturn null;\n    }\n\n    public Long getCount() {\n\treturn executeCustomSingleQuery(\n\n\tnew CustomGenericQuery<Long>() {\n\t    public void customizeQuery(final Root<E> root, final CriteriaBuilder cb,\n\t\t    CriteriaQuery<Long> cq) {\n\t    }\n\t}, Long.class);\n    }\n}\n"});
    }

    public void testBug431408() {
        this.runConformTest(new String[]{"EclipseJava8Generics.java", "public class EclipseJava8Generics {\n\n  public interface Foo<V> {\n  }\n\n  public static class FooBar<V, T extends Foo<V>> {\n  }\n\n  public static class BaseClass {\n    protected <V> FooBar<V, ? extends Foo<V>> doSomething() {\n      return null;\n    }\n  }\n\n  public static class DerivedClass extends BaseClass {\n    @Override\n    protected <V> FooBar<V, ? extends Foo<V>> doSomething() {\n      //Eclipse 4.3.2 with Java 8 can't compile the next line \n      FooBar<V, ? extends Foo<V>> prop = super.doSomething();\n      return prop;\n    }\n  }\n}\n"});
    }

    public void testBug431581() {
        this.runNegativeTest(new String[]{"BugEclipse.java", "public class BugEclipse\n{\n  static Dog dog = new Dog();\n  public static void main(String[] args)\n  {\n    System.out.println(\"bug compile eclipse\");\n    Cat cat = getDog(); // <- error here, eclipse compile this line but the execution print ClassCastException\n  }\n  public static <T extends Dog> T getDog()\n  {\n    return (T) dog;\n  }\n  static class Cat {\n  }\n  static class Dog {\n  }\n}\n"}, "----------\n1. ERROR in BugEclipse.java (at line 7)\n\tCat cat = getDog(); // <- error here, eclipse compile this line but the execution print ClassCastException\n" + (this.complianceLevel < 0x340000L ? "\t          ^^^^^^\nBound mismatch: The generic method getDog() of type BugEclipse is not applicable for the arguments (). The inferred type BugEclipse.Cat&BugEclipse.Dog is not a valid substitute for the bounded parameter <T extends BugEclipse.Dog>\n" : "\t          ^^^^^^^^\nType mismatch: cannot convert from BugEclipse.Dog to BugEclipse.Cat\n") + "----------\n" + "2. WARNING in BugEclipse.java (at line 11)\n" + "\treturn (T) dog;\n" + "\t       ^^^^^^^\n" + "Type safety: Unchecked cast from BugEclipse.Dog to T\n" + "----------\n");
    }

    public void testBug432603() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.Map;\nimport java.util.Map.Entry;\n\nabstract class Optional<T> {\n\tpublic static <T> Optional<T> fromNullable(T t) { return null; }\n\tabstract Optional<T> or(Optional<? extends T> secondChoice);\n\tabstract T or(Supplier<? extends T> supplier);\n\tabstract T or(T defaultValue);\n}\n\ninterface Supplier<T> { T get(); }\n\npublic class Test {\n\n    private static final Object NO_VALUE = new Object();\n\n    public void method(Map<String, ?> map) {\n        for (Entry<String, ?> entry : map.entrySet()) {\n            Optional.fromNullable(entry.getValue()).or(NO_VALUE);\n//                                                  ^^ error here\n        }\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 19)\n\tOptional.fromNullable(entry.getValue()).or(NO_VALUE);\n\t                                        ^^\nThe method or(Optional<? extends capture#2-of ?>) in the type Optional<capture#2-of ?> is not applicable for the arguments (Object)\n----------\n");
    }

    public void testBug432603a() {
        this.runConformTest(new String[]{"Test.java", "import java.util.Map;\nimport java.util.Map.Entry;\n\nabstract class Optional<T> {\n\tpublic static <T> Optional<T> fromNullable(T t) { return null; }\n\tabstract Optional<T> or(Optional<? extends T> secondChoice);\n\tabstract T or(Supplier<? extends T> supplier);\n\tabstract T or(T defaultValue);\n}\n\ninterface Supplier<T> { T get(); }\n\npublic class Test {\n\n    private static final Object NO_VALUE = new Object();\n\n    public void method(Map<String, ?> map) {\n        for (Entry<String, ?> entry : map.entrySet()) {\n            Optional.<Object>fromNullable(entry.getValue()).or(NO_VALUE);\n//                                                  ^^ error here\n        }\n    }\n}\n"});
    }

    public void testBug399527() {
        this.runNegativeTest(new String[]{"TypeInferenceProblem.java", "\npublic class TypeInferenceProblem {\n  interface HeaderAccess<T> {\n    T getHeader();\n  }\n\n  interface IExpectationSetters<T> {\n    IExpectationSetters<T> andReturn(T value);\n  }\n\n  static class MocksControl implements IExpectationSetters<Object> {\n    public IExpectationSetters<Object> andReturn(Object value) {\n      return null;\n    }\n  }\n\n  @SuppressWarnings(\"unchecked\")\n  public static <T> IExpectationSetters<T> expect(final T value) {\n    return (IExpectationSetters<T>) new MocksControl();\n  }\n\n  private HeaderAccess<Object> mockHeaderAccess;\n  private HeaderAccess<?> unboundedMockHeaderAccess;\n\n  public void test() {\n    // No error\n    expect(mockHeaderAccess.getHeader()).andReturn(new Object());\n    /*\n     * Error: The method andReturn(capture#1-of ?) in the type\n     * TypeInferenceProblem.IExpectationSetters<capture#1-of ?> \n     * is not applicable for the arguments (Object)\n     */\n    expect(unboundedMockHeaderAccess.getHeader()).andReturn(new Object());\n  }\n}\n"}, "----------\n1. ERROR in TypeInferenceProblem.java (at line 33)\n\texpect(unboundedMockHeaderAccess.getHeader()).andReturn(new Object());\n\t                                              ^^^^^^^^^\nThe method andReturn(capture#1-of ?) in the type TypeInferenceProblem.IExpectationSetters<capture#1-of ?> is not applicable for the arguments (Object)\n----------\n");
    }

    public void testBug399527_corrected() {
        this.runConformTest(new String[]{"TypeInferenceProblem.java", "\npublic class TypeInferenceProblem {\n  interface HeaderAccess<T> {\n    T getHeader();\n  }\n\n  interface IExpectationSetters<T> {\n    IExpectationSetters<T> andReturn(T value);\n  }\n\n  static class MocksControl implements IExpectationSetters<Object> {\n    public IExpectationSetters<Object> andReturn(Object value) {\n      return null;\n    }\n  }\n\n  @SuppressWarnings(\"unchecked\")\n  public static <T> IExpectationSetters<T> expect(final T value) {\n    return (IExpectationSetters<T>) new MocksControl();\n  }\n\n  private HeaderAccess<Object> mockHeaderAccess;\n  private HeaderAccess<?> unboundedMockHeaderAccess;\n\n  public void test() {\n    // No error\n    expect(mockHeaderAccess.getHeader()).andReturn(new Object());\n    this.<Object>expect(unboundedMockHeaderAccess.getHeader()).andReturn(new Object());\n  }\n}\n"});
    }

    public void testBug399527_comment1() {
        String sourceString = "public class TypeInferenceProblemMin {\n  interface HeaderAccess<T> {\n    T getHeader();\n  }\n\n  interface IExpectationSetters<T> {\n  }\n\n  public static <T> IExpectationSetters<T> expect(final T value) {\n\t  return null;\n  }\n\n  private HeaderAccess<?> unboundedMockHeaderAccess;\n  \n  public void test() {\n    // no error:\n    Object header = unboundedMockHeaderAccess.getHeader();\n    IExpectationSetters<Object> exp1 = expect(header);\n\n    // Type mismatch: cannot convert from TypeInferenceProblemMin.IExpectationSetters<capture#2-of ?> to TypeInferenceProblemMin.IExpectationSetters<Object>\n    IExpectationSetters<Object> exp2 = expect(unboundedMockHeaderAccess.getHeader());\n  }\n}\n";
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"TypeInferenceProblemMin.java", sourceString}, "----------\n1. ERROR in TypeInferenceProblemMin.java (at line 21)\n\tIExpectationSetters<Object> exp2 = expect(unboundedMockHeaderAccess.getHeader());\n\t                                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from TypeInferenceProblemMin.IExpectationSetters<capture#2-of ?> to TypeInferenceProblemMin.IExpectationSetters<Object>\n----------\n");
        } else {
            this.runConformTest(new String[]{"TypeInferenceProblemMin.java", sourceString});
        }
    }

    public void testBug434570() {
        this.runConformTest(new String[]{"example/Example.java", "package example;\n\nimport example.Example.Config;\nimport example.Example.CustomInitializer;\n\n@Config(initializers = CustomInitializer.class)\npublic class Example {\n\n\tstatic interface Context {\n\t}\n\n\tstatic interface ConfigurableContext extends Context {\n\t}\n\n\tstatic abstract class AbstractContext implements ConfigurableContext {\n\t}\n\n\tstatic class GenericContext extends AbstractContext {\n\t}\n\n\tstatic interface Initializer<C extends ConfigurableContext> {\n\t}\n\n\tstatic @interface Config {\n\t\tClass<? extends Initializer<? extends ConfigurableContext>>[] initializers() default {};\n\t}\n\n\tstatic class CustomInitializer implements Initializer<GenericContext> {\n\t}\n\n\t@Config(initializers = CustomInitializer.class)\n\tstatic class CompilationSuccess {\n\t}\n\n}\n"});
    }

    public void testBug434630() {
        this.runConformTest(new String[]{"Foo.java", "interface Provider<T> {}\n@interface ProvidedBy {\n\tClass<? extends Provider<?>> value();}\n\n@ProvidedBy(Foo.SomeProvider.class)\npublic interface Foo {\n\t\n\tpublic static class SomeProvider implements Provider<Foo> {\n\n\t\tpublic Foo get() {\n\t\t\treturn null;\n\t\t}\n\t\t\n\t}\n}\n"});
    }

    public void testBug434570_comment3() {
        this.runConformTest(new String[]{"TestWontCompile.java", "import org.bug.AnnotationWithClassParameter;\nimport org.bug.CustomHandler;\nimport org.bug.Handler;\n\n\n@AnnotationWithClassParameter(CustomHandler.class)\npublic class TestWontCompile extends ATest<Object> {\n\t\n\tpublic static void main(String[] args) {\n\t\tClass<? extends Handler<?>> h = CustomHandler.class;\n\t}\n\n}\n", "ATest.java", "public abstract class ATest<T> {\n\n}\n", "org/bug/Item.java", "package org.bug;\n\npublic interface Item {\n\n}\n", "org/bug/CustomItem.java", "package org.bug;\n\npublic class CustomItem implements Item {\n\n}\n", "org/bug/Handler.java", "package org.bug;\n\npublic abstract class Handler<T extends Item> {\n\n}\n", "org/bug/CustomHandler.java", "package org.bug;\n\npublic class CustomHandler extends Handler<CustomItem> {\n\n}\n", "org/bug/AnnotationWithClassParameter.java", "package org.bug;\n\nimport java.lang.annotation.Documented;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE)\n@Retention(RetentionPolicy.RUNTIME)\n@Documented\npublic @interface AnnotationWithClassParameter {\n\t\n\tClass<? extends Handler<?>> value();\n\n}\n"});
    }

    public void testBug434570_comment3b() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.runConformTest(new String[]{"TestWontCompile.java", "import org.bug.AnnotationWithClassParameter;\nimport org.bug.CustomHandler;\nimport org.bug.Handler;\n\n\n@AnnotationWithClassParameter(CustomHandler.class)\npublic class TestWontCompile extends ATest<Object> {\n\t\n\tpublic static void main(String[] args) {\n\t\tClass<? extends Handler<?>> h = CustomHandler.class;\n\t}\n\n}\n", "ATest.java", "public abstract class ATest<T> {\n\n}\n", "org/bug/Item.java", "package org.bug;\n\npublic interface Item {\n\n}\n", "org/bug/CustomItem.java", "package org.bug;\n\npublic class CustomItem implements Item {\n\n}\n", "org/bug/Handler.java", "package org.bug;\n\npublic abstract class Handler<T extends Item> {\n\n}\n", "org/bug/CustomHandler.java", "package org.bug;\n\npublic class CustomHandler extends Handler<CustomItem> {\n\n}\n", "org/bug/AnnotationWithClassParameter.java", "package org.bug;\n\nimport java.lang.annotation.Documented;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE)\n@Retention(RetentionPolicy.RUNTIME)\n@Documented\npublic @interface AnnotationWithClassParameter {\n\t\n\tClass<? extends Handler<?>> value();\n\n}\n"}, options);
    }

    public void testBug434630_comment7() {
        this.runConformTest(new String[]{"test/FooImpl.java", "package test;\n\npublic class FooImpl implements Foo {\n\n}\n", "test/Foo.java", "package test;\ninterface Provider<T> {}\n@interface ProvidedBy {\n\tClass<? extends Provider<?>> value();}\n\n@ProvidedBy(Foo.SomeProvider.class)\npublic interface Foo {\n\t\n\tpublic static class SomeProvider implements Provider<Foo> {\n\n\t\tpublic Foo get() {\n\t\t\treturn null;\n\t\t}\n\t\t\n\t}\n}\n"});
    }

    public void testBug434044() {
        this.runConformTest(new String[]{"EclipseJava8Generics.java", "public class EclipseJava8Generics {\n\n  public interface Foo<V> {\n    public V doFoo();\n  }\n\n  public static class FooBar<V, T extends Foo<V>> {\n    public T getBar() {\n      return null;\n    }\n  }\n\n  public static class Factory {\n\n    public static <V, T extends Foo<V>> FooBar<V, T> createFooBar() {\n      return null;\n    }\n  }\n\n  public static void test() {\n    final FooBar<?, ? extends Foo<?>> typedProperty = Factory.createFooBar();\n    //TODO Eclipse Bug 434044\n    final Object propertyValue = typedProperty.getBar().doFoo();\n\n  }\n\n}\n"});
    }

    public void testBug434044_comment20() {
        this.runConformTest(new String[]{"EclipseJava8Generics.java", "public class EclipseJava8Generics {\n\n  public interface Foo<V> {\n    public V doFoo();\n  }\n\n  public static class FooBar<V, T extends Foo<V>> {\n    public T getBar() {\n      return null;\n    }\n  }\n\n  public static abstract class AbstractFoo<V> implements Foo<V> {\n  }\n\n  public static class Factory {\n    public static <V, T extends AbstractFoo<V>> FooBar<V, T> createFooBar() {\n      return null;\n    }\n  }\n\n  public static void test() {\n    final FooBar<?, ? extends AbstractFoo<?>> typedProperty = Factory.createFooBar();\n    //TODO Eclipse Bug 434044 still exists\n    final Object propertyValue = typedProperty.getBar().doFoo();\n  }\n\n}\n"});
    }

    public void testBug434044_comment36() {
        this.runNegativeTest(new String[]{"EclipseJava8Generics.java", "public class EclipseJava8Generics {\n\n  public interface Nasty {\n    public Object doFoo(Integer a);\n  }\n  public interface Foo<V> {\n    public V doFoo(String a);\n  }\n\n  public static class FooBar<V, T extends Foo<V>> {\n    public T getBar() {\n      return null;\n    }\n  }\n\n  public static abstract class AbstractFoo<V> implements Foo<V>, Nasty {\n  }\n\n  public static class Factory {\n    public static <V, T extends AbstractFoo<V>> FooBar<V, T> createFooBar() {\n      return null;\n    }\n  }\n\n  public static void test() {\n    final FooBar<?, ? extends AbstractFoo<?>> typedProperty = Factory.createFooBar();\n    //TODO Eclipse Bug 434044 still exists\n    final Object propertyValue = typedProperty.getBar().doFoo(null);\n  }\n}\n"}, "----------\n1. ERROR in EclipseJava8Generics.java (at line 28)\n\tfinal Object propertyValue = typedProperty.getBar().doFoo(null);\n\t                                                    ^^^^^\nThe method doFoo(String) is ambiguous for the type capture#2-of ? extends EclipseJava8Generics.AbstractFoo<?>\n----------\n");
    }

    public void testBug434793() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.runConformTest(new String[]{"Outer.java", "import java.util.*;\n\npublic class Outer {\n\tprivate static class SingletonList<E>\n\t\t\t\t extends AbstractList<E>\n\t\t\t\t implements java.util.RandomAccess, java.io.Serializable {\n\t\tpublic E get(int i) { throw new RuntimeException(); }\n\t\tpublic int size() { return 0; }\n\t}\n}\n"}, options);
    }

    public void testBug435643() {
        this.runConformTest(new String[]{"test/Main.java", "package test;\nabstract class ASTNode<T extends ASTNode> implements Iterable<T> {\n\tpublic T getChild(int i) { return null; }\n} \nabstract class List<T extends ASTNode> extends ASTNode<T> { }\nclass Joiner {\n\t  public static Joiner on(String separator) {\n\t    return null;\n\t  }\n\t  String join(Iterable<?> parts) {\n\t\t  return \"\";\n\t  }\n}\nclass AstFunctions {\n\t  public static <T extends ASTNode<?>> Function<T, String> prettyPrint() {\n\t\t  return null;\n\t  }\n}\nclass Iterables {\n\tpublic static <F, T> Iterable<T> transform(final Iterable<F> fromIterable,\n\t\t      final Function<? super F, ? extends T> function) {\n\t\treturn null;\n\t}\n}\ninterface Function<F, T> {\n\t T apply(F input);\n}\npublic class Main {\n\n\t  String test(ASTNode<?> node, ASTNode rawNode) {\n\t\trawNode.getChild(0); \n\t    \n        @SuppressWarnings(\"unchecked\")\n        List<? extends ASTNode<?>> list = (List<? extends ASTNode<?>>) node;\n        return Joiner.on(\", \").join(Iterables.transform(list, AstFunctions.prettyPrint()));\n\t  }\n\n}\n"});
    }

    public void testBug438337comment5() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tvoid test() {\n\t\tI18nResource<?> i18nResource = null;\n\t}\n}\n", "I18nResource.java", "public interface I18nResource<E extends Internationalized<? extends I18nResource<E>>> extends BusinessObject {}\n", "Internationalized.java", "public interface Internationalized<E extends I18nResource<? extends Internationalized<E>>>\n    extends BusinessObject {}\n", "BusinessObject.java", "public interface BusinessObject {}\n"});
    }

    public void testBug438337comment3() {
        this.runConformTest(new String[]{"PermissionDrivenPresenter.java", "public abstract class PermissionDrivenPresenter<V extends BaseView<? extends Presenter<V>>> extends BasePresenter<V> {\n\n    public void updatePermissions() {\n        getView().setReadOnly(true);\n    }\n}\n", "View.java", "public interface View<P extends Presenter<? extends View<P>>> { }\n", "Presenter.java", "public interface Presenter<V extends View<? extends Presenter<V>>> { }\n", "BaseView.java", "public abstract class BaseView<P extends Presenter<? extends View<P>>> implements View<P> {\n\tvoid setReadOnly(boolean f) {}\n}\n", "BasePresenter.java", "public abstract class BasePresenter<V extends View<? extends Presenter<V>>> implements Presenter<V> {\n    public V getView() {\n        return null;\n    }\n}\n"});
    }

    public void test416480() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends Object & Runnable> {\n    private Runnable cast(T obj) {\n        return obj;\n    }\n    public static void main(String[] args) {\n        try {\n            Runnable runnable = new X().cast(new Object());\n        } catch (ClassCastException c) {\n            System.out.println(\"CCE\");\n        }\n    }\n}\n"}, "CCE");
    }

    public void testBug422832() {
        String path = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "Bug422832ClassFile" + File.separator + "aspose.pdf.jar";
        String[] libs = this.getDefaultClassPaths();
        int len = libs.length;
        String[] stringArray = libs;
        libs = new String[len + 1];
        System.arraycopy(stringArray, 0, libs, 0, len);
        libs[len] = path;
        this.runNegativeTest(new String[]{"ExampleClass.java", "public class ExampleClass extends aspose.b.a.a {}\n"}, "----------\n1. ERROR in ExampleClass.java (at line 1)\n\tpublic class ExampleClass extends aspose.b.a.a {}\n\t             ^^^^^^^^^^^^\nThe hierarchy of the type ExampleClass is inconsistent\n----------\n", libs, false);
    }
}

