/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class LambdaRegressionTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public LambdaRegressionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LambdaRegressionTest.buildMinimalComplianceTestSuite(LambdaRegressionTest.testClass(), 32);
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\nimport java.util.function.Function;\npublic class X {\n  public static void main(String[] args) {\n    new X().run();\n  }\n  public void run() {\n    class Inner {\n      public Inner() {\n        System.out.println(\"miep\");\n      }\n    }\n    Map<String, Inner> map = new HashMap<>();\n    Function<String, Inner> function = (name) -> {\n      Inner i = map.get(name);\n      if (i == null) {\n        i = new Inner();\n        map.put(name, i);\n      }\n      return i;\n\n    };\n    function.apply(\"test\");\n  }\n}\n"}, "miep");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.Consumer;\n@SuppressWarnings(\"all\")\npublic class X {\n  private final String text = \"Bug?\";\n  public static void main(String[] args) {\n    new X().doIt();\n  }\n  private void doIt() {\n    new Sub();\n  }\n  private class Super<T> {\n    public Super(Consumer<T> consumer) {\n    }\n  }\n  private class Sub extends Super<String> {\n    public Sub() {\n      super(s -> System.out.println(text));\n      // super(s -> System.out.println(\"miep\"));\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tsuper(s -> System.out.println(text));\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot refer to 'this' nor 'super' while explicitly invoking a constructor\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.Consumer;\n@SuppressWarnings(\"all\")\npublic class X {\n  private final String text = \"Bug?\";\n  public static void main(String[] args) {\n    new X().doIt();\n  }\n  private void doIt() {\n    new Sub();\n  }\n  private class Super<T> {\n    public Super(Consumer<T> consumer) {\n    }\n  }\n  private class Sub extends Super<String> {\n    public Sub() {\n       super(s -> System.out.println(\"miep\"));\n    }\n  }\n}\n"}, "");
    }

    public void test004() {
        this.runConformTest(new String[]{"Y.java", "import java.util.function.Supplier;\nclass E {\n\tE(Supplier<Object> factory) { }\n}\npublic class Y extends E {\n\tY() {\n\t\tsuper( () -> {\n\t\t\tclass Z extends E {\n\t\t\t\tZ() {\n\t\t\t\t\tsuper(() -> new Object());\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn null;\n\t\t\t});\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Y();\n\t}\n}"});
    }

    public void testBug4448556() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\nimport java.util.List;\npublic class X {\n    private static final List<Integer> INTEGERS = Arrays.asList(1, 2, 3, 4);\n    public static void main(String[] args) {\n        for (int i = 0; i < INTEGERS.size(); i++) {\n            MyPredicate<Integer> predicate = INTEGERS.get(i)::equals;\n        }\n    }  \n    public interface MyPredicate<T> extends Serializable {\n        boolean accept(T each);\n    }\n}"}, "");
    }

    public void testBug4448556a() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\nimport java.util.List;\npublic class X {\n\tint value = 0; \n    private static final List<Integer> INTEGERS = Arrays.asList(1, 2, 3, 4);\n    public Integer next() {\n    \treturn new Integer(++value);\n    }\n    public static void main(String[] args) {\n    \tX t = new X();\n        MyPredicate<Integer> predicate = t.next()::equals;\n        System.out.println(\"Value \" + t.value + \" accept \" + predicate.accept(t.value));\n    }\n    public interface MyPredicate<T> extends Serializable {\n        boolean accept(T each);\n    }\n}"}, "Value 1 accept true");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.LambdaRegressionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

