/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class MethodHandleTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public MethodHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MethodHandleTest.buildMinimalComplianceTestSuite(MethodHandleTest.testClass(), 16);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.compiler.regression.MethodHandleTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\n\npublic class X {\n\tpublic static void main(String[] args) throws Throwable {\n\t\tMethodHandles.Lookup lookup = MethodHandles.lookup();\n\n\t\tMethodType mt = MethodType.methodType(String.class, String.class, char.class);\n\t\tMethodHandle mh = lookup.findStatic(X.class, \"append\", mt);\n\t\tString s = (String) mh.invokeExact(\"follo\",'w');\n\t\tSystem.out.println(s);\n\n\t\tmt = MethodType.methodType(int.class, Object[].class);\n\t\tmh = lookup.findVirtual(X.class, \"arrayLength\", mt);\n\t\tint i = (int) mh.invokeExact(new X(), new Object[] {1, 'A', \"foo\"});\n\t\tSystem.out.println(i);\n\n\t\tmt = MethodType.methodType(void.class, String.class);\n\t\tmh = lookup.findStatic(X.class, \"hello\", mt);\n\t\tmh.invokeExact(\"world\");\n\n\t\tmt = MethodType.methodType(Object.class, String.class, int.class);\n\t\tmh = lookup.findVirtual(X.class, \"foo\", mt);\n\t\tObject o = mh.invokeGeneric(new X(), (Object)\"foo:\", i);\n\n\t\tmt = MethodType.methodType(void.class);\n\t\tmh = lookup.findStatic(X.class, \"bar\", mt);\n\t\tmh.invokeExact();\n\t}\n\tpublic static void bar() {\n\t\tSystem.out.println(\"bar\");\n\t}\n\tpublic Object foo(String s, int i) {\n\t\tSystem.out.println(s + i);\n\t\treturn s + i;\n\t}\n\tpublic static String append(String s, char c) {\n\t\treturn s + c;\n\t}\n\tpublic int arrayLength(Object[] array) {\n\t\treturn array.length;\n\t}\n\tpublic static void hello(String name) {\n\t\tSystem.out.println(\"Hello, \"+ name);\n\t}\n}"}, "follow\n3\nHello, world\nfoo:3\nbar");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\nimport java.lang.invoke.WrongMethodTypeException;\n\npublic class X {\n\tpublic static void foo() {\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tMethodHandle handle = MethodHandles.lookup().findStatic(X.class, \"foo\", MethodType.methodType(void.class));\n\t\t\ttry {\n\t\t\t\thandle.invokeGeneric(null);\n\t\t\t} catch (WrongMethodTypeException ok) {\n\t\t\t\tSystem.out.println(\"This is ok\");\n\t\t\t} catch (Throwable e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t} catch (Throwable e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "This is ok");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\nimport java.lang.invoke.WrongMethodTypeException;\n\npublic class X {\n\tpublic static <T> T foo(T param){\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tMethodHandle handle = MethodHandles.lookup().findStatic(X.class, \"foo\", MethodType.methodType(Object.class, Object.class));\n\t\t\ttry {\n\t\t\t\thandle.invokeGeneric(null);\n\t\t\t} catch (Throwable e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t} catch (Throwable e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "");
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\nimport java.lang.invoke.WrongMethodTypeException;\n\npublic class X {\n\tpublic static <T> T foo(T param){\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tMethodHandle handle = MethodHandles.lookup().findStatic(X.class, \"foo\", MethodType.methodType(Object.class, Object.class));\n\t\t\ttry {\n\t\t\t\thandle.invokeGeneric(new Object());\n\t\t\t} catch (Throwable e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t} catch (Throwable e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\nimport java.lang.invoke.WrongMethodTypeException;\n\npublic class X {\n\tpublic static <T> T foo(T param){\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tMethodHandle handle = MethodHandles.lookup().findStatic(X.class, \"foo\", MethodType.methodType(Object.class, Object.class));\n\t\t\ttry {\n\t\t\t\tObject o = handle.invokeGeneric(new Object());\n\t\t\t} catch (Throwable e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t} catch (Throwable e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\nimport java.lang.invoke.WrongMethodTypeException;\n\npublic class X {\n\tpublic static void main(String[] args) throws Throwable {\n\t\tMethodHandles.Lookup lookup = MethodHandles.lookup();\n\n\t\tMethodType mt = MethodType.methodType(String.class, String.class, char.class);\n\t\tMethodHandle mh = lookup.findStatic(X.class, \"append\", mt);\n\t\tString s = (String) mh.invokeExact(\"follo\",'w');\n\t\tSystem.out.println(s);\n\t\tMethodType mt2 = MethodType.methodType(String.class, String.class, char.class);\n\t\tMethodHandle mh2 = lookup.findStatic(X.class, \"append\", mt2);\n\t\ttry {\n\t\t\tmh2.invokeExact(\"follo\",'w');\n\t\t} catch(WrongMethodTypeException e) {\n\t\t\tSystem.out.println(\"Expected exception\");\n\t\t}\n\t}\n\tpublic static String append(String s, char c) {\n\t\treturn s + c;\n\t}\n}"}, "follow\nExpected exception");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "import static java.lang.invoke.MethodHandles.lookup;\nimport static java.lang.invoke.MethodType.methodType;\nimport java.lang.invoke.MethodHandle;\n\npublic class X {\n\tpublic static void main(String[] args) throws Throwable {\n\t\tMethodHandle fooMH = lookup().findStatic(X.class, \"foo\", methodType(String.class));\n\t\tString s = (String) fooMH.invokeExact();\n\t\tSystem.out.println(s);\n\t\tfooMH.asType(methodType(void.class)).invokeExact();\n\t}\n\tpublic static String foo() {\n\t\tSystem.out.println(\"Inside foo\");\n\t\treturn \"foo\";\n\t}\n}"}, "Inside foo\nfoo\nInside foo");
    }

    public void test008() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\nimport java.lang.invoke.WrongMethodTypeException;\n\npublic class X {\n\tpublic static <T> T foo(T param){\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tMethodHandle handle = MethodHandles.lookup().findStatic(X.class, \"foo\", MethodType.methodType(Object.class, Object.class));\n\t\t\ttry {\n\t\t\t\tObject o = handle.invokeGeneric(new Object());\n\t\t\t} catch (Throwable e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t} catch (Throwable e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 14)\n\tObject o = handle.invokeGeneric(new Object());\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method invokeGeneric(Object...) from the type MethodHandle is deprecated\n----------\n", null, true, options);
    }

    public void test009() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\npublic class X {\n  public static void main(String[] args) throws Throwable {\n    String str = \"test\";\n    MethodHandle mh = MethodHandles.lookup().findVirtual(String.class, \"toString\", \n        MethodType.methodType(String.class));\n    String actual = (String) mh.invoke(str);\n    assert \"test\".equals(actual);\n    Zork z;\n  }\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test010() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\npublic class X {\n  public static void main(String[] args) throws Throwable {\n    String str = \"test\";\n    MethodHandle mh = MethodHandles.lookup().findVirtual(String.class, \"toString\", \n        MethodType.methodType(String.class));\n    Object actual = (Object) mh.invoke(str);\n    assert \"test\".equals(actual);\n    Zork z;\n  }\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 9)\n\tObject actual = (Object) mh.invoke(str);\n\t                ^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Object to Object\n----------\n2. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }
}

