/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.runtime.TargetInterface;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.eval.EvaluationContext;

public class EvaluationSetup
extends CompilerTestSetup {
    public static final String EVAL_DIRECTORY = String.valueOf(Util.getOutputDirectory()) + File.separator + "evaluation";
    public static final String JRE_PATH = Util.getJREDirectory();
    EvaluationContext context;
    TargetInterface target;
    LocalVirtualMachine launchedVM;
    INameEnvironment env;

    public EvaluationSetup(long complianceLevel) {
        super(complianceLevel);
    }

    protected void setUp() {
        if (this.context == null) {
            int evalPort = Util.getFreePort();
            try {
                LocalVMLauncher launcher = LocalVMLauncher.getLauncher();
                launcher.setVMPath(JRE_PATH);
                launcher.setEvalPort(evalPort);
                launcher.setEvalTargetPath(EVAL_DIRECTORY);
                this.launchedVM = launcher.launch();
            }
            catch (TargetException e) {
                throw new Error(e.getMessage());
            }
            try {
                this.startReader("VM's stdout reader", this.launchedVM.getInputStream(), System.out);
            }
            catch (TargetException targetException) {}
            try {
                this.startReader("VM's sterr reader", this.launchedVM.getErrorStream(), System.err);
            }
            catch (TargetException targetException) {}
            this.context = new EvaluationContext();
            this.target = new TargetInterface();
            this.target.connect("localhost", evalPort, 30000);
            this.env = new FileSystem(Util.getJavaClassLibs(), new String[0], null);
        }
        super.setUp();
    }

    protected void startReader(String name, final InputStream in, final PrintStream out) {
        new Thread(name){

            public void run() {
                int read = 0;
                while (read != -1) {
                    try {
                        read = in.read();
                    }
                    catch (IOException iOException) {
                        read = -1;
                    }
                    if (read == -1) continue;
                    out.print((char)read);
                }
            }
        }.start();
    }

    protected void tearDown() {
        LocalVirtualMachine vm;
        if (this.context != null && (vm = this.launchedVM) != null) {
            try {
                if (this.target != null) {
                    this.target.disconnect();
                }
                int retry = 0;
                while (vm.isRunning() && ++retry < 20) {
                    try {
                        Thread.sleep(retry * 100);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (vm.isRunning()) {
                    vm.shutDown();
                }
                this.context = null;
            }
            catch (TargetException e) {
                throw new Error(e.getMessage());
            }
        }
        if (this.env != null) {
            this.env.cleanup();
        }
    }
}

