/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval.target;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class IDEInterface {
    static final boolean TIMING = false;
    long startTime;
    int portNumber = 0;
    Socket socket;

    IDEInterface(int portNumber) {
        this.portNumber = portNumber;
    }

    void connect() throws IOException {
        ServerSocket server = new ServerSocket(this.portNumber);
        this.socket = server.accept();
        this.socket.setTcpNoDelay(true);
        server.close();
    }

    void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            this.socket = null;
        }
    }

    protected byte[][] getNextClasses() {
        if (this.socket == null) {
            return new byte[0][];
        }
        try {
            DataInputStream in = new DataInputStream(this.socket.getInputStream());
            int numberOfClasses = in.readInt();
            byte[][] result = new byte[numberOfClasses][];
            int i = 0;
            while (i < numberOfClasses) {
                int lengthOfClassFile = in.readInt();
                byte[] classFile = new byte[lengthOfClassFile];
                int read = 0;
                while (read < lengthOfClassFile && read != -1) {
                    read += in.read(classFile, read, lengthOfClassFile - read);
                }
                result[i] = classFile;
                ++i;
            }
            return result;
        }
        catch (IOException iOException) {
            this.disconnect();
            return new byte[0][];
        }
    }

    protected boolean getRunFlag() {
        if (this.socket == null) {
            return false;
        }
        try {
            DataInputStream in = new DataInputStream(this.socket.getInputStream());
            return in.readBoolean();
        }
        catch (IOException iOException) {
            this.disconnect();
            return false;
        }
    }

    boolean isConnected() {
        return this.socket != null;
    }

    protected void sendResult(Class resultType, Object resultValue) {
        if (this.socket == null) {
            return;
        }
        try {
            DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
            if (resultType == Void.TYPE) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(resultType.isPrimitive() ? resultType.toString() : resultType.getName());
                out.writeUTF(resultValue == null ? "null" : resultValue.toString());
            }
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }
}

