/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.File;
import java.util.Vector;
import org.eclipse.jdt.core.tests.runtime.StandardVMLauncher;

public class DRLVMLauncher
extends StandardVMLauncher {
    public String[] getCommandLine() {
        Object[] result;
        int i;
        Vector<String> commandLine = new Vector<String>();
        String vmLocation = String.valueOf(this.vmPath) + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "javaw";
        String osName = System.getProperty("os.name");
        if (osName.indexOf("win32") == -1 && !new File(vmLocation).exists()) {
            vmLocation = vmLocation.substring(0, vmLocation.length() - 1);
        }
        commandLine.addElement(vmLocation);
        if (this.vmArguments != null) {
            i = 0;
            while (i < this.vmArguments.length) {
                commandLine.addElement(this.vmArguments[i]);
                ++i;
            }
        }
        commandLine.addElement("-Xbootclasspath/a:" + this.buildBootClassPath());
        if (this.debugPort != -1) {
            commandLine.addElement("-Xdebug");
            commandLine.addElement("-Xnoagent");
            commandLine.addElement("-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=n");
        }
        commandLine.addElement("-classpath");
        commandLine.addElement(this.buildClassPath());
        if (this.evalPort != -1) {
            commandLine.addElement("org.eclipse.jdt.core.tests.eval.target.CodeSnippetRunner");
        }
        if (this.evalPort != -1) {
            commandLine.addElement("-evalport");
            commandLine.addElement(Integer.toString(this.evalPort));
            commandLine.addElement("-cscp");
            commandLine.addElement(String.valueOf(this.evalTargetPath) + File.separator + "regularPath");
            commandLine.addElement("-csbp");
            commandLine.addElement(String.valueOf(this.evalTargetPath) + File.separator + "bootPath");
        }
        if (this.programClass != null) {
            commandLine.addElement(this.programClass);
        }
        if (this.programArguments != null) {
            i = 0;
            while (i < this.programArguments.length) {
                commandLine.addElement(this.programArguments[i]);
                ++i;
            }
        }
        if (this.batchFileName != null) {
            this.writeBatchFile(this.batchFileName, commandLine);
            result = new String[]{this.batchFileName};
        } else {
            result = new String[commandLine.size()];
            commandLine.copyInto(result);
        }
        int i2 = 0;
        while (i2 < result.length) {
            Object argument = result[i2];
            if (((String)argument).indexOf(32) != -1) {
                result[i2] = "\"" + (String)argument + "\"";
            }
            ++i2;
        }
        return result;
    }

    protected String buildBootClassPath() {
        StringBuffer bootPathString = new StringBuffer();
        char pathSeparator = File.pathSeparatorChar;
        if (this.bootPath != null) {
            int length = this.bootPath.length;
            int i = 0;
            while (i < length) {
                bootPathString.append(this.bootPath[i]);
                bootPathString.append(pathSeparator);
                ++i;
            }
        }
        if (this.evalTargetPath != null) {
            bootPathString.append(this.evalTargetPath);
            bootPathString.append(File.separatorChar);
            bootPathString.append("bootPath");
        }
        return bootPathString.toString();
    }
}

