/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;
import org.eclipse.jdt.core.tests.performance.NullPrintWriter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.SourceElementRequestorAdapter;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FullSourceWorkspaceBuildTests
extends FullSourceWorkspaceTests {
    private static int TESTS_COUNT = 0;
    private static final int ITERATIONS_COUNT = 10;
    private static final int WARMUP_COUNT = 3;
    private static final int SCAN_REPEAT = 800;
    private static final int TIME_THRESHOLD = 150;
    private static PrintStream[] LOG_STREAMS = new PrintStream[DIM_NAMES.length];
    private static final String ALL_OPTIONS = "-warn:allDeprecation,allJavadoc,assertIdentifier,charConcat,conditionAssign,constructorName,deprecation,emptyBlock,fieldHiding,finally,indirectStatic,intfNonInherited,localHiding,maskedCatchBlock,nls,noEffectAssign,pkgDefaultMethod,semicolon,unqualifiedField,unusedArgument,unusedImport,unusedLocal,unusedPrivate,unusedThrown,unnecessaryElse,uselessTypeCheck,specialParamHiding,staticReceiver,syntheticAccess,tasks(TODO|FIX|XXX)";
    static final String[] JDT_CORE_SRC_PATHS = new String[]{"batch", "codeassist", "compiler", "dom", "eval", "formatter", "model", "search"};
    static /* synthetic */ Class class$0;

    public FullSourceWorkspaceBuildTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = FullSourceWorkspaceBuildTests.buildSuite(FullSourceWorkspaceBuildTests.testClass());
        TESTS_COUNT = suite.countTestCases();
        FullSourceWorkspaceBuildTests.createPrintStream(FullSourceWorkspaceBuildTests.testClass(), LOG_STREAMS, TESTS_COUNT, null);
        return suite;
    }

    private static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceBuildTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    void build(final IJavaProject javaProject, Hashtable options, boolean noWarning) throws IOException, CoreException {
        if (DEBUG) {
            System.out.print("\tstart build...");
        }
        JavaCore.setOptions((Hashtable)options);
        if (PRINT) {
            System.out.println("JavaCore options: " + options);
        }
        if (javaProject == null) {
            this.runGc();
            this.startMeasuring();
            ENV.fullBuild();
            this.stopMeasuring();
        } else {
            if (PRINT) {
                System.out.println("Project options: " + javaProject.getOptions(false));
            }
            int i = 0;
            while (i < 3) {
                ENV.fullBuild(javaProject.getProject().getName());
                ++i;
            }
            int max = MEASURES_COUNT;
            int i2 = 0;
            while (i2 < max) {
                this.runGc();
                this.startMeasuring();
                IWorkspaceRunnable compilation = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        ENV.fullBuild(javaProject.getPath());
                    }
                };
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                workspace.run(compilation, null, 1, null);
                this.stopMeasuring();
                ++i2;
            }
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IMarker[] markers = workspaceRoot.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<Object> messages = new ArrayList<Object>();
        int warnings = 0;
        int i = 0;
        int length = markers.length;
        while (i < length) {
            IMarker marker = markers[i];
            switch ((Integer)marker.getAttribute("severity")) {
                case 2: {
                    resources.add(marker.getResource().getName());
                    messages.add(marker.getAttribute("message"));
                    break;
                }
                case 1: {
                    ++warnings;
                    if (!noWarning) break;
                    resources.add(marker.getResource().getName());
                    messages.add(marker.getAttribute("message"));
                }
            }
            ++i;
        }
        workspaceRoot.deleteMarkers("org.eclipse.jdt.core.problem", true, 2);
        int size = messages.size();
        if (size > 0) {
            StringBuffer debugBuffer = new StringBuffer();
            int i3 = 0;
            while (i3 < size) {
                debugBuffer.append(resources.get(i3));
                debugBuffer.append(":\n\t");
                debugBuffer.append(messages.get(i3));
                debugBuffer.append('\n');
                ++i3;
            }
            System.out.println(String.valueOf(this.scenarioShortName) + ": Unexpected ERROR marker(s):\n" + debugBuffer.toString());
            System.out.println("--------------------");
            String target = javaProject == null ? "workspace" : javaProject.getElementName();
            FullSourceWorkspaceBuildTests.assertEquals((String)("Found " + size + " unexpected errors while building " + target), (int)0, (int)size);
        }
        if (DEBUG) {
            System.out.println("done");
        }
        this.commitMeasurements();
        this.assertPerformance();
        if (warnings > 0) {
            System.out.println("\t- " + warnings + " warnings found while performing build.");
        }
        if (this.scenarioComment == null) {
            this.scenarioComment = new StringBuffer("[" + TEST_POSITION + "]");
        } else {
            this.scenarioComment.append(' ');
        }
        this.scenarioComment.append("warn=");
        this.scenarioComment.append(warnings);
    }

    void compile(String pluginID, String options, boolean log, String[] srcPaths) throws IOException, CoreException {
        this.compile(pluginID, options, null, log, srcPaths);
    }

    void compile(String pluginID, String options, String compliance, boolean log, String[] srcPaths) throws IOException, CoreException {
        String sources;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        String targetWorkspacePath = workspaceRoot.getProject(pluginID).getLocation().toFile().getCanonicalPath();
        String logFileName = String.valueOf(targetWorkspacePath) + File.separator + this.getName() + ".log";
        String workspacePath = String.valueOf(workspaceRoot.getLocation().toFile().getCanonicalPath()) + File.separator;
        String binPath = String.valueOf(File.separator) + "bin" + File.pathSeparator;
        String classpath = " -cp " + workspacePath + "org.eclipse.osgi" + binPath + workspacePath + "org.eclipse.jface" + binPath + workspacePath + "org.eclipse.core.runtime" + binPath + workspacePath + "org.eclipse.core.resources" + binPath + workspacePath + "org.eclipse.text" + binPath;
        String string = sources = srcPaths == null ? " " + targetWorkspacePath : "";
        if (srcPaths != null) {
            int i = 0;
            int l = srcPaths.length;
            while (i < l) {
                String path = String.valueOf(workspacePath) + pluginID + File.separator + srcPaths[i];
                if (path.indexOf(" ") > 0) {
                    path = "\"" + path + "\"";
                }
                sources = String.valueOf(sources) + " " + path;
                ++i;
            }
        }
        this.compile(sources, options, classpath, null, log, logFileName);
    }

    void compile(String[] srcPaths, String options, String compliance, boolean log) throws IOException {
        String targetWorkspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getCanonicalPath();
        String logFileName = String.valueOf(targetWorkspacePath) + File.separator + this.getName() + ".log";
        String pluginDir = FullSourceWorkspaceBuildTests.getPluginBinariesDirectoryPath();
        String sources = "";
        int i = 0;
        int l = srcPaths.length;
        while (i < l) {
            String path = String.valueOf(pluginDir) + File.separator + srcPaths[i];
            if (path.indexOf(" ") > 0) {
                path = "\"" + path + "\"";
            }
            sources = String.valueOf(sources) + " " + path;
            ++i;
        }
        this.compile(sources, options, "", compliance, log, logFileName);
    }

    private void compile(String sources, String options, String classpath, String compliance, boolean log, String logFileName) {
        compliance = compliance == null ? " -" + (COMPLIANCE == null ? "1.4" : COMPLIANCE) : " -" + compliance;
        String cmdLine = String.valueOf(classpath) + compliance + " -g -preserveAllLocals " + (options == null ? "" : options) + " -d " + COMPILER_OUTPUT_DIR + (log ? " -log " + logFileName : "") + sources;
        if (PRINT) {
            System.out.println("\tCompiler command line = " + cmdLine);
        }
        int warnings = 0;
        StringWriter errStrWriter = new StringWriter();
        PrintWriter err = new PrintWriter(errStrWriter);
        PrintWriter out = new PrintWriter(new StringWriter());
        Main warmup = new Main(out, err, false, null, null);
        int i = 1;
        while (i < 3) {
            warmup.compile(Main.tokenize((String)cmdLine));
            ++i;
        }
        if (warmup.globalErrorsCount > 0) {
            System.out.println(String.valueOf(this.scenarioShortName) + ": " + warmup.globalErrorsCount + " Unexpected compile ERROR!");
            if (DEBUG) {
                System.out.println(errStrWriter.toString());
                System.out.println("--------------------");
            }
        }
        if (!"none".equals(COMPILER_OUTPUT_DIR)) {
            org.eclipse.jdt.core.tests.util.Util.delete((String)COMPILER_OUTPUT_DIR);
        }
        warnings = warmup.globalWarningsCount;
        if (!log) {
            org.eclipse.jdt.core.tests.util.Util.writeToFile((String)errStrWriter.toString(), (String)logFileName);
        }
        err = null;
        out = null;
        errStrWriter = null;
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            NullPrintWriter nullPrint = new NullPrintWriter();
            Main main = new Main((PrintWriter)nullPrint, (PrintWriter)nullPrint, false, null, null);
            this.startMeasuring();
            main.compile(Main.tokenize((String)cmdLine));
            this.stopMeasuring();
            if (!"none".equals(COMPILER_OUTPUT_DIR)) {
                org.eclipse.jdt.core.tests.util.Util.delete((String)COMPILER_OUTPUT_DIR);
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
        if (warnings > 0) {
            System.out.println("\t- " + warnings + " warnings found while performing batch compilation.");
        }
        if (this.scenarioComment == null) {
            this.scenarioComment = new StringBuffer("[" + TEST_POSITION + "]");
        } else {
            this.scenarioComment.append(' ');
        }
        this.scenarioComment.append("warn=");
        this.scenarioComment.append(warnings);
    }

    long[] parseFile(String fileName, int kind, int iterations) throws InvalidInputException, IOException {
        File file = new File(fileName);
        char[] content = Util.getFileCharContent((File)file, null);
        CompilerOptions options = new CompilerOptions();
        options.sourceLevel = 0x300000L;
        options.targetJDK = 0x300000L;
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), options, (IProblemFactory)new DefaultProblemFactory());
        Parser parser = null;
        switch (kind) {
            case 1: {
                parser = new SourceElementParser((ISourceElementRequestor)new SourceElementRequestorAdapter(), problemReporter.problemFactory, options, true, true);
                break;
            }
            default: {
                parser = new Parser(problemReporter, true);
            }
        }
        int i = 0;
        while (i < 2) {
            CompilationUnit unit = new CompilationUnit(content, file.getName(), null);
            CompilationResult unitResult = new CompilationResult((ICompilationUnit)unit, 0, 1, options.maxProblemsPerUnit);
            CompilationUnitDeclaration unitDeclaration = parser.dietParse((ICompilationUnit)unit, unitResult);
            parser.getMethodBodies(unitDeclaration);
            ++i;
        }
        this.runGc();
        long parsedLines = 0L;
        long parsedCharacters = 0L;
        long start = 0L;
        if (DEBUG) {
            start = System.currentTimeMillis();
        }
        this.startMeasuring();
        int i2 = 0;
        while (i2 < iterations) {
            CompilationUnit unit = new CompilationUnit(content, file.getName(), null);
            CompilationResult unitResult = new CompilationResult((ICompilationUnit)unit, 0, 1, options.maxProblemsPerUnit);
            CompilationUnitDeclaration unitDeclaration = parser.dietParse((ICompilationUnit)unit, unitResult);
            parser.getMethodBodies(unitDeclaration);
            parsedCharacters += (long)content.length;
            parsedLines += (long)unitResult.getLineSeparatorPositions().length;
            ++i2;
        }
        this.stopMeasuring();
        if (DEBUG) {
            long time = System.currentTimeMillis() - start;
            if (time < 150L) {
                System.err.println(String.valueOf(parsedLines) + " lines/" + parsedCharacters + " characters parsed");
            } else {
                System.out.println(String.valueOf(parsedLines) + " lines/" + parsedCharacters + " characters parsed");
            }
        }
        return new long[]{parsedCharacters, parsedLines};
    }

    void parseParserFile(final int kind) throws InvalidInputException, IOException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        final String workspacePath = workspaceRoot.getLocation().toFile().getCanonicalPath();
        int i = 0;
        while (i < MEASURES_COUNT) {
            IWorkspaceRunnable compilation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        FullSourceWorkspaceBuildTests.this.parseFile(String.valueOf(workspacePath) + PARSER_WORKING_COPY.getPath(), kind, 60);
                    }
                    catch (InvalidInputException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            if (workspace.isTreeLocked()) {
                compilation.run(null);
            } else {
                workspace.run(compilation, null, 1, null);
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    /*
     * Unable to fully structure code
     */
    void scanFile(String fileName, int kind) throws InvalidInputException, IOException {
        tokenCount = 0L;
        content = Util.getFileCharContent((File)new File(fileName), null);
        scanner = new Scanner();
        scanner.setSource(content);
        i = 0;
        while (i < 2) {
            scanner.resetTo(0, content.length);
            block27: while (true) {
                token = scanner.getNextToken();
                switch (kind) {
                    case 0: {
                        switch (token) {
                            case 60: {
                                break block27;
                            }
                        }
                        continue block27;
                    }
                    case 1: {
                        switch (token) {
                            case 60: {
                                break block27;
                            }
                            case 22: {
                                scanner.getCurrentIdentifierSource();
                            }
                        }
                    }
                    default: {
                        continue block27;
                    }
                }
                break;
            }
            ++i;
        }
        size = 0L;
        i = 0;
        while (i < FullSourceWorkspaceBuildTests.MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            j = 0;
            while (j < 800) {
                scanner.resetTo(0, content.length);
                block30: while (true) {
                    token = scanner.getNextToken();
                    switch (kind) {
                        case 0: {
                            switch (token) {
                                case 60: {
                                    break block30;
                                }
                            }
                            ** GOTO lbl50
                        }
                        case 1: {
                            switch (token) {
                                case 60: {
                                    break block30;
                                }
                                case 22: {
                                    c = scanner.getCurrentIdentifierSource();
                                    size += (long)c.length;
                                }
                            }
                        }
lbl50:
                        // 4 sources

                        default: {
                            ++tokenCount;
                            continue block30;
                        }
                    }
                    break;
                }
                ++j;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
        if (FullSourceWorkspaceBuildTests.DEBUG) {
            switch (kind) {
                case 0: {
                    System.out.println(String.valueOf(tokenCount) + " tokens read.");
                    break;
                }
                case 1: {
                    System.out.print(String.valueOf(tokenCount) + " tokens were read (" + size + " characters)");
                }
            }
        }
    }

    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        super.tearDown();
    }

    public void testScanner() throws InvalidInputException, IOException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        final String workspacePath = workspaceRoot.getLocation().toFile().getCanonicalPath();
        IWorkspaceRunnable compilation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    FullSourceWorkspaceBuildTests.this.scanFile(String.valueOf(workspacePath) + PARSER_WORKING_COPY.getPath(), 1);
                }
                catch (InvalidInputException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        if (workspace.isTreeLocked()) {
            compilation.run(null);
        } else {
            workspace.run(compilation, null, 1, null);
        }
    }

    public void testParser() throws InvalidInputException, IOException, CoreException {
        this.parseParserFile(0);
    }

    public void _testSourceParser() throws InvalidInputException, IOException, CoreException {
        this.parseParserFile(1);
    }

    public void testFullBuildDefault() throws CoreException, IOException {
        this.tagAsSummary("Build entire workspace", false);
        this.build(null, this.warningOptions(0), false);
    }

    public void testFullBuildProjectNoWarning() throws CoreException, IOException {
        this.tagAsSummary("Build JDT/Core project (no warning)", false);
        this.build(JDT_CORE_PROJECT, this.warningOptions(-1), true);
    }

    public void testFullBuildProjectDefault() throws CoreException, IOException {
        this.tagAsGlobalSummary("Build JDT/Core project", true);
        this.build(JDT_CORE_PROJECT, this.warningOptions(0), false);
    }

    public void testFullBuildProjectAllWarnings() throws CoreException, IOException {
        this.tagAsSummary("Build JDT/Core project (all warnings)", false);
        this.build(JDT_CORE_PROJECT, this.warningOptions(1), false);
    }

    public void testBatchCompilerNoWarning() throws IOException, CoreException {
        this.tagAsSummary("Compile folders using cmd line (no warn)", false);
        this.compile("org.eclipse.jdt.core", "-nowarn", null, true, null);
    }

    public void testCompileJDTCoreProjectNoWarning() throws IOException, CoreException {
        this.tagAsSummary("Compile JDT/Core with cmd line (no warn)", false);
        this.compile("org.eclipse.jdt.core", "-nowarn", null, false, JDT_CORE_SRC_PATHS);
    }

    public void testCompileJDTCoreProjectDefault() throws IOException, CoreException {
        this.tagAsSummary("Compile JDT/Core with command line", true);
        this.compile("org.eclipse.jdt.core", "", null, false, JDT_CORE_SRC_PATHS);
    }

    public void testCompileJDTCoreProjectJavadoc() throws IOException, CoreException {
        this.tagAsSummary("Compile JDT/Core with cmd line (javadoc)", false);
        this.compile("org.eclipse.jdt.core", "-warn:javadoc", null, false, JDT_CORE_SRC_PATHS);
    }

    public void testCompileJDTCoreProjectAllWarnings() throws IOException, CoreException {
        this.tagAsSummary("Compile JDT/Core with cmd line (all)", false);
        this.compile("org.eclipse.jdt.core", ALL_OPTIONS, null, false, JDT_CORE_SRC_PATHS);
    }

    public void testCompileSWTProjectDefault() throws IOException, CoreException {
        this.tagAsSummary("Compile SWT with command line", false);
        String[] sourcePaths = new String[]{"Eclipse SWT/win32", "Eclipse SWT/common", "Eclipse SWT/common_j2se", "Eclipse SWT PI/win32", "Eclipse SWT PI/common_j2se", "Eclipse SWT OLE Win32/win32", "Eclipse SWT Accessibility/win32", "Eclipse SWT Accessibility/common", "Eclipse SWT AWT/win32", "Eclipse SWT AWT/common", "Eclipse SWT Drag and Drop/win32", "Eclipse SWT Drag and Drop/common", "Eclipse SWT Printing/win32", "Eclipse SWT Printing/common", "Eclipse SWT Program/win32", "Eclipse SWT Program/common", "Eclipse SWT Custom Widgets/common", "Eclipse SWT Browser/common", "Eclipse SWT Browser/win32"};
        this.compile("org.eclipse.swt", "", null, false, sourcePaths);
    }

    public void testBuildGenericType() throws IOException, CoreException {
        this.tagAsSummary("Build Generic Type ", false);
        this.compile(new String[]{"EclipseVisitorBug.java"}, "", "1.6", false);
    }
}

