/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.TestingEnvironment;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.performance.util.JdtCorePerformanceMeter;
import org.eclipse.jdt.core.tests.performance.util.Statistics;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaCorePreferenceInitializer;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;

public abstract class FullSourceWorkspaceTests
extends TestCase {
    static final boolean DEBUG = "true".equals(System.getProperty("debug"));
    static final boolean PRINT = "true".equals(System.getProperty("print"));
    static final boolean TOUCH = "true".equals(System.getProperty("touch"));
    static final Hashtable INITIAL_OPTIONS = JavaCore.getOptions();
    static final String COMPLIANCE = System.getProperty("compliance");
    static final int MAX_GC = 10;
    static final int TIME_GC = 500;
    static final int DELTA_GC = 1000;
    protected static TestingEnvironment ENV;
    protected static IJavaProject[] ALL_PROJECTS;
    protected static IJavaProject JDT_CORE_PROJECT;
    protected static ICompilationUnit PARSER_WORKING_COPY;
    protected static final String BIG_PROJECT_NAME = "BigProject";
    protected static JavaProject BIG_PROJECT;
    protected static final String BIG_JAR1_NAME = "big1.jar";
    protected static final String BIG_JAR2_NAME = "big2.jar";
    public static final String COMPILER_OUTPUT_DIR;
    protected static IndexManager INDEX_MANAGER;
    protected static int ALL_TESTS_COUNT;
    protected static int TEST_POSITION;
    protected static List TESTS_NAME_LIST;
    protected static final int MEASURES_COUNT;
    String scenarioReadableName;
    String scenarioShortName;
    StringBuffer scenarioComment;
    static Map SCENARII_COMMENT;
    int nbMeasures;
    long startMeasuring;
    long testDuration;
    protected static final double ERROR_THRESHOLD = 0.005;
    protected static final String ERROR_STRING;
    private static final File INVALID_DIR;
    protected static File LOG_DIR;
    protected static final String[] DIM_NAMES;
    protected static final String LOG_VERSION;
    protected static final String PATCH_ID;
    protected static String RUN_ID;
    private NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private final NumberFormat d2Format = NumberFormat.getNumberInstance();

    static {
        Hashtable options = INITIAL_OPTIONS;
        String compliance = FullSourceWorkspaceTests.compliance();
        if (compliance == null) {
            System.out.println("Used default compliance: " + options.get("org.eclipse.jdt.core.compiler.compliance"));
        } else {
            System.out.println("Used compliance: " + compliance);
            options.put("org.eclipse.jdt.core.compiler.compliance", compliance);
            options.put("org.eclipse.jdt.core.compiler.source", compliance);
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compliance);
            JavaCore.setOptions((Hashtable)options);
        }
        ENV = null;
        String outputDir = null;
        String container = System.getProperty("user.home");
        if (container == null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            File pluginDir = workspaceRoot.getProject("org.eclipse.jdt.core").getLocation().toFile();
            try {
                outputDir = String.valueOf(pluginDir.getCanonicalPath()) + File.separator + "bin";
            }
            catch (IOException iOException) {}
        } else {
            outputDir = String.valueOf(Util.toNativePath((String)container)) + File.separator + "bin";
        }
        COMPILER_OUTPUT_DIR = outputDir == null ? "none" : "\"" + outputDir + "\"";
        INDEX_MANAGER = JavaModelManager.getIndexManager();
        ALL_TESTS_COUNT = 0;
        TEST_POSITION = 0;
        String measures = System.getProperty("measures", "10");
        int count = 10;
        try {
            count = Integer.parseInt(measures);
            if (count < 0 || count > 20) {
                System.out.println("INFO: Measures parameter (" + count + ") is ignored as it is an invalid value! (should be between 0 and 20)");
                count = 10;
            } else if (count != 10) {
                System.out.println("WARNING: Measures count has been changed while running this test = " + count + " instead of 10 normally!");
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("INFO: Specified 'measures' VM argument (=" + measures + ") is ignored as it is not an integer (0-20)!");
        }
        MEASURES_COUNT = count;
        SCENARII_COMMENT = new HashMap();
        NumberFormat valueFormat = NumberFormat.getNumberInstance();
        valueFormat.setMaximumFractionDigits(1);
        ERROR_STRING = valueFormat.format(0.5);
        INVALID_DIR = new File("Invalid");
        DIM_NAMES = new String[]{"cpu", "elapsed", "heap"};
        String version = new Main(null, null, false, null, null).bind("compiler.version");
        version = version.substring(0, version.indexOf(44));
        if (version.startsWith("0.")) {
            version = "v_" + version.substring(2);
        }
        LOG_VERSION = version;
        PATCH_ID = System.getProperty("patch");
    }

    protected static String compliance() {
        String compliance = null;
        if ("1.3".equals(COMPLIANCE)) {
            compliance = "1.3";
        } else if ("1.4".equals(COMPLIANCE)) {
            compliance = "1.4";
        } else if ("1.5".equals(COMPLIANCE) || "5.0".equals(COMPLIANCE)) {
            compliance = "1.5";
        } else if ("1.6".equals(COMPLIANCE) || "6.0".equals(COMPLIANCE)) {
            compliance = "1.6";
        }
        return compliance;
    }

    protected static void initLogDir() {
        String logDir = System.getProperty("logDir");
        File dir = null;
        if (logDir != null) {
            String[] stringArray;
            dir = new File(logDir);
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    System.err.println(String.valueOf(logDir) + " is not a valid directory, log files will NOT be written!");
                    dir = INVALID_DIR;
                }
            } else {
                int n = 0;
                boolean created = false;
                while (!created && n < 3) {
                    created = dir.mkdir();
                    if (!created) {
                        dir = dir.getParentFile();
                    }
                    ++n;
                }
                if (!created) {
                    System.err.println("Cannot create " + logDir + ", log files will NOT be written!");
                    dir = INVALID_DIR;
                }
            }
            if (PATCH_ID == null) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = LOG_VERSION;
                stringArray = stringArray2;
                stringArray2[1] = RUN_ID;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = LOG_VERSION;
                stringArray3[1] = PATCH_ID;
                stringArray = stringArray3;
                stringArray3[2] = RUN_ID;
            }
            String[] subdirs = stringArray;
            int i = 0;
            while (i < subdirs.length) {
                if ((dir = new File(dir, subdirs[i])).exists()) {
                    if (!dir.isDirectory()) {
                        System.err.println(String.valueOf(dir.getPath()) + " is not a valid directory, log files will NOT be written!");
                        dir = INVALID_DIR;
                        break;
                    }
                } else if (!dir.mkdirs()) {
                    System.err.println("Cannot create " + dir.getPath() + ", log files will NOT be written!");
                    dir = INVALID_DIR;
                    break;
                }
                ++i;
            }
        }
        LOG_DIR = dir;
    }

    public FullSourceWorkspaceTests(String name) {
        super(name);
        this.percentFormat.setMaximumFractionDigits(1);
        this.d2Format.setMaximumFractionDigits(2);
    }

    static Test buildSuite(Class testClass) {
        String className = testClass.getName();
        TestSuite suite = new TestSuite(className);
        List tests = FullSourceWorkspaceTests.buildTestsList((Class)testClass);
        int size = tests.size();
        TESTS_NAME_LIST = new ArrayList(size);
        int i = 0;
        while (i < size) {
            FullSourceWorkspaceTests test = (FullSourceWorkspaceTests)((Object)tests.get(i));
            suite.addTest((Test)test);
            TESTS_NAME_LIST.add(test.getName());
            ++i;
        }
        ALL_TESTS_COUNT += suite.testCount();
        if (LOG_DIR == null) {
            if (RUN_ID == null) {
                RUN_ID = FullSourceWorkspaceTests.suiteTypeShortName(testClass);
            }
            FullSourceWorkspaceTests.initLogDir();
        }
        return suite;
    }

    static void createPrintStream(Class testClass, PrintStream[] logStreams, int count, String prefix) {
        if (LOG_DIR != null) {
            int i = 0;
            int ln = DIM_NAMES.length;
            while (i < ln) {
                String suiteTypeName = FullSourceWorkspaceTests.suiteTypeShortName(testClass);
                File logFile = new File(LOG_DIR, String.valueOf(suiteTypeName) + '_' + DIM_NAMES[i] + ".log");
                if (TOUCH) {
                    System.out.println("Log file " + logFile.getPath() + " would be opened.");
                    return;
                }
                try {
                    boolean fileExist = logFile.exists();
                    if (logStreams[i] != null) {
                        logStreams[i].close();
                    }
                    logStreams[i] = new PrintStream(new FileOutputStream(logFile, true));
                    if (logStreams[i] != null) {
                        if (!fileExist) {
                            logStreams[i].print("Date  \tTime  \t");
                            int j = 0;
                            while (j < count) {
                                String testName = ((String)TESTS_NAME_LIST.get(j)).substring(4 + (prefix == null ? 0 : prefix.length()));
                                logStreams[i].print(String.valueOf(testName) + '\t');
                                ++j;
                            }
                            logStreams[i].println("Comment");
                        }
                        Date date = new Date(System.currentTimeMillis());
                        logStreams[i].print(String.valueOf(DateFormat.getDateInstance(3).format(date)) + '\t');
                        logStreams[i].print(String.valueOf(DateFormat.getTimeInstance(3).format(date)) + '\t');
                        System.out.println("Log file " + logFile.getPath() + " opened.");
                    } else {
                        System.err.println("Cannot open " + logFile.getPath() + "!!!");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("Cannot find file " + logFile.getPath() + "!!!");
                }
                ++i;
            }
        }
    }

    static String getPluginBinariesDirectoryPath() {
        try {
            URL platformURL = Platform.getBundle((String)"org.eclipse.jdt.core.tests.binaries").getEntry("/");
            return new File(FileLocator.toFileURL((URL)platformURL).getFile()).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String suiteTypeShortName(Class testClass) {
        String className = testClass.getName();
        int startIndex = className.indexOf("FullSourceWorkspace");
        int endIndex = className.lastIndexOf("Test");
        if (startIndex < 0) {
            return null;
        }
        return className.substring(startIndex += "FullSourceWorkspace".length(), endIndex);
    }

    protected void logPerfResult(PrintStream[] logStreams, int count) {
        StringBuffer[] scenarioComments;
        boolean haveStats;
        if (TOUCH) {
            return;
        }
        int length = DIM_NAMES.length;
        String[] comments = new String[length];
        boolean bl = haveStats = JdtCorePerformanceMeter.STATISTICS != null;
        if (haveStats) {
            DataPoint[] dataPoints = (DataPoint[])JdtCorePerformanceMeter.STATISTICS.get(this.scenarioReadableName);
            if (dataPoints != null) {
                Statistics statistics = new Statistics(dataPoints);
                int idx = 0;
                while (idx < length) {
                    this.storeDimension(logStreams, comments, statistics, idx);
                    ++idx;
                }
            } else {
                try {
                    haveStats = false;
                    Thread.sleep(1000L);
                    System.err.println(String.valueOf(this.scenarioShortName) + ": we should have stored statistics!");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if ((scenarioComments = (StringBuffer[])SCENARII_COMMENT.get(((Object)((Object)this)).getClass())) == null) {
            scenarioComments = new StringBuffer[length];
            SCENARII_COMMENT.put(((Object)((Object)this)).getClass(), scenarioComments);
        }
        int i = 0;
        while (i < length) {
            if (this.scenarioComment != null || comments[i] != null) {
                if (scenarioComments[i] == null) {
                    scenarioComments[i] = new StringBuffer();
                } else {
                    scenarioComments[i].append(' ');
                }
                if (this.scenarioComment == null) {
                    scenarioComments[i].append("[" + TEST_POSITION + "]");
                } else {
                    scenarioComments[i].append(this.scenarioComment);
                }
                if (comments[i] != null) {
                    if (this.scenarioComment != null) {
                        scenarioComments[i].append(',');
                    }
                    scenarioComments[i].append(comments[i]);
                }
            }
            ++i;
        }
        if (count == 0) {
            i = 0;
            int ln = logStreams.length;
            while (i < ln) {
                if (logStreams[i] != null) {
                    if (haveStats) {
                        if (scenarioComments[i] != null) {
                            logStreams[i].print(scenarioComments[i].toString());
                        }
                        logStreams[i].println();
                    }
                    logStreams[i].close();
                }
                ++i;
            }
            TEST_POSITION = 0;
        }
    }

    private void storeDimension(PrintStream[] logStreams, String[] comments, Statistics statistics, int index) {
        System.out.println("\t- " + statistics.toString(index));
        double stddev = statistics.getStddev(index);
        double average = statistics.getAverage(index);
        long count = statistics.getCount(index);
        double error = stddev / Math.sqrt(count);
        if (error / average > 0.005) {
            System.out.println("\tWARNING: " + DIM_NAMES[index] + " error is over " + ERROR_STRING + "%: " + this.d2Format.format(stddev) + "/sqrt(" + count + ")=" + this.percentFormat.format(error / average));
            comments[index] = "err=" + this.percentFormat.format(error / average);
        }
        if (logStreams[index] != null) {
            logStreams[index].print(statistics.getSum(index) + "\t");
        }
    }

    protected void runGc() {
        int iterations = 0;
        long delta = 0L;
        long free = 0L;
        int i = 0;
        while (i < 10) {
            free = Runtime.getRuntime().freeMemory();
            System.gc();
            delta = Runtime.getRuntime().freeMemory() - free;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (iterations == 10 && delta > 1000L) {
            System.out.println("WARNING: " + this.scenarioShortName + " still get " + delta + " unfreeable memory (free=" + free + ",total=" + Runtime.getRuntime().totalMemory() + ") after " + 10 + " gc...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        String scenario = Performance.getDefault().getDefaultScenarioId((junit.framework.TestCase)this);
        this.scenarioReadableName = scenario.substring(scenario.lastIndexOf(46) + 1, scenario.length() - 2);
        this.scenarioShortName = this.scenarioReadableName.substring(this.scenarioReadableName.lastIndexOf(35) + 5, this.scenarioReadableName.length());
        this.scenarioComment = null;
        if (ENV == null) {
            ENV = new TestingEnvironment();
            ENV.openEmptyWorkspace();
            this.setUpFullSourceWorkspace();
        }
        FullSourceWorkspaceTests.assertNotNull((String)"We should have found org.eclipse.jdt.core project in workspace!!!", (Object)JDT_CORE_PROJECT);
        ++TEST_POSITION;
        if (TOUCH) {
            String testPrintName = "'" + this.scenarioShortName + "' test";
            System.out.println("Touch " + testPrintName + " to verify that it will run correctly.");
            throw new Error(String.valueOf(testPrintName) + " execution has been aborted!");
        }
        System.out.println("================================================================================");
        System.out.println("Running " + this.scenarioReadableName + "...");
        this.testDuration = 0L;
        this.nbMeasures = 0;
        Thread.sleep(2000L);
    }

    private void setUpFullSourceWorkspace() throws IOException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        String targetWorkspacePath = workspaceRoot.getLocation().toFile().getCanonicalPath();
        IEclipsePreferences resourcesPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        resourcesPreferences.put("refresh.enabled", "false");
        workspace.getDescription().setSnapshotInterval(Long.MAX_VALUE);
        workspace.getDescription().setAutoBuilding(false);
        File wkspDir = new File(targetWorkspacePath);
        FullSourceProjectsFilter filter = new FullSourceProjectsFilter();
        File[] directories = wkspDir.listFiles(filter);
        long start = System.currentTimeMillis();
        int dirLength = directories.length;
        if (dirLength < 62) {
            String fullSourceZipPath = String.valueOf(FullSourceWorkspaceTests.getPluginBinariesDirectoryPath()) + File.separator + "full-source-R3_0.zip";
            System.out.println("Unzipping " + fullSourceZipPath);
            System.out.print("\tin " + targetWorkspacePath + "...");
            Util.unzip((String)fullSourceZipPath, (String)targetWorkspacePath);
            System.out.println(" done in " + (System.currentTimeMillis() - start) + "ms.");
            directories = wkspDir.listFiles(filter);
            dirLength = directories.length;
        }
        System.out.print("Create and open projects in environment...");
        start = System.currentTimeMillis();
        int i = 0;
        while (i < dirLength) {
            String dirName = directories[i].getName();
            IProject project = workspaceRoot.getProject(dirName);
            if (project.exists()) {
                ENV.addProject(project);
            } else {
                ENV.addProject(dirName);
            }
            ++i;
        }
        System.out.println("(" + (System.currentTimeMillis() - start) + "ms)");
        String jreLibPath = JavaCore.getClasspathVariable((String)"JRE_LIB").toOSString();
        System.out.print("Create lib entries for the JDKs...");
        start = System.currentTimeMillis();
        String[] jdkLibs = Util.getJavaClassLibs();
        int jdkLibsLength = jdkLibs.length;
        IClasspathEntry[] jdkEntries = new IClasspathEntry[jdkLibsLength];
        int jdkEntriesCount = 0;
        int i2 = 0;
        while (i2 < jdkLibsLength) {
            if (!jdkLibs[i2].equals(jreLibPath)) {
                jdkEntries[jdkEntriesCount++] = JavaCore.newLibraryEntry((IPath)new Path(jdkLibs[i2]), null, null);
            }
            ++i2;
        }
        System.out.println(String.valueOf(jdkLibsLength) + " found (" + (System.currentTimeMillis() - start) + "ms)");
        System.out.print("Set projects classpaths...");
        start = System.currentTimeMillis();
        ALL_PROJECTS = JavaCore.create((IWorkspaceRoot)workspaceRoot).getJavaProjects();
        int projectsLength = ALL_PROJECTS.length;
        int i3 = 0;
        while (i3 < projectsLength) {
            block11: {
                String projectName = ALL_PROJECTS[i3].getElementName();
                if (!BIG_PROJECT_NAME.equals(projectName)) {
                    if ("org.eclipse.jdt.core".equals(projectName)) {
                        JDT_CORE_PROJECT = ALL_PROJECTS[i3];
                    }
                    IClasspathEntry[] entries = ALL_PROJECTS[i3].getRawClasspath();
                    int entriesLength = entries.length;
                    try {
                        IClasspathEntry[] iClasspathEntryArray = entries;
                        entries = new IClasspathEntry[jdkEntriesCount + entriesLength];
                        System.arraycopy(iClasspathEntryArray, 0, entries, 0, entriesLength);
                        System.arraycopy(jdkEntries, 0, entries, entriesLength, jdkEntriesCount);
                        ALL_PROJECTS[i3].setRawClasspath(entries, null);
                    }
                    catch (JavaModelException jme) {
                        if (jme.getStatus().getCode() == 977) break block11;
                        throw jme;
                    }
                }
            }
            ++i3;
        }
        System.out.println("(" + (System.currentTimeMillis() - start) + "ms)");
        IType element = JDT_CORE_PROJECT.findType("org.eclipse.jdt.internal.compiler.parser.Parser");
        FullSourceWorkspaceTests.assertTrue((String)"Parser should exist in org.eclipse.jdt.core project!", (element != null && element.exists() ? 1 : 0) != 0);
        PARSER_WORKING_COPY = (ICompilationUnit)element.getParent();
    }

    public void tagAsGlobalSummary(String shortName, Dimension dimension) {
        this.tagAsGlobalSummary(shortName, dimension, false);
    }

    protected void tagAsGlobalSummary(String shortName, boolean fingerprint) {
        this.tagAsGlobalSummary(shortName, Dimension.ELAPSED_PROCESS, fingerprint);
    }

    protected void tagAsGlobalSummary(String shortName, Dimension dimension, boolean fingerprint) {
        if (DEBUG) {
            System.out.println(shortName);
        }
        if (fingerprint) {
            super.tagAsGlobalSummary(shortName, dimension);
        }
    }

    public void tagAsGlobalSummary(String shortName, Dimension[] dimensions) {
        System.out.println("ERROR: tagAsGlobalSummary(String, Dimension[]) is not implemented!!!");
    }

    public void tagAsSummary(String shortName, Dimension dimension) {
        this.tagAsSummary(shortName, dimension, false);
    }

    protected void tagAsSummary(String shortName, boolean fingerprint) {
        this.tagAsSummary(shortName, Dimension.ELAPSED_PROCESS, fingerprint);
    }

    public void tagAsSummary(String shortName, Dimension dimension, boolean fingerprint) {
        if (DEBUG) {
            System.out.println(shortName);
        }
        if (fingerprint) {
            super.tagAsSummary(shortName, dimension);
        }
    }

    public void tagAsSummary(String shortName, Dimension[] dimensions) {
        System.out.println("ERROR: tagAsGlobalSummary(String, Dimension[]) is not implemented!!!");
    }

    public void tagAsSummary(String shortName, Dimension[] dimensions, boolean fingerprint) {
        if (DEBUG) {
            System.out.println(shortName);
        }
        if (fingerprint) {
            super.tagAsSummary(shortName, dimensions);
        }
    }

    public void startMeasuring() {
        if (PRINT && this.nbMeasures == 0) {
            System.out.println("\tMeasures (~Elapsed Process time):");
        }
        this.startMeasuring = System.currentTimeMillis();
        super.startMeasuring();
    }

    public void stopMeasuring() {
        super.stopMeasuring();
        ++this.nbMeasures;
        long duration = System.currentTimeMillis() - this.startMeasuring;
        if (PRINT) {
            System.out.println("\t\t- n\ufffd " + this.nbMeasures + ": " + duration + "ms");
        }
        this.testDuration += duration;
    }

    public void commitMeasurements() {
        if (PRINT) {
            System.out.println("\tTest duration = " + this.testDuration + "ms");
            System.out.println("\tTime average = " + this.testDuration * 1000L / (long)this.nbMeasures / 1000L);
        }
        super.commitMeasurements();
    }

    protected void tearDown() throws Exception {
        if (--ALL_TESTS_COUNT == 0) {
            JavaCore.setOptions((Hashtable)INITIAL_OPTIONS);
        }
        super.tearDown();
    }

    Map clearOptions(Map options) {
        Iterator iter = options.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)options.get(key);
            if ("error".equals(value) || "warning".equals(value)) {
                options.put(key, "ignore");
                continue;
            }
            if (!"enabled".equals(value)) continue;
            options.put(key, "disabled");
        }
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        return options;
    }

    protected IJavaProject createJavaProject(final String projectName, final String[] sourceFolders, final String projectOutput, final String compliance) throws CoreException {
        final IJavaProject[] result = new IJavaProject[1];
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFolder output;
                IProject project = ENV.getProject(projectName);
                IPath projectPath = project.getFullPath();
                int sourceLength = sourceFolders == null ? 0 : sourceFolders.length;
                IClasspathEntry[] entries = new IClasspathEntry[sourceLength + 1];
                int i = 0;
                while (i < sourceLength) {
                    Path sourcePath = new Path(sourceFolders[i]);
                    int segmentCount = sourcePath.segmentCount();
                    if (segmentCount > 0) {
                        IProject container = project;
                        int j = 0;
                        while (j < segmentCount) {
                            IFolder folder = container.getFolder((IPath)new Path(sourcePath.segment(j)));
                            if (!folder.exists()) {
                                folder.create(true, true, null);
                            }
                            container = folder;
                            ++j;
                        }
                    }
                    entries[i] = JavaCore.newSourceEntry((IPath)projectPath.append((IPath)sourcePath), (IPath[])new IPath[0], (IPath[])new IPath[0], null);
                    ++i;
                }
                entries[sourceLength] = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), null, null);
                Path outputPath = new Path(projectOutput);
                if (outputPath.segmentCount() > 0 && !(output = project.getFolder((IPath)outputPath)).exists()) {
                    output.create(true, true, null);
                }
                IJavaProject javaProject = ENV.getJavaProject(projectName);
                javaProject.setRawClasspath(entries, projectPath.append((IPath)outputPath), null);
                if ("1.5".equals(compliance)) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                    options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    javaProject.setOptions(options);
                }
                result[0] = javaProject;
            }
        };
        ResourcesPlugin.getWorkspace().run(create, null);
        return result[0];
    }

    private void collectAllFiles(File root, ArrayList collector, FileFilter fileFilter) {
        File[] files = root.listFiles(fileFilter);
        int i = 0;
        while (i < files.length) {
            File currentFile = files[i];
            if (currentFile.isDirectory()) {
                this.collectAllFiles(currentFile, collector, fileFilter);
            } else {
                collector.add(currentFile);
            }
            ++i;
        }
    }

    protected File[] getAllFiles(File root, FileFilter fileFilter) {
        ArrayList files = new ArrayList();
        if (root.isDirectory()) {
            this.collectAllFiles(root, files, fileFilter);
            File[] result = new File[files.size()];
            files.toArray(result);
            return result;
        }
        return null;
    }

    protected IClassFile getClassFile(IJavaProject project, String rootPath, String packageName, String className) throws JavaModelException {
        IPackageFragment pkg = this.getPackageFragment(project, rootPath, packageName);
        if (pkg == null) {
            return null;
        }
        return pkg.getClassFile(className);
    }

    protected ICompilationUnit getCompilationUnit(String projectName, String packageName, String unitName) throws JavaModelException {
        IJavaProject javaProject = this.getProject(projectName);
        if (javaProject == null) {
            return null;
        }
        IType type = javaProject.findType(packageName, unitName);
        if (type != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    protected IPackageFragment getPackageFragment(IJavaProject project, String rootPath, String packageName) throws JavaModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(project, rootPath);
        if (root == null) {
            return null;
        }
        return root.getPackageFragment(packageName);
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IJavaProject project, String rootPath) throws JavaModelException {
        if (project == null) {
            return null;
        }
        Path path = new Path(rootPath);
        if (path.isAbsolute()) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = workspaceRoot.findMember((IPath)path);
            IPackageFragmentRoot root = resource == null ? project.getPackageFragmentRoot(rootPath) : project.getPackageFragmentRoot(resource);
            return root;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        if (roots == null || roots.length == 0) {
            return null;
        }
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!root.isExternal() && root.getUnderlyingResource().getProjectRelativePath().equals((Object)path)) {
                return root;
            }
            ++i;
        }
        return this.getExternalJarFile(project, rootPath);
    }

    protected IJavaProject getProject(String projectName) {
        int i = 0;
        int length = ALL_PROJECTS.length;
        while (i < length) {
            if (ALL_PROJECTS[i].getElementName().equals(projectName)) {
                return ALL_PROJECTS[i];
            }
            ++i;
        }
        return null;
    }

    protected List getProjectCompilationUnits(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] fragmentRoots = javaProject.getPackageFragmentRoots();
        int length = fragmentRoots.length;
        ArrayList<ICompilationUnit> allUnits = new ArrayList<ICompilationUnit>();
        int i = 0;
        while (i < length) {
            if (!(fragmentRoots[i] instanceof JarPackageFragmentRoot)) {
                IJavaElement[] packages = fragmentRoots[i].getChildren();
                int k = 0;
                while (k < packages.length) {
                    IPackageFragment pack = (IPackageFragment)packages[k];
                    ICompilationUnit[] units = pack.getCompilationUnits();
                    int u = 0;
                    while (u < units.length) {
                        allUnits.add(units[u]);
                        ++u;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return allUnits;
    }

    protected IPackageFragmentRoot getExternalJarFile(IJavaProject project, String jarSimpleName) throws JavaModelException {
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        if (roots == null || roots.length == 0) {
            return null;
        }
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.isExternal() && root.getElementName().equals(jarSimpleName)) {
                return root;
            }
            ++i;
        }
        return null;
    }

    protected void simulateExit() throws CoreException {
        AbstractJavaModelTests.waitForAutoBuild();
        ResourcesPlugin.getWorkspace().save(true, null);
        JavaModelManager.getJavaModelManager().shutdown();
    }

    protected void simulateExitRestart() throws CoreException {
        this.simulateExit();
        this.simulateRestart();
    }

    protected void simulateRestart() throws CoreException {
        JavaModelManager.doNotUse();
        JavaModelManager.getJavaModelManager().startup();
        new JavaCorePreferenceInitializer().initializeDefaultPreferences();
    }

    protected List splitListInSmallArrays(List units, int splitSize) throws JavaModelException {
        int size = units.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        int length = size / splitSize;
        int remind = size % splitSize;
        ArrayList<ICompilationUnit[]> splitted = new ArrayList<ICompilationUnit[]>(remind == 0 ? length : length + 1);
        if (length == 0) {
            ICompilationUnit[] sublist = new ICompilationUnit[size];
            units.toArray(sublist);
            splitted.add(sublist);
            return splitted;
        }
        int ptr = 0;
        int i = 0;
        while (i < length) {
            ICompilationUnit[] sublist = new ICompilationUnit[splitSize];
            units.subList(ptr, ptr + splitSize).toArray(sublist);
            splitted.add(sublist);
            ptr += splitSize;
            ++i;
        }
        if (remind > 0) {
            if (remind < 10) {
                ICompilationUnit[] lastList;
                ICompilationUnit[] iCompilationUnitArray = lastList = (ICompilationUnit[])splitted.remove(length - 1);
                lastList = new ICompilationUnit[splitSize + remind];
                System.arraycopy(iCompilationUnitArray, 0, lastList, 0, splitSize);
                int i2 = ptr;
                int j = splitSize;
                while (i2 < size) {
                    lastList[j] = (ICompilationUnit)units.get(i2);
                    ++i2;
                    ++j;
                }
                splitted.add(lastList);
            } else {
                ICompilationUnit[] sublist = new ICompilationUnit[remind];
                units.subList(ptr, size).toArray(sublist);
                splitted.add(sublist);
            }
        }
        return splitted;
    }

    protected Hashtable warningOptions(int kind) {
        Hashtable optionsMap = JavaCore.getDefaultOptions();
        if (kind == 0) {
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        } else {
            this.clearOptions(optionsMap);
            boolean all = kind == 1;
            String generate = all ? "generate" : "do not generate";
            String warning = all ? "warning" : "ignore";
            String enabled = all ? "enabled" : "disabled";
            String preserve = all ? "optimize out" : "preserve";
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.localVariable", generate);
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.lineNumber", generate);
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.sourceFile", generate);
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", preserve);
            optionsMap.put("org.eclipse.jdt.core.compiler.doc.comment.support", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecation", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedImport", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.taskTags", all ? "TODO,FIXME,XXX" : "");
            optionsMap.put("org.eclipse.jdt.core.compiler.taskPriorities", all ? "NORMAL,HIGH,NORMAL" : "");
            optionsMap.put("org.eclipse.jdt.core.compiler.taskCaseSensitive", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", enabled);
        }
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "ignore");
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", "ignore");
        String compliance = FullSourceWorkspaceTests.compliance();
        if (compliance != null) {
            optionsMap.put("org.eclipse.jdt.core.compiler.compliance", compliance);
            optionsMap.put("org.eclipse.jdt.core.compiler.source", compliance);
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compliance);
        }
        return optionsMap;
    }

    protected String getExternalPath() {
        String path = "";
        try {
            path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getParentFile().getCanonicalPath();
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                path = String.valueOf(path) + File.separatorChar;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path;
    }

    protected String getExternalResourcePath(String relativePath) {
        return String.valueOf(this.getExternalPath()) + relativePath;
    }

    class FullSourceProjectsFilter
    implements FileFilter {
        FullSourceProjectsFilter() {
        }

        public boolean accept(File project) {
            StringTokenizer tokenizer;
            String token;
            if (project.isDirectory() && (token = (tokenizer = new StringTokenizer(project.getName(), ".")).nextToken()).equals("org") && tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.equals("junit") && !tokenizer.hasMoreTokens()) {
                    return true;
                }
                if (token.equals("apache")) {
                    token = tokenizer.nextToken();
                    return token.equals("ant") || token.equals("lucene");
                }
                if (token.equals("eclipse") && tokenizer.hasMoreTokens()) {
                    return true;
                }
            }
            return false;
        }
    }
}

