/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.PrintStream;
import java.text.NumberFormat;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;

public class FullSourceWorkspaceTypeHierarchyTests
extends FullSourceWorkspaceTests
implements IJavaSearchConstants {
    private static int TESTS_COUNT = 0;
    private static final int WARMUP_COUNT = 5;
    private static PrintStream[] LOG_STREAMS = new PrintStream[DIM_NAMES.length];
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    protected JavaSearchResultCollector resultCollector;
    static /* synthetic */ Class class$0;

    public FullSourceWorkspaceTypeHierarchyTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = FullSourceWorkspaceTypeHierarchyTests.buildSuite(FullSourceWorkspaceTypeHierarchyTests.testClass());
        TESTS_COUNT = suite.countTestCases();
        FullSourceWorkspaceTypeHierarchyTests.createPrintStream(FullSourceWorkspaceTypeHierarchyTests.testClass(), LOG_STREAMS, TESTS_COUNT, null);
        return suite;
    }

    private static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTypeHierarchyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultCollector = new JavaSearchResultCollector();
    }

    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        super.tearDown();
    }

    public void testPerfAllTypes() throws CoreException {
        this.tagAsSummary("Type hierarchy", true);
        ICompilationUnit unit = this.getCompilationUnit("org.eclipse.jdt.core", "org.eclipse.jdt.internal.compiler.ast", "ASTNode.java");
        FullSourceWorkspaceTypeHierarchyTests.assertNotNull((String)"ASTNode not found!", (Object)unit);
        int i = 0;
        while (i < 5) {
            IType[] types = unit.getType("ASTNode").newTypeHierarchy(null).getAllClasses();
            if (i == 0) {
                System.out.println("  - " + INT_FORMAT.format(types.length) + " all classes found in hierarchy.");
            }
            ++i;
        }
        this.runGc();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            unit.getType("ASTNode").newTypeHierarchy(null).getAllClasses();
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testPerfClassWithPotentialSubinterfaces() throws CoreException {
        ICompilationUnit unit = this.getCompilationUnit("org.eclipse.text", "org.eclipse.jface.text.templates", "TemplateVariableResolver.java");
        FullSourceWorkspaceTypeHierarchyTests.assertNotNull((String)"TemplateVariableResolver not found!", (Object)unit);
        IType type = unit.getType("TemplateVariableResolver");
        int i = 0;
        while (i < 5) {
            type.newTypeHierarchy(null);
            ++i;
        }
        this.runGc();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            type.newTypeHierarchy(null);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testPerSuperTypes() throws CoreException {
        FullSourceWorkspaceTypeHierarchyTests.assertNotNull((String)"Parser not found!", (Object)PARSER_WORKING_COPY);
        this.setComment(1, "Extra handling of type parameters even in case of 1.4 projects");
        int i = 0;
        while (i < 50) {
            IType[] types = PARSER_WORKING_COPY.getType("Parser").newSupertypeHierarchy(null).getAllClasses();
            if (i == 0) {
                System.out.println("  - " + INT_FORMAT.format(types.length) + " classes found in hierarchy.");
            }
            ++i;
        }
        this.runGc();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int j = 0;
            while (j < 20) {
                PARSER_WORKING_COPY.getType("Parser").newSupertypeHierarchy(null).getAllClasses();
                ++j;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    class JavaSearchResultCollector
    extends SearchRequestor {
        int count = 0;

        JavaSearchResultCollector() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            ++this.count;
        }
    }
}

