/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointFieldChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointRenameFieldParticipant
extends BreakpointRenameParticipant {
    @Override
    protected boolean accepts(IJavaElement element) {
        return element instanceof IField;
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<Change> changes = new ArrayList<Change>();
        IResource resource = this.getBreakpointContainer();
        IMarker[] markers = resource.findMarkers("org.eclipse.jdt.debug.javaWatchpointMarker", true, 2);
        this.gatherChanges(markers, changes, this.getArguments().getNewName());
        if (changes.size() > 1) {
            return new CompositeChange(RefactoringMessages.BreakpointRenameParticipant_1, changes.toArray(new Change[changes.size()]));
        }
        if (changes.size() == 1) {
            return (Change)changes.get(0);
        }
        return null;
    }

    @Override
    protected void gatherChanges(IMarker[] markers, List<Change> changes, String destFieldName) throws CoreException, OperationCanceledException {
        IField originalField = (IField)this.getOriginalElement();
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaWatchpoint) {
                IType breakpointType;
                IJavaWatchpoint watchpoint = (IJavaWatchpoint)breakpoint;
                if (originalField.getElementName().equals(watchpoint.getFieldName()) && (breakpointType = BreakpointUtils.getType((IJavaBreakpoint)watchpoint)) != null && originalField.getDeclaringType().equals(breakpointType)) {
                    IField destField = originalField.getDeclaringType().getField(destFieldName);
                    changes.add(new WatchpointFieldChange(watchpoint, destField));
                }
            }
            ++i;
        }
    }
}

