/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.Collections;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ListeningLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.examples.databinding.contentprovider.test.RenamableItem;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LabelProviderTest2 {
    private Shell shell;
    private ListViewer list;
    private WritableList listOfRenamables;
    private Button addButton;
    private Button removeButton;
    private Button renameButton;
    private SelectionListener buttonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button pressed = (Button)e.widget;
            if (pressed == LabelProviderTest2.this.addButton) {
                LabelProviderTest2.this.listOfRenamables.add((Object)new RenamableItem());
            } else if (pressed == LabelProviderTest2.this.removeButton) {
                LabelProviderTest2.this.listOfRenamables.remove((Object)LabelProviderTest2.this.getCurrentSelection());
            } else if (pressed == LabelProviderTest2.this.renameButton) {
                LabelProviderTest2.this.rename(LabelProviderTest2.this.getCurrentSelection());
            }
            super.widgetSelected(e);
        }
    };
    private IObservableValue selectedRenamable;

    public LabelProviderTest2() {
        this.shell = new Shell(Display.getCurrent());
        this.listOfRenamables = new WritableList();
        this.list = new ListViewer((Composite)this.shell);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.list.setContentProvider((IContentProvider)contentProvider);
        this.list.setLabelProvider((IBaseLabelProvider)new ListeningLabelProvider(contentProvider.getKnownElements()){
            RenamableItem.Listener listener;
            {
                this.listener = new RenamableItem.Listener(){

                    @Override
                    public void handleChanged(RenamableItem item) {
                        this.fireChangeEvent(Collections.singleton(item));
                    }
                };
            }

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof RenamableItem) {
                    RenamableItem item = (RenamableItem)element;
                    label.setText(item.getName());
                }
            }

            protected void addListenerTo(Object next) {
                RenamableItem item = (RenamableItem)next;
                item.addListener(this.listener);
            }

            protected void removeListenerFrom(Object next) {
                RenamableItem item = (RenamableItem)next;
                item.removeListener(this.listener);
            }
        });
        this.list.setInput((Object)this.listOfRenamables);
        this.selectedRenamable = ViewersObservables.observeSingleSelection((Viewer)this.list);
        Composite buttonBar = new Composite((Composite)this.shell, 0);
        this.addButton = new Button(buttonBar, 8);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener(this.buttonSelectionListener);
        this.removeButton = new Button(buttonBar, 8);
        this.removeButton.addSelectionListener(this.buttonSelectionListener);
        this.removeButton.setText("Remove");
        this.renameButton = new Button(buttonBar, 8);
        this.renameButton.addSelectionListener(this.buttonSelectionListener);
        this.renameButton.setText("Rename");
        this.selectedRenamable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                boolean shouldEnable = LabelProviderTest2.this.selectedRenamable.getValue() != null;
                LabelProviderTest2.this.removeButton.setEnabled(shouldEnable);
                LabelProviderTest2.this.renameButton.setEnabled(shouldEnable);
            }
        });
        this.removeButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        GridLayoutFactory.fillDefaults().generateLayout(buttonBar);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)this.shell);
    }

    protected void rename(RenamableItem currentSelection) {
        InputDialog inputDialog = new InputDialog(this.shell, "Edit name", "Enter the new item name", currentSelection.getName(), null);
        if (inputDialog.open() == 0) {
            currentSelection.setName(inputDialog.getValue());
        }
    }

    protected RenamableItem getCurrentSelection() {
        return (RenamableItem)this.selectedRenamable.getValue();
    }

    public static void main(String[] args) {
        final Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                LabelProviderTest2 test = new LabelProviderTest2();
                Shell s = test.getShell();
                s.pack();
                s.setVisible(true);
                while (!s.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
        display.dispose();
    }

    private Shell getShell() {
        return this.shell;
    }
}

