/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Snippet008ComputedValue {
    public static void main(String[] args) {
        final Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                shell.setLayout((Layout)new FillLayout());
                UI ui = new UI((Composite)shell);
                Data data = new Data();
                DataBindingContext dbc = new DataBindingContext();
                dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)ui.firstName, (int)24), (IObservableValue)data.firstName);
                dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)ui.lastName, (int)24), (IObservableValue)data.lastName);
                FormattedName formattedName = new FormattedName((IObservableValue)data.firstName, (IObservableValue)data.lastName);
                dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)ui.formattedName, (int)0), (IObservableValue)formattedName, new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
                shell.pack();
                shell.open();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
        display.dispose();
    }

    static class Data {
        final WritableValue firstName = new WritableValue((Object)"", String.class);
        final WritableValue lastName = new WritableValue((Object)"", String.class);

        Data() {
        }
    }

    static class FormattedName
    extends ComputedValue {
        private IObservableValue firstName;
        private IObservableValue lastName;

        FormattedName(IObservableValue firstName, IObservableValue lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        protected Object calculate() {
            String lastName = (String)this.lastName.getValue();
            String firstName = (String)this.firstName.getValue();
            lastName = lastName != null && lastName.length() > 0 ? lastName : "[Last Name]";
            firstName = firstName != null && firstName.length() > 0 ? firstName : "[First Name]";
            StringBuffer buffer = new StringBuffer();
            buffer.append(lastName).append(", ").append(firstName);
            return buffer.toString();
        }
    }

    static class UI
    extends Composite {
        final Text firstName;
        final Text lastName;
        final Text formattedName;

        UI(Composite parent) {
            super(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
            new Label((Composite)this, 0).setText("First Name:");
            new Label((Composite)this, 0).setText("Last Name");
            GridDataFactory gdf = GridDataFactory.swtDefaults().align(4, 4).grab(true, false);
            this.firstName = new Text((Composite)this, 2048);
            gdf.applyTo((Control)this.firstName);
            this.lastName = new Text((Composite)this, 2048);
            gdf.applyTo((Control)this.lastName);
            gdf = GridDataFactory.swtDefaults().span(2, 1).grab(true, false).align(4, 1);
            Label label = new Label((Composite)this, 0);
            label.setText("Formatted Name:");
            gdf.applyTo((Control)label);
            this.formattedName = new Text((Composite)this, 2048);
            this.formattedName.setEditable(false);
            gdf.applyTo((Control)this.formattedName);
        }
    }
}

