/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.util.JFaceProperties;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Snippet031JFaceObservable {
    public static final String NAME_PROPERTY = "name_property";

    public static void main(String[] args) {
        Display display = new Display();
        final ViewModel viewModel = new ViewModel();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell = new View(viewModel).createShell();
                Display display = Display.getCurrent();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
        System.out.println("person.getName() = " + viewModel.getPerson().getName());
    }

    public static class Person
    extends EventManager {
        String name = "HelloWorld";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.fireChange(new PropertyChangeEvent((Object)this, Snippet031JFaceObservable.NAME_PROPERTY, (Object)this.name, (Object)this.name));
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
            this.addListenerObject(listener);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            this.removeListenerObject(listener);
        }

        private void fireChange(PropertyChangeEvent event) {
            Object[] list = this.getListeners();
            int i = 0;
            while (i < list.length) {
                ((IPropertyChangeListener)list[i]).propertyChange(event);
                ++i;
            }
        }
    }

    static class View {
        private ViewModel viewModel;
        private Text name;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new RowLayout(512));
            this.name = new Text((Composite)shell, 2048);
            DataBindingContext bindingContext = new DataBindingContext();
            Person person = this.viewModel.getPerson();
            IValueProperty nameProperty = JFaceProperties.value(Person.class, (String)"name", (String)Snippet031JFaceObservable.NAME_PROPERTY);
            bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.name, (int)24), nameProperty.observe((Object)person), null, null);
            Label label = new Label((Composite)shell, 0);
            bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)label), nameProperty.observe((Object)person), null, null);
            shell.pack();
            shell.open();
            return shell;
        }
    }

    static class ViewModel {
        private Person person = new Person();

        ViewModel() {
        }

        public Person getPerson() {
            return this.person;
        }
    }
}

