/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ListBindingTest
extends AbstractDefaultRealmTestCase {
    private IObservableList target;
    private IObservableList model;
    private DataBindingContext dbc;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.target = new WritableList(arrayList, (Object)clazz);
        ArrayList arrayList2 = new ArrayList();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.model = new WritableList(arrayList2, (Object)clazz2);
        this.dbc = new DataBindingContext();
    }

    public void testUpdateModelFromTarget() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model, new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
        this.target.add((Object)"1");
        ArrayList targetCopy = new ArrayList(this.target.size());
        targetCopy.addAll(this.target);
        this.model.add((Object)"2");
        ListBindingTest.assertFalse((String)"target should not equal model", (boolean)this.target.equals((Object)this.model));
        binding.updateTargetToModel();
        ListBindingTest.assertEquals((String)"target should not have changed", targetCopy, (Object)this.target);
        ListBindingTest.assertEquals((String)"target != model", (Object)this.target, (Object)this.model);
    }

    public void testUpdateTargetFromModel() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model, new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
        this.target.add((Object)"1");
        this.model.add((Object)"2");
        ArrayList modelCopy = new ArrayList(this.model.size());
        modelCopy.addAll(this.model);
        ListBindingTest.assertFalse((String)"model should not equal target", (boolean)this.model.equals((Object)this.target));
        binding.updateModelToTarget();
        ListBindingTest.assertEquals((String)"model should not have changed", modelCopy, (Object)this.model);
        ListBindingTest.assertEquals((String)"model != target", (Object)this.model, (Object)this.target);
    }

    public void testGetTarget() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model);
        ListBindingTest.assertEquals((Object)this.target, (Object)binding.getTarget());
    }

    public void testGetModel() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model);
        ListBindingTest.assertEquals((Object)this.model, (Object)binding.getModel());
    }

    public void testStatusIsInstanceOfBindingStatus() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model);
        ListBindingTest.assertTrue((boolean)(binding.getValidationStatus().getValue() instanceof BindingStatus));
    }

    public void testAddValidationStatusContainsMultipleStatuses() throws Exception {
        UpdateListStrategy strategy = new UpdateListStrategy(){

            protected IStatus doAdd(IObservableList observableList, Object element, int index) {
                super.doAdd(observableList, element, index);
                switch (index) {
                    case 0: {
                        return ValidationStatus.error((String)"");
                    }
                    case 1: {
                        return ValidationStatus.info((String)"");
                    }
                }
                return null;
            }
        };
        Binding binding = this.dbc.bindList(this.target, this.model, strategy, null);
        this.target.addAll(Arrays.asList("1", "2"));
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        ListBindingTest.assertEquals((String)"maximum status", (int)4, (int)status.getSeverity());
        ListBindingTest.assertTrue((String)"multi status", (boolean)status.isMultiStatus());
        IStatus[] children = status.getChildren();
        ListBindingTest.assertEquals((String)"multi status children", (int)2, (int)children.length);
        ListBindingTest.assertEquals((String)"first status severity", (int)4, (int)children[0].getSeverity());
        ListBindingTest.assertEquals((String)"second status severity", (int)1, (int)children[1].getSeverity());
    }

    public void testRemoveValidationStatusContainsMultipleStatuses() throws Exception {
        List<String> items = Arrays.asList("1", "2");
        this.model.addAll(items);
        UpdateListStrategy strategy = new UpdateListStrategy(){
            int count;

            protected IStatus doRemove(IObservableList observableList, int index) {
                super.doRemove(observableList, index);
                switch (this.count++) {
                    case 0: {
                        return ValidationStatus.error((String)"");
                    }
                    case 1: {
                        return ValidationStatus.info((String)"");
                    }
                }
                return null;
            }
        };
        Binding binding = this.dbc.bindList(this.target, this.model, strategy, null);
        this.target.removeAll(items);
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        ListBindingTest.assertEquals((String)"maximum status", (int)4, (int)status.getSeverity());
        ListBindingTest.assertTrue((String)"multi status", (boolean)status.isMultiStatus());
        IStatus[] children = status.getChildren();
        ListBindingTest.assertEquals((String)"multi status children", (int)2, (int)children.length);
        ListBindingTest.assertEquals((String)"first status severity", (int)4, (int)children[0].getSeverity());
        ListBindingTest.assertEquals((String)"second status severity", (int)1, (int)children[1].getSeverity());
    }

    public void testAddOKValidationStatus() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model);
        this.target.add((Object)"1");
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        ListBindingTest.assertTrue((boolean)status.isOK());
        ListBindingTest.assertEquals((int)0, (int)status.getChildren().length);
    }

    public void testRemoveOKValidationStatus() throws Exception {
        this.model.add((Object)"1");
        Binding binding = this.dbc.bindList(this.target, this.model);
        this.target.remove((Object)"1");
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        ListBindingTest.assertTrue((boolean)status.isOK());
        ListBindingTest.assertEquals((int)0, (int)status.getChildren().length);
    }
}

