/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.beans;

import java.util.Arrays;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class BeansObservablesTest
extends AbstractDefaultRealmTestCase {
    Bean[] elements = null;
    Bean model = null;
    Class elementType = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void setUp() throws Exception {
        super.setUp();
        this.elements = new Bean[]{new Bean("1"), new Bean("2"), new Bean("3")};
        this.model = new Bean(this.elements);
        this.model.setList(Arrays.asList(this.elements));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.elementType = clazz;
    }

    public void testObserveListArrayInferredElementType() throws Exception {
        IObservableList list = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.model, (String)"list", null);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeansObservablesTest.assertEquals((String)"element type", (Object)clazz, (Object)list.getElementType());
    }

    public void testObserveListNonInferredElementType() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.elementType = clazz;
        IObservableList list = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.model, (String)"list", null);
        BeansObservablesTest.assertEquals((String)"element type", (Object)this.elementType, (Object)list.getElementType());
    }

    public void testListFactory() throws Exception {
        IObservableFactory factory = BeansObservables.listFactory((Realm)Realm.getDefault(), (String)"list", (Class)this.elementType);
        IObservableList list = (IObservableList)factory.createObservable((Object)this.model);
        BeansObservablesTest.assertTrue((String)"elements of the list", (boolean)Arrays.equals(this.elements, list.toArray((Object[])new Bean[list.size()])));
        BeansObservablesTest.assertEquals((String)"element type", (Object)this.elementType, (Object)list.getElementType());
    }

    public void testObserveDetailListElementType() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableValue parent = WritableValue.withValueType((Object)clazz);
        parent.setValue((Object)this.model);
        IObservableList list = BeansObservables.observeDetailList((IObservableValue)parent, (String)"list", (Class)this.elementType);
        BeansObservablesTest.assertEquals((String)"element type", (Object)this.elementType, (Object)list.getElementType());
        BeansObservablesTest.assertTrue((String)"elements of list", (boolean)Arrays.equals(this.elements, list.toArray((Object[])new Bean[list.size()])));
    }

    public void testObserveDetailValueIBeanObservable() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableValue parent = WritableValue.withValueType((Object)clazz);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableValue detailValue = BeansObservables.observeDetailValue((IObservableValue)parent, (String)"value", (Class)clazz2);
        BeansObservablesTest.assertTrue((boolean)(detailValue instanceof IBeanObservable));
        BeanObservableValueDecorator beanObservable = (BeanObservableValueDecorator)detailValue;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeansObservablesTest.assertEquals((String)"property descriptor", (Object)clazz3.getMethod("getValue", null), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        BeansObservablesTest.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        BeansObservablesTest.assertTrue((String)"delegate", (boolean)beanObservable.getDecorated().getClass().getName().endsWith("DetailObservableValue"));
    }

    public void testObserveDetailValueNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableValue detailValue = BeansObservables.observeDetailValue((IObservableValue)parent, (String)"value", (Class)clazz);
        BeansObservablesTest.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailValue).getPropertyDescriptor());
    }

    public void testObservableDetailListIBeanObservable() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableValue parent = WritableValue.withValueType((Object)clazz);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableList detailList = BeansObservables.observeDetailList((IObservableValue)parent, (String)"list", (Class)clazz2);
        BeansObservablesTest.assertTrue((String)"detail is not an IBeanObservable", (boolean)(detailList instanceof IBeanObservable));
        BeanObservableListDecorator beanObservable = (BeanObservableListDecorator)detailList;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeansObservablesTest.assertEquals((String)"property descriptor", (Object)clazz3.getMethod("getList", null), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        BeansObservablesTest.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        BeansObservablesTest.assertTrue((String)"delegate is the observed", (boolean)beanObservable.getDecorated().equals(detailList));
    }

    public void testObservableDetailListNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableList detailList = BeansObservables.observeDetailList((IObservableValue)parent, (String)"list", (Class)clazz);
        BeansObservablesTest.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailList).getPropertyDescriptor());
    }

    public void testObservableDetailSetIBeanObservable() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableValue parent = WritableValue.withValueType((Object)clazz);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableSet detailSet = BeansObservables.observeDetailSet((IObservableValue)parent, (String)"set", (Class)clazz2);
        BeansObservablesTest.assertTrue((String)"detail is not an IBeanObservable", (boolean)(detailSet instanceof IBeanObservable));
        BeanObservableSetDecorator beanObservable = (BeanObservableSetDecorator)detailSet;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeansObservablesTest.assertEquals((String)"property descriptor", (Object)clazz3.getMethod("getSet", null), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        BeansObservablesTest.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        BeansObservablesTest.assertTrue((String)"delegate is the observed", (boolean)beanObservable.getDecorated().equals(detailSet));
    }

    public void testObservableDetailSetNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableSet detailSet = BeansObservables.observeDetailSet((IObservableValue)parent, (String)"set", (Class)clazz);
        BeansObservablesTest.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailSet).getPropertyDescriptor());
    }

    public void testObserveSetElementType() throws Exception {
        Bean bean = new Bean();
        Realm realm = Realm.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableSet observableSet = BeansObservables.observeSet((Realm)realm, (Object)bean, (String)"set", (Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeansObservablesTest.assertEquals((Object)clazz2, (Object)observableSet.getElementType());
    }

    public void testObserveSetNonInferredElementType() throws Exception {
        Bean bean = new Bean();
        IObservableSet observableSet = BeansObservables.observeSet((Realm)Realm.getDefault(), (Object)bean, (String)"set");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeansObservablesTest.assertEquals((Object)clazz, (Object)observableSet.getElementType());
    }

    public void testHandleExternalChangeToProperty() {
        Bean targetBean = new Bean();
        IObservableList modelObservable = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.model, (String)"array", (Class)this.elementType);
        IObservableList targetObservable = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)targetBean, (String)"array", (Class)this.elementType);
        DataBindingContext context = new DataBindingContext(Realm.getDefault());
        try {
            context.bindList(targetObservable, modelObservable);
            BeansObservablesTest.assertTrue((boolean)Arrays.equals(this.elements, targetBean.getArray()));
            Object[] newElements = new Bean[]{new Bean("4"), new Bean("5"), new Bean("6")};
            this.model.setArray(newElements);
            BeansObservablesTest.assertTrue((boolean)Arrays.equals(newElements, targetBean.getArray()));
            newElements = new Bean[]{new Bean("7"), new Bean("8"), new Bean("9")};
            targetBean.setArray(newElements);
            BeansObservablesTest.assertTrue((boolean)Arrays.equals(newElements, this.model.getArray()));
        }
        finally {
            context.dispose();
        }
    }

    public void testObserveDetailValue_ValueType() {
        Bean inner = new Bean("string");
        Bean outer = new Bean(inner);
        IBeanValueProperty beanProperty = BeanProperties.value((String)"bean");
        IObservableValue beanObservable = beanProperty.observe((Object)outer);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeansObservablesTest.assertEquals((Object)clazz, (Object)beanObservable.getValueType());
        IBeanValueProperty valueProperty = BeanProperties.value((String)"value");
        IObservableValue valueObservable = valueProperty.observeDetail(beanObservable);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BeansObservablesTest.assertEquals((Object)clazz2, (Object)valueObservable.getValueType());
    }
}

