/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.beans;

import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class PojoObservablesTest
extends AbstractDefaultRealmTestCase {
    private Bean pojo;
    private String propertyName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        this.pojo = new Bean();
        this.propertyName = "value";
    }

    public void testObserveValue_ReturnsIBeanObservable() throws Exception {
        IObservableValue value = PojoObservables.observeValue((Object)this.pojo, (String)this.propertyName);
        PojoObservablesTest.assertNotNull((Object)value);
        PojoObservablesTest.assertTrue((boolean)(value instanceof IBeanObservable));
    }

    public void testObserveValue_DoesNotAttachListeners() throws Exception {
        IObservableValue value = PojoObservables.observeValue((Object)this.pojo, (String)this.propertyName);
        ChangeEventTracker.observe((IObservable)value);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
    }

    public void testObservableValueWithRealm_ReturnsIBeanObservable() throws Exception {
        CurrentRealm realm = new CurrentRealm(true);
        IObservableValue value = PojoObservables.observeValue((Realm)realm, (Object)this.pojo, (String)this.propertyName);
        PojoObservablesTest.assertNotNull((Object)value);
        PojoObservablesTest.assertTrue((boolean)(value instanceof IBeanObservable));
    }

    public void testObservableMap_ReturnsIBeanObservable() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)new Bean());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableMap map = PojoObservables.observeMap((IObservableSet)set, (Class)clazz, (String)this.propertyName);
        PojoObservablesTest.assertNotNull((Object)map);
        PojoObservablesTest.assertTrue((boolean)(map instanceof IBeanObservable));
    }

    public void testObservableMap_DoesNotAttachListeners() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)this.pojo);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableMap map = PojoObservables.observeMap((IObservableSet)set, (Class)clazz, (String)this.propertyName);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
        ChangeEventTracker.observe((IObservable)map);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
    }

    public void testObserveMaps_ReturnsMaps() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)this.pojo);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableMap[] maps = PojoObservables.observeMaps((IObservableSet)set, clazz, (String[])new String[]{"value", "class"});
        PojoObservablesTest.assertEquals((int)2, (int)maps.length);
    }

    public void testObserveListWithElementType_ReturnsIBeanObservable() throws Exception {
        Realm realm = Realm.getDefault();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableList list = PojoObservables.observeList((Realm)realm, (Object)this.pojo, (String)"list", (Class)clazz);
        PojoObservablesTest.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    public void testObserveListWithElementType_DoesNotAttachListeners() throws Exception {
        Realm realm = Realm.getDefault();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableList observable = PojoObservables.observeList((Realm)realm, (Object)this.pojo, (String)"list", (Class)clazz);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("list"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("list"));
    }

    public void testObserveList_ReturnsIBeanObservable() throws Exception {
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list");
        PojoObservablesTest.assertTrue((boolean)(observable instanceof IBeanObservable));
    }

    public void testObserveList_DoesNotAttachListeners() throws Exception {
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list");
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("list"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("list"));
    }

    public void testObserveSetWithElementType_ReturnsIBeanObservable() throws Exception {
        Realm realm = Realm.getDefault();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableSet list = PojoObservables.observeSet((Realm)realm, (Object)this.pojo, (String)"set", (Class)clazz);
        PojoObservablesTest.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    public void testObserveSetWithElementType_DoesNotAttachListeners() throws Exception {
        Realm realm = Realm.getDefault();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableSet observable = PojoObservables.observeSet((Realm)realm, (Object)this.pojo, (String)"set", (Class)clazz);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    public void testObserveSet_ReturnsIBeanObservable() throws Exception {
        IObservableSet list = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set");
        PojoObservablesTest.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    public void testObserveSet_DoesNotAttachListeners() throws Exception {
        IObservableSet observable = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set");
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    public void testValueFactory_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.valueFactory((Realm)Realm.getDefault(), (String)"value");
        IObservableValue observable = (IObservableValue)factory.createObservable((Object)this.pojo);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("value"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("value"));
    }

    public void testListFactory_DoesNotAttachListeners() throws Exception {
        Realm realm = Realm.getDefault();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableFactory factory = PojoObservables.listFactory((Realm)realm, (String)"list", (Class)clazz);
        IObservableList observable = (IObservableList)factory.createObservable((Object)this.pojo);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("value"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("value"));
    }

    public void testSetFactory_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.setFactory((Realm)Realm.getDefault(), (String)this.propertyName);
        IObservableSet observable = (IObservableSet)factory.createObservable((Object)this.pojo);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    public void testSetFactoryWithElementType_DoesNotAttachListeners() throws Exception {
        Realm realm = Realm.getDefault();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IObservableFactory factory = PojoObservables.setFactory((Realm)realm, (String)this.propertyName, (Class)clazz);
        IObservableSet observable = (IObservableSet)factory.createObservable((Object)this.pojo);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        PojoObservablesTest.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    public void testObserveDetailValue_ValueType() {
        Bean inner = new Bean("string");
        Bean outer = new Bean(inner);
        IBeanValueProperty beanProperty = PojoProperties.value((String)"bean");
        IObservableValue beanObservable = beanProperty.observe((Object)outer);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.internal.databinding.beans.Bean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PojoObservablesTest.assertEquals((Object)clazz, (Object)beanObservable.getValueType());
        IBeanValueProperty valueProperty = PojoProperties.value((String)"value");
        IObservableValue valueObservable = valueProperty.observeDetail(beanObservable);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PojoObservablesTest.assertEquals((Object)clazz2, (Object)valueObservable.getValueType());
    }
}

