/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;

public class NumberToStringConverterTest
extends TestCase {
    private NumberFormat numberFormat;
    private NumberFormat integerFormat;
    Class icuBigDecimal = null;
    Constructor icuBigDecimalCtr = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public NumberToStringConverterTest() {
        try {
            this.icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            classArray[1] = Integer.TYPE;
            this.icuBigDecimalCtr = this.icuBigDecimal.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.numberFormat = NumberFormat.getNumberInstance();
        this.integerFormat = NumberFormat.getIntegerInstance();
    }

    public void testFromTypes() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((String)"Integer.class", (Object)clazz, (Object)NumberToStringConverter.fromInteger((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Integer.TYPE", Integer.TYPE, (Object)NumberToStringConverter.fromInteger((boolean)true).getFromType());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((String)"Double.class", (Object)clazz2, (Object)NumberToStringConverter.fromDouble((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Double.TYPE", Double.TYPE, (Object)NumberToStringConverter.fromDouble((boolean)true).getFromType());
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((String)"Long.class", (Object)clazz3, (Object)NumberToStringConverter.fromLong((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Long.TYPE", Long.TYPE, (Object)NumberToStringConverter.fromLong((boolean)true).getFromType());
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((String)"Float.class", (Object)clazz4, (Object)NumberToStringConverter.fromFloat((boolean)false).getFromType());
        NumberToStringConverterTest.assertEquals((String)"Float.TYPE", Float.TYPE, (Object)NumberToStringConverter.fromFloat((boolean)true).getFromType());
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((String)"BigInteger.class", (Object)clazz5, (Object)NumberToStringConverter.fromBigInteger().getFromType());
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((String)"BigDecimal.class", (Object)clazz6, (Object)NumberToStringConverter.fromBigDecimal().getFromType());
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((String)"Short.class", (Object)clazz7, (Object)NumberToStringConverter.fromShort((boolean)false).getFromType());
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((String)"Byte.class", (Object)clazz8, (Object)NumberToStringConverter.fromByte((boolean)false).getFromType());
    }

    public void testToTypeIsStringClass() throws Exception {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NumberToStringConverterTest.assertEquals((Object)clazz, (Object)NumberToStringConverter.fromInteger((boolean)false).getToType());
    }

    public void testConvertIntegerToString() throws Exception {
        Integer input = new Integer(1000);
        String expected = this.integerFormat.format(input.longValue());
        NumberToStringConverter converter = NumberToStringConverter.fromInteger((boolean)false);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertDoubleToString() throws Exception {
        Double input = new Double(1000.1);
        String expected = this.numberFormat.format(input.doubleValue());
        NumberToStringConverter converter = NumberToStringConverter.fromDouble((boolean)false);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertFloatToString() throws Exception {
        Float input = new Float(1000.1f);
        String expected = this.numberFormat.format((double)input.floatValue());
        NumberToStringConverter converter = NumberToStringConverter.fromFloat((boolean)false);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertLongToString() throws Exception {
        Long input = new Long(1000L);
        String expected = this.integerFormat.format(input.longValue());
        NumberToStringConverter converter = NumberToStringConverter.fromLong((boolean)false);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testConvertBigIntegerToString() throws Exception {
        BigInteger input = BigInteger.valueOf(1000L);
        String expected = this.integerFormat.format(input);
        NumberToStringConverter converter = NumberToStringConverter.fromBigInteger();
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)expected, (String)result);
    }

    private String formatBigDecimal(BigDecimal javabd) throws Exception {
        if (this.icuBigDecimal != null && this.icuBigDecimalCtr != null) {
            Number icubd = (Number)this.icuBigDecimalCtr.newInstance(javabd.unscaledValue(), new Integer(javabd.scale()));
            return this.numberFormat.format((Object)icubd);
        }
        throw new IllegalArgumentException("ICU not present. Cannot reliably format large BigDecimal values; needed for testing. Java platforms prior to 1.5 fail to format/parse these decimals correctly.");
    }

    public void testConvertBigDecimalToString() throws Exception {
        NumberToStringConverter converter = NumberToStringConverter.fromBigDecimal();
        BigDecimal input = new BigDecimal("100.23");
        String expected = this.formatBigDecimal(input);
        String result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)"Non-integer BigDecimal", (String)expected, (String)result);
        input = new BigDecimal(2.147483747E9);
        expected = this.formatBigDecimal(input);
        result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)"Integral BigDecimal in long range", (String)expected, (String)result);
        input = new BigDecimal(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(100L)));
        expected = this.formatBigDecimal(input);
        result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)"Integral BigDecimal in BigInteger range", (String)expected, (String)result);
        input = new BigDecimal("100404101.233456783456788934567893456789231982001345678234567890");
        expected = this.formatBigDecimal(input);
        result = (String)converter.convert((Object)input);
        NumberToStringConverterTest.assertEquals((String)"High-precision BigDecimal", (String)expected, (String)result);
    }

    public void testNullSourceConvertsToEmptyString() throws Exception {
        NumberToStringConverter converter = NumberToStringConverter.fromInteger((boolean)false);
        NumberToStringConverterTest.assertEquals((Object)"", (Object)converter.convert(null));
    }
}

