/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;

public class StringToNumberConverterTest
extends TestCase {
    private NumberFormat numberFormat;
    private NumberFormat numberIntegerFormat;
    Class icuBigDecimal = null;
    Constructor icuBigDecimalCtr = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public StringToNumberConverterTest() {
        try {
            this.icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            classArray[1] = Integer.TYPE;
            this.icuBigDecimalCtr = this.icuBigDecimal.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(305);
        this.numberFormat.setGroupingUsed(false);
        this.numberIntegerFormat = NumberFormat.getIntegerInstance();
    }

    public void testToTypes() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((String)"Integer.class", (Object)clazz, (Object)StringToNumberConverter.toInteger((boolean)false).getToType());
        StringToNumberConverterTest.assertEquals((String)"Integer.TYPE", Integer.TYPE, (Object)StringToNumberConverter.toInteger((boolean)true).getToType());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((String)"Double.class", (Object)clazz2, (Object)StringToNumberConverter.toDouble((boolean)false).getToType());
        StringToNumberConverterTest.assertEquals((String)"Double.TYPE", Double.TYPE, (Object)StringToNumberConverter.toDouble((boolean)true).getToType());
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((String)"Long.class", (Object)clazz3, (Object)StringToNumberConverter.toLong((boolean)false).getToType());
        StringToNumberConverterTest.assertEquals((String)"Long.TYPE", Long.TYPE, (Object)StringToNumberConverter.toLong((boolean)true).getToType());
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((String)"Float.class", (Object)clazz4, (Object)StringToNumberConverter.toFloat((boolean)false).getToType());
        StringToNumberConverterTest.assertEquals((String)"Float.TYPE", Float.TYPE, (Object)StringToNumberConverter.toFloat((boolean)true).getToType());
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((String)"BigInteger.TYPE", (Object)clazz5, (Object)StringToNumberConverter.toBigInteger().getToType());
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((String)"BigDecimal.TYPE", (Object)clazz6, (Object)StringToNumberConverter.toBigDecimal().getToType());
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((String)"Short.class", (Object)clazz7, (Object)StringToNumberConverter.toShort((boolean)false).getToType());
        StringToNumberConverterTest.assertEquals((String)"Short.TYPE", Short.TYPE, (Object)StringToNumberConverter.toShort((boolean)true).getToType());
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((String)"Byte.class", (Object)clazz8, (Object)StringToNumberConverter.toByte((boolean)false).getToType());
        StringToNumberConverterTest.assertEquals((String)"Byte.TYPE", Byte.TYPE, (Object)StringToNumberConverter.toByte((boolean)true).getToType());
    }

    public void testFromTypeIsString() throws Exception {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringToNumberConverterTest.assertEquals((Object)clazz, (Object)StringToNumberConverter.toInteger((boolean)false).getFromType());
    }

    public void testConvertsToBigInteger() throws Exception {
        BigInteger input = BigInteger.valueOf(1000L);
        StringToNumberConverter converter = StringToNumberConverter.toBigInteger();
        BigInteger result = (BigInteger)converter.convert((Object)this.numberFormat.format(input));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    private String formatBigDecimal(BigDecimal javabd) throws Exception {
        if (this.icuBigDecimal != null && this.icuBigDecimalCtr != null) {
            Number icubd = (Number)this.icuBigDecimalCtr.newInstance(javabd.unscaledValue(), new Integer(javabd.scale()));
            return this.numberFormat.format((Object)icubd);
        }
        throw new IllegalArgumentException("ICU not present. Cannot reliably format large BigDecimal values; needed for testing. Java platforms prior to 1.5 fail to format/parse these decimals correctly.");
    }

    public void testConvertsToBigDecimal() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toBigDecimal();
        BigDecimal input = new BigDecimal("100.23");
        BigDecimal result = (BigDecimal)converter.convert((Object)this.formatBigDecimal(input));
        StringToNumberConverterTest.assertEquals((String)"Non-integer BigDecimal", (Object)input, (Object)result);
        input = new BigDecimal(2.147483747E9);
        result = (BigDecimal)converter.convert((Object)this.formatBigDecimal(input));
        StringToNumberConverterTest.assertEquals((String)"Integral BigDecimal in long range", (Object)input, (Object)result);
        input = new BigDecimal("92233720368547990480");
        result = (BigDecimal)converter.convert((Object)this.formatBigDecimal(input));
        StringToNumberConverterTest.assertEquals((String)"Integral BigDecimal in long range", (Object)input, (Object)result);
        input = new BigDecimal("100404101.23345678345678893456789345678923198200134567823456789");
        result = (BigDecimal)converter.convert((Object)this.formatBigDecimal(input));
        StringToNumberConverterTest.assertEquals((String)"Non-integer BigDecimal", (Object)input, (Object)result);
    }

    public void testConvertsToInteger() throws Exception {
        Integer input = new Integer(1000);
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        Integer result = (Integer)converter.convert((Object)this.numberIntegerFormat.format(input.longValue()));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    public void testConvertsToDouble() throws Exception {
        Double input = new Double(1000.0);
        StringToNumberConverter converter = StringToNumberConverter.toDouble((boolean)false);
        Double result = (Double)converter.convert((Object)this.numberFormat.format(input.doubleValue()));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    public void testConvertsToLong() throws Exception {
        Long input = new Long(1000L);
        StringToNumberConverter converter = StringToNumberConverter.toLong((boolean)false);
        Long result = (Long)converter.convert((Object)this.numberIntegerFormat.format(input.longValue()));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    public void testConvertsToFloat() throws Exception {
        Float input = new Float(1000.0f);
        StringToNumberConverter converter = StringToNumberConverter.toFloat((boolean)false);
        Float result = (Float)converter.convert((Object)this.numberFormat.format((double)input.floatValue()));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    public void testConvertedToIntegerPrimitive() throws Exception {
        Integer input = new Integer(1000);
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)true);
        Integer result = (Integer)converter.convert((Object)this.numberIntegerFormat.format(input.longValue()));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    public void testConvertsToDoublePrimitive() throws Exception {
        Double input = new Double(1000.0);
        StringToNumberConverter converter = StringToNumberConverter.toDouble((boolean)true);
        Double result = (Double)converter.convert((Object)this.numberFormat.format(input.doubleValue()));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    public void testConvertsToLongPrimitive() throws Exception {
        Long input = new Long(1000L);
        StringToNumberConverter converter = StringToNumberConverter.toLong((boolean)true);
        Long result = (Long)converter.convert((Object)this.numberIntegerFormat.format(input.longValue()));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    public void testConvertsToFloatPrimitive() throws Exception {
        Float input = new Float(1000.0f);
        StringToNumberConverter converter = StringToNumberConverter.toFloat((boolean)true);
        Float result = (Float)converter.convert((Object)this.numberFormat.format((double)input.floatValue()));
        StringToNumberConverterTest.assertEquals((Object)input, (Object)result);
    }

    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        try {
            StringToNumberConverterTest.assertNull((Object)converter.convert((Object)""));
        }
        catch (Exception exception) {
            StringToNumberConverterTest.fail((String)"exception should not have been thrown");
        }
    }

    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        try {
            converter.convert((Object)new Integer(1));
            StringToNumberConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testInvalidInteger() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        try {
            Object result = converter.convert((Object)"1 1 -1");
            StringToNumberConverterTest.fail((String)("exception should have been thrown, but result was " + result));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testThrowsIllegalArgumentExceptionIfNumberIsOutOfRange() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        try {
            converter.convert((Object)this.numberFormat.format(Long.MAX_VALUE));
            StringToNumberConverterTest.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

