/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.DecoratingObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DecoratingObservableTest
extends AbstractDefaultRealmTestCase {
    private IObservable decorated;
    private DecoratingObservable decorator;

    protected void setUp() throws Exception {
        super.setUp();
        this.decorated = new ObservableStub(Realm.getDefault());
        this.decorator = new DecoratingObservable(this.decorated, false);
    }

    public void testDisposeDecorated_DisposesDecorator() {
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)this.decorator);
        DecoratingObservableTest.assertFalse((boolean)this.decorator.isDisposed());
        this.decorated.dispose();
        DecoratingObservableTest.assertEquals((int)1, (int)tracker.count);
        DecoratingObservableTest.assertTrue((boolean)this.decorator.isDisposed());
    }

    static class ObservableStub
    extends AbstractObservable {
        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return false;
        }
    }
}

