/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import java.util.LinkedList;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;

public class ThreadRealm
extends Realm {
    private Thread thread;
    private final LinkedList queue = new LinkedList();
    private volatile boolean block;

    public synchronized void init(Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Parameter thread was null.");
        }
        Assert.isTrue((this.thread == null ? 1 : 0) != 0, (String)"Realm can only be initialized once.");
        this.thread = thread;
    }

    public boolean isCurrent() {
        return Thread.currentThread() == this.thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(runnable);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue() {
        if (Thread.currentThread() == this.thread) {
            throw new IllegalStateException("Cannot execute this method in the realm's own thread");
        }
        try {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                while (!this.queue.isEmpty()) {
                    if (!this.block) {
                        throw new IllegalStateException("Cannot process queue, ThreadRealm is not blocking on its thread");
                    }
                    this.queue.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isBlocking() {
        return this.block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void block() {
        if (this.block) {
            throw new IllegalStateException("Realm is already blocking.");
        }
        if (Thread.currentThread() != this.thread) {
            throw new IllegalStateException("The current thread is not the correct thread.");
        }
        try {
            try {
                this.block = true;
                var1_1 = this.queue;
                synchronized (var1_1) {
                    this.queue.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl39
                }
                do {
                    runnable = null;
                    var2_2 = this.queue;
                    synchronized (var2_2) {
                        if (this.queue.isEmpty()) {
                            this.queue.wait();
                        } else {
                            runnable = (Runnable)this.queue.getFirst();
                        }
                    }
                    if (runnable == null) continue;
                    ThreadRealm.safeRun((Runnable)runnable);
                    var2_2 = this.queue;
                    synchronized (var2_2) {
                        this.queue.removeFirst();
                        this.queue.notifyAll();
                    }
lbl39:
                    // 3 sources

                } while (this.block);
            }
            catch (InterruptedException v3) {
                Thread.currentThread().interrupt();
                this.block = false;
            }
        }
        finally {
            this.block = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        this.block = false;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void waitUntilBlocking() {
        if (Thread.currentThread() != this.thread) ** GOTO lbl14
        throw new IllegalStateException("Cannot execute this method in the realm's own thread");
lbl-1000:
        // 1 sources

        {
            var1_1 = this.queue;
            synchronized (var1_1) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException v0) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
lbl14:
            // 3 sources

            ** while (!this.block)
        }
lbl15:
        // 1 sources

    }
}

