/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;

public class AbstractObservableListTest
extends TestCase {
    private AbstractObservableListStub list;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        this.list = new AbstractObservableListStub();
    }

    protected void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    public void testFireChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                AbstractObservableListTest.this.list.fireChange();
            }
        });
    }

    public void testFireStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                AbstractObservableListTest.this.list.fireStale();
            }
        });
    }

    public void testFireListChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                AbstractObservableListTest.this.list.fireListChange(null);
            }
        });
    }

    public void testMove_FiresListChanges() throws Exception {
        this.list = new MutableObservableListStub();
        Object element = new Object();
        this.list.add(element);
        this.list.add(new Object());
        final ArrayList diffEntries = new ArrayList();
        this.list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                diffEntries.addAll(Arrays.asList(event.diff.getDifferences()));
            }
        });
        this.list.move(0, 1);
        AbstractObservableListTest.assertEquals((int)2, (int)diffEntries.size());
        ListDiffEntry entry = (ListDiffEntry)diffEntries.get(0);
        AbstractObservableListTest.assertEquals((Object)element, (Object)entry.getElement());
        AbstractObservableListTest.assertEquals((boolean)false, (boolean)entry.isAddition());
        AbstractObservableListTest.assertEquals((int)0, (int)entry.getPosition());
        entry = (ListDiffEntry)diffEntries.get(1);
        AbstractObservableListTest.assertEquals((Object)element, (Object)entry.getElement());
        AbstractObservableListTest.assertEquals((boolean)true, (boolean)entry.isAddition());
        AbstractObservableListTest.assertEquals((int)1, (int)entry.getPosition());
    }

    public void testMove_MovesElement() throws Exception {
        this.list = new MutableObservableListStub();
        Object element0 = new Object();
        Object element1 = new Object();
        this.list.add(element0);
        this.list.add(element1);
        this.list.move(0, 1);
        AbstractObservableListTest.assertEquals((Object)element1, (Object)this.list.get(0));
        AbstractObservableListTest.assertEquals((Object)element0, (Object)this.list.get(1));
    }

    public void testAddListChangeListener_AfterDispose() {
        this.list.dispose();
        this.list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
            }
        });
    }

    public void testRemoveListChangeListener_AfterDispose() {
        this.list.dispose();
        this.list.removeListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
            }
        });
    }

    public void testAddChangeListener_AfterDispose() {
        this.list.dispose();
        this.list.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
    }

    public void testRemoveChangeListener_AfterDispose() {
        this.list.dispose();
        this.list.removeChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
    }

    public void testAddStaleListener_AfterDispose() {
        this.list.dispose();
        this.list.addStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
            }
        });
    }

    public void testRemoveStaleListener_AfterDispose() {
        this.list.dispose();
        this.list.removeStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
            }
        });
    }

    public void testAddDisposeListener_AfterDispose() {
        this.list.dispose();
        this.list.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
            }
        });
    }

    public void testRemoveDisposeListener_AfterDispose() {
        this.list.dispose();
        this.list.removeDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
            }
        });
    }

    public void testHasListeners_AfterDispose() {
        this.list.dispose();
        this.list.hasListeners();
    }

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.tests.databinding.observable.list.AbstractObservableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.tests.databinding.observable.list.AbstractObservableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(ObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class AbstractObservableListStub
    extends AbstractObservableList {
        Object elementType;
        List wrappedList;

        public AbstractObservableListStub() {
            this.wrappedList = new ArrayList();
        }

        public AbstractObservableListStub(Realm realm, List list) {
            super(realm);
            this.wrappedList = list;
        }

        protected int doGetSize() {
            return this.wrappedList.size();
        }

        public Object get(int index) {
            ObservableTracker.getterCalled((IObservable)this);
            return this.wrappedList.get(index);
        }

        public Object getElementType() {
            return this.elementType;
        }

        protected void fireChange() {
            super.fireChange();
        }

        protected void fireStale() {
            super.fireStale();
        }

        protected void fireListChange(ListDiff diff) {
            super.fireListChange(diff);
        }

        protected synchronized boolean hasListeners() {
            return super.hasListeners();
        }
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int itemCount) {
            String[] items = new String[itemCount];
            int i = 0;
            while (i < itemCount) {
                items[i] = String.valueOf(i);
                ++i;
            }
            AbstractObservableListStub observable = new AbstractObservableListStub(realm, Arrays.asList(items));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            observable.elementType = clazz;
            return observable;
        }

        public Object getElementType(IObservableCollection collection) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public void change(IObservable observable) {
            ((AbstractObservableListStub)observable).fireChange();
        }
    }

    static class MutableObservableListStub
    extends AbstractObservableListStub {
        MutableObservableListStub() {
        }

        public void add(int index, Object element) {
            this.checkRealm();
            this.wrappedList.add(index, element);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, (Object)element)));
        }

        public Object remove(int index) {
            this.checkRealm();
            Object element = this.wrappedList.remove(index);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, element)));
            return element;
        }
    }
}

