/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;

public class ListDiffVisitorTest
extends TestCase {
    ListDiffVisitorStub visitor;

    protected void setUp() throws Exception {
        super.setUp();
        this.visitor = new ListDiffVisitorStub();
    }

    public void testHandleMove_DelegatesByDefault() {
        this.visitor.handleMove(0, 1, "element");
        ListDiffVisitorTest.assertEquals((String)"Default ListDiffVisitor.handleMove must delegate to handleRemove and handleAdd", (String)"remove(0,element), add(1,element)", (String)this.visitor.log);
    }

    public void testHandleReplace_DelegatesByDefault() {
        this.visitor.handleReplace(2, "oldElement", "newElement");
        ListDiffVisitorTest.assertEquals((String)"Default ListDiffVisitor.handleReplace must delegate to handleRemove and handleAdd", (String)"remove(2,oldElement), add(2,newElement)", (String)this.visitor.log);
    }

    static class ListDiffVisitorStub
    extends ListDiffVisitor {
        String log = "";

        ListDiffVisitorStub() {
        }

        private void log(String message) {
            if (this.log.length() > 0) {
                this.log = String.valueOf(this.log) + ", ";
            }
            this.log = String.valueOf(this.log) + message;
        }

        public void handleAdd(int index, Object element) {
            this.log("add(" + index + "," + element + ")");
        }

        public void handleRemove(int index, Object element) {
            this.log("remove(" + index + "," + element + ")");
        }
    }
}

