/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.conformance.MutableObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;

public class WritableListTest
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    public void testSetRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                WritableList list = new WritableList();
                list.add((Object)"");
                list.set(0, (Object)"");
            }
        });
    }

    public void testAddRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                WritableList list = new WritableList();
                list.add((Object)"");
            }
        });
    }

    public void testAddByIndexRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                WritableList list = new WritableList();
                list.add(0, (Object)"");
            }
        });
    }

    public void testAddAllRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                WritableList list = new WritableList();
                list.addAll((Collection)Collections.EMPTY_LIST);
            }
        });
    }

    public void testAddAllByIndexRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                WritableList list = new WritableList();
                list.addAll(0, (Collection)Collections.EMPTY_LIST);
            }
        });
    }

    public void testRemoveRealmChecks() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        final WritableList list = new WritableList();
        list.add((Object)"");
        list.add((Object)"");
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                list.remove((Object)"");
            }
        });
        RealmTester.setDefault(null);
    }

    public void testRemoveByIndexRealmChecks() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        final WritableList list = new WritableList();
        list.add((Object)"");
        list.add((Object)"");
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                list.remove(list.size() - 1);
            }
        });
        RealmTester.setDefault(null);
    }

    public void testRemoveAllRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                WritableList list = new WritableList();
                list.removeAll((Collection)Collections.EMPTY_LIST);
            }
        });
    }

    public void testRetainAllRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                WritableList list = new WritableList();
                list.retainAll((Collection)Collections.EMPTY_LIST);
            }
        });
    }

    public void testClearRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                WritableList list = new WritableList();
                list.clear();
            }
        });
    }

    public void testNullElementType() throws Exception {
        RealmTester.setDefault((Realm)SWTObservables.getRealm((Display)Display.getDefault()));
        WritableList writableList = new WritableList();
        WritableListTest.assertNull((Object)writableList.getElementType());
        writableList = new WritableList(Realm.getDefault());
        WritableListTest.assertNull((Object)writableList.getElementType());
    }

    public void testWithElementType() throws Exception {
        RealmTester.setDefault((Realm)SWTObservables.getRealm((Display)Display.getDefault()));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> elementType = clazz;
        WritableList list = WritableList.withElementType((Object)elementType);
        WritableListTest.assertNotNull((Object)list);
        WritableListTest.assertEquals((Object)Realm.getDefault(), (Object)list.getRealm());
        WritableListTest.assertEquals(elementType, (Object)list.getElementType());
    }

    public void testListConstructorsDoNotCopy_1() {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList("a", "b", "c"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableList wlist = new WritableList(list, (Object)clazz);
        wlist.remove(1);
        WritableListTest.assertEquals((int)2, (int)list.size());
        list.add("d");
        WritableListTest.assertEquals((int)3, (int)wlist.size());
    }

    public void testListConstructorsDoNotCopy_2() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList("a", "b", "c"));
        CurrentRealm currentRealm = new CurrentRealm(true);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableList wlist = new WritableList((Realm)currentRealm, list, (Object)clazz);
        wlist.remove(1);
        WritableListTest.assertEquals((int)2, (int)list.size());
        list.add("d");
        WritableListTest.assertEquals((int)3, (int)wlist.size());
    }

    public void testCollectionConstructorsCopy_1() {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList("a", "b", "c"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableList wlist = new WritableList(list, (Object)clazz);
        wlist.remove(1);
        WritableListTest.assertEquals((int)3, (int)list.size());
        list.add("d");
        WritableListTest.assertEquals((int)2, (int)wlist.size());
    }

    public void testCollectionConstructorsCopy_2() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList("a", "b", "c"));
        CurrentRealm currentRealm = new CurrentRealm(true);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WritableList wlist = new WritableList((Realm)currentRealm, list, (Object)clazz);
        wlist.remove(1);
        WritableListTest.assertEquals((int)3, (int)list.size());
        list.add("d");
        WritableListTest.assertEquals((int)2, (int)wlist.size());
    }

    public static Test suite() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.tests.databinding.observable.list.WritableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.tests.databinding.observable.list.WritableListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(MutableObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public Object createElement(IObservableCollection collection) {
            return String.valueOf(collection.size() + 1);
        }

        public Object getElementType(IObservableCollection collection) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public IObservableCollection createObservableCollection(Realm realm, int itemCount) {
            ArrayList arrayList = new ArrayList();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            WritableList observable = new WritableList(realm, arrayList, (Object)clazz);
            int i = 0;
            while (i < itemCount) {
                observable.add((Object)String.valueOf(i));
                ++i;
            }
            return observable;
        }

        public void change(IObservable observable) {
            ((WritableList)observable).add((Object)"");
        }
    }
}

