/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;

public class AbstractObservableMapTest
extends TestCase {
    private AbstractObservableMapStub map;

    protected void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        this.map = new AbstractObservableMapStub();
    }

    protected void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    public void testIsStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                AbstractObservableMapTest.this.map.isStale();
            }
        });
    }

    public void testSetStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                AbstractObservableMapTest.this.map.setStale(true);
            }
        });
    }

    public void testFireStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                AbstractObservableMapTest.this.map.fireStale();
            }
        });
    }

    public void testFireChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                AbstractObservableMapTest.this.map.fireChange();
            }
        });
    }

    public void testFireMapChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                AbstractObservableMapTest.this.map.fireMapChange(null);
            }
        });
    }

    public void testAddListChangeListener_AfterDispose() {
        this.map.dispose();
        this.map.addMapChangeListener(new IMapChangeListener(){

            public void handleMapChange(MapChangeEvent event) {
            }
        });
    }

    public void testRemoveListChangeListener_AfterDispose() {
        this.map.dispose();
        this.map.removeMapChangeListener(new IMapChangeListener(){

            public void handleMapChange(MapChangeEvent event) {
            }
        });
    }

    public void testAddChangeListener_AfterDispose() {
        this.map.dispose();
        this.map.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
    }

    public void testRemoveChangeListener_AfterDispose() {
        this.map.dispose();
        this.map.removeChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        });
    }

    public void testAddStaleListener_AfterDispose() {
        this.map.dispose();
        this.map.addStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
            }
        });
    }

    public void testRemoveStaleListener_AfterDispose() {
        this.map.dispose();
        this.map.removeStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
            }
        });
    }

    public void testAddDisposeListener_AfterDispose() {
        this.map.dispose();
        this.map.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
            }
        });
    }

    public void testRemoveDisposeListener_AfterDispose() {
        this.map.dispose();
        this.map.removeDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
            }
        });
    }

    public void testHasListeners_AfterDispose() {
        this.map.dispose();
        this.map.hasListeners();
    }

    static class AbstractObservableMapStub
    extends AbstractObservableMap {
        AbstractObservableMapStub() {
        }

        public Set entrySet() {
            return null;
        }

        protected void fireChange() {
            super.fireChange();
        }

        protected void fireMapChange(MapDiff diff) {
            super.fireMapChange(diff);
        }

        protected void fireStale() {
            super.fireStale();
        }

        protected synchronized boolean hasListeners() {
            return super.hasListeners();
        }
    }
}

