/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.lang.reflect.Method;
import java.util.Collections;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.map.CompositeMap;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimpleCart;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class CompositeMapTest
extends AbstractDefaultRealmTestCase {
    private WritableSet persons;
    private CompositeMap composedMap;
    private IObservableMap first;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    boolean hasListeners(AbstractObservable o) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.databinding.observable.AbstractObservable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method method = clazz.getSuperclass().getDeclaredMethod("hasListeners", new Class[0]);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)o, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.persons = new WritableSet();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.examples.databinding.model.SimplePerson");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.first = BeansObservables.observeMap((IObservableSet)this.persons, (Class)clazz, (String)"cart");
        this.composedMap = new CompositeMap(this.first, new IObservableFactory(){

            public IObservable createObservable(Object target) {
                IObservableSet iObservableSet = (IObservableSet)target;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.jface.examples.databinding.model.SimpleCart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return BeansObservables.observeMap((IObservableSet)iObservableSet, (Class)clazz, (String)"numItems");
            }
        });
    }

    public void testAddToFirstMap() {
        MapChangeEventTracker tracker = new MapChangeEventTracker();
        this.composedMap.addMapChangeListener((IMapChangeListener)tracker);
        CompositeMapTest.assertEquals((int)0, (int)tracker.count);
        SimplePerson newPerson = new SimplePerson("p1", "a1", "c1", "s1");
        newPerson.getCart().setNumItems(42);
        this.persons.add((Object)newPerson);
        CompositeMapTest.assertEquals((int)1, (int)tracker.count);
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getRemovedKeys().size());
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getChangedKeys().size());
        CompositeMapTest.assertEquals(Collections.singleton(newPerson), (Object)tracker.event.diff.getAddedKeys());
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)tracker.event.diff.getNewValue((Object)newPerson));
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)this.composedMap.get((Object)newPerson));
    }

    public void testAddSharedToFirstMap() {
        SimplePerson person1 = new SimplePerson("p1", "a1", "c1", "s1");
        person1.getCart().setNumItems(42);
        this.persons.add((Object)person1);
        MapChangeEventTracker tracker = new MapChangeEventTracker();
        this.composedMap.addMapChangeListener((IMapChangeListener)tracker);
        CompositeMapTest.assertEquals((int)0, (int)tracker.count);
        SimplePerson person2 = new SimplePerson("p1", "a1", "c1", "s1");
        person2.setCart(person1.getCart());
        this.persons.add((Object)person2);
        CompositeMapTest.assertEquals((int)1, (int)tracker.count);
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getRemovedKeys().size());
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getChangedKeys().size());
        CompositeMapTest.assertEquals(Collections.singleton(person2), (Object)tracker.event.diff.getAddedKeys());
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)tracker.event.diff.getNewValue((Object)person2));
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)this.composedMap.get((Object)person2));
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)this.composedMap.get((Object)person1));
    }

    public void testRemoveFromFirstMap() {
        MapChangeEventTracker tracker = new MapChangeEventTracker();
        SimplePerson newPerson = new SimplePerson("p1", "a1", "c1", "s1");
        newPerson.getCart().setNumItems(42);
        this.persons.add((Object)newPerson);
        CompositeMapTest.assertTrue((String)"newPerson should be added", (boolean)this.composedMap.containsKey((Object)newPerson));
        this.composedMap.addMapChangeListener((IMapChangeListener)tracker);
        CompositeMapTest.assertEquals((int)0, (int)tracker.count);
        this.persons.remove((Object)newPerson);
        CompositeMapTest.assertEquals((int)1, (int)tracker.count);
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getAddedKeys().size());
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getChangedKeys().size());
        CompositeMapTest.assertEquals(Collections.singleton(newPerson), (Object)tracker.event.diff.getRemovedKeys());
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)tracker.event.diff.getOldValue((Object)newPerson));
        CompositeMapTest.assertFalse((String)"newPerson should be removed", (boolean)this.composedMap.containsKey((Object)newPerson));
    }

    public void testRemoveSharedFromFirstMap() {
        SimplePerson person1 = new SimplePerson("p1", "a1", "c1", "s1");
        person1.getCart().setNumItems(42);
        this.persons.add((Object)person1);
        SimplePerson person2 = new SimplePerson("p1", "a1", "c1", "s1");
        person2.setCart(person1.getCart());
        this.persons.add((Object)person2);
        CompositeMapTest.assertTrue((String)"person2 should be added", (boolean)this.composedMap.containsKey((Object)person2));
        MapChangeEventTracker tracker = new MapChangeEventTracker();
        this.composedMap.addMapChangeListener((IMapChangeListener)tracker);
        CompositeMapTest.assertEquals((int)0, (int)tracker.count);
        this.persons.remove((Object)person2);
        CompositeMapTest.assertEquals((int)1, (int)tracker.count);
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getAddedKeys().size());
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getChangedKeys().size());
        CompositeMapTest.assertEquals(Collections.singleton(person2), (Object)tracker.event.diff.getRemovedKeys());
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)tracker.event.diff.getOldValue((Object)person2));
        CompositeMapTest.assertFalse((String)"person2 should be removed", (boolean)this.composedMap.containsKey((Object)person2));
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)this.composedMap.get((Object)person1));
    }

    public void testChangeInFirstMap() {
        SimplePerson person1 = new SimplePerson("p1", "a1", "c1", "s1");
        person1.getCart().setNumItems(42);
        this.persons.add((Object)person1);
        MapChangeEventTracker tracker = new MapChangeEventTracker();
        this.composedMap.addMapChangeListener((IMapChangeListener)tracker);
        CompositeMapTest.assertEquals((int)0, (int)tracker.count);
        person1.setCart(new SimpleCart());
        CompositeMapTest.assertEquals((int)1, (int)tracker.count);
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getAddedKeys().size());
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getRemovedKeys().size());
        CompositeMapTest.assertEquals(Collections.singleton(person1), (Object)tracker.event.diff.getChangedKeys());
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)tracker.event.diff.getOldValue((Object)person1));
        CompositeMapTest.assertEquals((Object)new Integer(0), (Object)tracker.event.diff.getNewValue((Object)person1));
        CompositeMapTest.assertEquals((Object)new Integer(0), (Object)this.composedMap.get((Object)person1));
    }

    public void testChangeInFirstMapToShared() {
        SimplePerson person0 = new SimplePerson("p0", "a0", "c0", "s0");
        person0.getCart().setNumItems(13);
        this.persons.add((Object)person0);
        SimplePerson person1 = new SimplePerson("p1", "a1", "c1", "s1");
        person1.getCart().setNumItems(42);
        this.persons.add((Object)person1);
        MapChangeEventTracker tracker = new MapChangeEventTracker();
        this.composedMap.addMapChangeListener((IMapChangeListener)tracker);
        CompositeMapTest.assertEquals((int)0, (int)tracker.count);
        person1.setCart(person0.getCart());
        CompositeMapTest.assertEquals((int)1, (int)tracker.count);
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getAddedKeys().size());
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getRemovedKeys().size());
        CompositeMapTest.assertEquals(Collections.singleton(person1), (Object)tracker.event.diff.getChangedKeys());
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)tracker.event.diff.getOldValue((Object)person1));
        CompositeMapTest.assertEquals((Object)new Integer(13), (Object)tracker.event.diff.getNewValue((Object)person1));
        CompositeMapTest.assertEquals((Object)new Integer(13), (Object)this.composedMap.get((Object)person1));
    }

    public void testChangeInFirstMapFromShared() {
        SimplePerson person0 = new SimplePerson("p0", "a0", "c0", "s0");
        person0.getCart().setNumItems(13);
        this.persons.add((Object)person0);
        SimplePerson person1 = new SimplePerson("p1", "a1", "c1", "s1");
        person1.setCart(person0.getCart());
        this.persons.add((Object)person1);
        MapChangeEventTracker tracker = new MapChangeEventTracker();
        this.composedMap.addMapChangeListener((IMapChangeListener)tracker);
        CompositeMapTest.assertEquals((int)0, (int)tracker.count);
        person1.setCart(new SimpleCart());
        CompositeMapTest.assertEquals((int)1, (int)tracker.count);
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getAddedKeys().size());
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getRemovedKeys().size());
        CompositeMapTest.assertEquals(Collections.singleton(person1), (Object)tracker.event.diff.getChangedKeys());
        CompositeMapTest.assertEquals((Object)new Integer(13), (Object)tracker.event.diff.getOldValue((Object)person1));
        CompositeMapTest.assertEquals((Object)new Integer(0), (Object)tracker.event.diff.getNewValue((Object)person1));
        CompositeMapTest.assertEquals((Object)new Integer(0), (Object)this.composedMap.get((Object)person1));
    }

    public void testChangeInSecondMap() {
        SimplePerson person0 = new SimplePerson("p0", "a0", "c0", "s0");
        person0.getCart().setNumItems(13);
        this.persons.add((Object)person0);
        MapChangeEventTracker tracker = new MapChangeEventTracker();
        this.composedMap.addMapChangeListener((IMapChangeListener)tracker);
        CompositeMapTest.assertEquals((int)0, (int)tracker.count);
        person0.getCart().setNumItems(42);
        CompositeMapTest.assertEquals((int)1, (int)tracker.count);
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getAddedKeys().size());
        CompositeMapTest.assertEquals((int)0, (int)tracker.event.diff.getRemovedKeys().size());
        CompositeMapTest.assertEquals(Collections.singleton(person0), (Object)tracker.event.diff.getChangedKeys());
        CompositeMapTest.assertEquals((Object)new Integer(13), (Object)tracker.event.diff.getOldValue((Object)person0));
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)tracker.event.diff.getNewValue((Object)person0));
        CompositeMapTest.assertEquals((Object)new Integer(42), (Object)this.composedMap.get((Object)person0));
    }

    public void testDispose() {
        SimplePerson person0 = new SimplePerson("p0", "a0", "c0", "s0");
        person0.getCart().setNumItems(13);
        this.persons.add((Object)person0);
        CompositeMapTest.assertTrue((boolean)this.hasListeners((AbstractObservable)this.first));
        this.composedMap.dispose();
        CompositeMapTest.assertFalse((boolean)this.hasListeners((AbstractObservable)this.first));
    }
}

