/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ComputedObservableMapTest
extends AbstractDefaultRealmTestCase {
    private IObservableSet keySet;
    private ComputedObservableMapStub map;
    private String propertyName;
    private Bean bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.keySet = new WritableSet();
        this.map = new ComputedObservableMapStub(this.keySet);
        this.propertyName = "value";
        this.bean = new Bean("a");
    }

    public void testGet_ElementNotInKeySet() {
        ComputedObservableMapTest.assertNull((Object)this.map.get(this.bean));
    }

    public void testGet_ElementInKeySet() {
        this.keySet.add((Object)this.bean);
        ComputedObservableMapTest.assertEquals((Object)"a", (Object)this.map.get(this.bean));
    }

    public void testPut_ElementNotInKeySet() {
        ComputedObservableMapTest.assertNull((Object)this.map.put(this.bean, "b"));
        ComputedObservableMapTest.assertEquals((String)"a", (String)this.bean.getValue());
    }

    public void testPut_ElementInKeySet() {
        this.keySet.add((Object)this.bean);
        ComputedObservableMapTest.assertEquals((Object)"a", (Object)this.map.put(this.bean, "b"));
        ComputedObservableMapTest.assertEquals((Object)"b", (Object)this.map.get(this.bean));
    }

    public void testAddToKeySet_BeforeFirstListenerAdded_DoesNotAddListenerToKey() {
        ComputedObservableMapTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
        this.keySet.add((Object)this.bean);
        ComputedObservableMapTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    public void testAddToKeySet_AfterFirstListenerAdded_AddsListenerToKey() {
        ChangeEventTracker.observe((IObservable)this.map);
        ComputedObservableMapTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
        this.keySet.add((Object)this.bean);
        ComputedObservableMapTest.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
    }

    public void testRemoveFromKeySet_RemovesListenersFromKey() {
        ChangeEventTracker.observe((IObservable)this.map);
        this.keySet.add((Object)this.bean);
        ComputedObservableMapTest.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
        this.keySet.remove((Object)this.bean);
        ComputedObservableMapTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    public void testRemoveLastListener_DoNotDiscardKeySet() {
        IChangeListener listener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
            }
        };
        this.map.addChangeListener(listener);
        this.map.removeChangeListener(listener);
        this.keySet.add((Object)this.bean);
        ComputedObservableMapTest.assertEquals((int)1, (int)this.map.size());
    }

    public void testDispose_RemoveListenersFromKeySetElements() {
        ChangeEventTracker.observe((IObservable)this.map);
        this.keySet.add((Object)this.bean);
        ComputedObservableMapTest.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
        this.map.dispose();
        ComputedObservableMapTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    public void testDisposeKeySet_DisposesMap() {
        ComputedObservableMapTest.assertFalse((boolean)this.map.isDisposed());
        this.keySet.dispose();
        ComputedObservableMapTest.assertTrue((boolean)this.map.isDisposed());
    }

    public void testDisposeKeySet_RemoveListenersFromKeySetElements() {
        ChangeEventTracker.observe((IObservable)this.map);
        this.keySet.add((Object)this.bean);
        ComputedObservableMapTest.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
        this.keySet.dispose();
        ComputedObservableMapTest.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    static class ComputedObservableMapStub
    extends ComputedObservableMap {
        private PropertyChangeListener listener = new PropertyChangeListener(this){
            final /* synthetic */ ComputedObservableMapStub this$1;
            {
                this.this$1 = computedObservableMapStub;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                ComputedObservableMapStub.access$0(this.this$1, evt.getSource(), evt.getOldValue(), evt.getNewValue());
            }
        };

        ComputedObservableMapStub(IObservableSet keySet) {
            super(keySet);
        }

        protected Object doGet(Object key) {
            return ((Bean)key).getValue();
        }

        protected Object doPut(Object key, Object value) {
            Object result = this.doGet(key);
            ((Bean)key).setValue((String)value);
            return result;
        }

        protected void hookListener(Object addedKey) {
            ((Bean)addedKey).addPropertyChangeListener(this.listener);
        }

        protected void unhookListener(Object removedKey) {
            ((Bean)removedKey).removePropertyChangeListener(this.listener);
        }

        static /* synthetic */ void access$0(ComputedObservableMapStub computedObservableMapStub, Object object, Object object2, Object object3) {
            computedObservableMapStub.fireSingleChange(object, object2, object3);
        }
    }
}

