/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.set;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.ComputedSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.SetChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ComputedSetTest
extends AbstractDefaultRealmTestCase {
    ComputedSetStub set;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        this.set = new ComputedSetStub();
        this.set.size();
    }

    public void testDependency_Staleness() {
        ComputedSetTest.assertFalse((boolean)this.set.isStale());
        this.set.dependency.fireStale();
        ComputedSetTest.assertTrue((boolean)this.set.isStale());
    }

    public void testDependency_FiresSetChange() {
        ComputedSetTest.assertEquals((Object)this.set.nextComputation, (Object)((Object)this.set));
        Object element = new Object();
        this.set.nextComputation.add(element);
        this.set.dependency.fireChange();
        ComputedSetTest.assertEquals(Collections.singleton(element), (Object)((Object)this.set));
    }

    public void testDependency_NoStaleEventIfAlreadyDirty() {
        this.set.dependency.fireChange();
        this.set.addStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
                ComputedSetTest.fail((String)"Should not fire stale when set is already dirty");
            }
        });
        this.set.dependency.fireStale();
    }

    public void testDependency_SetChangeEventFiresOnlyWhenNotDirty() {
        SetChangeEventTracker tracker = SetChangeEventTracker.observe((IObservableSet)this.set);
        this.set.dependency.fireChange();
        ComputedSetTest.assertEquals((String)"ComputedSet should fire set change event when its dependency changes", (int)1, (int)tracker.count);
        this.set.dependency.fireChange();
        ComputedSetTest.assertEquals((String)"ComputedSet should not fire set change events when dirty", (int)1, (int)tracker.count);
        this.set.size();
        this.set.dependency.fireChange();
        ComputedSetTest.assertEquals((String)"ComputedSet should fire set change event when its dependency changes", (int)2, (int)tracker.count);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.databinding.observable.set.ComputedSetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.tests.databinding.observable.set.ComputedSetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTestSuite((Class)clazz2);
        suite.addTest(ObservableCollectionContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class ComputedSetStub
    extends ComputedSet {
        Set nextComputation = new HashSet();
        ObservableStub dependency;

        ComputedSetStub() {
            this(Realm.getDefault());
        }

        ComputedSetStub(Realm realm) {
            super(realm);
            this.dependency = new ObservableStub(realm);
        }

        protected Set calculate() {
            ObservableTracker.getterCalled((IObservable)this.dependency);
            return new HashSet(this.nextComputation);
        }
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            ComputedSetStub set = new ComputedSetStub(realm);
            int i = 0;
            while (i < elementCount) {
                set.nextComputation.add(this.createElement((IObservableCollection)set));
                ++i;
            }
            set.size();
            return set;
        }

        public void change(IObservable observable) {
            ComputedSetStub set = (ComputedSetStub)observable;
            set.nextComputation.add(new Object());
            set.dependency.fireChange();
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public void setStale(IObservable observable, boolean stale) {
            if (stale) {
                ((ComputedSetStub)observable).dependency.fireStale();
            } else {
                ComputedSetStub computedSet = (ComputedSetStub)observable;
                computedSet.dependency.stale = false;
                computedSet.dependency.fireChange();
            }
        }
    }

    static class ObservableStub
    extends AbstractObservable {
        boolean stale;

        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return this.stale;
        }

        protected void fireStale() {
            this.stale = true;
            super.fireStale();
        }

        protected void fireChange() {
            super.fireChange();
        }
    }
}

