/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.tests.databinding.observable.value.AbstractObservableValueTest;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;

public class AbstractObservableValueTest
extends TestCase {
    public void testSetValueRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                ObservableValueStub observable = new ObservableValueStub();
                try {
                    observable.setValue(null);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        });
    }

    public void testSetValueInvokesDoSetValue() throws Exception {
        CurrentRealm realm = new CurrentRealm(true);
        class ValueStub
        extends ObservableValueStub {
            int doSetValue;
            final /* synthetic */ AbstractObservableValueTest this$0;

            ValueStub(AbstractObservableValueTest abstractObservableValueTest, Realm realm) {
                super(realm);
                this.this$0 = abstractObservableValueTest;
            }

            protected void doSetValue(Object value) {
                ++this.doSetValue;
            }
        }
        ValueStub stub = new ValueStub(this, (Realm)realm);
        AbstractObservableValueTest.assertEquals((int)0, (int)stub.doSetValue);
        stub.setValue(new Object());
        AbstractObservableValueTest.assertEquals((String)"doSetValue should have been invoked", (int)1, (int)stub.doSetValue);
    }

    public void testFireValueChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent((Runnable)new Runnable(){

            public void run() {
                ObservableValueStub observable = new ObservableValueStub();
                observable.fireValueChange(null);
            }
        });
    }

    private static class ObservableValueStub
    extends AbstractObservableValue {
        ObservableValueStub() {
            super(Realm.getDefault());
        }

        private ObservableValueStub(Realm realm) {
            super(realm);
        }

        protected Object doGetValue() {
            return null;
        }

        public Object getValueType() {
            return null;
        }

        protected void fireValueChange(ValueDiff diff) {
            super.fireValueChange(diff);
        }
    }
}

